%--------------------------------------------------------------------------
% File     : TOP003-2 : TPTP v9.2.0. Released v1.0.0.
% Domain   : Topology
% Problem  : Topology generated by a basis forms a topological space, part 3
% Version  : [WM89] axioms : Incomplete > Reduced & Augmented > Incomplete.
% English  :

% Refs     : [WM89]  Wick & McCune (1989), Automated Reasoning about Elemen
% Source   : [WM89]
% Names    : Lemma 1c [WM89]

% Status   : Satisfiable
% Rating   : 0.00 v5.4.0, 0.11 v5.3.0, 0.14 v5.0.0, 0.12 v4.1.0, 0.00 v4.0.0, 0.12 v3.5.0, 0.29 v3.4.0, 0.17 v3.2.0, 0.40 v3.1.0, 0.43 v2.7.0, 0.40 v2.6.0, 0.25 v2.5.0, 0.33 v2.4.0, 0.33 v2.3.0, 0.67 v2.2.1, 0.75 v2.2.0, 0.67 v2.1.0, 0.00 v2.0.0
% Syntax   : Number of clauses     :   11 (   3 unt;   1 nHn;   9 RR)
%            Number of literals    :   22 (   0 equ;  11 neg)
%            Maximal clause size   :    3 (   2 avg)
%            Maximal term depth    :    2 (   1 avg)
%            Number of predicates  :    5 (   5 usr;   0 prp; 2-2 aty)
%            Number of functors    :    6 (   6 usr;   2 con; 0-2 aty)
%            Number of variables   :   20 (   0 sgn)
% SPC      : CNF_SAT_RFO_NEQ

% Comments : The axioms in this version are known to be incomplete. To
%            make them complete it is be necessary to add appropriate set
%            theory axioms.
%--------------------------------------------------------------------------
%----Include Point-set topology axioms
% include('Axioms/TOP001-0.ax').
%--------------------------------------------------------------------------
%----Sigma (union of members).
cnf(union_of_members_1,axiom,
    ( ~ element_of_set(U,union_of_members(Vf))
    | element_of_set(U,f1(Vf,U)) ) ).

cnf(union_of_members_2,axiom,
    ( ~ element_of_set(U,union_of_members(Vf))
    | element_of_collection(f1(Vf,U),Vf) ) ).

%----Basis for a topology
cnf(basis_for_topology_28,axiom,
    ( ~ basis(X,Vf)
    | equal_sets(union_of_members(Vf),X) ) ).

%----Topology generated by a basis
cnf(topology_generated_40,axiom,
    ( element_of_collection(U,top_of_basis(Vf))
    | element_of_set(f11(Vf,U),U) ) ).

cnf(set_theory_7,axiom,
    ( ~ element_of_collection(X,Y)
    | subset_sets(X,union_of_members(Y)) ) ).

cnf(set_theory_8,axiom,
    ( ~ subset_sets(X,Y)
    | ~ element_of_set(U,X)
    | element_of_set(U,Y) ) ).

cnf(set_theory_9,axiom,
    subset_sets(X,X) ).

cnf(set_theory_10,axiom,
    ( ~ equal_sets(X,Y)
    | ~ subset_sets(Z,X)
    | subset_sets(Z,Y) ) ).

cnf(set_theory_11,axiom,
    ( ~ equal_sets(X,Y)
    | ~ subset_sets(X,Z)
    | subset_sets(Y,Z) ) ).

cnf(lemma_1c_1,negated_conjecture,
    basis(cx,f) ).

cnf(lemma_1c_2,negated_conjecture,
    ~ element_of_collection(cx,top_of_basis(f)) ).

%--------------------------------------------------------------------------
