%------------------------------------------------------------------------------
% File     : SYO891_16 : TPTP v9.2.0. Released v8.2.0.
% Domain   : Syntactic
% Problem  : Fitting and Mendelsohn problem
% Version  : Especial.
% English  :

% Refs     : [FM98]  Fitting & Mendelsohn (1998), First-Order Modal Logic
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
% Source   : [QMLTP]
% Names    : SYM056+1 [QMLTP]

% Status   : Theorem
% Rating   : 0.00 v8.2.0
% Syntax   : Number of formulae    :   15 (   2 unt;   6 typ;   0 def)
%            Number of atoms       :   35 (   0 equ)
%            Maximal formula atoms :   10 (   3 avg)
%            Number of connectives :   26 (   0   ~;   0   |;   9   &)
%                                         (   0 <=>;  17  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   6 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :    9 (   4   >;   5   *;   0   +;   0  <<)
%            Number of predicates  :    4 (   4 usr;   0 prp; 2-3 aty)
%            Number of functors    :    1 (   1 usr;   1 con; 0-0 aty)
%            Number of variables   :   24 (;  18   !;   6   ?;  24   :)
% SPC      : TF0_THM_NEQ_NAR

% Comments : Generated by embedproblem, version 1.7.14, rigid constant, 
%            modal_system_S4, TFF embedding.
%------------------------------------------------------------------------------
tff('$ki_world_type',type,
    '$ki_world': $tType ).

tff('$ki_local_world_decl',type,
    '$ki_local_world': '$ki_world' ).

tff('$ki_accessible_decl',type,
    '$ki_accessible': ( '$ki_world' * '$ki_world' ) > $o ).

tff(mrel_reflexive,axiom,
    ! [W: '$ki_world'] : '$ki_accessible'(W,W) ).

tff(mrel_transitive,axiom,
    ! [W: '$ki_world',V: '$ki_world',U: '$ki_world'] :
      ( ( '$ki_accessible'(W,V)
        & '$ki_accessible'(V,U) )
     => '$ki_accessible'(W,U) ) ).

tff(qmltpeq_decl,type,
    qmltpeq: ( '$ki_world' * $i * $i ) > $o ).

tff(p_decl,type,
    p: ( '$ki_world' * $i ) > $o ).

tff('$ki_exists_in_world_$i_decl',type,
    '$ki_exists_in_world_$i': ( '$ki_world' * $i ) > $o ).

tff('$ki_exists_in_world_$i_cumul',axiom,
    ! [W: '$ki_world',V: '$ki_world',X: $i] :
      ( ( '$ki_exists_in_world_$i'(W,X)
        & '$ki_accessible'(W,V) )
     => '$ki_exists_in_world_$i'(V,X) ) ).

tff('$ki_exists_in_world_$i_nonempty',axiom,
    ! [W: '$ki_world'] :
    ? [X: $i] : '$ki_exists_in_world_$i'(W,X) ).

tff(reflexivity,axiom,
    ! [X: $i] :
      ( '$ki_exists_in_world_$i'('$ki_local_world',X)
     => qmltpeq('$ki_local_world',X,X) ) ).

tff(symmetry,axiom,
    ! [X: $i] :
      ( '$ki_exists_in_world_$i'('$ki_local_world',X)
     => ! [Y: $i] :
          ( '$ki_exists_in_world_$i'('$ki_local_world',Y)
         => ( qmltpeq('$ki_local_world',X,Y)
           => qmltpeq('$ki_local_world',Y,X) ) ) ) ).

tff(transitivity,axiom,
    ! [X: $i] :
      ( '$ki_exists_in_world_$i'('$ki_local_world',X)
     => ! [Y: $i] :
          ( '$ki_exists_in_world_$i'('$ki_local_world',Y)
         => ! [Z: $i] :
              ( '$ki_exists_in_world_$i'('$ki_local_world',Z)
             => ( ( qmltpeq('$ki_local_world',X,Y)
                  & qmltpeq('$ki_local_world',Y,Z) )
               => qmltpeq('$ki_local_world',X,Z) ) ) ) ) ).

tff(p_substitution_1,axiom,
    ! [A: $i] :
      ( '$ki_exists_in_world_$i'('$ki_local_world',A)
     => ! [B: $i] :
          ( '$ki_exists_in_world_$i'('$ki_local_world',B)
         => ( ( qmltpeq('$ki_local_world',A,B)
              & p('$ki_local_world',A) )
           => p('$ki_local_world',B) ) ) ) ).

tff(verify,conjecture,
    ( ! [X: $i] :
        ( '$ki_exists_in_world_$i'('$ki_local_world',X)
       => ! [W: '$ki_world'] :
            ( '$ki_accessible'('$ki_local_world',W)
           => ? [Y: $i] :
                ( '$ki_exists_in_world_$i'(W,Y)
                & qmltpeq(W,X,Y) ) ) )
   => ( ? [X: $i] :
          ( '$ki_exists_in_world_$i'('$ki_local_world',X)
          & ? [W: '$ki_world'] :
              ( '$ki_accessible'('$ki_local_world',W)
              & p(W,X) ) )
     => ? [W: '$ki_world'] :
          ( '$ki_accessible'('$ki_local_world',W)
          & ? [X: $i] :
              ( '$ki_exists_in_world_$i'(W,X)
              & p(W,X) ) ) ) ) ).

%------------------------------------------------------------------------------
