%--------------------------------------------------------------------------
% File     : SYN321-1 : TPTP v9.2.0. Released v1.2.0.
% Domain   : Syntactic
% Problem  : Church problem 46.3 (2)
% Version  : Especial.
% English  :

% Refs     : [Chu56] Church (1956), Introduction to Mathematical Logic I
%          : [FL+93] Fermuller et al. (1993), Resolution Methods for the De
%          : [Tam94] Tammet (1994), Email to Geoff Sutcliffe.
% Source   : [Tam94]
% Names    : Ch3N2 [Tam94]

% Status   : Unsatisfiable
% Rating   : 0.00 v5.5.0, 0.20 v5.4.0, 0.00 v2.1.0, 0.00 v2.0.0
% Syntax   : Number of clauses     :    4 (   0 unt;   1 nHn;   2 RR)
%            Number of literals    :    8 (   0 equ;   4 neg)
%            Maximal clause size   :    2 (   2 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  :    2 (   2 usr;   0 prp; 2-2 aty)
%            Number of functors    :    3 (   3 usr;   3 con; 0-0 aty)
%            Number of variables   :    4 (   3 sgn)
% SPC      : CNF_UNS_EPR_NEQ_NHN

% Comments : All the problems here can be decided by using a certain
%            completeness-preserving term ordering strategies. See [FL+93].
%          : The conversion from the full 1st order form in [Chu56]
%            to clause form was done by hand by Tanel Tammet.
%--------------------------------------------------------------------------
cnf(clause1,negated_conjecture,
    ( ~ f(a,Z)
    | g(a,U) ) ).

cnf(clause2,negated_conjecture,
    ( ~ g(U,U)
    | f(U,b) ) ).

cnf(clause3,negated_conjecture,
    ( f(a,b)
    | g(a,U) ) ).

cnf(clause4,negated_conjecture,
    ( ~ f(a,b)
    | ~ g(a,d) ) ).

%--------------------------------------------------------------------------
