%------------------------------------------------------------------------------
% File     : SWW999_1 : TPTP v9.2.0. Released v9.1.0.
% Domain   : Software Verification
% Problem  : maxarray-3
% Version  : Especial.
% English  :

% Refs     : [Kot17] Kotelnikov (2017), Email to Geoff Sutcliffe
% Source   : [Kot17]
% Names    : maxarray-3 [Kot17]

% Status   : Theorem
% Rating   : ? v9.1.0
% Syntax   : Number of formulae    :   18 (   1 unt;   9 typ;   0 def)
%            Number of atoms       :   33 (  10 equ)
%            Maximal formula atoms :   15 (   3 avg)
%            Number of connectives :   25 (   1   ~;   6   |;  11   &)
%                                         (   0 <=>;   7  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    8 (   4 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of X terms     :    6 (   0  [];   0 ite;   6 let)
%            Number arithmetic     :   35 (  19 atm;   0 fun;   5 num;  11 var)
%            Number of types       :    3 (   1 usr;   1 ari)
%            Number of type conns  :    5 (   2   >;   3   *;   0   +;   0  <<)
%            Number of predicates  :    6 (   1 usr;   2 prp; 0-2 aty)
%            Number of functors    :   11 (   7 usr;   7 con; 0-3 aty)
%            Number of variables   :   15 (  15   !;   0   ?;  15   :)
% SPC      : TX0_THM_EQU_ARI

% Comments : This file was generated by Voogie.
%------------------------------------------------------------------------------
tff(array_int_int,type,
    array_int_int: $tType ).

tff(select_int_int,type,
    select_int_int: ( array_int_int * $int ) > $int ).

tff(store_int_int,type,
    store_int_int: ( array_int_int * $int * $int ) > array_int_int ).

tff(a,type,
    a: array_int_int ).

tff(bad,type,
    bad: $o ).

tff(m,type,
    m: $int ).

tff(n,type,
    n: $int ).

tff(x,type,
    x: $int ).

tff(y,type,
    y: $int ).

tff(voogie_precondition_1,axiom,
    ! [A: array_int_int,V: $int,I: $int,J: $int] :
      ( ( I = J )
     => ( select_int_int(store_int_int(A,I,V),J) = V ) ) ).

tff(voogie_precondition_2,axiom,
    ! [A: array_int_int,V: $int,I: $int,J: $int] :
      ( ( I != J )
     => ( select_int_int(store_int_int(A,I,V),J) = select_int_int(A,J) ) ) ).

tff(voogie_precondition_3,axiom,
    ! [A: array_int_int,B: array_int_int] :
      ( ! [I: $int] : ( select_int_int(A,I) = select_int_int(B,I) )
     => ( A = B ) ) ).

tff(voogie_precondition_4,axiom,
    $greater(n,0) ).

tff(voogie_precondition_5,axiom,
    ( $lesseq(0,x)
    & $lesseq(x,y)
    & $less(y,n) ) ).

tff(voogie_precondition_6,axiom,
    ( ( m = x )
    | ( m = y ) ) ).

tff(voogie_precondition_7,axiom,
    ! [I: $int] :
      ( ( $lesseq(0,I)
        & $less(I,x) )
     => $lesseq(select_int_int(a,I),select_int_int(a,m)) ) ).

tff(voogie_precondition_8,axiom,
    ! [I: $int] :
      ( ( $less(y,I)
        & $less(I,n) )
     => $lesseq(select_int_int(a,I),select_int_int(a,m)) ) ).

tff(voogie_conjecture,conjecture,
    $let(
      bad: $o,
      bad:= 
        $ite(
          ~ ( ( x != y ) ),
          $true,
          bad ),
      $let(
        [ m: $int,
          y: $int,
          x: $int ],
        [m,y,x]:= 
          $ite(
            $lesseq(select_int_int(a,x),select_int_int(a,y)),
            $let(
              x: $int,
              x:= $sum(x,1),
              $let(
                m: $int,
                m:= y,
                [m,y,x] ) ),
            $let(
              y: $int,
              y:= $difference(y,1),
              $let(
                m: $int,
                m:= x,
                [m,y,x] ) ) ),
        $let(
          bad: $o,
          bad:= 
            $ite(
              ~ ( ( x != y ) ),
              $true,
              bad ),
          $let(
            [ m: $int,
              y: $int,
              x: $int ],
            [m,y,x]:= 
              $ite(
                $lesseq(select_int_int(a,x),select_int_int(a,y)),
                $let(
                  x: $int,
                  x:= $sum(x,1),
                  $let(
                    m: $int,
                    m:= y,
                    [m,y,x] ) ),
                $let(
                  y: $int,
                  y:= $difference(y,1),
                  $let(
                    m: $int,
                    m:= x,
                    [m,y,x] ) ) ),
            $let(
              bad: $o,
              bad:= 
                $ite(
                  ~ ( ( x != y ) ),
                  $true,
                  bad ),
              $let(
                [ m: $int,
                  y: $int,
                  x: $int ],
                [m,y,x]:= 
                  $ite(
                    $lesseq(select_int_int(a,x),select_int_int(a,y)),
                    $let(
                      x: $int,
                      x:= $sum(x,1),
                      $let(
                        m: $int,
                        m:= y,
                        [m,y,x] ) ),
                    $let(
                      y: $int,
                      y:= $difference(y,1),
                      $let(
                        m: $int,
                        m:= x,
                        [m,y,x] ) ) ),
                ( ( bad
                  | ( $lesseq(0,x)
                    & $lesseq(x,y)
                    & $less(y,n) ) )
                & ( bad
                  | ( m = x )
                  | ( m = y ) )
                & ( bad
                  | ! [I: $int] :
                      ( ( $lesseq(0,I)
                        & $less(I,x) )
                     => $lesseq(select_int_int(a,I),select_int_int(a,m)) ) )
                & ( bad
                  | ! [I: $int] :
                      ( ( $less(y,I)
                        & $less(I,n) )
                     => $lesseq(select_int_int(a,I),select_int_int(a,m)) ) ) ) ) ) ) ) ) ) ).

%------------------------------------------------------------------------------
