%------------------------------------------------------------------------------
% File     : SWW993_1 : TPTP v9.2.0. Released v9.1.0.
% Domain   : Software Verification
% Problem  : matrix-transpose-2
% Version  : Especial.
% English  :

% Refs     : [Kot17] Kotelnikov (2017), Email to Geoff Sutcliffe
% Source   : [Kot17]
% Names    : matrix-transpose-2 [Kot17]

% Status   : Theorem
% Rating   : ? v9.1.0
% Syntax   : Number of formulae    :   22 (   1 unt;  12 typ;   0 def)
%            Number of atoms       :   35 (  18 equ)
%            Maximal formula atoms :   12 (   3 avg)
%            Number of connectives :   27 (   2   ~;   4   |;  13   &)
%                                         (   0 <=>;   8  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   6 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of X terms     :    4 (   0  [];   0 ite;   4 let)
%            Number arithmetic     :   36 (  15 atm;   0 fun;   5 num;  16 var)
%            Number of types       :    4 (   2 usr;   1 ari)
%            Number of type conns  :   10 (   4   >;   6   *;   0   +;   0  <<)
%            Number of predicates  :    6 (   1 usr;   2 prp; 0-2 aty)
%            Number of functors    :   12 (   9 usr;   7 con; 0-3 aty)
%            Number of variables   :   26 (  26   !;   0   ?;  26   :)
% SPC      : TX0_THM_EQU_ARI

% Comments : This file was generated by Voogie.
%------------------------------------------------------------------------------
tff(array_int_array_int_int,type,
    array_int_array_int_int: $tType ).

tff(array_int_int,type,
    array_int_int: $tType ).

tff(select_int_array_int_int,type,
    select_int_array_int_int: ( array_int_array_int_int * $int ) > array_int_int ).

tff(store_int_array_int_int,type,
    store_int_array_int_int: ( array_int_array_int_int * $int * array_int_int ) > array_int_array_int_int ).

tff(select_int_int,type,
    select_int_int: ( array_int_int * $int ) > $int ).

tff(store_int_int,type,
    store_int_int: ( array_int_int * $int * $int ) > array_int_int ).

tff(bad,type,
    bad: $o ).

tff(col,type,
    col: $int ).

tff(matrix,type,
    matrix: array_int_array_int_int ).

tff(row,type,
    row: $int ).

tff(size,type,
    size: $int ).

tff(transposed,type,
    transposed: array_int_array_int_int ).

tff(voogie_precondition_1,axiom,
    ! [A: array_int_array_int_int,V: array_int_int,I: $int,J: $int] :
      ( ( I = J )
     => ( select_int_array_int_int(store_int_array_int_int(A,I,V),J) = V ) ) ).

tff(voogie_precondition_2,axiom,
    ! [A: array_int_array_int_int,V: array_int_int,I: $int,J: $int] :
      ( ( I != J )
     => ( select_int_array_int_int(store_int_array_int_int(A,I,V),J) = select_int_array_int_int(A,J) ) ) ).

tff(voogie_precondition_3,axiom,
    ! [A: array_int_array_int_int,B: array_int_array_int_int] :
      ( ! [I: $int] : ( select_int_array_int_int(A,I) = select_int_array_int_int(A,I) )
     => ( A = B ) ) ).

tff(voogie_precondition_4,axiom,
    ! [A: array_int_int,V: $int,I: $int,J: $int] :
      ( ( I = J )
     => ( select_int_int(store_int_int(A,I,V),J) = V ) ) ).

tff(voogie_precondition_5,axiom,
    ! [A: array_int_int,V: $int,I: $int,J: $int] :
      ( ( I != J )
     => ( select_int_int(store_int_int(A,I,V),J) = select_int_int(A,J) ) ) ).

tff(voogie_precondition_6,axiom,
    ! [A: array_int_int,B: array_int_int] :
      ( ! [I: $int] : ( select_int_int(A,I) = select_int_int(B,I) )
     => ( A = B ) ) ).

tff(voogie_precondition_7,axiom,
    $greater(size,0) ).

tff(voogie_precondition_8,axiom,
    ( $lesseq(0,row)
    & $lesseq(row,col) ) ).

tff(voogie_precondition_9,axiom,
    ! [I: $int,J: $int] :
      ( ( ( $lesseq(0,I)
          & $lesseq(I,J)
          & $less(J,size)
          & ( ( ( I = row )
              & $less(J,col) )
            | $less(I,row) ) )
       => ( select_int_int(select_int_array_int_int(transposed,I),J) = select_int_int(select_int_array_int_int(matrix,J),I) ) )
      & ( select_int_int(select_int_array_int_int(transposed,J),I) = select_int_int(select_int_array_int_int(matrix,I),J) ) ) ).

tff(voogie_conjecture,conjecture,
    $let(
      bad: $o,
      bad:= 
        $ite(
          ~ ( ( row != size ) ),
          $true,
          bad ),
      $let(
        [ transposed: array_int_array_int_int,
          col: $int,
          row: $int ],
        [transposed,col,row]:= 
          $ite(
            $less(col,size),
            $let(
              transposed: array_int_array_int_int,
              transposed:= store_int_array_int_int(transposed,row,store_int_int(select_int_array_int_int(transposed,row),col,select_int_int(select_int_array_int_int(matrix,col),row))),
              $let(
                transposed: array_int_array_int_int,
                transposed:= store_int_array_int_int(transposed,col,store_int_int(select_int_array_int_int(transposed,col),row,select_int_int(select_int_array_int_int(matrix,row),col))),
                $let(
                  col: $int,
                  col:= $sum(col,1),
                  [transposed,col,row] ) ) ),
            $let(
              row: $int,
              row:= $sum(row,1),
              $let(
                col: $int,
                col:= $sum(row,1),
                $let(
                  transposed: array_int_array_int_int,
                  transposed:= store_int_array_int_int(transposed,row,store_int_int(select_int_array_int_int(transposed,row),row,select_int_int(select_int_array_int_int(matrix,row),row))),
                  [transposed,col,row] ) ) ) ),
        $let(
          bad: $o,
          bad:= 
            $ite(
              ~ ( ( row != size ) ),
              $true,
              bad ),
          $let(
            [ transposed: array_int_array_int_int,
              col: $int,
              row: $int ],
            [transposed,col,row]:= 
              $ite(
                $less(col,size),
                $let(
                  transposed: array_int_array_int_int,
                  transposed:= store_int_array_int_int(transposed,row,store_int_int(select_int_array_int_int(transposed,row),col,select_int_int(select_int_array_int_int(matrix,col),row))),
                  $let(
                    transposed: array_int_array_int_int,
                    transposed:= store_int_array_int_int(transposed,col,store_int_int(select_int_array_int_int(transposed,col),row,select_int_int(select_int_array_int_int(matrix,row),col))),
                    $let(
                      col: $int,
                      col:= $sum(col,1),
                      [transposed,col,row] ) ) ),
                $let(
                  row: $int,
                  row:= $sum(row,1),
                  $let(
                    col: $int,
                    col:= $sum(row,1),
                    $let(
                      transposed: array_int_array_int_int,
                      transposed:= store_int_array_int_int(transposed,row,store_int_int(select_int_array_int_int(transposed,row),row,select_int_int(select_int_array_int_int(matrix,row),row))),
                      [transposed,col,row] ) ) ) ),
            ( ( bad
              | ( $lesseq(0,row)
                & $lesseq(row,col) ) )
            & ( bad
              | ! [I: $int,J: $int] :
                  ( ( ( $lesseq(0,I)
                      & $lesseq(I,J)
                      & $less(J,size)
                      & ( ( ( I = row )
                          & $less(J,col) )
                        | $less(I,row) ) )
                   => ( select_int_int(select_int_array_int_int(transposed,I),J) = select_int_int(select_int_array_int_int(matrix,J),I) ) )
                  & ( select_int_int(select_int_array_int_int(transposed,J),I) = select_int_int(select_int_array_int_int(matrix,I),J) ) ) ) ) ) ) ) ) ).

%------------------------------------------------------------------------------
