%------------------------------------------------------------------------------
% File     : SWW971_5 : TPTP v9.2.0. Released v8.2.0.
% Domain   : Software Verification
% Problem  : Conflict detection of 2 conceptual schemata (e.g. UML-schemata)
% Version  : [QMLTP] axioms.
% English  :

% Refs     : [BE04]  Boeva & Ekenberg (2004), A Transition Logic for Schema
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
% Source   : [QMLTP]
% Names    : APM002+1 [QMLTP]

% Status   : CounterSatisfiable
% Rating   : 0.00 v8.2.0
% Syntax   : Number of formulae    :   16 (   4 unt;   9 typ;   0 def)
%            Number of atoms       :   26 (   0 equ)
%            Maximal formula atoms :   11 (   3 avg)
%            Number of connectives :   25 (   6   ~;   2   |;  10   &)
%                                         (   2 <=>;   5  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   4 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :    8 (   4   >;   4   *;   0   +;   0  <<)
%            Number of predicates  :    5 (   4 usr;   1 prp; 0-2 aty)
%            Number of functors    :    4 (   4 usr;   4 con; 0-0 aty)
%            Number of variables   :   10 (;   6   !;   4   ?;  10   :)
% SPC      : TF0_CSA_NEQ_NAR

% Comments : Generated by embedproblem, version 1.7.14, rigid constant, 
%            modal_system_S5, TFF embedding.
%------------------------------------------------------------------------------
tff('$ki_world_type',type,
    '$ki_world': $tType ).

tff('$ki_local_world_decl',type,
    '$ki_local_world': '$ki_world' ).

tff('$ki_accessible_decl',type,
    '$ki_accessible': ( '$ki_world' * '$ki_world' ) > $o ).

tff(mrel_universal,axiom,
    ! [W: '$ki_world',V: '$ki_world'] : '$ki_accessible'(W,V) ).

tff(a_decl,type,
    a: $i ).

tff(b_decl,type,
    b: $i ).

tff(c_decl,type,
    c: $i ).

tff(p_decl,type,
    p: ( '$ki_world' * $i ) > $o ).

tff(r_decl,type,
    r: ( '$ki_world' * $i ) > $o ).

tff('$ki_exists_in_world_$i_decl',type,
    '$ki_exists_in_world_$i': ( '$ki_world' * $i ) > $o ).

tff('$ki_exists_in_world_$i_const',axiom,
    ! [W: '$ki_world',X: $i] : '$ki_exists_in_world_$i'(W,X) ).

tff('$ki_exists_in_world_$i_nonempty',axiom,
    ! [W: '$ki_world'] :
    ? [X: $i] : '$ki_exists_in_world_$i'(W,X) ).

tff(schema1,axiom,
    ( ( ~ r('$ki_local_world',a)
      | r('$ki_local_world',b) )
    & ( r('$ki_local_world',c)
    <=> r('$ki_local_world',a) )
    & ( r('$ki_local_world',a)
     => ? [W: '$ki_world'] :
          ( '$ki_accessible'('$ki_local_world',W)
          & r(W,b) ) )
    & ( ~ r('$ki_local_world',a)
     => ? [W: '$ki_world'] :
          ( '$ki_accessible'('$ki_local_world',W)
          & ~ r(W,b)
          & ~ r(W,c) ) ) ) ).

tff(schema2,axiom,
    ( ( p('$ki_local_world',a)
     => p('$ki_local_world',b) )
    & ( p('$ki_local_world',c)
      | ~ p('$ki_local_world',b) )
    & ( ( p('$ki_local_world',a)
        & p('$ki_local_world',b) )
     => ? [W: '$ki_world'] :
          ( '$ki_accessible'('$ki_local_world',W)
          & ~ p(W,b) ) ) ) ).

tff(integration_assertion,axiom,
    ! [X: $i] :
      ( '$ki_exists_in_world_$i'('$ki_local_world',X)
     => ( p('$ki_local_world',X)
      <=> r('$ki_local_world',X) ) ) ).

tff(verify,conjecture,
    $false ).

%------------------------------------------------------------------------------
