%------------------------------------------------------------------------------
% File     : SWW645_2 : TPTP v9.2.0. Released v6.1.0.
% Domain   : Software Verification
% Problem  : Sudoku-T-WP parameter classical sudoku
% Version  : Especial : Let and conditional terms encoded away.
% English  :

% Refs     : [Fil14] Filliatre (2014), Email to Geoff Sutcliffe
%          : [BF+]   Bobot et al. (URL), Toccata: Certified Programs and Cert
% Source   : [Fil14]
% Names    : sudoku-T-WP_parameter_classical_sudoku [Fil14]

% Status   : Theorem
% Rating   : 1.00 v6.3.0, 0.86 v6.2.0, 1.00 v6.1.0
% Syntax   : Number of formulae    :  116 (  33 unt;  57 typ;   0 def)
%            Number of atoms       : 1230 ( 310 equ)
%            Maximal formula atoms : 1093 (  10 avg)
%            Number of connectives : 1177 (   6   ~;   1   |; 855   &)
%                                         (  14 <=>; 301  =>;   0  <=;   0 <~>)
%            Maximal formula depth : 1094 (  24 avg)
%            Maximal term depth    :    8 (   1 avg)
%            Number arithmetic     : 3124 ( 851 atm;  10 fun;2227 num;  36 var)
%            Number of types       :    9 (   7 usr;   1 ari)
%            Number of type conns  :   89 (  41   >;  48   *;   0   +;   0  <<)
%            Number of predicates  :   18 (  15 usr;   0 prp; 1-4 aty)
%            Number of functors    :  119 (  35 usr;  91 con; 0-6 aty)
%            Number of variables   :  449 ( 449   !;   0   ?; 449   :)
% SPC      : TF0_THM_EQU_ARI

% Comments :
%------------------------------------------------------------------------------
tff(uni,type,
    uni: $tType ).

tff(ty,type,
    ty: $tType ).

tff(sort,type,
    sort1: ( ty * uni ) > $o ).

tff(witness,type,
    witness1: ty > uni ).

tff(witness_sort1,axiom,
    ! [A: ty] : sort1(A,witness1(A)) ).

tff(int,type,
    int: ty ).

tff(real,type,
    real: ty ).

tff(bool,type,
    bool1: $tType ).

tff(bool1,type,
    bool: ty ).

tff(true,type,
    true1: bool1 ).

tff(false,type,
    false1: bool1 ).

tff(match_bool,type,
    match_bool1: ( ty * bool1 * uni * uni ) > uni ).

tff(match_bool_sort1,axiom,
    ! [A: ty,X: bool1,X1: uni,X2: uni] : sort1(A,match_bool1(A,X,X1,X2)) ).

tff(match_bool_True,axiom,
    ! [A: ty,Z: uni,Z1: uni] :
      ( sort1(A,Z)
     => ( match_bool1(A,true1,Z,Z1) = Z ) ) ).

tff(match_bool_False,axiom,
    ! [A: ty,Z: uni,Z1: uni] :
      ( sort1(A,Z1)
     => ( match_bool1(A,false1,Z,Z1) = Z1 ) ) ).

tff(true_False,axiom,
    true1 != false1 ).

tff(bool_inversion,axiom,
    ! [U: bool1] :
      ( ( U = true1 )
      | ( U = false1 ) ) ).

tff(tuple0,type,
    tuple02: $tType ).

tff(tuple01,type,
    tuple0: ty ).

tff(tuple02,type,
    tuple03: tuple02 ).

tff(tuple0_inversion,axiom,
    ! [U: tuple02] : ( U = tuple03 ) ).

tff(qtmark,type,
    qtmark: ty ).

tff(compatOrderMult,axiom,
    ! [X: $int,Y: $int,Z: $int] :
      ( $lesseq(X,Y)
     => ( $lesseq(0,Z)
       => $lesseq($product(X,Z),$product(Y,Z)) ) ) ).

tff(map,type,
    map: ( ty * ty ) > ty ).

tff(get,type,
    get: ( ty * ty * uni * uni ) > uni ).

tff(get_sort2,axiom,
    ! [A: ty,B: ty,X: uni,X1: uni] : sort1(B,get(B,A,X,X1)) ).

tff(set,type,
    set: ( ty * ty * uni * uni * uni ) > uni ).

tff(set_sort2,axiom,
    ! [A: ty,B: ty,X: uni,X1: uni,X2: uni] : sort1(map(A,B),set(B,A,X,X1,X2)) ).

tff(select_eq,axiom,
    ! [A: ty,B: ty,M: uni,A1: uni,A2: uni,B1: uni] :
      ( sort1(B,B1)
     => ( ( A1 = A2 )
       => ( get(B,A,set(B,A,M,A1,B1),A2) = B1 ) ) ) ).

tff(select_neq,axiom,
    ! [A: ty,B: ty,M: uni,A1: uni,A2: uni] :
      ( sort1(A,A1)
     => ( sort1(A,A2)
       => ! [B1: uni] :
            ( ( A1 != A2 )
           => ( get(B,A,set(B,A,M,A1,B1),A2) = get(B,A,M,A2) ) ) ) ) ).

tff(const1,type,
    const: ( ty * ty * uni ) > uni ).

tff(const_sort1,axiom,
    ! [A: ty,B: ty,X: uni] : sort1(map(A,B),const(B,A,X)) ).

tff(const,axiom,
    ! [A: ty,B: ty,B1: uni,A1: uni] :
      ( sort1(B,B1)
     => ( get(B,A,const(B,A,B1),A1) = B1 ) ) ).

tff(is_index,type,
    is_index1: $int > $o ).

tff(is_index_def,axiom,
    ! [I: $int] :
      ( is_index1(I)
    <=> ( $lesseq(0,I)
        & $less(I,81) ) ) ).

tff(map_int_int,type,
    map_int_int: $tType ).

tff(valid_values,type,
    valid_values1: map_int_int > $o ).

tff(t2tb,type,
    t2tb: map_int_int > uni ).

tff(t2tb_sort,axiom,
    ! [X: map_int_int] : sort1(map(int,int),t2tb(X)) ).

tff(tb2t,type,
    tb2t: uni > map_int_int ).

tff(bridgeL,axiom,
    ! [I: map_int_int] : ( tb2t(t2tb(I)) = I ) ).

tff(bridgeR,axiom,
    ! [J: uni] : ( t2tb(tb2t(J)) = J ) ).

tff(t2tb1,type,
    t2tb1: $int > uni ).

tff(t2tb_sort1,axiom,
    ! [X: $int] : sort1(int,t2tb1(X)) ).

tff(tb2t1,type,
    tb2t1: uni > $int ).

tff(bridgeL1,axiom,
    ! [I: $int] : ( tb2t1(t2tb1(I)) = I ) ).

tff(bridgeR1,axiom,
    ! [J: uni] : ( t2tb1(tb2t1(J)) = J ) ).

tff(valid_values_def,axiom,
    ! [G: map_int_int] :
      ( valid_values1(G)
    <=> ! [I: $int] :
          ( is_index1(I)
         => ( $lesseq(0,tb2t1(get(int,int,t2tb(G),t2tb1(I))))
            & $lesseq(tb2t1(get(int,int,t2tb(G),t2tb1(I))),9) ) ) ) ).

tff(grid_eq_sub1,type,
    grid_eq_sub1: ( map_int_int * map_int_int * $int * $int ) > $o ).

tff(grid_eq_sub_def,axiom,
    ! [G1: map_int_int,G2: map_int_int,A: $int,B: $int] :
      ( grid_eq_sub1(G1,G2,A,B)
    <=> ! [J: $int] :
          ( ( $lesseq(A,J)
            & $less(J,B) )
         => ( tb2t1(get(int,int,t2tb(G1),t2tb1(J))) = tb2t1(get(int,int,t2tb(G2),t2tb1(J))) ) ) ) ).

tff(grid_eq_sub,axiom,
    ! [G1: map_int_int,G2: map_int_int,A: $int,B: $int] :
      ( ( $lesseq(0,A)
        & $lesseq(A,81)
        & $lesseq(0,B)
        & $lesseq(B,81)
        & grid_eq_sub1(G1,G2,0,81) )
     => grid_eq_sub1(G1,G2,A,B) ) ).

tff(array,type,
    array: ty > ty ).

tff(mk_array,type,
    mk_array1: ( ty * $int * uni ) > uni ).

tff(mk_array_sort1,axiom,
    ! [A: ty,X: $int,X1: uni] : sort1(array(A),mk_array1(A,X,X1)) ).

tff(length,type,
    length1: ( ty * uni ) > $int ).

tff(length_def1,axiom,
    ! [A: ty,U: $int,U1: uni] : ( length1(A,mk_array1(A,U,U1)) = U ) ).

tff(elts,type,
    elts: ( ty * uni ) > uni ).

tff(elts_sort1,axiom,
    ! [A: ty,X: uni] : sort1(map(int,A),elts(A,X)) ).

tff(elts_def1,axiom,
    ! [A: ty,U: $int,U1: uni] :
      ( sort1(map(int,A),U1)
     => ( elts(A,mk_array1(A,U,U1)) = U1 ) ) ).

tff(array_inversion1,axiom,
    ! [A: ty,U: uni] : ( U = mk_array1(A,length1(A,U),elts(A,U)) ) ).

tff(get1,type,
    get2: ( ty * uni * $int ) > uni ).

tff(get_sort3,axiom,
    ! [A: ty,X: uni,X1: $int] : sort1(A,get2(A,X,X1)) ).

tff(get_def,axiom,
    ! [A: ty,A1: uni,I: $int] : ( get2(A,A1,I) = get(A,int,elts(A,A1),t2tb1(I)) ) ).

tff(set1,type,
    set2: ( ty * uni * $int * uni ) > uni ).

tff(set_sort3,axiom,
    ! [A: ty,X: uni,X1: $int,X2: uni] : sort1(array(A),set2(A,X,X1,X2)) ).

tff(set_def,axiom,
    ! [A: ty,A1: uni,I: $int,V: uni] : ( set2(A,A1,I,V) = mk_array1(A,length1(A,A1),set(A,int,elts(A,A1),t2tb1(I),V)) ) ).

tff(make,type,
    make1: ( ty * $int * uni ) > uni ).

tff(make_sort1,axiom,
    ! [A: ty,X: $int,X1: uni] : sort1(array(A),make1(A,X,X1)) ).

tff(make_def,axiom,
    ! [A: ty,N: $int,V: uni] : ( make1(A,N,V) = mk_array1(A,N,const(A,int,V)) ) ).

tff(sudoku_chunks,type,
    sudoku_chunks1: $tType ).

tff(sudoku_chunks1,type,
    sudoku_chunks: ty ).

tff(array_int,type,
    array_int: $tType ).

tff(mk_sudoku_chunks,type,
    mk_sudoku_chunks1: ( array_int * array_int * array_int * array_int * array_int * array_int ) > sudoku_chunks1 ).

tff(column_start,type,
    column_start1: sudoku_chunks1 > array_int ).

tff(column_start_def1,axiom,
    ! [U: array_int,U1: array_int,U2: array_int,U3: array_int,U4: array_int,U5: array_int] : ( column_start1(mk_sudoku_chunks1(U,U1,U2,U3,U4,U5)) = U ) ).

tff(column_offsets,type,
    column_offsets1: sudoku_chunks1 > array_int ).

tff(column_offsets_def1,axiom,
    ! [U: array_int,U1: array_int,U2: array_int,U3: array_int,U4: array_int,U5: array_int] : ( column_offsets1(mk_sudoku_chunks1(U,U1,U2,U3,U4,U5)) = U1 ) ).

tff(row_start,type,
    row_start1: sudoku_chunks1 > array_int ).

tff(row_start_def1,axiom,
    ! [U: array_int,U1: array_int,U2: array_int,U3: array_int,U4: array_int,U5: array_int] : ( row_start1(mk_sudoku_chunks1(U,U1,U2,U3,U4,U5)) = U2 ) ).

tff(row_offsets,type,
    row_offsets1: sudoku_chunks1 > array_int ).

tff(row_offsets_def1,axiom,
    ! [U: array_int,U1: array_int,U2: array_int,U3: array_int,U4: array_int,U5: array_int] : ( row_offsets1(mk_sudoku_chunks1(U,U1,U2,U3,U4,U5)) = U3 ) ).

tff(square_start,type,
    square_start1: sudoku_chunks1 > array_int ).

tff(square_start_def1,axiom,
    ! [U: array_int,U1: array_int,U2: array_int,U3: array_int,U4: array_int,U5: array_int] : ( square_start1(mk_sudoku_chunks1(U,U1,U2,U3,U4,U5)) = U4 ) ).

tff(square_offsets,type,
    square_offsets1: sudoku_chunks1 > array_int ).

tff(square_offsets_def1,axiom,
    ! [U: array_int,U1: array_int,U2: array_int,U3: array_int,U4: array_int,U5: array_int] : ( square_offsets1(mk_sudoku_chunks1(U,U1,U2,U3,U4,U5)) = U5 ) ).

tff(sudoku_chunks_inversion1,axiom,
    ! [U: sudoku_chunks1] : ( U = mk_sudoku_chunks1(column_start1(U),column_offsets1(U),row_start1(U),row_offsets1(U),square_start1(U),square_offsets1(U)) ) ).

tff(chunk_valid_indexes,type,
    chunk_valid_indexes1: ( array_int * array_int ) > $o ).

tff(t2tb2,type,
    t2tb2: array_int > uni ).

tff(t2tb_sort2,axiom,
    ! [X: array_int] : sort1(array(int),t2tb2(X)) ).

tff(tb2t2,type,
    tb2t2: uni > array_int ).

tff(bridgeL2,axiom,
    ! [I: array_int] : ( tb2t2(t2tb2(I)) = I ) ).

tff(bridgeR2,axiom,
    ! [J: uni] : ( t2tb2(tb2t2(J)) = J ) ).

tff(chunk_valid_indexes_def,axiom,
    ! [Start: array_int,Offsets: array_int] :
      ( chunk_valid_indexes1(Start,Offsets)
    <=> ( ( length1(int,t2tb2(Start)) = 81 )
        & ( length1(int,t2tb2(Offsets)) = 9 )
        & ! [I: $int,O: $int] :
            ( ( is_index1(I)
              & $lesseq(0,O)
              & $less(O,9) )
           => is_index1($sum(tb2t1(get2(int,t2tb2(Start),I)),tb2t1(get2(int,t2tb2(Offsets),O)))) ) ) ) ).

tff(disjoint_chunks,type,
    disjoint_chunks1: ( array_int * array_int ) > $o ).

tff(disjoint_chunks_def,axiom,
    ! [Start: array_int,Offsets: array_int] :
      ( disjoint_chunks1(Start,Offsets)
    <=> ( ( length1(int,t2tb2(Start)) = 81 )
        & ( length1(int,t2tb2(Offsets)) = 9 )
        & ! [I1: $int,I2: $int,O: $int] :
            ( ( is_index1(I1)
              & is_index1(I2)
              & $lesseq(0,O)
              & $less(O,9) )
           => ( ( tb2t1(get2(int,t2tb2(Start),I1)) != tb2t1(get2(int,t2tb2(Start),I2)) )
             => ( I1 != $sum(tb2t1(get2(int,t2tb2(Start),I2)),tb2t1(get2(int,t2tb2(Offsets),O))) ) ) ) ) ) ).

tff(well_formed_sudoku,type,
    well_formed_sudoku1: sudoku_chunks1 > $o ).

tff(well_formed_sudoku_def,axiom,
    ! [S: sudoku_chunks1] :
      ( well_formed_sudoku1(S)
    <=> ( chunk_valid_indexes1(column_start1(S),column_offsets1(S))
        & chunk_valid_indexes1(row_start1(S),row_offsets1(S))
        & chunk_valid_indexes1(square_start1(S),square_offsets1(S))
        & disjoint_chunks1(column_start1(S),column_offsets1(S))
        & disjoint_chunks1(row_start1(S),row_offsets1(S))
        & disjoint_chunks1(square_start1(S),square_offsets1(S)) ) ) ).

tff(valid_chunk,type,
    valid_chunk1: ( map_int_int * $int * array_int * array_int ) > $o ).

tff(valid_chunk_def,axiom,
    ! [G: map_int_int,I: $int,Start: array_int,Offsets: array_int] :
      ( valid_chunk1(G,I,Start,Offsets)
    <=> ! [O1: $int,O2: $int] :
          ( ( $lesseq(0,O1)
            & $less(O1,9)
            & $lesseq(0,O2)
            & $less(O2,9)
            & ( O1 != O2 ) )
         => ( ( $lesseq(1,tb2t1(get(int,int,t2tb(G),t2tb1($sum(tb2t1(get2(int,t2tb2(Start),I)),tb2t1(get2(int,t2tb2(Offsets),O1)))))))
              & $lesseq(tb2t1(get(int,int,t2tb(G),t2tb1($sum(tb2t1(get2(int,t2tb2(Start),I)),tb2t1(get2(int,t2tb2(Offsets),O1)))))),9)
              & $lesseq(1,tb2t1(get(int,int,t2tb(G),t2tb1($sum(tb2t1(get2(int,t2tb2(Start),I)),tb2t1(get2(int,t2tb2(Offsets),O2)))))))
              & $lesseq(tb2t1(get(int,int,t2tb(G),t2tb1($sum(tb2t1(get2(int,t2tb2(Start),I)),tb2t1(get2(int,t2tb2(Offsets),O2)))))),9) )
           => ( tb2t1(get(int,int,t2tb(G),t2tb1($sum(tb2t1(get2(int,t2tb2(Start),I)),tb2t1(get2(int,t2tb2(Offsets),O1)))))) != tb2t1(get(int,int,t2tb(G),t2tb1($sum(tb2t1(get2(int,t2tb2(Start),I)),tb2t1(get2(int,t2tb2(Offsets),O2)))))) ) ) ) ) ).

tff(valid_column,type,
    valid_column1: ( sudoku_chunks1 * map_int_int * $int ) > $o ).

tff(valid_column_def,axiom,
    ! [S: sudoku_chunks1,G: map_int_int,I: $int] :
      ( valid_column1(S,G,I)
    <=> valid_chunk1(G,I,column_start1(S),column_offsets1(S)) ) ).

tff(valid_row,type,
    valid_row1: ( sudoku_chunks1 * map_int_int * $int ) > $o ).

tff(valid_row_def,axiom,
    ! [S: sudoku_chunks1,G: map_int_int,I: $int] :
      ( valid_row1(S,G,I)
    <=> valid_chunk1(G,I,row_start1(S),row_offsets1(S)) ) ).

tff(valid_square,type,
    valid_square1: ( sudoku_chunks1 * map_int_int * $int ) > $o ).

tff(valid_square_def,axiom,
    ! [S: sudoku_chunks1,G: map_int_int,I: $int] :
      ( valid_square1(S,G,I)
    <=> valid_chunk1(G,I,square_start1(S),square_offsets1(S)) ) ).

tff(valid,type,
    valid1: ( sudoku_chunks1 * map_int_int ) > $o ).

tff(valid_def,axiom,
    ! [S: sudoku_chunks1,G: map_int_int] :
      ( valid1(S,G)
    <=> ! [I: $int] :
          ( is_index1(I)
         => ( valid_column1(S,G,I)
            & valid_row1(S,G,I)
            & valid_square1(S,G,I) ) ) ) ).

tff(full,type,
    full1: map_int_int > $o ).

tff(full_def,axiom,
    ! [G: map_int_int] :
      ( full1(G)
    <=> ! [I: $int] :
          ( is_index1(I)
         => ( $lesseq(1,tb2t1(get(int,int,t2tb(G),t2tb1(I))))
            & $lesseq(tb2t1(get(int,int,t2tb(G),t2tb1(I))),9) ) ) ) ).

tff(included,type,
    included1: ( map_int_int * map_int_int ) > $o ).

tff(included_def,axiom,
    ! [G1: map_int_int,G2: map_int_int] :
      ( included1(G1,G2)
    <=> ! [I: $int] :
          ( ( is_index1(I)
            & $lesseq(1,tb2t1(get(int,int,t2tb(G1),t2tb1(I))))
            & $lesseq(tb2t1(get(int,int,t2tb(G1),t2tb1(I))),9) )
         => ( tb2t1(get(int,int,t2tb(G2),t2tb1(I))) = tb2t1(get(int,int,t2tb(G1),t2tb1(I))) ) ) ) ).

tff(subset_valid_chunk,axiom,
    ! [G: map_int_int,H: map_int_int] :
      ( included1(G,H)
     => ! [I: $int,S: array_int,O: array_int] :
          ( ( is_index1(I)
            & chunk_valid_indexes1(S,O)
            & valid_chunk1(H,I,S,O) )
         => valid_chunk1(G,I,S,O) ) ) ).

tff(subset_valid,axiom,
    ! [S: sudoku_chunks1,G: map_int_int,H: map_int_int] :
      ( ( well_formed_sudoku1(S)
        & included1(G,H)
        & valid1(S,H) )
     => valid1(S,G) ) ).

tff(is_solution_for,type,
    is_solution_for1: ( sudoku_chunks1 * map_int_int * map_int_int ) > $o ).

tff(is_solution_for_def,axiom,
    ! [S: sudoku_chunks1,Sol: map_int_int,Data: map_int_int] :
      ( is_solution_for1(S,Sol,Data)
    <=> ( included1(Data,Sol)
        & full1(Sol)
        & valid1(S,Sol) ) ) ).

tff(wP_parameter_classical_sudoku,conjecture,
    ( $lesseq(0,81)
    & ( $lesseq(0,81)
     => ( $lesseq(0,0)
        & $less(0,81)
        & ! [Cs: map_int_int] :
            ( ( $lesseq(0,81)
              & ( Cs = tb2t(set(int,int,const(int,int,t2tb1(0)),t2tb1(0),t2tb1(0))) ) )
           => ( $lesseq(0,1)
              & $less(1,81)
              & ! [Cs1: map_int_int] :
                  ( ( $lesseq(0,81)
                    & ( Cs1 = tb2t(set(int,int,t2tb(Cs),t2tb1(1),t2tb1(1))) ) )
                 => ( $lesseq(0,2)
                    & $less(2,81)
                    & ! [Cs2: map_int_int] :
                        ( ( $lesseq(0,81)
                          & ( Cs2 = tb2t(set(int,int,t2tb(Cs1),t2tb1(2),t2tb1(2))) ) )
                       => ( $lesseq(0,3)
                          & $less(3,81)
                          & ! [Cs3: map_int_int] :
                              ( ( $lesseq(0,81)
                                & ( Cs3 = tb2t(set(int,int,t2tb(Cs2),t2tb1(3),t2tb1(3))) ) )
                             => ( $lesseq(0,4)
                                & $less(4,81)
                                & ! [Cs4: map_int_int] :
                                    ( ( $lesseq(0,81)
                                      & ( Cs4 = tb2t(set(int,int,t2tb(Cs3),t2tb1(4),t2tb1(4))) ) )
                                   => ( $lesseq(0,5)
                                      & $less(5,81)
                                      & ! [Cs5: map_int_int] :
                                          ( ( $lesseq(0,81)
                                            & ( Cs5 = tb2t(set(int,int,t2tb(Cs4),t2tb1(5),t2tb1(5))) ) )
                                         => ( $lesseq(0,6)
                                            & $less(6,81)
                                            & ! [Cs6: map_int_int] :
                                                ( ( $lesseq(0,81)
                                                  & ( Cs6 = tb2t(set(int,int,t2tb(Cs5),t2tb1(6),t2tb1(6))) ) )
                                               => ( $lesseq(0,7)
                                                  & $less(7,81)
                                                  & ! [Cs7: map_int_int] :
                                                      ( ( $lesseq(0,81)
                                                        & ( Cs7 = tb2t(set(int,int,t2tb(Cs6),t2tb1(7),t2tb1(7))) ) )
                                                     => ( $lesseq(0,8)
                                                        & $less(8,81)
                                                        & ! [Cs8: map_int_int] :
                                                            ( ( $lesseq(0,81)
                                                              & ( Cs8 = tb2t(set(int,int,t2tb(Cs7),t2tb1(8),t2tb1(8))) ) )
                                                           => ( $lesseq(0,9)
                                                              & $less(9,81)
                                                              & ! [Cs9: map_int_int] :
                                                                  ( ( $lesseq(0,81)
                                                                    & ( Cs9 = tb2t(set(int,int,t2tb(Cs8),t2tb1(9),t2tb1(0))) ) )
                                                                 => ( $lesseq(0,10)
                                                                    & $less(10,81)
                                                                    & ! [Cs10: map_int_int] :
                                                                        ( ( $lesseq(0,81)
                                                                          & ( Cs10 = tb2t(set(int,int,t2tb(Cs9),t2tb1(10),t2tb1(1))) ) )
                                                                       => ( $lesseq(0,11)
                                                                          & $less(11,81)
                                                                          & ! [Cs11: map_int_int] :
                                                                              ( ( $lesseq(0,81)
                                                                                & ( Cs11 = tb2t(set(int,int,t2tb(Cs10),t2tb1(11),t2tb1(2))) ) )
                                                                             => ( $lesseq(0,12)
                                                                                & $less(12,81)
                                                                                & ! [Cs12: map_int_int] :
                                                                                    ( ( $lesseq(0,81)
                                                                                      & ( Cs12 = tb2t(set(int,int,t2tb(Cs11),t2tb1(12),t2tb1(3))) ) )
                                                                                   => ( $lesseq(0,13)
                                                                                      & $less(13,81)
                                                                                      & ! [Cs13: map_int_int] :
                                                                                          ( ( $lesseq(0,81)
                                                                                            & ( Cs13 = tb2t(set(int,int,t2tb(Cs12),t2tb1(13),t2tb1(4))) ) )
                                                                                         => ( $lesseq(0,14)
                                                                                            & $less(14,81)
                                                                                            & ! [Cs14: map_int_int] :
                                                                                                ( ( $lesseq(0,81)
                                                                                                  & ( Cs14 = tb2t(set(int,int,t2tb(Cs13),t2tb1(14),t2tb1(5))) ) )
                                                                                               => ( $lesseq(0,15)
                                                                                                  & $less(15,81)
                                                                                                  & ! [Cs15: map_int_int] :
                                                                                                      ( ( $lesseq(0,81)
                                                                                                        & ( Cs15 = tb2t(set(int,int,t2tb(Cs14),t2tb1(15),t2tb1(6))) ) )
                                                                                                     => ( $lesseq(0,16)
                                                                                                        & $less(16,81)
                                                                                                        & ! [Cs16: map_int_int] :
                                                                                                            ( ( $lesseq(0,81)
                                                                                                              & ( Cs16 = tb2t(set(int,int,t2tb(Cs15),t2tb1(16),t2tb1(7))) ) )
                                                                                                           => ( $lesseq(0,17)
                                                                                                              & $less(17,81)
                                                                                                              & ! [Cs17: map_int_int] :
                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                    & ( Cs17 = tb2t(set(int,int,t2tb(Cs16),t2tb1(17),t2tb1(8))) ) )
                                                                                                                 => ( $lesseq(0,18)
                                                                                                                    & $less(18,81)
                                                                                                                    & ! [Cs18: map_int_int] :
                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                          & ( Cs18 = tb2t(set(int,int,t2tb(Cs17),t2tb1(18),t2tb1(0))) ) )
                                                                                                                       => ( $lesseq(0,19)
                                                                                                                          & $less(19,81)
                                                                                                                          & ! [Cs19: map_int_int] :
                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                & ( Cs19 = tb2t(set(int,int,t2tb(Cs18),t2tb1(19),t2tb1(1))) ) )
                                                                                                                             => ( $lesseq(0,20)
                                                                                                                                & $less(20,81)
                                                                                                                                & ! [Cs20: map_int_int] :
                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                      & ( Cs20 = tb2t(set(int,int,t2tb(Cs19),t2tb1(20),t2tb1(2))) ) )
                                                                                                                                   => ( $lesseq(0,21)
                                                                                                                                      & $less(21,81)
                                                                                                                                      & ! [Cs21: map_int_int] :
                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                            & ( Cs21 = tb2t(set(int,int,t2tb(Cs20),t2tb1(21),t2tb1(3))) ) )
                                                                                                                                         => ( $lesseq(0,22)
                                                                                                                                            & $less(22,81)
                                                                                                                                            & ! [Cs22: map_int_int] :
                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                  & ( Cs22 = tb2t(set(int,int,t2tb(Cs21),t2tb1(22),t2tb1(4))) ) )
                                                                                                                                               => ( $lesseq(0,23)
                                                                                                                                                  & $less(23,81)
                                                                                                                                                  & ! [Cs23: map_int_int] :
                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                        & ( Cs23 = tb2t(set(int,int,t2tb(Cs22),t2tb1(23),t2tb1(5))) ) )
                                                                                                                                                     => ( $lesseq(0,24)
                                                                                                                                                        & $less(24,81)
                                                                                                                                                        & ! [Cs24: map_int_int] :
                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                              & ( Cs24 = tb2t(set(int,int,t2tb(Cs23),t2tb1(24),t2tb1(6))) ) )
                                                                                                                                                           => ( $lesseq(0,25)
                                                                                                                                                              & $less(25,81)
                                                                                                                                                              & ! [Cs25: map_int_int] :
                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                    & ( Cs25 = tb2t(set(int,int,t2tb(Cs24),t2tb1(25),t2tb1(7))) ) )
                                                                                                                                                                 => ( $lesseq(0,26)
                                                                                                                                                                    & $less(26,81)
                                                                                                                                                                    & ! [Cs26: map_int_int] :
                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                          & ( Cs26 = tb2t(set(int,int,t2tb(Cs25),t2tb1(26),t2tb1(8))) ) )
                                                                                                                                                                       => ( $lesseq(0,27)
                                                                                                                                                                          & $less(27,81)
                                                                                                                                                                          & ! [Cs27: map_int_int] :
                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                & ( Cs27 = tb2t(set(int,int,t2tb(Cs26),t2tb1(27),t2tb1(0))) ) )
                                                                                                                                                                             => ( $lesseq(0,28)
                                                                                                                                                                                & $less(28,81)
                                                                                                                                                                                & ! [Cs28: map_int_int] :
                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                      & ( Cs28 = tb2t(set(int,int,t2tb(Cs27),t2tb1(28),t2tb1(1))) ) )
                                                                                                                                                                                   => ( $lesseq(0,29)
                                                                                                                                                                                      & $less(29,81)
                                                                                                                                                                                      & ! [Cs29: map_int_int] :
                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                            & ( Cs29 = tb2t(set(int,int,t2tb(Cs28),t2tb1(29),t2tb1(2))) ) )
                                                                                                                                                                                         => ( $lesseq(0,30)
                                                                                                                                                                                            & $less(30,81)
                                                                                                                                                                                            & ! [Cs30: map_int_int] :
                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                  & ( Cs30 = tb2t(set(int,int,t2tb(Cs29),t2tb1(30),t2tb1(3))) ) )
                                                                                                                                                                                               => ( $lesseq(0,31)
                                                                                                                                                                                                  & $less(31,81)
                                                                                                                                                                                                  & ! [Cs31: map_int_int] :
                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                        & ( Cs31 = tb2t(set(int,int,t2tb(Cs30),t2tb1(31),t2tb1(4))) ) )
                                                                                                                                                                                                     => ( $lesseq(0,32)
                                                                                                                                                                                                        & $less(32,81)
                                                                                                                                                                                                        & ! [Cs32: map_int_int] :
                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                              & ( Cs32 = tb2t(set(int,int,t2tb(Cs31),t2tb1(32),t2tb1(5))) ) )
                                                                                                                                                                                                           => ( $lesseq(0,33)
                                                                                                                                                                                                              & $less(33,81)
                                                                                                                                                                                                              & ! [Cs33: map_int_int] :
                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                    & ( Cs33 = tb2t(set(int,int,t2tb(Cs32),t2tb1(33),t2tb1(6))) ) )
                                                                                                                                                                                                                 => ( $lesseq(0,34)
                                                                                                                                                                                                                    & $less(34,81)
                                                                                                                                                                                                                    & ! [Cs34: map_int_int] :
                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                          & ( Cs34 = tb2t(set(int,int,t2tb(Cs33),t2tb1(34),t2tb1(7))) ) )
                                                                                                                                                                                                                       => ( $lesseq(0,35)
                                                                                                                                                                                                                          & $less(35,81)
                                                                                                                                                                                                                          & ! [Cs35: map_int_int] :
                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                & ( Cs35 = tb2t(set(int,int,t2tb(Cs34),t2tb1(35),t2tb1(8))) ) )
                                                                                                                                                                                                                             => ( $lesseq(0,36)
                                                                                                                                                                                                                                & $less(36,81)
                                                                                                                                                                                                                                & ! [Cs36: map_int_int] :
                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                      & ( Cs36 = tb2t(set(int,int,t2tb(Cs35),t2tb1(36),t2tb1(0))) ) )
                                                                                                                                                                                                                                   => ( $lesseq(0,37)
                                                                                                                                                                                                                                      & $less(37,81)
                                                                                                                                                                                                                                      & ! [Cs37: map_int_int] :
                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                            & ( Cs37 = tb2t(set(int,int,t2tb(Cs36),t2tb1(37),t2tb1(1))) ) )
                                                                                                                                                                                                                                         => ( $lesseq(0,38)
                                                                                                                                                                                                                                            & $less(38,81)
                                                                                                                                                                                                                                            & ! [Cs38: map_int_int] :
                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                  & ( Cs38 = tb2t(set(int,int,t2tb(Cs37),t2tb1(38),t2tb1(2))) ) )
                                                                                                                                                                                                                                               => ( $lesseq(0,39)
                                                                                                                                                                                                                                                  & $less(39,81)
                                                                                                                                                                                                                                                  & ! [Cs39: map_int_int] :
                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                        & ( Cs39 = tb2t(set(int,int,t2tb(Cs38),t2tb1(39),t2tb1(3))) ) )
                                                                                                                                                                                                                                                     => ( $lesseq(0,40)
                                                                                                                                                                                                                                                        & $less(40,81)
                                                                                                                                                                                                                                                        & ! [Cs40: map_int_int] :
                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                              & ( Cs40 = tb2t(set(int,int,t2tb(Cs39),t2tb1(40),t2tb1(4))) ) )
                                                                                                                                                                                                                                                           => ( $lesseq(0,41)
                                                                                                                                                                                                                                                              & $less(41,81)
                                                                                                                                                                                                                                                              & ! [Cs41: map_int_int] :
                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                    & ( Cs41 = tb2t(set(int,int,t2tb(Cs40),t2tb1(41),t2tb1(5))) ) )
                                                                                                                                                                                                                                                                 => ( $lesseq(0,42)
                                                                                                                                                                                                                                                                    & $less(42,81)
                                                                                                                                                                                                                                                                    & ! [Cs42: map_int_int] :
                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                          & ( Cs42 = tb2t(set(int,int,t2tb(Cs41),t2tb1(42),t2tb1(6))) ) )
                                                                                                                                                                                                                                                                       => ( $lesseq(0,43)
                                                                                                                                                                                                                                                                          & $less(43,81)
                                                                                                                                                                                                                                                                          & ! [Cs43: map_int_int] :
                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                & ( Cs43 = tb2t(set(int,int,t2tb(Cs42),t2tb1(43),t2tb1(7))) ) )
                                                                                                                                                                                                                                                                             => ( $lesseq(0,44)
                                                                                                                                                                                                                                                                                & $less(44,81)
                                                                                                                                                                                                                                                                                & ! [Cs44: map_int_int] :
                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                      & ( Cs44 = tb2t(set(int,int,t2tb(Cs43),t2tb1(44),t2tb1(8))) ) )
                                                                                                                                                                                                                                                                                   => ( $lesseq(0,45)
                                                                                                                                                                                                                                                                                      & $less(45,81)
                                                                                                                                                                                                                                                                                      & ! [Cs45: map_int_int] :
                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                            & ( Cs45 = tb2t(set(int,int,t2tb(Cs44),t2tb1(45),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                         => ( $lesseq(0,46)
                                                                                                                                                                                                                                                                                            & $less(46,81)
                                                                                                                                                                                                                                                                                            & ! [Cs46: map_int_int] :
                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                  & ( Cs46 = tb2t(set(int,int,t2tb(Cs45),t2tb1(46),t2tb1(1))) ) )
                                                                                                                                                                                                                                                                                               => ( $lesseq(0,47)
                                                                                                                                                                                                                                                                                                  & $less(47,81)
                                                                                                                                                                                                                                                                                                  & ! [Cs47: map_int_int] :
                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                        & ( Cs47 = tb2t(set(int,int,t2tb(Cs46),t2tb1(47),t2tb1(2))) ) )
                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,48)
                                                                                                                                                                                                                                                                                                        & $less(48,81)
                                                                                                                                                                                                                                                                                                        & ! [Cs48: map_int_int] :
                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                              & ( Cs48 = tb2t(set(int,int,t2tb(Cs47),t2tb1(48),t2tb1(3))) ) )
                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,49)
                                                                                                                                                                                                                                                                                                              & $less(49,81)
                                                                                                                                                                                                                                                                                                              & ! [Cs49: map_int_int] :
                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                    & ( Cs49 = tb2t(set(int,int,t2tb(Cs48),t2tb1(49),t2tb1(4))) ) )
                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,50)
                                                                                                                                                                                                                                                                                                                    & $less(50,81)
                                                                                                                                                                                                                                                                                                                    & ! [Cs50: map_int_int] :
                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                          & ( Cs50 = tb2t(set(int,int,t2tb(Cs49),t2tb1(50),t2tb1(5))) ) )
                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,51)
                                                                                                                                                                                                                                                                                                                          & $less(51,81)
                                                                                                                                                                                                                                                                                                                          & ! [Cs51: map_int_int] :
                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                & ( Cs51 = tb2t(set(int,int,t2tb(Cs50),t2tb1(51),t2tb1(6))) ) )
                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,52)
                                                                                                                                                                                                                                                                                                                                & $less(52,81)
                                                                                                                                                                                                                                                                                                                                & ! [Cs52: map_int_int] :
                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                      & ( Cs52 = tb2t(set(int,int,t2tb(Cs51),t2tb1(52),t2tb1(7))) ) )
                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,53)
                                                                                                                                                                                                                                                                                                                                      & $less(53,81)
                                                                                                                                                                                                                                                                                                                                      & ! [Cs53: map_int_int] :
                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                            & ( Cs53 = tb2t(set(int,int,t2tb(Cs52),t2tb1(53),t2tb1(8))) ) )
                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,54)
                                                                                                                                                                                                                                                                                                                                            & $less(54,81)
                                                                                                                                                                                                                                                                                                                                            & ! [Cs54: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                  & ( Cs54 = tb2t(set(int,int,t2tb(Cs53),t2tb1(54),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,55)
                                                                                                                                                                                                                                                                                                                                                  & $less(55,81)
                                                                                                                                                                                                                                                                                                                                                  & ! [Cs55: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                        & ( Cs55 = tb2t(set(int,int,t2tb(Cs54),t2tb1(55),t2tb1(1))) ) )
                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,56)
                                                                                                                                                                                                                                                                                                                                                        & $less(56,81)
                                                                                                                                                                                                                                                                                                                                                        & ! [Cs56: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                              & ( Cs56 = tb2t(set(int,int,t2tb(Cs55),t2tb1(56),t2tb1(2))) ) )
                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,57)
                                                                                                                                                                                                                                                                                                                                                              & $less(57,81)
                                                                                                                                                                                                                                                                                                                                                              & ! [Cs57: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                    & ( Cs57 = tb2t(set(int,int,t2tb(Cs56),t2tb1(57),t2tb1(3))) ) )
                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,58)
                                                                                                                                                                                                                                                                                                                                                                    & $less(58,81)
                                                                                                                                                                                                                                                                                                                                                                    & ! [Cs58: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                          & ( Cs58 = tb2t(set(int,int,t2tb(Cs57),t2tb1(58),t2tb1(4))) ) )
                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,59)
                                                                                                                                                                                                                                                                                                                                                                          & $less(59,81)
                                                                                                                                                                                                                                                                                                                                                                          & ! [Cs59: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                & ( Cs59 = tb2t(set(int,int,t2tb(Cs58),t2tb1(59),t2tb1(5))) ) )
                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,60)
                                                                                                                                                                                                                                                                                                                                                                                & $less(60,81)
                                                                                                                                                                                                                                                                                                                                                                                & ! [Cs60: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                      & ( Cs60 = tb2t(set(int,int,t2tb(Cs59),t2tb1(60),t2tb1(6))) ) )
                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,61)
                                                                                                                                                                                                                                                                                                                                                                                      & $less(61,81)
                                                                                                                                                                                                                                                                                                                                                                                      & ! [Cs61: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                            & ( Cs61 = tb2t(set(int,int,t2tb(Cs60),t2tb1(61),t2tb1(7))) ) )
                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,62)
                                                                                                                                                                                                                                                                                                                                                                                            & $less(62,81)
                                                                                                                                                                                                                                                                                                                                                                                            & ! [Cs62: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                  & ( Cs62 = tb2t(set(int,int,t2tb(Cs61),t2tb1(62),t2tb1(8))) ) )
                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,63)
                                                                                                                                                                                                                                                                                                                                                                                                  & $less(63,81)
                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Cs63: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                        & ( Cs63 = tb2t(set(int,int,t2tb(Cs62),t2tb1(63),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,64)
                                                                                                                                                                                                                                                                                                                                                                                                        & $less(64,81)
                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Cs64: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                              & ( Cs64 = tb2t(set(int,int,t2tb(Cs63),t2tb1(64),t2tb1(1))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,65)
                                                                                                                                                                                                                                                                                                                                                                                                              & $less(65,81)
                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Cs65: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Cs65 = tb2t(set(int,int,t2tb(Cs64),t2tb1(65),t2tb1(2))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,66)
                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(66,81)
                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Cs66: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Cs66 = tb2t(set(int,int,t2tb(Cs65),t2tb1(66),t2tb1(3))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,67)
                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(67,81)
                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Cs67: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Cs67 = tb2t(set(int,int,t2tb(Cs66),t2tb1(67),t2tb1(4))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,68)
                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(68,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Cs68: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Cs68 = tb2t(set(int,int,t2tb(Cs67),t2tb1(68),t2tb1(5))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,69)
                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(69,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Cs69: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Cs69 = tb2t(set(int,int,t2tb(Cs68),t2tb1(69),t2tb1(6))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,70)
                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(70,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Cs70: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Cs70 = tb2t(set(int,int,t2tb(Cs69),t2tb1(70),t2tb1(7))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,71)
                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(71,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Cs71: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Cs71 = tb2t(set(int,int,t2tb(Cs70),t2tb1(71),t2tb1(8))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,72)
                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(72,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Cs72: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Cs72 = tb2t(set(int,int,t2tb(Cs71),t2tb1(72),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,73)
                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(73,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Cs73: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Cs73 = tb2t(set(int,int,t2tb(Cs72),t2tb1(73),t2tb1(1))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,74)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(74,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Cs74: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Cs74 = tb2t(set(int,int,t2tb(Cs73),t2tb1(74),t2tb1(2))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,75)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(75,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Cs75: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Cs75 = tb2t(set(int,int,t2tb(Cs74),t2tb1(75),t2tb1(3))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,76)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(76,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Cs76: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Cs76 = tb2t(set(int,int,t2tb(Cs75),t2tb1(76),t2tb1(4))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,77)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(77,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Cs77: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Cs77 = tb2t(set(int,int,t2tb(Cs76),t2tb1(77),t2tb1(5))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,78)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(78,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Cs78: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Cs78 = tb2t(set(int,int,t2tb(Cs77),t2tb1(78),t2tb1(6))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,79)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(79,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Cs79: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Cs79 = tb2t(set(int,int,t2tb(Cs78),t2tb1(79),t2tb1(7))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,80)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(80,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Cs80: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Cs80 = tb2t(set(int,int,t2tb(Cs79),t2tb1(80),t2tb1(8))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,0)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Co: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Co = tb2t(set(int,int,const(int,int,t2tb1(0)),t2tb1(0),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,1)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(1,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Co1: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Co1 = tb2t(set(int,int,t2tb(Co),t2tb1(1),t2tb1(9))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,2)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(2,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Co2: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Co2 = tb2t(set(int,int,t2tb(Co1),t2tb1(2),t2tb1(18))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,3)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(3,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Co3: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Co3 = tb2t(set(int,int,t2tb(Co2),t2tb1(3),t2tb1(27))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,4)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(4,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Co4: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Co4 = tb2t(set(int,int,t2tb(Co3),t2tb1(4),t2tb1(36))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,5)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(5,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Co5: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Co5 = tb2t(set(int,int,t2tb(Co4),t2tb1(5),t2tb1(45))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,6)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(6,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Co6: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Co6 = tb2t(set(int,int,t2tb(Co5),t2tb1(6),t2tb1(54))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,7)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(7,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Co7: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Co7 = tb2t(set(int,int,t2tb(Co6),t2tb1(7),t2tb1(63))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,8)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(8,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Co8: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Co8 = tb2t(set(int,int,t2tb(Co7),t2tb1(8),t2tb1(72))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,0)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Rs: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Rs = tb2t(set(int,int,const(int,int,t2tb1(0)),t2tb1(0),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,1)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(1,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Rs1: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Rs1 = tb2t(set(int,int,t2tb(Rs),t2tb1(1),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,2)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(2,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Rs2: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Rs2 = tb2t(set(int,int,t2tb(Rs1),t2tb1(2),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,3)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(3,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Rs3: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Rs3 = tb2t(set(int,int,t2tb(Rs2),t2tb1(3),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,4)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(4,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Rs4: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Rs4 = tb2t(set(int,int,t2tb(Rs3),t2tb1(4),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,5)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(5,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Rs5: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Rs5 = tb2t(set(int,int,t2tb(Rs4),t2tb1(5),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,6)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(6,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Rs6: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Rs6 = tb2t(set(int,int,t2tb(Rs5),t2tb1(6),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,7)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(7,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Rs7: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Rs7 = tb2t(set(int,int,t2tb(Rs6),t2tb1(7),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,8)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(8,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Rs8: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Rs8 = tb2t(set(int,int,t2tb(Rs7),t2tb1(8),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(9,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Rs9: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Rs9 = tb2t(set(int,int,t2tb(Rs8),t2tb1(9),t2tb1(9))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,10)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(10,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Rs10: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Rs10 = tb2t(set(int,int,t2tb(Rs9),t2tb1(10),t2tb1(9))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,11)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(11,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Rs11: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Rs11 = tb2t(set(int,int,t2tb(Rs10),t2tb1(11),t2tb1(9))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,12)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(12,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Rs12: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Rs12 = tb2t(set(int,int,t2tb(Rs11),t2tb1(12),t2tb1(9))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,13)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(13,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Rs13: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Rs13 = tb2t(set(int,int,t2tb(Rs12),t2tb1(13),t2tb1(9))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,14)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(14,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Rs14: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Rs14 = tb2t(set(int,int,t2tb(Rs13),t2tb1(14),t2tb1(9))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,15)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(15,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Rs15: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Rs15 = tb2t(set(int,int,t2tb(Rs14),t2tb1(15),t2tb1(9))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,16)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(16,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Rs16: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Rs16 = tb2t(set(int,int,t2tb(Rs15),t2tb1(16),t2tb1(9))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,17)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(17,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Rs17: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Rs17 = tb2t(set(int,int,t2tb(Rs16),t2tb1(17),t2tb1(9))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,18)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(18,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Rs18: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Rs18 = tb2t(set(int,int,t2tb(Rs17),t2tb1(18),t2tb1(18))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,19)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(19,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Rs19: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Rs19 = tb2t(set(int,int,t2tb(Rs18),t2tb1(19),t2tb1(18))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,20)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(20,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Rs20: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Rs20 = tb2t(set(int,int,t2tb(Rs19),t2tb1(20),t2tb1(18))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,21)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(21,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Rs21: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Rs21 = tb2t(set(int,int,t2tb(Rs20),t2tb1(21),t2tb1(18))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,22)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(22,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Rs22: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Rs22 = tb2t(set(int,int,t2tb(Rs21),t2tb1(22),t2tb1(18))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,23)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(23,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Rs23: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Rs23 = tb2t(set(int,int,t2tb(Rs22),t2tb1(23),t2tb1(18))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,24)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(24,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Rs24: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Rs24 = tb2t(set(int,int,t2tb(Rs23),t2tb1(24),t2tb1(18))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,25)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(25,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Rs25: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Rs25 = tb2t(set(int,int,t2tb(Rs24),t2tb1(25),t2tb1(18))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,26)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(26,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Rs26: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Rs26 = tb2t(set(int,int,t2tb(Rs25),t2tb1(26),t2tb1(18))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,27)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(27,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Rs27: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Rs27 = tb2t(set(int,int,t2tb(Rs26),t2tb1(27),t2tb1(27))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,28)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(28,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Rs28: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Rs28 = tb2t(set(int,int,t2tb(Rs27),t2tb1(28),t2tb1(27))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,29)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(29,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Rs29: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Rs29 = tb2t(set(int,int,t2tb(Rs28),t2tb1(29),t2tb1(27))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,30)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(30,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Rs30: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Rs30 = tb2t(set(int,int,t2tb(Rs29),t2tb1(30),t2tb1(27))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,31)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(31,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Rs31: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Rs31 = tb2t(set(int,int,t2tb(Rs30),t2tb1(31),t2tb1(27))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,32)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(32,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Rs32: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Rs32 = tb2t(set(int,int,t2tb(Rs31),t2tb1(32),t2tb1(27))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,33)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(33,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Rs33: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Rs33 = tb2t(set(int,int,t2tb(Rs32),t2tb1(33),t2tb1(27))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,34)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(34,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Rs34: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Rs34 = tb2t(set(int,int,t2tb(Rs33),t2tb1(34),t2tb1(27))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,35)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(35,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Rs35: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Rs35 = tb2t(set(int,int,t2tb(Rs34),t2tb1(35),t2tb1(27))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,36)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(36,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Rs36: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Rs36 = tb2t(set(int,int,t2tb(Rs35),t2tb1(36),t2tb1(36))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,37)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(37,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Rs37: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Rs37 = tb2t(set(int,int,t2tb(Rs36),t2tb1(37),t2tb1(36))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,38)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(38,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Rs38: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Rs38 = tb2t(set(int,int,t2tb(Rs37),t2tb1(38),t2tb1(36))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,39)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(39,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Rs39: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Rs39 = tb2t(set(int,int,t2tb(Rs38),t2tb1(39),t2tb1(36))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,40)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(40,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Rs40: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Rs40 = tb2t(set(int,int,t2tb(Rs39),t2tb1(40),t2tb1(36))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,41)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(41,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Rs41: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Rs41 = tb2t(set(int,int,t2tb(Rs40),t2tb1(41),t2tb1(36))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,42)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(42,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Rs42: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Rs42 = tb2t(set(int,int,t2tb(Rs41),t2tb1(42),t2tb1(36))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,43)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(43,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Rs43: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Rs43 = tb2t(set(int,int,t2tb(Rs42),t2tb1(43),t2tb1(36))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,44)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(44,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Rs44: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Rs44 = tb2t(set(int,int,t2tb(Rs43),t2tb1(44),t2tb1(36))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,45)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(45,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Rs45: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Rs45 = tb2t(set(int,int,t2tb(Rs44),t2tb1(45),t2tb1(45))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,46)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(46,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Rs46: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Rs46 = tb2t(set(int,int,t2tb(Rs45),t2tb1(46),t2tb1(45))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,47)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(47,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Rs47: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Rs47 = tb2t(set(int,int,t2tb(Rs46),t2tb1(47),t2tb1(45))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,48)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(48,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Rs48: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Rs48 = tb2t(set(int,int,t2tb(Rs47),t2tb1(48),t2tb1(45))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,49)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(49,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Rs49: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Rs49 = tb2t(set(int,int,t2tb(Rs48),t2tb1(49),t2tb1(45))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,50)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(50,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Rs50: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Rs50 = tb2t(set(int,int,t2tb(Rs49),t2tb1(50),t2tb1(45))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,51)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(51,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Rs51: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Rs51 = tb2t(set(int,int,t2tb(Rs50),t2tb1(51),t2tb1(45))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,52)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(52,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Rs52: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Rs52 = tb2t(set(int,int,t2tb(Rs51),t2tb1(52),t2tb1(45))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,53)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(53,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Rs53: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Rs53 = tb2t(set(int,int,t2tb(Rs52),t2tb1(53),t2tb1(45))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,54)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(54,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Rs54: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Rs54 = tb2t(set(int,int,t2tb(Rs53),t2tb1(54),t2tb1(54))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,55)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(55,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Rs55: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Rs55 = tb2t(set(int,int,t2tb(Rs54),t2tb1(55),t2tb1(54))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,56)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(56,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Rs56: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Rs56 = tb2t(set(int,int,t2tb(Rs55),t2tb1(56),t2tb1(54))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,57)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(57,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Rs57: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Rs57 = tb2t(set(int,int,t2tb(Rs56),t2tb1(57),t2tb1(54))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,58)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(58,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Rs58: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Rs58 = tb2t(set(int,int,t2tb(Rs57),t2tb1(58),t2tb1(54))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,59)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(59,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Rs59: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Rs59 = tb2t(set(int,int,t2tb(Rs58),t2tb1(59),t2tb1(54))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,60)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(60,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Rs60: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Rs60 = tb2t(set(int,int,t2tb(Rs59),t2tb1(60),t2tb1(54))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,61)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(61,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Rs61: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Rs61 = tb2t(set(int,int,t2tb(Rs60),t2tb1(61),t2tb1(54))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,62)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(62,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Rs62: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Rs62 = tb2t(set(int,int,t2tb(Rs61),t2tb1(62),t2tb1(54))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,63)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(63,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Rs63: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Rs63 = tb2t(set(int,int,t2tb(Rs62),t2tb1(63),t2tb1(63))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,64)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(64,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Rs64: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Rs64 = tb2t(set(int,int,t2tb(Rs63),t2tb1(64),t2tb1(63))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,65)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(65,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Rs65: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Rs65 = tb2t(set(int,int,t2tb(Rs64),t2tb1(65),t2tb1(63))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,66)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(66,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Rs66: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Rs66 = tb2t(set(int,int,t2tb(Rs65),t2tb1(66),t2tb1(63))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,67)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(67,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Rs67: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Rs67 = tb2t(set(int,int,t2tb(Rs66),t2tb1(67),t2tb1(63))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,68)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(68,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Rs68: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Rs68 = tb2t(set(int,int,t2tb(Rs67),t2tb1(68),t2tb1(63))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,69)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(69,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Rs69: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Rs69 = tb2t(set(int,int,t2tb(Rs68),t2tb1(69),t2tb1(63))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,70)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(70,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Rs70: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Rs70 = tb2t(set(int,int,t2tb(Rs69),t2tb1(70),t2tb1(63))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,71)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(71,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Rs71: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Rs71 = tb2t(set(int,int,t2tb(Rs70),t2tb1(71),t2tb1(63))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,72)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(72,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Rs72: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Rs72 = tb2t(set(int,int,t2tb(Rs71),t2tb1(72),t2tb1(72))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,73)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(73,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Rs73: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Rs73 = tb2t(set(int,int,t2tb(Rs72),t2tb1(73),t2tb1(72))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,74)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(74,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Rs74: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Rs74 = tb2t(set(int,int,t2tb(Rs73),t2tb1(74),t2tb1(72))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,75)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(75,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Rs75: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Rs75 = tb2t(set(int,int,t2tb(Rs74),t2tb1(75),t2tb1(72))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,76)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(76,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Rs76: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Rs76 = tb2t(set(int,int,t2tb(Rs75),t2tb1(76),t2tb1(72))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,77)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(77,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Rs77: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Rs77 = tb2t(set(int,int,t2tb(Rs76),t2tb1(77),t2tb1(72))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,78)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(78,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Rs78: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Rs78 = tb2t(set(int,int,t2tb(Rs77),t2tb1(78),t2tb1(72))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,79)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(79,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Rs79: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Rs79 = tb2t(set(int,int,t2tb(Rs78),t2tb1(79),t2tb1(72))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,80)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(80,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Rs80: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Rs80 = tb2t(set(int,int,t2tb(Rs79),t2tb1(80),t2tb1(72))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,0)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Ro: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Ro = tb2t(set(int,int,const(int,int,t2tb1(0)),t2tb1(0),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,1)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(1,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Ro1: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Ro1 = tb2t(set(int,int,t2tb(Ro),t2tb1(1),t2tb1(1))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,2)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(2,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Ro2: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Ro2 = tb2t(set(int,int,t2tb(Ro1),t2tb1(2),t2tb1(2))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,3)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(3,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Ro3: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Ro3 = tb2t(set(int,int,t2tb(Ro2),t2tb1(3),t2tb1(3))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,4)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(4,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Ro4: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Ro4 = tb2t(set(int,int,t2tb(Ro3),t2tb1(4),t2tb1(4))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,5)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(5,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Ro5: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Ro5 = tb2t(set(int,int,t2tb(Ro4),t2tb1(5),t2tb1(5))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,6)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(6,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Ro6: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Ro6 = tb2t(set(int,int,t2tb(Ro5),t2tb1(6),t2tb1(6))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,7)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(7,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Ro7: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Ro7 = tb2t(set(int,int,t2tb(Ro6),t2tb1(7),t2tb1(7))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,8)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(8,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Ro8: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Ro8 = tb2t(set(int,int,t2tb(Ro7),t2tb1(8),t2tb1(8))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,0)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Ss: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Ss = tb2t(set(int,int,const(int,int,t2tb1(0)),t2tb1(0),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,1)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(1,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Ss1: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Ss1 = tb2t(set(int,int,t2tb(Ss),t2tb1(1),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,2)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(2,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Ss2: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Ss2 = tb2t(set(int,int,t2tb(Ss1),t2tb1(2),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,3)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(3,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Ss3: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Ss3 = tb2t(set(int,int,t2tb(Ss2),t2tb1(3),t2tb1(3))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,4)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(4,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Ss4: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Ss4 = tb2t(set(int,int,t2tb(Ss3),t2tb1(4),t2tb1(3))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,5)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(5,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Ss5: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Ss5 = tb2t(set(int,int,t2tb(Ss4),t2tb1(5),t2tb1(3))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,6)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(6,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Ss6: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Ss6 = tb2t(set(int,int,t2tb(Ss5),t2tb1(6),t2tb1(6))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,7)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(7,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Ss7: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Ss7 = tb2t(set(int,int,t2tb(Ss6),t2tb1(7),t2tb1(6))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,8)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(8,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Ss8: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Ss8 = tb2t(set(int,int,t2tb(Ss7),t2tb1(8),t2tb1(6))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,9)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(9,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Ss9: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Ss9 = tb2t(set(int,int,t2tb(Ss8),t2tb1(9),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,10)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(10,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Ss10: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Ss10 = tb2t(set(int,int,t2tb(Ss9),t2tb1(10),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,11)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(11,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Ss11: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Ss11 = tb2t(set(int,int,t2tb(Ss10),t2tb1(11),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,12)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(12,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Ss12: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Ss12 = tb2t(set(int,int,t2tb(Ss11),t2tb1(12),t2tb1(3))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,13)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(13,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Ss13: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Ss13 = tb2t(set(int,int,t2tb(Ss12),t2tb1(13),t2tb1(3))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,14)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(14,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Ss14: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Ss14 = tb2t(set(int,int,t2tb(Ss13),t2tb1(14),t2tb1(3))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,15)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(15,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Ss15: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Ss15 = tb2t(set(int,int,t2tb(Ss14),t2tb1(15),t2tb1(6))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,16)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(16,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Ss16: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Ss16 = tb2t(set(int,int,t2tb(Ss15),t2tb1(16),t2tb1(6))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,17)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(17,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Ss17: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Ss17 = tb2t(set(int,int,t2tb(Ss16),t2tb1(17),t2tb1(6))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,18)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(18,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Ss18: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Ss18 = tb2t(set(int,int,t2tb(Ss17),t2tb1(18),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,19)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(19,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Ss19: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Ss19 = tb2t(set(int,int,t2tb(Ss18),t2tb1(19),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,20)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(20,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Ss20: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Ss20 = tb2t(set(int,int,t2tb(Ss19),t2tb1(20),t2tb1(0))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,21)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(21,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Ss21: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Ss21 = tb2t(set(int,int,t2tb(Ss20),t2tb1(21),t2tb1(3))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,22)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(22,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Ss22: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Ss22 = tb2t(set(int,int,t2tb(Ss21),t2tb1(22),t2tb1(3))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,23)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(23,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Ss23: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Ss23 = tb2t(set(int,int,t2tb(Ss22),t2tb1(23),t2tb1(3))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,24)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(24,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Ss24: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Ss24 = tb2t(set(int,int,t2tb(Ss23),t2tb1(24),t2tb1(6))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,25)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(25,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Ss25: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Ss25 = tb2t(set(int,int,t2tb(Ss24),t2tb1(25),t2tb1(6))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,26)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(26,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Ss26: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Ss26 = tb2t(set(int,int,t2tb(Ss25),t2tb1(26),t2tb1(6))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,27)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(27,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Ss27: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Ss27 = tb2t(set(int,int,t2tb(Ss26),t2tb1(27),t2tb1(27))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,28)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(28,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Ss28: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Ss28 = tb2t(set(int,int,t2tb(Ss27),t2tb1(28),t2tb1(27))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,29)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(29,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Ss29: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Ss29 = tb2t(set(int,int,t2tb(Ss28),t2tb1(29),t2tb1(27))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,30)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(30,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Ss30: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Ss30 = tb2t(set(int,int,t2tb(Ss29),t2tb1(30),t2tb1(30))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,31)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(31,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Ss31: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Ss31 = tb2t(set(int,int,t2tb(Ss30),t2tb1(31),t2tb1(30))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,32)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(32,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Ss32: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Ss32 = tb2t(set(int,int,t2tb(Ss31),t2tb1(32),t2tb1(30))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,33)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(33,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Ss33: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Ss33 = tb2t(set(int,int,t2tb(Ss32),t2tb1(33),t2tb1(33))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,34)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(34,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Ss34: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Ss34 = tb2t(set(int,int,t2tb(Ss33),t2tb1(34),t2tb1(33))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,35)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(35,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Ss35: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Ss35 = tb2t(set(int,int,t2tb(Ss34),t2tb1(35),t2tb1(33))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,36)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(36,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Ss36: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Ss36 = tb2t(set(int,int,t2tb(Ss35),t2tb1(36),t2tb1(27))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,37)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(37,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Ss37: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Ss37 = tb2t(set(int,int,t2tb(Ss36),t2tb1(37),t2tb1(27))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,38)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(38,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Ss38: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Ss38 = tb2t(set(int,int,t2tb(Ss37),t2tb1(38),t2tb1(27))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,39)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(39,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Ss39: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Ss39 = tb2t(set(int,int,t2tb(Ss38),t2tb1(39),t2tb1(30))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,40)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(40,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Ss40: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Ss40 = tb2t(set(int,int,t2tb(Ss39),t2tb1(40),t2tb1(30))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,41)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(41,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Ss41: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Ss41 = tb2t(set(int,int,t2tb(Ss40),t2tb1(41),t2tb1(30))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,42)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(42,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Ss42: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Ss42 = tb2t(set(int,int,t2tb(Ss41),t2tb1(42),t2tb1(33))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,43)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(43,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Ss43: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Ss43 = tb2t(set(int,int,t2tb(Ss42),t2tb1(43),t2tb1(33))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,44)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(44,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Ss44: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Ss44 = tb2t(set(int,int,t2tb(Ss43),t2tb1(44),t2tb1(33))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,45)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(45,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Ss45: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Ss45 = tb2t(set(int,int,t2tb(Ss44),t2tb1(45),t2tb1(27))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,46)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(46,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Ss46: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Ss46 = tb2t(set(int,int,t2tb(Ss45),t2tb1(46),t2tb1(27))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,47)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(47,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Ss47: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Ss47 = tb2t(set(int,int,t2tb(Ss46),t2tb1(47),t2tb1(27))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,48)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(48,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Ss48: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Ss48 = tb2t(set(int,int,t2tb(Ss47),t2tb1(48),t2tb1(30))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,49)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(49,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Ss49: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Ss49 = tb2t(set(int,int,t2tb(Ss48),t2tb1(49),t2tb1(30))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,50)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(50,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Ss50: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Ss50 = tb2t(set(int,int,t2tb(Ss49),t2tb1(50),t2tb1(30))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,51)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(51,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Ss51: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Ss51 = tb2t(set(int,int,t2tb(Ss50),t2tb1(51),t2tb1(33))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,52)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(52,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Ss52: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Ss52 = tb2t(set(int,int,t2tb(Ss51),t2tb1(52),t2tb1(33))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,53)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(53,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Ss53: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Ss53 = tb2t(set(int,int,t2tb(Ss52),t2tb1(53),t2tb1(33))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,54)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(54,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Ss54: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Ss54 = tb2t(set(int,int,t2tb(Ss53),t2tb1(54),t2tb1(54))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,55)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(55,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Ss55: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Ss55 = tb2t(set(int,int,t2tb(Ss54),t2tb1(55),t2tb1(54))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,56)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(56,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Ss56: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Ss56 = tb2t(set(int,int,t2tb(Ss55),t2tb1(56),t2tb1(54))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,57)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(57,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Ss57: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Ss57 = tb2t(set(int,int,t2tb(Ss56),t2tb1(57),t2tb1(57))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,58)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(58,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Ss58: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Ss58 = tb2t(set(int,int,t2tb(Ss57),t2tb1(58),t2tb1(57))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,59)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(59,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Ss59: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Ss59 = tb2t(set(int,int,t2tb(Ss58),t2tb1(59),t2tb1(57))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,60)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(60,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ! [Ss60: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ( Ss60 = tb2t(set(int,int,t2tb(Ss59),t2tb1(60),t2tb1(60))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           => ( $lesseq(0,61)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & $less(61,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              & ! [Ss61: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ( Ss61 = tb2t(set(int,int,t2tb(Ss60),t2tb1(61),t2tb1(60))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 => ( $lesseq(0,62)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & $less(62,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    & ! [Ss62: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ( Ss62 = tb2t(set(int,int,t2tb(Ss61),t2tb1(62),t2tb1(60))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       => ( $lesseq(0,63)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & $less(63,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          & ! [Ss63: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ( Ss63 = tb2t(set(int,int,t2tb(Ss62),t2tb1(63),t2tb1(54))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             => ( $lesseq(0,64)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & $less(64,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                & ! [Ss64: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ( Ss64 = tb2t(set(int,int,t2tb(Ss63),t2tb1(64),t2tb1(54))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   => ( $lesseq(0,65)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & $less(65,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      & ! [Ss65: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ( Ss65 = tb2t(set(int,int,t2tb(Ss64),t2tb1(65),t2tb1(54))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         => ( $lesseq(0,66)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & $less(66,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            & ! [Ss66: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ( Ss66 = tb2t(set(int,int,t2tb(Ss65),t2tb1(66),t2tb1(57))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               => ( $lesseq(0,67)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & $less(67,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  & ! [Ss67: map_int_int] :
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( ( $lesseq(0,81)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & ( Ss67 = tb2t(set(int,int,t2tb(Ss66),t2tb1(67),t2tb1(57))) ) )
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     => ( $lesseq(0,68)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        & $less(68,81)
                                                                                                                                                                                                                                       