%------------------------------------------------------------------------------
% File     : SWW563_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Java type soundness line 236
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : jinja_236 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  154 (  38 unt;  51 typ;   0 def)
%            Number of atoms       :  229 (  59 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  167 (  41   ~;   1   |;   7   &)
%                                         (  15 <=>; 103  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   19 (   8 avg)
%            Maximal term depth    :   15 (   3 avg)
%            Number of types       :    7 (   6 usr)
%            Number of type conns  :   65 (  33   >;  32   *;   0   +;   0  <<)
%            Number of predicates  :   14 (  13 usr;   0 prp; 1-5 aty)
%            Number of functors    :   32 (  32 usr;  11 con; 0-5 aty)
%            Number of variables   :  546 ( 520   !;   6   ?; 546   :)
%                                         (  20  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:18:40
%------------------------------------------------------------------------------
%----Should-be-implicit typings (11)
tff(ty_tc_Expr_Obop,type,
    bop: $tType ).

tff(ty_tc_Expr_Oexp,type,
    exp: $tType > $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Option_Ooption,type,
    option: $tType > $tType ).

tff(ty_tc_String_Ochar,type,
    char: $tType ).

tff(ty_tc_Type_Oty,type,
    ty: $tType ).

tff(ty_tc_Value_Oval,type,
    val1: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (40)
tff(sy_c_BigStep_Oeval,type,
    eval: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * exp(list(char)) * product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))) * exp(list(char)) * product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))) ) > $o ).

tff(sy_c_BigStep_Ofinal,type,
    final: 
      !>[A: $tType] : ( exp(A) > $o ) ).

tff(sy_c_Conform_Ohconf,type,
    hconf: 
      !>[M: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M)))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))) ) > $o ) ).

tff(sy_c_Conform_Olconf,type,
    lconf: 
      !>[M: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M)))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))) * fun(list(char),option(val1)) * fun(list(char),option(ty)) ) > $o ) ).

tff(sy_c_Exceptions_OOutOfMemory,type,
    outOfMemory: list(char) ).

tff(sy_c_Exceptions_Oaddr__of__sys__xcpt,type,
    addr_of_sys_xcpt: list(char) > nat ).

tff(sy_c_Expr_Oexp_OBinOp,type,
    binOp: 
      !>[A: $tType] : ( ( exp(A) * bop * exp(A) ) > exp(A) ) ).

tff(sy_c_Expr_Oexp_OBlock,type,
    block: 
      !>[A: $tType] : ( ( A * ty * exp(A) ) > exp(A) ) ).

tff(sy_c_Expr_Oexp_OVal,type,
    val: 
      !>[A: $tType] : ( val1 > exp(A) ) ).

tff(sy_c_Expr_Oexp_Onew,type,
    new: 
      !>[A: $tType] : ( list(char) > exp(A) ) ).

tff(sy_c_Expr_Oexp_Othrow,type,
    throw: 
      !>[A: $tType] : ( exp(A) > exp(A) ) ).

tff(sy_c_JWellForm_Owf__J__mdecl,type,
    wf_J_mdecl: fun(list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),fun(list(char),fun(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))),bool))) ).

tff(sy_c_Objects_Ohext,type,
    hext: ( fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))) ) > $o ).

tff(sy_c_Objects_Onew__Addr,type,
    new_Addr: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))) > option(nat) ).

tff(sy_c_Option_Ooption_ONone,type,
    none: 
      !>[A: $tType] : option(A) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B1: $tType] : ( ( A * B1 ) > product_prod(A,B1) ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B1: $tType,T2: $tType] : ( ( fun(A,fun(B1,T2)) * product_prod(A,B1) ) > T2 ) ).

tff(sy_c_SmallStep_Ored,type,
    red: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) > fun(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),bool) ).

tff(sy_c_SmallStep_Oredp,type,
    redp: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * exp(list(char)) * product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))) * exp(list(char)) * product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))) ) > $o ).

tff(sy_c_State_Ohp,type,
    hp: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))) > fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))) ).

tff(sy_c_Transitive__Closure_Ortrancl,type,
    transitive_rtrancl: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_TypeRel_Owiden,type,
    widen: 
      !>[M: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M)))))))) * ty * ty ) > $o ) ).

tff(sy_c_TypeSafe__Mirabelle__jrcojvmxyu_Osconf,type,
    typeSa976492716_sconf: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * fun(list(char),option(ty)) * product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))) ) > $o ).

tff(sy_c_Type_Ois__refT,type,
    is_refT: ty > $o ).

tff(sy_c_Value_Othe__Addr,type,
    the_Addr: val1 > nat ).

tff(sy_c_Value_Oval_OAddr,type,
    addr: nat > val1 ).

tff(sy_c_WWellForm_Owwf__J__mdecl,type,
    wwf_J_mdecl: fun(list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),fun(list(char),fun(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))),bool))) ).

tff(sy_c_WellForm_Owf__prog,type,
    wf_prog: 
      !>[M: $tType] : ( ( fun(list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M)))))))),fun(list(char),fun(product_prod(list(char),product_prod(list(ty),product_prod(ty,M))),bool))) * list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M)))))))) ) > $o ) ).

tff(sy_c_WellTypeRT_OWTrt,type,
    wTrt: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))) * fun(list(char),option(ty)) * exp(list(char)) * ty ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,B1) * A ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_C______,type,
    c: list(char) ).

tff(sy_v_E____,type,
    e: fun(list(char),option(ty)) ).

tff(sy_v_P,type,
    p: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) ).

tff(sy_v_T____,type,
    t: ty ).

tff(sy_v_ha______,type,
    ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))) ).

tff(sy_v_la______,type,
    la: fun(list(char),option(val1)) ).

%----Relevant facts (100)
tff(fact_0_RedNewFail_Ohyps,axiom,
    new_Addr(ha) = none(nat) ).

tff(fact_1_RedNewFail_I2_J,axiom,
    typeSa976492716_sconf(p,e,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)),ha,la)) ).

tff(fact_2_RedNewFail_I3_J,axiom,
    wTrt(p,ha,e,new(list(char),c),t) ).

tff(fact_3_assms,axiom,
    wf_prog(product_prod(list(list(char)),exp(list(char))),wf_J_mdecl,p) ).

tff(fact_4_widen__refl,axiom,
    ! [M: $tType,T1: ty,P1: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M))))))))] : widen(M,P1,T1,T1) ).

tff(fact_5_val_Osimps_I3_J,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( addr(Nat) = addr(Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_6_exp_Osimps_I14_J,axiom,
    ! [A: $tType,Exp5: exp(A),Exp4: exp(A)] :
      ( ( throw(A,Exp4) = throw(A,Exp5) )
    <=> ( Exp4 = Exp5 ) ) ).

tff(fact_7_exp_Osimps_I3_J,axiom,
    ! [A: $tType,Val3: val1,Val2: val1] :
      ( ( val(A,Val2) = val(A,Val3) )
    <=> ( Val2 = Val3 ) ) ).

tff(fact_8_exp_Osimps_I90_J,axiom,
    ! [A: $tType,Exp: exp(A),Val: val1] : ( val(A,Val) != throw(A,Exp) ) ).

tff(fact_9_exp_Osimps_I91_J,axiom,
    ! [A: $tType,Val: val1,Exp: exp(A)] : ( throw(A,Exp) != val(A,Val) ) ).

tff(fact_10_final__def,axiom,
    ! [A: $tType,Ea: exp(A)] :
      ( final(A,Ea)
    <=> ( ? [V3: val1] : ( Ea = val(A,V3) )
        | ? [A4: nat] : ( Ea = throw(A,val(A,addr(A4))) ) ) ) ).

tff(fact_11_widen__trans,axiom,
    ! [A: $tType,T1: ty,U1: ty,S4: ty,P1: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( widen(A,P1,S4,U1)
     => ( widen(A,P1,U1,T1)
       => widen(A,P1,S4,T1) ) ) ).

tff(fact_12_WTrtThrow,axiom,
    ! [Ta: ty,T_r1: ty,Ea: exp(list(char)),Ea1: fun(list(char),option(ty)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wTrt(Pa,Hb,Ea1,Ea,T_r1)
     => ( is_refT(T_r1)
       => wTrt(Pa,Hb,Ea1,throw(list(char),Ea),Ta) ) ) ).

tff(fact_13_finalE,axiom,
    ! [A: $tType,E3: exp(A)] :
      ( final(A,E3)
     => ( ! [V2: val1] : ( E3 != val(A,V2) )
       => ~ ! [A2: nat] : ( E3 != throw(A,val(A,addr(A2))) ) ) ) ).

tff(fact_14_redp__redsp_ORedNewFail,axiom,
    ! [Lb: fun(list(char),option(val1)),Ca: list(char),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1)))))] :
      ( ( new_Addr(Hb) = none(nat) )
     => redp(Pa,new(list(char),Ca),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)),Hb,Lb),throw(list(char),val(list(char),addr(addr_of_sys_xcpt(outOfMemory)))),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)),Hb,Lb)) ) ).

tff(fact_15_exp_Osimps_I1_J,axiom,
    ! [A: $tType,List2: list(char),List1: list(char)] :
      ( ( new(A,List1) = new(A,List2) )
    <=> ( List1 = List2 ) ) ).

tff(fact_16_redp__redsp_OThrowRed,axiom,
    ! [S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( redp(Pa,Ea,S,E_a,S1)
     => redp(Pa,throw(list(char),Ea),S,throw(list(char),E_a),S1) ) ).

tff(fact_17_redp__redsp_OThrowThrow,axiom,
    ! [S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] : redp(Pa,throw(list(char),throw(list(char),Ea)),S,throw(list(char),Ea),S) ).

tff(fact_18_exp_Osimps_I18_J,axiom,
    ! [A: $tType,Val1: val1,List: list(char)] : ( new(A,List) != val(A,Val1) ) ).

tff(fact_19_exp_Osimps_I19_J,axiom,
    ! [A: $tType,List: list(char),Val1: val1] : ( val(A,Val1) != new(A,List) ) ).

tff(fact_20_exp_Osimps_I41_J,axiom,
    ! [A: $tType,List: list(char),Exp: exp(A)] : ( throw(A,Exp) != new(A,List) ) ).

tff(fact_21_exp_Osimps_I40_J,axiom,
    ! [A: $tType,Exp: exp(A),List: list(char)] : ( new(A,List) != throw(A,Exp) ) ).

tff(fact_22_WTrt__elim__cases_I4_J,axiom,
    ! [Ta: ty,Ea: exp(list(char)),Ea1: fun(list(char),option(ty)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wTrt(Pa,Hb,Ea1,throw(list(char),Ea),Ta)
     => ~ ! [T_r: ty] :
            ( wTrt(Pa,Hb,Ea1,Ea,T_r)
           => ~ is_refT(T_r) ) ) ).

tff(fact_23_NewFail,axiom,
    ! [Lb: fun(list(char),option(val1)),Ca: list(char),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1)))))] :
      ( ( new_Addr(Hb) = none(nat) )
     => eval(Pa,new(list(char),Ca),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)),Hb,Lb),throw(list(char),val(list(char),addr(addr_of_sys_xcpt(outOfMemory)))),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)),Hb,Lb)) ) ).

tff(fact_24_split__paired__All,axiom,
    ! [A: $tType,B1: $tType,Pa: fun(product_prod(A,B1),bool)] :
      ( ! [X11: product_prod(A,B1)] : pp(aa(product_prod(A,B1),bool,Pa,X11))
    <=> ! [A4: A,B3: B1] : pp(aa(product_prod(A,B1),bool,Pa,product_Pair(A,B1,A4,B3))) ) ).

tff(fact_25_Pair__eq,axiom,
    ! [A: $tType,B1: $tType,B6: B1,A7: A,B: B1,A1: A] :
      ( ( product_Pair(A,B1,A1,B) = product_Pair(A,B1,A7,B6) )
    <=> ( ( A1 = A7 )
        & ( B = B6 ) ) ) ).

tff(fact_26_the__Addr_Osimps,axiom,
    ! [A5: nat] : ( the_Addr(addr(A5)) = A5 ) ).

tff(fact_27_pred__equals__eq2,axiom,
    ! [B1: $tType,A: $tType,S3: fun(product_prod(A,B1),bool),R1: fun(product_prod(A,B1),bool)] :
      ( ! [X3: A,Xa2: B1] :
          ( member(product_prod(A,B1),product_Pair(A,B1,X3,Xa2),R1)
        <=> member(product_prod(A,B1),product_Pair(A,B1,X3,Xa2),S3) )
    <=> ( R1 = S3 ) ) ).

tff(fact_28_redp__redsp_OBlockThrow,axiom,
    ! [S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),A1: nat,Ta: ty,V: list(char),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] : redp(Pa,block(list(char),V,Ta,throw(list(char),val(list(char),addr(A1)))),S,throw(list(char),val(list(char),addr(A1))),S) ).

tff(fact_29_red__reds_ORedNewFail,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),Lb: fun(list(char),option(val1)),Ca: list(char),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1)))))] :
      ( ( new_Addr(Hb) = none(nat) )
     => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),new(list(char),Ca),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)),Hb,Lb)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),throw(list(char),val(list(char),addr(addr_of_sys_xcpt(outOfMemory)))),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)),Hb,Lb))),red(Pa)) ) ).

tff(fact_30_exp_Osimps_I10_J,axiom,
    ! [A: $tType,Exp5: exp(A),Ty3: ty,A7: A,Exp4: exp(A),Ty2: ty,A1: A] :
      ( ( block(A,A1,Ty2,Exp4) = block(A,A7,Ty3,Exp5) )
    <=> ( ( A1 = A7 )
        & ( Ty2 = Ty3 )
        & ( Exp4 = Exp5 ) ) ) ).

tff(fact_31_redp__red__eq,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),X2: exp(list(char)),Xa1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Xb1: exp(list(char)),Xc: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))] :
      ( redp(Pa,X2,Xa1,Xb1,Xc)
    <=> member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),X2,Xa1),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Xb1,Xc)),red(Pa)) ) ).

tff(fact_32_red__reds_OThrowThrow,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea: exp(list(char))] : member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),throw(list(char),throw(list(char),Ea)),S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),throw(list(char),Ea),S)),red(Pa)) ).

tff(fact_33_red__reds_ORedBlock,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),U: val1,Ta: ty,V: list(char)] : member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),block(list(char),V,Ta,val(list(char),U)),S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),val(list(char),U),S)),red(Pa)) ).

tff(fact_34_eval__finalId,axiom,
    ! [S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),Ea: exp(list(char))] :
      ( final(list(char),Ea)
     => eval(Pa,Ea,S,Ea,S) ) ).

tff(fact_35_red__reds_OThrowRed,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea,S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a,S1)),red(Pa))
     => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),throw(list(char),Ea),S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),throw(list(char),E_a),S1)),red(Pa)) ) ).

tff(fact_36_eval__final,axiom,
    ! [S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( eval(Pa,Ea,S,E_a,S1)
     => final(list(char),E_a) ) ).

tff(fact_37_red__reds_OBlockThrow,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),A1: nat,Ta: ty,V: list(char)] : member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),block(list(char),V,Ta,throw(list(char),val(list(char),addr(A1)))),S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),throw(list(char),val(list(char),addr(A1))),S)),red(Pa)) ).

tff(fact_38_Val,axiom,
    ! [S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),V1: val1,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] : eval(Pa,val(list(char),V1),S,val(list(char),V1),S) ).

tff(fact_39_eval__cases_I2_J,axiom,
    ! [S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),V1: val1,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( eval(Pa,val(list(char),V1),S,E_a,S1)
     => ~ ( ( E_a = val(list(char),V1) )
         => ( S1 != S ) ) ) ).

tff(fact_40_eval__evals_OThrowThrow,axiom,
    ! [S_1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a: exp(list(char)),S_0: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( eval(Pa,Ea,S_0,throw(list(char),E_a),S_1)
     => eval(Pa,throw(list(char),Ea),S_0,throw(list(char),E_a),S_1) ) ).

tff(fact_41_exp_Osimps_I82_J,axiom,
    ! [A: $tType,Exp: exp(A),Ty: ty,A6: A,Val: val1] : ( val(A,Val) != block(A,A6,Ty,Exp) ) ).

tff(fact_42_exp_Osimps_I83_J,axiom,
    ! [A: $tType,Val: val1,Exp: exp(A),Ty: ty,A6: A] : ( block(A,A6,Ty,Exp) != val(A,Val) ) ).

tff(fact_43_exp_Osimps_I203_J,axiom,
    ! [A: $tType,Exp3: exp(A),Ty1: ty,A5: A,Exp: exp(A)] : ( throw(A,Exp) != block(A,A5,Ty1,Exp3) ) ).

tff(fact_44_exp_Osimps_I202_J,axiom,
    ! [A: $tType,Exp: exp(A),Exp3: exp(A),Ty1: ty,A5: A] : ( block(A,A5,Ty1,Exp3) != throw(A,Exp) ) ).

tff(fact_45_exp_Osimps_I33_J,axiom,
    ! [A: $tType,List: list(char),Exp: exp(A),Ty: ty,A6: A] : ( block(A,A6,Ty,Exp) != new(A,List) ) ).

tff(fact_46_exp_Osimps_I32_J,axiom,
    ! [A: $tType,Exp: exp(A),Ty: ty,A6: A,List: list(char)] : ( new(A,List) != block(A,A6,Ty,Exp) ) ).

tff(fact_47_redp__redsp_ORedBlock,axiom,
    ! [S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),U: val1,Ta: ty,V: list(char),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] : redp(Pa,block(list(char),V,Ta,val(list(char),U)),S,val(list(char),U),S) ).

tff(fact_48_Throw,axiom,
    ! [S_1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),A1: nat,S_0: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( eval(Pa,Ea,S_0,val(list(char),addr(A1)),S_1)
     => eval(Pa,throw(list(char),Ea),S_0,throw(list(char),val(list(char),addr(A1))),S_1) ) ).

tff(fact_49_Pair__inject,axiom,
    ! [A: $tType,B1: $tType,B5: B1,A6: A,B4: B1,A5: A] :
      ( ( product_Pair(A,B1,A5,B4) = product_Pair(A,B1,A6,B5) )
     => ~ ( ( A5 = A6 )
         => ( B4 != B5 ) ) ) ).

tff(fact_50_prod__cases4,axiom,
    ! [A: $tType,B1: $tType,C2: $tType,D: $tType,Y1: product_prod(A,product_prod(B1,product_prod(C2,D)))] :
      ~ ! [A2: A,B2: B1,C3: C2,D1: D] : ( Y1 != product_Pair(A,product_prod(B1,product_prod(C2,D)),A2,product_Pair(B1,product_prod(C2,D),B2,product_Pair(C2,D,C3,D1))) ) ).

tff(fact_51_prod__induct4,axiom,
    ! [D: $tType,C2: $tType,B1: $tType,A: $tType,X: product_prod(A,product_prod(B1,product_prod(C2,D))),Pa: fun(product_prod(A,product_prod(B1,product_prod(C2,D))),bool)] :
      ( ! [A2: A,B2: B1,C3: C2,D1: D] : pp(aa(product_prod(A,product_prod(B1,product_prod(C2,D))),bool,Pa,product_Pair(A,product_prod(B1,product_prod(C2,D)),A2,product_Pair(B1,product_prod(C2,D),B2,product_Pair(C2,D,C3,D1)))))
     => pp(aa(product_prod(A,product_prod(B1,product_prod(C2,D))),bool,Pa,X)) ) ).

tff(fact_52_prod__cases5,axiom,
    ! [A: $tType,B1: $tType,C2: $tType,D: $tType,E1: $tType,Y1: product_prod(A,product_prod(B1,product_prod(C2,product_prod(D,E1))))] :
      ~ ! [A2: A,B2: B1,C3: C2,D1: D,E2: E1] : ( Y1 != product_Pair(A,product_prod(B1,product_prod(C2,product_prod(D,E1))),A2,product_Pair(B1,product_prod(C2,product_prod(D,E1)),B2,product_Pair(C2,product_prod(D,E1),C3,product_Pair(D,E1,D1,E2)))) ) ).

tff(fact_53_prod__induct5,axiom,
    ! [E1: $tType,D: $tType,C2: $tType,B1: $tType,A: $tType,X: product_prod(A,product_prod(B1,product_prod(C2,product_prod(D,E1)))),Pa: fun(product_prod(A,product_prod(B1,product_prod(C2,product_prod(D,E1)))),bool)] :
      ( ! [A2: A,B2: B1,C3: C2,D1: D,E2: E1] : pp(aa(product_prod(A,product_prod(B1,product_prod(C2,product_prod(D,E1)))),bool,Pa,product_Pair(A,product_prod(B1,product_prod(C2,product_prod(D,E1))),A2,product_Pair(B1,product_prod(C2,product_prod(D,E1)),B2,product_Pair(C2,product_prod(D,E1),C3,product_Pair(D,E1,D1,E2))))))
     => pp(aa(product_prod(A,product_prod(B1,product_prod(C2,product_prod(D,E1)))),bool,Pa,X)) ) ).

tff(fact_54_prod__cases6,axiom,
    ! [A: $tType,B1: $tType,C2: $tType,D: $tType,E1: $tType,F2: $tType,Y1: product_prod(A,product_prod(B1,product_prod(C2,product_prod(D,product_prod(E1,F2)))))] :
      ~ ! [A2: A,B2: B1,C3: C2,D1: D,E2: E1,F3: F2] : ( Y1 != product_Pair(A,product_prod(B1,product_prod(C2,product_prod(D,product_prod(E1,F2)))),A2,product_Pair(B1,product_prod(C2,product_prod(D,product_prod(E1,F2))),B2,product_Pair(C2,product_prod(D,product_prod(E1,F2)),C3,product_Pair(D,product_prod(E1,F2),D1,product_Pair(E1,F2,E2,F3))))) ) ).

tff(fact_55_prod__induct6,axiom,
    ! [F2: $tType,E1: $tType,D: $tType,C2: $tType,B1: $tType,A: $tType,X: product_prod(A,product_prod(B1,product_prod(C2,product_prod(D,product_prod(E1,F2))))),Pa: fun(product_prod(A,product_prod(B1,product_prod(C2,product_prod(D,product_prod(E1,F2))))),bool)] :
      ( ! [A2: A,B2: B1,C3: C2,D1: D,E2: E1,F3: F2] : pp(aa(product_prod(A,product_prod(B1,product_prod(C2,product_prod(D,product_prod(E1,F2))))),bool,Pa,product_Pair(A,product_prod(B1,product_prod(C2,product_prod(D,product_prod(E1,F2)))),A2,product_Pair(B1,product_prod(C2,product_prod(D,product_prod(E1,F2))),B2,product_Pair(C2,product_prod(D,product_prod(E1,F2)),C3,product_Pair(D,product_prod(E1,F2),D1,product_Pair(E1,F2,E2,F3)))))))
     => pp(aa(product_prod(A,product_prod(B1,product_prod(C2,product_prod(D,product_prod(E1,F2))))),bool,Pa,X)) ) ).

tff(fact_56_split__paired__Ex,axiom,
    ! [A: $tType,B1: $tType,Pa: fun(product_prod(A,B1),bool)] :
      ( ? [X11: product_prod(A,B1)] : pp(aa(product_prod(A,B1),bool,Pa,X11))
    <=> ? [A4: A,B3: B1] : pp(aa(product_prod(A,B1),bool,Pa,product_Pair(A,B1,A4,B3))) ) ).

tff(fact_57_red__preserves__hconf,axiom,
    ! [Ta: ty,Ea1: fun(list(char),option(ty)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L_a: fun(list(char),option(val1)),H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),E_a: exp(list(char)),Lb: fun(list(char),option(val1)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),Ea: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)),Hb,Lb)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)),H_a,L_a))),red(Pa))
     => ( wTrt(Pa,Hb,Ea1,Ea,Ta)
       => ( hconf(product_prod(list(list(char)),exp(list(char))),Pa,Hb)
         => hconf(product_prod(list(list(char)),exp(list(char))),Pa,H_a) ) ) ) ).

tff(fact_58_red__preserves__lconf,axiom,
    ! [Ta: ty,Ea1: fun(list(char),option(ty)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L_a: fun(list(char),option(val1)),H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),E_a: exp(list(char)),Lb: fun(list(char),option(val1)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),Ea: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)),Hb,Lb)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)),H_a,L_a))),red(Pa))
     => ( wTrt(Pa,Hb,Ea1,Ea,Ta)
       => ( lconf(product_prod(list(list(char)),exp(list(char))),Pa,Hb,Lb,Ea1)
         => lconf(product_prod(list(list(char)),exp(list(char))),Pa,H_a,L_a,Ea1) ) ) ) ).

tff(fact_59_prod__cases3,axiom,
    ! [A: $tType,B1: $tType,C2: $tType,Y1: product_prod(A,product_prod(B1,C2))] :
      ~ ! [A2: A,B2: B1,C3: C2] : ( Y1 != product_Pair(A,product_prod(B1,C2),A2,product_Pair(B1,C2,B2,C3)) ) ).

tff(fact_60_prod__induct3,axiom,
    ! [C2: $tType,B1: $tType,A: $tType,X: product_prod(A,product_prod(B1,C2)),Pa: fun(product_prod(A,product_prod(B1,C2)),bool)] :
      ( ! [A2: A,B2: B1,C3: C2] : pp(aa(product_prod(A,product_prod(B1,C2)),bool,Pa,product_Pair(A,product_prod(B1,C2),A2,product_Pair(B1,C2,B2,C3))))
     => pp(aa(product_prod(A,product_prod(B1,C2)),bool,Pa,X)) ) ).

tff(fact_61_red__preserves__sconf,axiom,
    ! [Ta: ty,Ea1: fun(list(char),option(ty)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea,S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a,S1)),red(Pa))
     => ( wTrt(Pa,hp(S),Ea1,Ea,Ta)
       => ( typeSa976492716_sconf(Pa,Ea1,S)
         => typeSa976492716_sconf(Pa,Ea1,S1) ) ) ) ).

tff(fact_62_prod_Orecs,axiom,
    ! [B1: $tType,A: $tType,C2: $tType,B: C2,A1: B1,F1: fun(B1,fun(C2,A))] : ( product_prod_rec(B1,C2,A,F1,product_Pair(B1,C2,A1,B)) = aa(C2,A,aa(B1,fun(C2,A),F1,A1),B) ) ).

tff(fact_63_red__hext__incr,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L_a: fun(list(char),option(val1)),H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),E_a: exp(list(char)),Lb: fun(list(char),option(val1)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),Ea: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)),Hb,Lb)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)),H_a,L_a))),red(Pa))
     => hext(Hb,H_a) ) ).

tff(fact_64_extend__1__eval,axiom,
    ! [S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a: exp(list(char)),S2: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wf_prog(product_prod(list(list(char)),exp(list(char))),wwf_J_mdecl,Pa)
     => ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea,S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E,S2)),red(Pa))
       => ( eval(Pa,E,S2,E_a,S1)
         => eval(Pa,Ea,S,E_a,S1) ) ) ) ).

tff(fact_65_WTrt__hext__mono,axiom,
    ! [H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),Ta: ty,Ea: exp(list(char)),Ea1: fun(list(char),option(ty)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wTrt(Pa,Hb,Ea1,Ea,Ta)
     => ( hext(Hb,H_a)
       => wTrt(Pa,H_a,Ea1,Ea,Ta) ) ) ).

tff(fact_66_eval__hext,axiom,
    ! [L_a: fun(list(char),option(val1)),H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),E_a: exp(list(char)),Lb: fun(list(char),option(val1)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),Ea: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( eval(Pa,Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)),Hb,Lb),E_a,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)),H_a,L_a))
     => hext(Hb,H_a) ) ).

tff(fact_67_wf__prog__wwf__prog,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wf_prog(product_prod(list(list(char)),exp(list(char))),wf_J_mdecl,Pa)
     => wf_prog(product_prod(list(list(char)),exp(list(char))),wwf_J_mdecl,Pa) ) ).

tff(fact_68_hext__refl,axiom,
    ! [Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1)))))] : hext(Hb,Hb) ).

tff(fact_69_wf__mdecl__wwf__mdecl,axiom,
    ! [Md: product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))),C1: list(char),P1: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( pp(aa(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))),bool,aa(list(char),fun(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))),bool),aa(list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),fun(list(char),fun(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))),bool)),wf_J_mdecl,P1),C1),Md))
     => pp(aa(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))),bool,aa(list(char),fun(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))),bool),aa(list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),fun(list(char),fun(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))),bool)),wwf_J_mdecl,P1),C1),Md)) ) ).

tff(fact_70_hext__trans,axiom,
    ! [H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1)))))] :
      ( hext(Hb,H_a)
     => ( hext(H_a,H)
       => hext(Hb,H) ) ) ).

tff(fact_71_lconf__hext,axiom,
    ! [A: $tType,H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),Ea1: fun(list(char),option(ty)),Lb: fun(list(char),option(val1)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( lconf(A,Pa,Hb,Lb,Ea1)
     => ( hext(Hb,H_a)
       => lconf(A,Pa,H_a,Lb,Ea1) ) ) ).

tff(fact_72_small__by__big,axiom,
    ! [S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wf_prog(product_prod(list(list(char)),exp(list(char))),wwf_J_mdecl,Pa)
     => ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea,S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a,S1)),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),red(Pa)))
       => ( final(list(char),E_a)
         => eval(Pa,Ea,S,E_a,S1) ) ) ) ).

tff(fact_73_big__iff__small,axiom,
    ! [S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wf_prog(product_prod(list(list(char)),exp(list(char))),wwf_J_mdecl,Pa)
     => ( eval(Pa,Ea,S,E_a,S1)
      <=> ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea,S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a,S1)),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),red(Pa)))
          & final(list(char),E_a) ) ) ) ).

tff(fact_74_ThrowReds,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea,S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a,S1)),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),red(Pa)))
     => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),throw(list(char),Ea),S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),throw(list(char),E_a),S1)),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),red(Pa))) ) ).

tff(fact_75_ext,axiom,
    ! [B1: $tType,A: $tType,G: fun(A,B1),F: fun(A,B1)] :
      ( ! [X1: A] : ( aa(A,B1,F,X1) = aa(A,B1,G,X1) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A3: fun(A,bool),X: A] :
      ( member(A,X,A3)
    <=> pp(aa(A,bool,A3,X)) ) ).

tff(fact_77_ThrowRedsThrow,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),A1: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea,S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),throw(list(char),A1),S1)),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),red(Pa)))
     => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),throw(list(char),Ea),S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),throw(list(char),A1),S1)),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),red(Pa))) ) ).

tff(fact_78_extend__eval,axiom,
    ! [S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a: exp(list(char)),S2: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wf_prog(product_prod(list(list(char)),exp(list(char))),wwf_J_mdecl,Pa)
     => ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea,S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E,S2)),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),red(Pa)))
       => ( eval(Pa,E,S2,E_a,S1)
         => eval(Pa,Ea,S,E_a,S1) ) ) ) ).

tff(fact_79_big__by__small,axiom,
    ! [S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wf_prog(product_prod(list(list(char)),exp(list(char))),wwf_J_mdecl,Pa)
     => ( eval(Pa,Ea,S,E_a,S1)
       => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea,S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a,S1)),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),red(Pa))) ) ) ).

tff(fact_80_rtrancl_Ortrancl__refl,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),A1: A] : member(product_prod(A,A),product_Pair(A,A,A1,A1),transitive_rtrancl(A,R)) ).

tff(fact_81_r__into__rtrancl,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),P: product_prod(A,A)] :
      ( member(product_prod(A,A),P,R)
     => member(product_prod(A,A),P,transitive_rtrancl(A,R)) ) ).

tff(fact_82_rtrancl__idemp,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] : ( transitive_rtrancl(A,transitive_rtrancl(A,R)) = transitive_rtrancl(A,R) ) ).

tff(fact_83_rtrancl__trans,axiom,
    ! [A: $tType,C: A,R: fun(product_prod(A,A),bool),B: A,A1: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A1,B),transitive_rtrancl(A,R))
     => ( member(product_prod(A,A),product_Pair(A,A,B,C),transitive_rtrancl(A,R))
       => member(product_prod(A,A),product_Pair(A,A,A1,C),transitive_rtrancl(A,R)) ) ) ).

tff(fact_84_rtrancl_Ortrancl__into__rtrancl,axiom,
    ! [A: $tType,C: A,R: fun(product_prod(A,A),bool),B: A,A1: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A1,B),transitive_rtrancl(A,R))
     => ( member(product_prod(A,A),product_Pair(A,A,B,C),R)
       => member(product_prod(A,A),product_Pair(A,A,A1,C),transitive_rtrancl(A,R)) ) ) ).

tff(fact_85_converse__rtrancl__into__rtrancl,axiom,
    ! [A: $tType,C: A,R: fun(product_prod(A,A),bool),B: A,A1: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A1,B),R)
     => ( member(product_prod(A,A),product_Pair(A,A,B,C),transitive_rtrancl(A,R))
       => member(product_prod(A,A),product_Pair(A,A,A1,C),transitive_rtrancl(A,R)) ) ) ).

tff(fact_86_rtrancl__induct2,axiom,
    ! [A: $tType,B1: $tType,Pa: fun(A,fun(B1,bool)),R: fun(product_prod(product_prod(A,B1),product_prod(A,B1)),bool),By: B1,Bx: A,Ay: B1,Ax: A] :
      ( member(product_prod(product_prod(A,B1),product_prod(A,B1)),product_Pair(product_prod(A,B1),product_prod(A,B1),product_Pair(A,B1,Ax,Ay),product_Pair(A,B1,Bx,By)),transitive_rtrancl(product_prod(A,B1),R))
     => ( pp(aa(B1,bool,aa(A,fun(B1,bool),Pa,Ax),Ay))
       => ( ! [A2: A,B2: B1,Aa: A,Ba: B1] :
              ( member(product_prod(product_prod(A,B1),product_prod(A,B1)),product_Pair(product_prod(A,B1),product_prod(A,B1),product_Pair(A,B1,Ax,Ay),product_Pair(A,B1,A2,B2)),transitive_rtrancl(product_prod(A,B1),R))
             => ( member(product_prod(product_prod(A,B1),product_prod(A,B1)),product_Pair(product_prod(A,B1),product_prod(A,B1),product_Pair(A,B1,A2,B2),product_Pair(A,B1,Aa,Ba)),R)
               => ( pp(aa(B1,bool,aa(A,fun(B1,bool),Pa,A2),B2))
                 => pp(aa(B1,bool,aa(A,fun(B1,bool),Pa,Aa),Ba)) ) ) )
         => pp(aa(B1,bool,aa(A,fun(B1,bool),Pa,Bx),By)) ) ) ) ).

tff(fact_87_converse__rtrancl__induct2,axiom,
    ! [A: $tType,B1: $tType,Pa: fun(A,fun(B1,bool)),R: fun(product_prod(product_prod(A,B1),product_prod(A,B1)),bool),By: B1,Bx: A,Ay: B1,Ax: A] :
      ( member(product_prod(product_prod(A,B1),product_prod(A,B1)),product_Pair(product_prod(A,B1),product_prod(A,B1),product_Pair(A,B1,Ax,Ay),product_Pair(A,B1,Bx,By)),transitive_rtrancl(product_prod(A,B1),R))
     => ( pp(aa(B1,bool,aa(A,fun(B1,bool),Pa,Bx),By))
       => ( ! [A2: A,B2: B1,Aa: A,Ba: B1] :
              ( member(product_prod(product_prod(A,B1),product_prod(A,B1)),product_Pair(product_prod(A,B1),product_prod(A,B1),product_Pair(A,B1,A2,B2),product_Pair(A,B1,Aa,Ba)),R)
             => ( member(product_prod(product_prod(A,B1),product_prod(A,B1)),product_Pair(product_prod(A,B1),product_prod(A,B1),product_Pair(A,B1,Aa,Ba),product_Pair(A,B1,Bx,By)),transitive_rtrancl(product_prod(A,B1),R))
               => ( pp(aa(B1,bool,aa(A,fun(B1,bool),Pa,Aa),Ba))
                 => pp(aa(B1,bool,aa(A,fun(B1,bool),Pa,A2),B2)) ) ) )
         => pp(aa(B1,bool,aa(A,fun(B1,bool),Pa,Ax),Ay)) ) ) ) ).

tff(fact_88_converse__rtranclE2,axiom,
    ! [B1: $tType,A: $tType,R: fun(product_prod(product_prod(A,B1),product_prod(A,B1)),bool),Zb: B1,Za: A,Xb: B1,Xa: A] :
      ( member(product_prod(product_prod(A,B1),product_prod(A,B1)),product_Pair(product_prod(A,B1),product_prod(A,B1),product_Pair(A,B1,Xa,Xb),product_Pair(A,B1,Za,Zb)),transitive_rtrancl(product_prod(A,B1),R))
     => ( ( product_Pair(A,B1,Xa,Xb) != product_Pair(A,B1,Za,Zb) )
       => ~ ! [A2: A,B2: B1] :
              ( member(product_prod(product_prod(A,B1),product_prod(A,B1)),product_Pair(product_prod(A,B1),product_prod(A,B1),product_Pair(A,B1,Xa,Xb),product_Pair(A,B1,A2,B2)),R)
             => ~ member(product_prod(product_prod(A,B1),product_prod(A,B1)),product_Pair(product_prod(A,B1),product_prod(A,B1),product_Pair(A,B1,A2,B2),product_Pair(A,B1,Za,Zb)),transitive_rtrancl(product_prod(A,B1),R)) ) ) ) ).

tff(fact_89_rtrancl__induct,axiom,
    ! [A: $tType,Pa: fun(A,bool),R: fun(product_prod(A,A),bool),B: A,A1: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A1,B),transitive_rtrancl(A,R))
     => ( pp(aa(A,bool,Pa,A1))
       => ( ! [Y: A,Z: A] :
              ( member(product_prod(A,A),product_Pair(A,A,A1,Y),transitive_rtrancl(A,R))
             => ( member(product_prod(A,A),product_Pair(A,A,Y,Z),R)
               => ( pp(aa(A,bool,Pa,Y))
                 => pp(aa(A,bool,Pa,Z)) ) ) )
         => pp(aa(A,bool,Pa,B)) ) ) ) ).

tff(fact_90_rtranclE,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),B: A,A1: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A1,B),transitive_rtrancl(A,R))
     => ( ( A1 != B )
       => ~ ! [Y: A] :
              ( member(product_prod(A,A),product_Pair(A,A,A1,Y),transitive_rtrancl(A,R))
             => ~ member(product_prod(A,A),product_Pair(A,A,Y,B),R) ) ) ) ).

tff(fact_91_converse__rtranclE,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),Z1: A,X: A] :
      ( member(product_prod(A,A),product_Pair(A,A,X,Z1),transitive_rtrancl(A,R))
     => ( ( X != Z1 )
       => ~ ! [Y: A] :
              ( member(product_prod(A,A),product_Pair(A,A,X,Y),R)
             => ~ member(product_prod(A,A),product_Pair(A,A,Y,Z1),transitive_rtrancl(A,R)) ) ) ) ).

tff(fact_92_converse__rtrancl__induct,axiom,
    ! [A: $tType,Pa: fun(A,bool),R: fun(product_prod(A,A),bool),B: A,A1: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A1,B),transitive_rtrancl(A,R))
     => ( pp(aa(A,bool,Pa,B))
       => ( ! [Y: A,Z: A] :
              ( member(product_prod(A,A),product_Pair(A,A,Y,Z),R)
             => ( member(product_prod(A,A),product_Pair(A,A,Z,B),transitive_rtrancl(A,R))
               => ( pp(aa(A,bool,Pa,Z))
                 => pp(aa(A,bool,Pa,Y)) ) ) )
         => pp(aa(A,bool,Pa,A1)) ) ) ) ).

tff(fact_93_BinOpRedsThrow2,axiom,
    ! [Bop1: bop,S_2: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea: exp(list(char)),E_2: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S_1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),V_1: val1,S_0: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_1: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_1,S_0),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),val(list(char),V_1),S_1)),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),red(Pa)))
     => ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_2,S_1),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),throw(list(char),Ea),S_2)),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),red(Pa)))
       => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),binOp(list(char),E_1,Bop1,E_2),S_0),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),throw(list(char),Ea),S_2)),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1)))),red(Pa))) ) ) ).

tff(fact_94_exp_Osimps_I4_J,axiom,
    ! [A: $tType,Exp22: exp(A),Bop2: bop,Exp12: exp(A),Exp21: exp(A),Bop1: bop,Exp11: exp(A)] :
      ( ( binOp(A,Exp11,Bop1,Exp21) = binOp(A,Exp12,Bop2,Exp22) )
    <=> ( ( Exp11 = Exp12 )
        & ( Bop1 = Bop2 )
        & ( Exp21 = Exp22 ) ) ) ).

tff(fact_95_eval__evals_OBinOpThrow1,axiom,
    ! [E_2: exp(list(char)),Bop1: bop,S_1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea: exp(list(char)),S_0: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_1: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( eval(Pa,E_1,S_0,throw(list(char),Ea),S_1)
     => eval(Pa,binOp(list(char),E_1,Bop1,E_2),S_0,throw(list(char),Ea),S_1) ) ).

tff(fact_96_redp__redsp_OBinOpRed2,axiom,
    ! [Bop1: bop,V_1: val1,S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_a: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),Ea: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( redp(Pa,Ea,S,E_a,S1)
     => redp(Pa,binOp(list(char),val(list(char),V_1),Bop1,Ea),S,binOp(list(char),val(list(char),V_1),Bop1,E_a),S1) ) ).

tff(fact_97_redp__redsp_OBinOpThrow1,axiom,
    ! [S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val1))))),fun(list(char),option(val1))),E_2: exp(list(char)),Bop1: bop,Ea: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] : redp(Pa,binOp(list(char),throw(list(char),Ea),Bop1,E_2),S,throw(list(char),Ea),S) ).

tff(fact_98_exp_Osimps_I21_J,axiom,
    ! [A: $tType,List: list(char),Exp2: exp(A),Bop: bop,Exp1: exp(A)] : ( binOp(A,Exp1,Bop,Exp2) != new(A,List) ) ).

tff(fact_99_exp_Osimps_I20_J,axiom,
    ! [A: $tType,Exp2: exp(A),Bop: bop,Exp1: exp(A),List: list(char)] : ( new(A,List) != binOp(A,Exp1,Bop,Exp2) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ? [T: ty] :
      ( wTrt(p,ha,e,throw(list(char),val(list(char),addr(addr_of_sys_xcpt(outOfMemory)))),T)
      & widen(product_prod(list(list(char)),exp(list(char))),p,T,t) ) ).

%------------------------------------------------------------------------------
