%------------------------------------------------------------------------------
% File     : SWW562_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Java type soundness line 227
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : jinja_227 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  179 (  43 unt;  70 typ;   0 def)
%            Number of atoms       :  234 ( 105 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  159 (  34   ~;   8   |;  24   &)
%                                         (  27 <=>;  66  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   18 (   7 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   87 (  38   >;  49   *;   0   +;   0  <<)
%            Number of predicates  :   13 (  12 usr;   0 prp; 1-8 aty)
%            Number of functors    :   53 (  53 usr;  21 con; 0-5 aty)
%            Number of variables   :  575 ( 519   !;  18   ?; 575   :)
%                                         (  38  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:18:30
%------------------------------------------------------------------------------
%----Should-be-implicit typings (10)
tff(ty_tc_Expr_Oexp,type,
    exp: $tType > $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Option_Ooption,type,
    option: $tType > $tType ).

tff(ty_tc_String_Ochar,type,
    char: $tType ).

tff(ty_tc_Type_Oty,type,
    ty: $tType ).

tff(ty_tc_Value_Oval,type,
    val: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (60)
tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_Expr_Oexp_OCall,type,
    call: 
      !>[A: $tType] : ( ( exp(A) * list(char) * list(exp(A)) ) > exp(A) ) ).

tff(sy_c_Expr_Oexp_OFAcc,type,
    fAcc: 
      !>[A: $tType] : ( ( exp(A) * list(char) * list(char) ) > exp(A) ) ).

tff(sy_c_Expr_Oexp_OVal,type,
    val1: 
      !>[A: $tType] : fun(val,exp(A)) ).

tff(sy_c_JWellForm_Owf__J__mdecl,type,
    wf_J_mdecl: fun(list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),fun(list(char),fun(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))),bool))) ).

tff(sy_c_List_Olex,type,
    lex: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > fun(product_prod(list(A),list(A)),bool) ) ).

tff(sy_c_List_Olexord,type,
    lexord: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > fun(product_prod(list(A),list(A)),bool) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist__all2,type,
    list_all2: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(B,bool)) * list(A) * list(B) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_Map_Omap__upds,type,
    map_upds: 
      !>[A: $tType,B: $tType] : ( ( fun(A,option(B)) * list(A) * list(B) ) > fun(A,option(B)) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Objects_Otypeof__h,type,
    typeof_h: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) > fun(val,option(ty)) ).

tff(sy_c_Option_Ooption_ONone,type,
    none: 
      !>[A: $tType] : option(A) ).

tff(sy_c_Option_Ooption_OSome,type,
    some: 
      !>[A: $tType] : fun(A,option(A)) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T3: $tType] : ( ( fun(A,fun(B,T3)) * product_prod(A,B) ) > T3 ) ).

tff(sy_c_SmallStep_Oblocks,type,
    blocks: product_prod(list(list(char)),product_prod(list(ty),product_prod(list(val),exp(list(char))))) > exp(list(char)) ).

tff(sy_c_SmallStep_Ored,type,
    red: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) > fun(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),bool) ).

tff(sy_c_SmallStep_Oredp,type,
    redp: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * exp(list(char)) * product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))) * exp(list(char)) * product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))) ) > $o ).

tff(sy_c_State_Ohp,type,
    hp: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))) > fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ).

tff(sy_c_TypeRel_OMethod,type,
    method: 
      !>[M4: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M4)))))))) * list(char) * list(char) * list(ty) * ty * M4 * list(char) ) > $o ) ).

tff(sy_c_TypeRel_Omethod,type,
    method1: 
      !>[M4: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M4)))))))) * list(char) * list(char) ) > product_prod(list(char),product_prod(list(ty),product_prod(ty,M4))) ) ).

tff(sy_c_TypeRel_Owiden,type,
    widen: 
      !>[M4: $tType] : ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M4)))))))) > fun(ty,fun(ty,bool)) ) ).

tff(sy_c_TypeSafe__Mirabelle__jrcojvmxyu_Osconf,type,
    typeSa976492716_sconf: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * fun(list(char),option(ty)) * product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))) ) > $o ).

tff(sy_c_Type_Othis,type,
    this: list(char) ).

tff(sy_c_Type_Oty_OClass,type,
    class: list(char) > ty ).

tff(sy_c_Value_Oval_OAddr,type,
    addr: nat > val ).

tff(sy_c_WellForm_Owf__mdecl,type,
    wf_mdecl: 
      !>[M4: $tType] : ( ( fun(list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M4)))))))),fun(list(char),fun(product_prod(list(char),product_prod(list(ty),product_prod(ty,M4))),bool))) * list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M4)))))))) * list(char) * product_prod(list(char),product_prod(list(ty),product_prod(ty,M4))) ) > $o ) ).

tff(sy_c_WellForm_Owf__prog,type,
    wf_prog: 
      !>[M4: $tType] : ( ( fun(list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M4)))))))),fun(list(char),fun(product_prod(list(char),product_prod(list(ty),product_prod(ty,M4))),bool))) * list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M4)))))))) ) > $o ) ).

tff(sy_c_WellTypeRT_OWTrt,type,
    wTrt: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * fun(list(char),option(ty)) * exp(list(char)) * ty ) > $o ).

tff(sy_c_WellTypeRT_OWTrts,type,
    wTrts: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * fun(list(char),option(ty)) * list(exp(list(char))) * list(ty) ) > $o ).

tff(sy_c_WellType_OWT,type,
    wt: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * fun(list(char),option(ty)) * exp(list(char)) * ty ) > $o ).

tff(sy_c_WellType_OWTs,type,
    wTs: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * fun(list(char),option(ty)) * list(exp(list(char))) * list(ty) ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_C____,type,
    c: list(char) ).

tff(sy_v_D____,type,
    d: list(char) ).

tff(sy_v_E____,type,
    e: fun(list(char),option(ty)) ).

tff(sy_v_M____,type,
    m: list(char) ).

tff(sy_v_P,type,
    p: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) ).

tff(sy_v_T_H_H____,type,
    t: ty ).

tff(sy_v_T_H____,type,
    t1: ty ).

tff(sy_v_T____,type,
    t2: ty ).

tff(sy_v_Ts_H____,type,
    ts1: list(ty) ).

tff(sy_v_Ts____,type,
    ts: list(ty) ).

tff(sy_v_a____,type,
    a: nat ).

tff(sy_v_body____,type,
    body: exp(list(char)) ).

tff(sy_v_fs____,type,
    fs: fun(product_prod(list(char),list(char)),option(val)) ).

tff(sy_v_ha____,type,
    ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ).

tff(sy_v_la____,type,
    la: fun(list(char),option(val)) ).

tff(sy_v_pns____,type,
    pns: list(list(char)) ).

tff(sy_v_vs____,type,
    vs: list(val) ).

%----Relevant facts (100)
tff(fact_0_wtabody,axiom,
    wt(p,map_upds(list(char),ty,combk(option(ty),list(char),none(ty)),cons(list(char),this,pns),cons(ty,class(d),ts)),body,t) ).

tff(fact_1_Type_Oty_Oinject,axiom,
    ! [List3: list(char),List: list(char)] :
      ( ( class(List) = class(List3) )
    <=> ( List = List3 ) ) ).

tff(fact_2_T_H_HsubT,axiom,
    pp(aa(ty,bool,aa(ty,fun(ty,bool),widen(product_prod(list(list(char)),exp(list(char))),p),t),t2)) ).

tff(fact_3_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A4: A,List: list(A),Aa: A] :
      ( ( cons(A,Aa,List) = cons(A,A4,List3) )
    <=> ( ( Aa = A4 )
        & ( List = List3 ) ) ) ).

tff(fact_4_assms,axiom,
    wf_prog(product_prod(list(list(char)),exp(list(char))),wf_J_mdecl,p) ).

tff(fact_5_T_HisT,axiom,
    t1 = t2 ).

tff(fact_6__096_B_Bthesis_O_A_I_B_BT_H_H_O_A_091_124_AP_M_091this_A_D_Apns_A_091_124_N_062_093_AClass_AD_A_D_ATs_093_A_092_060turnstile_062_Abody_A_058_058_AT_H_H_059_AP_A_092_060turnstile_062_AT_H_H_A_092_060le_062_AT_059_Alength_Apns_A_061_Alength_ATs_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [T2: ty] :
        ( wt(p,map_upds(list(char),ty,combk(option(ty),list(char),none(ty)),cons(list(char),this,pns),cons(ty,class(d),ts)),body,T2)
       => ( pp(aa(ty,bool,aa(ty,fun(ty,bool),widen(product_prod(list(list(char)),exp(list(char))),p),T2),t2))
         => ( size_size(list(list(char)),pns) != size_size(list(ty),ts) ) ) ) ).

tff(fact_7_RedCall_I4_J,axiom,
    size_size(list(ty),ts) = size_size(list(list(char)),pns) ).

tff(fact_8_length__pns,axiom,
    size_size(list(list(char)),pns) = size_size(list(ty),ts) ).

tff(fact_9_method,axiom,
    method(product_prod(list(list(char)),exp(list(char))),p,c,m,ts,t2,product_Pair(list(list(char)),exp(list(char)),pns,body),d) ).

tff(fact_10_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs2: list(A)] : ( Xs2 != cons(A,X,Xs2) ) ).

tff(fact_11_not__Cons__self2,axiom,
    ! [A: $tType,Xs2: list(A),X: A] : ( cons(A,X,Xs2) != Xs2 ) ).

tff(fact_12_RedCall_I5_J,axiom,
    typeSa976492716_sconf(p,e,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),ha,la)) ).

tff(fact_13_neq__if__length__neq,axiom,
    ! [A: $tType,Ys1: list(A),Xs2: list(A)] :
      ( ( size_size(list(A),Xs2) != size_size(list(A),Ys1) )
     => ( Xs2 != Ys1 ) ) ).

tff(fact_14_subs,axiom,
    list_all2(ty,ty,widen(product_prod(list(list(char)),exp(list(char))),p),ts1,ts) ).

tff(fact_15_widen__refl,axiom,
    ! [M4: $tType,T: ty,P: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M4))))))))] : pp(aa(ty,bool,aa(ty,fun(ty,bool),widen(M4,P),T),T)) ).

tff(fact_16_Cons__in__lex,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),Ys: list(A),Y1: A,Xs: list(A),X2: A] :
      ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),cons(A,X2,Xs),cons(A,Y1,Ys)),lex(A,R1))
    <=> ( ( member(product_prod(A,A),product_Pair(A,A,X2,Y1),R1)
          & ( size_size(list(A),Xs) = size_size(list(A),Ys) ) )
        | ( ( X2 = Y1 )
          & member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Xs,Ys),lex(A,R1)) ) ) ) ).

tff(fact_17_split__paired__All,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ! [X12: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X12))
    <=> ! [A5: A,B3: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A5,B3))) ) ).

tff(fact_18_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B6: B,A4: A,B2: B,Aa: A] :
      ( ( product_Pair(A,B,Aa,B2) = product_Pair(A,B,A4,B6) )
    <=> ( ( Aa = A4 )
        & ( B2 = B6 ) ) ) ).

tff(fact_19_WT__implies__WTrt,axiom,
    ! [Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ta: ty,Ea: exp(list(char)),Ea1: fun(list(char),option(ty)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wt(Pa,Ea1,Ea,Ta)
     => wTrt(Pa,Hb,Ea1,Ea,Ta) ) ).

tff(fact_20__096wf__mdecl_Awf__J__mdecl_AP_AD_A_IM_M_ATs_M_AT_M_Apns_M_Abody_J_096,axiom,
    wf_mdecl(product_prod(list(list(char)),exp(list(char))),wf_J_mdecl,p,d,product_Pair(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))),m,product_Pair(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))),ts,product_Pair(ty,product_prod(list(list(char)),exp(list(char))),t2,product_Pair(list(list(char)),exp(list(char)),pns,body))))) ).

tff(fact_21_RedCall_I3_J,axiom,
    size_size(list(val),vs) = size_size(list(list(char)),pns) ).

tff(fact_22_Ex__list__of__length,axiom,
    ! [A: $tType,N: nat] :
    ? [Xs1: list(A)] : ( size_size(list(A),Xs1) = N ) ).

tff(fact_23_length__vs,axiom,
    size_size(list(val),vs) = size_size(list(ty),ts) ).

tff(fact_24_list__all2__Cons,axiom,
    ! [A: $tType,B: $tType,Ys: list(B),Y1: B,Xs: list(A),X2: A,Pa: fun(A,fun(B,bool))] :
      ( list_all2(A,B,Pa,cons(A,X2,Xs),cons(B,Y1,Ys))
    <=> ( pp(aa(B,bool,aa(A,fun(B,bool),Pa,X2),Y1))
        & list_all2(A,B,Pa,Xs,Ys) ) ) ).

tff(fact_25_widens__refl,axiom,
    ! [A: $tType,Xs: list(ty),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] : list_all2(ty,ty,widen(A,Pa),Xs,Xs) ).

tff(fact_26_list__all2__eq,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( Xs = Ys )
    <=> list_all2(A,A,fequal(A),Xs,Ys) ) ).

tff(fact_27_widens__trans,axiom,
    ! [A: $tType,Us: list(ty),Tsa: list(ty),Ss: list(ty),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( list_all2(ty,ty,widen(A,Pa),Ss,Tsa)
     => ( list_all2(ty,ty,widen(A,Pa),Tsa,Us)
       => list_all2(ty,ty,widen(A,Pa),Ss,Us) ) ) ).

tff(fact_28_list__all2__lengthD,axiom,
    ! [A: $tType,B: $tType,Ys: list(B),Xs: list(A),Pa: fun(A,fun(B,bool))] :
      ( list_all2(A,B,Pa,Xs,Ys)
     => ( size_size(list(A),Xs) = size_size(list(B),Ys) ) ) ).

tff(fact_29_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B5: B,A3: A,B4: B,A6: A] :
      ( ( product_Pair(A,B,A6,B4) = product_Pair(A,B,A3,B5) )
     => ~ ( ( A6 = A3 )
         => ( B4 != B5 ) ) ) ).

tff(fact_30_widen__trans,axiom,
    ! [A: $tType,T: ty,U: ty,S2: ty,P: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( pp(aa(ty,bool,aa(ty,fun(ty,bool),widen(A,P),S2),U))
     => ( pp(aa(ty,bool,aa(ty,fun(ty,bool),widen(A,P),U),T))
       => pp(aa(ty,bool,aa(ty,fun(ty,bool),widen(A,P),S2),T)) ) ) ).

tff(fact_31_sees__method__fun,axiom,
    ! [A: $tType,D4: list(char),M3: A,T1: ty,TS1: list(ty),D3: list(char),M2: A,T: ty,TS: list(ty),M1: list(char),C3: list(char),P: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( method(A,P,C3,M1,TS,T,M2,D3)
     => ( method(A,P,C3,M1,TS1,T1,M3,D4)
       => ( ( TS1 = TS )
          & ( T1 = T )
          & ( M3 = M2 )
          & ( D4 = D3 ) ) ) ) ).

tff(fact_32_sees__method__idemp,axiom,
    ! [A: $tType,D3: list(char),M2: A,T: ty,Ts3: list(ty),M1: list(char),C3: list(char),P: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( method(A,P,C3,M1,Ts3,T,M2,D3)
     => method(A,P,D3,M1,Ts3,T,M2,D3) ) ).

tff(fact_33_widens__Cons,axiom,
    ! [A: $tType,Ys: list(ty),Xs: list(ty),X2: ty,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( list_all2(ty,ty,widen(A,Pa),cons(ty,X2,Xs),Ys)
    <=> ? [Z: ty,Zs: list(ty)] :
          ( ( Ys = cons(ty,Z,Zs) )
          & pp(aa(ty,bool,aa(ty,fun(ty,bool),widen(A,Pa),X2),Z))
          & list_all2(ty,ty,widen(A,Pa),Xs,Zs) ) ) ).

tff(fact_34_method__def2,axiom,
    ! [A: $tType,D3: list(char),M2: A,T: ty,Ts3: list(ty),M1: list(char),C3: list(char),P: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( method(A,P,C3,M1,Ts3,T,M2,D3)
     => ( method1(A,P,C3,M1) = product_Pair(list(char),product_prod(list(ty),product_prod(ty,A)),D3,product_Pair(list(ty),product_prod(ty,A),Ts3,product_Pair(ty,A,T,M2))) ) ) ).

tff(fact_35_sees__wf__mdecl,axiom,
    ! [A: $tType,Da: list(char),M: A,Ta: ty,Tsa: list(ty),Ma: list(char),Ca: list(char),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A)))))))),Wf_md: fun(list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A)))))))),fun(list(char),fun(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))),bool)))] :
      ( wf_prog(A,Wf_md,Pa)
     => ( method(A,Pa,Ca,Ma,Tsa,Ta,M,Da)
       => wf_mdecl(A,Wf_md,Pa,Da,product_Pair(list(char),product_prod(list(ty),product_prod(ty,A)),Ma,product_Pair(list(ty),product_prod(ty,A),Tsa,product_Pair(ty,A,Ta,M)))) ) ) ).

tff(fact_36_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D1: $tType,E: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D1,E))))] :
      ~ ! [A2: A,B1: B,C2: C,D2: D1,E1: E] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D1,E))),A2,product_Pair(B,product_prod(C,product_prod(D1,E)),B1,product_Pair(C,product_prod(D1,E),C2,product_Pair(D1,E,D2,E1)))) ) ).

tff(fact_37_prod__induct5,axiom,
    ! [E: $tType,D1: $tType,C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,product_prod(C,product_prod(D1,E)))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D1,E)))),bool)] :
      ( ! [A2: A,B1: B,C2: C,D2: D1,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D1,E)))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,product_prod(D1,E))),A2,product_Pair(B,product_prod(C,product_prod(D1,E)),B1,product_Pair(C,product_prod(D1,E),C2,product_Pair(D1,E,D2,E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D1,E)))),bool,Pa,X2)) ) ).

tff(fact_38_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D1: $tType,E: $tType,F2: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D1,product_prod(E,F2)))))] :
      ~ ! [A2: A,B1: B,C2: C,D2: D1,E1: E,F3: F2] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D1,product_prod(E,F2)))),A2,product_Pair(B,product_prod(C,product_prod(D1,product_prod(E,F2))),B1,product_Pair(C,product_prod(D1,product_prod(E,F2)),C2,product_Pair(D1,product_prod(E,F2),D2,product_Pair(E,F2,E1,F3))))) ) ).

tff(fact_39_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D1: $tType,C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,product_prod(C,product_prod(D1,product_prod(E,F2))))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D1,product_prod(E,F2))))),bool)] :
      ( ! [A2: A,B1: B,C2: C,D2: D1,E1: E,F3: F2] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D1,product_prod(E,F2))))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,product_prod(D1,product_prod(E,F2)))),A2,product_Pair(B,product_prod(C,product_prod(D1,product_prod(E,F2))),B1,product_Pair(C,product_prod(D1,product_prod(E,F2)),C2,product_Pair(D1,product_prod(E,F2),D2,product_Pair(E,F2,E1,F3)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D1,product_prod(E,F2))))),bool,Pa,X2)) ) ).

tff(fact_40_prod__induct4,axiom,
    ! [D1: $tType,C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,product_prod(C,D1))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,D1))),bool)] :
      ( ! [A2: A,B1: B,C2: C,D2: D1] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D1))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,D1)),A2,product_Pair(B,product_prod(C,D1),B1,product_Pair(C,D1,C2,D2)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D1))),bool,Pa,X2)) ) ).

tff(fact_41_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D1: $tType,Y: product_prod(A,product_prod(B,product_prod(C,D1)))] :
      ~ ! [A2: A,B1: B,C2: C,D2: D1] : ( Y != product_Pair(A,product_prod(B,product_prod(C,D1)),A2,product_Pair(B,product_prod(C,D1),B1,product_Pair(C,D1,C2,D2))) ) ).

tff(fact_42_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ? [X12: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X12))
    <=> ? [A5: A,B3: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A5,B3))) ) ).

tff(fact_43_Class__widen,axiom,
    ! [A: $tType,T: ty,C3: list(char),P: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( pp(aa(ty,bool,aa(ty,fun(ty,bool),widen(A,P),class(C3)),T))
     => ? [D: list(char)] : ( T = class(D) ) ) ).

tff(fact_44_list__all2__Cons1,axiom,
    ! [A: $tType,B: $tType,Ys: list(B),Xs: list(A),X2: A,Pa: fun(A,fun(B,bool))] :
      ( list_all2(A,B,Pa,cons(A,X2,Xs),Ys)
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Ys = cons(B,Z,Zs) )
          & pp(aa(B,bool,aa(A,fun(B,bool),Pa,X2),Z))
          & list_all2(A,B,Pa,Xs,Zs) ) ) ).

tff(fact_45_list__all2__Cons2,axiom,
    ! [A: $tType,B: $tType,Ys: list(B),Y1: B,Xs: list(A),Pa: fun(A,fun(B,bool))] :
      ( list_all2(A,B,Pa,Xs,cons(B,Y1,Ys))
    <=> ? [Z: A,Zs: list(A)] :
          ( ( Xs = cons(A,Z,Zs) )
          & pp(aa(B,bool,aa(A,fun(B,bool),Pa,Z),Y1))
          & list_all2(A,B,Pa,Zs,Ys) ) ) ).

tff(fact_46_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y: product_prod(A,product_prod(B,C))] :
      ~ ! [A2: A,B1: B,C2: C] : ( Y != product_Pair(A,product_prod(B,C),A2,product_Pair(B,C,B1,C2)) ) ).

tff(fact_47_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,C)),Pa: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A2: A,B1: B,C2: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,Pa,product_Pair(A,product_prod(B,C),A2,product_Pair(B,C,B1,C2))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,Pa,X2)) ) ).

tff(fact_48_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,B2: C,Aa: B,F11: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F11,product_Pair(B,C,Aa,B2)) = aa(C,A,aa(B,fun(C,A),F11,Aa),B2) ) ).

tff(fact_49__096_B_Bthesis_O_A_I_B_BTs_H_O_A_091_124_AP_ME_Mh_A_092_060turnstile_062_Amap_AVal_Avs_A_091_058_093_ATs_H_059_Alist__all2_A_Iwiden_AP_J_ATs_H_ATs_059_AT_H_A_061_AT_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Ts2: list(ty)] :
        ( wTrts(p,ha,e,map(val,exp(list(char)),val1(list(char)),vs),Ts2)
       => ( list_all2(ty,ty,widen(product_prod(list(list(char)),exp(list(char))),p),Ts2,ts)
         => ( t1 != t2 ) ) ) ).

tff(fact_50_hp,axiom,
    aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),hp(product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),ha,la)),a) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),c,fs)) ).

tff(fact_51_wtes,axiom,
    wTrts(p,ha,e,map(val,exp(list(char)),val1(list(char)),vs),ts1) ).

tff(fact_52_lexord__cons__cons,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),Y1: list(A),B2: A,X2: list(A),Aa: A] :
      ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),cons(A,Aa,X2),cons(A,B2,Y1)),lexord(A,R1))
    <=> ( member(product_prod(A,A),product_Pair(A,A,Aa,B2),R1)
        | ( ( Aa = B2 )
          & member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),X2,Y1),lexord(A,R1)) ) ) ) ).

tff(fact_53_map__ident,axiom,
    ! [A: $tType,X1: list(A)] : ( map(A,A,combi(A),X1) = X1 ) ).

tff(fact_54_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X2: B,F1: fun(B,A)] : ( map(B,A,F1,cons(B,X2,Xs)) = cons(A,aa(B,A,F1,X2),map(B,A,F1,Xs)) ) ).

tff(fact_55_length__map,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F1: fun(B,A)] : ( size_size(list(A),map(B,A,F1,Xs)) = size_size(list(B),Xs) ) ).

tff(fact_56_WTrtCons,axiom,
    ! [Tsa: list(ty),Esa: list(exp(list(char))),Ta: ty,Ea: exp(list(char)),Ea1: fun(list(char),option(ty)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wTrt(Pa,Hb,Ea1,Ea,Ta)
     => ( wTrts(Pa,Hb,Ea1,Esa,Tsa)
       => wTrts(Pa,Hb,Ea1,cons(exp(list(char)),Ea,Esa),cons(ty,Ta,Tsa)) ) ) ).

tff(fact_57_list__all2__map1,axiom,
    ! [C: $tType,A: $tType,B: $tType,Bs: list(B),As: list(C),F1: fun(C,A),Pa: fun(A,fun(B,bool))] :
      ( list_all2(A,B,Pa,map(C,A,F1,As),Bs)
    <=> list_all2(C,B,aa(fun(C,A),fun(C,fun(B,bool)),aa(fun(A,fun(B,bool)),fun(fun(C,A),fun(C,fun(B,bool))),combb(A,fun(B,bool),C),Pa),F1),As,Bs) ) ).

tff(fact_58_list__all2__map2,axiom,
    ! [A: $tType,B: $tType,C: $tType,Bs: list(C),F1: fun(C,B),As: list(A),Pa: fun(A,fun(B,bool))] :
      ( list_all2(A,B,Pa,As,map(C,B,F1,Bs))
    <=> list_all2(A,C,combc(A,fun(C,B),fun(C,bool),aa(fun(A,fun(B,bool)),fun(A,fun(fun(C,B),fun(C,bool))),aa(fun(fun(B,bool),fun(fun(C,B),fun(C,bool))),fun(fun(A,fun(B,bool)),fun(A,fun(fun(C,B),fun(C,bool)))),combb(fun(B,bool),fun(fun(C,B),fun(C,bool)),A),combb(B,bool,C)),Pa),F1),As,Bs) ) ).

tff(fact_59_map__eq__imp__length__eq,axiom,
    ! [A: $tType,B: $tType,C: $tType,Ys: list(C),G: fun(C,A),Xs: list(B),F1: fun(B,A)] :
      ( ( map(B,A,F1,Xs) = map(C,A,G,Ys) )
     => ( size_size(list(B),Xs) = size_size(list(C),Ys) ) ) ).

tff(fact_60_WTrts__same__length,axiom,
    ! [Tsa: list(ty),Esa: list(exp(list(char))),Ea1: fun(list(char),option(ty)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wTrts(Pa,Hb,Ea1,Esa,Tsa)
     => ( size_size(list(exp(list(char))),Esa) = size_size(list(ty),Tsa) ) ) ).

tff(fact_61_lexord__lex,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),Y1: list(A),X2: list(A)] :
      ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),X2,Y1),lex(A,R1))
    <=> ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),X2,Y1),lexord(A,R1))
        & ( size_size(list(A),X2) = size_size(list(A),Y1) ) ) ) ).

tff(fact_62_Cons__eq__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys: list(B),F1: fun(B,A),Xs: list(A),X2: A] :
      ( ( cons(A,X2,Xs) = map(B,A,F1,Ys) )
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Ys = cons(B,Z,Zs) )
          & ( X2 = aa(B,A,F1,Z) )
          & ( Xs = map(B,A,F1,Zs) ) ) ) ).

tff(fact_63_RedCall_I6_J,axiom,
    wTrt(p,ha,e,call(list(char),aa(val,exp(list(char)),val1(list(char)),addr(a)),m,map(val,exp(list(char)),val1(list(char)),vs)),t1) ).

tff(fact_64_not__None__eq,axiom,
    ! [A: $tType,X2: option(A)] :
      ( ( X2 != none(A) )
    <=> ? [Y2: A] : ( X2 = aa(A,option(A),some(A),Y2) ) ) ).

tff(fact_65_not__Some__eq,axiom,
    ! [A: $tType,X2: option(A)] :
      ( ! [Y2: A] : ( X2 != aa(A,option(A),some(A),Y2) )
    <=> ( X2 = none(A) ) ) ).

tff(fact_66_option_Oinject,axiom,
    ! [A: $tType,A4: A,Aa: A] :
      ( ( aa(A,option(A),some(A),Aa) = aa(A,option(A),some(A),A4) )
    <=> ( Aa = A4 ) ) ).

tff(fact_67_wt,axiom,
    wTrt(p,ha,e,call(list(char),aa(val,exp(list(char)),val1(list(char)),addr(a)),m,map(val,exp(list(char)),val1(list(char)),vs)),t1) ).

tff(fact_68_option_Osimps_I2_J,axiom,
    ! [A: $tType,A3: A] : ( none(A) != aa(A,option(A),some(A),A3) ) ).

tff(fact_69_option_Osimps_I3_J,axiom,
    ! [A: $tType,A3: A] : ( aa(A,option(A),some(A),A3) != none(A) ) ).

tff(fact_70_WTrtCall,axiom,
    ! [Ts_a: list(ty),Esa: list(exp(list(char))),Da: list(char),Bodya: exp(list(char)),Pnsa: list(list(char)),Ta: ty,Tsa: list(ty),Ma: list(char),Ca: list(char),Ea: exp(list(char)),Ea1: fun(list(char),option(ty)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wTrt(Pa,Hb,Ea1,Ea,class(Ca))
     => ( method(product_prod(list(list(char)),exp(list(char))),Pa,Ca,Ma,Tsa,Ta,product_Pair(list(list(char)),exp(list(char)),Pnsa,Bodya),Da)
       => ( wTrts(Pa,Hb,Ea1,Esa,Ts_a)
         => ( list_all2(ty,ty,widen(product_prod(list(list(char)),exp(list(char))),Pa),Ts_a,Tsa)
           => wTrt(Pa,Hb,Ea1,call(list(char),Ea,Ma,Esa),Ta) ) ) ) ) ).

tff(fact_71_lexord__linear,axiom,
    ! [A: $tType,Y1: list(A),X2: list(A),R1: fun(product_prod(A,A),bool)] :
      ( ! [A2: A,B1: A] :
          ( member(product_prod(A,A),product_Pair(A,A,A2,B1),R1)
          | ( A2 = B1 )
          | member(product_prod(A,A),product_Pair(A,A,B1,A2),R1) )
     => ( member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),X2,Y1),lexord(A,R1))
        | ( X2 = Y1 )
        | member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Y1,X2),lexord(A,R1)) ) ) ).

tff(fact_72_lexord__irreflexive,axiom,
    ! [A: $tType,Xs: list(A),R1: fun(product_prod(A,A),bool)] :
      ( ! [X3: A] : ~ member(product_prod(A,A),product_Pair(A,A,X3,X3),R1)
     => ~ member(product_prod(list(A),list(A)),product_Pair(list(A),list(A),Xs,Xs),lexord(A,R1)) ) ).

tff(fact_73_WTCall,axiom,
    ! [Ts_a: list(ty),Esa: list(exp(list(char))),Da: list(char),Bodya: exp(list(char)),Pnsa: list(list(char)),Ta: ty,Tsa: list(ty),Ma: list(char),Ca: list(char),Ea: exp(list(char)),Ea1: fun(list(char),option(ty)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wt(Pa,Ea1,Ea,class(Ca))
     => ( method(product_prod(list(list(char)),exp(list(char))),Pa,Ca,Ma,Tsa,Ta,product_Pair(list(list(char)),exp(list(char)),Pnsa,Bodya),Da)
       => ( wTs(Pa,Ea1,Esa,Ts_a)
         => ( list_all2(ty,ty,widen(product_prod(list(list(char)),exp(list(char))),Pa),Ts_a,Tsa)
           => wt(Pa,Ea1,call(list(char),Ea,Ma,Esa),Ta) ) ) ) ) ).

tff(fact_74_WTCons,axiom,
    ! [Tsa: list(ty),Esa: list(exp(list(char))),Ta: ty,Ea: exp(list(char)),Ea1: fun(list(char),option(ty)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wt(Pa,Ea1,Ea,Ta)
     => ( wTs(Pa,Ea1,Esa,Tsa)
       => wTs(Pa,Ea1,cons(exp(list(char)),Ea,Esa),cons(ty,Ta,Tsa)) ) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F1: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F1,X3) = aa(A,B,G,X3) )
     => ( F1 = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X2: A] :
      ( member(A,X2,A1)
    <=> pp(aa(A,bool,A1,X2)) ) ).

tff(fact_77_WTs__implies__WTrts,axiom,
    ! [Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Tsa: list(ty),Esa: list(exp(list(char))),Ea1: fun(list(char),option(ty)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wTs(Pa,Ea1,Esa,Tsa)
     => wTrts(Pa,Hb,Ea1,Esa,Tsa) ) ).

tff(fact_78_WT__elim__cases_I11_J,axiom,
    ! [Ta: ty,Ps: list(exp(list(char))),Ma: list(char),Ea: exp(list(char)),Ea1: fun(list(char),option(ty)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wt(Pa,Ea1,call(list(char),Ea,Ma,Ps),Ta)
     => ~ ! [C1: list(char)] :
            ( wt(Pa,Ea1,Ea,class(C1))
           => ! [Ts1: list(ty)] :
                ( ? [Pns: list(list(char)),Body: exp(list(char)),X11: list(char)] : method(product_prod(list(list(char)),exp(list(char))),Pa,C1,Ma,Ts1,Ta,product_Pair(list(list(char)),exp(list(char)),Pns,Body),X11)
               => ! [Ts2: list(ty)] :
                    ( wTs(Pa,Ea1,Ps,Ts2)
                   => ~ list_all2(ty,ty,widen(product_prod(list(list(char)),exp(list(char))),Pa),Ts2,Ts1) ) ) ) ) ).

tff(fact_79_red__reds_ORedCall,axiom,
    ! [Vsa: list(val),Da: list(char),Bodya: exp(list(char)),Pnsa: list(list(char)),Ta: ty,Tsa: list(ty),Ma: list(char),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),Fsa: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))] :
      ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),hp(S),Aa) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fsa)) )
     => ( method(product_prod(list(list(char)),exp(list(char))),Pa,Ca,Ma,Tsa,Ta,product_Pair(list(list(char)),exp(list(char)),Pnsa,Bodya),Da)
       => ( ( size_size(list(val),Vsa) = size_size(list(list(char)),Pnsa) )
         => ( ( size_size(list(ty),Tsa) = size_size(list(list(char)),Pnsa) )
           => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),call(list(char),aa(val,exp(list(char)),val1(list(char)),addr(Aa)),Ma,map(val,exp(list(char)),val1(list(char)),Vsa)),S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),blocks(product_Pair(list(list(char)),product_prod(list(ty),product_prod(list(val),exp(list(char)))),cons(list(char),this,Pnsa),product_Pair(list(ty),product_prod(list(val),exp(list(char))),cons(ty,class(Da),Tsa),product_Pair(list(val),exp(list(char)),cons(val,addr(Aa),Vsa),Bodya)))),S)),red(Pa)) ) ) ) ) ).

tff(fact_80_red__reds_OCallObj,axiom,
    ! [Esa: list(exp(list(char))),Ma: list(char),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_a: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea,S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_a,S1)),red(Pa))
     => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),call(list(char),Ea,Ma,Esa),S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),call(list(char),E_a,Ma,Esa),S1)),red(Pa)) ) ).

tff(fact_81_red__preserves__sconf,axiom,
    ! [Ta: ty,Ea1: fun(list(char),option(ty)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_a: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea,S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_a,S1)),red(Pa))
     => ( wTrt(Pa,hp(S),Ea1,Ea,Ta)
       => ( typeSa976492716_sconf(Pa,Ea1,S)
         => typeSa976492716_sconf(Pa,Ea1,S1) ) ) ) ).

tff(fact_82_redp__redsp_ORedCall,axiom,
    ! [Vsa: list(val),Da: list(char),Bodya: exp(list(char)),Pnsa: list(list(char)),Ta: ty,Tsa: list(ty),Ma: list(char),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),Fsa: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))] :
      ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),hp(S),Aa) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fsa)) )
     => ( method(product_prod(list(list(char)),exp(list(char))),Pa,Ca,Ma,Tsa,Ta,product_Pair(list(list(char)),exp(list(char)),Pnsa,Bodya),Da)
       => ( ( size_size(list(val),Vsa) = size_size(list(list(char)),Pnsa) )
         => ( ( size_size(list(ty),Tsa) = size_size(list(list(char)),Pnsa) )
           => redp(Pa,call(list(char),aa(val,exp(list(char)),val1(list(char)),addr(Aa)),Ma,map(val,exp(list(char)),val1(list(char)),Vsa)),S,blocks(product_Pair(list(list(char)),product_prod(list(ty),product_prod(list(val),exp(list(char)))),cons(list(char),this,Pnsa),product_Pair(list(ty),product_prod(list(val),exp(list(char))),cons(ty,class(Da),Tsa),product_Pair(list(val),exp(list(char)),cons(val,addr(Aa),Vsa),Bodya)))),S) ) ) ) ) ).

tff(fact_83_wt__blocks,axiom,
    ! [Ta: ty,Ea: exp(list(char)),Ea1: fun(list(char),option(ty)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),Vsa: list(val),Tsa: list(ty),Vs: list(list(char))] :
      ( ( size_size(list(list(char)),Vs) = size_size(list(ty),Tsa) )
     => ( ( size_size(list(val),Vsa) = size_size(list(ty),Tsa) )
       => ( wTrt(Pa,Hb,Ea1,blocks(product_Pair(list(list(char)),product_prod(list(ty),product_prod(list(val),exp(list(char)))),Vs,product_Pair(list(ty),product_prod(list(val),exp(list(char))),Tsa,product_Pair(list(val),exp(list(char)),Vsa,Ea)))),Ta)
        <=> ( wTrt(Pa,Hb,map_upds(list(char),ty,Ea1,Vs,Tsa),Ea,Ta)
            & ? [Ts: list(ty)] :
                ( ( map(val,option(ty),typeof_h(Hb),Vsa) = map(ty,option(ty),some(ty),Ts) )
                & list_all2(ty,ty,widen(product_prod(list(list(char)),exp(list(char))),Pa),Ts,Tsa) ) ) ) ) ) ).

tff(fact_84_WTrtVal,axiom,
    ! [Ea1: fun(list(char),option(ty)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),Ta: ty,V: val,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( ( aa(val,option(ty),typeof_h(Hb),V) = aa(ty,option(ty),some(ty),Ta) )
     => wTrt(Pa,Hb,Ea1,aa(val,exp(list(char)),val1(list(char)),V),Ta) ) ).

tff(fact_85_WTVal,axiom,
    ! [Ea1: fun(list(char),option(ty)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),Ta: ty,V: val] :
      ( ( aa(val,option(ty),typeof_h(combk(option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),nat,none(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))),V) = aa(ty,option(ty),some(ty),Ta) )
     => wt(Pa,Ea1,aa(val,exp(list(char)),val1(list(char)),V),Ta) ) ).

tff(fact_86_WTrts__Val,axiom,
    ! [Tsa: list(ty),Vsa: list(val),Ea1: fun(list(char),option(ty)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wTrts(Pa,Hb,Ea1,map(val,exp(list(char)),val1(list(char)),Vsa),Tsa)
    <=> ( map(val,option(ty),typeof_h(Hb),Vsa) = map(ty,option(ty),some(ty),Tsa) ) ) ).

tff(fact_87_redp__redsp_OCallObj,axiom,
    ! [Esa: list(exp(list(char))),Ma: list(char),S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_a: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( redp(Pa,Ea,S,E_a,S1)
     => redp(Pa,call(list(char),Ea,Ma,Esa),S,call(list(char),E_a,Ma,Esa),S1) ) ).

tff(fact_88_redp__red__eq,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),X1: exp(list(char)),Xa: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Xb: exp(list(char)),Xc: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))] :
      ( redp(Pa,X1,Xa,Xb,Xc)
    <=> member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),X1,Xa),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Xb,Xc)),red(Pa)) ) ).

tff(fact_89_exp_Osimps_I9_J,axiom,
    ! [A: $tType,List23: list(exp(A)),List13: list(char),Exp3: exp(A),List22: list(exp(A)),List12: list(char),Exp2: exp(A)] :
      ( ( call(A,Exp2,List12,List22) = call(A,Exp3,List13,List23) )
    <=> ( ( Exp2 = Exp3 )
        & ( List12 = List13 )
        & ( List22 = List23 ) ) ) ).

tff(fact_90_typeof__lit__typeof,axiom,
    ! [Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ta: ty,V: val] :
      ( ( aa(val,option(ty),typeof_h(combk(option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),nat,none(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))),V) = aa(ty,option(ty),some(ty),Ta) )
     => ( aa(val,option(ty),typeof_h(Hb),V) = aa(ty,option(ty),some(ty),Ta) ) ) ).

tff(fact_91_exp_Osimps_I3_J,axiom,
    ! [A: $tType,Val2: val,Val1: val] :
      ( ( aa(val,exp(A),val1(A),Val1) = aa(val,exp(A),val1(A),Val2) )
    <=> ( Val1 = Val2 ) ) ).

tff(fact_92_exp_Osimps_I81_J,axiom,
    ! [A: $tType,Val: val,List21: list(exp(A)),List11: list(char),Exp1: exp(A)] : ( call(A,Exp1,List11,List21) != aa(val,exp(A),val1(A),Val) ) ).

tff(fact_93_exp_Osimps_I80_J,axiom,
    ! [A: $tType,List21: list(exp(A)),List11: list(char),Exp1: exp(A),Val: val] : ( aa(val,exp(A),val1(A),Val) != call(A,Exp1,List11,List21) ) ).

tff(fact_94_val_Osimps_I3_J,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( addr(Nat) = addr(Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_95_red__reds_ORedFAcc,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),V: val,Da: list(char),F: list(char),Fsa: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))] :
      ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),hp(S),Aa) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fsa)) )
     => ( ( aa(product_prod(list(char),list(char)),option(val),Fsa,product_Pair(list(char),list(char),F,Da)) = aa(val,option(val),some(val),V) )
       => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),fAcc(list(char),aa(val,exp(list(char)),val1(list(char)),addr(Aa)),F,Da),S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),aa(val,exp(list(char)),val1(list(char)),V),S)),red(Pa)) ) ) ).

tff(fact_96_exp_Osimps_I7_J,axiom,
    ! [A: $tType,List23: list(char),List13: list(char),Exp3: exp(A),List22: list(char),List12: list(char),Exp2: exp(A)] :
      ( ( fAcc(A,Exp2,List12,List22) = fAcc(A,Exp3,List13,List23) )
    <=> ( ( Exp2 = Exp3 )
        & ( List12 = List13 )
        & ( List22 = List23 ) ) ) ).

tff(fact_97_exp_Osimps_I77_J,axiom,
    ! [A: $tType,Val: val,List21: list(char),List11: list(char),Exp1: exp(A)] : ( fAcc(A,Exp1,List11,List21) != aa(val,exp(A),val1(A),Val) ) ).

tff(fact_98_exp_Osimps_I76_J,axiom,
    ! [A: $tType,List21: list(char),List11: list(char),Exp1: exp(A),Val: val] : ( aa(val,exp(A),val1(A),Val) != fAcc(A,Exp1,List11,List21) ) ).

tff(fact_99_exp_Osimps_I156_J,axiom,
    ! [A: $tType,List21: list(exp(A)),List11: list(char),Exp1: exp(A),List2: list(char),List1: list(char),Exp: exp(A)] : ( fAcc(A,Exp,List1,List2) != call(A,Exp1,List11,List21) ) ).

%----Helper facts (8)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    wTrt(p,ha,map_upds(list(char),ty,combk(option(ty),list(char),none(ty)),cons(list(char),this,pns),cons(ty,class(d),ts)),body,t) ).

%------------------------------------------------------------------------------
