%------------------------------------------------------------------------------
% File     : SWW557_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Java type soundness line 123
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : jinja_123 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  183 (  51 unt;  55 typ;   0 def)
%            Number of atoms       :  269 ( 116 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  204 (  63   ~;  19   |;  11   &)
%                                         (  24 <=>;  87  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   19 (   7 avg)
%            Maximal term depth    :   14 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   48 (  29   >;  19   *;   0   +;   0  <<)
%            Number of predicates  :    5 (   4 usr;   0 prp; 1-2 aty)
%            Number of functors    :   46 (  46 usr;  16 con; 0-6 aty)
%            Number of variables   :  568 ( 514   !;   9   ?; 568   :)
%                                         (  45  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:17:12
%------------------------------------------------------------------------------
%----Should-be-implicit typings (10)
tff(ty_tc_Expr_Oexp,type,
    exp: $tType > $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Option_Ooption,type,
    option: $tType > $tType ).

tff(ty_tc_String_Ochar,type,
    char: $tType ).

tff(ty_tc_Type_Oty,type,
    ty: $tType ).

tff(ty_tc_Value_Oval,type,
    val: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (45)
tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_DefAss_O_092_060A_062,type,
    a: 
      !>[A: $tType] : ( exp(A) > option(fun(A,bool)) ) ).

tff(sy_c_Map_Omap__add,type,
    map_add: 
      !>[A: $tType,B: $tType] : ( ( fun(A,option(B)) * fun(A,option(B)) ) > fun(A,option(B)) ) ).

tff(sy_c_Objects_Ohext,type,
    hext: ( fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ) > $o ).

tff(sy_c_Option_Ois__none,type,
    is_none: 
      !>[A: $tType] : ( option(A) > $o ) ).

tff(sy_c_Option_Ooption_ONone,type,
    none: 
      !>[A: $tType] : option(A) ).

tff(sy_c_Option_Ooption_OSome,type,
    some: 
      !>[A: $tType] : ( A > option(A) ) ).

tff(sy_c_Option_Ooption_Ooption__case,type,
    option_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,T) * option(A) ) > T ) ).

tff(sy_c_Option_Ooption_Ooption__rec,type,
    option_rec: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,T) * option(A) ) > T ) ).

tff(sy_c_Option_Oset,type,
    set: 
      !>[A: $tType] : ( option(A) > fun(A,bool) ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(product_prod(A,B),C) * A * B ) > C ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * product_prod(A,B) ) > C ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( fun(A,fun(B,T)) * product_prod(A,B) ) > T ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_SmallStep_Ored,type,
    red: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) > fun(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),bool) ).

tff(sy_c_Transitive__Closure_Ortrancl,type,
    transitive_rtrancl: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_Wellfounded_Olex__prod,type,
    lex_prod: 
      !>[A: $tType,B: $tType] : ( ( fun(product_prod(A,A),bool) * fun(product_prod(B,B),bool) ) > fun(product_prod(product_prod(A,B),product_prod(A,B)),bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_P,type,
    p: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) ).

tff(sy_v_a,type,
    a1: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ).

tff(sy_v_aa,type,
    aa1: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ).

tff(sy_v_ab,type,
    ab: fun(list(char),bool) ).

tff(sy_v_b,type,
    b: fun(list(char),option(val)) ).

tff(sy_v_ba,type,
    ba: fun(list(char),option(val)) ).

tff(sy_v_e_092_060_094isub_0622,type,
    e_2: exp(list(char)) ).

tff(sy_v_e_Ha,type,
    e_a: exp(list(char)) ).

tff(sy_v_ea,type,
    ea: exp(list(char)) ).

tff(sy_v_x,type,
    x: list(char) ).

tff(sy_v_y,type,
    y: val ).

%----Relevant facts (100)
tff(fact_0_not__Some__eq,axiom,
    ! [A: $tType,X1: option(A)] :
      ( ! [Y3: A] : ( X1 != some(A,Y3) )
    <=> ( X1 = none(A) ) ) ).

tff(fact_1_not__None__eq,axiom,
    ! [A: $tType,X1: option(A)] :
      ( ( X1 != none(A) )
    <=> ? [Y3: A] : ( X1 = some(A,Y3) ) ) ).

tff(fact_2_option_Oinject,axiom,
    ! [A: $tType,A5: A,A2: A] :
      ( ( some(A,A2) = some(A,A5) )
    <=> ( A2 = A5 ) ) ).

tff(fact_3_split__paired__All,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ! [A4: A,B6: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A4,B6))) ) ).

tff(fact_4_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B5: B,A5: A,B2: B,A2: A] :
      ( ( product_Pair(A,B,A2,B2) = product_Pair(A,B,A5,B5) )
    <=> ( ( A2 = A5 )
        & ( B2 = B5 ) ) ) ).

tff(fact_5_option_Osimps_I2_J,axiom,
    ! [A: $tType,A7: A] : ( none(A) != some(A,A7) ) ).

tff(fact_6_option_Osimps_I3_J,axiom,
    ! [A: $tType,A7: A] : ( some(A,A7) != none(A) ) ).

tff(fact_7_prod__induct6,axiom,
    ! [F3: $tType,E: $tType,D1: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,product_prod(D1,product_prod(E,F3))))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D1,product_prod(E,F3))))),bool)] :
      ( ! [A3: A,B3: B,C5: C,D2: D1,E1: E,F4: F3] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D1,product_prod(E,F3))))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,product_prod(D1,product_prod(E,F3)))),A3,product_Pair(B,product_prod(C,product_prod(D1,product_prod(E,F3))),B3,product_Pair(C,product_prod(D1,product_prod(E,F3)),C5,product_Pair(D1,product_prod(E,F3),D2,product_Pair(E,F3,E1,F4)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D1,product_prod(E,F3))))),bool,Pa,X1)) ) ).

tff(fact_8_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D1: $tType,E: $tType,F3: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D1,product_prod(E,F3)))))] :
      ~ ! [A3: A,B3: B,C5: C,D2: D1,E1: E,F4: F3] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D1,product_prod(E,F3)))),A3,product_Pair(B,product_prod(C,product_prod(D1,product_prod(E,F3))),B3,product_Pair(C,product_prod(D1,product_prod(E,F3)),C5,product_Pair(D1,product_prod(E,F3),D2,product_Pair(E,F3,E1,F4))))) ) ).

tff(fact_9_prod__induct5,axiom,
    ! [E: $tType,D1: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,product_prod(D1,E)))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D1,E)))),bool)] :
      ( ! [A3: A,B3: B,C5: C,D2: D1,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D1,E)))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,product_prod(D1,E))),A3,product_Pair(B,product_prod(C,product_prod(D1,E)),B3,product_Pair(C,product_prod(D1,E),C5,product_Pair(D1,E,D2,E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D1,E)))),bool,Pa,X1)) ) ).

tff(fact_10_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D1: $tType,E: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D1,E))))] :
      ~ ! [A3: A,B3: B,C5: C,D2: D1,E1: E] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D1,E))),A3,product_Pair(B,product_prod(C,product_prod(D1,E)),B3,product_Pair(C,product_prod(D1,E),C5,product_Pair(D1,E,D2,E1)))) ) ).

tff(fact_11_prod__induct4,axiom,
    ! [D1: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,D1))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,D1))),bool)] :
      ( ! [A3: A,B3: B,C5: C,D2: D1] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D1))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,D1)),A3,product_Pair(B,product_prod(C,D1),B3,product_Pair(C,D1,C5,D2)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D1))),bool,Pa,X1)) ) ).

tff(fact_12_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B8: B,A7: A,B7: B,A6: A] :
      ( ( product_Pair(A,B,A6,B7) = product_Pair(A,B,A7,B8) )
     => ~ ( ( A6 = A7 )
         => ( B7 != B8 ) ) ) ).

tff(fact_13_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D1: $tType,Y: product_prod(A,product_prod(B,product_prod(C,D1)))] :
      ~ ! [A3: A,B3: B,C5: C,D2: D1] : ( Y != product_Pair(A,product_prod(B,product_prod(C,D1)),A3,product_Pair(B,product_prod(C,D1),B3,product_Pair(C,D1,C5,D2))) ) ).

tff(fact_14_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ? [A4: A,B6: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A4,B6))) ) ).

tff(fact_15_option_Oexhaust,axiom,
    ! [A: $tType,Y: option(A)] :
      ( ( Y != none(A) )
     => ~ ! [A3: A] : ( Y != some(A,A3) ) ) ).

tff(fact_16_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y: product_prod(A,product_prod(B,C))] :
      ~ ! [A3: A,B3: B,C5: C] : ( Y != product_Pair(A,product_prod(B,C),A3,product_Pair(B,C,B3,C5)) ) ).

tff(fact_17_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,C)),Pa: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A3: A,B3: B,C5: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,Pa,product_Pair(A,product_prod(B,C),A3,product_Pair(B,C,B3,C5))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,Pa,X1)) ) ).

tff(fact_18_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,B2: C,A2: B,F1: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F1,product_Pair(B,C,A2,B2)) = aa(C,A,aa(B,fun(C,A),F1,A2),B2) ) ).

tff(fact_19_elem__set,axiom,
    ! [A: $tType,Xo: option(A),X1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xo)))
    <=> ( Xo = some(A,X1) ) ) ).

tff(fact_20_option_Orecs_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,A),F1: A] : ( option_rec(A,B,F1,F2,none(B)) = F1 ) ).

tff(fact_21_option_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,A2: B,F2: fun(B,A),F1: A] : ( option_rec(A,B,F1,F2,some(B,A2)) = aa(B,A,F2,A2) ) ).

tff(fact_22_ospec,axiom,
    ! [A: $tType,X1: A,Pa: fun(A,bool),A1: option(A)] :
      ( ! [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,A1)))
         => pp(aa(A,bool,Pa,X2)) )
     => ( ( A1 = some(A,X1) )
       => pp(aa(A,bool,Pa,X1)) ) ) ).

tff(fact_23_PairE,axiom,
    ! [A: $tType,B: $tType,P2: product_prod(A,B)] :
      ~ ! [X2: A,Y1: B] : ( P2 != product_Pair(A,B,X2,Y1) ) ).

tff(fact_24_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y: product_prod(A,B)] :
      ~ ! [A3: A,B3: B] : ( Y != product_Pair(A,B,A3,B3) ) ).

tff(fact_25_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,B2: C,A2: B,C1: fun(B,fun(C,A))] : ( produc1605651328_split(B,C,A,C1,product_Pair(B,C,A2,B2)) = aa(C,A,aa(B,fun(C,A),C1,A2),B2) ) ).

tff(fact_26_curry__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,B2: C,A2: B,F: fun(product_prod(B,C),A)] : ( product_curry(B,C,A,F,A2,B2) = aa(product_prod(B,C),A,F,product_Pair(B,C,A2,B2)) ) ).

tff(fact_27_is__none__code_I1_J,axiom,
    ! [A: $tType] : is_none(A,none(A)) ).

tff(fact_28_is__none__def,axiom,
    ! [A: $tType,X1: option(A)] :
      ( is_none(A,X1)
    <=> ( X1 = none(A) ) ) ).

tff(fact_29_curryI,axiom,
    ! [A: $tType,B: $tType,B2: B,A2: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,A2,B2)))
     => pp(product_curry(A,B,bool,F,A2,B2)) ) ).

tff(fact_30_curryE,axiom,
    ! [A: $tType,B: $tType,B2: B,A2: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,A2,B2))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,A2,B2))) ) ).

tff(fact_31_curryD,axiom,
    ! [A: $tType,B: $tType,B2: B,A2: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,A2,B2))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,A2,B2))) ) ).

tff(fact_32_is__none__code_I2_J,axiom,
    ! [B: $tType,X: B] : ~ is_none(B,some(B,X)) ).

tff(fact_33_in__lex__prod,axiom,
    ! [A: $tType,B: $tType,S: fun(product_prod(B,B),bool),R1: fun(product_prod(A,A),bool),B5: B,A5: A,B2: B,A2: A] :
      ( pp(aa(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool,aa(product_prod(product_prod(A,B),product_prod(A,B)),fun(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool),member(product_prod(product_prod(A,B),product_prod(A,B))),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,A2,B2),product_Pair(A,B,A5,B5))),lex_prod(A,B,R1,S)))
    <=> ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,A2,A5)),R1))
        | ( ( A2 = A5 )
          & pp(aa(fun(product_prod(B,B),bool),bool,aa(product_prod(B,B),fun(fun(product_prod(B,B),bool),bool),member(product_prod(B,B)),product_Pair(B,B,B2,B5)),S)) ) ) ) ).

tff(fact_34_option_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,A),F1: A] : ( option_case(A,B,F1,F2,none(B)) = F1 ) ).

tff(fact_35_option_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,A2: B,F2: fun(B,A),F1: A] : ( option_case(A,B,F1,F2,some(B,A2)) = aa(B,A,F2,A2) ) ).

tff(fact_36_red__hext__incr,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L_a: fun(list(char),option(val)),H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E_a: exp(list(char)),La: fun(list(char),option(val)),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ea: exp(list(char))] :
      ( pp(aa(fun(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),bool),bool,aa(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),fun(fun(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),bool),bool),member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,La)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_a,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_a,L_a)))),red(Pa)))
     => hext(Ha,H_a) ) ).

tff(fact_37_set__empty__eq,axiom,
    ! [A: $tType,Xo: option(A)] :
      ( ( set(A,Xo) = bot_bot(fun(A,bool)) )
    <=> ( Xo = none(A) ) ) ).

tff(fact_38_Option_Oset_Osimps_I1_J,axiom,
    ! [A: $tType] : ( set(A,none(A)) = bot_bot(fun(A,bool)) ) ).

tff(fact_39_hext__refl,axiom,
    ! [Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] : hext(Ha,Ha) ).

tff(fact_40_emptyE,axiom,
    ! [A: $tType,A2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),bot_bot(fun(A,bool)))) ).

tff(fact_41_Collect__empty__eq,axiom,
    ! [A: $tType,Pa: fun(A,bool)] :
      ( ( collect(A,Pa) = bot_bot(fun(A,bool)) )
    <=> ! [X4: A] : ~ pp(aa(A,bool,Pa,X4)) ) ).

tff(fact_42_empty__iff,axiom,
    ! [A: $tType,C1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),bot_bot(fun(A,bool)))) ).

tff(fact_43_empty__Collect__eq,axiom,
    ! [A: $tType,Pa: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,Pa) )
    <=> ! [X4: A] : ~ pp(aa(A,bool,Pa,X4)) ) ).

tff(fact_44_all__not__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X4: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),A1))
    <=> ( A1 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_45_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,combk(bool,A,fFalse)) ) ).

tff(fact_46_ex__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ? [X4: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),A1))
    <=> ( A1 != bot_bot(fun(A,bool)) ) ) ).

tff(fact_47_equals0D,axiom,
    ! [A: $tType,A2: A,A1: fun(A,bool)] :
      ( ( A1 = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1)) ) ).

tff(fact_48_hext__trans,axiom,
    ! [H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( hext(Ha,H_a)
     => ( hext(H_a,H)
       => hext(Ha,H) ) ) ).

tff(fact_49_bot__fun__def,axiom,
    ! [A: $tType,B: $tType] :
      ( bot(B)
     => ! [X3: A] : ( aa(A,B,bot_bot(fun(A,B)),X3) = bot_bot(B) ) ) ).

tff(fact_50_bot__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( bot(A)
     => ! [X1: B] : ( aa(B,A,bot_bot(fun(B,A)),X1) = bot_bot(A) ) ) ).

tff(fact_51_hext__def,axiom,
    ! [H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( hext(Ha,H_a)
    <=> ! [A4: nat,C2: list(char),Fs4: fun(product_prod(list(char),list(char)),option(val))] :
          ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Ha,A4) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C2,Fs4)) )
         => ? [Fs5: fun(product_prod(list(char),list(char)),option(val))] : ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),H_a,A4) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C2,Fs5)) ) ) ) ).

tff(fact_52_hext__objD,axiom,
    ! [Fs2: fun(product_prod(list(char),list(char)),option(val)),C4: list(char),A2: nat,H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( hext(Ha,H_a)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Ha,A2) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C4,Fs2)) )
       => ? [Fs3: fun(product_prod(list(char),list(char)),option(val))] : ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),H_a,A2) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C4,Fs3)) ) ) ) ).

tff(fact_53_hextI,axiom,
    ! [H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( ! [A3: nat,C3: list(char),Fs: fun(product_prod(list(char),list(char)),option(val))] :
          ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Ha,A3) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C3,Fs)) )
         => ? [Fs1: fun(product_prod(list(char),list(char)),option(val))] : ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),H_a,A3) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C3,Fs1)) ) )
     => hext(Ha,H_a) ) ).

tff(fact_54_equals0I,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [Y1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),A1))
     => ( A1 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_55_red__lcl__add,axiom,
    ! [L_0: fun(list(char),option(val)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L_a: fun(list(char),option(val)),H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E_a: exp(list(char)),La: fun(list(char),option(val)),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ea: exp(list(char))] :
      ( pp(aa(fun(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),bool),bool,aa(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),fun(fun(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),bool),bool),member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,La)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_a,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_a,L_a)))),red(Pa)))
     => pp(aa(fun(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),bool),bool,aa(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),fun(fun(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),bool),bool),member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,map_add(list(char),val,L_0,La))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_a,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_a,map_add(list(char),val,L_0,L_a))))),red(Pa))) ) ).

tff(fact_56_Option_Oset_Osimps_I2_J,axiom,
    ! [A: $tType,X1: A] : ( set(A,some(A,X1)) = insert(A,X1,bot_bot(fun(A,bool))) ) ).

tff(fact_57_insertCI,axiom,
    ! [A: $tType,B2: A,B4: fun(A,bool),A2: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),B4))
       => ( A2 = B2 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B2,B4))) ) ).

tff(fact_58_insertE,axiom,
    ! [A: $tType,A1: fun(A,bool),B2: A,A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B2,A1)))
     => ( ( A2 != B2 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1)) ) ) ).

tff(fact_59_insert__iff,axiom,
    ! [A: $tType,A1: fun(A,bool),B2: A,A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B2,A1)))
    <=> ( ( A2 = B2 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1)) ) ) ).

tff(fact_60_insert__absorb2,axiom,
    ! [A: $tType,A1: fun(A,bool),X1: A] : ( insert(A,X1,insert(A,X1,A1)) = insert(A,X1,A1) ) ).

tff(fact_61_singleton__inject,axiom,
    ! [A: $tType,B2: A,A2: A] :
      ( ( insert(A,A2,bot_bot(fun(A,bool))) = insert(A,B2,bot_bot(fun(A,bool))) )
     => ( A2 = B2 ) ) ).

tff(fact_62_singletonE,axiom,
    ! [A: $tType,A2: A,B2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),insert(A,A2,bot_bot(fun(A,bool)))))
     => ( B2 = A2 ) ) ).

tff(fact_63_doubleton__eq__iff,axiom,
    ! [A: $tType,D: A,C1: A,B2: A,A2: A] :
      ( ( insert(A,A2,insert(A,B2,bot_bot(fun(A,bool)))) = insert(A,C1,insert(A,D,bot_bot(fun(A,bool)))) )
    <=> ( ( ( A2 = C1 )
          & ( B2 = D ) )
        | ( ( A2 = D )
          & ( B2 = C1 ) ) ) ) ).

tff(fact_64_singleton__iff,axiom,
    ! [A: $tType,A2: A,B2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),insert(A,A2,bot_bot(fun(A,bool)))))
    <=> ( B2 = A2 ) ) ).

tff(fact_65_insert__not__empty,axiom,
    ! [A: $tType,A1: fun(A,bool),A2: A] : ( insert(A,A2,A1) != bot_bot(fun(A,bool)) ) ).

tff(fact_66_empty__not__insert,axiom,
    ! [A: $tType,A1: fun(A,bool),A2: A] : ( bot_bot(fun(A,bool)) != insert(A,A2,A1) ) ).

tff(fact_67_insert__absorb,axiom,
    ! [A: $tType,A1: fun(A,bool),A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1))
     => ( insert(A,A2,A1) = A1 ) ) ).

tff(fact_68_insertI2,axiom,
    ! [A: $tType,B2: A,B4: fun(A,bool),A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),B4))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B2,B4))) ) ).

tff(fact_69_insert__eq__iff,axiom,
    ! [A: $tType,B4: fun(A,bool),B2: A,A1: fun(A,bool),A2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),B4))
       => ( ( insert(A,A2,A1) = insert(A,B2,B4) )
        <=> ( ( ( A2 = B2 )
             => ( A1 = B4 ) )
            & ( ( A2 != B2 )
             => ? [C2: fun(A,bool)] :
                  ( ( A1 = insert(A,B2,C2) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),C2))
                  & ( B4 = insert(A,A2,C2) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),C2)) ) ) ) ) ) ) ).

tff(fact_70_insert__ident,axiom,
    ! [A: $tType,B4: fun(A,bool),A1: fun(A,bool),X1: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),B4))
       => ( ( insert(A,X1,A1) = insert(A,X1,B4) )
        <=> ( A1 = B4 ) ) ) ) ).

tff(fact_71_insert__code,axiom,
    ! [A: $tType,X1: A,A1: fun(A,bool),Y2: A] :
      ( pp(aa(A,bool,insert(A,Y2,A1),X1))
    <=> ( ( Y2 = X1 )
        | pp(aa(A,bool,A1,X1)) ) ) ).

tff(fact_72_insert__commute,axiom,
    ! [A: $tType,A1: fun(A,bool),Y2: A,X1: A] : ( insert(A,X1,insert(A,Y2,A1)) = insert(A,Y2,insert(A,X1,A1)) ) ).

tff(fact_73_insert__Collect,axiom,
    ! [A: $tType,Pa: fun(A,bool),A2: A] : ( insert(A,A2,collect(A,Pa)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fimplies,combb(bool,bool,A,fNot,combc(A,A,bool,fequal(A),A2))),Pa)) ) ).

tff(fact_74_insert__compr,axiom,
    ! [A: $tType,B4: fun(A,bool),A2: A] : ( insert(A,A2,B4) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),A2)),combc(A,fun(A,bool),bool,member(A),B4))) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A1))
    <=> pp(aa(A,bool,A1,X1)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,Pa: fun(A,bool)] : ( collect(A,Pa) = Pa ) ).

tff(fact_78_insertI1,axiom,
    ! [A: $tType,B4: fun(A,bool),A2: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,A2,B4))) ).

tff(fact_79_map__add__None,axiom,
    ! [B: $tType,A: $tType,K: B,N: fun(B,option(A)),M: fun(B,option(A))] :
      ( ( aa(B,option(A),map_add(B,A,M,N),K) = none(A) )
    <=> ( ( aa(B,option(A),N,K) = none(A) )
        & ( aa(B,option(A),M,K) = none(A) ) ) ) ).

tff(fact_80_map__add__Some__iff,axiom,
    ! [B: $tType,A: $tType,X1: A,K: B,N: fun(B,option(A)),M: fun(B,option(A))] :
      ( ( aa(B,option(A),map_add(B,A,M,N),K) = some(A,X1) )
    <=> ( ( aa(B,option(A),N,K) = some(A,X1) )
        | ( ( aa(B,option(A),N,K) = none(A) )
          & ( aa(B,option(A),M,K) = some(A,X1) ) ) ) ) ).

tff(fact_81_map__add__SomeD,axiom,
    ! [B: $tType,A: $tType,X1: A,K: B,N: fun(B,option(A)),M: fun(B,option(A))] :
      ( ( aa(B,option(A),map_add(B,A,M,N),K) = some(A,X1) )
     => ( ( aa(B,option(A),N,K) = some(A,X1) )
        | ( ( aa(B,option(A),N,K) = none(A) )
          & ( aa(B,option(A),M,K) = some(A,X1) ) ) ) ) ).

tff(fact_82_map__add__assoc,axiom,
    ! [B: $tType,A: $tType,M3: fun(A,option(B)),M2: fun(A,option(B)),M1: fun(A,option(B))] : ( map_add(A,B,M1,map_add(A,B,M2,M3)) = map_add(A,B,map_add(A,B,M1,M2),M3) ) ).

tff(fact_83_map__add__find__right,axiom,
    ! [B: $tType,A: $tType,M: fun(B,option(A)),Xx: A,K: B,N: fun(B,option(A))] :
      ( ( aa(B,option(A),N,K) = some(A,Xx) )
     => ( aa(B,option(A),map_add(B,A,M,N),K) = some(A,Xx) ) ) ).

tff(fact_84_the__elem__eq,axiom,
    ! [A: $tType,X1: A] : ( the_elem(A,insert(A,X1,bot_bot(fun(A,bool)))) = X1 ) ).

tff(fact_85_Red__lcl__add,axiom,
    ! [L_0: fun(list(char),option(val)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L_a: fun(list(char),option(val)),H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E_a: exp(list(char)),La: fun(list(char),option(val)),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ea: exp(list(char))] :
      ( pp(aa(fun(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),bool),bool,aa(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),fun(fun(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),bool),bool),member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,La)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_a,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_a,L_a)))),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa))))
     => pp(aa(fun(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),bool),bool,aa(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),fun(fun(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),bool),bool),member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,map_add(list(char),val,L_0,La))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_a,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_a,map_add(list(char),val,L_0,L_a))))),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa)))) ) ).

tff(fact_86_rtrancl_Ortrancl__refl,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),A2: A] : pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,A2,A2)),transitive_rtrancl(A,R1))) ).

tff(fact_87_rtrancl__idemp,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool)] : ( transitive_rtrancl(A,transitive_rtrancl(A,R1)) = transitive_rtrancl(A,R1) ) ).

tff(fact_88_r__into__rtrancl,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),P1: product_prod(A,A)] :
      ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),P1),R1))
     => pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),P1),transitive_rtrancl(A,R1))) ) ).

tff(fact_89_rtrancl__trans,axiom,
    ! [A: $tType,C1: A,R1: fun(product_prod(A,A),bool),B2: A,A2: A] :
      ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,A2,B2)),transitive_rtrancl(A,R1)))
     => ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,B2,C1)),transitive_rtrancl(A,R1)))
       => pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,A2,C1)),transitive_rtrancl(A,R1))) ) ) ).

tff(fact_90_rtrancl_Ortrancl__into__rtrancl,axiom,
    ! [A: $tType,C1: A,R1: fun(product_prod(A,A),bool),B2: A,A2: A] :
      ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,A2,B2)),transitive_rtrancl(A,R1)))
     => ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,B2,C1)),R1))
       => pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,A2,C1)),transitive_rtrancl(A,R1))) ) ) ).

tff(fact_91_converse__rtrancl__into__rtrancl,axiom,
    ! [A: $tType,C1: A,R1: fun(product_prod(A,A),bool),B2: A,A2: A] :
      ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,A2,B2)),R1))
     => ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,B2,C1)),transitive_rtrancl(A,R1)))
       => pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,A2,C1)),transitive_rtrancl(A,R1))) ) ) ).

tff(fact_92_rtrancl__induct2,axiom,
    ! [A: $tType,B: $tType,Pa: fun(A,fun(B,bool)),R1: fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),By: B,Bx: A,Ay: B,Ax: A] :
      ( pp(aa(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool,aa(product_prod(product_prod(A,B),product_prod(A,B)),fun(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool),member(product_prod(product_prod(A,B),product_prod(A,B))),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,Ax,Ay),product_Pair(A,B,Bx,By))),transitive_rtrancl(product_prod(A,B),R1)))
     => ( pp(aa(B,bool,aa(A,fun(B,bool),Pa,Ax),Ay))
       => ( ! [A3: A,B3: B,Aa: A,Ba: B] :
              ( pp(aa(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool,aa(product_prod(product_prod(A,B),product_prod(A,B)),fun(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool),member(product_prod(product_prod(A,B),product_prod(A,B))),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,Ax,Ay),product_Pair(A,B,A3,B3))),transitive_rtrancl(product_prod(A,B),R1)))
             => ( pp(aa(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool,aa(product_prod(product_prod(A,B),product_prod(A,B)),fun(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool),member(product_prod(product_prod(A,B),product_prod(A,B))),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,A3,B3),product_Pair(A,B,Aa,Ba))),R1))
               => ( pp(aa(B,bool,aa(A,fun(B,bool),Pa,A3),B3))
                 => pp(aa(B,bool,aa(A,fun(B,bool),Pa,Aa),Ba)) ) ) )
         => pp(aa(B,bool,aa(A,fun(B,bool),Pa,Bx),By)) ) ) ) ).

tff(fact_93_converse__rtrancl__induct2,axiom,
    ! [A: $tType,B: $tType,Pa: fun(A,fun(B,bool)),R1: fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),By: B,Bx: A,Ay: B,Ax: A] :
      ( pp(aa(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool,aa(product_prod(product_prod(A,B),product_prod(A,B)),fun(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool),member(product_prod(product_prod(A,B),product_prod(A,B))),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,Ax,Ay),product_Pair(A,B,Bx,By))),transitive_rtrancl(product_prod(A,B),R1)))
     => ( pp(aa(B,bool,aa(A,fun(B,bool),Pa,Bx),By))
       => ( ! [A3: A,B3: B,Aa: A,Ba: B] :
              ( pp(aa(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool,aa(product_prod(product_prod(A,B),product_prod(A,B)),fun(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool),member(product_prod(product_prod(A,B),product_prod(A,B))),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,A3,B3),product_Pair(A,B,Aa,Ba))),R1))
             => ( pp(aa(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool,aa(product_prod(product_prod(A,B),product_prod(A,B)),fun(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool),member(product_prod(product_prod(A,B),product_prod(A,B))),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,Aa,Ba),product_Pair(A,B,Bx,By))),transitive_rtrancl(product_prod(A,B),R1)))
               => ( pp(aa(B,bool,aa(A,fun(B,bool),Pa,Aa),Ba))
                 => pp(aa(B,bool,aa(A,fun(B,bool),Pa,A3),B3)) ) ) )
         => pp(aa(B,bool,aa(A,fun(B,bool),Pa,Ax),Ay)) ) ) ) ).

tff(fact_94_converse__rtranclE2,axiom,
    ! [B: $tType,A: $tType,R1: fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),Zb: B,Za: A,Xb: B,Xa: A] :
      ( pp(aa(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool,aa(product_prod(product_prod(A,B),product_prod(A,B)),fun(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool),member(product_prod(product_prod(A,B),product_prod(A,B))),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,Xa,Xb),product_Pair(A,B,Za,Zb))),transitive_rtrancl(product_prod(A,B),R1)))
     => ( ( product_Pair(A,B,Xa,Xb) != product_Pair(A,B,Za,Zb) )
       => ~ ! [A3: A,B3: B] :
              ( pp(aa(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool,aa(product_prod(product_prod(A,B),product_prod(A,B)),fun(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool),member(product_prod(product_prod(A,B),product_prod(A,B))),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,Xa,Xb),product_Pair(A,B,A3,B3))),R1))
             => ~ pp(aa(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool,aa(product_prod(product_prod(A,B),product_prod(A,B)),fun(fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),bool),member(product_prod(product_prod(A,B),product_prod(A,B))),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,A3,B3),product_Pair(A,B,Za,Zb))),transitive_rtrancl(product_prod(A,B),R1))) ) ) ) ).

tff(fact_95_rtrancl__induct,axiom,
    ! [A: $tType,Pa: fun(A,bool),R1: fun(product_prod(A,A),bool),B2: A,A2: A] :
      ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,A2,B2)),transitive_rtrancl(A,R1)))
     => ( pp(aa(A,bool,Pa,A2))
       => ( ! [Y1: A,Z: A] :
              ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,A2,Y1)),transitive_rtrancl(A,R1)))
             => ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,Y1,Z)),R1))
               => ( pp(aa(A,bool,Pa,Y1))
                 => pp(aa(A,bool,Pa,Z)) ) ) )
         => pp(aa(A,bool,Pa,B2)) ) ) ) ).

tff(fact_96_rtranclE,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),B2: A,A2: A] :
      ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,A2,B2)),transitive_rtrancl(A,R1)))
     => ( ( A2 != B2 )
       => ~ ! [Y1: A] :
              ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,A2,Y1)),transitive_rtrancl(A,R1)))
             => ~ pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,Y1,B2)),R1)) ) ) ) ).

tff(fact_97_converse__rtranclE,axiom,
    ! [A: $tType,R1: fun(product_prod(A,A),bool),Z1: A,X1: A] :
      ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,X1,Z1)),transitive_rtrancl(A,R1)))
     => ( ( X1 != Z1 )
       => ~ ! [Y1: A] :
              ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,X1,Y1)),R1))
             => ~ pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,Y1,Z1)),transitive_rtrancl(A,R1))) ) ) ) ).

tff(fact_98_converse__rtrancl__induct,axiom,
    ! [A: $tType,Pa: fun(A,bool),R1: fun(product_prod(A,A),bool),B2: A,A2: A] :
      ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,A2,B2)),transitive_rtrancl(A,R1)))
     => ( pp(aa(A,bool,Pa,B2))
       => ( ! [Y1: A,Z: A] :
              ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,Y1,Z)),R1))
             => ( pp(aa(fun(product_prod(A,A),bool),bool,aa(product_prod(A,A),fun(fun(product_prod(A,A),bool),bool),member(product_prod(A,A)),product_Pair(A,A,Z,B2)),transitive_rtrancl(A,R1)))
               => ( pp(aa(A,bool,Pa,Z))
                 => pp(aa(A,bool,Pa,Y1)) ) ) )
         => pp(aa(A,bool,Pa,A2)) ) ) ) ).

tff(fact_99_Set_Oset__insert,axiom,
    ! [A: $tType,A1: fun(A,bool),X1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A1))
     => ~ ! [B1: fun(A,bool)] :
            ( ( A1 = insert(A,X1,B1) )
           => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),B1)) ) ) ).

%----Arities (3)
tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Orderings_Obot,axiom,
    bot(nat) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (18)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (7)
tff(conj_0,hypothesis,
    pp(aa(fun(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),bool),bool,aa(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),fun(fun(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),bool),bool),member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),a1,b)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),e_a,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),aa1,ba)))),red(p))) ).

tff(conj_1,hypothesis,
    a(list(char),e_a) = none(fun(list(char),bool)) ).

tff(conj_2,hypothesis,
    a(list(char),ea) = none(fun(list(char),bool)) ).

tff(conj_3,hypothesis,
    a(list(char),e_2) = some(fun(list(char),bool),ab) ).

tff(conj_4,hypothesis,
    aa(list(char),option(val),b,x) = some(val,y) ).

tff(conj_5,hypothesis,
    aa(list(char),option(val),ba,x) = none(val) ).

tff(conj_6,conjecture,
    pp(aa(fun(list(char),bool),bool,aa(list(char),fun(fun(list(char),bool),bool),member(list(char)),x),ab)) ).

%------------------------------------------------------------------------------
