%------------------------------------------------------------------------------
% File     : SWW556_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Java type soundness line 112
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : jinja_112 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  155 (  35 unt;  49 typ;   0 def)
%            Number of atoms       :  262 ( 132 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  208 (  52   ~;  13   |;  37   &)
%                                         (  31 <=>;  75  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   8 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   57 (  33   >;  24   *;   0   +;   0  <<)
%            Number of predicates  :    5 (   4 usr;   0 prp; 1-3 aty)
%            Number of functors    :   40 (  40 usr;  10 con; 0-6 aty)
%            Number of variables   :  567 ( 494   !;  34   ?; 567   :)
%                                         (  39  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:54
%------------------------------------------------------------------------------
%----Should-be-implicit typings (10)
tff(ty_tc_Expr_Oexp,type,
    exp: $tType > $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Option_Ooption,type,
    option: $tType > $tType ).

tff(ty_tc_String_Ochar,type,
    char: $tType ).

tff(ty_tc_Type_Oty,type,
    ty: $tType ).

tff(ty_tc_Value_Oval,type,
    val: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (39)
tff(sy_c_DefAss_O_092_060D_062,type,
    d: 
      !>[A1: $tType] : ( ( exp(A1) * option(fun(A1,bool)) ) > $o ) ).

tff(sy_c_DefAss_OhyperUn,type,
    hyperUn: 
      !>[A1: $tType] : ( ( option(fun(A1,bool)) * option(fun(A1,bool)) ) > option(fun(A1,bool)) ) ).

tff(sy_c_List_Oappend,type,
    append: 
      !>[A1: $tType] : ( ( list(A1) * list(A1) ) > list(A1) ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A1: $tType] : ( ( A1 * list(A1) ) > list(A1) ) ).

tff(sy_c_List_Olex,type,
    lex: 
      !>[A1: $tType] : ( fun(product_prod(A1,A1),bool) > fun(product_prod(list(A1),list(A1)),bool) ) ).

tff(sy_c_List_Olexn,type,
    lexn: 
      !>[A1: $tType] : ( ( fun(product_prod(A1,A1),bool) * nat ) > fun(product_prod(list(A1),list(A1)),bool) ) ).

tff(sy_c_List_Olexord,type,
    lexord: 
      !>[A1: $tType] : ( fun(product_prod(A1,A1),bool) > fun(product_prod(list(A1),list(A1)),bool) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A1: $tType] : ( ( A1 * list(A1) ) > list(A1) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A1: $tType] : list(A1) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A1: $tType] : ( ( T * fun(A1,fun(list(A1),T)) * list(A1) ) > T ) ).

tff(sy_c_List_Olistrel1,type,
    listrel1: 
      !>[A1: $tType] : ( fun(product_prod(A1,A1),bool) > fun(product_prod(list(A1),list(A1)),bool) ) ).

tff(sy_c_List_Omaps,type,
    maps: 
      !>[A1: $tType,B: $tType] : ( ( fun(A1,list(B)) * list(A1) ) > list(B) ) ).

tff(sy_c_List_Opartition,type,
    partition: 
      !>[A1: $tType] : ( ( fun(A1,bool) * list(A1) ) > product_prod(list(A1),list(A1)) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A1: $tType] : ( list(A1) > fun(A1,bool) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A1: $tType] : ( ( list(A1) * list(A1) ) > list(A1) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A1: $tType] : ( A1 > nat ) ).

tff(sy_c_Option_Ois__none,type,
    is_none: 
      !>[A1: $tType] : ( option(A1) > $o ) ).

tff(sy_c_Option_Ooption_OSome,type,
    some: 
      !>[A1: $tType] : ( A1 > option(A1) ) ).

tff(sy_c_Option_Ooption_Ooption__case,type,
    option_case: 
      !>[T: $tType,A1: $tType] : ( ( T * fun(A1,T) * option(A1) ) > T ) ).

tff(sy_c_Option_Ooption_Ooption__rec,type,
    option_rec: 
      !>[T: $tType,A1: $tType] : ( ( T * fun(A1,T) * option(A1) ) > T ) ).

tff(sy_c_Option_Oset,type,
    set1: 
      !>[A1: $tType] : ( option(A1) > fun(A1,bool) ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A1: $tType,B: $tType] : ( ( A1 * B ) > product_prod(A1,B) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A1: $tType,B: $tType,C1: $tType] : ( ( fun(product_prod(A1,B),C1) * A1 * B ) > C1 ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A1: $tType,B: $tType,C1: $tType] : ( ( fun(A1,fun(B,C1)) * product_prod(A1,B) ) > C1 ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A1: $tType,B: $tType,T: $tType] : ( ( fun(A1,fun(B,T)) * product_prod(A1,B) ) > T ) ).

tff(sy_c_SmallStep_Oblocks,type,
    blocks: product_prod(list(list(char)),product_prod(list(ty),product_prod(list(val),exp(list(char))))) > exp(list(char)) ).

tff(sy_c_aa,type,
    aa: 
      !>[A1: $tType,B: $tType] : ( ( fun(A1,B) * A1 ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A1: $tType] : ( ( A1 * fun(A1,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_A,type,
    a: option(fun(list(char),bool)) ).

tff(sy_v_T,type,
    t: ty ).

tff(sy_v_Tsa,type,
    tsa: list(ty) ).

tff(sy_v_V,type,
    v: list(char) ).

tff(sy_v_Vsa,type,
    vsa: list(list(char)) ).

tff(sy_v_ea,type,
    ea: exp(list(char)) ).

tff(sy_v_v,type,
    v1: val ).

tff(sy_v_vsa,type,
    vsa1: list(val) ).

%----Relevant facts (100)
tff(fact_0_option_Oinject,axiom,
    ! [A1: $tType,A8: A1,A5: A1] :
      ( ( some(A1,A5) = some(A1,A8) )
    <=> ( A5 = A8 ) ) ).

tff(fact_1_list_Oinject,axiom,
    ! [A1: $tType,List2: list(A1),A8: A1,List1: list(A1),A5: A1] :
      ( ( cons(A1,A5,List1) = cons(A1,A8,List2) )
    <=> ( ( A5 = A8 )
        & ( List1 = List2 ) ) ) ).

tff(fact_2_split__paired__All,axiom,
    ! [A1: $tType,B: $tType,P: fun(product_prod(A1,B),bool)] :
      ( ! [X11: product_prod(A1,B)] : pp(aa(product_prod(A1,B),bool,P,X11))
    <=> ! [A6: A1,B5: B] : pp(aa(product_prod(A1,B),bool,P,product_Pair(A1,B,A6,B5))) ) ).

tff(fact_3_Pair__eq,axiom,
    ! [A1: $tType,B: $tType,B8: B,A8: A1,B3: B,A5: A1] :
      ( ( product_Pair(A1,B,A5,B3) = product_Pair(A1,B,A8,B8) )
    <=> ( ( A5 = A8 )
        & ( B3 = B8 ) ) ) ).

tff(fact_4_set__ConsD,axiom,
    ! [A1: $tType,Xs1: list(A1),X: A1,Y: A1] :
      ( member(A1,Y,set(A1,cons(A1,X,Xs1)))
     => ( ( Y = X )
        | member(A1,Y,set(A1,Xs1)) ) ) ).

tff(fact_5_prod__induct6,axiom,
    ! [F3: $tType,E: $tType,D: $tType,C1: $tType,B: $tType,A1: $tType,X: product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F3))))),P: fun(product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F3))))),bool)] :
      ( ! [A4: A1,B4: B,C3: C1,D1: D,E1: E,F4: F3] : pp(aa(product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F3))))),bool,P,product_Pair(A1,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F3)))),A4,product_Pair(B,product_prod(C1,product_prod(D,product_prod(E,F3))),B4,product_Pair(C1,product_prod(D,product_prod(E,F3)),C3,product_Pair(D,product_prod(E,F3),D1,product_Pair(E,F3,E1,F4)))))))
     => pp(aa(product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F3))))),bool,P,X)) ) ).

tff(fact_6_prod__cases6,axiom,
    ! [A1: $tType,B: $tType,C1: $tType,D: $tType,E: $tType,F3: $tType,Y2: product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F3)))))] :
      ~ ! [A4: A1,B4: B,C3: C1,D1: D,E1: E,F4: F3] : ( Y2 != product_Pair(A1,product_prod(B,product_prod(C1,product_prod(D,product_prod(E,F3)))),A4,product_Pair(B,product_prod(C1,product_prod(D,product_prod(E,F3))),B4,product_Pair(C1,product_prod(D,product_prod(E,F3)),C3,product_Pair(D,product_prod(E,F3),D1,product_Pair(E,F3,E1,F4))))) ) ).

tff(fact_7_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C1: $tType,B: $tType,A1: $tType,X: product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,E)))),P: fun(product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,E)))),bool)] :
      ( ! [A4: A1,B4: B,C3: C1,D1: D,E1: E] : pp(aa(product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,E)))),bool,P,product_Pair(A1,product_prod(B,product_prod(C1,product_prod(D,E))),A4,product_Pair(B,product_prod(C1,product_prod(D,E)),B4,product_Pair(C1,product_prod(D,E),C3,product_Pair(D,E,D1,E1))))))
     => pp(aa(product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,E)))),bool,P,X)) ) ).

tff(fact_8_prod__cases5,axiom,
    ! [A1: $tType,B: $tType,C1: $tType,D: $tType,E: $tType,Y2: product_prod(A1,product_prod(B,product_prod(C1,product_prod(D,E))))] :
      ~ ! [A4: A1,B4: B,C3: C1,D1: D,E1: E] : ( Y2 != product_Pair(A1,product_prod(B,product_prod(C1,product_prod(D,E))),A4,product_Pair(B,product_prod(C1,product_prod(D,E)),B4,product_Pair(C1,product_prod(D,E),C3,product_Pair(D,E,D1,E1)))) ) ).

tff(fact_9_prod__induct4,axiom,
    ! [D: $tType,C1: $tType,B: $tType,A1: $tType,X: product_prod(A1,product_prod(B,product_prod(C1,D))),P: fun(product_prod(A1,product_prod(B,product_prod(C1,D))),bool)] :
      ( ! [A4: A1,B4: B,C3: C1,D1: D] : pp(aa(product_prod(A1,product_prod(B,product_prod(C1,D))),bool,P,product_Pair(A1,product_prod(B,product_prod(C1,D)),A4,product_Pair(B,product_prod(C1,D),B4,product_Pair(C1,D,C3,D1)))))
     => pp(aa(product_prod(A1,product_prod(B,product_prod(C1,D))),bool,P,X)) ) ).

tff(fact_10_prod__cases4,axiom,
    ! [A1: $tType,B: $tType,C1: $tType,D: $tType,Y2: product_prod(A1,product_prod(B,product_prod(C1,D)))] :
      ~ ! [A4: A1,B4: B,C3: C1,D1: D] : ( Y2 != product_Pair(A1,product_prod(B,product_prod(C1,D)),A4,product_Pair(B,product_prod(C1,D),B4,product_Pair(C1,D,C3,D1))) ) ).

tff(fact_11_Cons__in__lex,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool),Ys1: list(A1),Y: A1,Xs1: list(A1),X: A1] :
      ( member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),cons(A1,X,Xs1),cons(A1,Y,Ys1)),lex(A1,R))
    <=> ( ( member(product_prod(A1,A1),product_Pair(A1,A1,X,Y),R)
          & ( size_size(list(A1),Xs1) = size_size(list(A1),Ys1) ) )
        | ( ( X = Y )
          & member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),Xs1,Ys1),lex(A1,R)) ) ) ) ).

tff(fact_12_Pair__inject,axiom,
    ! [A1: $tType,B: $tType,B7: B,A2: A1,B6: B,A7: A1] :
      ( ( product_Pair(A1,B,A7,B6) = product_Pair(A1,B,A2,B7) )
     => ~ ( ( A7 = A2 )
         => ( B6 != B7 ) ) ) ).

tff(fact_13_not__Cons__self2,axiom,
    ! [A1: $tType,Xs: list(A1),X1: A1] : ( cons(A1,X1,Xs) != Xs ) ).

tff(fact_14_not__Cons__self,axiom,
    ! [A1: $tType,X1: A1,Xs: list(A1)] : ( Xs != cons(A1,X1,Xs) ) ).

tff(fact_15_neq__if__length__neq,axiom,
    ! [A1: $tType,Ys: list(A1),Xs: list(A1)] :
      ( ( size_size(list(A1),Xs) != size_size(list(A1),Ys) )
     => ( Xs != Ys ) ) ).

tff(fact_16_split__paired__Ex,axiom,
    ! [A1: $tType,B: $tType,P: fun(product_prod(A1,B),bool)] :
      ( ? [X11: product_prod(A1,B)] : pp(aa(product_prod(A1,B),bool,P,X11))
    <=> ? [A6: A1,B5: B] : pp(aa(product_prod(A1,B),bool,P,product_Pair(A1,B,A6,B5))) ) ).

tff(fact_17_prod__cases3,axiom,
    ! [A1: $tType,B: $tType,C1: $tType,Y2: product_prod(A1,product_prod(B,C1))] :
      ~ ! [A4: A1,B4: B,C3: C1] : ( Y2 != product_Pair(A1,product_prod(B,C1),A4,product_Pair(B,C1,B4,C3)) ) ).

tff(fact_18_prod__induct3,axiom,
    ! [C1: $tType,B: $tType,A1: $tType,X: product_prod(A1,product_prod(B,C1)),P: fun(product_prod(A1,product_prod(B,C1)),bool)] :
      ( ! [A4: A1,B4: B,C3: C1] : pp(aa(product_prod(A1,product_prod(B,C1)),bool,P,product_Pair(A1,product_prod(B,C1),A4,product_Pair(B,C1,B4,C3))))
     => pp(aa(product_prod(A1,product_prod(B,C1)),bool,P,X)) ) ).

tff(fact_19_prod_Orecs,axiom,
    ! [B: $tType,A1: $tType,C1: $tType,B3: C1,A5: B,F1: fun(B,fun(C1,A1))] : ( product_prod_rec(B,C1,A1,F1,product_Pair(B,C1,A5,B3)) = aa(C1,A1,aa(B,fun(C1,A1),F1,A5),B3) ) ).

tff(fact_20_lexord__cons__cons,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool),Y: list(A1),B3: A1,X: list(A1),A5: A1] :
      ( member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),cons(A1,A5,X),cons(A1,B3,Y)),lexord(A1,R))
    <=> ( member(product_prod(A1,A1),product_Pair(A1,A1,A5,B3),R)
        | ( ( A5 = B3 )
          & member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),X,Y),lexord(A1,R)) ) ) ) ).

tff(fact_21_elem__set,axiom,
    ! [A1: $tType,Xo: option(A1),X: A1] :
      ( member(A1,X,set1(A1,Xo))
    <=> ( Xo = some(A1,X) ) ) ).

tff(fact_22_lexn__length,axiom,
    ! [A1: $tType,N1: nat,R: fun(product_prod(A1,A1),bool),Ys1: list(A1),Xs1: list(A1)] :
      ( member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),Xs1,Ys1),lexn(A1,R,N1))
     => ( ( size_size(list(A1),Xs1) = N1 )
        & ( size_size(list(A1),Ys1) = N1 ) ) ) ).

tff(fact_23_lexord__lex,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool),Y: list(A1),X: list(A1)] :
      ( member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),X,Y),lex(A1,R))
    <=> ( member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),X,Y),lexord(A1,R))
        & ( size_size(list(A1),X) = size_size(list(A1),Y) ) ) ) ).

tff(fact_24_option_Orecs_I2_J,axiom,
    ! [A1: $tType,B: $tType,A5: B,F2: fun(B,A1),F1: A1] : ( option_rec(A1,B,F1,F2,some(B,A5)) = aa(B,A1,F2,A5) ) ).

tff(fact_25_lexord__partial__trans,axiom,
    ! [A1: $tType,Zs: list(A1),Ys1: list(A1),R: fun(product_prod(A1,A1),bool),Xs1: list(A1)] :
      ( ! [X3: A1,Y1: A1,Z1: A1] :
          ( member(A1,X3,set(A1,Xs1))
         => ( member(product_prod(A1,A1),product_Pair(A1,A1,X3,Y1),R)
           => ( member(product_prod(A1,A1),product_Pair(A1,A1,Y1,Z1),R)
             => member(product_prod(A1,A1),product_Pair(A1,A1,X3,Z1),R) ) ) )
     => ( member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),Xs1,Ys1),lexord(A1,R))
       => ( member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),Ys1,Zs),lexord(A1,R))
         => member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),Xs1,Zs),lexord(A1,R)) ) ) ) ).

tff(fact_26_lexord__linear,axiom,
    ! [A1: $tType,Y: list(A1),X: list(A1),R: fun(product_prod(A1,A1),bool)] :
      ( ! [A4: A1,B4: A1] :
          ( member(product_prod(A1,A1),product_Pair(A1,A1,A4,B4),R)
          | ( A4 = B4 )
          | member(product_prod(A1,A1),product_Pair(A1,A1,B4,A4),R) )
     => ( member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),X,Y),lexord(A1,R))
        | ( X = Y )
        | member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),Y,X),lexord(A1,R)) ) ) ).

tff(fact_27_lexord__irreflexive,axiom,
    ! [A1: $tType,Xs1: list(A1),R: fun(product_prod(A1,A1),bool)] :
      ( ! [X3: A1] : ~ member(product_prod(A1,A1),product_Pair(A1,A1,X3,X3),R)
     => ~ member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),Xs1,Xs1),lexord(A1,R)) ) ).

tff(fact_28_ospec,axiom,
    ! [A1: $tType,X: A1,P: fun(A1,bool),A3: option(A1)] :
      ( ! [X3: A1] :
          ( member(A1,X3,set1(A1,A3))
         => pp(aa(A1,bool,P,X3)) )
     => ( ( A3 = some(A1,X) )
       => pp(aa(A1,bool,P,X)) ) ) ).

tff(fact_29_Ex__list__of__length,axiom,
    ! [A1: $tType,N: nat] :
    ? [Xs2: list(A1)] : ( size_size(list(A1),Xs2) = N ) ).

tff(fact_30_list_Osimps_I5_J,axiom,
    ! [A1: $tType,B: $tType,List1: list(B),A5: B,F2: fun(B,fun(list(B),A1)),F1: A1] : ( list_case(A1,B,F1,F2,cons(B,A5,List1)) = aa(list(B),A1,aa(B,fun(list(B),A1),F2,A5),List1) ) ).

tff(fact_31_PairE,axiom,
    ! [A1: $tType,B: $tType,P1: product_prod(A1,B)] :
      ~ ! [X3: A1,Y1: B] : ( P1 != product_Pair(A1,B,X3,Y1) ) ).

tff(fact_32_prod_Oexhaust,axiom,
    ! [A1: $tType,B: $tType,Y2: product_prod(A1,B)] :
      ~ ! [A4: A1,B4: B] : ( Y2 != product_Pair(A1,B,A4,B4) ) ).

tff(fact_33_internal__split__conv,axiom,
    ! [B: $tType,A1: $tType,C1: $tType,B3: C1,A5: B,C2: fun(B,fun(C1,A1))] : ( produc1605651328_split(B,C1,A1,C2,product_Pair(B,C1,A5,B3)) = aa(C1,A1,aa(B,fun(C1,A1),C2,A5),B3) ) ).

tff(fact_34_curry__conv,axiom,
    ! [A1: $tType,B: $tType,C1: $tType,B3: C1,A5: B,F: fun(product_prod(B,C1),A1)] : ( product_curry(B,C1,A1,F,A5,B3) = aa(product_prod(B,C1),A1,F,product_Pair(B,C1,A5,B3)) ) ).

tff(fact_35_partition__P,axiom,
    ! [A1: $tType,No: list(A1),Yes: list(A1),Xs1: list(A1),P: fun(A1,bool)] :
      ( ( partition(A1,P,Xs1) = product_Pair(list(A1),list(A1),Yes,No) )
     => ( ! [X4: A1] :
            ( member(A1,X4,set(A1,Yes))
           => pp(aa(A1,bool,P,X4)) )
        & ! [X4: A1] :
            ( member(A1,X4,set(A1,No))
           => ~ pp(aa(A1,bool,P,X4)) ) ) ) ).

tff(fact_36_splice_Osimps_I3_J,axiom,
    ! [A1: $tType,Ys: list(A1),Y2: A1,Xs: list(A1),X1: A1] : ( splice(A1,cons(A1,X1,Xs),cons(A1,Y2,Ys)) = cons(A1,X1,cons(A1,Y2,splice(A1,Xs,Ys))) ) ).

tff(fact_37_Cons__listrel1__Cons,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool),Ys1: list(A1),Y: A1,Xs1: list(A1),X: A1] :
      ( member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),cons(A1,X,Xs1),cons(A1,Y,Ys1)),listrel1(A1,R))
    <=> ( ( member(product_prod(A1,A1),product_Pair(A1,A1,X,Y),R)
          & ( Xs1 = Ys1 ) )
        | ( ( X = Y )
          & member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),Xs1,Ys1),listrel1(A1,R)) ) ) ) ).

tff(fact_38_curryI,axiom,
    ! [A1: $tType,B: $tType,B3: B,A5: A1,F: fun(product_prod(A1,B),bool)] :
      ( pp(aa(product_prod(A1,B),bool,F,product_Pair(A1,B,A5,B3)))
     => pp(product_curry(A1,B,bool,F,A5,B3)) ) ).

tff(fact_39_curryD,axiom,
    ! [A1: $tType,B: $tType,B3: B,A5: A1,F: fun(product_prod(A1,B),bool)] :
      ( pp(product_curry(A1,B,bool,F,A5,B3))
     => pp(aa(product_prod(A1,B),bool,F,product_Pair(A1,B,A5,B3))) ) ).

tff(fact_40_curryE,axiom,
    ! [A1: $tType,B: $tType,B3: B,A5: A1,F: fun(product_prod(A1,B),bool)] :
      ( pp(product_curry(A1,B,bool,F,A5,B3))
     => pp(aa(product_prod(A1,B),bool,F,product_Pair(A1,B,A5,B3))) ) ).

tff(fact_41_listrel1I2,axiom,
    ! [A1: $tType,X: A1,R: fun(product_prod(A1,A1),bool),Ys1: list(A1),Xs1: list(A1)] :
      ( member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),Xs1,Ys1),listrel1(A1,R))
     => member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),cons(A1,X,Xs1),cons(A1,X,Ys1)),listrel1(A1,R)) ) ).

tff(fact_42_listrel1__eq__len,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool),Ys1: list(A1),Xs1: list(A1)] :
      ( member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),Xs1,Ys1),listrel1(A1,R))
     => ( size_size(list(A1),Xs1) = size_size(list(A1),Ys1) ) ) ).

tff(fact_43_listrel1I1,axiom,
    ! [A1: $tType,Xs1: list(A1),R: fun(product_prod(A1,A1),bool),Y: A1,X: A1] :
      ( member(product_prod(A1,A1),product_Pair(A1,A1,X,Y),R)
     => member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),cons(A1,X,Xs1),cons(A1,Y,Xs1)),listrel1(A1,R)) ) ).

tff(fact_44_Cons__listrel1E2,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool),Ys1: list(A1),Y: A1,Xs1: list(A1)] :
      ( member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),Xs1,cons(A1,Y,Ys1)),listrel1(A1,R))
     => ( ! [X3: A1] :
            ( ( Xs1 = cons(A1,X3,Ys1) )
           => ~ member(product_prod(A1,A1),product_Pair(A1,A1,X3,Y),R) )
       => ~ ! [Zs1: list(A1)] :
              ( ( Xs1 = cons(A1,Y,Zs1) )
             => ~ member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),Zs1,Ys1),listrel1(A1,R)) ) ) ) ).

tff(fact_45_Cons__listrel1E1,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool),Ys1: list(A1),Xs1: list(A1),X: A1] :
      ( member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),cons(A1,X,Xs1),Ys1),listrel1(A1,R))
     => ( ! [Y1: A1] :
            ( ( Ys1 = cons(A1,Y1,Xs1) )
           => ~ member(product_prod(A1,A1),product_Pair(A1,A1,X,Y1),R) )
       => ~ ! [Zs1: list(A1)] :
              ( ( Ys1 = cons(A1,X,Zs1) )
             => ~ member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),Xs1,Zs1),listrel1(A1,R)) ) ) ) ).

tff(fact_46_List_Oinsert__def,axiom,
    ! [A1: $tType,Xs1: list(A1),X: A1] :
      ( ( member(A1,X,set(A1,Xs1))
       => ( insert(A1,X,Xs1) = Xs1 ) )
      & ( ~ member(A1,X,set(A1,Xs1))
       => ( insert(A1,X,Xs1) = cons(A1,X,Xs1) ) ) ) ).

tff(fact_47_not__in__set__insert,axiom,
    ! [A1: $tType,Xs1: list(A1),X: A1] :
      ( ~ member(A1,X,set(A1,Xs1))
     => ( insert(A1,X,Xs1) = cons(A1,X,Xs1) ) ) ).

tff(fact_48_is__none__code_I2_J,axiom,
    ! [B: $tType,X1: B] : ~ is_none(B,some(B,X1)) ).

tff(fact_49_in__set__insert,axiom,
    ! [A1: $tType,Xs1: list(A1),X: A1] :
      ( member(A1,X,set(A1,Xs1))
     => ( insert(A1,X,Xs1) = Xs1 ) ) ).

tff(fact_50_lexord__append__left__rightI,axiom,
    ! [A1: $tType,Y: list(A1),X: list(A1),U: list(A1),R: fun(product_prod(A1,A1),bool),B3: A1,A5: A1] :
      ( member(product_prod(A1,A1),product_Pair(A1,A1,A5,B3),R)
     => member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),append(A1,U,cons(A1,A5,X)),append(A1,U,cons(A1,B3,Y))),lexord(A1,R)) ) ).

tff(fact_51_hyperUn__assoc,axiom,
    ! [A1: $tType,C: option(fun(A1,bool)),B2: option(fun(A1,bool)),A3: option(fun(A1,bool))] : ( hyperUn(A1,hyperUn(A1,A3,B2),C) = hyperUn(A1,A3,hyperUn(A1,B2,C)) ) ).

tff(fact_52_listrel1I,axiom,
    ! [A1: $tType,Ys1: list(A1),Vsa: list(A1),Us1: list(A1),Xs1: list(A1),R: fun(product_prod(A1,A1),bool),Y: A1,X: A1] :
      ( member(product_prod(A1,A1),product_Pair(A1,A1,X,Y),R)
     => ( ( Xs1 = append(A1,Us1,cons(A1,X,Vsa)) )
       => ( ( Ys1 = append(A1,Us1,cons(A1,Y,Vsa)) )
         => member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),Xs1,Ys1),listrel1(A1,R)) ) ) ) ).

tff(fact_53_option_Osimps_I5_J,axiom,
    ! [A1: $tType,B: $tType,A5: B,F2: fun(B,A1),F1: A1] : ( option_case(A1,B,F1,F2,some(B,A5)) = aa(B,A1,F2,A5) ) ).

tff(fact_54_append__assoc,axiom,
    ! [A1: $tType,Zs3: list(A1),Ys: list(A1),Xs: list(A1)] : ( append(A1,append(A1,Xs,Ys),Zs3) = append(A1,Xs,append(A1,Ys,Zs3)) ) ).

tff(fact_55_same__append__eq,axiom,
    ! [A1: $tType,Zs: list(A1),Ys1: list(A1),Xs1: list(A1)] :
      ( ( append(A1,Xs1,Ys1) = append(A1,Xs1,Zs) )
    <=> ( Ys1 = Zs ) ) ).

tff(fact_56_append__same__eq,axiom,
    ! [A1: $tType,Zs: list(A1),Xs1: list(A1),Ys1: list(A1)] :
      ( ( append(A1,Ys1,Xs1) = append(A1,Zs,Xs1) )
    <=> ( Ys1 = Zs ) ) ).

tff(fact_57_append__Cons,axiom,
    ! [A1: $tType,Ys: list(A1),Xs: list(A1),X1: A1] : ( append(A1,cons(A1,X1,Xs),Ys) = cons(A1,X1,append(A1,Xs,Ys)) ) ).

tff(fact_58_append__eq__append__conv2,axiom,
    ! [A1: $tType,Ts: list(A1),Zs: list(A1),Ys1: list(A1),Xs1: list(A1)] :
      ( ( append(A1,Xs1,Ys1) = append(A1,Zs,Ts) )
    <=> ? [Us3: list(A1)] :
          ( ( ( Xs1 = append(A1,Zs,Us3) )
            & ( append(A1,Us3,Ys1) = Ts ) )
          | ( ( append(A1,Xs1,Us3) = Zs )
            & ( Ys1 = append(A1,Us3,Ts) ) ) ) ) ).

tff(fact_59_append__eq__appendI,axiom,
    ! [A1: $tType,Us2: list(A1),Ys: list(A1),Zs3: list(A1),Xs11: list(A1),Xs: list(A1)] :
      ( ( append(A1,Xs,Xs11) = Zs3 )
     => ( ( Ys = append(A1,Xs11,Us2) )
       => ( append(A1,Xs,Ys) = append(A1,Zs3,Us2) ) ) ) ).

tff(fact_60_Cons__eq__appendI,axiom,
    ! [A1: $tType,Zs3: list(A1),Xs: list(A1),Ys: list(A1),Xs11: list(A1),X1: A1] :
      ( ( cons(A1,X1,Xs11) = Ys )
     => ( ( Xs = append(A1,Xs11,Zs3) )
       => ( cons(A1,X1,Xs) = append(A1,Ys,Zs3) ) ) ) ).

tff(fact_61_append__listrel1I,axiom,
    ! [A1: $tType,Vsa: list(A1),Us1: list(A1),R: fun(product_prod(A1,A1),bool),Ys1: list(A1),Xs1: list(A1)] :
      ( ( ( member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),Xs1,Ys1),listrel1(A1,R))
          & ( Us1 = Vsa ) )
        | ( ( Xs1 = Ys1 )
          & member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),Us1,Vsa),listrel1(A1,R)) ) )
     => member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),append(A1,Xs1,Us1),append(A1,Ys1,Vsa)),listrel1(A1,R)) ) ).

tff(fact_62_lexord__append__leftI,axiom,
    ! [A1: $tType,X: list(A1),R: fun(product_prod(A1,A1),bool),V: list(A1),U: list(A1)] :
      ( member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),U,V),lexord(A1,R))
     => member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),append(A1,X,U),append(A1,X,V)),lexord(A1,R)) ) ).

tff(fact_63_listrel1E,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool),Ys1: list(A1),Xs1: list(A1)] :
      ( member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),Xs1,Ys1),listrel1(A1,R))
     => ~ ! [X3: A1,Y1: A1] :
            ( member(product_prod(A1,A1),product_Pair(A1,A1,X3,Y1),R)
           => ! [Us: list(A1),Vs: list(A1)] :
                ( ( Xs1 = append(A1,Us,cons(A1,X3,Vs)) )
               => ( Ys1 != append(A1,Us,cons(A1,Y1,Vs)) ) ) ) ) ).

tff(fact_64_lexord__append__rightI,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool),X: list(A1),Y: list(A1)] :
      ( ? [B1: A1,Z: list(A1)] : ( Y = cons(A1,B1,Z) )
     => member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),X,append(A1,X,Y)),lexord(A1,R)) ) ).

tff(fact_65_lexord__append__leftD,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool),V: list(A1),U: list(A1),X: list(A1)] :
      ( member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),append(A1,X,U),append(A1,X,V)),lexord(A1,R))
     => ( ! [A4: A1] : ~ member(product_prod(A1,A1),product_Pair(A1,A1,A4,A4),R)
       => member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),U,V),lexord(A1,R)) ) ) ).

tff(fact_66_in__set__conv__decomp,axiom,
    ! [A1: $tType,Xs1: list(A1),X: A1] :
      ( member(A1,X,set(A1,Xs1))
    <=> ? [Ys4: list(A1),Zs2: list(A1)] : ( Xs1 = append(A1,Ys4,cons(A1,X,Zs2)) ) ) ).

tff(fact_67_split__list__propE,axiom,
    ! [A1: $tType,P: fun(A1,bool),Xs1: list(A1)] :
      ( ? [X4: A1] :
          ( member(A1,X4,set(A1,Xs1))
          & pp(aa(A1,bool,P,X4)) )
     => ~ ! [Ys3: list(A1),X3: A1] :
            ( ? [Zs1: list(A1)] : ( Xs1 = append(A1,Ys3,cons(A1,X3,Zs1)) )
           => ~ pp(aa(A1,bool,P,X3)) ) ) ).

tff(fact_68_in__set__conv__decomp__first,axiom,
    ! [A1: $tType,Xs1: list(A1),X: A1] :
      ( member(A1,X,set(A1,Xs1))
    <=> ? [Ys4: list(A1),Zs2: list(A1)] :
          ( ( Xs1 = append(A1,Ys4,cons(A1,X,Zs2)) )
          & ~ member(A1,X,set(A1,Ys4)) ) ) ).

tff(fact_69_in__set__conv__decomp__last,axiom,
    ! [A1: $tType,Xs1: list(A1),X: A1] :
      ( member(A1,X,set(A1,Xs1))
    <=> ? [Ys4: list(A1),Zs2: list(A1)] :
          ( ( Xs1 = append(A1,Ys4,cons(A1,X,Zs2)) )
          & ~ member(A1,X,set(A1,Zs2)) ) ) ).

tff(fact_70_split__list__first__propE,axiom,
    ! [A1: $tType,P: fun(A1,bool),Xs1: list(A1)] :
      ( ? [X4: A1] :
          ( member(A1,X4,set(A1,Xs1))
          & pp(aa(A1,bool,P,X4)) )
     => ~ ! [Ys3: list(A1),X3: A1] :
            ( ? [Zs1: list(A1)] : ( Xs1 = append(A1,Ys3,cons(A1,X3,Zs1)) )
           => ( pp(aa(A1,bool,P,X3))
             => ~ ! [Xa1: A1] :
                    ( member(A1,Xa1,set(A1,Ys3))
                   => ~ pp(aa(A1,bool,P,Xa1)) ) ) ) ) ).

tff(fact_71_split__list__last__propE,axiom,
    ! [A1: $tType,P: fun(A1,bool),Xs1: list(A1)] :
      ( ? [X4: A1] :
          ( member(A1,X4,set(A1,Xs1))
          & pp(aa(A1,bool,P,X4)) )
     => ~ ! [Ys3: list(A1),X3: A1,Zs1: list(A1)] :
            ( ( Xs1 = append(A1,Ys3,cons(A1,X3,Zs1)) )
           => ( pp(aa(A1,bool,P,X3))
             => ~ ! [Xa1: A1] :
                    ( member(A1,Xa1,set(A1,Zs1))
                   => ~ pp(aa(A1,bool,P,Xa1)) ) ) ) ) ).

tff(fact_72_split__list__first,axiom,
    ! [A1: $tType,Xs1: list(A1),X: A1] :
      ( member(A1,X,set(A1,Xs1))
     => ? [Ys3: list(A1),Zs1: list(A1)] :
          ( ( Xs1 = append(A1,Ys3,cons(A1,X,Zs1)) )
          & ~ member(A1,X,set(A1,Ys3)) ) ) ).

tff(fact_73_split__list__last__prop__iff,axiom,
    ! [A1: $tType,P: fun(A1,bool),Xs1: list(A1)] :
      ( ? [X2: A1] :
          ( member(A1,X2,set(A1,Xs1))
          & pp(aa(A1,bool,P,X2)) )
    <=> ? [Ys4: list(A1),X2: A1,Zs2: list(A1)] :
          ( ( Xs1 = append(A1,Ys4,cons(A1,X2,Zs2)) )
          & pp(aa(A1,bool,P,X2))
          & ! [Xa: A1] :
              ( member(A1,Xa,set(A1,Zs2))
             => ~ pp(aa(A1,bool,P,Xa)) ) ) ) ).

tff(fact_74_split__list__first__prop__iff,axiom,
    ! [A1: $tType,P: fun(A1,bool),Xs1: list(A1)] :
      ( ? [X2: A1] :
          ( member(A1,X2,set(A1,Xs1))
          & pp(aa(A1,bool,P,X2)) )
    <=> ? [Ys4: list(A1),X2: A1] :
          ( ? [Zs2: list(A1)] : ( Xs1 = append(A1,Ys4,cons(A1,X2,Zs2)) )
          & pp(aa(A1,bool,P,X2))
          & ! [Xa: A1] :
              ( member(A1,Xa,set(A1,Ys4))
             => ~ pp(aa(A1,bool,P,Xa)) ) ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A1: $tType,A3: fun(A1,bool),X: A1] :
      ( member(A1,X,A3)
    <=> pp(aa(A1,bool,A3,X)) ) ).

tff(fact_76_split__list__last,axiom,
    ! [A1: $tType,Xs1: list(A1),X: A1] :
      ( member(A1,X,set(A1,Xs1))
     => ? [Ys3: list(A1),Zs1: list(A1)] :
          ( ( Xs1 = append(A1,Ys3,cons(A1,X,Zs1)) )
          & ~ member(A1,X,set(A1,Zs1)) ) ) ).

tff(fact_77_split__list,axiom,
    ! [A1: $tType,Xs1: list(A1),X: A1] :
      ( member(A1,X,set(A1,Xs1))
     => ? [Ys3: list(A1),Zs1: list(A1)] : ( Xs1 = append(A1,Ys3,cons(A1,X,Zs1)) ) ) ).

tff(fact_78_snoc__listrel1__snoc__iff,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool),Y: A1,Ys1: list(A1),X: A1,Xs1: list(A1)] :
      ( member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),append(A1,Xs1,cons(A1,X,nil(A1))),append(A1,Ys1,cons(A1,Y,nil(A1)))),listrel1(A1,R))
    <=> ( ( member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),Xs1,Ys1),listrel1(A1,R))
          & ( X = Y ) )
        | ( ( Xs1 = Ys1 )
          & member(product_prod(A1,A1),product_Pair(A1,A1,X,Y),R) ) ) ) ).

tff(fact_79_maps__simps_I1_J,axiom,
    ! [A1: $tType,B: $tType,Xs1: list(B),X: B,F: fun(B,list(A1))] : ( maps(B,A1,F,cons(B,X,Xs1)) = append(A1,aa(B,list(A1),F,X),maps(B,A1,F,Xs1)) ) ).

tff(fact_80_append__self__conv2,axiom,
    ! [A1: $tType,Ys1: list(A1),Xs1: list(A1)] :
      ( ( append(A1,Xs1,Ys1) = Ys1 )
    <=> ( Xs1 = nil(A1) ) ) ).

tff(fact_81_append__self__conv,axiom,
    ! [A1: $tType,Ys1: list(A1),Xs1: list(A1)] :
      ( ( append(A1,Xs1,Ys1) = Xs1 )
    <=> ( Ys1 = nil(A1) ) ) ).

tff(fact_82_append__is__Nil__conv,axiom,
    ! [A1: $tType,Ys1: list(A1),Xs1: list(A1)] :
      ( ( append(A1,Xs1,Ys1) = nil(A1) )
    <=> ( ( Xs1 = nil(A1) )
        & ( Ys1 = nil(A1) ) ) ) ).

tff(fact_83_self__append__conv2,axiom,
    ! [A1: $tType,Xs1: list(A1),Ys1: list(A1)] :
      ( ( Ys1 = append(A1,Xs1,Ys1) )
    <=> ( Xs1 = nil(A1) ) ) ).

tff(fact_84_self__append__conv,axiom,
    ! [A1: $tType,Ys1: list(A1),Xs1: list(A1)] :
      ( ( Xs1 = append(A1,Xs1,Ys1) )
    <=> ( Ys1 = nil(A1) ) ) ).

tff(fact_85_Nil__is__append__conv,axiom,
    ! [A1: $tType,Ys1: list(A1),Xs1: list(A1)] :
      ( ( nil(A1) = append(A1,Xs1,Ys1) )
    <=> ( ( Xs1 = nil(A1) )
        & ( Ys1 = nil(A1) ) ) ) ).

tff(fact_86_append1__eq__conv,axiom,
    ! [A1: $tType,Y: A1,Ys1: list(A1),X: A1,Xs1: list(A1)] :
      ( ( append(A1,Xs1,cons(A1,X,nil(A1))) = append(A1,Ys1,cons(A1,Y,nil(A1))) )
    <=> ( ( Xs1 = Ys1 )
        & ( X = Y ) ) ) ).

tff(fact_87_insert__Nil,axiom,
    ! [A1: $tType,X1: A1] : ( insert(A1,X1,nil(A1)) = cons(A1,X1,nil(A1)) ) ).

tff(fact_88_not__listrel1__Nil,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool),Xs1: list(A1)] : ~ member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),Xs1,nil(A1)),listrel1(A1,R)) ).

tff(fact_89_not__Nil__listrel1,axiom,
    ! [A1: $tType,R: fun(product_prod(A1,A1),bool),Xs1: list(A1)] : ~ member(product_prod(list(A1),list(A1)),product_Pair(list(A1),list(A1),nil(A1),Xs1),listrel1(A1,R)) ).

tff(fact_90_Cons__eq__append__conv,axiom,
    ! [A1: $tType,Zs: list(A1),Ys1: list(A1),Xs1: list(A1),X: A1] :
      ( ( cons(A1,X,Xs1) = append(A1,Ys1,Zs) )
    <=> ( ( ( Ys1 = nil(A1) )
          & ( cons(A1,X,Xs1) = Zs ) )
        | ? [Ys2: list(A1)] :
            ( ( cons(A1,X,Ys2) = Ys1 )
            & ( Xs1 = append(A1,Ys2,Zs) ) ) ) ) ).

tff(fact_91_append__eq__Cons__conv,axiom,
    ! [A1: $tType,Xs1: list(A1),X: A1,Zs: list(A1),Ys1: list(A1)] :
      ( ( append(A1,Ys1,Zs) = cons(A1,X,Xs1) )
    <=> ( ( ( Ys1 = nil(A1) )
          & ( Zs = cons(A1,X,Xs1) ) )
        | ? [Ys2: list(A1)] :
            ( ( Ys1 = cons(A1,X,Ys2) )
            & ( append(A1,Ys2,Zs) = Xs1 ) ) ) ) ).

tff(fact_92_splice__Nil2,axiom,
    ! [A1: $tType,Xs: list(A1)] : ( splice(A1,Xs,nil(A1)) = Xs ) ).

tff(fact_93_splice_Osimps_I1_J,axiom,
    ! [A1: $tType,Ys: list(A1)] : ( splice(A1,nil(A1),Ys) = Ys ) ).

tff(fact_94_list_Osimps_I3_J,axiom,
    ! [A1: $tType,List: list(A1),A2: A1] : ( cons(A1,A2,List) != nil(A1) ) ).

tff(fact_95_list_Osimps_I2_J,axiom,
    ! [A1: $tType,List: list(A1),A2: A1] : ( nil(A1) != cons(A1,A2,List) ) ).

tff(fact_96_maps__simps_I2_J,axiom,
    ! [B: $tType,A1: $tType,F: fun(B,list(A1))] : ( maps(B,A1,F,nil(B)) = nil(A1) ) ).

tff(fact_97_list_Osimps_I4_J,axiom,
    ! [B: $tType,A1: $tType,F2: fun(B,fun(list(B),A1)),F1: A1] : ( list_case(A1,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_98_eq__Nil__appendI,axiom,
    ! [A1: $tType,Ys: list(A1),Xs: list(A1)] :
      ( ( Xs = Ys )
     => ( Xs = append(A1,nil(A1),Ys) ) ) ).

tff(fact_99_append__Nil2,axiom,
    ! [A1: $tType,Xs: list(A1)] : ( append(A1,Xs,nil(A1)) = Xs ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (4)
tff(conj_0,hypothesis,
    ! [A: option(fun(list(char),bool))] :
      ( ( size_size(list(list(char)),vsa) = size_size(list(ty),tsa) )
     => ( ( size_size(list(val),vsa1) = size_size(list(ty),tsa) )
       => ( d(list(char),blocks(product_Pair(list(list(char)),product_prod(list(ty),product_prod(list(val),exp(list(char)))),vsa,product_Pair(list(ty),product_prod(list(val),exp(list(char))),tsa,product_Pair(list(val),exp(list(char)),vsa1,ea)))),A)
        <=> d(list(char),ea,hyperUn(list(char),A,some(fun(list(char),bool),set(list(char),vsa)))) ) ) ) ).

tff(conj_1,hypothesis,
    size_size(list(list(char)),cons(list(char),v,vsa)) = size_size(list(ty),cons(ty,t,tsa)) ).

tff(conj_2,hypothesis,
    size_size(list(val),cons(val,v1,vsa1)) = size_size(list(ty),cons(ty,t,tsa)) ).

tff(conj_3,conjecture,
    ( d(list(char),blocks(product_Pair(list(list(char)),product_prod(list(ty),product_prod(list(val),exp(list(char)))),cons(list(char),v,vsa),product_Pair(list(ty),product_prod(list(val),exp(list(char))),cons(ty,t,tsa),product_Pair(list(val),exp(list(char)),cons(val,v1,vsa1),ea)))),a)
  <=> d(list(char),ea,hyperUn(list(char),a,some(fun(list(char),bool),set(list(char),cons(list(char),v,vsa))))) ) ).

%------------------------------------------------------------------------------
