%------------------------------------------------------------------------------
% File     : SWW555_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Java type soundness line 76
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : jinja_76 [Bla13]

% Status   : Theorem
% Rating   : 1.00 v9.1.0, 0.67 v9.0.0, 0.33 v7.5.0, 0.67 v7.4.0, 1.00 v7.3.0, 0.75 v7.1.0, 1.00 v6.4.0
% Syntax   : Number of formulae    :  152 (  46 unt;  48 typ;   0 def)
%            Number of atoms       :  215 (  90 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  149 (  38   ~;   1   |;  10   &)
%                                         (  16 <=>;  84  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   19 (   8 avg)
%            Maximal term depth    :   10 (   3 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   53 (  26   >;  27   *;   0   +;   0  <<)
%            Number of predicates  :   10 (   9 usr;   0 prp; 1-5 aty)
%            Number of functors    :   34 (  34 usr;  16 con; 0-5 aty)
%            Number of variables   :  592 ( 567   !;   4   ?; 592   :)
%                                         (  21  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:27
%------------------------------------------------------------------------------
%----Should-be-implicit typings (10)
tff(ty_tc_Expr_Oexp,type,
    exp: $tType > $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Option_Ooption,type,
    option: $tType > $tType ).

tff(ty_tc_String_Ochar,type,
    char: $tType ).

tff(ty_tc_Type_Oty,type,
    ty: $tType ).

tff(ty_tc_Value_Oval,type,
    val: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (38)
tff(sy_c_BigStep_Ofinal,type,
    final: 
      !>[A: $tType] : ( exp(A) > $o ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_Conform_Oconf,type,
    conf: 
      !>[M1: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M1)))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * val * ty ) > $o ) ).

tff(sy_c_Conform_Ohconf,type,
    hconf: 
      !>[M1: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M1)))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ) > $o ) ).

tff(sy_c_Conform_Olconf,type,
    lconf: 
      !>[M1: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M1)))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * fun(list(char),option(val)) * fun(list(char),option(ty)) ) > $o ) ).

tff(sy_c_Expr_Oexp_OBlock,type,
    block: 
      !>[A: $tType] : ( ( A * ty * exp(A) ) > exp(A) ) ).

tff(sy_c_Expr_Oexp_OLAss,type,
    lAss: 
      !>[A: $tType] : ( ( A * exp(A) ) > exp(A) ) ).

tff(sy_c_Expr_Oexp_OSeq,type,
    seq: 
      !>[A: $tType] : ( ( exp(A) * exp(A) ) > exp(A) ) ).

tff(sy_c_Expr_Oexp_OVal,type,
    val1: 
      !>[A: $tType] : ( val > exp(A) ) ).

tff(sy_c_Fun_Ofun__upd,type,
    fun_upd: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A * B ) > fun(A,B) ) ).

tff(sy_c_Option_Ooption_ONone,type,
    none: 
      !>[A: $tType] : option(A) ).

tff(sy_c_Option_Ooption_OSome,type,
    some: 
      !>[A: $tType] : ( A > option(A) ) ).

tff(sy_c_Option_Othe,type,
    the: 
      !>[A: $tType] : ( option(A) > A ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_SmallStep_Oassigned,type,
    assigned: ( list(char) * exp(list(char)) ) > $o ).

tff(sy_c_SmallStep_Ored,type,
    red: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) > fun(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),bool) ).

tff(sy_c_SmallStep_Oredp,type,
    redp: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * exp(list(char)) * product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))) * exp(list(char)) * product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))) ) > $o ).

tff(sy_c_Transitive__Closure_Ortrancl,type,
    transitive_rtrancl: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_Value_Oval_OUnit,type,
    unit: val ).

tff(sy_c_WellTypeRT_OWTrt,type,
    wTrt: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * fun(list(char),option(ty)) * exp(list(char)) * ty ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_E____,type,
    e: fun(list(char),option(ty)) ).

tff(sy_v_P,type,
    p: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) ).

tff(sy_v_T_H____,type,
    t: ty ).

tff(sy_v_T____,type,
    t1: ty ).

tff(sy_v_V____,type,
    v: list(char) ).

tff(sy_v_e_Ha____,type,
    e_a: exp(list(char)) ).

tff(sy_v_ea____,type,
    ea: exp(list(char)) ).

tff(sy_v_h_Ha____,type,
    h_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ).

tff(sy_v_ha____,type,
    ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ).

tff(sy_v_l_Ha____,type,
    l_a: fun(list(char),option(val)) ).

tff(sy_v_la____,type,
    la: fun(list(char),option(val)) ).

tff(sy_v_v_H____,type,
    v2: val ).

tff(sy_v_v____,type,
    v1: val ).

%----Relevant facts (100)
tff(fact_0__096P_Mh_H_A_092_060turnstile_062_Al_A_I_058_092_060le_062_J_AE_096,axiom,
    lconf(product_prod(list(list(char)),exp(list(char))),p,h_a,la,e) ).

tff(fact_1__096P_Mh_H_A_092_060turnstile_062_Al_H_A_I_058_092_060le_062_J_AE_IV_A_124_N_062_AT_J_096,axiom,
    lconf(product_prod(list(list(char)),exp(list(char))),p,h_a,l_a,fun_upd(list(char),option(ty),e,v,some(ty,t1))) ).

tff(fact_2_lconf,axiom,
    lconf(product_prod(list(list(char)),exp(list(char))),p,ha,la,e) ).

tff(fact_3_l_HV,axiom,
    aa(list(char),option(val),l_a,v) = some(val,v2) ).

tff(fact_4_fun__upd__triv,axiom,
    ! [B: $tType,A: $tType,X: A,F2: fun(A,B)] : ( fun_upd(A,B,F2,X,aa(A,B,F2,X)) = F2 ) ).

tff(fact_5_fun__upd__upd,axiom,
    ! [A: $tType,B: $tType,Z: B,Y2: B,X: A,F2: fun(A,B)] : ( fun_upd(A,B,fun_upd(A,B,F2,X,Y2),X,Z) = fun_upd(A,B,F2,X,Z) ) ).

tff(fact_6_fun__upd__apply,axiom,
    ! [B: $tType,A: $tType,Y2: B,F2: fun(A,B),X: A,Z: A] :
      ( ( ( Z = X )
       => ( aa(A,B,fun_upd(A,B,F2,X,Y2),Z) = Y2 ) )
      & ( ( Z != X )
       => ( aa(A,B,fun_upd(A,B,F2,X,Y2),Z) = aa(A,B,F2,Z) ) ) ) ).

tff(fact_7_InitBlockRed_I5_J,axiom,
    lconf(product_prod(list(list(char)),exp(list(char))),p,ha,la,e) ).

tff(fact_8_IH,axiom,
    ! [Ta: ty,Ea: fun(list(char),option(ty))] :
      ( wTrt(p,ha,Ea,ea,Ta)
     => ( lconf(product_prod(list(list(char)),exp(list(char))),p,ha,fun_upd(list(char),option(val),la,v,some(val,v1)),Ea)
       => lconf(product_prod(list(list(char)),exp(list(char))),p,h_a,l_a,Ea) ) ) ).

tff(fact_9_fun__upd__idem__iff,axiom,
    ! [A: $tType,B: $tType,Y2: B,X: A,F2: fun(A,B)] :
      ( ( fun_upd(A,B,F2,X,Y2) = F2 )
    <=> ( aa(A,B,F2,X) = Y2 ) ) ).

tff(fact_10_fun__upd__same,axiom,
    ! [B: $tType,A: $tType,Y2: A,X: B,F2: fun(B,A)] : ( aa(B,A,fun_upd(B,A,F2,X,Y2),X) = Y2 ) ).

tff(fact_11_fun__upd__twist,axiom,
    ! [A: $tType,B: $tType,D2: B,B2: B,M: fun(A,B),C2: A,A2: A] :
      ( ( A2 != C2 )
     => ( fun_upd(A,B,fun_upd(A,B,M,A2,B2),C2,D2) = fun_upd(A,B,fun_upd(A,B,M,C2,D2),A2,B2) ) ) ).

tff(fact_12_fun__upd__other,axiom,
    ! [B: $tType,A: $tType,Y2: B,F2: fun(A,B),X: A,Z: A] :
      ( ( Z != X )
     => ( aa(A,B,fun_upd(A,B,F2,X,Y2),Z) = aa(A,B,F2,Z) ) ) ).

tff(fact_13_fun__upd__idem,axiom,
    ! [A: $tType,B: $tType,Y2: A,X: B,F2: fun(B,A)] :
      ( ( aa(B,A,F2,X) = Y2 )
     => ( fun_upd(B,A,F2,X,Y2) = F2 ) ) ).

tff(fact_14_InitBlockRed_I2_J,axiom,
    ! [Ta: ty,Ea: fun(list(char),option(ty))] :
      ( wTrt(p,ha,Ea,ea,Ta)
     => ( lconf(product_prod(list(list(char)),exp(list(char))),p,ha,fun_upd(list(char),option(val),la,v,some(val,v1)),Ea)
       => lconf(product_prod(list(list(char)),exp(list(char))),p,h_a,l_a,Ea) ) ) ).

tff(fact_15_fun__upd__def,axiom,
    ! [B: $tType,A: $tType,B2: B,F2: fun(A,B),A2: A,X2: A] :
      ( ( ( X2 = A2 )
       => ( aa(A,B,fun_upd(A,B,F2,A2,B2),X2) = B2 ) )
      & ( ( X2 != A2 )
       => ( aa(A,B,fun_upd(A,B,F2,A2,B2),X2) = aa(A,B,F2,X2) ) ) ) ).

tff(fact_16_option_Oinject,axiom,
    ! [A: $tType,A7: A,A2: A] :
      ( ( some(A,A2) = some(A,A7) )
    <=> ( A2 = A7 ) ) ).

tff(fact_17_map__upd__eqD1,axiom,
    ! [A: $tType,B: $tType,Y2: B,N: fun(A,option(B)),X: B,A2: A,M: fun(A,option(B))] :
      ( ( fun_upd(A,option(B),M,A2,some(B,X)) = fun_upd(A,option(B),N,A2,some(B,Y2)) )
     => ( X = Y2 ) ) ).

tff(fact_18_map__upd__triv,axiom,
    ! [A: $tType,B: $tType,X: A,K: B,T: fun(B,option(A))] :
      ( ( aa(B,option(A),T,K) = some(A,X) )
     => ( fun_upd(B,option(A),T,K,some(A,X)) = T ) ) ).

tff(fact_19_map__upd__Some__unfold,axiom,
    ! [B: $tType,A: $tType,Y2: A,X: B,B2: A,A2: B,M: fun(B,option(A))] :
      ( ( aa(B,option(A),fun_upd(B,option(A),M,A2,some(A,B2)),X) = some(A,Y2) )
    <=> ( ( ( X = A2 )
          & ( B2 = Y2 ) )
        | ( ( X != A2 )
          & ( aa(B,option(A),M,X) = some(A,Y2) ) ) ) ) ).

tff(fact_20_red,axiom,
    member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),ha,fun_upd(list(char),option(val),la,v,some(val,v1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),e_a,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),h_a,l_a))),red(p)) ).

tff(fact_21_lconf__upd2,axiom,
    ! [A: $tType,Va: list(char),Ta: ty,Va1: val,Ea: fun(list(char),option(ty)),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( lconf(A,Pa,Hb,Lb,Ea)
     => ( conf(A,Pa,Hb,Va1,Ta)
       => lconf(A,Pa,Hb,fun_upd(list(char),option(val),Lb,Va,some(val,Va1)),fun_upd(list(char),option(ty),Ea,Va,some(ty,Ta))) ) ) ).

tff(fact_22_InitBlockRed_I4_J,axiom,
    wTrt(p,ha,e,block(list(char),v,t1,seq(list(char),lAss(list(char),v,val1(list(char),v1)),ea)),t) ).

tff(fact_23_wt,axiom,
    wTrt(p,ha,e,block(list(char),v,t1,seq(list(char),lAss(list(char),v,val1(list(char),v1)),ea)),t) ).

tff(fact_24_lconf__upd,axiom,
    ! [A: $tType,Va: list(char),Ta: ty,Va1: val,Ea: fun(list(char),option(ty)),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( lconf(A,Pa,Hb,Lb,Ea)
     => ( conf(A,Pa,Hb,Va1,Ta)
       => ( ( aa(list(char),option(ty),Ea,Va) = some(ty,Ta) )
         => lconf(A,Pa,Hb,fun_upd(list(char),option(val),Lb,Va,some(val,Va1)),Ea) ) ) ) ).

tff(fact_25_WTrtBlock,axiom,
    ! [T_a: ty,Eb: exp(list(char)),Ta: ty,Va: list(char),Ea: fun(list(char),option(ty)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wTrt(Pa,Hb,fun_upd(list(char),option(ty),Ea,Va,some(ty,Ta)),Eb,T_a)
     => wTrt(Pa,Hb,Ea,block(list(char),Va,Ta,Eb),T_a) ) ).

tff(fact_26_red__reds_OInitBlockRed,axiom,
    ! [Ta: ty,V_a: val,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L_b: fun(list(char),option(val)),H_b: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E_b: exp(list(char)),Va1: val,Va: list(char),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Eb: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Eb,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,fun_upd(list(char),option(val),Lb,Va,some(val,Va1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_b,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_b,L_b))),red(Pa))
     => ( ( aa(list(char),option(val),L_b,Va) = some(val,V_a) )
       => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),block(list(char),Va,Ta,seq(list(char),lAss(list(char),Va,val1(list(char),Va1)),Eb)),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,Lb)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),block(list(char),Va,Ta,seq(list(char),lAss(list(char),Va,val1(list(char),V_a)),E_b)),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_b,fun_upd(list(char),option(val),L_b,Va,aa(list(char),option(val),Lb,Va))))),red(Pa)) ) ) ).

tff(fact_27_red__reds_ORedInitBlock,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),U: val,Va1: val,Ta: ty,Va: list(char)] : member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),block(list(char),Va,Ta,seq(list(char),lAss(list(char),Va,val1(list(char),Va1)),val1(list(char),U))),S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),val1(list(char),U),S)),red(Pa)) ).

tff(fact_28_WTrtSeq,axiom,
    ! [T_2: ty,E_2: exp(list(char)),T_1: ty,E_1: exp(list(char)),Ea: fun(list(char),option(ty)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wTrt(Pa,Hb,Ea,E_1,T_1)
     => ( wTrt(Pa,Hb,Ea,E_2,T_2)
       => wTrt(Pa,Hb,Ea,seq(list(char),E_1,E_2),T_2) ) ) ).

tff(fact_29_red__reds_ORedBlock,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),U: val,Ta: ty,Va: list(char)] : member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),block(list(char),Va,Ta,val1(list(char),U)),S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),val1(list(char),U),S)),red(Pa)) ).

tff(fact_30_red__reds_ORedSeq,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_2: exp(list(char)),Va1: val] : member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),seq(list(char),val1(list(char),Va1),E_2),S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_2,S)),red(Pa)) ).

tff(fact_31_lconf__def,axiom,
    ! [A: $tType,Ea: fun(list(char),option(ty)),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( lconf(A,Pa,Hb,Lb,Ea)
    <=> ! [V1: list(char),V: val] :
          ( ( aa(list(char),option(val),Lb,V1) = some(val,V) )
         => ? [T1: ty] :
              ( ( aa(list(char),option(ty),Ea,V1) = some(ty,T1) )
              & conf(A,Pa,Hb,V,T1) ) ) ) ).

tff(fact_32_red__reds_OSeqRed,axiom,
    ! [E_2: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_b: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Eb: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Eb,S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_b,S1)),red(Pa))
     => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),seq(list(char),Eb,E_2),S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),seq(list(char),E_b,E_2),S1)),red(Pa)) ) ).

tff(fact_33_red__reds_OLAssRed,axiom,
    ! [Va: list(char),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_b: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Eb: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Eb,S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_b,S1)),red(Pa))
     => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),lAss(list(char),Va,Eb),S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),lAss(list(char),Va,E_b),S1)),red(Pa)) ) ).

tff(fact_34_red__reds_ORedLAss,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Va1: val,Va: list(char)] : member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),lAss(list(char),Va,val1(list(char),Va1)),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,Lb)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),val1(list(char),unit),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,fun_upd(list(char),option(val),Lb,Va,some(val,Va1))))),red(Pa)) ).

tff(fact_35_exp_Osimps_I10_J,axiom,
    ! [A: $tType,Exp5: exp(A),Ty3: ty,A7: A,Exp4: exp(A),Ty2: ty,A2: A] :
      ( ( block(A,A2,Ty2,Exp4) = block(A,A7,Ty3,Exp5) )
    <=> ( ( A2 = A7 )
        & ( Ty2 = Ty3 )
        & ( Exp4 = Exp5 ) ) ) ).

tff(fact_36_exp_Osimps_I11_J,axiom,
    ! [A: $tType,Exp22: exp(A),Exp12: exp(A),Exp21: exp(A),Exp11: exp(A)] :
      ( ( seq(A,Exp11,Exp21) = seq(A,Exp12,Exp22) )
    <=> ( ( Exp11 = Exp12 )
        & ( Exp21 = Exp22 ) ) ) ).

tff(fact_37_exp_Osimps_I6_J,axiom,
    ! [A: $tType,Exp5: exp(A),A7: A,Exp4: exp(A),A2: A] :
      ( ( lAss(A,A2,Exp4) = lAss(A,A7,Exp5) )
    <=> ( ( A2 = A7 )
        & ( Exp4 = Exp5 ) ) ) ).

tff(fact_38_red__preserves__hconf,axiom,
    ! [Ta: ty,Ea: fun(list(char),option(ty)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L_b: fun(list(char),option(val)),H_b: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E_b: exp(list(char)),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Eb: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Eb,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,Lb)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_b,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_b,L_b))),red(Pa))
     => ( wTrt(Pa,Hb,Ea,Eb,Ta)
       => ( hconf(product_prod(list(list(char)),exp(list(char))),Pa,Hb)
         => hconf(product_prod(list(list(char)),exp(list(char))),Pa,H_b) ) ) ) ).

tff(fact_39_exp_Osimps_I3_J,axiom,
    ! [A: $tType,Val2: val,Val1: val] :
      ( ( val1(A,Val1) = val1(A,Val2) )
    <=> ( Val1 = Val2 ) ) ).

tff(fact_40_exp_Osimps_I75_J,axiom,
    ! [A: $tType,Val: val,Exp3: exp(A),A5: A] : ( lAss(A,A5,Exp3) != val1(A,Val) ) ).

tff(fact_41_exp_Osimps_I85_J,axiom,
    ! [A: $tType,Val: val,Exp2: exp(A),Exp1: exp(A)] : ( seq(A,Exp1,Exp2) != val1(A,Val) ) ).

tff(fact_42_exp_Osimps_I74_J,axiom,
    ! [A: $tType,Exp3: exp(A),A5: A,Val: val] : ( val1(A,Val) != lAss(A,A5,Exp3) ) ).

tff(fact_43_exp_Osimps_I84_J,axiom,
    ! [A: $tType,Exp2: exp(A),Exp1: exp(A),Val: val] : ( val1(A,Val) != seq(A,Exp1,Exp2) ) ).

tff(fact_44_exp_Osimps_I83_J,axiom,
    ! [A: $tType,Val: val,Exp3: exp(A),Ty1: ty,A5: A] : ( block(A,A5,Ty1,Exp3) != val1(A,Val) ) ).

tff(fact_45_exp_Osimps_I82_J,axiom,
    ! [A: $tType,Exp3: exp(A),Ty1: ty,A5: A,Val: val] : ( val1(A,Val) != block(A,A5,Ty1,Exp3) ) ).

tff(fact_46_exp_Osimps_I144_J,axiom,
    ! [A: $tType,Exp2: exp(A),Exp1: exp(A),Exp: exp(A),A4: A] : ( lAss(A,A4,Exp) != seq(A,Exp1,Exp2) ) ).

tff(fact_47_exp_Osimps_I145_J,axiom,
    ! [A: $tType,Exp: exp(A),A4: A,Exp2: exp(A),Exp1: exp(A)] : ( seq(A,Exp1,Exp2) != lAss(A,A4,Exp) ) ).

tff(fact_48_exp_Osimps_I143_J,axiom,
    ! [A: $tType,Exp: exp(A),A4: A,Exp3: exp(A),Ty1: ty,A5: A] : ( block(A,A5,Ty1,Exp3) != lAss(A,A4,Exp) ) ).

tff(fact_49_exp_Osimps_I196_J,axiom,
    ! [A: $tType,Exp2: exp(A),Exp1: exp(A),Exp: exp(A),Ty: ty,A4: A] : ( block(A,A4,Ty,Exp) != seq(A,Exp1,Exp2) ) ).

tff(fact_50_exp_Osimps_I142_J,axiom,
    ! [A: $tType,Exp3: exp(A),Ty1: ty,A5: A,Exp: exp(A),A4: A] : ( lAss(A,A4,Exp) != block(A,A5,Ty1,Exp3) ) ).

tff(fact_51_exp_Osimps_I197_J,axiom,
    ! [A: $tType,Exp: exp(A),Ty: ty,A4: A,Exp2: exp(A),Exp1: exp(A)] : ( seq(A,Exp1,Exp2) != block(A,A4,Ty,Exp) ) ).

tff(fact_52_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B6: B,A7: A,B2: B,A2: A] :
      ( ( product_Pair(A,B,A2,B2) = product_Pair(A,B,A7,B6) )
    <=> ( ( A2 = A7 )
        & ( B2 = B6 ) ) ) ).

tff(fact_53_split__paired__All,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ! [A6: A,B5: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A6,B5))) ) ).

tff(fact_54_redp__redsp_OInitBlockRed,axiom,
    ! [Ta: ty,V_a: val,L_b: fun(list(char),option(val)),H_b: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E_b: exp(list(char)),Va1: val,Va: list(char),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Eb: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( redp(Pa,Eb,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,fun_upd(list(char),option(val),Lb,Va,some(val,Va1))),E_b,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_b,L_b))
     => ( ( aa(list(char),option(val),L_b,Va) = some(val,V_a) )
       => redp(Pa,block(list(char),Va,Ta,seq(list(char),lAss(list(char),Va,val1(list(char),Va1)),Eb)),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,Lb),block(list(char),Va,Ta,seq(list(char),lAss(list(char),Va,val1(list(char),V_a)),E_b)),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_b,fun_upd(list(char),option(val),L_b,Va,aa(list(char),option(val),Lb,Va)))) ) ) ).

tff(fact_55_red__reds_OBlockRedSome,axiom,
    ! [Ta: ty,Va1: val,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L_b: fun(list(char),option(val)),H_b: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E_b: exp(list(char)),Va: list(char),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Eb: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Eb,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,fun_upd(list(char),option(val),Lb,Va,none(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_b,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_b,L_b))),red(Pa))
     => ( ( aa(list(char),option(val),L_b,Va) = some(val,Va1) )
       => ( ~ assigned(Va,Eb)
         => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),block(list(char),Va,Ta,Eb),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,Lb)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),block(list(char),Va,Ta,seq(list(char),lAss(list(char),Va,val1(list(char),Va1)),E_b)),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_b,fun_upd(list(char),option(val),L_b,Va,aa(list(char),option(val),Lb,Va))))),red(Pa)) ) ) ) ).

tff(fact_56_LAssRedsVal,axiom,
    ! [Va: list(char),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L_b: fun(list(char),option(val)),H_b: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Va1: val,S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Eb: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Eb,S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),val1(list(char),Va1),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_b,L_b))),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa)))
     => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),lAss(list(char),Va,Eb),S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),val1(list(char),unit),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_b,fun_upd(list(char),option(val),L_b,Va,some(val,Va1))))),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa))) ) ).

tff(fact_57_not__Some__eq,axiom,
    ! [A: $tType,X: option(A)] :
      ( ! [Y1: A] : ( X != some(A,Y1) )
    <=> ( X = none(A) ) ) ).

tff(fact_58_not__None__eq,axiom,
    ! [A: $tType,X: option(A)] :
      ( ( X != none(A) )
    <=> ? [Y1: A] : ( X = some(A,Y1) ) ) ).

tff(fact_59_empty__upd__none,axiom,
    ! [A: $tType,B: $tType,X: A,X2: A] : ( aa(A,option(B),fun_upd(A,option(B),combk(option(B),A,none(B)),X,none(B)),X2) = none(B) ) ).

tff(fact_60_lconf__empty,axiom,
    ! [A: $tType,Ea: fun(list(char),option(ty)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] : lconf(A,Pa,Hb,combk(option(val),list(char),none(val)),Ea) ).

tff(fact_61_option_Osimps_I2_J,axiom,
    ! [A: $tType,A5: A] : ( none(A) != some(A,A5) ) ).

tff(fact_62_option_Osimps_I3_J,axiom,
    ! [A: $tType,A5: A] : ( some(A,A5) != none(A) ) ).

tff(fact_63_redp__redsp_OLAssRed,axiom,
    ! [Va: list(char),S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_b: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Eb: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( redp(Pa,Eb,S,E_b,S1)
     => redp(Pa,lAss(list(char),Va,Eb),S,lAss(list(char),Va,E_b),S1) ) ).

tff(fact_64_redp__redsp_OSeqRed,axiom,
    ! [E_2: exp(list(char)),S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_b: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Eb: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( redp(Pa,Eb,S,E_b,S1)
     => redp(Pa,seq(list(char),Eb,E_2),S,seq(list(char),E_b,E_2),S1) ) ).

tff(fact_65_redp__redsp_OBlockRedNone,axiom,
    ! [Ta: ty,L_b: fun(list(char),option(val)),H_b: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E_b: exp(list(char)),Va: list(char),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Eb: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( redp(Pa,Eb,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,fun_upd(list(char),option(val),Lb,Va,none(val))),E_b,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_b,L_b))
     => ( ( aa(list(char),option(val),L_b,Va) = none(val) )
       => ( ~ assigned(Va,Eb)
         => redp(Pa,block(list(char),Va,Ta,Eb),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,Lb),block(list(char),Va,Ta,E_b),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_b,fun_upd(list(char),option(val),L_b,Va,aa(list(char),option(val),Lb,Va)))) ) ) ) ).

tff(fact_66_conf__upd__obj,axiom,
    ! [A: $tType,Ta: ty,X: val,Fs1: fun(product_prod(list(char),list(char)),option(val)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A)))))))),Fs: fun(product_prod(list(char),list(char)),option(val)),C3: list(char),A2: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,A2) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C3,Fs)) )
     => ( conf(A,Pa,fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,A2,some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C3,Fs1))),X,Ta)
      <=> conf(A,Pa,Hb,X,Ta) ) ) ).

tff(fact_67_redp__redsp_ORedSeq,axiom,
    ! [S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_2: exp(list(char)),Va1: val,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] : redp(Pa,seq(list(char),val1(list(char),Va1),E_2),S,E_2,S) ).

tff(fact_68_map__upd__nonempty,axiom,
    ! [A: $tType,B: $tType,X: B,K: A,T: fun(A,option(B))] :
      ~ ! [X3: A] : ( aa(A,option(B),fun_upd(A,option(B),T,K,some(B,X)),X3) = none(B) ) ).

tff(fact_69_redp__redsp_ORedBlock,axiom,
    ! [S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),U: val,Ta: ty,Va: list(char),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] : redp(Pa,block(list(char),Va,Ta,val1(list(char),U)),S,val1(list(char),U),S) ).

tff(fact_70_SeqReds,axiom,
    ! [E_2: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_b: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Eb: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Eb,S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_b,S1)),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa)))
     => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),seq(list(char),Eb,E_2),S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),seq(list(char),E_b,E_2),S1)),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa))) ) ).

tff(fact_71_LAssReds,axiom,
    ! [Va: list(char),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_b: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Eb: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Eb,S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_b,S1)),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa)))
     => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),lAss(list(char),Va,Eb),S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),lAss(list(char),Va,E_b),S1)),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa))) ) ).

tff(fact_72_redp__redsp_OBlockRedSome,axiom,
    ! [Ta: ty,Va1: val,L_b: fun(list(char),option(val)),H_b: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E_b: exp(list(char)),Va: list(char),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Eb: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( redp(Pa,Eb,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,fun_upd(list(char),option(val),Lb,Va,none(val))),E_b,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_b,L_b))
     => ( ( aa(list(char),option(val),L_b,Va) = some(val,Va1) )
       => ( ~ assigned(Va,Eb)
         => redp(Pa,block(list(char),Va,Ta,Eb),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,Lb),block(list(char),Va,Ta,seq(list(char),lAss(list(char),Va,val1(list(char),Va1)),E_b)),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_b,fun_upd(list(char),option(val),L_b,Va,aa(list(char),option(val),Lb,Va)))) ) ) ) ).

tff(fact_73_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B4: B,A5: A,B3: B,A4: A] :
      ( ( product_Pair(A,B,A4,B3) = product_Pair(A,B,A5,B4) )
     => ~ ( ( A4 = A5 )
         => ( B3 != B4 ) ) ) ).

tff(fact_74_SeqReds2,axiom,
    ! [S_2: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_21: exp(list(char)),E_2: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S_1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),V_1: val,S_0: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_1: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_1,S_0),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),val1(list(char),V_1),S_1)),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa)))
     => ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_2,S_1),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_21,S_2)),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa)))
       => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),seq(list(char),E_1,E_2),S_0),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_21,S_2)),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa))) ) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F2: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F2,X3) = aa(A,B,G,X3) )
     => ( F2 = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A3: fun(A,bool),X: A] :
      ( member(A,X,A3)
    <=> pp(aa(A,bool,A3,X)) ) ).

tff(fact_77_redp__red__eq,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),X2: exp(list(char)),Xa1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Xb1: exp(list(char)),Xc: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))] :
      ( redp(Pa,X2,Xa1,Xb1,Xc)
    <=> member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),X2,Xa1),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Xb1,Xc)),red(Pa)) ) ).

tff(fact_78_redp__redsp_ORedInitBlock,axiom,
    ! [S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),U: val,Va1: val,Ta: ty,Va: list(char),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] : redp(Pa,block(list(char),Va,Ta,seq(list(char),lAss(list(char),Va,val1(list(char),Va1)),val1(list(char),U))),S,val1(list(char),U),S) ).

tff(fact_79_red__reds_OBlockRedNone,axiom,
    ! [Ta: ty,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L_b: fun(list(char),option(val)),H_b: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E_b: exp(list(char)),Va: list(char),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Eb: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Eb,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,fun_upd(list(char),option(val),Lb,Va,none(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_b,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_b,L_b))),red(Pa))
     => ( ( aa(list(char),option(val),L_b,Va) = none(val) )
       => ( ~ assigned(Va,Eb)
         => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),block(list(char),Va,Ta,Eb),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,Lb)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),block(list(char),Va,Ta,E_b),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_b,fun_upd(list(char),option(val),L_b,Va,aa(list(char),option(val),Lb,Va))))),red(Pa)) ) ) ) ).

tff(fact_80_redp__redsp_ORedLAss,axiom,
    ! [Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Va1: val,Va: list(char),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] : redp(Pa,lAss(list(char),Va,val1(list(char),Va1)),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,Lb),val1(list(char),unit),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,fun_upd(list(char),option(val),Lb,Va,some(val,Va1)))) ).

tff(fact_81_InitBlockReds,axiom,
    ! [Ta: ty,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L_b: fun(list(char),option(val)),H_b: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E_b: exp(list(char)),Va1: val,Va: list(char),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Eb: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Eb,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,fun_upd(list(char),option(val),Lb,Va,some(val,Va1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_b,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_b,L_b))),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa)))
     => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),block(list(char),Va,Ta,seq(list(char),lAss(list(char),Va,val1(list(char),Va1)),Eb)),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,Lb)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),block(list(char),Va,Ta,seq(list(char),lAss(list(char),Va,val1(list(char),the(val,aa(list(char),option(val),L_b,Va)))),E_b)),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_b,fun_upd(list(char),option(val),L_b,Va,aa(list(char),option(val),Lb,Va))))),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa))) ) ).

tff(fact_82_InitBlockRedsFinal,axiom,
    ! [Ta: ty,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L_b: fun(list(char),option(val)),H_b: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E_b: exp(list(char)),Va1: val,Va: list(char),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Eb: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Eb,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,fun_upd(list(char),option(val),Lb,Va,some(val,Va1)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_b,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_b,L_b))),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa)))
     => ( final(list(char),E_b)
       => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),block(list(char),Va,Ta,seq(list(char),lAss(list(char),Va,val1(list(char),Va1)),Eb)),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,Lb)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_b,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_b,fun_upd(list(char),option(val),L_b,Va,aa(list(char),option(val),Lb,Va))))),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa))) ) ) ).

tff(fact_83_assigned__def,axiom,
    ! [Eb: exp(list(char)),Va: list(char)] :
      ( assigned(Va,Eb)
    <=> ? [V: val,E2: exp(list(char))] : ( Eb = seq(list(char),lAss(list(char),Va,val1(list(char),V)),E2) ) ) ).

tff(fact_84_the_Osimps,axiom,
    ! [A: $tType,X1: A] : ( the(A,some(A,X1)) = X1 ) ).

tff(fact_85_BlockRedsFinal,axiom,
    ! [Ta: ty,Va: list(char),L_0: fun(list(char),option(val)),H_0: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L_2: fun(list(char),option(val)),H_2: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E_2: exp(list(char)),S_0: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_0: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_0,S_0),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_2,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_2,L_2))),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa)))
     => ( final(list(char),E_2)
       => ( ( S_0 = product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_0,fun_upd(list(char),option(val),L_0,Va,none(val))) )
         => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),block(list(char),Va,Ta,E_0),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_0,L_0)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_2,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_2,fun_upd(list(char),option(val),L_2,Va,aa(list(char),option(val),L_0,Va))))),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa))) ) ) ) ).

tff(fact_86_rtrancl_Ortrancl__refl,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),A2: A] : member(product_prod(A,A),product_Pair(A,A,A2,A2),transitive_rtrancl(A,R)) ).

tff(fact_87_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y: product_prod(A,product_prod(B,product_prod(C,D)))] :
      ~ ! [A1: A,B1: B,C1: C,D1: D] : ( Y != product_Pair(A,product_prod(B,product_prod(C,D)),A1,product_Pair(B,product_prod(C,D),B1,product_Pair(C,D,C1,D1))) ) ).

tff(fact_88_rtrancl__idemp,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] : ( transitive_rtrancl(A,transitive_rtrancl(A,R)) = transitive_rtrancl(A,R) ) ).

tff(fact_89_r__into__rtrancl,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),P1: product_prod(A,A)] :
      ( member(product_prod(A,A),P1,R)
     => member(product_prod(A,A),P1,transitive_rtrancl(A,R)) ) ).

tff(fact_90_rtrancl__trans,axiom,
    ! [A: $tType,C2: A,R: fun(product_prod(A,A),bool),B2: A,A2: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A2,B2),transitive_rtrancl(A,R))
     => ( member(product_prod(A,A),product_Pair(A,A,B2,C2),transitive_rtrancl(A,R))
       => member(product_prod(A,A),product_Pair(A,A,A2,C2),transitive_rtrancl(A,R)) ) ) ).

tff(fact_91_rtrancl_Ortrancl__into__rtrancl,axiom,
    ! [A: $tType,C2: A,R: fun(product_prod(A,A),bool),B2: A,A2: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A2,B2),transitive_rtrancl(A,R))
     => ( member(product_prod(A,A),product_Pair(A,A,B2,C2),R)
       => member(product_prod(A,A),product_Pair(A,A,A2,C2),transitive_rtrancl(A,R)) ) ) ).

tff(fact_92_converse__rtrancl__into__rtrancl,axiom,
    ! [A: $tType,C2: A,R: fun(product_prod(A,A),bool),B2: A,A2: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A2,B2),R)
     => ( member(product_prod(A,A),product_Pair(A,A,B2,C2),transitive_rtrancl(A,R))
       => member(product_prod(A,A),product_Pair(A,A,A2,C2),transitive_rtrancl(A,R)) ) ) ).

tff(fact_93_converse__rtranclE2,axiom,
    ! [B: $tType,A: $tType,R: fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),Zb: B,Za: A,Xb: B,Xa: A] :
      ( member(product_prod(product_prod(A,B),product_prod(A,B)),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,Xa,Xb),product_Pair(A,B,Za,Zb)),transitive_rtrancl(product_prod(A,B),R))
     => ( ( product_Pair(A,B,Xa,Xb) != product_Pair(A,B,Za,Zb) )
       => ~ ! [A1: A,B1: B] :
              ( member(product_prod(product_prod(A,B),product_prod(A,B)),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,Xa,Xb),product_Pair(A,B,A1,B1)),R)
             => ~ member(product_prod(product_prod(A,B),product_prod(A,B)),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,A1,B1),product_Pair(A,B,Za,Zb)),transitive_rtrancl(product_prod(A,B),R)) ) ) ) ).

tff(fact_94_converse__rtrancl__induct2,axiom,
    ! [A: $tType,B: $tType,Pa: fun(A,fun(B,bool)),R: fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),By: B,Bx: A,Ay: B,Ax: A] :
      ( member(product_prod(product_prod(A,B),product_prod(A,B)),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,Ax,Ay),product_Pair(A,B,Bx,By)),transitive_rtrancl(product_prod(A,B),R))
     => ( pp(aa(B,bool,aa(A,fun(B,bool),Pa,Bx),By))
       => ( ! [A1: A,B1: B,Aa: A,Ba: B] :
              ( member(product_prod(product_prod(A,B),product_prod(A,B)),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,A1,B1),product_Pair(A,B,Aa,Ba)),R)
             => ( member(product_prod(product_prod(A,B),product_prod(A,B)),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,Aa,Ba),product_Pair(A,B,Bx,By)),transitive_rtrancl(product_prod(A,B),R))
               => ( pp(aa(B,bool,aa(A,fun(B,bool),Pa,Aa),Ba))
                 => pp(aa(B,bool,aa(A,fun(B,bool),Pa,A1),B1)) ) ) )
         => pp(aa(B,bool,aa(A,fun(B,bool),Pa,Ax),Ay)) ) ) ) ).

tff(fact_95_rtrancl__induct2,axiom,
    ! [A: $tType,B: $tType,Pa: fun(A,fun(B,bool)),R: fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),By: B,Bx: A,Ay: B,Ax: A] :
      ( member(product_prod(product_prod(A,B),product_prod(A,B)),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,Ax,Ay),product_Pair(A,B,Bx,By)),transitive_rtrancl(product_prod(A,B),R))
     => ( pp(aa(B,bool,aa(A,fun(B,bool),Pa,Ax),Ay))
       => ( ! [A1: A,B1: B,Aa: A,Ba: B] :
              ( member(product_prod(product_prod(A,B),product_prod(A,B)),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,Ax,Ay),product_Pair(A,B,A1,B1)),transitive_rtrancl(product_prod(A,B),R))
             => ( member(product_prod(product_prod(A,B),product_prod(A,B)),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,A1,B1),product_Pair(A,B,Aa,Ba)),R)
               => ( pp(aa(B,bool,aa(A,fun(B,bool),Pa,A1),B1))
                 => pp(aa(B,bool,aa(A,fun(B,bool),Pa,Aa),Ba)) ) ) )
         => pp(aa(B,bool,aa(A,fun(B,bool),Pa,Bx),By)) ) ) ) ).

tff(fact_96_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,X: product_prod(A,product_prod(B,product_prod(C,D))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A1: A,B1: B,C1: C,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,D)),A1,product_Pair(B,product_prod(C,D),B1,product_Pair(C,D,C1,D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,Pa,X)) ) ).

tff(fact_97_prod__induct6,axiom,
    ! [F: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F))))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F))))),bool)] :
      ( ! [A1: A,B1: B,C1: C,D1: D,E1: E,F1: F] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F))))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F)))),A1,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F))),B1,product_Pair(C,product_prod(D,product_prod(E,F)),C1,product_Pair(D,product_prod(E,F),D1,product_Pair(E,F,E1,F1)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F))))),bool,Pa,X)) ) ).

tff(fact_98_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F)))))] :
      ~ ! [A1: A,B1: B,C1: C,D1: D,E1: E,F1: F] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F)))),A1,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F))),B1,product_Pair(C,product_prod(D,product_prod(E,F)),C1,product_Pair(D,product_prod(E,F),D1,product_Pair(E,F,E1,F1))))) ) ).

tff(fact_99_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))] :
      ~ ! [A1: A,B1: B,C1: C,D1: D,E1: E] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A1,product_Pair(B,product_prod(C,product_prod(D,E)),B1,product_Pair(C,product_prod(D,E),C1,product_Pair(D,E,D1,E1)))) ) ).

%----Helper facts (3)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    lconf(product_prod(list(list(char)),exp(list(char))),p,h_a,fun_upd(list(char),option(val),l_a,v,aa(list(char),option(val),la,v)),e) ).

%------------------------------------------------------------------------------
