%------------------------------------------------------------------------------
% File     : SWW553_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Java type soundness line 42
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : jinja_42 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.00 v6.4.0
% Syntax   : Number of formulae    :  157 (  39 unt;  53 typ;   0 def)
%            Number of atoms       :  217 ( 111 equ)
%            Maximal formula atoms :    5 (   1 avg)
%            Number of connectives :  145 (  32   ~;   1   |;  11   &)
%                                         (  20 <=>;  81  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   7 avg)
%            Maximal term depth    :    8 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   70 (  33   >;  37   *;   0   +;   0  <<)
%            Number of predicates  :   13 (  12 usr;   0 prp; 1-6 aty)
%            Number of functors    :   36 (  36 usr;  14 con; 0-6 aty)
%            Number of variables   :  533 ( 494   !;   9   ?; 533   :)
%                                         (  30  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:07
%------------------------------------------------------------------------------
%----Should-be-implicit typings (10)
tff(ty_tc_Expr_Oexp,type,
    exp: $tType > $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Option_Ooption,type,
    option: $tType > $tType ).

tff(ty_tc_String_Ochar,type,
    char: $tType ).

tff(ty_tc_Type_Oty,type,
    ty: $tType ).

tff(ty_tc_Value_Oval,type,
    val: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (43)
tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_Conform_Oconf,type,
    conf: 
      !>[M3: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M3)))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * val * ty ) > $o ) ).

tff(sy_c_Conform_Ohconf,type,
    hconf: 
      !>[M3: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M3)))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ) > $o ) ).

tff(sy_c_Conform_Olconf,type,
    lconf: 
      !>[M3: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M3)))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * fun(list(char),option(val)) * fun(list(char),option(ty)) ) > $o ) ).

tff(sy_c_Conform_Ooconf,type,
    oconf: 
      !>[M3: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M3)))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))) ) > $o ) ).

tff(sy_c_Decl_Ois__type,type,
    is_type: 
      !>[M3: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M3)))))))) * ty ) > $o ) ).

tff(sy_c_Exceptions_Opreallocated,type,
    preallocated: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) > $o ).

tff(sy_c_Exceptions_Ostart__heap,type,
    start_heap: 
      !>[C: $tType] : ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,C)))))))) > fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ) ).

tff(sy_c_Expr_Oexp_OFAss,type,
    fAss: 
      !>[A: $tType] : ( ( exp(A) * list(char) * list(char) * exp(A) ) > exp(A) ) ).

tff(sy_c_Expr_Oexp_OVal,type,
    val1: 
      !>[A: $tType] : ( val > exp(A) ) ).

tff(sy_c_Fun_Ofun__upd,type,
    fun_upd: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A * B ) > fun(A,B) ) ).

tff(sy_c_Map_Omap__comp,type,
    map_comp: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,option(C)) * fun(A,option(B)) * A ) > option(C) ) ).

tff(sy_c_Objects_Ohext,type,
    hext: ( fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ) > $o ).

tff(sy_c_Objects_Otypeof__h,type,
    typeof_h: ( fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * val ) > option(ty) ).

tff(sy_c_Option_Ooption_ONone,type,
    none: 
      !>[A: $tType] : option(A) ).

tff(sy_c_Option_Ooption_OSome,type,
    some: 
      !>[A: $tType] : ( A > option(A) ) ).

tff(sy_c_Option_Ooption_Ooption__rec,type,
    option_rec: 
      !>[T5: $tType,A: $tType] : ( ( T5 * fun(A,T5) * option(A) ) > T5 ) ).

tff(sy_c_Option_Oset,type,
    set: 
      !>[A: $tType] : ( option(A) > fun(A,bool) ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T5: $tType] : ( ( fun(A,fun(B,T5)) * product_prod(A,B) ) > T5 ) ).

tff(sy_c_TypeRel_Ohas__field,type,
    has_field: 
      !>[M3: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M3)))))))) * list(char) * list(char) * ty * list(char) ) > $o ) ).

tff(sy_c_TypeRel_Owiden,type,
    widen: 
      !>[M3: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M3)))))))) * ty * ty ) > $o ) ).

tff(sy_c_Value_Odefault__val,type,
    default_val: ty > val ).

tff(sy_c_Value_Othe__Addr,type,
    the_Addr: val > nat ).

tff(sy_c_Value_Oval_OAddr,type,
    addr: nat > val ).

tff(sy_c_WellTypeRT_OWTrt,type,
    wTrt: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * fun(list(char),option(ty)) * exp(list(char)) * ty ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_C____,type,
    c: list(char) ).

tff(sy_v_D____,type,
    d: list(char) ).

tff(sy_v_E____,type,
    e: fun(list(char),option(ty)) ).

tff(sy_v_F____,type,
    f: list(char) ).

tff(sy_v_P,type,
    p: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) ).

tff(sy_v_TF____,type,
    tf: ty ).

tff(sy_v_T____,type,
    t: ty ).

tff(sy_v_Tv____,type,
    tv: ty ).

tff(sy_v_a____,type,
    a: nat ).

tff(sy_v_fs____,type,
    fs: fun(product_prod(list(char),list(char)),option(val)) ).

tff(sy_v_ha____,type,
    ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ).

tff(sy_v_v____,type,
    v: val ).

%----Relevant facts (100)
tff(fact_0_sub,axiom,
    widen(product_prod(list(list(char)),exp(list(char))),p,tv,tf) ).

tff(fact_1_typeofv,axiom,
    typeof_h(ha,v) = some(ty,tv) ).

tff(fact_2_hconf,axiom,
    hconf(product_prod(list(list(char)),exp(list(char))),p,ha) ).

tff(fact_3_has,axiom,
    has_field(product_prod(list(list(char)),exp(list(char))),p,c,f,tf,d) ).

tff(fact_4_RedFAss_I3_J,axiom,
    hconf(product_prod(list(list(char)),exp(list(char))),p,ha) ).

tff(fact_5__096_B_Bthesis_O_A_I_B_BTF_ATv_O_A_091_124_Atypeof_092_060_094bsub_062h_092_060_094esub_062_Av_A_061_A_092_060lfloor_062Tv_092_060rfloor_062_059_AP_A_092_060turnstile_062_AC_Ahas_AF_058TF_Ain_AD_059_AP_A_092_060turnstile_062_ATv_A_092_060le_062_ATF_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [TF: ty,Tv: ty] :
        ( ( typeof_h(ha,v) = some(ty,Tv) )
       => ( has_field(product_prod(list(list(char)),exp(list(char))),p,c,f,TF,d)
         => ~ widen(product_prod(list(list(char)),exp(list(char))),p,Tv,TF) ) ) ).

tff(fact_6_conf__widen,axiom,
    ! [A: $tType,T4: ty,Ta: ty,Va: val,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( conf(A,Pa,Hb,Va,Ta)
     => ( widen(A,Pa,Ta,T4)
       => conf(A,Pa,Hb,Va,T4) ) ) ).

tff(fact_7__096P_Mh_A_092_060turnstile_062_A_IC_M_Afs_J_A_092_060surd_062_096,axiom,
    oconf(product_prod(list(list(char)),exp(list(char))),p,ha,product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),c,fs)) ).

tff(fact_8_typeof__conf,axiom,
    ! [A: $tType,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A)))))))),Ta: ty,Va: val,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( ( typeof_h(Hb,Va) = some(ty,Ta) )
     => conf(A,Pa,Hb,Va,Ta) ) ).

tff(fact_9_defval__conf,axiom,
    ! [A: $tType,Ta: ty,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] : conf(A,Pa,Hb,default_val(Ta),Ta) ).

tff(fact_10_conf__def,axiom,
    ! [A: $tType,Ta: ty,Va: val,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( conf(A,Pa,Hb,Va,Ta)
    <=> ? [T3: ty] :
          ( ( typeof_h(Hb,Va) = some(ty,T3) )
          & widen(A,Pa,T3,Ta) ) ) ).

tff(fact_11_wt,axiom,
    wTrt(p,ha,e,fAss(list(char),val1(list(char),addr(a)),f,d,val1(list(char),v)),t) ).

tff(fact_12_conf__hext,axiom,
    ! [A: $tType,Ta: ty,Va: val,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A)))))))),H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( hext(Hb,H_a)
     => ( conf(A,Pa,Hb,Va,Ta)
       => conf(A,Pa,H_a,Va,Ta) ) ) ).

tff(fact_13_RedFAss_Ohyps,axiom,
    aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),ha,a) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),c,fs)) ).

tff(fact_14_RedFAss_I2_J,axiom,
    wTrt(p,ha,e,fAss(list(char),val1(list(char),addr(a)),f,d,val1(list(char),v)),t) ).

tff(fact_15_hconfD,axiom,
    ! [A: $tType,Obj: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( hconf(A,Pa,Hb)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Obj) )
       => oconf(A,Pa,Hb,Obj) ) ) ).

tff(fact_16_oconf__hext,axiom,
    ! [A: $tType,H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Obj: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( oconf(A,Pa,Hb,Obj)
     => ( hext(Hb,H_a)
       => oconf(A,Pa,H_a,Obj) ) ) ).

tff(fact_17_WTrtVal,axiom,
    ! [Ea: fun(list(char),option(ty)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),Ta: ty,Va: val,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( ( typeof_h(Hb,Va) = some(ty,Ta) )
     => wTrt(Pa,Hb,Ea,val1(list(char),Va),Ta) ) ).

tff(fact_18_hext__typeof__mono,axiom,
    ! [Ta: ty,Va: val,H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( hext(Hb,H_a)
     => ( ( typeof_h(Hb,Va) = some(ty,Ta) )
       => ( typeof_h(H_a,Va) = some(ty,Ta) ) ) ) ).

tff(fact_19_hext__refl,axiom,
    ! [Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] : hext(Hb,Hb) ).

tff(fact_20_exp_Osimps_I8_J,axiom,
    ! [A: $tType,Exp22: exp(A),List22: list(char),List12: list(char),Exp12: exp(A),Exp21: exp(A),List21: list(char),List11: list(char),Exp11: exp(A)] :
      ( ( fAss(A,Exp11,List11,List21,Exp21) = fAss(A,Exp12,List12,List22,Exp22) )
    <=> ( ( Exp11 = Exp12 )
        & ( List11 = List12 )
        & ( List21 = List22 )
        & ( Exp21 = Exp22 ) ) ) ).

tff(fact_21_widen__refl,axiom,
    ! [M3: $tType,T2: ty,P: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M3))))))))] : widen(M3,P,T2,T2) ).

tff(fact_22_val_Osimps_I3_J,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( addr(Nat) = addr(Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_23_option_Oinject,axiom,
    ! [A: $tType,A6: A,Aa: A] :
      ( ( some(A,Aa) = some(A,A6) )
    <=> ( Aa = A6 ) ) ).

tff(fact_24_exp_Osimps_I3_J,axiom,
    ! [A: $tType,Val2: val,Val1: val] :
      ( ( val1(A,Val1) = val1(A,Val2) )
    <=> ( Val1 = Val2 ) ) ).

tff(fact_25_widen__trans,axiom,
    ! [A: $tType,T2: ty,U: ty,S1: ty,P: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( widen(A,P,S1,U)
     => ( widen(A,P,U,T2)
       => widen(A,P,S1,T2) ) ) ).

tff(fact_26_hext__trans,axiom,
    ! [H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( hext(Hb,H_a)
     => ( hext(H_a,H)
       => hext(Hb,H) ) ) ).

tff(fact_27_exp_Osimps_I79_J,axiom,
    ! [A: $tType,Val: val,Exp2: exp(A),List2: list(char),List1: list(char),Exp1: exp(A)] : ( fAss(A,Exp1,List1,List2,Exp2) != val1(A,Val) ) ).

tff(fact_28_exp_Osimps_I78_J,axiom,
    ! [A: $tType,Exp2: exp(A),List2: list(char),List1: list(char),Exp1: exp(A),Val: val] : ( val1(A,Val) != fAss(A,Exp1,List1,List2,Exp2) ) ).

tff(fact_29_WTrt__hext__mono,axiom,
    ! [H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ta: ty,Ea1: exp(list(char)),Ea: fun(list(char),option(ty)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wTrt(Pa,Hb,Ea,Ea1,Ta)
     => ( hext(Hb,H_a)
       => wTrt(Pa,H_a,Ea,Ea1,Ta) ) ) ).

tff(fact_30_hext__def,axiom,
    ! [H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( hext(Hb,H_a)
    <=> ! [A4: nat,C4: list(char),Fs4: fun(product_prod(list(char),list(char)),option(val))] :
          ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,A4) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C4,Fs4)) )
         => ? [Fs5: fun(product_prod(list(char),list(char)),option(val))] : ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),H_a,A4) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C4,Fs5)) ) ) ) ).

tff(fact_31_hext__objD,axiom,
    ! [Fsa: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( hext(Hb,H_a)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fsa)) )
       => ? [Fs3: fun(product_prod(list(char),list(char)),option(val))] : ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),H_a,Aa) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs3)) ) ) ) ).

tff(fact_32_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B6: B,A6: A,B2: B,Aa: A] :
      ( ( product_Pair(A,B,Aa,B2) = product_Pair(A,B,A6,B6) )
    <=> ( ( Aa = A6 )
        & ( B2 = B6 ) ) ) ).

tff(fact_33_split__paired__All,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ! [A4: A,B3: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A4,B3))) ) ).

tff(fact_34_hextI,axiom,
    ! [H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( ! [A1: nat,C3: list(char),Fs1: fun(product_prod(list(char),list(char)),option(val))] :
          ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,A1) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C3,Fs1)) )
         => ? [Fs2: fun(product_prod(list(char),list(char)),option(val))] : ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),H_a,A1) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C3,Fs2)) ) )
     => hext(Hb,H_a) ) ).

tff(fact_35_hconf__def,axiom,
    ! [A: $tType,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( hconf(A,Pa,Hb)
    <=> ( ! [A4: nat,Obj1: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))] :
            ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,A4) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Obj1) )
           => oconf(A,Pa,Hb,Obj1) )
        & preallocated(Hb) ) ) ).

tff(fact_36_the__Addr_Osimps,axiom,
    ! [A5: nat] : ( the_Addr(addr(A5)) = A5 ) ).

tff(fact_37_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B5: B,A2: A,B4: B,A5: A] :
      ( ( product_Pair(A,B,A5,B4) = product_Pair(A,B,A2,B5) )
     => ~ ( ( A5 = A2 )
         => ( B4 != B5 ) ) ) ).

tff(fact_38_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ? [A4: A,B3: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A4,B3))) ) ).

tff(fact_39_preallocated__hext,axiom,
    ! [H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( preallocated(Hb)
     => ( hext(Hb,H_a)
       => preallocated(H_a) ) ) ).

tff(fact_40_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,B2: C,Aa: B,F1: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F1,product_Pair(B,C,Aa,B2)) = aa(C,A,aa(B,fun(C,A),F1,Aa),B2) ) ).

tff(fact_41_elem__set,axiom,
    ! [A: $tType,Xo: option(A),X1: A] :
      ( member(A,X1,set(A,Xo))
    <=> ( Xo = some(A,X1) ) ) ).

tff(fact_42_option_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,Aa: B,F2: fun(B,A),F1: A] : ( option_rec(A,B,F1,F2,some(B,Aa)) = aa(B,A,F2,Aa) ) ).

tff(fact_43_ospec,axiom,
    ! [A: $tType,X1: A,Pa: fun(A,bool),A3: option(A)] :
      ( ! [X2: A] :
          ( member(A,X2,set(A,A3))
         => pp(aa(A,bool,Pa,X2)) )
     => ( ( A3 = some(A,X1) )
       => pp(aa(A,bool,Pa,X1)) ) ) ).

tff(fact_44_preallocated__start,axiom,
    ! [A: $tType,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] : preallocated(start_heap(A,Pa)) ).

tff(fact_45_oconf__fupd,axiom,
    ! [A: $tType,Fsa: fun(product_prod(list(char),list(char)),option(val)),Va: val,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Da: list(char),Ta: ty,Fa: list(char),Ca: list(char),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( has_field(A,Pa,Ca,Fa,Ta,Da)
     => ( conf(A,Pa,Hb,Va,Ta)
       => ( oconf(A,Pa,Hb,product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fsa))
         => oconf(A,Pa,Hb,product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,fun_upd(product_prod(list(char),list(char)),option(val),Fsa,product_Pair(list(char),list(char),Fa,Da),some(val,Va)))) ) ) ) ).

tff(fact_46_pred__equals__eq2,axiom,
    ! [B: $tType,A: $tType,S: fun(product_prod(A,B),bool),R: fun(product_prod(A,B),bool)] :
      ( ! [X3: A,Xa: B] :
          ( member(product_prod(A,B),product_Pair(A,B,X3,Xa),R)
        <=> member(product_prod(A,B),product_Pair(A,B,X3,Xa),S) )
    <=> ( R = S ) ) ).

tff(fact_47_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y: product_prod(A,B)] :
      ~ ! [A1: A,B1: B] : ( Y != product_Pair(A,B,A1,B1) ) ).

tff(fact_48_fun__upd__triv,axiom,
    ! [B: $tType,A: $tType,X1: A,F: fun(A,B)] : ( fun_upd(A,B,F,X1,aa(A,B,F,X1)) = F ) ).

tff(fact_49_fun__upd__upd,axiom,
    ! [A: $tType,B: $tType,Z: B,Y3: B,X1: A,F: fun(A,B)] : ( fun_upd(A,B,fun_upd(A,B,F,X1,Y3),X1,Z) = fun_upd(A,B,F,X1,Z) ) ).

tff(fact_50_fun__upd__apply,axiom,
    ! [B: $tType,A: $tType,Y3: B,F: fun(A,B),X1: A,Z: A] :
      ( ( ( Z = X1 )
       => ( aa(A,B,fun_upd(A,B,F,X1,Y3),Z) = Y3 ) )
      & ( ( Z != X1 )
       => ( aa(A,B,fun_upd(A,B,F,X1,Y3),Z) = aa(A,B,F,Z) ) ) ) ).

tff(fact_51_map__upd__Some__unfold,axiom,
    ! [B: $tType,A: $tType,Y3: A,X1: B,B2: A,Aa: B,M: fun(B,option(A))] :
      ( ( aa(B,option(A),fun_upd(B,option(A),M,Aa,some(A,B2)),X1) = some(A,Y3) )
    <=> ( ( ( X1 = Aa )
          & ( B2 = Y3 ) )
        | ( ( X1 != Aa )
          & ( aa(B,option(A),M,X1) = some(A,Y3) ) ) ) ) ).

tff(fact_52_conf__upd__obj,axiom,
    ! [A: $tType,Ta: ty,X1: val,Fs: fun(product_prod(list(char),list(char)),option(val)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A)))))))),Fsa: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fsa)) )
     => ( conf(A,Pa,fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs))),X1,Ta)
      <=> conf(A,Pa,Hb,X1,Ta) ) ) ).

tff(fact_53_hext__upd__obj,axiom,
    ! [Fs: fun(product_prod(list(char),list(char)),option(val)),Fsa: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fsa)) )
     => hext(Hb,fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs)))) ) ).

tff(fact_54_preallocated__upd__obj,axiom,
    ! [Fs: fun(product_prod(list(char),list(char)),option(val)),Fsa: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( preallocated(Hb)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fsa)) )
       => preallocated(fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs)))) ) ) ).

tff(fact_55_oconf__upd__obj,axiom,
    ! [A: $tType,Fs: fun(product_prod(list(char),list(char)),option(val)),Fsa: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,Obj: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( oconf(A,Pa,Hb,Obj)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fsa)) )
       => oconf(A,Pa,fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs))),Obj) ) ) ).

tff(fact_56_fun__upd__def,axiom,
    ! [B: $tType,A: $tType,B2: B,F: fun(A,B),Aa: A,X: A] :
      ( ( ( X = Aa )
       => ( aa(A,B,fun_upd(A,B,F,Aa,B2),X) = B2 ) )
      & ( ( X != Aa )
       => ( aa(A,B,fun_upd(A,B,F,Aa,B2),X) = aa(A,B,F,X) ) ) ) ).

tff(fact_57_fun__upd__idem,axiom,
    ! [A: $tType,B: $tType,Y3: A,X1: B,F: fun(B,A)] :
      ( ( aa(B,A,F,X1) = Y3 )
     => ( fun_upd(B,A,F,X1,Y3) = F ) ) ).

tff(fact_58_fun__upd__other,axiom,
    ! [B: $tType,A: $tType,Y3: B,F: fun(A,B),X1: A,Z: A] :
      ( ( Z != X1 )
     => ( aa(A,B,fun_upd(A,B,F,X1,Y3),Z) = aa(A,B,F,Z) ) ) ).

tff(fact_59_fun__upd__twist,axiom,
    ! [A: $tType,B: $tType,D2: B,B2: B,M: fun(A,B),C2: A,Aa: A] :
      ( ( Aa != C2 )
     => ( fun_upd(A,B,fun_upd(A,B,M,Aa,B2),C2,D2) = fun_upd(A,B,fun_upd(A,B,M,C2,D2),Aa,B2) ) ) ).

tff(fact_60_fun__upd__same,axiom,
    ! [B: $tType,A: $tType,Y3: A,X1: B,F: fun(B,A)] : ( aa(B,A,fun_upd(B,A,F,X1,Y3),X1) = Y3 ) ).

tff(fact_61_fun__upd__idem__iff,axiom,
    ! [A: $tType,B: $tType,Y3: B,X1: A,F: fun(A,B)] :
      ( ( fun_upd(A,B,F,X1,Y3) = F )
    <=> ( aa(A,B,F,X1) = Y3 ) ) ).

tff(fact_62_hconf__upd__obj,axiom,
    ! [A: $tType,Fs: fun(product_prod(list(char),list(char)),option(val)),Fsa: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( hconf(A,Pa,Hb)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fsa)) )
       => ( oconf(A,Pa,Hb,product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs))
         => hconf(A,Pa,fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs)))) ) ) ) ).

tff(fact_63_map__upd__eqD1,axiom,
    ! [A: $tType,B: $tType,Y3: B,N: fun(A,option(B)),X1: B,Aa: A,M: fun(A,option(B))] :
      ( ( fun_upd(A,option(B),M,Aa,some(B,X1)) = fun_upd(A,option(B),N,Aa,some(B,Y3)) )
     => ( X1 = Y3 ) ) ).

tff(fact_64_map__upd__triv,axiom,
    ! [A: $tType,B: $tType,X1: A,K: B,T: fun(B,option(A))] :
      ( ( aa(B,option(A),T,K) = some(A,X1) )
     => ( fun_upd(B,option(A),T,K,some(A,X1)) = T ) ) ).

tff(fact_65_lconf__upd2,axiom,
    ! [A: $tType,V2: list(char),Ta: ty,Va: val,Ea: fun(list(char),option(ty)),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( lconf(A,Pa,Hb,Lb,Ea)
     => ( conf(A,Pa,Hb,Va,Ta)
       => lconf(A,Pa,Hb,fun_upd(list(char),option(val),Lb,V2,some(val,Va)),fun_upd(list(char),option(ty),Ea,V2,some(ty,Ta))) ) ) ).

tff(fact_66_lconf__upd,axiom,
    ! [A: $tType,V2: list(char),Ta: ty,Va: val,Ea: fun(list(char),option(ty)),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( lconf(A,Pa,Hb,Lb,Ea)
     => ( conf(A,Pa,Hb,Va,Ta)
       => ( ( aa(list(char),option(ty),Ea,V2) = some(ty,Ta) )
         => lconf(A,Pa,Hb,fun_upd(list(char),option(val),Lb,V2,some(val,Va)),Ea) ) ) ) ).

tff(fact_67_PairE,axiom,
    ! [A: $tType,B: $tType,P1: product_prod(A,B)] :
      ~ ! [X2: A,Y2: B] : ( P1 != product_Pair(A,B,X2,Y2) ) ).

tff(fact_68_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y: product_prod(A,product_prod(B,C))] :
      ~ ! [A1: A,B1: B,C1: C] : ( Y != product_Pair(A,product_prod(B,C),A1,product_Pair(B,C,B1,C1)) ) ).

tff(fact_69_lconf__hext,axiom,
    ! [A: $tType,H_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ea: fun(list(char),option(ty)),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( lconf(A,Pa,Hb,Lb,Ea)
     => ( hext(Hb,H_a)
       => lconf(A,Pa,H_a,Lb,Ea) ) ) ).

tff(fact_70_lconf__def,axiom,
    ! [A: $tType,Ea: fun(list(char),option(ty)),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( lconf(A,Pa,Hb,Lb,Ea)
    <=> ! [V1: list(char),V: val] :
          ( ( aa(list(char),option(val),Lb,V1) = some(val,V) )
         => ? [T1: ty] :
              ( ( aa(list(char),option(ty),Ea,V1) = some(ty,T1) )
              & conf(A,Pa,Hb,V,T1) ) ) ) ).

tff(fact_71_prod__induct6,axiom,
    ! [F3: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3))))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3))))),bool)] :
      ( ! [A1: A,B1: B,C1: C,D1: D,E1: E,F4: F3] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3))))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3)))),A1,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F3))),B1,product_Pair(C,product_prod(D,product_prod(E,F3)),C1,product_Pair(D,product_prod(E,F3),D1,product_Pair(E,F3,E1,F4)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3))))),bool,Pa,X1)) ) ).

tff(fact_72_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F3: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3)))))] :
      ~ ! [A1: A,B1: B,C1: C,D1: D,E1: E,F4: F3] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3)))),A1,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F3))),B1,product_Pair(C,product_prod(D,product_prod(E,F3)),C1,product_Pair(D,product_prod(E,F3),D1,product_Pair(E,F3,E1,F4))))) ) ).

tff(fact_73_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))] :
      ~ ! [A1: A,B1: B,C1: C,D1: D,E1: E] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A1,product_Pair(B,product_prod(C,product_prod(D,E)),B1,product_Pair(C,product_prod(D,E),C1,product_Pair(D,E,D1,E1)))) ) ).

tff(fact_74_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A1: A,B1: B,C1: C,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A1,product_Pair(B,product_prod(C,product_prod(D,E)),B1,product_Pair(C,product_prod(D,E),C1,product_Pair(D,E,D1,E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,Pa,X1)) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A3: fun(A,bool),X1: A] :
      ( member(A,X1,A3)
    <=> pp(aa(A,bool,A3,X1)) ) ).

tff(fact_77_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,D))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A1: A,B1: B,C1: C,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,D)),A1,product_Pair(B,product_prod(C,D),B1,product_Pair(C,D,C1,D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,Pa,X1)) ) ).

tff(fact_78_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y: product_prod(A,product_prod(B,product_prod(C,D)))] :
      ~ ! [A1: A,B1: B,C1: C,D1: D] : ( Y != product_Pair(A,product_prod(B,product_prod(C,D)),A1,product_Pair(B,product_prod(C,D),B1,product_Pair(C,D,C1,D1))) ) ).

tff(fact_79_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,C)),Pa: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A1: A,B1: B,C1: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,Pa,product_Pair(A,product_prod(B,C),A1,product_Pair(B,C,B1,C1))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,Pa,X1)) ) ).

tff(fact_80_hconf__new,axiom,
    ! [A: $tType,Obj: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( hconf(A,Pa,Hb)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = none(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))) )
       => ( oconf(A,Pa,Hb,Obj)
         => hconf(A,Pa,fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Obj))) ) ) ) ).

tff(fact_81_not__None__eq,axiom,
    ! [A: $tType,X1: option(A)] :
      ( ( X1 != none(A) )
    <=> ? [Y1: A] : ( X1 = some(A,Y1) ) ) ).

tff(fact_82_not__Some__eq,axiom,
    ! [A: $tType,X1: option(A)] :
      ( ! [Y1: A] : ( X1 != some(A,Y1) )
    <=> ( X1 = none(A) ) ) ).

tff(fact_83_empty__upd__none,axiom,
    ! [A: $tType,B: $tType,X1: A,X: A] : ( aa(A,option(B),fun_upd(A,option(B),combk(option(B),A,none(B)),X1,none(B)),X) = none(B) ) ).

tff(fact_84_map__upd__nonempty,axiom,
    ! [A: $tType,B: $tType,X1: B,K: A,T: fun(A,option(B))] :
      ~ ! [X2: A] : ( aa(A,option(B),fun_upd(A,option(B),T,K,some(B,X1)),X2) = none(B) ) ).

tff(fact_85_option_Orecs_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,A),F1: A] : ( option_rec(A,B,F1,F2,none(B)) = F1 ) ).

tff(fact_86_option_Osimps_I3_J,axiom,
    ! [A: $tType,A2: A] : ( some(A,A2) != none(A) ) ).

tff(fact_87_option_Osimps_I2_J,axiom,
    ! [A: $tType,A2: A] : ( none(A) != some(A,A2) ) ).

tff(fact_88_typeof__lit__typeof,axiom,
    ! [Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ta: ty,Va: val] :
      ( ( typeof_h(combk(option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),nat,none(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Va) = some(ty,Ta) )
     => ( typeof_h(Hb,Va) = some(ty,Ta) ) ) ).

tff(fact_89_hext__new,axiom,
    ! [X1: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = none(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))) )
     => hext(Hb,fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),X1))) ) ).

tff(fact_90_preallocated__new,axiom,
    ! [X1: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( preallocated(Hb)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = none(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))) )
       => preallocated(fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),X1))) ) ) ).

tff(fact_91_oconf__new,axiom,
    ! [A: $tType,X1: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Aa: nat,Obj: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( oconf(A,Pa,Hb,Obj)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = none(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))) )
       => oconf(A,Pa,fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),X1)),Obj) ) ) ).

tff(fact_92_typeof__lit__conf,axiom,
    ! [A: $tType,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A)))))))),Ta: ty,Va: val] :
      ( ( typeof_h(combk(option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),nat,none(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Va) = some(ty,Ta) )
     => conf(A,Pa,Hb,Va,Ta) ) ).

tff(fact_93_option_Oexhaust,axiom,
    ! [A: $tType,Y: option(A)] :
      ( ( Y != none(A) )
     => ~ ! [A1: A] : ( Y != some(A,A1) ) ) ).

tff(fact_94_typeof__lit__is__type,axiom,
    ! [A: $tType,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A)))))))),Ta: ty,Va: val] :
      ( ( typeof_h(combk(option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),nat,none(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Va) = some(ty,Ta) )
     => is_type(A,Pa,Ta) ) ).

tff(fact_95_lconf__empty,axiom,
    ! [A: $tType,Ea: fun(list(char),option(ty)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] : lconf(A,Pa,Hb,combk(option(val),list(char),none(val)),Ea) ).

tff(fact_96_map__comp__empty_I2_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,M: fun(A,option(C)),X: A] : ( map_comp(C,B,A,combk(option(B),C,none(B)),M,X) = none(B) ) ).

tff(fact_97_map__comp__empty_I1_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,M: fun(C,option(B)),X: A] : ( map_comp(C,B,A,M,combk(option(C),A,none(C)),X) = none(B) ) ).

tff(fact_98_map__comp__simps_I1_J,axiom,
    ! [B: $tType,A: $tType,C: $tType,M1: fun(A,option(C)),K: B,M2: fun(B,option(A))] :
      ( ( aa(B,option(A),M2,K) = none(A) )
     => ( map_comp(A,C,B,M1,M2,K) = none(C) ) ) ).

tff(fact_99_map__comp__simps_I2_J,axiom,
    ! [B: $tType,C: $tType,A: $tType,M1: fun(A,option(C)),K1: A,K: B,M2: fun(B,option(A))] :
      ( ( aa(B,option(A),M2,K) = some(A,K1) )
     => ( map_comp(A,C,B,M1,M2,K) = aa(A,option(C),M1,K1) ) ) ).

%----Helper facts (3)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    conf(product_prod(list(list(char)),exp(list(char))),p,ha,v,tf) ).

%------------------------------------------------------------------------------
