%------------------------------------------------------------------------------
% File     : SWW552_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Java type soundness line 35
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : jinja_35 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v6.4.0
% Syntax   : Number of formulae    :  162 (  43 unt;  57 typ;   0 def)
%            Number of atoms       :  218 ( 125 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  148 (  35   ~;   2   |;  13   &)
%                                         (  23 <=>;  75  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   21 (   8 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   83 (  37   >;  46   *;   0   +;   0  <<)
%            Number of predicates  :   12 (  11 usr;   0 prp; 1-6 aty)
%            Number of functors    :   41 (  41 usr;  13 con; 0-6 aty)
%            Number of variables   :  630 ( 579   !;   8   ?; 630   :)
%                                         (  43  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:57
%------------------------------------------------------------------------------
%----Should-be-implicit typings (10)
tff(ty_tc_Expr_Oexp,type,
    exp: $tType > $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Option_Ooption,type,
    option: $tType > $tType ).

tff(ty_tc_String_Ochar,type,
    char: $tType ).

tff(ty_tc_Type_Oty,type,
    ty: $tType ).

tff(ty_tc_Value_Oval,type,
    val: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (47)
tff(sy_c_BigStep_Oeval,type,
    eval: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * exp(list(char)) * product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))) * exp(list(char)) * product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))) ) > $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_Conform_Oconf,type,
    conf: 
      !>[M3: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M3)))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * val * ty ) > $o ) ).

tff(sy_c_Conform_Ohconf,type,
    hconf: 
      !>[M3: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M3)))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ) > $o ) ).

tff(sy_c_Conform_Olconf,type,
    lconf: 
      !>[M3: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M3)))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * fun(list(char),option(val)) * fun(list(char),option(ty)) ) > $o ) ).

tff(sy_c_Conform_Ooconf,type,
    oconf: 
      !>[M3: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M3)))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))) ) > $o ) ).

tff(sy_c_Exceptions_Opreallocated,type,
    preallocated: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) > $o ).

tff(sy_c_Exceptions_Ostart__heap,type,
    start_heap: 
      !>[C: $tType] : ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,C)))))))) > fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ) ).

tff(sy_c_Expr_Oexp_OFAss,type,
    fAss: 
      !>[A: $tType] : ( ( exp(A) * list(char) * list(char) * exp(A) ) > exp(A) ) ).

tff(sy_c_Expr_Oexp_OVal,type,
    val1: 
      !>[A: $tType] : ( val > exp(A) ) ).

tff(sy_c_Fun_Ofun__upd,type,
    fun_upd: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A * B ) > fun(A,B) ) ).

tff(sy_c_Map_Omap__comp,type,
    map_comp: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,option(C)) * fun(A,option(B)) * A ) > option(C) ) ).

tff(sy_c_Option_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( fun(A,B) > fun(option(A),option(B)) ) ).

tff(sy_c_Option_Ooption_ONone,type,
    none: 
      !>[A: $tType] : option(A) ).

tff(sy_c_Option_Ooption_OSome,type,
    some: 
      !>[A: $tType] : fun(A,option(A)) ).

tff(sy_c_Option_Ooption_Ooption__case,type,
    option_case: 
      !>[T2: $tType,A: $tType] : ( ( T2 * fun(A,T2) ) > fun(option(A),T2) ) ).

tff(sy_c_Option_Ooption_Ooption__rec,type,
    option_rec: 
      !>[T2: $tType,A: $tType] : ( ( T2 * fun(A,T2) * option(A) ) > T2 ) ).

tff(sy_c_Option_Oset,type,
    set: 
      !>[A: $tType] : ( option(A) > fun(A,bool) ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(product_prod(A,B),C) * A * B ) > C ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * product_prod(A,B) ) > C ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T2: $tType] : ( ( fun(A,fun(B,T2)) * product_prod(A,B) ) > T2 ) ).

tff(sy_c_Quickcheck__Exhaustive_Oorelse,type,
    quickcheck_orelse: 
      !>[A: $tType] : ( ( option(A) * option(A) ) > option(A) ) ).

tff(sy_c_SmallStep_Ored,type,
    red: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) > fun(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),bool) ).

tff(sy_c_SmallStep_Oredp,type,
    redp: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * exp(list(char)) * product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))) * exp(list(char)) * product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))) ) > $o ).

tff(sy_c_Transitive__Closure_Ortrancl,type,
    transitive_rtrancl: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_TypeRel_Ohas__field,type,
    has_field: 
      !>[M3: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M3)))))))) * list(char) * list(char) * ty * list(char) ) > $o ) ).

tff(sy_c_Value_Othe__Addr,type,
    the_Addr: val > nat ).

tff(sy_c_Value_Oval_OAddr,type,
    addr: nat > val ).

tff(sy_c_Value_Oval_OUnit,type,
    unit: val ).

tff(sy_c_WellTypeRT_OWTrt,type,
    wTrt: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * fun(list(char),option(ty)) * exp(list(char)) * ty ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_C____,type,
    c: list(char) ).

tff(sy_v_D____,type,
    d: list(char) ).

tff(sy_v_E____,type,
    e: fun(list(char),option(ty)) ).

tff(sy_v_F____,type,
    f: list(char) ).

tff(sy_v_P,type,
    p: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) ).

tff(sy_v_T____,type,
    t: ty ).

tff(sy_v_a____,type,
    a: nat ).

tff(sy_v_fs____,type,
    fs: fun(product_prod(list(char),list(char)),option(val)) ).

tff(sy_v_ha____,type,
    ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ).

tff(sy_v_v____,type,
    v: val ).

%----Relevant facts (100)
tff(fact_0_RedFAss_I3_J,axiom,
    hconf(product_prod(list(list(char)),exp(list(char))),p,ha) ).

tff(fact_1_RedFAss_Ohyps,axiom,
    aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),ha,a) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),c,fs)) ).

tff(fact_2_RedFAss_I2_J,axiom,
    wTrt(p,ha,e,fAss(list(char),val1(list(char),addr(a)),f,d,val1(list(char),v)),t) ).

tff(fact_3_hconfD,axiom,
    ! [A: $tType,Obj: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( hconf(A,Pa,Hb)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Obj) )
       => oconf(A,Pa,Hb,Obj) ) ) ).

tff(fact_4_exp_Osimps_I8_J,axiom,
    ! [A: $tType,Exp22: exp(A),List22: list(char),List12: list(char),Exp12: exp(A),Exp21: exp(A),List21: list(char),List11: list(char),Exp11: exp(A)] :
      ( ( fAss(A,Exp11,List11,List21,Exp21) = fAss(A,Exp12,List12,List22,Exp22) )
    <=> ( ( Exp11 = Exp12 )
        & ( List11 = List12 )
        & ( List21 = List22 )
        & ( Exp21 = Exp22 ) ) ) ).

tff(fact_5_val_Osimps_I3_J,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( addr(Nat1) = addr(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_6_option_Oinject,axiom,
    ! [A: $tType,A6: A,Aa: A] :
      ( ( aa(A,option(A),some(A),Aa) = aa(A,option(A),some(A),A6) )
    <=> ( Aa = A6 ) ) ).

tff(fact_7_exp_Osimps_I3_J,axiom,
    ! [A: $tType,Val2: val,Val1: val] :
      ( ( val1(A,Val1) = val1(A,Val2) )
    <=> ( Val1 = Val2 ) ) ).

tff(fact_8_split__paired__All,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ! [A5: A,B3: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A5,B3))) ) ).

tff(fact_9_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B6: B,A6: A,B1: B,Aa: A] :
      ( ( product_Pair(A,B,Aa,B1) = product_Pair(A,B,A6,B6) )
    <=> ( ( Aa = A6 )
        & ( B1 = B6 ) ) ) ).

tff(fact_10_exp_Osimps_I78_J,axiom,
    ! [A: $tType,Exp2: exp(A),List2: list(char),List1: list(char),Exp1: exp(A),Val: val] : ( val1(A,Val) != fAss(A,Exp1,List1,List2,Exp2) ) ).

tff(fact_11_exp_Osimps_I79_J,axiom,
    ! [A: $tType,Val: val,Exp2: exp(A),List2: list(char),List1: list(char),Exp1: exp(A)] : ( fAss(A,Exp1,List1,List2,Exp2) != val1(A,Val) ) ).

tff(fact_12_hconf__def,axiom,
    ! [A: $tType,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( hconf(A,Pa,Hb)
    <=> ( ! [A5: nat,Obj1: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))] :
            ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,A5) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Obj1) )
           => oconf(A,Pa,Hb,Obj1) )
        & preallocated(Hb) ) ) ).

tff(fact_13_pred__equals__eq2,axiom,
    ! [B: $tType,A: $tType,S2: fun(product_prod(A,B),bool),R1: fun(product_prod(A,B),bool)] :
      ( ! [X3: A,Xa1: B] :
          ( member(product_prod(A,B),product_Pair(A,B,X3,Xa1),R1)
        <=> member(product_prod(A,B),product_Pair(A,B,X3,Xa1),S2) )
    <=> ( R1 = S2 ) ) ).

tff(fact_14_hconf__upd__obj,axiom,
    ! [A: $tType,Fs: fun(product_prod(list(char),list(char)),option(val)),Fsa: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( hconf(A,Pa,Hb)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fsa)) )
       => ( oconf(A,Pa,Hb,product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs))
         => hconf(A,Pa,fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs)))) ) ) ) ).

tff(fact_15_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B5: B,A3: A,B4: B,A4: A] :
      ( ( product_Pair(A,B,A4,B4) = product_Pair(A,B,A3,B5) )
     => ~ ( ( A4 = A3 )
         => ( B4 != B5 ) ) ) ).

tff(fact_16_oconf__upd__obj,axiom,
    ! [A: $tType,Fs: fun(product_prod(list(char),list(char)),option(val)),Fsa: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,Obj: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( oconf(A,Pa,Hb,Obj)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fsa)) )
       => oconf(A,Pa,fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs))),Obj) ) ) ).

tff(fact_17_preallocated__upd__obj,axiom,
    ! [Fs: fun(product_prod(list(char),list(char)),option(val)),Fsa: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( preallocated(Hb)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fsa)) )
       => preallocated(fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs)))) ) ) ).

tff(fact_18_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ? [A5: A,B3: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A5,B3))) ) ).

tff(fact_19_fun__upd__apply,axiom,
    ! [B: $tType,A: $tType,Y1: B,F: fun(A,B),X1: A,Z1: A] :
      ( ( ( Z1 = X1 )
       => ( aa(A,B,fun_upd(A,B,F,X1,Y1),Z1) = Y1 ) )
      & ( ( Z1 != X1 )
       => ( aa(A,B,fun_upd(A,B,F,X1,Y1),Z1) = aa(A,B,F,Z1) ) ) ) ).

tff(fact_20_fun__upd__upd,axiom,
    ! [A: $tType,B: $tType,Z1: B,Y1: B,X1: A,F: fun(A,B)] : ( fun_upd(A,B,fun_upd(A,B,F,X1,Y1),X1,Z1) = fun_upd(A,B,F,X1,Z1) ) ).

tff(fact_21_fun__upd__triv,axiom,
    ! [B: $tType,A: $tType,X1: A,F: fun(A,B)] : ( fun_upd(A,B,F,X1,aa(A,B,F,X1)) = F ) ).

tff(fact_22_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,B1: C,Aa: B,F1: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F1,product_Pair(B,C,Aa,B1)) = aa(C,A,aa(B,fun(C,A),F1,Aa),B1) ) ).

tff(fact_23_map__upd__eqD1,axiom,
    ! [A: $tType,B: $tType,Y1: B,N: fun(A,option(B)),X1: B,Aa: A,M: fun(A,option(B))] :
      ( ( fun_upd(A,option(B),M,Aa,aa(B,option(B),some(B),X1)) = fun_upd(A,option(B),N,Aa,aa(B,option(B),some(B),Y1)) )
     => ( X1 = Y1 ) ) ).

tff(fact_24_map__upd__triv,axiom,
    ! [A: $tType,B: $tType,X1: A,K: B,T1: fun(B,option(A))] :
      ( ( aa(B,option(A),T1,K) = aa(A,option(A),some(A),X1) )
     => ( fun_upd(B,option(A),T1,K,aa(A,option(A),some(A),X1)) = T1 ) ) ).

tff(fact_25_fun__upd__idem__iff,axiom,
    ! [A: $tType,B: $tType,Y1: B,X1: A,F: fun(A,B)] :
      ( ( fun_upd(A,B,F,X1,Y1) = F )
    <=> ( aa(A,B,F,X1) = Y1 ) ) ).

tff(fact_26_fun__upd__same,axiom,
    ! [B: $tType,A: $tType,Y1: A,X1: B,F: fun(B,A)] : ( aa(B,A,fun_upd(B,A,F,X1,Y1),X1) = Y1 ) ).

tff(fact_27_fun__upd__twist,axiom,
    ! [A: $tType,B: $tType,D2: B,B1: B,M: fun(A,B),C1: A,Aa: A] :
      ( ( Aa != C1 )
     => ( fun_upd(A,B,fun_upd(A,B,M,Aa,B1),C1,D2) = fun_upd(A,B,fun_upd(A,B,M,C1,D2),Aa,B1) ) ) ).

tff(fact_28_fun__upd__other,axiom,
    ! [B: $tType,A: $tType,Y1: B,F: fun(A,B),X1: A,Z1: A] :
      ( ( Z1 != X1 )
     => ( aa(A,B,fun_upd(A,B,F,X1,Y1),Z1) = aa(A,B,F,Z1) ) ) ).

tff(fact_29_fun__upd__idem,axiom,
    ! [A: $tType,B: $tType,Y1: A,X1: B,F: fun(B,A)] :
      ( ( aa(B,A,F,X1) = Y1 )
     => ( fun_upd(B,A,F,X1,Y1) = F ) ) ).

tff(fact_30_fun__upd__def,axiom,
    ! [B: $tType,A: $tType,B1: B,F: fun(A,B),Aa: A,X: A] :
      ( ( ( X = Aa )
       => ( aa(A,B,fun_upd(A,B,F,Aa,B1),X) = B1 ) )
      & ( ( X != Aa )
       => ( aa(A,B,fun_upd(A,B,F,Aa,B1),X) = aa(A,B,F,X) ) ) ) ).

tff(fact_31_map__upd__Some__unfold,axiom,
    ! [B: $tType,A: $tType,Y1: A,X1: B,B1: A,Aa: B,M: fun(B,option(A))] :
      ( ( aa(B,option(A),fun_upd(B,option(A),M,Aa,aa(A,option(A),some(A),B1)),X1) = aa(A,option(A),some(A),Y1) )
    <=> ( ( ( X1 = Aa )
          & ( B1 = Y1 ) )
        | ( ( X1 != Aa )
          & ( aa(B,option(A),M,X1) = aa(A,option(A),some(A),Y1) ) ) ) ) ).

tff(fact_32_preallocated__start,axiom,
    ! [A: $tType,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] : preallocated(start_heap(A,Pa)) ).

tff(fact_33_the__Addr_Osimps,axiom,
    ! [A4: nat] : ( the_Addr(addr(A4)) = A4 ) ).

tff(fact_34_elem__set,axiom,
    ! [A: $tType,Xo: option(A),X1: A] :
      ( member(A,X1,set(A,Xo))
    <=> ( Xo = aa(A,option(A),some(A),X1) ) ) ).

tff(fact_35_hconf__new,axiom,
    ! [A: $tType,Obj: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( hconf(A,Pa,Hb)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = none(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))) )
       => ( oconf(A,Pa,Hb,Obj)
         => hconf(A,Pa,fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Obj))) ) ) ) ).

tff(fact_36_option_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,Aa: B,F2: fun(B,A),F1: A] : ( option_rec(A,B,F1,F2,aa(B,option(B),some(B),Aa)) = aa(B,A,F2,Aa) ) ).

tff(fact_37_prod__induct6,axiom,
    ! [F3: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3))))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3))))),bool)] :
      ( ! [A2: A,B2: B,C2: C,D1: D,E1: E,F4: F3] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3))))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3)))),A2,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F3))),B2,product_Pair(C,product_prod(D,product_prod(E,F3)),C2,product_Pair(D,product_prod(E,F3),D1,product_Pair(E,F3,E1,F4)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3))))),bool,Pa,X1)) ) ).

tff(fact_38_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F3: $tType,Y2: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3)))))] :
      ~ ! [A2: A,B2: B,C2: C,D1: D,E1: E,F4: F3] : ( Y2 != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F3)))),A2,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F3))),B2,product_Pair(C,product_prod(D,product_prod(E,F3)),C2,product_Pair(D,product_prod(E,F3),D1,product_Pair(E,F3,E1,F4))))) ) ).

tff(fact_39_not__None__eq,axiom,
    ! [A: $tType,X1: option(A)] :
      ( ( X1 != none(A) )
    <=> ? [Y3: A] : ( X1 = aa(A,option(A),some(A),Y3) ) ) ).

tff(fact_40_not__Some__eq,axiom,
    ! [A: $tType,X1: option(A)] :
      ( ! [Y3: A] : ( X1 != aa(A,option(A),some(A),Y3) )
    <=> ( X1 = none(A) ) ) ).

tff(fact_41_empty__upd__none,axiom,
    ! [A: $tType,B: $tType,X1: A,X: A] : ( aa(A,option(B),fun_upd(A,option(B),combk(option(B),A,none(B)),X1,none(B)),X) = none(B) ) ).

tff(fact_42_option_Orecs_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,A),F1: A] : ( option_rec(A,B,F1,F2,none(B)) = F1 ) ).

tff(fact_43_option_Osimps_I3_J,axiom,
    ! [A: $tType,A3: A] : ( aa(A,option(A),some(A),A3) != none(A) ) ).

tff(fact_44_option_Osimps_I2_J,axiom,
    ! [A: $tType,A3: A] : ( none(A) != aa(A,option(A),some(A),A3) ) ).

tff(fact_45_map__upd__nonempty,axiom,
    ! [A: $tType,B: $tType,X1: B,K: A,T1: fun(A,option(B))] :
      ~ ! [X2: A] : ( aa(A,option(B),fun_upd(A,option(B),T1,K,aa(B,option(B),some(B),X1)),X2) = none(B) ) ).

tff(fact_46_preallocated__new,axiom,
    ! [X1: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( preallocated(Hb)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = none(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))) )
       => preallocated(fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),X1))) ) ) ).

tff(fact_47_oconf__new,axiom,
    ! [A: $tType,X1: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Aa: nat,Obj: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( oconf(A,Pa,Hb,Obj)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = none(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))) )
       => oconf(A,Pa,fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),X1)),Obj) ) ) ).

tff(fact_48_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y2: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))] :
      ~ ! [A2: A,B2: B,C2: C,D1: D,E1: E] : ( Y2 != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A2,product_Pair(B,product_prod(C,product_prod(D,E)),B2,product_Pair(C,product_prod(D,E),C2,product_Pair(D,E,D1,E1)))) ) ).

tff(fact_49_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A2: A,B2: B,C2: C,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A2,product_Pair(B,product_prod(C,product_prod(D,E)),B2,product_Pair(C,product_prod(D,E),C2,product_Pair(D,E,D1,E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,Pa,X1)) ) ).

tff(fact_50_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y2: product_prod(A,product_prod(B,product_prod(C,D)))] :
      ~ ! [A2: A,B2: B,C2: C,D1: D] : ( Y2 != product_Pair(A,product_prod(B,product_prod(C,D)),A2,product_Pair(B,product_prod(C,D),B2,product_Pair(C,D,C2,D1))) ) ).

tff(fact_51_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,product_prod(C,D))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A2: A,B2: B,C2: C,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,D)),A2,product_Pair(B,product_prod(C,D),B2,product_Pair(C,D,C2,D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,Pa,X1)) ) ).

tff(fact_52_ospec,axiom,
    ! [A: $tType,X1: A,Pa: fun(A,bool),A1: option(A)] :
      ( ! [X2: A] :
          ( member(A,X2,set(A,A1))
         => pp(aa(A,bool,Pa,X2)) )
     => ( ( A1 = aa(A,option(A),some(A),X1) )
       => pp(aa(A,bool,Pa,X1)) ) ) ).

tff(fact_53_option_Oexhaust,axiom,
    ! [A: $tType,Y2: option(A)] :
      ( ( Y2 != none(A) )
     => ~ ! [A2: A] : ( Y2 != aa(A,option(A),some(A),A2) ) ) ).

tff(fact_54_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,X1: product_prod(A,product_prod(B,C)),Pa: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A2: A,B2: B,C2: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,Pa,product_Pair(A,product_prod(B,C),A2,product_Pair(B,C,B2,C2))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,Pa,X1)) ) ).

tff(fact_55_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y2: product_prod(A,product_prod(B,C))] :
      ~ ! [A2: A,B2: B,C2: C] : ( Y2 != product_Pair(A,product_prod(B,C),A2,product_Pair(B,C,B2,C2)) ) ).

tff(fact_56_map__comp__empty_I1_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,M: fun(C,option(B)),X: A] : ( map_comp(C,B,A,M,combk(option(C),A,none(C)),X) = none(B) ) ).

tff(fact_57_map__comp__empty_I2_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,M: fun(A,option(C)),X: A] : ( map_comp(C,B,A,combk(option(B),C,none(B)),M,X) = none(B) ) ).

tff(fact_58_map__comp__simps_I2_J,axiom,
    ! [B: $tType,C: $tType,A: $tType,M1: fun(A,option(C)),K2: A,K: B,M2: fun(B,option(A))] :
      ( ( aa(B,option(A),M2,K) = aa(A,option(A),some(A),K2) )
     => ( map_comp(A,C,B,M1,M2,K) = aa(A,option(C),M1,K2) ) ) ).

tff(fact_59_map__comp__Some__iff,axiom,
    ! [C: $tType,B: $tType,A: $tType,Va: A,K: C,M2: fun(C,option(B)),M1: fun(B,option(A))] :
      ( ( map_comp(B,A,C,M1,M2,K) = aa(A,option(A),some(A),Va) )
    <=> ? [K1: B] :
          ( ( aa(C,option(B),M2,K) = aa(B,option(B),some(B),K1) )
          & ( aa(B,option(A),M1,K1) = aa(A,option(A),some(A),Va) ) ) ) ).

tff(fact_60_map__comp__simps_I1_J,axiom,
    ! [B: $tType,A: $tType,C: $tType,M1: fun(A,option(C)),K: B,M2: fun(B,option(A))] :
      ( ( aa(B,option(A),M2,K) = none(A) )
     => ( map_comp(A,C,B,M1,M2,K) = none(C) ) ) ).

tff(fact_61_map__comp__None__iff,axiom,
    ! [C: $tType,B: $tType,A: $tType,K: C,M2: fun(C,option(B)),M1: fun(B,option(A))] :
      ( ( map_comp(B,A,C,M1,M2,K) = none(A) )
    <=> ( ( aa(C,option(B),M2,K) = none(B) )
        | ? [K1: B] :
            ( ( aa(C,option(B),M2,K) = aa(B,option(B),some(B),K1) )
            & ( aa(B,option(A),M1,K1) = none(A) ) ) ) ) ).

tff(fact_62_map__comp__def,axiom,
    ! [B: $tType,C: $tType,A: $tType,G: fun(A,option(C)),F: fun(C,option(B)),X: A] : ( map_comp(C,B,A,F,G,X) = aa(option(C),option(B),option_case(option(B),C,none(B),F),aa(A,option(C),G,X)) ) ).

tff(fact_63_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y2: product_prod(A,B)] :
      ~ ! [A2: A,B2: B] : ( Y2 != product_Pair(A,B,A2,B2) ) ).

tff(fact_64_PairE,axiom,
    ! [A: $tType,B: $tType,P1: product_prod(A,B)] :
      ~ ! [X2: A,Y: B] : ( P1 != product_Pair(A,B,X2,Y) ) ).

tff(fact_65_option_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,Aa: B,F2: fun(B,A),F1: A] : ( aa(option(B),A,option_case(A,B,F1,F2),aa(B,option(B),some(B),Aa)) = aa(B,A,F2,Aa) ) ).

tff(fact_66_option_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,A),F1: A] : ( aa(option(B),A,option_case(A,B,F1,F2),none(B)) = F1 ) ).

tff(fact_67_,axiom,
    ! [A: $tType,Y1: option(A),X1: option(A)] : ( quickcheck_orelse(A,X1,Y1) = aa(option(A),option(A),option_case(option(A),A,Y1,some(A)),X1) ) ).

tff(fact_68_Option_Omap__def,axiom,
    ! [B: $tType,A: $tType,X: fun(A,B)] : ( map(A,B,X) = option_case(option(B),A,none(B),combb(B,option(B),A,some(B),X)) ) ).

tff(fact_69_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,B1: C,Aa: B,C1: fun(B,fun(C,A))] : ( produc1605651328_split(B,C,A,C1,product_Pair(B,C,Aa,B1)) = aa(C,A,aa(B,fun(C,A),C1,Aa),B1) ) ).

tff(fact_70_option__map__Some,axiom,
    ! [A: $tType,B: $tType,X1: B,F: fun(B,A)] : ( aa(option(B),option(A),map(B,A,F),aa(B,option(B),some(B),X1)) = aa(A,option(A),some(A),aa(B,A,F,X1)) ) ).

tff(fact_71_option__map__eq__Some,axiom,
    ! [B: $tType,A: $tType,Y1: A,Xo: option(B),F: fun(B,A)] :
      ( ( aa(option(B),option(A),map(B,A,F),Xo) = aa(A,option(A),some(A),Y1) )
    <=> ? [Z: B] :
          ( ( Xo = aa(B,option(B),some(B),Z) )
          & ( aa(B,A,F,Z) = Y1 ) ) ) ).

tff(fact_72_option__map__is__None,axiom,
    ! [A: $tType,B: $tType,Opt: option(B),F: fun(B,A)] :
      ( ( aa(option(B),option(A),map(B,A,F),Opt) = none(A) )
    <=> ( Opt = none(B) ) ) ).

tff(fact_73_option__map__None,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( aa(option(B),option(A),map(B,A,F),none(B)) = none(A) ) ).

tff(fact_74_option__caseE,axiom,
    ! [A: $tType,X1: option(A),Q1: fun(A,bool),Pa: bool] :
      ( pp(aa(option(A),bool,option_case(bool,A,Pa,Q1),X1))
     => ( ( ( X1 = none(A) )
         => ~ pp(Pa) )
       => ~ ! [Y: A] :
              ( ( X1 = aa(A,option(A),some(A),Y) )
             => ~ pp(aa(A,bool,Q1,Y)) ) ) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X1: A] :
      ( member(A,X1,A1)
    <=> pp(aa(A,bool,A1,X1)) ) ).

tff(fact_77_curry__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,B1: C,Aa: B,F: fun(product_prod(B,C),A)] : ( product_curry(B,C,A,F,Aa,B1) = aa(product_prod(B,C),A,F,product_Pair(B,C,Aa,B1)) ) ).

tff(fact_78_conf__upd__obj,axiom,
    ! [A: $tType,Ta: ty,X1: val,Fs: fun(product_prod(list(char),list(char)),option(val)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A)))))))),Fsa: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fsa)) )
     => ( conf(A,Pa,fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs))),X1,Ta)
      <=> conf(A,Pa,Hb,X1,Ta) ) ) ).

tff(fact_79_curryI,axiom,
    ! [A: $tType,B: $tType,B1: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,B1)))
     => pp(product_curry(A,B,bool,F,Aa,B1)) ) ).

tff(fact_80_curryD,axiom,
    ! [A: $tType,B: $tType,B1: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,B1))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,B1))) ) ).

tff(fact_81_curryE,axiom,
    ! [A: $tType,B: $tType,B1: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,B1))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,Aa,B1))) ) ).

tff(fact_82_curry__def,axiom,
    ! [C: $tType,A: $tType,B: $tType,X: fun(product_prod(A,B),C),Xa: A,Xb: B] : ( product_curry(A,B,C,X,Xa,Xb) = aa(product_prod(A,B),C,X,product_Pair(A,B,Xa,Xb)) ) ).

tff(fact_83_oconf__fupd,axiom,
    ! [A: $tType,Fsa: fun(product_prod(list(char),list(char)),option(val)),Va: val,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Da: list(char),Ta: ty,Fa: list(char),Ca: list(char),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( has_field(A,Pa,Ca,Fa,Ta,Da)
     => ( conf(A,Pa,Hb,Va,Ta)
       => ( oconf(A,Pa,Hb,product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fsa))
         => oconf(A,Pa,Hb,product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,fun_upd(product_prod(list(char),list(char)),option(val),Fsa,product_Pair(list(char),list(char),Fa,Da),aa(val,option(val),some(val),Va)))) ) ) ) ).

tff(fact_84_disjE__realizer2,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: B,R1: fun(B,bool),X1: option(A),Q1: fun(A,bool),Pa: bool] :
      ( pp(aa(option(A),bool,option_case(bool,A,Pa,Q1),X1))
     => ( ( pp(Pa)
         => pp(aa(B,bool,R1,F)) )
       => ( ! [Q2: A] :
              ( pp(aa(A,bool,Q1,Q2))
             => pp(aa(B,bool,R1,aa(A,B,G,Q2))) )
         => pp(aa(B,bool,R1,aa(option(A),B,option_case(B,A,F,G),X1))) ) ) ) ).

tff(fact_85_red__reds_ORedFAss,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),Lb: fun(list(char),option(val)),Va: val,Da: list(char),Fa: list(char),Fsa: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fsa)) )
     => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),fAss(list(char),val1(list(char),addr(Aa)),Fa,Da,val1(list(char),Va)),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,Lb)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),val1(list(char),unit),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,fun_upd(product_prod(list(char),list(char)),option(val),Fsa,product_Pair(list(char),list(char),Fa,Da),aa(val,option(val),some(val),Va))))),Lb))),red(Pa)) ) ).

tff(fact_86_lconf__upd2,axiom,
    ! [A: $tType,V2: list(char),Ta: ty,Va: val,Ea1: fun(list(char),option(ty)),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( lconf(A,Pa,Hb,Lb,Ea1)
     => ( conf(A,Pa,Hb,Va,Ta)
       => lconf(A,Pa,Hb,fun_upd(list(char),option(val),Lb,V2,aa(val,option(val),some(val),Va)),fun_upd(list(char),option(ty),Ea1,V2,aa(ty,option(ty),some(ty),Ta))) ) ) ).

tff(fact_87_lconf__empty,axiom,
    ! [A: $tType,Ea1: fun(list(char),option(ty)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] : lconf(A,Pa,Hb,combk(option(val),list(char),none(val)),Ea1) ).

tff(fact_88_red__reds_OFAssRed2,axiom,
    ! [Da: list(char),Fa: list(char),Va: val,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_a: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea,S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_a,S1)),red(Pa))
     => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),fAss(list(char),val1(list(char),Va),Fa,Da,Ea),S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),fAss(list(char),val1(list(char),Va),Fa,Da,E_a),S1)),red(Pa)) ) ).

tff(fact_89_red__reds_OFAssRed1,axiom,
    ! [E_2: exp(list(char)),Da: list(char),Fa: list(char),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_a: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea,S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_a,S1)),red(Pa))
     => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),fAss(list(char),Ea,Fa,Da,E_2),S),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),fAss(list(char),E_a,Fa,Da,E_2),S1)),red(Pa)) ) ).

tff(fact_90_val_Osimps_I11_J,axiom,
    ! [Nat: nat] : ( addr(Nat) != unit ) ).

tff(fact_91_val_Osimps_I10_J,axiom,
    ! [Nat: nat] : ( unit != addr(Nat) ) ).

tff(fact_92_lconf__upd,axiom,
    ! [A: $tType,V2: list(char),Ta: ty,Va: val,Ea1: fun(list(char),option(ty)),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( lconf(A,Pa,Hb,Lb,Ea1)
     => ( conf(A,Pa,Hb,Va,Ta)
       => ( ( aa(list(char),option(ty),Ea1,V2) = aa(ty,option(ty),some(ty),Ta) )
         => lconf(A,Pa,Hb,fun_upd(list(char),option(val),Lb,V2,aa(val,option(val),some(val),Va)),Ea1) ) ) ) ).

tff(fact_93_lconf__def,axiom,
    ! [A: $tType,Ea1: fun(list(char),option(ty)),Lb: fun(list(char),option(val)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( lconf(A,Pa,Hb,Lb,Ea1)
    <=> ! [V1: list(char),V: val] :
          ( ( aa(list(char),option(val),Lb,V1) = aa(val,option(val),some(val),V) )
         => ? [T: ty] :
              ( ( aa(list(char),option(ty),Ea1,V1) = aa(ty,option(ty),some(ty),T) )
              & conf(A,Pa,Hb,V,T) ) ) ) ).

tff(fact_94_redp__redsp_ORedFAss,axiom,
    ! [Lb: fun(list(char),option(val)),Va: val,Da: list(char),Fa: list(char),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),Fsa: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fsa)) )
     => redp(Pa,fAss(list(char),val1(list(char),addr(Aa)),Fa,Da,val1(list(char),Va)),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Hb,Lb),val1(list(char),unit),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,fun_upd(product_prod(list(char),list(char)),option(val),Fsa,product_Pair(list(char),list(char),Fa,Da),aa(val,option(val),some(val),Va))))),Lb)) ) ).

tff(fact_95_redp__redsp_OFAssRed1,axiom,
    ! [E_2: exp(list(char)),Da: list(char),Fa: list(char),S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_a: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( redp(Pa,Ea,S,E_a,S1)
     => redp(Pa,fAss(list(char),Ea,Fa,Da,E_2),S,fAss(list(char),E_a,Fa,Da,E_2),S1) ) ).

tff(fact_96_redp__redsp_OFAssRed2,axiom,
    ! [Da: list(char),Fa: list(char),Va: val,S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_a: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( redp(Pa,Ea,S,E_a,S1)
     => redp(Pa,fAss(list(char),val1(list(char),Va),Fa,Da,Ea),S,fAss(list(char),val1(list(char),Va),Fa,Da,E_a),S1) ) ).

tff(fact_97_redp__red__eq,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),X: exp(list(char)),Xa: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Xb: exp(list(char)),Xc: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))] :
      ( redp(Pa,X,Xa,Xb,Xc)
    <=> member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),X,Xa),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Xb,Xc)),red(Pa)) ) ).

tff(fact_98_FAssRedsVal,axiom,
    ! [Da: list(char),Fa: list(char),Fsa: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),L_2: fun(list(char),option(val)),H_2: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Va: val,E_2: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),S_1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Aa: nat,S_0: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_1: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_1,S_0),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),val1(list(char),addr(Aa)),S_1)),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa)))
     => ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_2,S_1),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),val1(list(char),Va),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_2,L_2))),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa)))
       => ( ( aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fsa)) = aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),H_2,Aa) )
         => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),fAss(list(char),E_1,Fa,Da,E_2),S_0),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),val1(list(char),unit),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),H_2,Aa,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,fun_upd(product_prod(list(char),list(char)),option(val),Fsa,product_Pair(list(char),list(char),Fa,Da),aa(val,option(val),some(val),Va))))),L_2))),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa))) ) ) ) ).

tff(fact_99_FAss,axiom,
    ! [H_21: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Da: list(char),Fa: list(char),Fs: fun(product_prod(list(char),list(char)),option(val)),Fsa: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),L_2: fun(list(char),option(val)),H_2: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Va: val,E_2: exp(list(char)),S_1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Aa: nat,S_0: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E_1: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( eval(Pa,E_1,S_0,val1(list(char),addr(Aa)),S_1)
     => ( eval(Pa,E_2,S_1,val1(list(char),Va),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_2,L_2))
       => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),H_2,Aa) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fsa)) )
         => ( ( Fs = fun_upd(product_prod(list(char),list(char)),option(val),Fsa,product_Pair(list(char),list(char),Fa,Da),aa(val,option(val),some(val),Va)) )
           => ( ( H_21 = fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),H_2,Aa,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs))) )
             => eval(Pa,fAss(list(char),E_1,Fa,Da,E_2),S_0,val1(list(char),unit),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H_21,L_2)) ) ) ) ) ) ).

%----Helper facts (4)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    hconf(product_prod(list(list(char)),exp(list(char))),p,ha) ).

%------------------------------------------------------------------------------
