%------------------------------------------------------------------------------
% File     : SWW551_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Java type soundness line 26
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : jinja_26 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v6.4.0
% Syntax   : Number of formulae    :  174 (  47 unt;  57 typ;   0 def)
%            Number of atoms       :  243 ( 137 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  165 (  39   ~;  16   |;  13   &)
%                                         (  22 <=>;  75  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   6 avg)
%            Maximal term depth    :    8 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   61 (  34   >;  27   *;   0   +;   0  <<)
%            Number of predicates  :    9 (   8 usr;   0 prp; 1-5 aty)
%            Number of functors    :   44 (  44 usr;  13 con; 0-6 aty)
%            Number of variables   :  515 ( 457   !;  11   ?; 515   :)
%                                         (  47  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:48
%------------------------------------------------------------------------------
%----Should-be-implicit typings (10)
tff(ty_tc_Expr_Oexp,type,
    exp: $tType > $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Option_Ooption,type,
    option: $tType > $tType ).

tff(ty_tc_String_Ochar,type,
    char: $tType ).

tff(ty_tc_Type_Oty,type,
    ty: $tType ).

tff(ty_tc_Value_Oval,type,
    val: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (47)
tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Conform_Ohconf,type,
    hconf: 
      !>[M3: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M3)))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ) > $o ) ).

tff(sy_c_Conform_Ooconf,type,
    oconf: 
      !>[M3: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M3)))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))) ) > $o ) ).

tff(sy_c_Exceptions_Opreallocated,type,
    preallocated: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) > $o ).

tff(sy_c_Exceptions_Ostart__heap,type,
    start_heap: 
      !>[C: $tType] : ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,C)))))))) > fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ) ).

tff(sy_c_Expr_Oexp_Onew,type,
    new: 
      !>[A: $tType] : ( list(char) > exp(A) ) ).

tff(sy_c_Fun_Ofun__upd,type,
    fun_upd: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A * B ) > fun(A,B) ) ).

tff(sy_c_Map_Omap__comp,type,
    map_comp: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,option(C)) * fun(A,option(B)) * A ) > option(C) ) ).

tff(sy_c_Map_Oran,type,
    ran: 
      !>[A: $tType,B: $tType] : ( fun(A,option(B)) > fun(B,bool) ) ).

tff(sy_c_Objects_Ohext,type,
    hext: ( fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ) > $o ).

tff(sy_c_Objects_Oinit__fields,type,
    init_fields: list(product_prod(product_prod(list(char),list(char)),ty)) > fun(product_prod(list(char),list(char)),option(val)) ).

tff(sy_c_Objects_Onew__Addr,type,
    new_Addr: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) > option(nat) ).

tff(sy_c_Option_Obind,type,
    bind: 
      !>[A: $tType,B: $tType] : fun(option(A),fun(fun(A,option(B)),option(B))) ).

tff(sy_c_Option_Ois__none,type,
    is_none: 
      !>[A: $tType] : ( option(A) > $o ) ).

tff(sy_c_Option_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( fun(A,B) > fun(option(A),option(B)) ) ).

tff(sy_c_Option_Ooption_ONone,type,
    none: 
      !>[A: $tType] : option(A) ).

tff(sy_c_Option_Ooption_OSome,type,
    some: 
      !>[A: $tType] : fun(A,option(A)) ).

tff(sy_c_Option_Ooption_Ooption__case,type,
    option_case: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,T1) ) > fun(option(A),T1) ) ).

tff(sy_c_Option_Ooption_Ooption__rec,type,
    option_rec: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,T1) * option(A) ) > T1 ) ).

tff(sy_c_Option_Oset,type,
    set: 
      !>[A: $tType] : ( option(A) > fun(A,bool) ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T1: $tType] : ( ( fun(A,fun(B,T1)) * product_prod(A,B) ) > T1 ) ).

tff(sy_c_Quickcheck__Exhaustive_Oorelse,type,
    quickcheck_orelse: 
      !>[A: $tType] : ( ( option(A) * option(A) ) > option(A) ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_TypeRel_OFields,type,
    fields: 
      !>[M3: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M3)))))))) * list(char) * list(product_prod(product_prod(list(char),list(char)),ty)) ) > $o ) ).

tff(sy_c_WellTypeRT_OWTrt,type,
    wTrt: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * fun(list(char),option(ty)) * exp(list(char)) * ty ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_C____,type,
    c: list(char) ).

tff(sy_v_E____,type,
    e: fun(list(char),option(ty)) ).

tff(sy_v_FDTs____,type,
    fDTs: list(product_prod(product_prod(list(char),list(char)),ty)) ).

tff(sy_v_P,type,
    p: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) ).

tff(sy_v_T____,type,
    t: ty ).

tff(sy_v_a____,type,
    a: nat ).

tff(sy_v_h_Ha____,type,
    h_a: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ).

tff(sy_v_ha____,type,
    ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ).

%----Relevant facts (100)
tff(fact_0_RedNew_I1_J,axiom,
    new_Addr(ha) = aa(nat,option(nat),some(nat),a) ).

tff(fact_1_option_Oinject,axiom,
    ! [A: $tType,A6: A,Aa: A] :
      ( ( aa(A,option(A),some(A),Aa) = aa(A,option(A),some(A),A6) )
    <=> ( Aa = A6 ) ) ).

tff(fact_2_new__Addr__SomeD,axiom,
    ! [Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( ( new_Addr(Hb) = aa(nat,option(nat),some(nat),Aa) )
     => ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = none(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))) ) ) ).

tff(fact_3_elem__set,axiom,
    ! [A: $tType,Xo: option(A),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xo)))
    <=> ( Xo = aa(A,option(A),some(A),X2) ) ) ).

tff(fact_4_option_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,Aa: B,F2: fun(B,A),F1: A] : ( option_rec(A,B,F1,F2,aa(B,option(B),some(B),Aa)) = aa(B,A,F2,Aa) ) ).

tff(fact_5_is__none__code_I2_J,axiom,
    ! [B: $tType,X: B] : ~ is_none(B,aa(B,option(B),some(B),X)) ).

tff(fact_6_RedNew_I3_J,axiom,
    h_a = fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),ha,a,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),c,init_fields(fDTs)))) ).

tff(fact_7_option_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,Aa: B,F2: fun(B,A),F1: A] : ( aa(option(B),A,option_case(A,B,F1,F2),aa(B,option(B),some(B),Aa)) = aa(B,A,F2,Aa) ) ).

tff(fact_8_bind__lunit,axiom,
    ! [A: $tType,B: $tType,F: fun(B,option(A)),X2: B] : ( aa(fun(B,option(A)),option(A),aa(option(B),fun(fun(B,option(A)),option(A)),bind(B,A),aa(B,option(B),some(B),X2)),F) = aa(B,option(A),F,X2) ) ).

tff(fact_9_RedNew_I5_J,axiom,
    hconf(product_prod(list(list(char)),exp(list(char))),p,ha) ).

tff(fact_10_map__comp__Some__iff,axiom,
    ! [C: $tType,B: $tType,A: $tType,V: A,K: C,M2: fun(C,option(B)),M1: fun(B,option(A))] :
      ( ( map_comp(B,A,C,M1,M2,K) = aa(A,option(A),some(A),V) )
    <=> ? [K1: B] :
          ( ( aa(C,option(B),M2,K) = aa(B,option(B),some(B),K1) )
          & ( aa(B,option(A),M1,K1) = aa(A,option(A),some(A),V) ) ) ) ).

tff(fact_11_ranI,axiom,
    ! [A: $tType,B: $tType,B2: A,Aa: B,M: fun(B,option(A))] :
      ( ( aa(B,option(A),M,Aa) = aa(A,option(A),some(A),B2) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),ran(B,A,M))) ) ).

tff(fact_12_map__comp__simps_I2_J,axiom,
    ! [B: $tType,C: $tType,A: $tType,M1: fun(A,option(C)),K2: A,K: B,M2: fun(B,option(A))] :
      ( ( aa(B,option(A),M2,K) = aa(A,option(A),some(A),K2) )
     => ( map_comp(A,C,B,M1,M2,K) = aa(A,option(C),M1,K2) ) ) ).

tff(fact_13_bind__assoc,axiom,
    ! [C: $tType,A: $tType,B: $tType,G: fun(B,option(A)),F: fun(C,option(B)),X2: option(C)] : ( aa(fun(B,option(A)),option(A),aa(option(B),fun(fun(B,option(A)),option(A)),bind(B,A),aa(fun(C,option(B)),option(B),aa(option(C),fun(fun(C,option(B)),option(B)),bind(C,B),X2),F)),G) = aa(fun(C,option(A)),option(A),aa(option(C),fun(fun(C,option(A)),option(A)),bind(C,A),X2),combc(C,fun(B,option(A)),option(A),combb(option(B),fun(fun(B,option(A)),option(A)),C,bind(B,A),F),G)) ) ).

tff(fact_14_not__None__eq,axiom,
    ! [A: $tType,X2: option(A)] :
      ( ( X2 != none(A) )
    <=> ? [Y3: A] : ( X2 = aa(A,option(A),some(A),Y3) ) ) ).

tff(fact_15_not__Some__eq,axiom,
    ! [A: $tType,X2: option(A)] :
      ( ! [Y3: A] : ( X2 != aa(A,option(A),some(A),Y3) )
    <=> ( X2 = none(A) ) ) ).

tff(fact_16_bind__lzero,axiom,
    ! [B: $tType,A: $tType,F: fun(B,option(A))] : ( aa(fun(B,option(A)),option(A),aa(option(B),fun(fun(B,option(A)),option(A)),bind(B,A),none(B)),F) = none(A) ) ).

tff(fact_17_empty__upd__none,axiom,
    ! [A: $tType,B: $tType,X2: A,X1: A] : ( aa(A,option(B),fun_upd(A,option(B),combk(option(B),A,none(B)),X2,none(B)),X1) = none(B) ) ).

tff(fact_18_bind__rzero,axiom,
    ! [B: $tType,A: $tType,X2: option(B)] : ( aa(fun(B,option(A)),option(A),aa(option(B),fun(fun(B,option(A)),option(A)),bind(B,A),X2),combk(option(A),B,none(A))) = none(A) ) ).

tff(fact_19_map__comp__empty_I1_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,M: fun(C,option(B)),X1: A] : ( map_comp(C,B,A,M,combk(option(C),A,none(C)),X1) = none(B) ) ).

tff(fact_20_map__comp__empty_I2_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,M: fun(A,option(C)),X1: A] : ( map_comp(C,B,A,combk(option(B),C,none(B)),M,X1) = none(B) ) ).

tff(fact_21_RedNew_I2_J,axiom,
    fields(product_prod(list(list(char)),exp(list(char))),p,c,fDTs) ).

tff(fact_22_map__upd__nonempty,axiom,
    ! [A: $tType,B: $tType,X2: B,K: A,T: fun(A,option(B))] :
      ~ ! [X3: A] : ( aa(A,option(B),fun_upd(A,option(B),T,K,aa(B,option(B),some(B),X2)),X3) = none(B) ) ).

tff(fact_23_is__none__code_I1_J,axiom,
    ! [A: $tType] : is_none(A,none(A)) ).

tff(fact_24_is__none__def,axiom,
    ! [A: $tType,X2: option(A)] :
      ( is_none(A,X2)
    <=> ( X2 = none(A) ) ) ).

tff(fact_25_map__comp__def,axiom,
    ! [B: $tType,C: $tType,A: $tType,G: fun(A,option(C)),F: fun(C,option(B)),X1: A] : ( map_comp(C,B,A,F,G,X1) = aa(option(C),option(B),option_case(option(B),C,none(B),F),aa(A,option(C),G,X1)) ) ).

tff(fact_26_map__comp__None__iff,axiom,
    ! [C: $tType,B: $tType,A: $tType,K: C,M2: fun(C,option(B)),M1: fun(B,option(A))] :
      ( ( map_comp(B,A,C,M1,M2,K) = none(A) )
    <=> ( ( aa(C,option(B),M2,K) = none(B) )
        | ? [K1: B] :
            ( ( aa(C,option(B),M2,K) = aa(B,option(B),some(B),K1) )
            & ( aa(B,option(A),M1,K1) = none(A) ) ) ) ) ).

tff(fact_27_option_Orecs_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,A),F1: A] : ( option_rec(A,B,F1,F2,none(B)) = F1 ) ).

tff(fact_28_option_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,A),F1: A] : ( aa(option(B),A,option_case(A,B,F1,F2),none(B)) = F1 ) ).

tff(fact_29_map__comp__simps_I1_J,axiom,
    ! [B: $tType,A: $tType,C: $tType,M1: fun(A,option(C)),K: B,M2: fun(B,option(A))] :
      ( ( aa(B,option(A),M2,K) = none(A) )
     => ( map_comp(A,C,B,M1,M2,K) = none(C) ) ) ).

tff(fact_30_map__upd__eqD1,axiom,
    ! [A: $tType,B: $tType,Y1: B,N: fun(A,option(B)),X2: B,Aa: A,M: fun(A,option(B))] :
      ( ( fun_upd(A,option(B),M,Aa,aa(B,option(B),some(B),X2)) = fun_upd(A,option(B),N,Aa,aa(B,option(B),some(B),Y1)) )
     => ( X2 = Y1 ) ) ).

tff(fact_31_map__upd__triv,axiom,
    ! [A: $tType,B: $tType,X2: A,K: B,T: fun(B,option(A))] :
      ( ( aa(B,option(A),T,K) = aa(A,option(A),some(A),X2) )
     => ( fun_upd(B,option(A),T,K,aa(A,option(A),some(A),X2)) = T ) ) ).

tff(fact_32_map__upd__Some__unfold,axiom,
    ! [B: $tType,A: $tType,Y1: A,X2: B,B2: A,Aa: B,M: fun(B,option(A))] :
      ( ( aa(B,option(A),fun_upd(B,option(A),M,Aa,aa(A,option(A),some(A),B2)),X2) = aa(A,option(A),some(A),Y1) )
    <=> ( ( ( X2 = Aa )
          & ( B2 = Y1 ) )
        | ( ( X2 != Aa )
          & ( aa(B,option(A),M,X2) = aa(A,option(A),some(A),Y1) ) ) ) ) ).

tff(fact_33_option_Osimps_I3_J,axiom,
    ! [A: $tType,A5: A] : ( aa(A,option(A),some(A),A5) != none(A) ) ).

tff(fact_34_option_Osimps_I2_J,axiom,
    ! [A: $tType,A5: A] : ( none(A) != aa(A,option(A),some(A),A5) ) ).

tff(fact_35_bind__runit,axiom,
    ! [A: $tType,X2: option(A)] : ( aa(fun(A,option(A)),option(A),aa(option(A),fun(fun(A,option(A)),option(A)),bind(A,A),X2),some(A)) = X2 ) ).

tff(fact_36_ospec,axiom,
    ! [A: $tType,X2: A,Pa: fun(A,bool),A1: option(A)] :
      ( ! [X3: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,A1)))
         => pp(aa(A,bool,Pa,X3)) )
     => ( ( A1 = aa(A,option(A),some(A),X2) )
       => pp(aa(A,bool,Pa,X2)) ) ) ).

tff(fact_37_option__caseE,axiom,
    ! [A: $tType,X2: option(A),Q1: fun(A,bool),Pa: bool] :
      ( pp(aa(option(A),bool,option_case(bool,A,Pa,Q1),X2))
     => ( ( ( X2 = none(A) )
         => ~ pp(Pa) )
       => ~ ! [Y2: A] :
              ( ( X2 = aa(A,option(A),some(A),Y2) )
             => ~ pp(aa(A,bool,Q1,Y2)) ) ) ) ).

tff(fact_38_fun__upd__triv,axiom,
    ! [B: $tType,A: $tType,X2: A,F: fun(A,B)] : ( fun_upd(A,B,F,X2,aa(A,B,F,X2)) = F ) ).

tff(fact_39_fun__upd__upd,axiom,
    ! [A: $tType,B: $tType,Z1: B,Y1: B,X2: A,F: fun(A,B)] : ( fun_upd(A,B,fun_upd(A,B,F,X2,Y1),X2,Z1) = fun_upd(A,B,F,X2,Z1) ) ).

tff(fact_40_fun__upd__apply,axiom,
    ! [B: $tType,A: $tType,Y1: B,F: fun(A,B),X2: A,Z1: A] :
      ( ( ( Z1 = X2 )
       => ( aa(A,B,fun_upd(A,B,F,X2,Y1),Z1) = Y1 ) )
      & ( ( Z1 != X2 )
       => ( aa(A,B,fun_upd(A,B,F,X2,Y1),Z1) = aa(A,B,F,Z1) ) ) ) ).

tff(fact_41_option_Oexhaust,axiom,
    ! [A: $tType,Y: option(A)] :
      ( ( Y != none(A) )
     => ~ ! [A2: A] : ( Y != aa(A,option(A),some(A),A2) ) ) ).

tff(fact_42_split__paired__All,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ! [A3: A,B3: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A3,B3))) ) ).

tff(fact_43_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B6: B,A6: A,B2: B,Aa: A] :
      ( ( product_Pair(A,B,Aa,B2) = product_Pair(A,B,A6,B6) )
    <=> ( ( Aa = A6 )
        & ( B2 = B6 ) ) ) ).

tff(fact_44_RedNew_I4_J,axiom,
    wTrt(p,ha,e,new(list(char),c),t) ).

tff(fact_45_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B5: B,A5: A,B4: B,A4: A] :
      ( ( product_Pair(A,B,A4,B4) = product_Pair(A,B,A5,B5) )
     => ~ ( ( A4 = A5 )
         => ( B4 != B5 ) ) ) ).

tff(fact_46_fun__upd__def,axiom,
    ! [B: $tType,A: $tType,B2: B,F: fun(A,B),Aa: A,X1: A] :
      ( ( ( X1 = Aa )
       => ( aa(A,B,fun_upd(A,B,F,Aa,B2),X1) = B2 ) )
      & ( ( X1 != Aa )
       => ( aa(A,B,fun_upd(A,B,F,Aa,B2),X1) = aa(A,B,F,X1) ) ) ) ).

tff(fact_47_fun__upd__idem,axiom,
    ! [A: $tType,B: $tType,Y1: A,X2: B,F: fun(B,A)] :
      ( ( aa(B,A,F,X2) = Y1 )
     => ( fun_upd(B,A,F,X2,Y1) = F ) ) ).

tff(fact_48_fun__upd__other,axiom,
    ! [B: $tType,A: $tType,Y1: B,F: fun(A,B),X2: A,Z1: A] :
      ( ( Z1 != X2 )
     => ( aa(A,B,fun_upd(A,B,F,X2,Y1),Z1) = aa(A,B,F,Z1) ) ) ).

tff(fact_49_fun__upd__twist,axiom,
    ! [A: $tType,B: $tType,D: B,B2: B,M: fun(A,B),C3: A,Aa: A] :
      ( ( Aa != C3 )
     => ( fun_upd(A,B,fun_upd(A,B,M,Aa,B2),C3,D) = fun_upd(A,B,fun_upd(A,B,M,C3,D),Aa,B2) ) ) ).

tff(fact_50_fun__upd__same,axiom,
    ! [B: $tType,A: $tType,Y1: A,X2: B,F: fun(B,A)] : ( aa(B,A,fun_upd(B,A,F,X2,Y1),X2) = Y1 ) ).

tff(fact_51_fun__upd__idem__iff,axiom,
    ! [A: $tType,B: $tType,Y1: B,X2: A,F: fun(A,B)] :
      ( ( fun_upd(A,B,F,X2,Y1) = F )
    <=> ( aa(A,B,F,X2) = Y1 ) ) ).

tff(fact_52_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ? [A3: A,B3: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A3,B3))) ) ).

tff(fact_53_exp_Osimps_I1_J,axiom,
    ! [A: $tType,List1: list(char),List: list(char)] :
      ( ( new(A,List) = new(A,List1) )
    <=> ( List = List1 ) ) ).

tff(fact_54_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,B2: C,Aa: B,F1: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F1,product_Pair(B,C,Aa,B2)) = aa(C,A,aa(B,fun(C,A),F1,Aa),B2) ) ).

tff(fact_55_,axiom,
    ! [A: $tType,Y1: option(A),X2: option(A)] : ( quickcheck_orelse(A,X2,Y1) = aa(option(A),option(A),option_case(option(A),A,Y1,some(A)),X2) ) ).

tff(fact_56_disjE__realizer2,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: B,R1: fun(B,bool),X2: option(A),Q1: fun(A,bool),Pa: bool] :
      ( pp(aa(option(A),bool,option_case(bool,A,Pa,Q1),X2))
     => ( ( pp(Pa)
         => pp(aa(B,bool,R1,F)) )
       => ( ! [Q2: A] :
              ( pp(aa(A,bool,Q1,Q2))
             => pp(aa(B,bool,R1,aa(A,B,G,Q2))) )
         => pp(aa(B,bool,R1,aa(option(A),B,option_case(B,A,F,G),X2))) ) ) ) ).

tff(fact_57_hconf__new,axiom,
    ! [A: $tType,Obj: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( hconf(A,Pa,Hb)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = none(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))) )
       => ( oconf(A,Pa,Hb,Obj)
         => hconf(A,Pa,fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Obj))) ) ) ) ).

tff(fact_58_hconf__upd__obj,axiom,
    ! [A: $tType,Fs6: fun(product_prod(list(char),list(char)),option(val)),Fs4: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( hconf(A,Pa,Hb)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs4)) )
       => ( oconf(A,Pa,Hb,product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs6))
         => hconf(A,Pa,fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs6)))) ) ) ) ).

tff(fact_59_hconfD,axiom,
    ! [A: $tType,Obj: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( hconf(A,Pa,Hb)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Obj) )
       => oconf(A,Pa,Hb,Obj) ) ) ).

tff(fact_60_oconf__upd__obj,axiom,
    ! [A: $tType,Fs6: fun(product_prod(list(char),list(char)),option(val)),Fs4: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,Obj: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( oconf(A,Pa,Hb,Obj)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs4)) )
       => oconf(A,Pa,fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs6))),Obj) ) ) ).

tff(fact_61_oconf__new,axiom,
    ! [A: $tType,X2: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Aa: nat,Obj: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( oconf(A,Pa,Hb,Obj)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = none(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))) )
       => oconf(A,Pa,fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),X2)),Obj) ) ) ).

tff(fact_62_oconf__init__fields,axiom,
    ! [A: $tType,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),FDTsa: list(product_prod(product_prod(list(char),list(char)),ty)),Ca: list(char),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( fields(A,Pa,Ca,FDTsa)
     => oconf(A,Pa,Hb,product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,init_fields(FDTsa))) ) ).

tff(fact_63_hconf__def,axiom,
    ! [A: $tType,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( hconf(A,Pa,Hb)
    <=> ( ! [A3: nat,Obj1: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))] :
            ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,A3) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Obj1) )
           => oconf(A,Pa,Hb,Obj1) )
        & preallocated(Hb) ) ) ).

tff(fact_64_hext__new,axiom,
    ! [X2: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = none(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))) )
     => hext(Hb,fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),X2))) ) ).

tff(fact_65_hext__upd__obj,axiom,
    ! [Fs6: fun(product_prod(list(char),list(char)),option(val)),Fs4: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs4)) )
     => hext(Hb,fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs6)))) ) ).

tff(fact_66_hext__refl,axiom,
    ! [Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] : hext(Hb,Hb) ).

tff(fact_67_hext__trans,axiom,
    ! [H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),H_b: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( hext(Hb,H_b)
     => ( hext(H_b,H)
       => hext(Hb,H) ) ) ).

tff(fact_68_oconf__hext,axiom,
    ! [A: $tType,H_b: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Obj: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( oconf(A,Pa,Hb,Obj)
     => ( hext(Hb,H_b)
       => oconf(A,Pa,H_b,Obj) ) ) ).

tff(fact_69_preallocated__new,axiom,
    ! [X2: product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( preallocated(Hb)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = none(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))) )
       => preallocated(fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),X2))) ) ) ).

tff(fact_70_preallocated__upd__obj,axiom,
    ! [Fs6: fun(product_prod(list(char),list(char)),option(val)),Fs4: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( preallocated(Hb)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs4)) )
       => preallocated(fun_upd(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa,aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs6)))) ) ) ).

tff(fact_71_hext__objD,axiom,
    ! [Fs4: fun(product_prod(list(char),list(char)),option(val)),Ca: list(char),Aa: nat,H_b: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( hext(Hb,H_b)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,Aa) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs4)) )
       => ? [Fs5: fun(product_prod(list(char),list(char)),option(val))] : ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),H_b,Aa) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),Ca,Fs5)) ) ) ) ).

tff(fact_72_preallocated__hext,axiom,
    ! [H_b: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( preallocated(Hb)
     => ( hext(Hb,H_b)
       => preallocated(H_b) ) ) ).

tff(fact_73_hext__def,axiom,
    ! [H_b: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( hext(Hb,H_b)
    <=> ! [A3: nat,C1: list(char),Fs2: fun(product_prod(list(char),list(char)),option(val))] :
          ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,A3) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C1,Fs2)) )
         => ? [Fs3: fun(product_prod(list(char),list(char)),option(val))] : ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),H_b,A3) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C1,Fs3)) ) ) ) ).

tff(fact_74_WTrt__hext__mono,axiom,
    ! [H_b: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ta: ty,Ea1: exp(list(char)),Ea: fun(list(char),option(ty)),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wTrt(Pa,Hb,Ea,Ea1,Ta)
     => ( hext(Hb,H_b)
       => wTrt(Pa,H_b,Ea,Ea1,Ta) ) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F,X3) = aa(A,B,G,X3) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
    <=> pp(aa(A,bool,A1,X2)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,Pa: fun(A,bool)] : ( collect(A,Pa) = Pa ) ).

tff(fact_78_hextI,axiom,
    ! [H_b: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Hb: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( ! [A2: nat,C2: list(char),Fs: fun(product_prod(list(char),list(char)),option(val))] :
          ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Hb,A2) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C2,Fs)) )
         => ? [Fs1: fun(product_prod(list(char),list(char)),option(val))] : ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),H_b,A2) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C2,Fs1)) ) )
     => hext(Hb,H_b) ) ).

tff(fact_79_preallocated__start,axiom,
    ! [A: $tType,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] : preallocated(start_heap(A,Pa)) ).

tff(fact_80_Option_Omap__def,axiom,
    ! [B: $tType,A: $tType,X1: fun(A,B)] : ( map(A,B,X1) = option_case(option(B),A,none(B),combb(B,option(B),A,some(B),X1)) ) ).

tff(fact_81_ran__map__upd,axiom,
    ! [A: $tType,B: $tType,B2: A,Aa: B,M: fun(B,option(A))] :
      ( ( aa(B,option(A),M,Aa) = none(A) )
     => ( ran(B,A,fun_upd(B,option(A),M,Aa,aa(A,option(A),some(A),B2))) = insert(A,B2,ran(B,A,M)) ) ) ).

tff(fact_82_option__map__Some,axiom,
    ! [A: $tType,B: $tType,X2: B,F: fun(B,A)] : ( aa(option(B),option(A),map(B,A,F),aa(B,option(B),some(B),X2)) = aa(A,option(A),some(A),aa(B,A,F,X2)) ) ).

tff(fact_83_option__map__eq__Some,axiom,
    ! [B: $tType,A: $tType,Y1: A,Xo: option(B),F: fun(B,A)] :
      ( ( aa(option(B),option(A),map(B,A,F),Xo) = aa(A,option(A),some(A),Y1) )
    <=> ? [Z: B] :
          ( ( Xo = aa(B,option(B),some(B),Z) )
          & ( aa(B,A,F,Z) = Y1 ) ) ) ).

tff(fact_84_option__map__is__None,axiom,
    ! [A: $tType,B: $tType,Opt: option(B),F: fun(B,A)] :
      ( ( aa(option(B),option(A),map(B,A,F),Opt) = none(A) )
    <=> ( Opt = none(B) ) ) ).

tff(fact_85_option__map__None,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( aa(option(B),option(A),map(B,A,F),none(B)) = none(A) ) ).

tff(fact_86_insert__absorb2,axiom,
    ! [A: $tType,A1: fun(A,bool),X2: A] : ( insert(A,X2,insert(A,X2,A1)) = insert(A,X2,A1) ) ).

tff(fact_87_insert__iff,axiom,
    ! [A: $tType,A1: fun(A,bool),B2: A,Aa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,B2,A1)))
    <=> ( ( Aa = B2 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1)) ) ) ).

tff(fact_88_insertCI,axiom,
    ! [A: $tType,B2: A,B1: fun(A,bool),Aa: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),B1))
       => ( Aa = B2 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,B2,B1))) ) ).

tff(fact_89_insertE,axiom,
    ! [A: $tType,A1: fun(A,bool),B2: A,Aa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,B2,A1)))
     => ( ( Aa != B2 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1)) ) ) ).

tff(fact_90_insert__absorb,axiom,
    ! [A: $tType,A1: fun(A,bool),Aa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1))
     => ( insert(A,Aa,A1) = A1 ) ) ).

tff(fact_91_insertI2,axiom,
    ! [A: $tType,B2: A,B1: fun(A,bool),Aa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),B1))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,B2,B1))) ) ).

tff(fact_92_insert__eq__iff,axiom,
    ! [A: $tType,B1: fun(A,bool),B2: A,A1: fun(A,bool),Aa: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),B1))
       => ( ( insert(A,Aa,A1) = insert(A,B2,B1) )
        <=> ( ( ( Aa = B2 )
             => ( A1 = B1 ) )
            & ( ( Aa != B2 )
             => ? [C1: fun(A,bool)] :
                  ( ( A1 = insert(A,B2,C1) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),C1))
                  & ( B1 = insert(A,Aa,C1) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),C1)) ) ) ) ) ) ) ).

tff(fact_93_insert__ident,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),X2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B1))
       => ( ( insert(A,X2,A1) = insert(A,X2,B1) )
        <=> ( A1 = B1 ) ) ) ) ).

tff(fact_94_insert__code,axiom,
    ! [A: $tType,X2: A,A1: fun(A,bool),Y1: A] :
      ( pp(aa(A,bool,insert(A,Y1,A1),X2))
    <=> ( ( Y1 = X2 )
        | pp(aa(A,bool,A1,X2)) ) ) ).

tff(fact_95_insert__commute,axiom,
    ! [A: $tType,A1: fun(A,bool),Y1: A,X2: A] : ( insert(A,X2,insert(A,Y1,A1)) = insert(A,Y1,insert(A,X2,A1)) ) ).

tff(fact_96_insert__Collect,axiom,
    ! [A: $tType,Pa: fun(A,bool),Aa: A] : ( insert(A,Aa,collect(A,Pa)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fimplies,combb(bool,bool,A,fNot,combc(A,A,bool,fequal(A),Aa))),Pa)) ) ).

tff(fact_97_insert__compr,axiom,
    ! [A: $tType,B1: fun(A,bool),Aa: A] : ( insert(A,Aa,B1) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),Aa)),combc(A,fun(A,bool),bool,member(A),B1))) ) ).

tff(fact_98_insertI1,axiom,
    ! [A: $tType,B1: fun(A,bool),Aa: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,Aa,B1))) ).

tff(fact_99_insert__compr__raw,axiom,
    ! [A: $tType,X1: A,Xa: fun(A,bool)] : ( insert(A,X1,Xa) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),X1)),combc(A,fun(A,bool),bool,member(A),Xa))) ) ).

%----Helper facts (16)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    new_Addr(ha) = aa(nat,option(nat),some(nat),a) ).

%------------------------------------------------------------------------------
