%------------------------------------------------------------------------------
% File     : SWW550_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Huffman's Algorithm line 1274
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla09] Blanchette (2009), Proof Pearl: Mechanizing the Textbo
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : huff_1274 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  180 (  52 unt;  50 typ;   0 def)
%            Number of atoms       :  280 ( 124 equ)
%            Maximal formula atoms :   15 (   1 avg)
%            Number of connectives :  193 (  43   ~;   5   |;  24   &)
%                                         (  18 <=>; 103  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   17 (   5 avg)
%            Maximal term depth    :    7 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   40 (  22   >;  18   *;   0   +;   0  <<)
%            Number of predicates  :   15 (  14 usr;   0 prp; 1-2 aty)
%            Number of functors    :   33 (  33 usr;  10 con; 0-6 aty)
%            Number of variables   :  404 ( 359   !;   2   ?; 404   :)
%                                         (  43  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:22:53
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Huffman__Mirabelle__lalbadcutu_Otree,type,
    huffma1450048681e_tree: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (45)
tff(sy_cl_Lattices_Obounded__lattice,type,
    bounded_lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Osemilattice__inf,type,
    semilattice_inf: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Obounded__lattice__bot,type,
    bounded_lattice_bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oalphabet,type,
    huffma675207370phabet: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > fun(A,bool) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_OcachedWeight,type,
    huffma854194513Weight: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oconsistent,type,
    huffma1518433673istent: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ocost,type,
    huffma1134658180e_cost: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ofreq,type,
    huffma1352802255e_freq: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Osibling,type,
    huffma1401021291ibling: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > A ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_OswapLeaves,type,
    huffma414517318Leaves: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * nat * A * nat * A ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OInnerNode,type,
    huffma1146269203erNode: 
      !>[A: $tType] : ( ( nat * huffma1450048681e_tree(A) * huffma1450048681e_tree(A) ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_Otree__case,type,
    huffma107959123e_case: 
      !>[A: $tType,T1: $tType] : ( ( fun(nat,fun(A,T1)) * fun(nat,fun(huffma1450048681e_tree(A),fun(huffma1450048681e_tree(A),T1))) * huffma1450048681e_tree(A) ) > T1 ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_OuniteTrees,type,
    huffma921447403eTrees: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * huffma1450048681e_tree(A) ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oweight,type,
    huffma83463279weight: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Lattices_Oinf__class_Oinf,type,
    inf_inf: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa1: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_aa____,type,
    aa: a ).

tff(sy_v_b,type,
    b: a ).

tff(sy_v_t_092_060_094isub_0621____,type,
    t_1: huffma1450048681e_tree(a) ).

tff(sy_v_t_092_060_094isub_0622____,type,
    t_2: huffma1450048681e_tree(a) ).

tff(sy_v_w_092_060_094isub_062a,type,
    w_a: nat ).

tff(sy_v_w_092_060_094isub_062b,type,
    w_b: nat ).

tff(sy_v_w____,type,
    w: nat ).

%----Relevant facts (99)
tff(fact_0_step_092_060_094isub_0621_Oprems,axiom,
    aa != b ).

tff(fact_1_step_092_060_094isub_0621_I5_J,axiom,
    ~ pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),aa),huffma675207370phabet(a,t_2))) ).

tff(fact_2_step_092_060_094isub_0621_I4_J,axiom,
    pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),aa),huffma675207370phabet(a,t_1))) ).

tff(fact_3_step_092_060_094isub_0621_I1_J,axiom,
    huffma1518433673istent(a,t_1) ).

tff(fact_4_step_092_060_094isub_0621_I2_J,axiom,
    huffma1518433673istent(a,t_2) ).

tff(fact_5_tree_Osimps_I2_J,axiom,
    ! [B: $tType,Tree21: huffma1450048681e_tree(B),Tree11: huffma1450048681e_tree(B),Nat1: nat,Tree2: huffma1450048681e_tree(B),Tree1: huffma1450048681e_tree(B),Nat: nat] :
      ( ( huffma1146269203erNode(B,Nat,Tree1,Tree2) = huffma1146269203erNode(B,Nat1,Tree11,Tree21) )
    <=> ( ( Nat = Nat1 )
        & ( Tree1 = Tree11 )
        & ( Tree2 = Tree21 ) ) ) ).

tff(fact_6_step_092_060_094isub_0621_I6_J,axiom,
    ( ( aa != b )
   => ( ( pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),aa),huffma675207370phabet(a,t_1)))
       => ( ( pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),b),huffma675207370phabet(a,t_1)))
           => ( plus_plus(nat,plus_plus(nat,huffma83463279weight(a,huffma414517318Leaves(a,t_1,w_a,aa,w_b,b)),huffma1352802255e_freq(a,t_1,aa)),huffma1352802255e_freq(a,t_1,b)) = plus_plus(nat,plus_plus(nat,huffma83463279weight(a,t_1),w_a),w_b) ) )
          & ( ~ pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),b),huffma675207370phabet(a,t_1)))
           => ( plus_plus(nat,huffma83463279weight(a,huffma414517318Leaves(a,t_1,w_a,aa,w_b,b)),huffma1352802255e_freq(a,t_1,aa)) = plus_plus(nat,huffma83463279weight(a,t_1),w_b) ) ) ) )
      & ( ~ pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),aa),huffma675207370phabet(a,t_1)))
       => ( ( pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),b),huffma675207370phabet(a,t_1)))
           => ( plus_plus(nat,huffma83463279weight(a,huffma414517318Leaves(a,t_1,w_a,aa,w_b,b)),huffma1352802255e_freq(a,t_1,b)) = plus_plus(nat,huffma83463279weight(a,t_1),w_a) ) )
          & ( ~ pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),b),huffma675207370phabet(a,t_1)))
           => ( huffma83463279weight(a,huffma414517318Leaves(a,t_1,w_a,aa,w_b,b)) = huffma83463279weight(a,t_1) ) ) ) ) ) ) ).

tff(fact_7_step_092_060_094isub_0621_I7_J,axiom,
    ( ( aa != b )
   => ( ( pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),aa),huffma675207370phabet(a,t_2)))
       => ( ( pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),b),huffma675207370phabet(a,t_2)))
           => ( plus_plus(nat,plus_plus(nat,huffma83463279weight(a,huffma414517318Leaves(a,t_2,w_a,aa,w_b,b)),huffma1352802255e_freq(a,t_2,aa)),huffma1352802255e_freq(a,t_2,b)) = plus_plus(nat,plus_plus(nat,huffma83463279weight(a,t_2),w_a),w_b) ) )
          & ( ~ pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),b),huffma675207370phabet(a,t_2)))
           => ( plus_plus(nat,huffma83463279weight(a,huffma414517318Leaves(a,t_2,w_a,aa,w_b,b)),huffma1352802255e_freq(a,t_2,aa)) = plus_plus(nat,huffma83463279weight(a,t_2),w_b) ) ) ) )
      & ( ~ pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),aa),huffma675207370phabet(a,t_2)))
       => ( ( pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),b),huffma675207370phabet(a,t_2)))
           => ( plus_plus(nat,huffma83463279weight(a,huffma414517318Leaves(a,t_2,w_a,aa,w_b,b)),huffma1352802255e_freq(a,t_2,b)) = plus_plus(nat,huffma83463279weight(a,t_2),w_a) ) )
          & ( ~ pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),b),huffma675207370phabet(a,t_2)))
           => ( huffma83463279weight(a,huffma414517318Leaves(a,t_2,w_a,aa,w_b,b)) = huffma83463279weight(a,t_2) ) ) ) ) ) ) ).

tff(fact_8_swapLeaves_Osimps_I2_J,axiom,
    ! [A: $tType,B2: A,W_b1: nat,A1: A,W_a1: nat,T_21: huffma1450048681e_tree(A),T_11: huffma1450048681e_tree(A),W: nat] : ( huffma414517318Leaves(A,huffma1146269203erNode(A,W,T_11,T_21),W_a1,A1,W_b1,B2) = huffma1146269203erNode(A,W,huffma414517318Leaves(A,T_11,W_a1,A1,W_b1,B2),huffma414517318Leaves(A,T_21,W_a1,A1,W_b1,B2)) ) ).

tff(fact_9_freq_Osimps_I2_J,axiom,
    ! [A: $tType,T_21: huffma1450048681e_tree(A),T_11: huffma1450048681e_tree(A),W: nat,X: A] : ( huffma1352802255e_freq(A,huffma1146269203erNode(A,W,T_11,T_21),X) = plus_plus(nat,huffma1352802255e_freq(A,T_11,X),huffma1352802255e_freq(A,T_21,X)) ) ).

tff(fact_10_weight_Osimps_I2_J,axiom,
    ! [A: $tType,T_21: huffma1450048681e_tree(A),T_11: huffma1450048681e_tree(A),W: nat] : ( huffma83463279weight(A,huffma1146269203erNode(A,W,T_11,T_21)) = plus_plus(nat,huffma83463279weight(A,T_11),huffma83463279weight(A,T_21)) ) ).

tff(fact_11_swapLeaves__id__when__notin__alphabet,axiom,
    ! [B: $tType,W1: nat,Wa: nat,Ta: huffma1450048681e_tree(B),Ab: B] :
      ( ~ pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),Ab),huffma675207370phabet(B,Ta)))
     => ( huffma414517318Leaves(B,Ta,Wa,Ab,W1,Ab) = Ta ) ) ).

tff(fact_12_cost_Osimps_I2_J,axiom,
    ! [A: $tType,T_21: huffma1450048681e_tree(A),T_11: huffma1450048681e_tree(A),W: nat] : ( huffma1134658180e_cost(A,huffma1146269203erNode(A,W,T_11,T_21)) = plus_plus(nat,plus_plus(nat,plus_plus(nat,huffma83463279weight(A,T_11),huffma1134658180e_cost(A,T_11)),huffma83463279weight(A,T_21)),huffma1134658180e_cost(A,T_21)) ) ).

tff(fact_13_freq__uniteTrees,axiom,
    ! [A: $tType,T_21: huffma1450048681e_tree(A),T_11: huffma1450048681e_tree(A),X: A] : ( huffma1352802255e_freq(A,huffma921447403eTrees(A,T_11,T_21),X) = plus_plus(nat,huffma1352802255e_freq(A,T_11,X),huffma1352802255e_freq(A,T_21,X)) ) ).

tff(fact_14_nat__add__left__cancel,axiom,
    ! [N: nat,M: nat,K1: nat] :
      ( ( plus_plus(nat,K1,M) = plus_plus(nat,K1,N) )
    <=> ( M = N ) ) ).

tff(fact_15_nat__add__right__cancel,axiom,
    ! [N: nat,K1: nat,M: nat] :
      ( ( plus_plus(nat,M,K1) = plus_plus(nat,N,K1) )
    <=> ( M = N ) ) ).

tff(fact_16_add__left__cancel,axiom,
    ! [B: $tType] :
      ( cancel_semigroup_add(B)
     => ! [C2: B,Ba: B,Ab: B] :
          ( ( plus_plus(B,Ab,Ba) = plus_plus(B,Ab,C2) )
        <=> ( Ba = C2 ) ) ) ).

tff(fact_17_add__right__cancel,axiom,
    ! [B: $tType] :
      ( cancel_semigroup_add(B)
     => ! [C2: B,Ab: B,Ba: B] :
          ( ( plus_plus(B,Ba,Ab) = plus_plus(B,C2,Ab) )
        <=> ( Ba = C2 ) ) ) ).

tff(fact_18_step_092_060_094isub_0621_I3_J,axiom,
    inf_inf(fun(a,bool),huffma675207370phabet(a,t_1),huffma675207370phabet(a,t_2)) = bot_bot(fun(a,bool)) ).

tff(fact_19_tree_Osimps_I6_J,axiom,
    ! [B: $tType,C: $tType,Tree2: huffma1450048681e_tree(C),Tree1: huffma1450048681e_tree(C),Nat: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B))),F1: fun(nat,fun(C,B))] : ( huffma107959123e_case(C,B,F1,F2,huffma1146269203erNode(C,Nat,Tree1,Tree2)) = aa1(huffma1450048681e_tree(C),B,aa1(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B),aa1(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B)),F2,Nat),Tree1),Tree2) ) ).

tff(fact_20_exists__in__alphabet,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B)] :
    ? [A3: B] : pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),A3),huffma675207370phabet(B,Ta))) ).

tff(fact_21_sibling_Osimps_I4_J,axiom,
    ! [B: $tType,Vb: huffma1450048681e_tree(B),Va: huffma1450048681e_tree(B),V: nat,Wa: nat,T_12: huffma1450048681e_tree(B),Ab: B] :
      ( ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),Ab),huffma675207370phabet(B,T_12)))
       => ( huffma1401021291ibling(B,huffma1146269203erNode(B,Wa,T_12,huffma1146269203erNode(B,V,Va,Vb)),Ab) = huffma1401021291ibling(B,T_12,Ab) ) )
      & ( ~ pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),Ab),huffma675207370phabet(B,T_12)))
       => ( ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),Ab),huffma675207370phabet(B,huffma1146269203erNode(B,V,Va,Vb))))
           => ( huffma1401021291ibling(B,huffma1146269203erNode(B,Wa,T_12,huffma1146269203erNode(B,V,Va,Vb)),Ab) = huffma1401021291ibling(B,huffma1146269203erNode(B,V,Va,Vb),Ab) ) )
          & ( ~ pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),Ab),huffma675207370phabet(B,huffma1146269203erNode(B,V,Va,Vb))))
           => ( huffma1401021291ibling(B,huffma1146269203erNode(B,Wa,T_12,huffma1146269203erNode(B,V,Va,Vb)),Ab) = Ab ) ) ) ) ) ).

tff(fact_22_sibling_Osimps_I3_J,axiom,
    ! [B: $tType,T_22: huffma1450048681e_tree(B),Wa: nat,Vb: huffma1450048681e_tree(B),Va: huffma1450048681e_tree(B),V: nat,Ab: B] :
      ( ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),Ab),huffma675207370phabet(B,huffma1146269203erNode(B,V,Va,Vb))))
       => ( huffma1401021291ibling(B,huffma1146269203erNode(B,Wa,huffma1146269203erNode(B,V,Va,Vb),T_22),Ab) = huffma1401021291ibling(B,huffma1146269203erNode(B,V,Va,Vb),Ab) ) )
      & ( ~ pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),Ab),huffma675207370phabet(B,huffma1146269203erNode(B,V,Va,Vb))))
       => ( ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),Ab),huffma675207370phabet(B,T_22)))
           => ( huffma1401021291ibling(B,huffma1146269203erNode(B,Wa,huffma1146269203erNode(B,V,Va,Vb),T_22),Ab) = huffma1401021291ibling(B,T_22,Ab) ) )
          & ( ~ pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),Ab),huffma675207370phabet(B,T_22)))
           => ( huffma1401021291ibling(B,huffma1146269203erNode(B,Wa,huffma1146269203erNode(B,V,Va,Vb),T_22),Ab) = Ab ) ) ) ) ) ).

tff(fact_23_swapLeaves__id,axiom,
    ! [A: $tType,A1: A,T: huffma1450048681e_tree(A)] :
      ( huffma1518433673istent(A,T)
     => ( huffma414517318Leaves(A,T,huffma1352802255e_freq(A,T,A1),A1,huffma1352802255e_freq(A,T,A1),A1) = T ) ) ).

tff(fact_24_consistent_Osimps_I2_J,axiom,
    ! [B: $tType,T_22: huffma1450048681e_tree(B),T_12: huffma1450048681e_tree(B),Wa: nat] :
      ( huffma1518433673istent(B,huffma1146269203erNode(B,Wa,T_12,T_22))
    <=> ( huffma1518433673istent(B,T_12)
        & huffma1518433673istent(B,T_22)
        & ( inf_inf(fun(B,bool),huffma675207370phabet(B,T_12),huffma675207370phabet(B,T_22)) = bot_bot(fun(B,bool)) ) ) ) ).

tff(fact_25_sibling__sibling__id,axiom,
    ! [A: $tType,A1: A,T: huffma1450048681e_tree(A)] :
      ( huffma1518433673istent(A,T)
     => ( huffma1401021291ibling(A,T,huffma1401021291ibling(A,T,A1)) = A1 ) ) ).

tff(fact_26_consistent__uniteTrees,axiom,
    ! [B: $tType,T_22: huffma1450048681e_tree(B),T_12: huffma1450048681e_tree(B)] :
      ( huffma1518433673istent(B,T_12)
     => ( huffma1518433673istent(B,T_22)
       => ( ( inf_inf(fun(B,bool),huffma675207370phabet(B,T_12),huffma675207370phabet(B,T_22)) = bot_bot(fun(B,bool)) )
         => huffma1518433673istent(B,huffma921447403eTrees(B,T_12,T_22)) ) ) ) ).

tff(fact_27_sibling__reciprocal,axiom,
    ! [A: $tType,B2: A,A1: A,T: huffma1450048681e_tree(A)] :
      ( huffma1518433673istent(A,T)
     => ( ( huffma1401021291ibling(A,T,A1) = B2 )
       => ( huffma1401021291ibling(A,T,B2) = A1 ) ) ) ).

tff(fact_28_in__alphabet__imp__sibling__in__alphabet,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B),Ab: B] :
      ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),Ab),huffma675207370phabet(B,Ta)))
     => pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),huffma1401021291ibling(B,Ta,Ab)),huffma675207370phabet(B,Ta))) ) ).

tff(fact_29_sibling__ne__imp__sibling__in__alphabet,axiom,
    ! [B: $tType,Ab: B,Ta: huffma1450048681e_tree(B)] :
      ( ( huffma1401021291ibling(B,Ta,Ab) != Ab )
     => pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),huffma1401021291ibling(B,Ta,Ab)),huffma675207370phabet(B,Ta))) ) ).

tff(fact_30_notin__alphabet__imp__sibling__id,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B),Ab: B] :
      ( ~ pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),Ab),huffma675207370phabet(B,Ta)))
     => ( huffma1401021291ibling(B,Ta,Ab) = Ab ) ) ).

tff(fact_31_consistent__swapLeaves,axiom,
    ! [A: $tType,B2: A,W_b1: nat,A1: A,W_a1: nat,T: huffma1450048681e_tree(A)] :
      ( huffma1518433673istent(A,T)
     => huffma1518433673istent(A,huffma414517318Leaves(A,T,W_a1,A1,W_b1,B2)) ) ).

tff(fact_32_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C3: A,A1: A,B2: A] :
          ( ( plus_plus(A,B2,A1) = plus_plus(A,C3,A1) )
         => ( B2 = C3 ) ) ) ).

tff(fact_33_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C3: A,B2: A,A1: A] :
          ( ( plus_plus(A,A1,B2) = plus_plus(A,A1,C3) )
         => ( B2 = C3 ) ) ) ).

tff(fact_34_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C3: A,B2: A,A1: A] :
          ( ( plus_plus(A,A1,B2) = plus_plus(A,A1,C3) )
         => ( B2 = C3 ) ) ) ).

tff(fact_35_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C3: A,B2: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B2),C3) = plus_plus(A,A1,plus_plus(A,B2,C3)) ) ) ).

tff(fact_36_nat__add__assoc,axiom,
    ! [K: nat,N1: nat,M1: nat] : ( plus_plus(nat,plus_plus(nat,M1,N1),K) = plus_plus(nat,M1,plus_plus(nat,N1,K)) ) ).

tff(fact_37_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X4: nat] : ( plus_plus(nat,X4,plus_plus(nat,Y,Z)) = plus_plus(nat,Y,plus_plus(nat,X4,Z)) ) ).

tff(fact_38_nat__add__commute,axiom,
    ! [N1: nat,M1: nat] : ( plus_plus(nat,M1,N1) = plus_plus(nat,N1,M1) ) ).

tff(fact_39_inf__bot__left,axiom,
    ! [A: $tType] :
      ( bounded_lattice_bot(A)
     => ! [X4: A] : ( inf_inf(A,bot_bot(A),X4) = bot_bot(A) ) ) ).

tff(fact_40_inf__bot__right,axiom,
    ! [A: $tType] :
      ( bounded_lattice_bot(A)
     => ! [X4: A] : ( inf_inf(A,X4,bot_bot(A)) = bot_bot(A) ) ) ).

tff(fact_41_Int__iff,axiom,
    ! [B: $tType,B1: fun(B,bool),A2: fun(B,bool),C2: B] :
      ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),C2),inf_inf(fun(B,bool),A2,B1)))
    <=> ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),C2),A2))
        & pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),C2),B1)) ) ) ).

tff(fact_42_inf1I,axiom,
    ! [B: $tType,B1: fun(B,bool),X1: B,A2: fun(B,bool)] :
      ( pp(aa1(B,bool,A2,X1))
     => ( pp(aa1(B,bool,B1,X1))
       => pp(aa1(B,bool,inf_inf(fun(B,bool),A2,B1),X1)) ) ) ).

tff(fact_43_IntI,axiom,
    ! [B: $tType,B1: fun(B,bool),A2: fun(B,bool),C2: B] :
      ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),C2),A2))
     => ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),C2),B1))
       => pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),C2),inf_inf(fun(B,bool),A2,B1))) ) ) ).

tff(fact_44_IntE,axiom,
    ! [B: $tType,B1: fun(B,bool),A2: fun(B,bool),C2: B] :
      ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),C2),inf_inf(fun(B,bool),A2,B1)))
     => ~ ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),C2),A2))
         => ~ pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),C2),B1)) ) ) ).

tff(fact_45_inf1E,axiom,
    ! [B: $tType,X1: B,B1: fun(B,bool),A2: fun(B,bool)] :
      ( pp(aa1(B,bool,inf_inf(fun(B,bool),A2,B1),X1))
     => ~ ( pp(aa1(B,bool,A2,X1))
         => ~ pp(aa1(B,bool,B1,X1)) ) ) ).

tff(fact_46_emptyE,axiom,
    ! [B: $tType,Ab: B] : ~ pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),Ab),bot_bot(fun(B,bool)))) ).

tff(fact_47_Collect__empty__eq,axiom,
    ! [B: $tType,P1: fun(B,bool)] :
      ( ( collect(B,P1) = bot_bot(fun(B,bool)) )
    <=> ! [X2: B] : ~ pp(aa1(B,bool,P1,X2)) ) ).

tff(fact_48_empty__iff,axiom,
    ! [B: $tType,C2: B] : ~ pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),C2),bot_bot(fun(B,bool)))) ).

tff(fact_49_empty__Collect__eq,axiom,
    ! [B: $tType,P1: fun(B,bool)] :
      ( ( bot_bot(fun(B,bool)) = collect(B,P1) )
    <=> ! [X2: B] : ~ pp(aa1(B,bool,P1,X2)) ) ).

tff(fact_50_all__not__in__conv,axiom,
    ! [B: $tType,A2: fun(B,bool)] :
      ( ! [X2: B] : ~ pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),X2),A2))
    <=> ( A2 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_51_inf__left__idem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Y: A,X4: A] : ( inf_inf(A,X4,inf_inf(A,X4,Y)) = inf_inf(A,X4,Y) ) ) ).

tff(fact_52_inf_Oleft__idem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [B2: A,A1: A] : ( inf_inf(A,A1,inf_inf(A,A1,B2)) = inf_inf(A,A1,B2) ) ) ).

tff(fact_53_equals0D,axiom,
    ! [B: $tType,Ab: B,A2: fun(B,bool)] :
      ( ( A2 = bot_bot(fun(B,bool)) )
     => ~ pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),Ab),A2)) ) ).

tff(fact_54_ex__in__conv,axiom,
    ! [B: $tType,A2: fun(B,bool)] :
      ( ? [X2: B] : pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),X2),A2))
    <=> ( A2 != bot_bot(fun(B,bool)) ) ) ).

tff(fact_55_empty__def,axiom,
    ! [B: $tType] : ( bot_bot(fun(B,bool)) = collect(B,combk(bool,B,fFalse)) ) ).

tff(fact_56_bot__empty__eq,axiom,
    ! [B: $tType,X: B] :
      ( pp(aa1(B,bool,bot_bot(fun(B,bool)),X))
    <=> pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),X),bot_bot(fun(B,bool)))) ) ).

tff(fact_57_inf__assoc,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Z: A,Y: A,X4: A] : ( inf_inf(A,inf_inf(A,X4,Y),Z) = inf_inf(A,X4,inf_inf(A,Y,Z)) ) ) ).

tff(fact_58_inf__sup__aci_I2_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z: A,Y: A,X4: A] : ( inf_inf(A,inf_inf(A,X4,Y),Z) = inf_inf(A,X4,inf_inf(A,Y,Z)) ) ) ).

tff(fact_59_inf_Oassoc,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [C3: A,B2: A,A1: A] : ( inf_inf(A,inf_inf(A,A1,B2),C3) = inf_inf(A,A1,inf_inf(A,B2,C3)) ) ) ).

tff(fact_60_inf__left__commute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Z: A,Y: A,X4: A] : ( inf_inf(A,X4,inf_inf(A,Y,Z)) = inf_inf(A,Y,inf_inf(A,X4,Z)) ) ) ).

tff(fact_61_inf__sup__aci_I3_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z: A,Y: A,X4: A] : ( inf_inf(A,X4,inf_inf(A,Y,Z)) = inf_inf(A,Y,inf_inf(A,X4,Z)) ) ) ).

tff(fact_62_inf_Oleft__commute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [C3: A,A1: A,B2: A] : ( inf_inf(A,B2,inf_inf(A,A1,C3)) = inf_inf(A,A1,inf_inf(A,B2,C3)) ) ) ).

tff(fact_63_inf__sup__aci_I4_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X4: A] : ( inf_inf(A,X4,inf_inf(A,X4,Y)) = inf_inf(A,X4,Y) ) ) ).

tff(fact_64_inf__commute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Y: A,X4: A] : ( inf_inf(A,X4,Y) = inf_inf(A,Y,X4) ) ) ).

tff(fact_65_inf__sup__aci_I1_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X4: A] : ( inf_inf(A,X4,Y) = inf_inf(A,Y,X4) ) ) ).

tff(fact_66_inf_Ocommute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [B2: A,A1: A] : ( inf_inf(A,A1,B2) = inf_inf(A,B2,A1) ) ) ).

tff(fact_67_inf__idem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [X4: A] : ( inf_inf(A,X4,X4) = X4 ) ) ).

tff(fact_68_inf_Oidem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [A1: A] : ( inf_inf(A,A1,A1) = A1 ) ) ).

tff(fact_69_inf1D2,axiom,
    ! [B: $tType,X1: B,B1: fun(B,bool),A2: fun(B,bool)] :
      ( pp(aa1(B,bool,inf_inf(fun(B,bool),A2,B1),X1))
     => pp(aa1(B,bool,B1,X1)) ) ).

tff(fact_70_inf1D1,axiom,
    ! [B: $tType,X1: B,B1: fun(B,bool),A2: fun(B,bool)] :
      ( pp(aa1(B,bool,inf_inf(fun(B,bool),A2,B1),X1))
     => pp(aa1(B,bool,A2,X1)) ) ).

tff(fact_71_IntD2,axiom,
    ! [B: $tType,B1: fun(B,bool),A2: fun(B,bool),C2: B] :
      ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),C2),inf_inf(fun(B,bool),A2,B1)))
     => pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),C2),B1)) ) ).

tff(fact_72_IntD1,axiom,
    ! [B: $tType,B1: fun(B,bool),A2: fun(B,bool),C2: B] :
      ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),C2),inf_inf(fun(B,bool),A2,B1)))
     => pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),C2),A2)) ) ).

tff(fact_73_Int__assoc,axiom,
    ! [B: $tType,C1: fun(B,bool),B1: fun(B,bool),A2: fun(B,bool)] : ( inf_inf(fun(B,bool),inf_inf(fun(B,bool),A2,B1),C1) = inf_inf(fun(B,bool),A2,inf_inf(fun(B,bool),B1,C1)) ) ).

tff(fact_74_Int__left__commute,axiom,
    ! [B: $tType,C1: fun(B,bool),B1: fun(B,bool),A2: fun(B,bool)] : ( inf_inf(fun(B,bool),A2,inf_inf(fun(B,bool),B1,C1)) = inf_inf(fun(B,bool),B1,inf_inf(fun(B,bool),A2,C1)) ) ).

tff(fact_75_ext,axiom,
    ! [C: $tType,B: $tType,G: fun(B,C),F: fun(B,C)] :
      ( ! [X3: B] : ( aa1(B,C,F,X3) = aa1(B,C,G,X3) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [B: $tType,A2: fun(B,bool),X1: B] :
      ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),X1),A2))
    <=> pp(aa1(B,bool,A2,X1)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [B: $tType,P1: fun(B,bool)] : ( collect(B,P1) = P1 ) ).

tff(fact_78_Int__left__absorb,axiom,
    ! [B: $tType,B1: fun(B,bool),A2: fun(B,bool)] : ( inf_inf(fun(B,bool),A2,inf_inf(fun(B,bool),A2,B1)) = inf_inf(fun(B,bool),A2,B1) ) ).

tff(fact_79_Int__commute,axiom,
    ! [B: $tType,B1: fun(B,bool),A2: fun(B,bool)] : ( inf_inf(fun(B,bool),A2,B1) = inf_inf(fun(B,bool),B1,A2) ) ).

tff(fact_80_Int__def,axiom,
    ! [B: $tType,B1: fun(B,bool),A2: fun(B,bool)] : ( inf_inf(fun(B,bool),A2,B1) = collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,combc(B,fun(B,bool),bool,member(B),A2)),combc(B,fun(B,bool),bool,member(B),B1))) ) ).

tff(fact_81_Int__absorb,axiom,
    ! [B: $tType,A2: fun(B,bool)] : ( inf_inf(fun(B,bool),A2,A2) = A2 ) ).

tff(fact_82_inf__Int__eq,axiom,
    ! [B: $tType,S: fun(B,bool),R1: fun(B,bool),X: B] :
      ( pp(aa1(B,bool,inf_inf(fun(B,bool),combc(B,fun(B,bool),bool,member(B),R1),combc(B,fun(B,bool),bool,member(B),S)),X))
    <=> pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),X),inf_inf(fun(B,bool),R1,S))) ) ).

tff(fact_83_Int__Collect,axiom,
    ! [B: $tType,P1: fun(B,bool),A2: fun(B,bool),X1: B] :
      ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),X1),inf_inf(fun(B,bool),A2,collect(B,P1))))
    <=> ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),X1),A2))
        & pp(aa1(B,bool,P1,X1)) ) ) ).

tff(fact_84_Collect__conj__eq,axiom,
    ! [B: $tType,Q1: fun(B,bool),P1: fun(B,bool)] : ( collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,P1),Q1)) = inf_inf(fun(B,bool),collect(B,P1),collect(B,Q1)) ) ).

tff(fact_85_disjoint__iff__not__equal,axiom,
    ! [B: $tType,B1: fun(B,bool),A2: fun(B,bool)] :
      ( ( inf_inf(fun(B,bool),A2,B1) = bot_bot(fun(B,bool)) )
    <=> ! [X2: B] :
          ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),X2),A2))
         => ! [Xa: B] :
              ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),Xa),B1))
             => ( X2 != Xa ) ) ) ) ).

tff(fact_86_Int__empty__right,axiom,
    ! [B: $tType,A2: fun(B,bool)] : ( inf_inf(fun(B,bool),A2,bot_bot(fun(B,bool))) = bot_bot(fun(B,bool)) ) ).

tff(fact_87_Int__empty__left,axiom,
    ! [B: $tType,B1: fun(B,bool)] : ( inf_inf(fun(B,bool),bot_bot(fun(B,bool)),B1) = bot_bot(fun(B,bool)) ) ).

tff(fact_88_inf__apply,axiom,
    ! [B: $tType,C: $tType] :
      ( lattice(B)
     => ! [X1: C,G: fun(C,B),F: fun(C,B)] : ( aa1(C,B,inf_inf(fun(C,B),F,G),X1) = inf_inf(B,aa1(C,B,F,X1),aa1(C,B,G,X1)) ) ) ).

tff(fact_89_inf__fun__def,axiom,
    ! [C: $tType,B: $tType] :
      ( lattice(C)
     => ! [G: fun(B,C),F: fun(B,C),X: B] : ( aa1(B,C,inf_inf(fun(B,C),F,G),X) = inf_inf(C,aa1(B,C,F,X),aa1(B,C,G,X)) ) ) ).

tff(fact_90_uniteTrees__def,axiom,
    ! [A: $tType,T_21: huffma1450048681e_tree(A),T_11: huffma1450048681e_tree(A)] : ( huffma921447403eTrees(A,T_11,T_21) = huffma1146269203erNode(A,plus_plus(nat,huffma854194513Weight(A,T_11),huffma854194513Weight(A,T_21)),T_11,T_21) ) ).

tff(fact_91_bot__apply,axiom,
    ! [C: $tType,B: $tType] :
      ( bot(B)
     => ! [X1: C] : ( aa1(C,B,bot_bot(fun(C,B)),X1) = bot_bot(B) ) ) ).

tff(fact_92_bot__fun__def,axiom,
    ! [B: $tType,C: $tType] :
      ( bot(C)
     => ! [X: B] : ( aa1(B,C,bot_bot(fun(B,C)),X) = bot_bot(C) ) ) ).

tff(fact_93_freq__swapLeaves,axiom,
    ! [B: $tType,W_b: nat,W_a: nat,Ba: B,Ab: B,Ta: huffma1450048681e_tree(B)] :
      ( huffma1518433673istent(B,Ta)
     => ( ( Ab != Ba )
       => ! [X: B] :
            ( ( ( X = Ab )
             => ( ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),Ba),huffma675207370phabet(B,Ta)))
                 => ( huffma1352802255e_freq(B,huffma414517318Leaves(B,Ta,W_a,Ab,W_b,Ba),X) = W_a ) )
                & ( ~ pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),Ba),huffma675207370phabet(B,Ta)))
                 => ( huffma1352802255e_freq(B,huffma414517318Leaves(B,Ta,W_a,Ab,W_b,Ba),X) = zero_zero(nat) ) ) ) )
            & ( ( X != Ab )
             => ( ( ( X = Ba )
                 => ( ( pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),Ab),huffma675207370phabet(B,Ta)))
                     => ( huffma1352802255e_freq(B,huffma414517318Leaves(B,Ta,W_a,Ab,W_b,Ba),X) = W_b ) )
                    & ( ~ pp(aa1(fun(B,bool),bool,aa1(B,fun(fun(B,bool),bool),member(B),Ab),huffma675207370phabet(B,Ta)))
                     => ( huffma1352802255e_freq(B,huffma414517318Leaves(B,Ta,W_a,Ab,W_b,Ba),X) = zero_zero(nat) ) ) ) )
                & ( ( X != Ba )
                 => ( huffma1352802255e_freq(B,huffma414517318Leaves(B,Ta,W_a,Ab,W_b,Ba),X) = huffma1352802255e_freq(B,Ta,X) ) ) ) ) ) ) ) ).

tff(fact_94_double__zero__sym,axiom,
    ! [B: $tType] :
      ( linord219039673up_add(B)
     => ! [Ab: B] :
          ( ( zero_zero(B) = plus_plus(B,Ab,Ab) )
        <=> ( Ab = zero_zero(B) ) ) ) ).

tff(fact_95_add__is__0,axiom,
    ! [N: nat,M: nat] :
      ( ( plus_plus(nat,M,N) = zero_zero(nat) )
    <=> ( ( M = zero_zero(nat) )
        & ( N = zero_zero(nat) ) ) ) ).

tff(fact_96_bot__nat__def,axiom,
    bot_bot(nat) = zero_zero(nat) ).

tff(fact_97_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_98_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

%----Arities (19)
tff(arity_HOL_Obool___Lattices_Obounded__lattice,axiom,
    bounded_lattice(bool) ).

tff(arity_fun___Lattices_Obounded__lattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bounded_lattice(T_2)
     => bounded_lattice(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Obounded__lattice__bot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bounded_lattice(T_2)
     => bounded_lattice_bot(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Osemilattice__inf,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => semilattice_inf(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Olattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => lattice(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Lattices_Osemilattice__inf,axiom,
    semilattice_inf(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Lattices_Olattice,axiom,
    lattice(nat) ).

tff(arity_Nat_Onat___Orderings_Obot,axiom,
    bot(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Lattices_Obounded__lattice__bot,axiom,
    bounded_lattice_bot(bool) ).

tff(arity_HOL_Obool___Lattices_Osemilattice__inf,axiom,
    semilattice_inf(bool) ).

tff(arity_HOL_Obool___Lattices_Olattice,axiom,
    lattice(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (11)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa1(A,C,combb(B,C,A,P,Q),R) = aa1(B,C,P,aa1(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa1(A,C,combc(A,B,C,P,Q),R) = aa1(B,C,aa1(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa1(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa1(A,C,combs(A,B,C,P,Q),R) = aa1(B,C,aa1(A,fun(B,C),P,R),aa1(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa1(bool,bool,aa1(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa1(bool,bool,aa1(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa1(bool,bool,aa1(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ( ( pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),aa),huffma675207370phabet(a,huffma1146269203erNode(a,w,t_1,t_2))))
     => ( ( pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),b),huffma675207370phabet(a,huffma1146269203erNode(a,w,t_1,t_2))))
         => ( plus_plus(nat,plus_plus(nat,huffma83463279weight(a,huffma414517318Leaves(a,huffma1146269203erNode(a,w,t_1,t_2),w_a,aa,w_b,b)),huffma1352802255e_freq(a,huffma1146269203erNode(a,w,t_1,t_2),aa)),huffma1352802255e_freq(a,huffma1146269203erNode(a,w,t_1,t_2),b)) = plus_plus(nat,plus_plus(nat,huffma83463279weight(a,huffma1146269203erNode(a,w,t_1,t_2)),w_a),w_b) ) )
        & ( ~ pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),b),huffma675207370phabet(a,huffma1146269203erNode(a,w,t_1,t_2))))
         => ( plus_plus(nat,huffma83463279weight(a,huffma414517318Leaves(a,huffma1146269203erNode(a,w,t_1,t_2),w_a,aa,w_b,b)),huffma1352802255e_freq(a,huffma1146269203erNode(a,w,t_1,t_2),aa)) = plus_plus(nat,huffma83463279weight(a,huffma1146269203erNode(a,w,t_1,t_2)),w_b) ) ) ) )
    & ( ~ pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),aa),huffma675207370phabet(a,huffma1146269203erNode(a,w,t_1,t_2))))
     => ( ( pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),b),huffma675207370phabet(a,huffma1146269203erNode(a,w,t_1,t_2))))
         => ( plus_plus(nat,huffma83463279weight(a,huffma414517318Leaves(a,huffma1146269203erNode(a,w,t_1,t_2),w_a,aa,w_b,b)),huffma1352802255e_freq(a,huffma1146269203erNode(a,w,t_1,t_2),b)) = plus_plus(nat,huffma83463279weight(a,huffma1146269203erNode(a,w,t_1,t_2)),w_a) ) )
        & ( ~ pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),b),huffma675207370phabet(a,huffma1146269203erNode(a,w,t_1,t_2))))
         => ( huffma83463279weight(a,huffma414517318Leaves(a,huffma1146269203erNode(a,w,t_1,t_2),w_a,aa,w_b,b)) = huffma83463279weight(a,huffma1146269203erNode(a,w,t_1,t_2)) ) ) ) ) ) ).

%------------------------------------------------------------------------------
