%------------------------------------------------------------------------------
% File     : SWW549_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Huffman's Algorithm line 1234
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla09] Blanchette (2009), Proof Pearl: Mechanizing the Textbo
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : huff_1234 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  162 (  48 unt;  42 typ;   0 def)
%            Number of atoms       :  286 ( 122 equ)
%            Maximal formula atoms :   13 (   1 avg)
%            Number of connectives :  215 (  49   ~;   8   |;  22   &)
%                                         (  13 <=>; 123  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   5 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   39 (  23   >;  16   *;   0   +;   0  <<)
%            Number of predicates  :   12 (  11 usr;   0 prp; 1-3 aty)
%            Number of functors    :   26 (  26 usr;   8 con; 0-6 aty)
%            Number of variables   :  348 ( 320   !;   3   ?; 348   :)
%                                         (  25  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:22:43
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Huffman__Mirabelle__lalbadcutu_Otree,type,
    huffma1450048681e_tree: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_String_Ochar,type,
    char: $tType ).

tff(ty_tc_String_Oliteral,type,
    literal: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (35)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_HOL_Obool_Obool__size,type,
    bool_size: bool > nat ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oalphabet,type,
    huffma675207370phabet: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > fun(A,bool) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oconsistent,type,
    huffma1518433673istent: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ocost,type,
    huffma1134658180e_cost: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Odepth,type,
    huffma410068972_depth: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ofreq,type,
    huffma1352802255e_freq: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > fun(A,nat) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oheight,type,
    huffma945805758height: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ooptimum,type,
    huffma1393970616ptimum: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Osibling,type,
    huffma1401021291ibling: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > A ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_OswapLeaves,type,
    huffma414517318Leaves: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * nat * A * nat * A ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OInnerNode,type,
    huffma1146269203erNode: 
      !>[A: $tType] : ( ( nat * huffma1450048681e_tree(A) * huffma1450048681e_tree(A) ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OLeaf,type,
    huffma2021818691e_Leaf: 
      !>[A: $tType] : ( ( nat * A ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_Otree__case,type,
    huffma107959123e_case: 
      !>[A: $tType,T1: $tType] : ( ( fun(nat,fun(A,T1)) * fun(nat,fun(huffma1450048681e_tree(A),fun(huffma1450048681e_tree(A),T1))) * huffma1450048681e_tree(A) ) > T1 ) ).

tff(sy_c_Nat_Onat_Onat__size,type,
    nat_size: nat > nat ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_String_Ochar_Ochar__size,type,
    char_size: char > nat ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a1: a ).

tff(sy_v_b,type,
    b: a ).

tff(sy_v_c,type,
    c: a ).

tff(sy_v_t,type,
    t: huffma1450048681e_tree(a) ).

tff(sy_v_w_092_060_094isub_062a,type,
    w_a: nat ).

tff(sy_v_w_092_060_094isub_062b,type,
    w_b: nat ).

%----Relevant facts (99)
tff(fact_0_consistent__swapLeaves,axiom,
    ! [A: $tType,B1: A,W_b: nat,A1: A,W_a: nat,T: huffma1450048681e_tree(A)] :
      ( huffma1518433673istent(A,T)
     => huffma1518433673istent(A,huffma414517318Leaves(A,T,W_a,A1,W_b,B1)) ) ).

tff(fact_1_swapLeaves__id,axiom,
    ! [A: $tType,A1: A,T: huffma1450048681e_tree(A)] :
      ( huffma1518433673istent(A,T)
     => ( huffma414517318Leaves(A,T,aa(A,nat,huffma1352802255e_freq(A,T),A1),A1,aa(A,nat,huffma1352802255e_freq(A,T),A1),A1) = T ) ) ).

tff(fact_2_notin__alphabet__imp__freq__0,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B),Aa: B] :
      ( ~ member(B,Aa,huffma675207370phabet(B,Ta))
     => ( aa(B,nat,huffma1352802255e_freq(B,Ta),Aa) = zero_zero(nat) ) ) ).

tff(fact_3_swapLeaves__id__when__notin__alphabet,axiom,
    ! [B: $tType,W2: nat,W: nat,Ta: huffma1450048681e_tree(B),Aa: B] :
      ( ~ member(B,Aa,huffma675207370phabet(B,Ta))
     => ( huffma414517318Leaves(B,Ta,W,Aa,W2,Aa) = Ta ) ) ).

tff(fact_4_exists__in__alphabet,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B)] :
    ? [A3: B] : member(B,A3,huffma675207370phabet(B,Ta)) ).

tff(fact_5_depth__swapLeaves__neither,axiom,
    ! [A: $tType,W_b: nat,W_a: nat,B1: A,A1: A,C1: A,T: huffma1450048681e_tree(A)] :
      ( huffma1518433673istent(A,T)
     => ( ( C1 != A1 )
       => ( ( C1 != B1 )
         => ( huffma410068972_depth(A,huffma414517318Leaves(A,T,W_a,A1,W_b,B1),C1) = huffma410068972_depth(A,T,C1) ) ) ) ) ).

tff(fact_6_freq_Osimps_I1_J,axiom,
    ! [A: $tType,W1: nat,A1: A,X4: A] :
      ( ( ( X4 = A1 )
       => ( aa(A,nat,huffma1352802255e_freq(A,huffma2021818691e_Leaf(A,W1,A1)),X4) = W1 ) )
      & ( ( X4 != A1 )
       => ( aa(A,nat,huffma1352802255e_freq(A,huffma2021818691e_Leaf(A,W1,A1)),X4) = zero_zero(nat) ) ) ) ).

tff(fact_7_zero__reorient,axiom,
    ! [B: $tType] :
      ( zero(B)
     => ! [X1: B] :
          ( ( zero_zero(B) = X1 )
        <=> ( X1 = zero_zero(B) ) ) ) ).

tff(fact_8_swapLeaves_Osimps_I1_J,axiom,
    ! [A: $tType,B1: A,W_b: nat,W_a: nat,W_c: nat,A1: A,C1: A] :
      ( ( ( C1 = A1 )
       => ( huffma414517318Leaves(A,huffma2021818691e_Leaf(A,W_c,C1),W_a,A1,W_b,B1) = huffma2021818691e_Leaf(A,W_b,B1) ) )
      & ( ( C1 != A1 )
       => ( ( ( C1 = B1 )
           => ( huffma414517318Leaves(A,huffma2021818691e_Leaf(A,W_c,C1),W_a,A1,W_b,B1) = huffma2021818691e_Leaf(A,W_a,A1) ) )
          & ( ( C1 != B1 )
           => ( huffma414517318Leaves(A,huffma2021818691e_Leaf(A,W_c,C1),W_a,A1,W_b,B1) = huffma2021818691e_Leaf(A,W_c,C1) ) ) ) ) ) ).

tff(fact_9_bool_Osize_I1_J,axiom,
    bool_size(fTrue) = zero_zero(nat) ).

tff(fact_10_bool_Osize_I2_J,axiom,
    bool_size(fFalse) = zero_zero(nat) ).

tff(fact_11_char__size,axiom,
    ! [C1: char] : ( char_size(C1) = zero_zero(nat) ) ).

tff(fact_12_consistent_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,W1: nat] : huffma1518433673istent(A,huffma2021818691e_Leaf(A,W1,A1)) ).

tff(fact_13_height__swapLeaves,axiom,
    ! [A: $tType,B1: A,W_b: nat,A1: A,W_a: nat,T: huffma1450048681e_tree(A)] : ( huffma945805758height(A,huffma414517318Leaves(A,T,W_a,A1,W_b,B1)) = huffma945805758height(A,T) ) ).

tff(fact_14_swapLeaves_Osimps_I2_J,axiom,
    ! [A: $tType,B1: A,W_b: nat,A1: A,W_a: nat,T_22: huffma1450048681e_tree(A),T_12: huffma1450048681e_tree(A),W1: nat] : ( huffma414517318Leaves(A,huffma1146269203erNode(A,W1,T_12,T_22),W_a,A1,W_b,B1) = huffma1146269203erNode(A,W1,huffma414517318Leaves(A,T_12,W_a,A1,W_b,B1),huffma414517318Leaves(A,T_22,W_a,A1,W_b,B1)) ) ).

tff(fact_15_tree_Osimps_I2_J,axiom,
    ! [B: $tType,Tree23: huffma1450048681e_tree(B),Tree13: huffma1450048681e_tree(B),Nat4: nat,Tree21: huffma1450048681e_tree(B),Tree11: huffma1450048681e_tree(B),Nat1: nat] :
      ( ( huffma1146269203erNode(B,Nat1,Tree11,Tree21) = huffma1146269203erNode(B,Nat4,Tree13,Tree23) )
    <=> ( ( Nat1 = Nat4 )
        & ( Tree11 = Tree13 )
        & ( Tree21 = Tree23 ) ) ) ).

tff(fact_16_tree_Osimps_I1_J,axiom,
    ! [B: $tType,A4: B,Nat4: nat,Aa: B,Nat1: nat] :
      ( ( huffma2021818691e_Leaf(B,Nat1,Aa) = huffma2021818691e_Leaf(B,Nat4,A4) )
    <=> ( ( Nat1 = Nat4 )
        & ( Aa = A4 ) ) ) ).

tff(fact_17_height_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,W1: nat] : ( huffma945805758height(A,huffma2021818691e_Leaf(A,W1,A1)) = zero_zero(nat) ) ).

tff(fact_18_depth_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,B1: A,W1: nat] : ( huffma410068972_depth(A,huffma2021818691e_Leaf(A,W1,B1),A1) = zero_zero(nat) ) ).

tff(fact_19_tree_Osimps_I3_J,axiom,
    ! [A: $tType,Tree22: huffma1450048681e_tree(A),Tree12: huffma1450048681e_tree(A),Nat3: nat,A1: A,Nat2: nat] : ( huffma2021818691e_Leaf(A,Nat2,A1) != huffma1146269203erNode(A,Nat3,Tree12,Tree22) ) ).

tff(fact_20_tree_Osimps_I4_J,axiom,
    ! [A: $tType,A1: A,Nat2: nat,Tree22: huffma1450048681e_tree(A),Tree12: huffma1450048681e_tree(A),Nat3: nat] : ( huffma1146269203erNode(A,Nat3,Tree12,Tree22) != huffma2021818691e_Leaf(A,Nat2,A1) ) ).

tff(fact_21_exists__at__height,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B)] :
      ( huffma1518433673istent(B,Ta)
     => ? [X3: B] :
          ( member(B,X3,huffma675207370phabet(B,Ta))
          & ( huffma410068972_depth(B,Ta,X3) = huffma945805758height(B,Ta) ) ) ) ).

tff(fact_22_tree_Osize_I3_J,axiom,
    ! [A: $tType,A1: A,Nat2: nat] : ( size_size(huffma1450048681e_tree(A),huffma2021818691e_Leaf(A,Nat2,A1)) = zero_zero(nat) ) ).

tff(fact_23_size__char,axiom,
    ! [C1: char] : ( size_size(char,C1) = zero_zero(nat) ) ).

tff(fact_24_nat_Osize_I1_J,axiom,
    nat_size(zero_zero(nat)) = zero_zero(nat) ).

tff(fact_25_cost_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,W1: nat] : ( huffma1134658180e_cost(A,huffma2021818691e_Leaf(A,W1,A1)) = zero_zero(nat) ) ).

tff(fact_26_bool_Osize_I4_J,axiom,
    size_size(bool,fFalse) = zero_zero(nat) ).

tff(fact_27_bool_Osize_I3_J,axiom,
    size_size(bool,fTrue) = zero_zero(nat) ).

tff(fact_28_tree_Osimps_I5_J,axiom,
    ! [B: $tType,C: $tType,Aa: C,Nat1: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B))),F1: fun(nat,fun(C,B))] : ( huffma107959123e_case(C,B,F1,F2,huffma2021818691e_Leaf(C,Nat1,Aa)) = aa(C,B,aa(nat,fun(C,B),F1,Nat1),Aa) ) ).

tff(fact_29_size__bool,axiom,
    ! [Ba: bool] : ( size_size(bool,Ba) = zero_zero(nat) ) ).

tff(fact_30_height__0__imp__cost__0,axiom,
    ! [A: $tType,T: huffma1450048681e_tree(A)] :
      ( ( huffma945805758height(A,T) = zero_zero(nat) )
     => ( huffma1134658180e_cost(A,T) = zero_zero(nat) ) ) ).

tff(fact_31_tree_Osimps_I6_J,axiom,
    ! [B: $tType,C: $tType,Tree21: huffma1450048681e_tree(C),Tree11: huffma1450048681e_tree(C),Nat1: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B))),F1: fun(nat,fun(C,B))] : ( huffma107959123e_case(C,B,F1,F2,huffma1146269203erNode(C,Nat1,Tree11,Tree21)) = aa(huffma1450048681e_tree(C),B,aa(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B),aa(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B)),F2,Nat1),Tree11),Tree21) ) ).

tff(fact_32_size__literal__def,axiom,
    ! [S: literal] : ( size_size(literal,S) = zero_zero(nat) ) ).

tff(fact_33_nat_Osize_I3_J,axiom,
    size_size(nat,zero_zero(nat)) = zero_zero(nat) ).

tff(fact_34_tree_Oexhaust,axiom,
    ! [A: $tType,Y: huffma1450048681e_tree(A)] :
      ( ! [Nat: nat,A3: A] : ( Y != huffma2021818691e_Leaf(A,Nat,A3) )
     => ~ ! [Nat: nat,Tree1: huffma1450048681e_tree(A),Tree2: huffma1450048681e_tree(A)] : ( Y != huffma1146269203erNode(A,Nat,Tree1,Tree2) ) ) ).

tff(fact_35_height__gt__0__alphabet__eq__imp__height__gt__0,axiom,
    ! [B: $tType,U1: huffma1450048681e_tree(B),Ta: huffma1450048681e_tree(B)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B,Ta))
     => ( huffma1518433673istent(B,Ta)
       => ( ( huffma675207370phabet(B,Ta) = huffma675207370phabet(B,U1) )
         => ord_less(nat,zero_zero(nat),huffma945805758height(B,U1)) ) ) ) ).

tff(fact_36_optimum__def,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B)] :
      ( huffma1393970616ptimum(B,Ta)
    <=> ! [U: huffma1450048681e_tree(B)] :
          ( huffma1518433673istent(B,U)
         => ( ( huffma675207370phabet(B,Ta) = huffma675207370phabet(B,U) )
           => ( ( huffma1352802255e_freq(B,Ta) = huffma1352802255e_freq(B,U) )
             => ord_less_eq(nat,huffma1134658180e_cost(B,Ta),huffma1134658180e_cost(B,U)) ) ) ) ) ).

tff(fact_37_sibling_Osimps_I2_J,axiom,
    ! [A: $tType,C1: A,W_c: nat,W_b: nat,W1: nat,B1: A,A1: A] :
      ( ( ( A1 = B1 )
       => ( huffma1401021291ibling(A,huffma1146269203erNode(A,W1,huffma2021818691e_Leaf(A,W_b,B1),huffma2021818691e_Leaf(A,W_c,C1)),A1) = C1 ) )
      & ( ( A1 != B1 )
       => ( ( ( A1 = C1 )
           => ( huffma1401021291ibling(A,huffma1146269203erNode(A,W1,huffma2021818691e_Leaf(A,W_b,B1),huffma2021818691e_Leaf(A,W_c,C1)),A1) = B1 ) )
          & ( ( A1 != C1 )
           => ( huffma1401021291ibling(A,huffma1146269203erNode(A,W1,huffma2021818691e_Leaf(A,W_b,B1),huffma2021818691e_Leaf(A,W_c,C1)),A1) = A1 ) ) ) ) ) ).

tff(fact_38_sibling_Osimps_I3_J,axiom,
    ! [B: $tType,T_21: huffma1450048681e_tree(B),W: nat,Vb: huffma1450048681e_tree(B),Va: huffma1450048681e_tree(B),V: nat,Aa: B] :
      ( ( member(B,Aa,huffma675207370phabet(B,huffma1146269203erNode(B,V,Va,Vb)))
       => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,huffma1146269203erNode(B,V,Va,Vb),T_21),Aa) = huffma1401021291ibling(B,huffma1146269203erNode(B,V,Va,Vb),Aa) ) )
      & ( ~ member(B,Aa,huffma675207370phabet(B,huffma1146269203erNode(B,V,Va,Vb)))
       => ( ( member(B,Aa,huffma675207370phabet(B,T_21))
           => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,huffma1146269203erNode(B,V,Va,Vb),T_21),Aa) = huffma1401021291ibling(B,T_21,Aa) ) )
          & ( ~ member(B,Aa,huffma675207370phabet(B,T_21))
           => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,huffma1146269203erNode(B,V,Va,Vb),T_21),Aa) = Aa ) ) ) ) ) ).

tff(fact_39_sibling_Osimps_I4_J,axiom,
    ! [B: $tType,Vb: huffma1450048681e_tree(B),Va: huffma1450048681e_tree(B),V: nat,W: nat,T_11: huffma1450048681e_tree(B),Aa: B] :
      ( ( member(B,Aa,huffma675207370phabet(B,T_11))
       => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,T_11,huffma1146269203erNode(B,V,Va,Vb)),Aa) = huffma1401021291ibling(B,T_11,Aa) ) )
      & ( ~ member(B,Aa,huffma675207370phabet(B,T_11))
       => ( ( member(B,Aa,huffma675207370phabet(B,huffma1146269203erNode(B,V,Va,Vb)))
           => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,T_11,huffma1146269203erNode(B,V,Va,Vb)),Aa) = huffma1401021291ibling(B,huffma1146269203erNode(B,V,Va,Vb),Aa) ) )
          & ( ~ member(B,Aa,huffma675207370phabet(B,huffma1146269203erNode(B,V,Va,Vb)))
           => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,T_11,huffma1146269203erNode(B,V,Va,Vb)),Aa) = Aa ) ) ) ) ) ).

tff(fact_40_nat__size,axiom,
    ! [N1: nat] : ( size_size(nat,N1) = N1 ) ).

tff(fact_41_in__alphabet__imp__sibling__in__alphabet,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B),Aa: B] :
      ( member(B,Aa,huffma675207370phabet(B,Ta))
     => member(B,huffma1401021291ibling(B,Ta,Aa),huffma675207370phabet(B,Ta)) ) ).

tff(fact_42_sibling__ne__imp__sibling__in__alphabet,axiom,
    ! [B: $tType,Aa: B,Ta: huffma1450048681e_tree(B)] :
      ( ( huffma1401021291ibling(B,Ta,Aa) != Aa )
     => member(B,huffma1401021291ibling(B,Ta,Aa),huffma675207370phabet(B,Ta)) ) ).

tff(fact_43_notin__alphabet__imp__sibling__id,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B),Aa: B] :
      ( ~ member(B,Aa,huffma675207370phabet(B,Ta))
     => ( huffma1401021291ibling(B,Ta,Aa) = Aa ) ) ).

tff(fact_44_sibling_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,B1: A,W_b: nat] : ( huffma1401021291ibling(A,huffma2021818691e_Leaf(A,W_b,B1),A1) = A1 ) ).

tff(fact_45_sibling__reciprocal,axiom,
    ! [A: $tType,B1: A,A1: A,T: huffma1450048681e_tree(A)] :
      ( huffma1518433673istent(A,T)
     => ( ( huffma1401021291ibling(A,T,A1) = B1 )
       => ( huffma1401021291ibling(A,T,B1) = A1 ) ) ) ).

tff(fact_46_sibling__sibling__id,axiom,
    ! [A: $tType,A1: A,T: huffma1450048681e_tree(A)] :
      ( huffma1518433673istent(A,T)
     => ( huffma1401021291ibling(A,T,huffma1401021291ibling(A,T,A1)) = A1 ) ) ).

tff(fact_47_either__height__gt__0__imp__sibling,axiom,
    ! [B: $tType,W: nat,Aa: B,T_21: huffma1450048681e_tree(B),T_11: huffma1450048681e_tree(B)] :
      ( ( ord_less(nat,zero_zero(nat),huffma945805758height(B,T_11))
        | ord_less(nat,zero_zero(nat),huffma945805758height(B,T_21)) )
     => ( ( member(B,Aa,huffma675207370phabet(B,T_11))
         => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,T_11,T_21),Aa) = huffma1401021291ibling(B,T_11,Aa) ) )
        & ( ~ member(B,Aa,huffma675207370phabet(B,T_11))
         => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,T_11,T_21),Aa) = huffma1401021291ibling(B,T_21,Aa) ) ) ) ) ).

tff(fact_48_height__gt__0__in__alphabet__imp__sibling__right,axiom,
    ! [B: $tType,W: nat,T_11: huffma1450048681e_tree(B),Aa: B,T_21: huffma1450048681e_tree(B)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B,T_21))
     => ( member(B,Aa,huffma675207370phabet(B,T_11))
       => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,T_11,T_21),Aa) = huffma1401021291ibling(B,T_11,Aa) ) ) ) ).

tff(fact_49_height__gt__0__in__alphabet__imp__sibling__left,axiom,
    ! [B: $tType,T_21: huffma1450048681e_tree(B),W: nat,Aa: B,T_11: huffma1450048681e_tree(B)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B,T_11))
     => ( member(B,Aa,huffma675207370phabet(B,T_11))
       => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,T_11,T_21),Aa) = huffma1401021291ibling(B,T_11,Aa) ) ) ) ).

tff(fact_50_height__gt__0__notin__alphabet__imp__sibling__right,axiom,
    ! [B: $tType,W: nat,T_11: huffma1450048681e_tree(B),Aa: B,T_21: huffma1450048681e_tree(B)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B,T_21))
     => ( ~ member(B,Aa,huffma675207370phabet(B,T_11))
       => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,T_11,T_21),Aa) = huffma1401021291ibling(B,T_21,Aa) ) ) ) ).

tff(fact_51_height__gt__0__notin__alphabet__imp__sibling__left,axiom,
    ! [B: $tType,T_21: huffma1450048681e_tree(B),W: nat,Aa: B,T_11: huffma1450048681e_tree(B)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B,T_11))
     => ( ~ member(B,Aa,huffma675207370phabet(B,T_11))
       => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,T_11,T_21),Aa) = huffma1401021291ibling(B,T_21,Aa) ) ) ) ).

tff(fact_52_depth__le__height,axiom,
    ! [A: $tType,A1: A,T: huffma1450048681e_tree(A)] : ord_less_eq(nat,huffma410068972_depth(A,T,A1),huffma945805758height(A,T)) ).

tff(fact_53_height__0__imp__sibling__id,axiom,
    ! [A: $tType,A1: A,T: huffma1450048681e_tree(A)] :
      ( ( huffma945805758height(A,T) = zero_zero(nat) )
     => ( huffma1401021291ibling(A,T,A1) = A1 ) ) ).

tff(fact_54_depth__height__imp__sibling__ne,axiom,
    ! [B: $tType,Aa: B,Ta: huffma1450048681e_tree(B)] :
      ( huffma1518433673istent(B,Ta)
     => ( ( huffma410068972_depth(B,Ta,Aa) = huffma945805758height(B,Ta) )
       => ( ord_less(nat,zero_zero(nat),huffma945805758height(B,Ta))
         => ( member(B,Aa,huffma675207370phabet(B,Ta))
           => ( huffma1401021291ibling(B,Ta,Aa) != Aa ) ) ) ) ) ).

tff(fact_55_depth__sibling,axiom,
    ! [A: $tType,A1: A,T: huffma1450048681e_tree(A)] :
      ( huffma1518433673istent(A,T)
     => ( huffma410068972_depth(A,T,huffma1401021291ibling(A,T,A1)) = huffma410068972_depth(A,T,A1) ) ) ).

tff(fact_56_le0,axiom,
    ! [N1: nat] : ord_less_eq(nat,zero_zero(nat),N1) ).

tff(fact_57_less__eq__nat_Osimps_I1_J,axiom,
    ! [N1: nat] : ord_less_eq(nat,zero_zero(nat),N1) ).

tff(fact_58_le__0__eq,axiom,
    ! [N: nat] :
      ( ord_less_eq(nat,N,zero_zero(nat))
    <=> ( N = zero_zero(nat) ) ) ).

tff(fact_59_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_60_less__nat__zero__code,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_61_less__zeroE,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_62_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),N: nat,M: nat] :
      ( ( ord_less(nat,M,N)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M)) )
     => ( ( ( M = N )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M)) )
       => ( ( ord_less(nat,N,M)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M)) ) ) ) ).

tff(fact_63_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_64_less__not__refl2,axiom,
    ! [M1: nat,N1: nat] :
      ( ord_less(nat,N1,M1)
     => ( M1 != N1 ) ) ).

tff(fact_65_less__irrefl__nat,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,N1) ).

tff(fact_66_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_67_nat__neq__iff,axiom,
    ! [N: nat,M: nat] :
      ( ( M != N )
    <=> ( ord_less(nat,M,N)
        | ord_less(nat,N,M) ) ) ).

tff(fact_68_less__not__refl,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,N1) ).

tff(fact_69_le__antisym,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less_eq(nat,M1,N1)
     => ( ord_less_eq(nat,N1,M1)
       => ( M1 = N1 ) ) ) ).

tff(fact_70_le__trans,axiom,
    ! [K1: nat,J2: nat,I3: nat] :
      ( ord_less_eq(nat,I3,J2)
     => ( ord_less_eq(nat,J2,K1)
       => ord_less_eq(nat,I3,K1) ) ) ).

tff(fact_71_eq__imp__le,axiom,
    ! [N1: nat,M1: nat] :
      ( ( M1 = N1 )
     => ord_less_eq(nat,M1,N1) ) ).

tff(fact_72_nat__le__linear,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less_eq(nat,M1,N1)
      | ord_less_eq(nat,N1,M1) ) ).

tff(fact_73_le__refl,axiom,
    ! [N1: nat] : ord_less_eq(nat,N1,N1) ).

tff(fact_74_ext,axiom,
    ! [C: $tType,B: $tType,G: fun(B,C),F: fun(B,C)] :
      ( ! [X3: B] : ( aa(B,C,F,X3) = aa(B,C,G,X3) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [B: $tType,A2: fun(B,bool),X1: B] :
      ( member(B,X1,A2)
    <=> pp(aa(B,bool,A2,X1)) ) ).

tff(fact_76_gr0I,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_77_gr__implies__not0,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,M1,N1)
     => ( N1 != zero_zero(nat) ) ) ).

tff(fact_78_not__less0,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_79_less__or__eq__imp__le,axiom,
    ! [N1: nat,M1: nat] :
      ( ( ord_less(nat,M1,N1)
        | ( M1 = N1 ) )
     => ord_less_eq(nat,M1,N1) ) ).

tff(fact_80_le__neq__implies__less,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less_eq(nat,M1,N1)
     => ( ( M1 != N1 )
       => ord_less(nat,M1,N1) ) ) ).

tff(fact_81_less__imp__le__nat,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,M1,N1)
     => ord_less_eq(nat,M1,N1) ) ).

tff(fact_82_le__eq__less__or__eq,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
    <=> ( ord_less(nat,M,N)
        | ( M = N ) ) ) ).

tff(fact_83_nat__less__le,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
    <=> ( ord_less_eq(nat,M,N)
        & ( M != N ) ) ) ).

tff(fact_84_ex__least__nat__le,axiom,
    ! [N: nat,P1: fun(nat,bool)] :
      ( ~ pp(aa(nat,bool,P1,zero_zero(nat)))
     => ( pp(aa(nat,bool,P1,N))
       => ? [K: nat] :
            ( ord_less_eq(nat,K,N)
            & ! [I2: nat] :
                ( ord_less(nat,I2,K)
               => ~ pp(aa(nat,bool,P1,I2)) )
            & pp(aa(nat,bool,P1,K)) ) ) ) ).

tff(fact_85_less__mono__imp__le__mono,axiom,
    ! [J: nat,I: nat,F: fun(nat,nat)] :
      ( ! [I1: nat,J1: nat] :
          ( ord_less(nat,I1,J1)
         => ord_less(nat,aa(nat,nat,F,I1),aa(nat,nat,F,J1)) )
     => ( ord_less_eq(nat,I,J)
       => ord_less_eq(nat,aa(nat,nat,F,I),aa(nat,nat,F,J)) ) ) ).

tff(fact_86_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ord_less_eq(A,X,X) ) ).

tff(fact_87_le__fun__def,axiom,
    ! [C: $tType,B: $tType] :
      ( ord(C)
     => ! [G: fun(B,C),F: fun(B,C)] :
          ( ord_less_eq(fun(B,C),F,G)
        <=> ! [X2: B] : ord_less_eq(C,aa(B,C,F,X2),aa(B,C,G,X2)) ) ) ).

tff(fact_88_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
          | ord_less_eq(A,Y,X) ) ) ).

tff(fact_89_order__eq__iff,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [Y1: B,X1: B] :
          ( ( X1 = Y1 )
        <=> ( ord_less_eq(B,X1,Y1)
            & ord_less_eq(B,Y1,X1) ) ) ) ).

tff(fact_90_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ( X = Y )
         => ord_less_eq(A,X,Y) ) ) ).

tff(fact_91_le__funD,axiom,
    ! [C: $tType,B: $tType] :
      ( ord(C)
     => ! [X1: B,G: fun(B,C),F: fun(B,C)] :
          ( ord_less_eq(fun(B,C),F,G)
         => ord_less_eq(C,aa(B,C,F,X1),aa(B,C,G,X1)) ) ) ).

tff(fact_92_order__antisym__conv,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [X1: B,Y1: B] :
          ( ord_less_eq(B,Y1,X1)
         => ( ord_less_eq(B,X1,Y1)
          <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_93_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ( A1 = B1 )
         => ( ord_less_eq(A,B1,C1)
           => ord_less_eq(A,A1,C1) ) ) ) ).

tff(fact_94_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ord_less_eq(A,A1,B1)
         => ( ( B1 = C1 )
           => ord_less_eq(A,A1,C1) ) ) ) ).

tff(fact_95_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,X)
           => ( X = Y ) ) ) ) ).

tff(fact_96_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,Z)
           => ord_less_eq(A,X,Z) ) ) ) ).

tff(fact_97_le__funE,axiom,
    ! [C: $tType,B: $tType] :
      ( ord(C)
     => ! [X1: B,G: fun(B,C),F: fun(B,C)] :
          ( ord_less_eq(fun(B,C),F,G)
         => ord_less_eq(C,aa(B,C,F,X1),aa(B,C,G,X1)) ) ) ).

tff(fact_98_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ ord_less_eq(A,X,Y)
         => ord_less_eq(A,Y,X) ) ) ).

%----Arities (12)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (6)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    huffma1518433673istent(a,t) ).

tff(conj_1,hypothesis,
    a1 != b ).

tff(conj_2,conjecture,
    ( ( ( c = a1 )
     => ( ( member(a,b,huffma675207370phabet(a,t))
         => ( aa(a,nat,huffma1352802255e_freq(a,huffma414517318Leaves(a,t,w_a,a1,w_b,b)),c) = w_a ) )
        & ( ~ member(a,b,huffma675207370phabet(a,t))
         => ( aa(a,nat,huffma1352802255e_freq(a,huffma414517318Leaves(a,t,w_a,a1,w_b,b)),c) = zero_zero(nat) ) ) ) )
    & ( ( c != a1 )
     => ( ( ( c = b )
         => ( ( member(a,a1,huffma675207370phabet(a,t))
             => ( aa(a,nat,huffma1352802255e_freq(a,huffma414517318Leaves(a,t,w_a,a1,w_b,b)),c) = w_b ) )
            & ( ~ member(a,a1,huffma675207370phabet(a,t))
             => ( aa(a,nat,huffma1352802255e_freq(a,huffma414517318Leaves(a,t,w_a,a1,w_b,b)),c) = zero_zero(nat) ) ) ) )
        & ( ( c != b )
         => ( aa(a,nat,huffma1352802255e_freq(a,huffma414517318Leaves(a,t,w_a,a1,w_b,b)),c) = aa(a,nat,huffma1352802255e_freq(a,t),c) ) ) ) ) ) ).

%------------------------------------------------------------------------------
