%------------------------------------------------------------------------------
% File     : SWW547_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Huffman's Algorithm line 1165
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla09] Blanchette (2009), Proof Pearl: Mechanizing the Textbo
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : huff_1165 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  143 (  29 unt;  28 typ;   0 def)
%            Number of atoms       :  317 (  82 equ)
%            Maximal formula atoms :    7 (   2 avg)
%            Number of connectives :  258 (  56   ~;  12   |;  14   &)
%                                         (  20 <=>; 156  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   6 avg)
%            Maximal term depth    :    4 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   25 (  15   >;  10   *;   0   +;   0  <<)
%            Number of predicates  :   11 (  10 usr;   0 prp; 1-3 aty)
%            Number of functors    :   15 (  15 usr;   4 con; 0-4 aty)
%            Number of variables   :  340 ( 320   !;   1   ?; 340   :)
%                                         (  19  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:22:19
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_t_a,type,
    a1: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Huffman__Mirabelle__lalbadcutu_Otree,type,
    huffma1450048681e_tree: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (23)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oalphabet,type,
    huffma675207370phabet: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > fun(A,bool) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oconsistent,type,
    huffma1518433673istent: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Odepth,type,
    huffma410068972_depth: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oheight,type,
    huffma945805758height: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Osibling,type,
    huffma1401021291ibling: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > A ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OInnerNode,type,
    huffma1146269203erNode: 
      !>[A: $tType] : ( ( nat * huffma1450048681e_tree(A) * huffma1450048681e_tree(A) ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OLeaf,type,
    huffma2021818691e_Leaf: 
      !>[A: $tType] : ( ( nat * A ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: a1 ).

tff(sy_v_t,type,
    t: huffma1450048681e_tree(a1) ).

%----Relevant facts (99)
tff(fact_0_sibling__sibling__id,axiom,
    ! [A: $tType,A1: A,T: huffma1450048681e_tree(A)] :
      ( huffma1518433673istent(A,T)
     => ( huffma1401021291ibling(A,T,huffma1401021291ibling(A,T,A1)) = A1 ) ) ).

tff(fact_1_sibling__reciprocal,axiom,
    ! [A: $tType,B1: A,A1: A,T: huffma1450048681e_tree(A)] :
      ( huffma1518433673istent(A,T)
     => ( ( huffma1401021291ibling(A,T,A1) = B1 )
       => ( huffma1401021291ibling(A,T,B1) = A1 ) ) ) ).

tff(fact_2_consistent_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,W1: nat] : huffma1518433673istent(A,huffma2021818691e_Leaf(A,W1,A1)) ).

tff(fact_3_sibling_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,B1: A,W_b: nat] : ( huffma1401021291ibling(A,huffma2021818691e_Leaf(A,W_b,B1),A1) = A1 ) ).

tff(fact_4_notin__alphabet__imp__sibling__id,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B),Aa: B] :
      ( ~ member(B,Aa,huffma675207370phabet(B,Ta))
     => ( huffma1401021291ibling(B,Ta,Aa) = Aa ) ) ).

tff(fact_5_sibling__ne__imp__sibling__in__alphabet,axiom,
    ! [B: $tType,Aa: B,Ta: huffma1450048681e_tree(B)] :
      ( ( huffma1401021291ibling(B,Ta,Aa) != Aa )
     => member(B,huffma1401021291ibling(B,Ta,Aa),huffma675207370phabet(B,Ta)) ) ).

tff(fact_6_in__alphabet__imp__sibling__in__alphabet,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B),Aa: B] :
      ( member(B,Aa,huffma675207370phabet(B,Ta))
     => member(B,huffma1401021291ibling(B,Ta,Aa),huffma675207370phabet(B,Ta)) ) ).

tff(fact_7_exists__at__height,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B)] :
      ( huffma1518433673istent(B,Ta)
     => ? [X3: B] :
          ( member(B,X3,huffma675207370phabet(B,Ta))
          & ( huffma410068972_depth(B,Ta,X3) = huffma945805758height(B,Ta) ) ) ) ).

tff(fact_8_depth__height__imp__sibling__ne,axiom,
    ! [B: $tType,Aa: B,Ta: huffma1450048681e_tree(B)] :
      ( huffma1518433673istent(B,Ta)
     => ( ( huffma410068972_depth(B,Ta,Aa) = huffma945805758height(B,Ta) )
       => ( ord_less(nat,zero_zero(nat),huffma945805758height(B,Ta))
         => ( member(B,Aa,huffma675207370phabet(B,Ta))
           => ( huffma1401021291ibling(B,Ta,Aa) != Aa ) ) ) ) ) ).

tff(fact_9_depth_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,B1: A,W1: nat] : ( huffma410068972_depth(A,huffma2021818691e_Leaf(A,W1,B1),A1) = zero_zero(nat) ) ).

tff(fact_10_sibling_Osimps_I2_J,axiom,
    ! [A: $tType,C: A,W_c: nat,W_b: nat,W1: nat,B1: A,A1: A] :
      ( ( ( A1 = B1 )
       => ( huffma1401021291ibling(A,huffma1146269203erNode(A,W1,huffma2021818691e_Leaf(A,W_b,B1),huffma2021818691e_Leaf(A,W_c,C)),A1) = C ) )
      & ( ( A1 != B1 )
       => ( ( ( A1 = C )
           => ( huffma1401021291ibling(A,huffma1146269203erNode(A,W1,huffma2021818691e_Leaf(A,W_b,B1),huffma2021818691e_Leaf(A,W_c,C)),A1) = B1 ) )
          & ( ( A1 != C )
           => ( huffma1401021291ibling(A,huffma1146269203erNode(A,W1,huffma2021818691e_Leaf(A,W_b,B1),huffma2021818691e_Leaf(A,W_c,C)),A1) = A1 ) ) ) ) ) ).

tff(fact_11_sibling_Osimps_I4_J,axiom,
    ! [B: $tType,Vb: huffma1450048681e_tree(B),Va: huffma1450048681e_tree(B),V: nat,W: nat,T_11: huffma1450048681e_tree(B),Aa: B] :
      ( ( member(B,Aa,huffma675207370phabet(B,T_11))
       => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,T_11,huffma1146269203erNode(B,V,Va,Vb)),Aa) = huffma1401021291ibling(B,T_11,Aa) ) )
      & ( ~ member(B,Aa,huffma675207370phabet(B,T_11))
       => ( ( member(B,Aa,huffma675207370phabet(B,huffma1146269203erNode(B,V,Va,Vb)))
           => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,T_11,huffma1146269203erNode(B,V,Va,Vb)),Aa) = huffma1401021291ibling(B,huffma1146269203erNode(B,V,Va,Vb),Aa) ) )
          & ( ~ member(B,Aa,huffma675207370phabet(B,huffma1146269203erNode(B,V,Va,Vb)))
           => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,T_11,huffma1146269203erNode(B,V,Va,Vb)),Aa) = Aa ) ) ) ) ) ).

tff(fact_12_sibling_Osimps_I3_J,axiom,
    ! [B: $tType,T_21: huffma1450048681e_tree(B),W: nat,Vb: huffma1450048681e_tree(B),Va: huffma1450048681e_tree(B),V: nat,Aa: B] :
      ( ( member(B,Aa,huffma675207370phabet(B,huffma1146269203erNode(B,V,Va,Vb)))
       => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,huffma1146269203erNode(B,V,Va,Vb),T_21),Aa) = huffma1401021291ibling(B,huffma1146269203erNode(B,V,Va,Vb),Aa) ) )
      & ( ~ member(B,Aa,huffma675207370phabet(B,huffma1146269203erNode(B,V,Va,Vb)))
       => ( ( member(B,Aa,huffma675207370phabet(B,T_21))
           => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,huffma1146269203erNode(B,V,Va,Vb),T_21),Aa) = huffma1401021291ibling(B,T_21,Aa) ) )
          & ( ~ member(B,Aa,huffma675207370phabet(B,T_21))
           => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,huffma1146269203erNode(B,V,Va,Vb),T_21),Aa) = Aa ) ) ) ) ) ).

tff(fact_13_depth__le__height,axiom,
    ! [A: $tType,A1: A,T: huffma1450048681e_tree(A)] : ord_less_eq(nat,huffma410068972_depth(A,T,A1),huffma945805758height(A,T)) ).

tff(fact_14_tree_Osimps_I2_J,axiom,
    ! [B: $tType,Tree22: huffma1450048681e_tree(B),Tree12: huffma1450048681e_tree(B),Nat3: nat,Tree21: huffma1450048681e_tree(B),Tree11: huffma1450048681e_tree(B),Nat2: nat] :
      ( ( huffma1146269203erNode(B,Nat2,Tree11,Tree21) = huffma1146269203erNode(B,Nat3,Tree12,Tree22) )
    <=> ( ( Nat2 = Nat3 )
        & ( Tree11 = Tree12 )
        & ( Tree21 = Tree22 ) ) ) ).

tff(fact_15_tree_Osimps_I1_J,axiom,
    ! [B: $tType,A3: B,Nat3: nat,Aa: B,Nat2: nat] :
      ( ( huffma2021818691e_Leaf(B,Nat2,Aa) = huffma2021818691e_Leaf(B,Nat3,A3) )
    <=> ( ( Nat2 = Nat3 )
        & ( Aa = A3 ) ) ) ).

tff(fact_16_height_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,W1: nat] : ( huffma945805758height(A,huffma2021818691e_Leaf(A,W1,A1)) = zero_zero(nat) ) ).

tff(fact_17_tree_Osimps_I3_J,axiom,
    ! [A: $tType,Tree2: huffma1450048681e_tree(A),Tree1: huffma1450048681e_tree(A),Nat1: nat,A1: A,Nat: nat] : ( huffma2021818691e_Leaf(A,Nat,A1) != huffma1146269203erNode(A,Nat1,Tree1,Tree2) ) ).

tff(fact_18_tree_Osimps_I4_J,axiom,
    ! [A: $tType,A1: A,Nat: nat,Tree2: huffma1450048681e_tree(A),Tree1: huffma1450048681e_tree(A),Nat1: nat] : ( huffma1146269203erNode(A,Nat1,Tree1,Tree2) != huffma2021818691e_Leaf(A,Nat,A1) ) ).

tff(fact_19_height__gt__0__alphabet__eq__imp__height__gt__0,axiom,
    ! [B: $tType,U: huffma1450048681e_tree(B),Ta: huffma1450048681e_tree(B)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B,Ta))
     => ( huffma1518433673istent(B,Ta)
       => ( ( huffma675207370phabet(B,Ta) = huffma675207370phabet(B,U) )
         => ord_less(nat,zero_zero(nat),huffma945805758height(B,U)) ) ) ) ).

tff(fact_20_height__gt__0__notin__alphabet__imp__sibling__left,axiom,
    ! [B: $tType,T_21: huffma1450048681e_tree(B),W: nat,Aa: B,T_11: huffma1450048681e_tree(B)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B,T_11))
     => ( ~ member(B,Aa,huffma675207370phabet(B,T_11))
       => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,T_11,T_21),Aa) = huffma1401021291ibling(B,T_21,Aa) ) ) ) ).

tff(fact_21_height__gt__0__notin__alphabet__imp__sibling__right,axiom,
    ! [B: $tType,W: nat,T_11: huffma1450048681e_tree(B),Aa: B,T_21: huffma1450048681e_tree(B)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B,T_21))
     => ( ~ member(B,Aa,huffma675207370phabet(B,T_11))
       => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,T_11,T_21),Aa) = huffma1401021291ibling(B,T_21,Aa) ) ) ) ).

tff(fact_22_height__gt__0__in__alphabet__imp__sibling__left,axiom,
    ! [B: $tType,T_21: huffma1450048681e_tree(B),W: nat,Aa: B,T_11: huffma1450048681e_tree(B)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B,T_11))
     => ( member(B,Aa,huffma675207370phabet(B,T_11))
       => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,T_11,T_21),Aa) = huffma1401021291ibling(B,T_11,Aa) ) ) ) ).

tff(fact_23_height__gt__0__in__alphabet__imp__sibling__right,axiom,
    ! [B: $tType,W: nat,T_11: huffma1450048681e_tree(B),Aa: B,T_21: huffma1450048681e_tree(B)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B,T_21))
     => ( member(B,Aa,huffma675207370phabet(B,T_11))
       => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,T_11,T_21),Aa) = huffma1401021291ibling(B,T_11,Aa) ) ) ) ).

tff(fact_24_either__height__gt__0__imp__sibling,axiom,
    ! [B: $tType,W: nat,Aa: B,T_21: huffma1450048681e_tree(B),T_11: huffma1450048681e_tree(B)] :
      ( ( ord_less(nat,zero_zero(nat),huffma945805758height(B,T_11))
        | ord_less(nat,zero_zero(nat),huffma945805758height(B,T_21)) )
     => ( ( member(B,Aa,huffma675207370phabet(B,T_11))
         => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,T_11,T_21),Aa) = huffma1401021291ibling(B,T_11,Aa) ) )
        & ( ~ member(B,Aa,huffma675207370phabet(B,T_11))
         => ( huffma1401021291ibling(B,huffma1146269203erNode(B,W,T_11,T_21),Aa) = huffma1401021291ibling(B,T_21,Aa) ) ) ) ) ).

tff(fact_25_height__0__imp__sibling__id,axiom,
    ! [A: $tType,A1: A,T: huffma1450048681e_tree(A)] :
      ( ( huffma945805758height(A,T) = zero_zero(nat) )
     => ( huffma1401021291ibling(A,T,A1) = A1 ) ) ).

tff(fact_26_le0,axiom,
    ! [N: nat] : ord_less_eq(nat,zero_zero(nat),N) ).

tff(fact_27_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : ord_less_eq(nat,zero_zero(nat),N) ).

tff(fact_28_le__0__eq,axiom,
    ! [N1: nat] :
      ( ord_less_eq(nat,N1,zero_zero(nat))
    <=> ( N1 = zero_zero(nat) ) ) ).

tff(fact_29_neq0__conv,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_30_less__nat__zero__code,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_31_less__zeroE,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_32_tree_Osize_I3_J,axiom,
    ! [A: $tType,A1: A,Nat: nat] : ( size_size(huffma1450048681e_tree(A),huffma2021818691e_Leaf(A,Nat,A1)) = zero_zero(nat) ) ).

tff(fact_33_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X1: A] : ord_less_eq(A,X1,X1) ) ).

tff(fact_34_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ~ ord_less_eq(A,X1,Y1)
         => ord_less_eq(A,Y1,X1) ) ) ).

tff(fact_35_le__funE,axiom,
    ! [C1: $tType,B: $tType] :
      ( ord(C1)
     => ! [X: B,G: fun(B,C1),F: fun(B,C1)] :
          ( ord_less_eq(fun(B,C1),F,G)
         => ord_less_eq(C1,aa(B,C1,F,X),aa(B,C1,G,X)) ) ) ).

tff(fact_36_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y1: A,X1: A] :
          ( ord_less_eq(A,X1,Y1)
         => ( ord_less_eq(A,Y1,Z)
           => ord_less_eq(A,X1,Z) ) ) ) ).

tff(fact_37_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X1: A] :
          ( ord_less_eq(A,X1,Y1)
         => ( ord_less_eq(A,Y1,X1)
           => ( X1 = Y1 ) ) ) ) ).

tff(fact_38_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B1: A,A1: A] :
          ( ord_less_eq(A,A1,B1)
         => ( ( B1 = C )
           => ord_less_eq(A,A1,C) ) ) ) ).

tff(fact_39_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B1: A,A1: A] :
          ( ( A1 = B1 )
         => ( ord_less_eq(A,B1,C)
           => ord_less_eq(A,A1,C) ) ) ) ).

tff(fact_40_order__antisym__conv,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [X: B,Y: B] :
          ( ord_less_eq(B,Y,X)
         => ( ord_less_eq(B,X,Y)
          <=> ( X = Y ) ) ) ) ).

tff(fact_41_le__funD,axiom,
    ! [C1: $tType,B: $tType] :
      ( ord(C1)
     => ! [X: B,G: fun(B,C1),F: fun(B,C1)] :
          ( ord_less_eq(fun(B,C1),F,G)
         => ord_less_eq(C1,aa(B,C1,F,X),aa(B,C1,G,X)) ) ) ).

tff(fact_42_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X1: A] :
          ( ( X1 = Y1 )
         => ord_less_eq(A,X1,Y1) ) ) ).

tff(fact_43_order__eq__iff,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [Y: B,X: B] :
          ( ( X = Y )
        <=> ( ord_less_eq(B,X,Y)
            & ord_less_eq(B,Y,X) ) ) ) ).

tff(fact_44_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ord_less_eq(A,X1,Y1)
          | ord_less_eq(A,Y1,X1) ) ) ).

tff(fact_45_le__fun__def,axiom,
    ! [C1: $tType,B: $tType] :
      ( ord(C1)
     => ! [G: fun(B,C1),F: fun(B,C1)] :
          ( ord_less_eq(fun(B,C1),F,G)
        <=> ! [X2: B] : ord_less_eq(C1,aa(B,C1,F,X2),aa(B,C1,G,X2)) ) ) ).

tff(fact_46_zero__reorient,axiom,
    ! [B: $tType] :
      ( zero(B)
     => ! [X: B] :
          ( ( zero_zero(B) = X )
        <=> ( X = zero_zero(B) ) ) ) ).

tff(fact_47_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ~ ord_less(A,X1,Y1)
         => ( ( X1 != Y1 )
           => ord_less(A,Y1,X1) ) ) ) ).

tff(fact_48_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
         => ~ ord_less(A,Y1,X1) ) ) ).

tff(fact_49_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
         => ( ord_less(A,Y1,Z)
           => ord_less(A,X1,Z) ) ) ) ).

tff(fact_50_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ( ( B1 = C )
           => ord_less(A,A1,C) ) ) ) ).

tff(fact_51_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B1: A,A1: A] :
          ( ( A1 = B1 )
         => ( ord_less(A,B1,C)
           => ord_less(A,A1,C) ) ) ) ).

tff(fact_52_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ~ ord_less(A,B1,A1) ) ) ).

tff(fact_53_order__less__imp__triv,axiom,
    ! [B: $tType] :
      ( preorder(B)
     => ! [P: bool,Y: B,X: B] :
          ( ord_less(B,X,Y)
         => ( ord_less(B,Y,X)
           => pp(P) ) ) ) ).

tff(fact_54_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
         => ( Y1 != X1 ) ) ) ).

tff(fact_55_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
         => ( X1 != Y1 ) ) ) ).

tff(fact_56_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
         => ~ ord_less(A,Y1,X1) ) ) ).

tff(fact_57_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
         => ~ ord_less(A,Y1,X1) ) ) ).

tff(fact_58_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
         => ( X1 != Y1 ) ) ) ).

tff(fact_59_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ( X1 != Y1 )
         => ( ~ ord_less(A,X1,Y1)
           => ord_less(A,Y1,X1) ) ) ) ).

tff(fact_60_linorder__antisym__conv3,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [X: B,Y: B] :
          ( ~ ord_less(B,Y,X)
         => ( ~ ord_less(B,X,Y)
          <=> ( X = Y ) ) ) ) ).

tff(fact_61_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
          | ( X1 = Y1 )
          | ord_less(A,Y1,X1) ) ) ).

tff(fact_62_not__less__iff__gr__or__eq,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [Y: B,X: B] :
          ( ~ ord_less(B,X,Y)
        <=> ( ord_less(B,Y,X)
            | ( X = Y ) ) ) ) ).

tff(fact_63_linorder__neq__iff,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [Y: B,X: B] :
          ( ( X != Y )
        <=> ( ord_less(B,X,Y)
            | ord_less(B,Y,X) ) ) ) ).

tff(fact_64_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X1: A] : ~ ord_less(A,X1,X1) ) ).

tff(fact_65_nat__less__cases,axiom,
    ! [P: fun(nat,fun(nat,bool)),N1: nat,M1: nat] :
      ( ( ord_less(nat,M1,N1)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),M1)) )
     => ( ( ( M1 = N1 )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),M1)) )
       => ( ( ord_less(nat,N1,M1)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),M1)) ) ) ) ).

tff(fact_66_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_67_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( ord_less(nat,N,M)
     => ( M != N ) ) ).

tff(fact_68_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_69_linorder__neqE__nat,axiom,
    ! [Y1: nat,X1: nat] :
      ( ( X1 != Y1 )
     => ( ~ ord_less(nat,X1,Y1)
       => ord_less(nat,Y1,X1) ) ) ).

tff(fact_70_nat__neq__iff,axiom,
    ! [N1: nat,M1: nat] :
      ( ( M1 != N1 )
    <=> ( ord_less(nat,M1,N1)
        | ord_less(nat,N1,M1) ) ) ).

tff(fact_71_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_72_le__antisym,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
     => ( ord_less_eq(nat,N,M)
       => ( M = N ) ) ) ).

tff(fact_73_le__trans,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less_eq(nat,I,J)
     => ( ord_less_eq(nat,J,K)
       => ord_less_eq(nat,I,K) ) ) ).

tff(fact_74_mem__def,axiom,
    ! [B: $tType,A2: fun(B,bool),X: B] :
      ( member(B,X,A2)
    <=> pp(aa(B,bool,A2,X)) ) ).

tff(fact_75_eq__imp__le,axiom,
    ! [N: nat,M: nat] :
      ( ( M = N )
     => ord_less_eq(nat,M,N) ) ).

tff(fact_76_nat__le__linear,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
      | ord_less_eq(nat,N,M) ) ).

tff(fact_77_le__refl,axiom,
    ! [N: nat] : ord_less_eq(nat,N,N) ).

tff(fact_78_order__le__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y1: A,X1: A] :
          ( ord_less_eq(A,X1,Y1)
         => ( ord_less(A,Y1,Z)
           => ord_less(A,X1,Z) ) ) ) ).

tff(fact_79_order__less__le__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
         => ( ord_less_eq(A,Y1,Z)
           => ord_less(A,X1,Z) ) ) ) ).

tff(fact_80_order__le__neq__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B1: A,A1: A] :
          ( ord_less_eq(A,A1,B1)
         => ( ( A1 != B1 )
           => ord_less(A,A1,B1) ) ) ) ).

tff(fact_81_order__le__imp__less__or__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X1: A] :
          ( ord_less_eq(A,X1,Y1)
         => ( ord_less(A,X1,Y1)
            | ( X1 = Y1 ) ) ) ) ).

tff(fact_82_linorder__antisym__conv2,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [Y: B,X: B] :
          ( ord_less_eq(B,X,Y)
         => ( ~ ord_less(B,X,Y)
          <=> ( X = Y ) ) ) ) ).

tff(fact_83_order__less__imp__le,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
         => ord_less_eq(A,X1,Y1) ) ) ).

tff(fact_84_leD,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X1: A,Y1: A] :
          ( ord_less_eq(A,Y1,X1)
         => ~ ord_less(A,X1,Y1) ) ) ).

tff(fact_85_order__neq__le__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B1: A,A1: A] :
          ( ( A1 != B1 )
         => ( ord_less_eq(A,A1,B1)
           => ord_less(A,A1,B1) ) ) ) ).

tff(fact_86_linorder__antisym__conv1,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [Y: B,X: B] :
          ( ~ ord_less(B,X,Y)
         => ( ord_less_eq(B,X,Y)
          <=> ( X = Y ) ) ) ) ).

tff(fact_87_not__leE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X1: A,Y1: A] :
          ( ~ ord_less_eq(A,Y1,X1)
         => ord_less(A,X1,Y1) ) ) ).

tff(fact_88_leI,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ~ ord_less(A,X1,Y1)
         => ord_less_eq(A,Y1,X1) ) ) ).

tff(fact_89_order__le__less,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [Y: B,X: B] :
          ( ord_less_eq(B,X,Y)
        <=> ( ord_less(B,X,Y)
            | ( X = Y ) ) ) ) ).

tff(fact_90_less__le__not__le,axiom,
    ! [B: $tType] :
      ( preorder(B)
     => ! [Y: B,X: B] :
          ( ord_less(B,X,Y)
        <=> ( ord_less_eq(B,X,Y)
            & ~ ord_less_eq(B,Y,X) ) ) ) ).

tff(fact_91_order__less__le,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [Y: B,X: B] :
          ( ord_less(B,X,Y)
        <=> ( ord_less_eq(B,X,Y)
            & ( X != Y ) ) ) ) ).

tff(fact_92_linorder__le__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ord_less_eq(A,X1,Y1)
          | ord_less(A,Y1,X1) ) ) ).

tff(fact_93_linorder__not__le,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [Y: B,X: B] :
          ( ~ ord_less_eq(B,X,Y)
        <=> ord_less(B,Y,X) ) ) ).

tff(fact_94_linorder__not__less,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [Y: B,X: B] :
          ( ~ ord_less(B,X,Y)
        <=> ord_less_eq(B,Y,X) ) ) ).

tff(fact_95_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_96_gr__implies__not0,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ( N != zero_zero(nat) ) ) ).

tff(fact_97_not__less0,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_98_less__or__eq__imp__le,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less(nat,M,N)
        | ( M = N ) )
     => ord_less_eq(nat,M,N) ) ).

%----Arities (12)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    huffma1518433673istent(a1,t) ).

tff(conj_1,conjecture,
    huffma410068972_depth(a1,t,huffma1401021291ibling(a1,t,a)) = huffma410068972_depth(a1,t,a) ).

%------------------------------------------------------------------------------
