%------------------------------------------------------------------------------
% File     : SWW545_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Huffman's Algorithm line 1139
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla09] Blanchette (2009), Proof Pearl: Mechanizing the Textbo
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : huff_1139 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  187 (  54 unt;  45 typ;   0 def)
%            Number of atoms       :  284 (  99 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :  190 (  48   ~;  10   |;   9   &)
%                                         (  17 <=>; 106  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   5 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   37 (  22   >;  15   *;   0   +;   0  <<)
%            Number of predicates  :   15 (  13 usr;   1 prp; 0-3 aty)
%            Number of functors    :   29 (  29 usr;   7 con; 0-5 aty)
%            Number of variables   :  421 ( 377   !;   3   ?; 421   :)
%                                         (  41  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:21:35
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Huffman__Mirabelle__lalbadcutu_Otree,type,
    huffma1450048681e_tree: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat1: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (40)
tff(sy_cl_Lattices_Obounded__lattice,type,
    bounded_lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Osemilattice__inf,type,
    semilattice_inf: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Obounded__lattice__bot,type,
    bounded_lattice_bot: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B1: $tType,C1: $tType,A: $tType] : ( ( fun(B1,C1) * fun(A,B1) ) > fun(A,C1) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B1: $tType,C1: $tType] : ( ( fun(A,fun(B1,C1)) * B1 ) > fun(A,C1) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B1: $tType] : ( A > fun(B1,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B1: $tType,C1: $tType] : ( ( fun(A,fun(B1,C1)) * fun(A,B1) ) > fun(A,C1) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oalphabet,type,
    huffma675207370phabet: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > fun(A,bool) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oconsistent,type,
    huffma1518433673istent: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ocost,type,
    huffma1134658180e_cost: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat1 ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Odepth,type,
    huffma410068972_depth: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > nat1 ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ofreq,type,
    huffma1352802255e_freq: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > nat1 ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oheight,type,
    huffma945805758height: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat1 ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OInnerNode,type,
    huffma1146269203erNode: 
      !>[A: $tType] : ( ( nat1 * huffma1450048681e_tree(A) * huffma1450048681e_tree(A) ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OLeaf,type,
    huffma2021818691e_Leaf: 
      !>[A: $tType] : ( ( nat1 * A ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_Otree__case,type,
    huffma107959123e_case: 
      !>[A: $tType,T1: $tType] : ( ( fun(nat1,fun(A,T1)) * fun(nat1,fun(huffma1450048681e_tree(A),fun(huffma1450048681e_tree(A),T1))) * huffma1450048681e_tree(A) ) > T1 ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_OuniteTrees,type,
    huffma921447403eTrees: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * huffma1450048681e_tree(A) ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Lattices_Oinf__class_Oinf,type,
    inf_inf: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat1 ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa1: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,B1) * A ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_aa,type,
    aa: a ).

tff(sy_v_nat,type,
    nat: nat1 ).

tff(sy_v_t_092_060_094isub_0621,type,
    t_1: huffma1450048681e_tree(a) ).

tff(sy_v_t_092_060_094isub_0622,type,
    t_2: huffma1450048681e_tree(a) ).

%----Relevant facts (99)
tff(fact_0_tree_Osimps_I1_J,axiom,
    ! [B1: $tType,A4: B1,Nat4: nat1,Aa: B1,Nat1: nat1] :
      ( ( huffma2021818691e_Leaf(B1,Nat1,Aa) = huffma2021818691e_Leaf(B1,Nat4,A4) )
    <=> ( ( Nat1 = Nat4 )
        & ( Aa = A4 ) ) ) ).

tff(fact_1_consistent_Osimps_I1_J,axiom,
    ! [A: $tType,A2: A,W: nat1] : huffma1518433673istent(A,huffma2021818691e_Leaf(A,W,A2)) ).

tff(fact_2_height_Osimps_I1_J,axiom,
    ! [A: $tType,A2: A,W: nat1] : ( huffma945805758height(A,huffma2021818691e_Leaf(A,W,A2)) = zero_zero(nat1) ) ).

tff(fact_3_inf__bot__left,axiom,
    ! [A: $tType] :
      ( bounded_lattice_bot(A)
     => ! [X: A] : ( inf_inf(A,bot_bot(A),X) = bot_bot(A) ) ) ).

tff(fact_4_inf__bot__right,axiom,
    ! [A: $tType] :
      ( bounded_lattice_bot(A)
     => ! [X: A] : ( inf_inf(A,X,bot_bot(A)) = bot_bot(A) ) ) ).

tff(fact_5_consistent__uniteTrees,axiom,
    ! [B1: $tType,T_21: huffma1450048681e_tree(B1),T_11: huffma1450048681e_tree(B1)] :
      ( huffma1518433673istent(B1,T_11)
     => ( huffma1518433673istent(B1,T_21)
       => ( ( inf_inf(fun(B1,bool),huffma675207370phabet(B1,T_11),huffma675207370phabet(B1,T_21)) = bot_bot(fun(B1,bool)) )
         => huffma1518433673istent(B1,huffma921447403eTrees(B1,T_11,T_21)) ) ) ) ).

tff(fact_6_tree_Osize_I3_J,axiom,
    ! [A: $tType,A2: A,Nat3: nat1] : ( size_size(huffma1450048681e_tree(A),huffma2021818691e_Leaf(A,Nat3,A2)) = zero_zero(nat1) ) ).

tff(fact_7_Int__iff,axiom,
    ! [B1: $tType,B3: fun(B1,bool),A1: fun(B1,bool),C4: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C4),inf_inf(fun(B1,bool),A1,B3)))
    <=> ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C4),A1))
        & pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C4),B3)) ) ) ).

tff(fact_8_inf1I,axiom,
    ! [B1: $tType,B3: fun(B1,bool),X1: B1,A1: fun(B1,bool)] :
      ( pp(aa1(B1,bool,A1,X1))
     => ( pp(aa1(B1,bool,B3,X1))
       => pp(aa1(B1,bool,inf_inf(fun(B1,bool),A1,B3),X1)) ) ) ).

tff(fact_9_IntI,axiom,
    ! [B1: $tType,B3: fun(B1,bool),A1: fun(B1,bool),C4: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C4),A1))
     => ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C4),B3))
       => pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C4),inf_inf(fun(B1,bool),A1,B3))) ) ) ).

tff(fact_10_IntE,axiom,
    ! [B1: $tType,B3: fun(B1,bool),A1: fun(B1,bool),C4: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C4),inf_inf(fun(B1,bool),A1,B3)))
     => ~ ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C4),A1))
         => ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C4),B3)) ) ) ).

tff(fact_11_inf1E,axiom,
    ! [B1: $tType,X1: B1,B3: fun(B1,bool),A1: fun(B1,bool)] :
      ( pp(aa1(B1,bool,inf_inf(fun(B1,bool),A1,B3),X1))
     => ~ ( pp(aa1(B1,bool,A1,X1))
         => ~ pp(aa1(B1,bool,B3,X1)) ) ) ).

tff(fact_12_inf_Oleft__idem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [B2: A,A2: A] : ( inf_inf(A,A2,inf_inf(A,A2,B2)) = inf_inf(A,A2,B2) ) ) ).

tff(fact_13_inf__left__idem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Y: A,X: A] : ( inf_inf(A,X,inf_inf(A,X,Y)) = inf_inf(A,X,Y) ) ) ).

tff(fact_14_all__not__in__conv,axiom,
    ! [B1: $tType,A1: fun(B1,bool)] :
      ( ! [X4: B1] : ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),X4),A1))
    <=> ( A1 = bot_bot(fun(B1,bool)) ) ) ).

tff(fact_15_emptyE,axiom,
    ! [B1: $tType,Aa: B1] : ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa),bot_bot(fun(B1,bool)))) ).

tff(fact_16_Collect__empty__eq,axiom,
    ! [B1: $tType,Pa: fun(B1,bool)] :
      ( ( collect(B1,Pa) = bot_bot(fun(B1,bool)) )
    <=> ! [X4: B1] : ~ pp(aa1(B1,bool,Pa,X4)) ) ).

tff(fact_17_empty__iff,axiom,
    ! [B1: $tType,C4: B1] : ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C4),bot_bot(fun(B1,bool)))) ).

tff(fact_18_empty__Collect__eq,axiom,
    ! [B1: $tType,Pa: fun(B1,bool)] :
      ( ( bot_bot(fun(B1,bool)) = collect(B1,Pa) )
    <=> ! [X4: B1] : ~ pp(aa1(B1,bool,Pa,X4)) ) ).

tff(fact_19_equals0D,axiom,
    ! [B1: $tType,Aa: B1,A1: fun(B1,bool)] :
      ( ( A1 = bot_bot(fun(B1,bool)) )
     => ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa),A1)) ) ).

tff(fact_20_ex__in__conv,axiom,
    ! [B1: $tType,A1: fun(B1,bool)] :
      ( ? [X4: B1] : pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),X4),A1))
    <=> ( A1 != bot_bot(fun(B1,bool)) ) ) ).

tff(fact_21_empty__def,axiom,
    ! [B1: $tType] : ( bot_bot(fun(B1,bool)) = collect(B1,combk(bool,B1,fFalse)) ) ).

tff(fact_22_bot__empty__eq,axiom,
    ! [B1: $tType,X3: B1] :
      ( pp(aa1(B1,bool,bot_bot(fun(B1,bool)),X3))
    <=> pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),X3),bot_bot(fun(B1,bool)))) ) ).

tff(fact_23_inf__assoc,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Z: A,Y: A,X: A] : ( inf_inf(A,inf_inf(A,X,Y),Z) = inf_inf(A,X,inf_inf(A,Y,Z)) ) ) ).

tff(fact_24_inf__sup__aci_I2_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z: A,Y: A,X: A] : ( inf_inf(A,inf_inf(A,X,Y),Z) = inf_inf(A,X,inf_inf(A,Y,Z)) ) ) ).

tff(fact_25_inf_Oassoc,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [C2: A,B2: A,A2: A] : ( inf_inf(A,inf_inf(A,A2,B2),C2) = inf_inf(A,A2,inf_inf(A,B2,C2)) ) ) ).

tff(fact_26_inf__left__commute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Z: A,Y: A,X: A] : ( inf_inf(A,X,inf_inf(A,Y,Z)) = inf_inf(A,Y,inf_inf(A,X,Z)) ) ) ).

tff(fact_27_inf__sup__aci_I3_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z: A,Y: A,X: A] : ( inf_inf(A,X,inf_inf(A,Y,Z)) = inf_inf(A,Y,inf_inf(A,X,Z)) ) ) ).

tff(fact_28_inf_Oleft__commute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [C2: A,A2: A,B2: A] : ( inf_inf(A,B2,inf_inf(A,A2,C2)) = inf_inf(A,A2,inf_inf(A,B2,C2)) ) ) ).

tff(fact_29_inf__sup__aci_I4_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X: A] : ( inf_inf(A,X,inf_inf(A,X,Y)) = inf_inf(A,X,Y) ) ) ).

tff(fact_30_inf__commute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Y: A,X: A] : ( inf_inf(A,X,Y) = inf_inf(A,Y,X) ) ) ).

tff(fact_31_inf__sup__aci_I1_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X: A] : ( inf_inf(A,X,Y) = inf_inf(A,Y,X) ) ) ).

tff(fact_32_inf_Ocommute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [B2: A,A2: A] : ( inf_inf(A,A2,B2) = inf_inf(A,B2,A2) ) ) ).

tff(fact_33_inf__idem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [X: A] : ( inf_inf(A,X,X) = X ) ) ).

tff(fact_34_inf_Oidem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [A2: A] : ( inf_inf(A,A2,A2) = A2 ) ) ).

tff(fact_35_inf1D2,axiom,
    ! [B1: $tType,X1: B1,B3: fun(B1,bool),A1: fun(B1,bool)] :
      ( pp(aa1(B1,bool,inf_inf(fun(B1,bool),A1,B3),X1))
     => pp(aa1(B1,bool,B3,X1)) ) ).

tff(fact_36_inf1D1,axiom,
    ! [B1: $tType,X1: B1,B3: fun(B1,bool),A1: fun(B1,bool)] :
      ( pp(aa1(B1,bool,inf_inf(fun(B1,bool),A1,B3),X1))
     => pp(aa1(B1,bool,A1,X1)) ) ).

tff(fact_37_IntD2,axiom,
    ! [B1: $tType,B3: fun(B1,bool),A1: fun(B1,bool),C4: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C4),inf_inf(fun(B1,bool),A1,B3)))
     => pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C4),B3)) ) ).

tff(fact_38_IntD1,axiom,
    ! [B1: $tType,B3: fun(B1,bool),A1: fun(B1,bool),C4: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C4),inf_inf(fun(B1,bool),A1,B3)))
     => pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C4),A1)) ) ).

tff(fact_39_Int__assoc,axiom,
    ! [B1: $tType,C3: fun(B1,bool),B3: fun(B1,bool),A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),inf_inf(fun(B1,bool),A1,B3),C3) = inf_inf(fun(B1,bool),A1,inf_inf(fun(B1,bool),B3,C3)) ) ).

tff(fact_40_Int__left__commute,axiom,
    ! [B1: $tType,C3: fun(B1,bool),B3: fun(B1,bool),A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A1,inf_inf(fun(B1,bool),B3,C3)) = inf_inf(fun(B1,bool),B3,inf_inf(fun(B1,bool),A1,C3)) ) ).

tff(fact_41_Int__left__absorb,axiom,
    ! [B1: $tType,B3: fun(B1,bool),A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A1,inf_inf(fun(B1,bool),A1,B3)) = inf_inf(fun(B1,bool),A1,B3) ) ).

tff(fact_42_Int__commute,axiom,
    ! [B1: $tType,B3: fun(B1,bool),A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A1,B3) = inf_inf(fun(B1,bool),B3,A1) ) ).

tff(fact_43_Int__def,axiom,
    ! [B1: $tType,B3: fun(B1,bool),A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A1,B3) = collect(B1,combs(B1,bool,bool,combb(bool,fun(bool,bool),B1,fconj,combc(B1,fun(B1,bool),bool,member(B1),A1)),combc(B1,fun(B1,bool),bool,member(B1),B3))) ) ).

tff(fact_44_Int__absorb,axiom,
    ! [B1: $tType,A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A1,A1) = A1 ) ).

tff(fact_45_disjoint__iff__not__equal,axiom,
    ! [B1: $tType,B3: fun(B1,bool),A1: fun(B1,bool)] :
      ( ( inf_inf(fun(B1,bool),A1,B3) = bot_bot(fun(B1,bool)) )
    <=> ! [X4: B1] :
          ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),X4),A1))
         => ! [Xa: B1] :
              ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Xa),B3))
             => ( X4 != Xa ) ) ) ) ).

tff(fact_46_Int__empty__right,axiom,
    ! [B1: $tType,A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A1,bot_bot(fun(B1,bool))) = bot_bot(fun(B1,bool)) ) ).

tff(fact_47_Int__empty__left,axiom,
    ! [B1: $tType,B3: fun(B1,bool)] : ( inf_inf(fun(B1,bool),bot_bot(fun(B1,bool)),B3) = bot_bot(fun(B1,bool)) ) ).

tff(fact_48_inf__apply,axiom,
    ! [B1: $tType,C1: $tType] :
      ( lattice(B1)
     => ! [X1: C1,G: fun(C1,B1),F: fun(C1,B1)] : ( aa1(C1,B1,inf_inf(fun(C1,B1),F,G),X1) = inf_inf(B1,aa1(C1,B1,F,X1),aa1(C1,B1,G,X1)) ) ) ).

tff(fact_49_inf__fun__def,axiom,
    ! [C1: $tType,B1: $tType] :
      ( lattice(C1)
     => ! [G: fun(B1,C1),F: fun(B1,C1),X3: B1] : ( aa1(B1,C1,inf_inf(fun(B1,C1),F,G),X3) = inf_inf(C1,aa1(B1,C1,F,X3),aa1(B1,C1,G,X3)) ) ) ).

tff(fact_50_cost_Osimps_I1_J,axiom,
    ! [A: $tType,A2: A,W: nat1] : ( huffma1134658180e_cost(A,huffma2021818691e_Leaf(A,W,A2)) = zero_zero(nat1) ) ).

tff(fact_51_consistent_Osimps_I2_J,axiom,
    ! [B1: $tType,T_21: huffma1450048681e_tree(B1),T_11: huffma1450048681e_tree(B1),W1: nat1] :
      ( huffma1518433673istent(B1,huffma1146269203erNode(B1,W1,T_11,T_21))
    <=> ( huffma1518433673istent(B1,T_11)
        & huffma1518433673istent(B1,T_21)
        & ( inf_inf(fun(B1,bool),huffma675207370phabet(B1,T_11),huffma675207370phabet(B1,T_21)) = bot_bot(fun(B1,bool)) ) ) ) ).

tff(fact_52_bot__apply,axiom,
    ! [C1: $tType,B1: $tType] :
      ( bot(B1)
     => ! [X1: C1] : ( aa1(C1,B1,bot_bot(fun(C1,B1)),X1) = bot_bot(B1) ) ) ).

tff(fact_53_bot__fun__def,axiom,
    ! [B1: $tType,C1: $tType] :
      ( bot(C1)
     => ! [X3: B1] : ( aa1(B1,C1,bot_bot(fun(B1,C1)),X3) = bot_bot(C1) ) ) ).

tff(fact_54_freq__0__left,axiom,
    ! [B1: $tType,Aa: B1,T_21: huffma1450048681e_tree(B1),T_11: huffma1450048681e_tree(B1)] :
      ( ( inf_inf(fun(B1,bool),huffma675207370phabet(B1,T_11),huffma675207370phabet(B1,T_21)) = bot_bot(fun(B1,bool)) )
     => ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,T_21)))
       => ( huffma1352802255e_freq(B1,T_11,Aa) = zero_zero(nat1) ) ) ) ).

tff(fact_55_freq__0__right,axiom,
    ! [B1: $tType,Aa: B1,T_21: huffma1450048681e_tree(B1),T_11: huffma1450048681e_tree(B1)] :
      ( ( inf_inf(fun(B1,bool),huffma675207370phabet(B1,T_11),huffma675207370phabet(B1,T_21)) = bot_bot(fun(B1,bool)) )
     => ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,T_11)))
       => ( huffma1352802255e_freq(B1,T_21,Aa) = zero_zero(nat1) ) ) ) ).

tff(fact_56_depth_Osimps_I1_J,axiom,
    ! [A: $tType,A2: A,B2: A,W: nat1] : ( huffma410068972_depth(A,huffma2021818691e_Leaf(A,W,B2),A2) = zero_zero(nat1) ) ).

tff(fact_57_tree_Osimps_I2_J,axiom,
    ! [B1: $tType,Tree23: huffma1450048681e_tree(B1),Tree13: huffma1450048681e_tree(B1),Nat4: nat1,Tree21: huffma1450048681e_tree(B1),Tree11: huffma1450048681e_tree(B1),Nat1: nat1] :
      ( ( huffma1146269203erNode(B1,Nat1,Tree11,Tree21) = huffma1146269203erNode(B1,Nat4,Tree13,Tree23) )
    <=> ( ( Nat1 = Nat4 )
        & ( Tree11 = Tree13 )
        & ( Tree21 = Tree23 ) ) ) ).

tff(fact_58_freq_Osimps_I1_J,axiom,
    ! [A: $tType,W: nat1,A2: A,X3: A] :
      ( ( ( X3 = A2 )
       => ( huffma1352802255e_freq(A,huffma2021818691e_Leaf(A,W,A2),X3) = W ) )
      & ( ( X3 != A2 )
       => ( huffma1352802255e_freq(A,huffma2021818691e_Leaf(A,W,A2),X3) = zero_zero(nat1) ) ) ) ).

tff(fact_59_tree_Osimps_I3_J,axiom,
    ! [A: $tType,Tree22: huffma1450048681e_tree(A),Tree12: huffma1450048681e_tree(A),Nat2: nat1,A2: A,Nat3: nat1] : ( huffma2021818691e_Leaf(A,Nat3,A2) != huffma1146269203erNode(A,Nat2,Tree12,Tree22) ) ).

tff(fact_60_tree_Osimps_I4_J,axiom,
    ! [A: $tType,A2: A,Nat3: nat1,Tree22: huffma1450048681e_tree(A),Tree12: huffma1450048681e_tree(A),Nat2: nat1] : ( huffma1146269203erNode(A,Nat2,Tree12,Tree22) != huffma2021818691e_Leaf(A,Nat3,A2) ) ).

tff(fact_61_zero__reorient,axiom,
    ! [B1: $tType] :
      ( zero(B1)
     => ! [X1: B1] :
          ( ( zero_zero(B1) = X1 )
        <=> ( X1 = zero_zero(B1) ) ) ) ).

tff(fact_62_notin__alphabet__imp__freq__0,axiom,
    ! [B1: $tType,Ta: huffma1450048681e_tree(B1),Aa: B1] :
      ( ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,Ta)))
     => ( huffma1352802255e_freq(B1,Ta,Aa) = zero_zero(nat1) ) ) ).

tff(fact_63_height__0__imp__cost__0,axiom,
    ! [A: $tType,T: huffma1450048681e_tree(A)] :
      ( ( huffma945805758height(A,T) = zero_zero(nat1) )
     => ( huffma1134658180e_cost(A,T) = zero_zero(nat1) ) ) ).

tff(fact_64_exists__at__height,axiom,
    ! [B1: $tType,Ta: huffma1450048681e_tree(B1)] :
      ( huffma1518433673istent(B1,Ta)
     => ? [X2: B1] :
          ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),X2),huffma675207370phabet(B1,Ta)))
          & ( huffma410068972_depth(B1,Ta,X2) = huffma945805758height(B1,Ta) ) ) ) ).

tff(fact_65_tree_Osimps_I5_J,axiom,
    ! [B1: $tType,C1: $tType,Aa: C1,Nat1: nat1,F2: fun(nat1,fun(huffma1450048681e_tree(C1),fun(huffma1450048681e_tree(C1),B1))),F1: fun(nat1,fun(C1,B1))] : ( huffma107959123e_case(C1,B1,F1,F2,huffma2021818691e_Leaf(C1,Nat1,Aa)) = aa1(C1,B1,aa1(nat1,fun(C1,B1),F1,Nat1),Aa) ) ).

tff(fact_66_tree_Osimps_I6_J,axiom,
    ! [B1: $tType,C1: $tType,Tree21: huffma1450048681e_tree(C1),Tree11: huffma1450048681e_tree(C1),Nat1: nat1,F2: fun(nat1,fun(huffma1450048681e_tree(C1),fun(huffma1450048681e_tree(C1),B1))),F1: fun(nat1,fun(C1,B1))] : ( huffma107959123e_case(C1,B1,F1,F2,huffma1146269203erNode(C1,Nat1,Tree11,Tree21)) = aa1(huffma1450048681e_tree(C1),B1,aa1(huffma1450048681e_tree(C1),fun(huffma1450048681e_tree(C1),B1),aa1(nat1,fun(huffma1450048681e_tree(C1),fun(huffma1450048681e_tree(C1),B1)),F2,Nat1),Tree11),Tree21) ) ).

tff(fact_67_exists__in__alphabet,axiom,
    ! [B1: $tType,Ta: huffma1450048681e_tree(B1)] :
    ? [A3: B1] : pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),A3),huffma675207370phabet(B1,Ta))) ).

tff(fact_68_tree_Oexhaust,axiom,
    ! [A: $tType,Y: huffma1450048681e_tree(A)] :
      ( ! [Nat: nat1,A3: A] : ( Y != huffma2021818691e_Leaf(A,Nat,A3) )
     => ~ ! [Nat: nat1,Tree1: huffma1450048681e_tree(A),Tree2: huffma1450048681e_tree(A)] : ( Y != huffma1146269203erNode(A,Nat,Tree1,Tree2) ) ) ).

tff(fact_69_height__gt__0__alphabet__eq__imp__height__gt__0,axiom,
    ! [B1: $tType,U: huffma1450048681e_tree(B1),Ta: huffma1450048681e_tree(B1)] :
      ( ord_less(nat1,zero_zero(nat1),huffma945805758height(B1,Ta))
     => ( huffma1518433673istent(B1,Ta)
       => ( ( huffma675207370phabet(B1,Ta) = huffma675207370phabet(B1,U) )
         => ord_less(nat1,zero_zero(nat1),huffma945805758height(B1,U)) ) ) ) ).

tff(fact_70_less__infI2,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [A2: A,X: A,B2: A] :
          ( ord_less(A,B2,X)
         => ord_less(A,inf_inf(A,A2,B2),X) ) ) ).

tff(fact_71_less__infI1,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [B2: A,X: A,A2: A] :
          ( ord_less(A,A2,X)
         => ord_less(A,inf_inf(A,A2,B2),X) ) ) ).

tff(fact_72_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ~ ord_less(A,X,X) ) ).

tff(fact_73_linorder__neq__iff,axiom,
    ! [B1: $tType] :
      ( linorder(B1)
     => ! [Y1: B1,X1: B1] :
          ( ( X1 != Y1 )
        <=> ( ord_less(B1,X1,Y1)
            | ord_less(B1,Y1,X1) ) ) ) ).

tff(fact_74_ext,axiom,
    ! [C1: $tType,B1: $tType,G: fun(B1,C1),F: fun(B1,C1)] :
      ( ! [X2: B1] : ( aa1(B1,C1,F,X2) = aa1(B1,C1,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [B1: $tType,A1: fun(B1,bool),X1: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),X1),A1))
    <=> pp(aa1(B1,bool,A1,X1)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [B1: $tType,Pa: fun(B1,bool)] : ( collect(B1,Pa) = Pa ) ).

tff(fact_77_not__less__iff__gr__or__eq,axiom,
    ! [B1: $tType] :
      ( linorder(B1)
     => ! [Y1: B1,X1: B1] :
          ( ~ ord_less(B1,X1,Y1)
        <=> ( ord_less(B1,Y1,X1)
            | ( X1 = Y1 ) ) ) ) ).

tff(fact_78_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
          | ( X = Y )
          | ord_less(A,Y,X) ) ) ).

tff(fact_79_linorder__antisym__conv3,axiom,
    ! [B1: $tType] :
      ( linorder(B1)
     => ! [X1: B1,Y1: B1] :
          ( ~ ord_less(B1,Y1,X1)
         => ( ~ ord_less(B1,X1,Y1)
          <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_80_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ ord_less(A,X,Y)
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_81_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( X != Y ) ) ) ).

tff(fact_82_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_83_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_84_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( X != Y ) ) ) ).

tff(fact_85_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( Y != X ) ) ) ).

tff(fact_86_order__less__imp__triv,axiom,
    ! [B1: $tType] :
      ( preorder(B1)
     => ! [Pa: bool,Y1: B1,X1: B1] :
          ( ord_less(B1,X1,Y1)
         => ( ord_less(B1,Y1,X1)
           => pp(Pa) ) ) ) ).

tff(fact_87_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B2: A,A2: A] :
          ( ord_less(A,A2,B2)
         => ~ ord_less(A,B2,A2) ) ) ).

tff(fact_88_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A2: A] :
          ( ( A2 = B2 )
         => ( ord_less(A,B2,C2)
           => ord_less(A,A2,C2) ) ) ) ).

tff(fact_89_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A2: A] :
          ( ord_less(A,A2,B2)
         => ( ( B2 = C2 )
           => ord_less(A,A2,C2) ) ) ) ).

tff(fact_90_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( ord_less(A,Y,Z)
           => ord_less(A,X,Z) ) ) ) ).

tff(fact_91_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_92_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ ord_less(A,X,Y)
         => ( ( X != Y )
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_93_not__less__bot,axiom,
    ! [A: $tType] :
      ( bot(A)
     => ! [A2: A] : ~ ord_less(A,A2,bot_bot(A)) ) ).

tff(fact_94_bot__less,axiom,
    ! [B1: $tType] :
      ( bot(B1)
     => ! [Aa: B1] :
          ( ( Aa != bot_bot(B1) )
        <=> ord_less(B1,bot_bot(B1),Aa) ) ) ).

tff(fact_95_less__zeroE,axiom,
    ! [N1: nat1] : ~ ord_less(nat1,N1,zero_zero(nat1)) ).

tff(fact_96_less__nat__zero__code,axiom,
    ! [N1: nat1] : ~ ord_less(nat1,N1,zero_zero(nat1)) ).

tff(fact_97_neq0__conv,axiom,
    ! [N: nat1] :
      ( ( N != zero_zero(nat1) )
    <=> ord_less(nat1,zero_zero(nat1),N) ) ).

tff(fact_98_not__psubset__empty,axiom,
    ! [B1: $tType,A1: fun(B1,bool)] : ~ ord_less(fun(B1,bool),A1,bot_bot(fun(B1,bool))) ).

%----Arities (25)
tff(arity_HOL_Obool___Lattices_Obounded__lattice,axiom,
    bounded_lattice(bool) ).

tff(arity_fun___Lattices_Obounded__lattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bounded_lattice(T_2)
     => bounded_lattice(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Obounded__lattice__bot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bounded_lattice(T_2)
     => bounded_lattice_bot(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Osemilattice__inf,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => semilattice_inf(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Olattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => lattice(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Lattices_Osemilattice__inf,axiom,
    semilattice_inf(nat1) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat1) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat1) ).

tff(arity_Nat_Onat___Lattices_Olattice,axiom,
    lattice(nat1) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat1) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat1) ).

tff(arity_Nat_Onat___Orderings_Obot,axiom,
    bot(nat1) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat1) ).

tff(arity_HOL_Obool___Lattices_Obounded__lattice__bot,axiom,
    bounded_lattice_bot(bool) ).

tff(arity_HOL_Obool___Lattices_Osemilattice__inf,axiom,
    semilattice_inf(bool) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Lattices_Olattice,axiom,
    lattice(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (11)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C1: $tType,B1: $tType,A: $tType,R: A,Q: fun(A,B1),P: fun(B1,C1)] : ( aa1(A,C1,combb(B1,C1,A,P,Q),R) = aa1(B1,C1,P,aa1(A,B1,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C1: $tType,B1: $tType,R: A,Q: B1,P: fun(A,fun(B1,C1))] : ( aa1(A,C1,combc(A,B1,C1,P,Q),R) = aa1(B1,C1,aa1(A,fun(B1,C1),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B1: $tType,A: $tType,Q: B1,P: A] : ( aa1(B1,A,combk(A,B1,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C1: $tType,B1: $tType,A: $tType,R: A,Q: fun(A,B1),P: fun(A,fun(B1,C1))] : ( aa1(A,C1,combs(A,B1,C1,P,Q),R) = aa1(B1,C1,aa1(A,fun(B1,C1),P,R),aa1(A,B1,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa1(bool,bool,aa1(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa1(bool,bool,aa1(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa1(bool,bool,aa1(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (7)
tff(conj_0,hypothesis,
    huffma1518433673istent(a,t_1) ).

tff(conj_1,hypothesis,
    huffma1518433673istent(a,t_2) ).

tff(conj_2,hypothesis,
    inf_inf(fun(a,bool),huffma675207370phabet(a,t_1),huffma675207370phabet(a,t_2)) = bot_bot(fun(a,bool)) ).

tff(conj_3,hypothesis,
    ! [W_b: nat1,B: a] :
      ( ( t_1 = huffma2021818691e_Leaf(a,W_b,B) )
     => ! [W_c: nat1,C: a] :
          ( ( B = C )
          | ( t_2 != huffma2021818691e_Leaf(a,W_c,C) ) ) ) ).

tff(conj_4,hypothesis,
    ( ( huffma945805758height(a,t_1) = zero_zero(nat1) )
    & ( huffma945805758height(a,t_2) = zero_zero(nat1) ) ) ).

tff(conj_5,hypothesis,
    t_1 = huffma2021818691e_Leaf(a,nat,aa) ).

tff(conj_6,conjecture,
    $false ).

%------------------------------------------------------------------------------
