%------------------------------------------------------------------------------
% File     : SWW544_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Huffman's Algorithm line 1135
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla09] Blanchette (2009), Proof Pearl: Mechanizing the Textbo
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : huff_1135 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  180 (  51 unt;  41 typ;   0 def)
%            Number of atoms       :  299 ( 107 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  217 (  57   ~;  17   |;  19   &)
%                                         (  17 <=>; 107  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   5 avg)
%            Maximal term depth    :    6 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   32 (  20   >;  12   *;   0   +;   0  <<)
%            Number of predicates  :   13 (  12 usr;   0 prp; 1-3 aty)
%            Number of functors    :   26 (  26 usr;   6 con; 0-5 aty)
%            Number of variables   :  400 ( 362   !;   1   ?; 400   :)
%                                         (  37  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:20:44
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Huffman__Mirabelle__lalbadcutu_Otree,type,
    huffma1450048681e_tree: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (36)
tff(sy_cl_Lattices_Obounded__lattice,type,
    bounded_lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Osemilattice__inf,type,
    semilattice_inf: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Obounded__lattice__bot,type,
    bounded_lattice_bot: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B1: $tType,C1: $tType,A: $tType] : ( ( fun(B1,C1) * fun(A,B1) ) > fun(A,C1) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B1: $tType,C1: $tType] : ( ( fun(A,fun(B1,C1)) * B1 ) > fun(A,C1) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B1: $tType] : ( A > fun(B1,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B1: $tType,C1: $tType] : ( ( fun(A,fun(B1,C1)) * fun(A,B1) ) > fun(A,C1) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oalphabet,type,
    huffma675207370phabet: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > fun(A,bool) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oconsistent,type,
    huffma1518433673istent: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ocost,type,
    huffma1134658180e_cost: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oheight,type,
    huffma945805758height: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Osibling,type,
    huffma1401021291ibling: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > A ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OInnerNode,type,
    huffma1146269203erNode: 
      !>[A: $tType] : ( ( nat * huffma1450048681e_tree(A) * huffma1450048681e_tree(A) ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OLeaf,type,
    huffma2021818691e_Leaf: 
      !>[A: $tType] : ( ( nat * A ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_OuniteTrees,type,
    huffma921447403eTrees: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * huffma1450048681e_tree(A) ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Lattices_Oinf__class_Oinf,type,
    inf_inf: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,B1) * A ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_aa,type,
    aa1: a ).

tff(sy_v_tree1,type,
    tree1: huffma1450048681e_tree(a) ).

tff(sy_v_tree2,type,
    tree2: huffma1450048681e_tree(a) ).

%----Relevant facts (99)
tff(fact_0_tree_Osimps_I1_J,axiom,
    ! [B1: $tType,A3: B1,Nat3: nat,Aa: B1,Nat2: nat] :
      ( ( huffma2021818691e_Leaf(B1,Nat2,Aa) = huffma2021818691e_Leaf(B1,Nat3,A3) )
    <=> ( ( Nat2 = Nat3 )
        & ( Aa = A3 ) ) ) ).

tff(fact_1_consistent_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,W: nat] : huffma1518433673istent(A,huffma2021818691e_Leaf(A,W,A1)) ).

tff(fact_2_height_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,W: nat] : ( huffma945805758height(A,huffma2021818691e_Leaf(A,W,A1)) = zero_zero(nat) ) ).

tff(fact_3_sibling_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,B2: A,W_b1: nat] : ( huffma1401021291ibling(A,huffma2021818691e_Leaf(A,W_b1,B2),A1) = A1 ) ).

tff(fact_4_notin__alphabet__imp__sibling__id,axiom,
    ! [B1: $tType,Ta: huffma1450048681e_tree(B1),Aa: B1] :
      ( ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,Ta)))
     => ( huffma1401021291ibling(B1,Ta,Aa) = Aa ) ) ).

tff(fact_5_sibling__ne__imp__sibling__in__alphabet,axiom,
    ! [B1: $tType,Aa: B1,Ta: huffma1450048681e_tree(B1)] :
      ( ( huffma1401021291ibling(B1,Ta,Aa) != Aa )
     => pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),huffma1401021291ibling(B1,Ta,Aa)),huffma675207370phabet(B1,Ta))) ) ).

tff(fact_6_height__gt__0__alphabet__eq__imp__height__gt__0,axiom,
    ! [B1: $tType,U: huffma1450048681e_tree(B1),Ta: huffma1450048681e_tree(B1)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B1,Ta))
     => ( huffma1518433673istent(B1,Ta)
       => ( ( huffma675207370phabet(B1,Ta) = huffma675207370phabet(B1,U) )
         => ord_less(nat,zero_zero(nat),huffma945805758height(B1,U)) ) ) ) ).

tff(fact_7_in__alphabet__imp__sibling__in__alphabet,axiom,
    ! [B1: $tType,Ta: huffma1450048681e_tree(B1),Aa: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,Ta)))
     => pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),huffma1401021291ibling(B1,Ta,Aa)),huffma675207370phabet(B1,Ta))) ) ).

tff(fact_8_height__0__imp__sibling__id,axiom,
    ! [A: $tType,A1: A,T: huffma1450048681e_tree(A)] :
      ( ( huffma945805758height(A,T) = zero_zero(nat) )
     => ( huffma1401021291ibling(A,T,A1) = A1 ) ) ).

tff(fact_9_neq0__conv,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_10_less__nat__zero__code,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_11_less__zeroE,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_12_inf__bot__left,axiom,
    ! [A: $tType] :
      ( bounded_lattice_bot(A)
     => ! [X: A] : ( inf_inf(A,bot_bot(A),X) = bot_bot(A) ) ) ).

tff(fact_13_inf__bot__right,axiom,
    ! [A: $tType] :
      ( bounded_lattice_bot(A)
     => ! [X: A] : ( inf_inf(A,X,bot_bot(A)) = bot_bot(A) ) ) ).

tff(fact_14_consistent__uniteTrees,axiom,
    ! [B1: $tType,T_21: huffma1450048681e_tree(B1),T_11: huffma1450048681e_tree(B1)] :
      ( huffma1518433673istent(B1,T_11)
     => ( huffma1518433673istent(B1,T_21)
       => ( ( inf_inf(fun(B1,bool),huffma675207370phabet(B1,T_11),huffma675207370phabet(B1,T_21)) = bot_bot(fun(B1,bool)) )
         => huffma1518433673istent(B1,huffma921447403eTrees(B1,T_11,T_21)) ) ) ) ).

tff(fact_15_tree_Osize_I3_J,axiom,
    ! [A: $tType,A1: A,Nat1: nat] : ( size_size(huffma1450048681e_tree(A),huffma2021818691e_Leaf(A,Nat1,A1)) = zero_zero(nat) ) ).

tff(fact_16_Int__iff,axiom,
    ! [B1: $tType,B3: fun(B1,bool),A2: fun(B1,bool),C4: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C4),inf_inf(fun(B1,bool),A2,B3)))
    <=> ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C4),A2))
        & pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C4),B3)) ) ) ).

tff(fact_17_inf1I,axiom,
    ! [B1: $tType,B3: fun(B1,bool),X1: B1,A2: fun(B1,bool)] :
      ( pp(aa(B1,bool,A2,X1))
     => ( pp(aa(B1,bool,B3,X1))
       => pp(aa(B1,bool,inf_inf(fun(B1,bool),A2,B3),X1)) ) ) ).

tff(fact_18_IntI,axiom,
    ! [B1: $tType,B3: fun(B1,bool),A2: fun(B1,bool),C4: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C4),A2))
     => ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C4),B3))
       => pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C4),inf_inf(fun(B1,bool),A2,B3))) ) ) ).

tff(fact_19_IntE,axiom,
    ! [B1: $tType,B3: fun(B1,bool),A2: fun(B1,bool),C4: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C4),inf_inf(fun(B1,bool),A2,B3)))
     => ~ ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C4),A2))
         => ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C4),B3)) ) ) ).

tff(fact_20_inf1E,axiom,
    ! [B1: $tType,X1: B1,B3: fun(B1,bool),A2: fun(B1,bool)] :
      ( pp(aa(B1,bool,inf_inf(fun(B1,bool),A2,B3),X1))
     => ~ ( pp(aa(B1,bool,A2,X1))
         => ~ pp(aa(B1,bool,B3,X1)) ) ) ).

tff(fact_21_emptyE,axiom,
    ! [B1: $tType,Aa: B1] : ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),bot_bot(fun(B1,bool)))) ).

tff(fact_22_Collect__empty__eq,axiom,
    ! [B1: $tType,Pa: fun(B1,bool)] :
      ( ( collect(B1,Pa) = bot_bot(fun(B1,bool)) )
    <=> ! [X4: B1] : ~ pp(aa(B1,bool,Pa,X4)) ) ).

tff(fact_23_empty__iff,axiom,
    ! [B1: $tType,C4: B1] : ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C4),bot_bot(fun(B1,bool)))) ).

tff(fact_24_empty__Collect__eq,axiom,
    ! [B1: $tType,Pa: fun(B1,bool)] :
      ( ( bot_bot(fun(B1,bool)) = collect(B1,Pa) )
    <=> ! [X4: B1] : ~ pp(aa(B1,bool,Pa,X4)) ) ).

tff(fact_25_all__not__in__conv,axiom,
    ! [B1: $tType,A2: fun(B1,bool)] :
      ( ! [X4: B1] : ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),X4),A2))
    <=> ( A2 = bot_bot(fun(B1,bool)) ) ) ).

tff(fact_26_inf__left__idem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Y: A,X: A] : ( inf_inf(A,X,inf_inf(A,X,Y)) = inf_inf(A,X,Y) ) ) ).

tff(fact_27_inf_Oleft__idem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [B2: A,A1: A] : ( inf_inf(A,A1,inf_inf(A,A1,B2)) = inf_inf(A,A1,B2) ) ) ).

tff(fact_28_bot__nat__def,axiom,
    bot_bot(nat) = zero_zero(nat) ).

tff(fact_29_equals0D,axiom,
    ! [B1: $tType,Aa: B1,A2: fun(B1,bool)] :
      ( ( A2 = bot_bot(fun(B1,bool)) )
     => ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),A2)) ) ).

tff(fact_30_ex__in__conv,axiom,
    ! [B1: $tType,A2: fun(B1,bool)] :
      ( ? [X4: B1] : pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),X4),A2))
    <=> ( A2 != bot_bot(fun(B1,bool)) ) ) ).

tff(fact_31_empty__def,axiom,
    ! [B1: $tType] : ( bot_bot(fun(B1,bool)) = collect(B1,combk(bool,B1,fFalse)) ) ).

tff(fact_32_bot__empty__eq,axiom,
    ! [B1: $tType,X2: B1] :
      ( pp(aa(B1,bool,bot_bot(fun(B1,bool)),X2))
    <=> pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),X2),bot_bot(fun(B1,bool)))) ) ).

tff(fact_33_inf__assoc,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Z: A,Y: A,X: A] : ( inf_inf(A,inf_inf(A,X,Y),Z) = inf_inf(A,X,inf_inf(A,Y,Z)) ) ) ).

tff(fact_34_inf__sup__aci_I2_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z: A,Y: A,X: A] : ( inf_inf(A,inf_inf(A,X,Y),Z) = inf_inf(A,X,inf_inf(A,Y,Z)) ) ) ).

tff(fact_35_inf_Oassoc,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [C2: A,B2: A,A1: A] : ( inf_inf(A,inf_inf(A,A1,B2),C2) = inf_inf(A,A1,inf_inf(A,B2,C2)) ) ) ).

tff(fact_36_inf__left__commute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Z: A,Y: A,X: A] : ( inf_inf(A,X,inf_inf(A,Y,Z)) = inf_inf(A,Y,inf_inf(A,X,Z)) ) ) ).

tff(fact_37_inf__sup__aci_I3_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z: A,Y: A,X: A] : ( inf_inf(A,X,inf_inf(A,Y,Z)) = inf_inf(A,Y,inf_inf(A,X,Z)) ) ) ).

tff(fact_38_inf_Oleft__commute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [C2: A,A1: A,B2: A] : ( inf_inf(A,B2,inf_inf(A,A1,C2)) = inf_inf(A,A1,inf_inf(A,B2,C2)) ) ) ).

tff(fact_39_inf__sup__aci_I4_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X: A] : ( inf_inf(A,X,inf_inf(A,X,Y)) = inf_inf(A,X,Y) ) ) ).

tff(fact_40_inf__commute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Y: A,X: A] : ( inf_inf(A,X,Y) = inf_inf(A,Y,X) ) ) ).

tff(fact_41_inf__sup__aci_I1_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X: A] : ( inf_inf(A,X,Y) = inf_inf(A,Y,X) ) ) ).

tff(fact_42_inf_Ocommute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [B2: A,A1: A] : ( inf_inf(A,A1,B2) = inf_inf(A,B2,A1) ) ) ).

tff(fact_43_inf__idem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [X: A] : ( inf_inf(A,X,X) = X ) ) ).

tff(fact_44_inf_Oidem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [A1: A] : ( inf_inf(A,A1,A1) = A1 ) ) ).

tff(fact_45_nat__less__cases,axiom,
    ! [Pa: fun(nat,fun(nat,bool)),N1: nat,M1: nat] :
      ( ( ord_less(nat,M1,N1)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),Pa,N1),M1)) )
     => ( ( ( M1 = N1 )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),Pa,N1),M1)) )
       => ( ( ord_less(nat,N1,M1)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),Pa,N1),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),Pa,N1),M1)) ) ) ) ).

tff(fact_46_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_47_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( ord_less(nat,N,M)
     => ( M != N ) ) ).

tff(fact_48_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_49_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_50_nat__neq__iff,axiom,
    ! [N1: nat,M1: nat] :
      ( ( M1 != N1 )
    <=> ( ord_less(nat,M1,N1)
        | ord_less(nat,N1,M1) ) ) ).

tff(fact_51_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_52_inf1D2,axiom,
    ! [B1: $tType,X1: B1,B3: fun(B1,bool),A2: fun(B1,bool)] :
      ( pp(aa(B1,bool,inf_inf(fun(B1,bool),A2,B3),X1))
     => pp(aa(B1,bool,B3,X1)) ) ).

tff(fact_53_inf1D1,axiom,
    ! [B1: $tType,X1: B1,B3: fun(B1,bool),A2: fun(B1,bool)] :
      ( pp(aa(B1,bool,inf_inf(fun(B1,bool),A2,B3),X1))
     => pp(aa(B1,bool,A2,X1)) ) ).

tff(fact_54_IntD2,axiom,
    ! [B1: $tType,B3: fun(B1,bool),A2: fun(B1,bool),C4: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C4),inf_inf(fun(B1,bool),A2,B3)))
     => pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C4),B3)) ) ).

tff(fact_55_IntD1,axiom,
    ! [B1: $tType,B3: fun(B1,bool),A2: fun(B1,bool),C4: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C4),inf_inf(fun(B1,bool),A2,B3)))
     => pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C4),A2)) ) ).

tff(fact_56_Int__assoc,axiom,
    ! [B1: $tType,C3: fun(B1,bool),B3: fun(B1,bool),A2: fun(B1,bool)] : ( inf_inf(fun(B1,bool),inf_inf(fun(B1,bool),A2,B3),C3) = inf_inf(fun(B1,bool),A2,inf_inf(fun(B1,bool),B3,C3)) ) ).

tff(fact_57_Int__left__commute,axiom,
    ! [B1: $tType,C3: fun(B1,bool),B3: fun(B1,bool),A2: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A2,inf_inf(fun(B1,bool),B3,C3)) = inf_inf(fun(B1,bool),B3,inf_inf(fun(B1,bool),A2,C3)) ) ).

tff(fact_58_Int__left__absorb,axiom,
    ! [B1: $tType,B3: fun(B1,bool),A2: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A2,inf_inf(fun(B1,bool),A2,B3)) = inf_inf(fun(B1,bool),A2,B3) ) ).

tff(fact_59_Int__commute,axiom,
    ! [B1: $tType,B3: fun(B1,bool),A2: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A2,B3) = inf_inf(fun(B1,bool),B3,A2) ) ).

tff(fact_60_Int__def,axiom,
    ! [B1: $tType,B3: fun(B1,bool),A2: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A2,B3) = collect(B1,combs(B1,bool,bool,combb(bool,fun(bool,bool),B1,fconj,combc(B1,fun(B1,bool),bool,member(B1),A2)),combc(B1,fun(B1,bool),bool,member(B1),B3))) ) ).

tff(fact_61_Int__absorb,axiom,
    ! [B1: $tType,A2: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A2,A2) = A2 ) ).

tff(fact_62_less__infI2,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [A1: A,X: A,B2: A] :
          ( ord_less(A,B2,X)
         => ord_less(A,inf_inf(A,A1,B2),X) ) ) ).

tff(fact_63_less__infI1,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [B2: A,X: A,A1: A] :
          ( ord_less(A,A1,X)
         => ord_less(A,inf_inf(A,A1,B2),X) ) ) ).

tff(fact_64_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_65_gr__implies__not0,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ( N != zero_zero(nat) ) ) ).

tff(fact_66_not__less0,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_67_disjoint__iff__not__equal,axiom,
    ! [B1: $tType,B3: fun(B1,bool),A2: fun(B1,bool)] :
      ( ( inf_inf(fun(B1,bool),A2,B3) = bot_bot(fun(B1,bool)) )
    <=> ! [X4: B1] :
          ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),X4),A2))
         => ! [Xa: B1] :
              ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Xa),B3))
             => ( X4 != Xa ) ) ) ) ).

tff(fact_68_Int__empty__right,axiom,
    ! [B1: $tType,A2: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A2,bot_bot(fun(B1,bool))) = bot_bot(fun(B1,bool)) ) ).

tff(fact_69_Int__empty__left,axiom,
    ! [B1: $tType,B3: fun(B1,bool)] : ( inf_inf(fun(B1,bool),bot_bot(fun(B1,bool)),B3) = bot_bot(fun(B1,bool)) ) ).

tff(fact_70_inf__apply,axiom,
    ! [B1: $tType,C1: $tType] :
      ( lattice(B1)
     => ! [X1: C1,G: fun(C1,B1),F: fun(C1,B1)] : ( aa(C1,B1,inf_inf(fun(C1,B1),F,G),X1) = inf_inf(B1,aa(C1,B1,F,X1),aa(C1,B1,G,X1)) ) ) ).

tff(fact_71_inf__fun__def,axiom,
    ! [C1: $tType,B1: $tType] :
      ( lattice(C1)
     => ! [G: fun(B1,C1),F: fun(B1,C1),X2: B1] : ( aa(B1,C1,inf_inf(fun(B1,C1),F,G),X2) = inf_inf(C1,aa(B1,C1,F,X2),aa(B1,C1,G,X2)) ) ) ).

tff(fact_72_cost_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,W: nat] : ( huffma1134658180e_cost(A,huffma2021818691e_Leaf(A,W,A1)) = zero_zero(nat) ) ).

tff(fact_73_consistent_Osimps_I2_J,axiom,
    ! [B1: $tType,T_21: huffma1450048681e_tree(B1),T_11: huffma1450048681e_tree(B1),W1: nat] :
      ( huffma1518433673istent(B1,huffma1146269203erNode(B1,W1,T_11,T_21))
    <=> ( huffma1518433673istent(B1,T_11)
        & huffma1518433673istent(B1,T_21)
        & ( inf_inf(fun(B1,bool),huffma675207370phabet(B1,T_11),huffma675207370phabet(B1,T_21)) = bot_bot(fun(B1,bool)) ) ) ) ).

tff(fact_74_ext,axiom,
    ! [C1: $tType,B1: $tType,G: fun(B1,C1),F: fun(B1,C1)] :
      ( ! [X3: B1] : ( aa(B1,C1,F,X3) = aa(B1,C1,G,X3) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [B1: $tType,A2: fun(B1,bool),X1: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),X1),A2))
    <=> pp(aa(B1,bool,A2,X1)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [B1: $tType,Pa: fun(B1,bool)] : ( collect(B1,Pa) = Pa ) ).

tff(fact_77_bot__apply,axiom,
    ! [C1: $tType,B1: $tType] :
      ( bot(B1)
     => ! [X1: C1] : ( aa(C1,B1,bot_bot(fun(C1,B1)),X1) = bot_bot(B1) ) ) ).

tff(fact_78_bot__fun__def,axiom,
    ! [B1: $tType,C1: $tType] :
      ( bot(C1)
     => ! [X2: B1] : ( aa(B1,C1,bot_bot(fun(B1,C1)),X2) = bot_bot(C1) ) ) ).

tff(fact_79_either__height__gt__0__imp__sibling,axiom,
    ! [B1: $tType,W1: nat,Aa: B1,T_21: huffma1450048681e_tree(B1),T_11: huffma1450048681e_tree(B1)] :
      ( ( ord_less(nat,zero_zero(nat),huffma945805758height(B1,T_11))
        | ord_less(nat,zero_zero(nat),huffma945805758height(B1,T_21)) )
     => ( ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,T_11)))
         => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W1,T_11,T_21),Aa) = huffma1401021291ibling(B1,T_11,Aa) ) )
        & ( ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,T_11)))
         => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W1,T_11,T_21),Aa) = huffma1401021291ibling(B1,T_21,Aa) ) ) ) ) ).

tff(fact_80_height__gt__0__in__alphabet__imp__sibling__right,axiom,
    ! [B1: $tType,W1: nat,T_11: huffma1450048681e_tree(B1),Aa: B1,T_21: huffma1450048681e_tree(B1)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B1,T_21))
     => ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,T_11)))
       => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W1,T_11,T_21),Aa) = huffma1401021291ibling(B1,T_11,Aa) ) ) ) ).

tff(fact_81_tree_Osimps_I2_J,axiom,
    ! [B1: $tType,Tree22: huffma1450048681e_tree(B1),Tree12: huffma1450048681e_tree(B1),Nat3: nat,Tree21: huffma1450048681e_tree(B1),Tree11: huffma1450048681e_tree(B1),Nat2: nat] :
      ( ( huffma1146269203erNode(B1,Nat2,Tree11,Tree21) = huffma1146269203erNode(B1,Nat3,Tree12,Tree22) )
    <=> ( ( Nat2 = Nat3 )
        & ( Tree11 = Tree12 )
        & ( Tree21 = Tree22 ) ) ) ).

tff(fact_82_sibling_Osimps_I4_J,axiom,
    ! [B1: $tType,Vb: huffma1450048681e_tree(B1),Va: huffma1450048681e_tree(B1),V: nat,W1: nat,T_11: huffma1450048681e_tree(B1),Aa: B1] :
      ( ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,T_11)))
       => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W1,T_11,huffma1146269203erNode(B1,V,Va,Vb)),Aa) = huffma1401021291ibling(B1,T_11,Aa) ) )
      & ( ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,T_11)))
       => ( ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,huffma1146269203erNode(B1,V,Va,Vb))))
           => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W1,T_11,huffma1146269203erNode(B1,V,Va,Vb)),Aa) = huffma1401021291ibling(B1,huffma1146269203erNode(B1,V,Va,Vb),Aa) ) )
          & ( ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,huffma1146269203erNode(B1,V,Va,Vb))))
           => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W1,T_11,huffma1146269203erNode(B1,V,Va,Vb)),Aa) = Aa ) ) ) ) ) ).

tff(fact_83_sibling_Osimps_I3_J,axiom,
    ! [B1: $tType,T_21: huffma1450048681e_tree(B1),W1: nat,Vb: huffma1450048681e_tree(B1),Va: huffma1450048681e_tree(B1),V: nat,Aa: B1] :
      ( ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,huffma1146269203erNode(B1,V,Va,Vb))))
       => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W1,huffma1146269203erNode(B1,V,Va,Vb),T_21),Aa) = huffma1401021291ibling(B1,huffma1146269203erNode(B1,V,Va,Vb),Aa) ) )
      & ( ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,huffma1146269203erNode(B1,V,Va,Vb))))
       => ( ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,T_21)))
           => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W1,huffma1146269203erNode(B1,V,Va,Vb),T_21),Aa) = huffma1401021291ibling(B1,T_21,Aa) ) )
          & ( ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,T_21)))
           => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W1,huffma1146269203erNode(B1,V,Va,Vb),T_21),Aa) = Aa ) ) ) ) ) ).

tff(fact_84_sibling_Osimps_I2_J,axiom,
    ! [A: $tType,C2: A,W_c1: nat,W_b1: nat,W: nat,B2: A,A1: A] :
      ( ( ( A1 = B2 )
       => ( huffma1401021291ibling(A,huffma1146269203erNode(A,W,huffma2021818691e_Leaf(A,W_b1,B2),huffma2021818691e_Leaf(A,W_c1,C2)),A1) = C2 ) )
      & ( ( A1 != B2 )
       => ( ( ( A1 = C2 )
           => ( huffma1401021291ibling(A,huffma1146269203erNode(A,W,huffma2021818691e_Leaf(A,W_b1,B2),huffma2021818691e_Leaf(A,W_c1,C2)),A1) = B2 ) )
          & ( ( A1 != C2 )
           => ( huffma1401021291ibling(A,huffma1146269203erNode(A,W,huffma2021818691e_Leaf(A,W_b1,B2),huffma2021818691e_Leaf(A,W_c1,C2)),A1) = A1 ) ) ) ) ) ).

tff(fact_85_not__psubset__empty,axiom,
    ! [B1: $tType,A2: fun(B1,bool)] : ~ ord_less(fun(B1,bool),A2,bot_bot(fun(B1,bool))) ).

tff(fact_86_tree_Osimps_I3_J,axiom,
    ! [A: $tType,Tree2: huffma1450048681e_tree(A),Tree1: huffma1450048681e_tree(A),Nat: nat,A1: A,Nat1: nat] : ( huffma2021818691e_Leaf(A,Nat1,A1) != huffma1146269203erNode(A,Nat,Tree1,Tree2) ) ).

tff(fact_87_tree_Osimps_I4_J,axiom,
    ! [A: $tType,A1: A,Nat1: nat,Tree2: huffma1450048681e_tree(A),Tree1: huffma1450048681e_tree(A),Nat: nat] : ( huffma1146269203erNode(A,Nat,Tree1,Tree2) != huffma2021818691e_Leaf(A,Nat1,A1) ) ).

tff(fact_88_zero__reorient,axiom,
    ! [B1: $tType] :
      ( zero(B1)
     => ! [X1: B1] :
          ( ( zero_zero(B1) = X1 )
        <=> ( X1 = zero_zero(B1) ) ) ) ).

tff(fact_89_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ~ ord_less(A,X,X) ) ).

tff(fact_90_linorder__neq__iff,axiom,
    ! [B1: $tType] :
      ( linorder(B1)
     => ! [Y1: B1,X1: B1] :
          ( ( X1 != Y1 )
        <=> ( ord_less(B1,X1,Y1)
            | ord_less(B1,Y1,X1) ) ) ) ).

tff(fact_91_not__less__iff__gr__or__eq,axiom,
    ! [B1: $tType] :
      ( linorder(B1)
     => ! [Y1: B1,X1: B1] :
          ( ~ ord_less(B1,X1,Y1)
        <=> ( ord_less(B1,Y1,X1)
            | ( X1 = Y1 ) ) ) ) ).

tff(fact_92_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
          | ( X = Y )
          | ord_less(A,Y,X) ) ) ).

tff(fact_93_linorder__antisym__conv3,axiom,
    ! [B1: $tType] :
      ( linorder(B1)
     => ! [X1: B1,Y1: B1] :
          ( ~ ord_less(B1,Y1,X1)
         => ( ~ ord_less(B1,X1,Y1)
          <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_94_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ ord_less(A,X,Y)
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_95_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( X != Y ) ) ) ).

tff(fact_96_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_97_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_98_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( X != Y ) ) ) ).

%----Arities (22)
tff(arity_HOL_Obool___Lattices_Obounded__lattice,axiom,
    bounded_lattice(bool) ).

tff(arity_fun___Lattices_Obounded__lattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bounded_lattice(T_2)
     => bounded_lattice(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Obounded__lattice__bot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bounded_lattice(T_2)
     => bounded_lattice_bot(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Osemilattice__inf,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => semilattice_inf(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Olattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => lattice(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Lattices_Osemilattice__inf,axiom,
    semilattice_inf(nat) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Lattices_Olattice,axiom,
    lattice(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Obot,axiom,
    bot(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Lattices_Obounded__lattice__bot,axiom,
    bounded_lattice_bot(bool) ).

tff(arity_HOL_Obool___Lattices_Osemilattice__inf,axiom,
    semilattice_inf(bool) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Lattices_Olattice,axiom,
    lattice(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (11)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C1: $tType,B1: $tType,A: $tType,R: A,Q: fun(A,B1),P: fun(B1,C1)] : ( aa(A,C1,combb(B1,C1,A,P,Q),R) = aa(B1,C1,P,aa(A,B1,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C1: $tType,B1: $tType,R: A,Q: B1,P: fun(A,fun(B1,C1))] : ( aa(A,C1,combc(A,B1,C1,P,Q),R) = aa(B1,C1,aa(A,fun(B1,C1),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B1: $tType,A: $tType,Q: B1,P: A] : ( aa(B1,A,combk(A,B1,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C1: $tType,B1: $tType,A: $tType,R: A,Q: fun(A,B1),P: fun(A,fun(B1,C1))] : ( aa(A,C1,combs(A,B1,C1,P,Q),R) = aa(B1,C1,aa(A,fun(B1,C1),P,R),aa(A,B1,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (7)
tff(conj_0,hypothesis,
    huffma1518433673istent(a,tree1) ).

tff(conj_1,hypothesis,
    huffma1518433673istent(a,tree2) ).

tff(conj_2,hypothesis,
    inf_inf(fun(a,bool),huffma675207370phabet(a,tree1),huffma675207370phabet(a,tree2)) = bot_bot(fun(a,bool)) ).

tff(conj_3,hypothesis,
    ! [W_b: nat,B: a] :
      ( ( tree1 = huffma2021818691e_Leaf(a,W_b,B) )
     => ! [W_c: nat,C: a] :
          ( ( B = C )
          | ( tree2 != huffma2021818691e_Leaf(a,W_c,C) ) ) ) ).

tff(conj_4,hypothesis,
    ( pp(aa(fun(a,bool),bool,aa(a,fun(fun(a,bool),bool),member(a),huffma1401021291ibling(a,tree1,aa1)),huffma675207370phabet(a,tree1)))
   => ( pp(aa(fun(a,bool),bool,aa(a,fun(fun(a,bool),bool),member(a),aa1),huffma675207370phabet(a,tree1)))
     => ( ( ( huffma945805758height(a,tree1) = zero_zero(nat) )
          & ( huffma945805758height(a,tree2) = zero_zero(nat) ) )
        | pp(aa(fun(a,bool),bool,aa(a,fun(fun(a,bool),bool),member(a),aa1),huffma675207370phabet(a,tree2)))
        | pp(aa(fun(a,bool),bool,aa(a,fun(fun(a,bool),bool),member(a),huffma1401021291ibling(a,tree1,aa1)),huffma675207370phabet(a,tree2))) ) ) ) ).

tff(conj_5,hypothesis,
    ( ( ( huffma945805758height(a,tree1) = zero_zero(nat) )
      & ( huffma945805758height(a,tree2) = zero_zero(nat) ) )
    | pp(aa(fun(a,bool),bool,aa(a,fun(fun(a,bool),bool),member(a),aa1),huffma675207370phabet(a,tree1)))
    | pp(aa(fun(a,bool),bool,aa(a,fun(fun(a,bool),bool),member(a),aa1),huffma675207370phabet(a,tree2))) ) ).

tff(conj_6,conjecture,
    ( ( ord_less(nat,zero_zero(nat),huffma945805758height(a,tree1))
      | ord_less(nat,zero_zero(nat),huffma945805758height(a,tree2)) )
    & ~ pp(aa(fun(a,bool),bool,aa(a,fun(fun(a,bool),bool),member(a),aa1),huffma675207370phabet(a,tree1)))
    & ~ pp(aa(fun(a,bool),bool,aa(a,fun(fun(a,bool),bool),member(a),huffma1401021291ibling(a,tree2,aa1)),huffma675207370phabet(a,tree1)))
    & pp(aa(fun(a,bool),bool,aa(a,fun(fun(a,bool),bool),member(a),aa1),huffma675207370phabet(a,tree2)))
    & pp(aa(fun(a,bool),bool,aa(a,fun(fun(a,bool),bool),member(a),huffma1401021291ibling(a,tree2,aa1)),huffma675207370phabet(a,tree2))) ) ).

%------------------------------------------------------------------------------
