%------------------------------------------------------------------------------
% File     : SWW543_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Huffman's Algorithm line 1131
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla09] Blanchette (2009), Proof Pearl: Mechanizing the Textbo
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : huff_1131 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  176 (  49 unt;  40 typ;   0 def)
%            Number of atoms       :  306 ( 104 equ)
%            Maximal formula atoms :   11 (   1 avg)
%            Number of connectives :  229 (  59   ~;  14   |;  13   &)
%                                         (  18 <=>; 125  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :    6 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   34 (  21   >;  13   *;   0   +;   0  <<)
%            Number of predicates  :   13 (  12 usr;   0 prp; 1-3 aty)
%            Number of functors    :   25 (  25 usr;   5 con; 0-5 aty)
%            Number of variables   :  418 ( 381   !;   1   ?; 418   :)
%                                         (  36  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:27
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_t_a,type,
    a1: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Huffman__Mirabelle__lalbadcutu_Otree,type,
    huffma1450048681e_tree: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (35)
tff(sy_cl_Lattices_Obounded__lattice,type,
    bounded_lattice: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Lattices_Osemilattice__inf,type,
    semilattice_inf: 
      !>[A1: $tType] : $o ).

tff(sy_cl_Lattices_Obounded__lattice__bot,type,
    bounded_lattice_bot: 
      !>[A1: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B1: $tType,C1: $tType,A1: $tType] : ( ( fun(B1,C1) * fun(A1,B1) ) > fun(A1,C1) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A1: $tType,B1: $tType,C1: $tType] : ( ( fun(A1,fun(B1,C1)) * B1 ) > fun(A1,C1) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A1: $tType,B1: $tType] : ( A1 > fun(B1,A1) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A1: $tType,B1: $tType,C1: $tType] : ( ( fun(A1,fun(B1,C1)) * fun(A1,B1) ) > fun(A1,C1) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A1: $tType] : A1 ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oalphabet,type,
    huffma675207370phabet: 
      !>[A1: $tType] : ( huffma1450048681e_tree(A1) > fun(A1,bool) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oconsistent,type,
    huffma1518433673istent: 
      !>[A1: $tType] : ( huffma1450048681e_tree(A1) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ocost,type,
    huffma1134658180e_cost: 
      !>[A1: $tType] : ( huffma1450048681e_tree(A1) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oheight,type,
    huffma945805758height: 
      !>[A1: $tType] : ( huffma1450048681e_tree(A1) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Osibling,type,
    huffma1401021291ibling: 
      !>[A1: $tType] : ( ( huffma1450048681e_tree(A1) * A1 ) > A1 ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OInnerNode,type,
    huffma1146269203erNode: 
      !>[A1: $tType] : ( ( nat * huffma1450048681e_tree(A1) * huffma1450048681e_tree(A1) ) > huffma1450048681e_tree(A1) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OLeaf,type,
    huffma2021818691e_Leaf: 
      !>[A1: $tType] : ( ( nat * A1 ) > huffma1450048681e_tree(A1) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_OuniteTrees,type,
    huffma921447403eTrees: 
      !>[A1: $tType] : ( ( huffma1450048681e_tree(A1) * huffma1450048681e_tree(A1) ) > huffma1450048681e_tree(A1) ) ).

tff(sy_c_Lattices_Oinf__class_Oinf,type,
    inf_inf: 
      !>[A1: $tType] : ( ( A1 * A1 ) > A1 ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A1: $tType] : ( A1 > nat ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A1: $tType] : A1 ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A1: $tType] : ( ( A1 * A1 ) > $o ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A1: $tType] : ( fun(A1,bool) > fun(A1,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A1: $tType,B1: $tType] : ( ( fun(A1,B1) * A1 ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A1: $tType] : fun(A1,fun(fun(A1,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_P,type,
    p: ( huffma1450048681e_tree(a1) * a1 ) > $o ).

tff(sy_v_a,type,
    a: a1 ).

tff(sy_v_t,type,
    t: huffma1450048681e_tree(a1) ).

%----Relevant facts (99)
tff(fact_0_tree_Osimps_I2_J,axiom,
    ! [B1: $tType,Tree22: huffma1450048681e_tree(B1),Tree12: huffma1450048681e_tree(B1),Nat3: nat,Tree21: huffma1450048681e_tree(B1),Tree11: huffma1450048681e_tree(B1),Nat2: nat] :
      ( ( huffma1146269203erNode(B1,Nat2,Tree11,Tree21) = huffma1146269203erNode(B1,Nat3,Tree12,Tree22) )
    <=> ( ( Nat2 = Nat3 )
        & ( Tree11 = Tree12 )
        & ( Tree21 = Tree22 ) ) ) ).

tff(fact_1_tree_Osimps_I1_J,axiom,
    ! [B1: $tType,A4: B1,Nat3: nat,Aa: B1,Nat2: nat] :
      ( ( huffma2021818691e_Leaf(B1,Nat2,Aa) = huffma2021818691e_Leaf(B1,Nat3,A4) )
    <=> ( ( Nat2 = Nat3 )
        & ( Aa = A4 ) ) ) ).

tff(fact_2_consistent_Osimps_I1_J,axiom,
    ! [A1: $tType,A3: A1,W1: nat] : huffma1518433673istent(A1,huffma2021818691e_Leaf(A1,W1,A3)) ).

tff(fact_3_height_Osimps_I1_J,axiom,
    ! [A1: $tType,A3: A1,W1: nat] : ( huffma945805758height(A1,huffma2021818691e_Leaf(A1,W1,A3)) = zero_zero(nat) ) ).

tff(fact_4_sibling_Osimps_I4_J,axiom,
    ! [B1: $tType,Vb: huffma1450048681e_tree(B1),Va: huffma1450048681e_tree(B1),V: nat,W2: nat,T_12: huffma1450048681e_tree(B1),Aa: B1] :
      ( ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,T_12)))
       => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W2,T_12,huffma1146269203erNode(B1,V,Va,Vb)),Aa) = huffma1401021291ibling(B1,T_12,Aa) ) )
      & ( ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,T_12)))
       => ( ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,huffma1146269203erNode(B1,V,Va,Vb))))
           => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W2,T_12,huffma1146269203erNode(B1,V,Va,Vb)),Aa) = huffma1401021291ibling(B1,huffma1146269203erNode(B1,V,Va,Vb),Aa) ) )
          & ( ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,huffma1146269203erNode(B1,V,Va,Vb))))
           => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W2,T_12,huffma1146269203erNode(B1,V,Va,Vb)),Aa) = Aa ) ) ) ) ) ).

tff(fact_5_sibling_Osimps_I3_J,axiom,
    ! [B1: $tType,T_22: huffma1450048681e_tree(B1),W2: nat,Vb: huffma1450048681e_tree(B1),Va: huffma1450048681e_tree(B1),V: nat,Aa: B1] :
      ( ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,huffma1146269203erNode(B1,V,Va,Vb))))
       => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W2,huffma1146269203erNode(B1,V,Va,Vb),T_22),Aa) = huffma1401021291ibling(B1,huffma1146269203erNode(B1,V,Va,Vb),Aa) ) )
      & ( ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,huffma1146269203erNode(B1,V,Va,Vb))))
       => ( ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,T_22)))
           => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W2,huffma1146269203erNode(B1,V,Va,Vb),T_22),Aa) = huffma1401021291ibling(B1,T_22,Aa) ) )
          & ( ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,T_22)))
           => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W2,huffma1146269203erNode(B1,V,Va,Vb),T_22),Aa) = Aa ) ) ) ) ) ).

tff(fact_6_sibling_Osimps_I2_J,axiom,
    ! [A1: $tType,C4: A1,W_c1: nat,W_b1: nat,W1: nat,B3: A1,A3: A1] :
      ( ( ( A3 = B3 )
       => ( huffma1401021291ibling(A1,huffma1146269203erNode(A1,W1,huffma2021818691e_Leaf(A1,W_b1,B3),huffma2021818691e_Leaf(A1,W_c1,C4)),A3) = C4 ) )
      & ( ( A3 != B3 )
       => ( ( ( A3 = C4 )
           => ( huffma1401021291ibling(A1,huffma1146269203erNode(A1,W1,huffma2021818691e_Leaf(A1,W_b1,B3),huffma2021818691e_Leaf(A1,W_c1,C4)),A3) = B3 ) )
          & ( ( A3 != C4 )
           => ( huffma1401021291ibling(A1,huffma1146269203erNode(A1,W1,huffma2021818691e_Leaf(A1,W_b1,B3),huffma2021818691e_Leaf(A1,W_c1,C4)),A3) = A3 ) ) ) ) ) ).

tff(fact_7_consistent_Osimps_I2_J,axiom,
    ! [B1: $tType,T_22: huffma1450048681e_tree(B1),T_12: huffma1450048681e_tree(B1),W2: nat] :
      ( huffma1518433673istent(B1,huffma1146269203erNode(B1,W2,T_12,T_22))
    <=> ( huffma1518433673istent(B1,T_12)
        & huffma1518433673istent(B1,T_22)
        & ( inf_inf(fun(B1,bool),huffma675207370phabet(B1,T_12),huffma675207370phabet(B1,T_22)) = bot_bot(fun(B1,bool)) ) ) ) ).

tff(fact_8_tree_Osimps_I3_J,axiom,
    ! [A1: $tType,Tree2: huffma1450048681e_tree(A1),Tree1: huffma1450048681e_tree(A1),Nat1: nat,A3: A1,Nat: nat] : ( huffma2021818691e_Leaf(A1,Nat,A3) != huffma1146269203erNode(A1,Nat1,Tree1,Tree2) ) ).

tff(fact_9_tree_Osimps_I4_J,axiom,
    ! [A1: $tType,A3: A1,Nat: nat,Tree2: huffma1450048681e_tree(A1),Tree1: huffma1450048681e_tree(A1),Nat1: nat] : ( huffma1146269203erNode(A1,Nat1,Tree1,Tree2) != huffma2021818691e_Leaf(A1,Nat,A3) ) ).

tff(fact_10_sibling_Osimps_I1_J,axiom,
    ! [A1: $tType,A3: A1,B3: A1,W_b1: nat] : ( huffma1401021291ibling(A1,huffma2021818691e_Leaf(A1,W_b1,B3),A3) = A3 ) ).

tff(fact_11_notin__alphabet__imp__sibling__id,axiom,
    ! [B1: $tType,Ta: huffma1450048681e_tree(B1),Aa: B1] :
      ( ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,Ta)))
     => ( huffma1401021291ibling(B1,Ta,Aa) = Aa ) ) ).

tff(fact_12_sibling__ne__imp__sibling__in__alphabet,axiom,
    ! [B1: $tType,Aa: B1,Ta: huffma1450048681e_tree(B1)] :
      ( ( huffma1401021291ibling(B1,Ta,Aa) != Aa )
     => pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),huffma1401021291ibling(B1,Ta,Aa)),huffma675207370phabet(B1,Ta))) ) ).

tff(fact_13_height__gt__0__alphabet__eq__imp__height__gt__0,axiom,
    ! [B1: $tType,U: huffma1450048681e_tree(B1),Ta: huffma1450048681e_tree(B1)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B1,Ta))
     => ( huffma1518433673istent(B1,Ta)
       => ( ( huffma675207370phabet(B1,Ta) = huffma675207370phabet(B1,U) )
         => ord_less(nat,zero_zero(nat),huffma945805758height(B1,U)) ) ) ) ).

tff(fact_14_height__gt__0__notin__alphabet__imp__sibling__left,axiom,
    ! [B1: $tType,T_22: huffma1450048681e_tree(B1),W2: nat,Aa: B1,T_12: huffma1450048681e_tree(B1)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B1,T_12))
     => ( ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,T_12)))
       => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W2,T_12,T_22),Aa) = huffma1401021291ibling(B1,T_22,Aa) ) ) ) ).

tff(fact_15_height__gt__0__notin__alphabet__imp__sibling__right,axiom,
    ! [B1: $tType,W2: nat,T_12: huffma1450048681e_tree(B1),Aa: B1,T_22: huffma1450048681e_tree(B1)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B1,T_22))
     => ( ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,T_12)))
       => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W2,T_12,T_22),Aa) = huffma1401021291ibling(B1,T_22,Aa) ) ) ) ).

tff(fact_16_height__gt__0__in__alphabet__imp__sibling__left,axiom,
    ! [B1: $tType,T_22: huffma1450048681e_tree(B1),W2: nat,Aa: B1,T_12: huffma1450048681e_tree(B1)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B1,T_12))
     => ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,T_12)))
       => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W2,T_12,T_22),Aa) = huffma1401021291ibling(B1,T_12,Aa) ) ) ) ).

tff(fact_17_height__gt__0__in__alphabet__imp__sibling__right,axiom,
    ! [B1: $tType,W2: nat,T_12: huffma1450048681e_tree(B1),Aa: B1,T_22: huffma1450048681e_tree(B1)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B1,T_22))
     => ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,T_12)))
       => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W2,T_12,T_22),Aa) = huffma1401021291ibling(B1,T_12,Aa) ) ) ) ).

tff(fact_18_in__alphabet__imp__sibling__in__alphabet,axiom,
    ! [B1: $tType,Ta: huffma1450048681e_tree(B1),Aa: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,Ta)))
     => pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),huffma1401021291ibling(B1,Ta,Aa)),huffma675207370phabet(B1,Ta))) ) ).

tff(fact_19_height__0__imp__sibling__id,axiom,
    ! [A1: $tType,A3: A1,T: huffma1450048681e_tree(A1)] :
      ( ( huffma945805758height(A1,T) = zero_zero(nat) )
     => ( huffma1401021291ibling(A1,T,A3) = A3 ) ) ).

tff(fact_20_either__height__gt__0__imp__sibling,axiom,
    ! [B1: $tType,W2: nat,Aa: B1,T_22: huffma1450048681e_tree(B1),T_12: huffma1450048681e_tree(B1)] :
      ( ( ord_less(nat,zero_zero(nat),huffma945805758height(B1,T_12))
        | ord_less(nat,zero_zero(nat),huffma945805758height(B1,T_22)) )
     => ( ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,T_12)))
         => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W2,T_12,T_22),Aa) = huffma1401021291ibling(B1,T_12,Aa) ) )
        & ( ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),huffma675207370phabet(B1,T_12)))
         => ( huffma1401021291ibling(B1,huffma1146269203erNode(B1,W2,T_12,T_22),Aa) = huffma1401021291ibling(B1,T_22,Aa) ) ) ) ) ).

tff(fact_21_neq0__conv,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_22_less__nat__zero__code,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_23_less__zeroE,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_24_inf__bot__left,axiom,
    ! [A1: $tType] :
      ( bounded_lattice_bot(A1)
     => ! [X1: A1] : ( inf_inf(A1,bot_bot(A1),X1) = bot_bot(A1) ) ) ).

tff(fact_25_inf__bot__right,axiom,
    ! [A1: $tType] :
      ( bounded_lattice_bot(A1)
     => ! [X1: A1] : ( inf_inf(A1,X1,bot_bot(A1)) = bot_bot(A1) ) ) ).

tff(fact_26_consistent__uniteTrees,axiom,
    ! [B1: $tType,T_22: huffma1450048681e_tree(B1),T_12: huffma1450048681e_tree(B1)] :
      ( huffma1518433673istent(B1,T_12)
     => ( huffma1518433673istent(B1,T_22)
       => ( ( inf_inf(fun(B1,bool),huffma675207370phabet(B1,T_12),huffma675207370phabet(B1,T_22)) = bot_bot(fun(B1,bool)) )
         => huffma1518433673istent(B1,huffma921447403eTrees(B1,T_12,T_22)) ) ) ) ).

tff(fact_27_tree_Osize_I3_J,axiom,
    ! [A1: $tType,A3: A1,Nat: nat] : ( size_size(huffma1450048681e_tree(A1),huffma2021818691e_Leaf(A1,Nat,A3)) = zero_zero(nat) ) ).

tff(fact_28_Int__iff,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A2: fun(B1,bool),C3: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C3),inf_inf(fun(B1,bool),A2,B2)))
    <=> ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C3),A2))
        & pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C3),B2)) ) ) ).

tff(fact_29_inf1I,axiom,
    ! [B1: $tType,B2: fun(B1,bool),X: B1,A2: fun(B1,bool)] :
      ( pp(aa(B1,bool,A2,X))
     => ( pp(aa(B1,bool,B2,X))
       => pp(aa(B1,bool,inf_inf(fun(B1,bool),A2,B2),X)) ) ) ).

tff(fact_30_IntI,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A2: fun(B1,bool),C3: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C3),A2))
     => ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C3),B2))
       => pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C3),inf_inf(fun(B1,bool),A2,B2))) ) ) ).

tff(fact_31_IntE,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A2: fun(B1,bool),C3: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C3),inf_inf(fun(B1,bool),A2,B2)))
     => ~ ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C3),A2))
         => ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C3),B2)) ) ) ).

tff(fact_32_inf1E,axiom,
    ! [B1: $tType,X: B1,B2: fun(B1,bool),A2: fun(B1,bool)] :
      ( pp(aa(B1,bool,inf_inf(fun(B1,bool),A2,B2),X))
     => ~ ( pp(aa(B1,bool,A2,X))
         => ~ pp(aa(B1,bool,B2,X)) ) ) ).

tff(fact_33_emptyE,axiom,
    ! [B1: $tType,Aa: B1] : ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),bot_bot(fun(B1,bool)))) ).

tff(fact_34_Collect__empty__eq,axiom,
    ! [B1: $tType,Pa: fun(B1,bool)] :
      ( ( collect(B1,Pa) = bot_bot(fun(B1,bool)) )
    <=> ! [X3: B1] : ~ pp(aa(B1,bool,Pa,X3)) ) ).

tff(fact_35_empty__iff,axiom,
    ! [B1: $tType,C3: B1] : ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C3),bot_bot(fun(B1,bool)))) ).

tff(fact_36_empty__Collect__eq,axiom,
    ! [B1: $tType,Pa: fun(B1,bool)] :
      ( ( bot_bot(fun(B1,bool)) = collect(B1,Pa) )
    <=> ! [X3: B1] : ~ pp(aa(B1,bool,Pa,X3)) ) ).

tff(fact_37_all__not__in__conv,axiom,
    ! [B1: $tType,A2: fun(B1,bool)] :
      ( ! [X3: B1] : ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),X3),A2))
    <=> ( A2 = bot_bot(fun(B1,bool)) ) ) ).

tff(fact_38_inf__left__idem,axiom,
    ! [A1: $tType] :
      ( semilattice_inf(A1)
     => ! [Y1: A1,X1: A1] : ( inf_inf(A1,X1,inf_inf(A1,X1,Y1)) = inf_inf(A1,X1,Y1) ) ) ).

tff(fact_39_inf_Oleft__idem,axiom,
    ! [A1: $tType] :
      ( semilattice_inf(A1)
     => ! [B3: A1,A3: A1] : ( inf_inf(A1,A3,inf_inf(A1,A3,B3)) = inf_inf(A1,A3,B3) ) ) ).

tff(fact_40_bot__nat__def,axiom,
    bot_bot(nat) = zero_zero(nat) ).

tff(fact_41_equals0D,axiom,
    ! [B1: $tType,Aa: B1,A2: fun(B1,bool)] :
      ( ( A2 = bot_bot(fun(B1,bool)) )
     => ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Aa),A2)) ) ).

tff(fact_42_ex__in__conv,axiom,
    ! [B1: $tType,A2: fun(B1,bool)] :
      ( ? [X3: B1] : pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),X3),A2))
    <=> ( A2 != bot_bot(fun(B1,bool)) ) ) ).

tff(fact_43_empty__def,axiom,
    ! [B1: $tType] : ( bot_bot(fun(B1,bool)) = collect(B1,combk(bool,B1,fFalse)) ) ).

tff(fact_44_bot__empty__eq,axiom,
    ! [B1: $tType,X2: B1] :
      ( pp(aa(B1,bool,bot_bot(fun(B1,bool)),X2))
    <=> pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),X2),bot_bot(fun(B1,bool)))) ) ).

tff(fact_45_inf__assoc,axiom,
    ! [A1: $tType] :
      ( semilattice_inf(A1)
     => ! [Z: A1,Y1: A1,X1: A1] : ( inf_inf(A1,inf_inf(A1,X1,Y1),Z) = inf_inf(A1,X1,inf_inf(A1,Y1,Z)) ) ) ).

tff(fact_46_inf__sup__aci_I2_J,axiom,
    ! [A1: $tType] :
      ( lattice(A1)
     => ! [Z: A1,Y1: A1,X1: A1] : ( inf_inf(A1,inf_inf(A1,X1,Y1),Z) = inf_inf(A1,X1,inf_inf(A1,Y1,Z)) ) ) ).

tff(fact_47_inf_Oassoc,axiom,
    ! [A1: $tType] :
      ( semilattice_inf(A1)
     => ! [C4: A1,B3: A1,A3: A1] : ( inf_inf(A1,inf_inf(A1,A3,B3),C4) = inf_inf(A1,A3,inf_inf(A1,B3,C4)) ) ) ).

tff(fact_48_inf__left__commute,axiom,
    ! [A1: $tType] :
      ( semilattice_inf(A1)
     => ! [Z: A1,Y1: A1,X1: A1] : ( inf_inf(A1,X1,inf_inf(A1,Y1,Z)) = inf_inf(A1,Y1,inf_inf(A1,X1,Z)) ) ) ).

tff(fact_49_inf__sup__aci_I3_J,axiom,
    ! [A1: $tType] :
      ( lattice(A1)
     => ! [Z: A1,Y1: A1,X1: A1] : ( inf_inf(A1,X1,inf_inf(A1,Y1,Z)) = inf_inf(A1,Y1,inf_inf(A1,X1,Z)) ) ) ).

tff(fact_50_inf_Oleft__commute,axiom,
    ! [A1: $tType] :
      ( semilattice_inf(A1)
     => ! [C4: A1,A3: A1,B3: A1] : ( inf_inf(A1,B3,inf_inf(A1,A3,C4)) = inf_inf(A1,A3,inf_inf(A1,B3,C4)) ) ) ).

tff(fact_51_inf__sup__aci_I4_J,axiom,
    ! [A1: $tType] :
      ( lattice(A1)
     => ! [Y1: A1,X1: A1] : ( inf_inf(A1,X1,inf_inf(A1,X1,Y1)) = inf_inf(A1,X1,Y1) ) ) ).

tff(fact_52_inf__commute,axiom,
    ! [A1: $tType] :
      ( semilattice_inf(A1)
     => ! [Y1: A1,X1: A1] : ( inf_inf(A1,X1,Y1) = inf_inf(A1,Y1,X1) ) ) ).

tff(fact_53_inf__sup__aci_I1_J,axiom,
    ! [A1: $tType] :
      ( lattice(A1)
     => ! [Y1: A1,X1: A1] : ( inf_inf(A1,X1,Y1) = inf_inf(A1,Y1,X1) ) ) ).

tff(fact_54_inf_Ocommute,axiom,
    ! [A1: $tType] :
      ( semilattice_inf(A1)
     => ! [B3: A1,A3: A1] : ( inf_inf(A1,A3,B3) = inf_inf(A1,B3,A3) ) ) ).

tff(fact_55_inf__idem,axiom,
    ! [A1: $tType] :
      ( semilattice_inf(A1)
     => ! [X1: A1] : ( inf_inf(A1,X1,X1) = X1 ) ) ).

tff(fact_56_inf_Oidem,axiom,
    ! [A1: $tType] :
      ( semilattice_inf(A1)
     => ! [A3: A1] : ( inf_inf(A1,A3,A3) = A3 ) ) ).

tff(fact_57_nat__less__cases,axiom,
    ! [Pa: fun(nat,fun(nat,bool)),N1: nat,M1: nat] :
      ( ( ord_less(nat,M1,N1)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),Pa,N1),M1)) )
     => ( ( ( M1 = N1 )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),Pa,N1),M1)) )
       => ( ( ord_less(nat,N1,M1)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),Pa,N1),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),Pa,N1),M1)) ) ) ) ).

tff(fact_58_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_59_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( ord_less(nat,N,M)
     => ( M != N ) ) ).

tff(fact_60_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_61_linorder__neqE__nat,axiom,
    ! [Y1: nat,X1: nat] :
      ( ( X1 != Y1 )
     => ( ~ ord_less(nat,X1,Y1)
       => ord_less(nat,Y1,X1) ) ) ).

tff(fact_62_nat__neq__iff,axiom,
    ! [N1: nat,M1: nat] :
      ( ( M1 != N1 )
    <=> ( ord_less(nat,M1,N1)
        | ord_less(nat,N1,M1) ) ) ).

tff(fact_63_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_64_inf1D2,axiom,
    ! [B1: $tType,X: B1,B2: fun(B1,bool),A2: fun(B1,bool)] :
      ( pp(aa(B1,bool,inf_inf(fun(B1,bool),A2,B2),X))
     => pp(aa(B1,bool,B2,X)) ) ).

tff(fact_65_inf1D1,axiom,
    ! [B1: $tType,X: B1,B2: fun(B1,bool),A2: fun(B1,bool)] :
      ( pp(aa(B1,bool,inf_inf(fun(B1,bool),A2,B2),X))
     => pp(aa(B1,bool,A2,X)) ) ).

tff(fact_66_IntD2,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A2: fun(B1,bool),C3: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C3),inf_inf(fun(B1,bool),A2,B2)))
     => pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C3),B2)) ) ).

tff(fact_67_IntD1,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A2: fun(B1,bool),C3: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C3),inf_inf(fun(B1,bool),A2,B2)))
     => pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C3),A2)) ) ).

tff(fact_68_Int__assoc,axiom,
    ! [B1: $tType,C2: fun(B1,bool),B2: fun(B1,bool),A2: fun(B1,bool)] : ( inf_inf(fun(B1,bool),inf_inf(fun(B1,bool),A2,B2),C2) = inf_inf(fun(B1,bool),A2,inf_inf(fun(B1,bool),B2,C2)) ) ).

tff(fact_69_Int__left__commute,axiom,
    ! [B1: $tType,C2: fun(B1,bool),B2: fun(B1,bool),A2: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A2,inf_inf(fun(B1,bool),B2,C2)) = inf_inf(fun(B1,bool),B2,inf_inf(fun(B1,bool),A2,C2)) ) ).

tff(fact_70_Int__left__absorb,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A2: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A2,inf_inf(fun(B1,bool),A2,B2)) = inf_inf(fun(B1,bool),A2,B2) ) ).

tff(fact_71_Int__commute,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A2: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A2,B2) = inf_inf(fun(B1,bool),B2,A2) ) ).

tff(fact_72_Int__def,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A2: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A2,B2) = collect(B1,combs(B1,bool,bool,combb(bool,fun(bool,bool),B1,fconj,combc(B1,fun(B1,bool),bool,member(B1),A2)),combc(B1,fun(B1,bool),bool,member(B1),B2))) ) ).

tff(fact_73_Int__absorb,axiom,
    ! [B1: $tType,A2: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A2,A2) = A2 ) ).

tff(fact_74_less__infI2,axiom,
    ! [A1: $tType] :
      ( semilattice_inf(A1)
     => ! [A3: A1,X1: A1,B3: A1] :
          ( ord_less(A1,B3,X1)
         => ord_less(A1,inf_inf(A1,A3,B3),X1) ) ) ).

tff(fact_75_ext,axiom,
    ! [C1: $tType,B1: $tType,G: fun(B1,C1),F: fun(B1,C1)] :
      ( ! [X4: B1] : ( aa(B1,C1,F,X4) = aa(B1,C1,G,X4) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [B1: $tType,A2: fun(B1,bool),X: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),X),A2))
    <=> pp(aa(B1,bool,A2,X)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [B1: $tType,Pa: fun(B1,bool)] : ( collect(B1,Pa) = Pa ) ).

tff(fact_78_less__infI1,axiom,
    ! [A1: $tType] :
      ( semilattice_inf(A1)
     => ! [B3: A1,X1: A1,A3: A1] :
          ( ord_less(A1,A3,X1)
         => ord_less(A1,inf_inf(A1,A3,B3),X1) ) ) ).

tff(fact_79_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_80_gr__implies__not0,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ( N != zero_zero(nat) ) ) ).

tff(fact_81_not__less0,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_82_disjoint__iff__not__equal,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A2: fun(B1,bool)] :
      ( ( inf_inf(fun(B1,bool),A2,B2) = bot_bot(fun(B1,bool)) )
    <=> ! [X3: B1] :
          ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),X3),A2))
         => ! [Xa: B1] :
              ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),Xa),B2))
             => ( X3 != Xa ) ) ) ) ).

tff(fact_83_Int__empty__right,axiom,
    ! [B1: $tType,A2: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A2,bot_bot(fun(B1,bool))) = bot_bot(fun(B1,bool)) ) ).

tff(fact_84_Int__empty__left,axiom,
    ! [B1: $tType,B2: fun(B1,bool)] : ( inf_inf(fun(B1,bool),bot_bot(fun(B1,bool)),B2) = bot_bot(fun(B1,bool)) ) ).

tff(fact_85_inf__apply,axiom,
    ! [B1: $tType,C1: $tType] :
      ( lattice(B1)
     => ! [X: C1,G: fun(C1,B1),F: fun(C1,B1)] : ( aa(C1,B1,inf_inf(fun(C1,B1),F,G),X) = inf_inf(B1,aa(C1,B1,F,X),aa(C1,B1,G,X)) ) ) ).

tff(fact_86_inf__fun__def,axiom,
    ! [C1: $tType,B1: $tType] :
      ( lattice(C1)
     => ! [G: fun(B1,C1),F: fun(B1,C1),X2: B1] : ( aa(B1,C1,inf_inf(fun(B1,C1),F,G),X2) = inf_inf(C1,aa(B1,C1,F,X2),aa(B1,C1,G,X2)) ) ) ).

tff(fact_87_cost_Osimps_I1_J,axiom,
    ! [A1: $tType,A3: A1,W1: nat] : ( huffma1134658180e_cost(A1,huffma2021818691e_Leaf(A1,W1,A3)) = zero_zero(nat) ) ).

tff(fact_88_bot__apply,axiom,
    ! [C1: $tType,B1: $tType] :
      ( bot(B1)
     => ! [X: C1] : ( aa(C1,B1,bot_bot(fun(C1,B1)),X) = bot_bot(B1) ) ) ).

tff(fact_89_bot__fun__def,axiom,
    ! [B1: $tType,C1: $tType] :
      ( bot(C1)
     => ! [X2: B1] : ( aa(B1,C1,bot_bot(fun(B1,C1)),X2) = bot_bot(C1) ) ) ).

tff(fact_90_bot__less,axiom,
    ! [B1: $tType] :
      ( bot(B1)
     => ! [Aa: B1] :
          ( ( Aa != bot_bot(B1) )
        <=> ord_less(B1,bot_bot(B1),Aa) ) ) ).

tff(fact_91_not__less__bot,axiom,
    ! [A1: $tType] :
      ( bot(A1)
     => ! [A3: A1] : ~ ord_less(A1,A3,bot_bot(A1)) ) ).

tff(fact_92_not__psubset__empty,axiom,
    ! [B1: $tType,A2: fun(B1,bool)] : ~ ord_less(fun(B1,bool),A2,bot_bot(fun(B1,bool))) ).

tff(fact_93_zero__reorient,axiom,
    ! [B1: $tType] :
      ( zero(B1)
     => ! [X: B1] :
          ( ( zero_zero(B1) = X )
        <=> ( X = zero_zero(B1) ) ) ) ).

tff(fact_94_order__less__irrefl,axiom,
    ! [A1: $tType] :
      ( preorder(A1)
     => ! [X1: A1] : ~ ord_less(A1,X1,X1) ) ).

tff(fact_95_linorder__neq__iff,axiom,
    ! [B1: $tType] :
      ( linorder(B1)
     => ! [Y: B1,X: B1] :
          ( ( X != Y )
        <=> ( ord_less(B1,X,Y)
            | ord_less(B1,Y,X) ) ) ) ).

tff(fact_96_not__less__iff__gr__or__eq,axiom,
    ! [B1: $tType] :
      ( linorder(B1)
     => ! [Y: B1,X: B1] :
          ( ~ ord_less(B1,X,Y)
        <=> ( ord_less(B1,Y,X)
            | ( X = Y ) ) ) ) ).

tff(fact_97_linorder__less__linear,axiom,
    ! [A1: $tType] :
      ( linorder(A1)
     => ! [Y1: A1,X1: A1] :
          ( ord_less(A1,X1,Y1)
          | ( X1 = Y1 )
          | ord_less(A1,Y1,X1) ) ) ).

tff(fact_98_linorder__antisym__conv3,axiom,
    ! [B1: $tType] :
      ( linorder(B1)
     => ! [X: B1,Y: B1] :
          ( ~ ord_less(B1,Y,X)
         => ( ~ ord_less(B1,X,Y)
          <=> ( X = Y ) ) ) ) ).

%----Arities (19)
tff(arity_HOL_Obool___Lattices_Obounded__lattice,axiom,
    bounded_lattice(bool) ).

tff(arity_fun___Lattices_Obounded__lattice,axiom,
    ! [T_11: $tType,T_21: $tType] :
      ( bounded_lattice(T_21)
     => bounded_lattice(fun(T_11,T_21)) ) ).

tff(arity_fun___Lattices_Obounded__lattice__bot,axiom,
    ! [T_11: $tType,T_21: $tType] :
      ( bounded_lattice(T_21)
     => bounded_lattice_bot(fun(T_11,T_21)) ) ).

tff(arity_fun___Lattices_Osemilattice__inf,axiom,
    ! [T_11: $tType,T_21: $tType] :
      ( lattice(T_21)
     => semilattice_inf(fun(T_11,T_21)) ) ).

tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_11: $tType,T_21: $tType] :
      ( preorder(T_21)
     => preorder(fun(T_11,T_21)) ) ).

tff(arity_fun___Lattices_Olattice,axiom,
    ! [T_11: $tType,T_21: $tType] :
      ( lattice(T_21)
     => lattice(fun(T_11,T_21)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_11: $tType,T_21: $tType] :
      ( bot(T_21)
     => bot(fun(T_11,T_21)) ) ).

tff(arity_Nat_Onat___Lattices_Osemilattice__inf,axiom,
    semilattice_inf(nat) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Lattices_Olattice,axiom,
    lattice(nat) ).

tff(arity_Nat_Onat___Orderings_Obot,axiom,
    bot(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Lattices_Obounded__lattice__bot,axiom,
    bounded_lattice_bot(bool) ).

tff(arity_HOL_Obool___Lattices_Osemilattice__inf,axiom,
    semilattice_inf(bool) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Lattices_Olattice,axiom,
    lattice(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (11)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C1: $tType,B1: $tType,A1: $tType,R: A1,Q: fun(A1,B1),P: fun(B1,C1)] : ( aa(A1,C1,combb(B1,C1,A1,P,Q),R) = aa(B1,C1,P,aa(A1,B1,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A1: $tType,C1: $tType,B1: $tType,R: A1,Q: B1,P: fun(A1,fun(B1,C1))] : ( aa(A1,C1,combc(A1,B1,C1,P,Q),R) = aa(B1,C1,aa(A1,fun(B1,C1),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B1: $tType,A1: $tType,Q: B1,P: A1] : ( aa(B1,A1,combk(A1,B1,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C1: $tType,B1: $tType,A1: $tType,R: A1,Q: fun(A1,B1),P: fun(A1,fun(B1,C1))] : ( aa(A1,C1,combs(A1,B1,C1,P,Q),R) = aa(B1,C1,aa(A1,fun(B1,C1),P,R),aa(A1,B1,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (7)
tff(conj_0,hypothesis,
    ! [W: nat,B: a1,A: a1] : p(huffma2021818691e_Leaf(a1,W,B),A) ).

tff(conj_1,hypothesis,
    ! [W: nat,W_b: nat,B: a1,W_c: nat,C: a1,A: a1] :
      ( ( B != C )
     => p(huffma1146269203erNode(a1,W,huffma2021818691e_Leaf(a1,W_b,B),huffma2021818691e_Leaf(a1,W_c,C)),A) ) ).

tff(conj_2,hypothesis,
    ! [W: nat,T_1: huffma1450048681e_tree(a1),T_2: huffma1450048681e_tree(a1),A: a1] :
      ( huffma1518433673istent(a1,T_1)
     => ( huffma1518433673istent(a1,T_2)
       => ( ( inf_inf(fun(a1,bool),huffma675207370phabet(a1,T_1),huffma675207370phabet(a1,T_2)) = bot_bot(fun(a1,bool)) )
         => ( ( ord_less(nat,zero_zero(nat),huffma945805758height(a1,T_1))
              | ord_less(nat,zero_zero(nat),huffma945805758height(a1,T_2)) )
           => ( pp(aa(fun(a1,bool),bool,aa(a1,fun(fun(a1,bool),bool),member(a1),A),huffma675207370phabet(a1,T_1)))
             => ( pp(aa(fun(a1,bool),bool,aa(a1,fun(fun(a1,bool),bool),member(a1),huffma1401021291ibling(a1,T_1,A)),huffma675207370phabet(a1,T_1)))
               => ( ~ pp(aa(fun(a1,bool),bool,aa(a1,fun(fun(a1,bool),bool),member(a1),A),huffma675207370phabet(a1,T_2)))
                 => ( ~ pp(aa(fun(a1,bool),bool,aa(a1,fun(fun(a1,bool),bool),member(a1),huffma1401021291ibling(a1,T_1,A)),huffma675207370phabet(a1,T_2)))
                   => ( p(T_1,A)
                     => p(huffma1146269203erNode(a1,W,T_1,T_2),A) ) ) ) ) ) ) ) ) ) ).

tff(conj_3,hypothesis,
    ! [W: nat,T_1: huffma1450048681e_tree(a1),T_2: huffma1450048681e_tree(a1),A: a1] :
      ( huffma1518433673istent(a1,T_1)
     => ( huffma1518433673istent(a1,T_2)
       => ( ( inf_inf(fun(a1,bool),huffma675207370phabet(a1,T_1),huffma675207370phabet(a1,T_2)) = bot_bot(fun(a1,bool)) )
         => ( ( ord_less(nat,zero_zero(nat),huffma945805758height(a1,T_1))
              | ord_less(nat,zero_zero(nat),huffma945805758height(a1,T_2)) )
           => ( ~ pp(aa(fun(a1,bool),bool,aa(a1,fun(fun(a1,bool),bool),member(a1),A),huffma675207370phabet(a1,T_1)))
             => ( ~ pp(aa(fun(a1,bool),bool,aa(a1,fun(fun(a1,bool),bool),member(a1),huffma1401021291ibling(a1,T_2,A)),huffma675207370phabet(a1,T_1)))
               => ( pp(aa(fun(a1,bool),bool,aa(a1,fun(fun(a1,bool),bool),member(a1),A),huffma675207370phabet(a1,T_2)))
                 => ( pp(aa(fun(a1,bool),bool,aa(a1,fun(fun(a1,bool),bool),member(a1),huffma1401021291ibling(a1,T_2,A)),huffma675207370phabet(a1,T_2)))
                   => ( p(T_2,A)
                     => p(huffma1146269203erNode(a1,W,T_1,T_2),A) ) ) ) ) ) ) ) ) ) ).

tff(conj_4,hypothesis,
    ! [W: nat,T_1: huffma1450048681e_tree(a1),T_2: huffma1450048681e_tree(a1),A: a1] :
      ( huffma1518433673istent(a1,T_1)
     => ( huffma1518433673istent(a1,T_2)
       => ( ( inf_inf(fun(a1,bool),huffma675207370phabet(a1,T_1),huffma675207370phabet(a1,T_2)) = bot_bot(fun(a1,bool)) )
         => ( ( ord_less(nat,zero_zero(nat),huffma945805758height(a1,T_1))
              | ord_less(nat,zero_zero(nat),huffma945805758height(a1,T_2)) )
           => ( ~ pp(aa(fun(a1,bool),bool,aa(a1,fun(fun(a1,bool),bool),member(a1),A),huffma675207370phabet(a1,T_1)))
             => ( ~ pp(aa(fun(a1,bool),bool,aa(a1,fun(fun(a1,bool),bool),member(a1),A),huffma675207370phabet(a1,T_2)))
               => p(huffma1146269203erNode(a1,W,T_1,T_2),A) ) ) ) ) ) ) ).

tff(conj_5,hypothesis,
    huffma1518433673istent(a1,t) ).

tff(conj_6,conjecture,
    p(t,a) ).

%------------------------------------------------------------------------------
