%------------------------------------------------------------------------------
% File     : SWW541_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Huffman's Algorithm line 1027
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla09] Blanchette (2009), Proof Pearl: Mechanizing the Textbo
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : huff_1027 [Bla13]

% Status   : Theorem
% Rating   : 0.67 v9.1.0, 0.33 v7.5.0, 1.00 v7.4.0, 0.75 v7.1.0, 1.00 v6.4.0
% Syntax   : Number of formulae    :  171 (  55 unt;  41 typ;   0 def)
%            Number of atoms       :  279 (  91 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  188 (  39   ~;   5   |;  19   &)
%                                         (  27 <=>;  98  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   5 avg)
%            Maximal term depth    :   10 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   38 (  22   >;  16   *;   0   +;   0  <<)
%            Number of predicates  :   15 (  14 usr;   0 prp; 1-3 aty)
%            Number of functors    :   23 (  23 usr;   6 con; 0-5 aty)
%            Number of variables   :  323 ( 285   !;   7   ?; 323   :)
%                                         (  31  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:18:42
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_t_a,type,
    a1: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Huffman__Mirabelle__lalbadcutu_Otree,type,
    huffma1450048681e_tree: $tType > $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (35)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oalphabet,type,
    huffma675207370phabet: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > fun(A,bool) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oconsistent,type,
    huffma1518433673istent: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ocost,type,
    huffma1134658180e_cost: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Odepth,type,
    huffma410068972_depth: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ofreq,type,
    huffma1352802255e_freq: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > fun(A,nat) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oheight,type,
    huffma945805758height: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ooptimum,type,
    huffma1393970616ptimum: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Osibling,type,
    huffma1401021291ibling: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > A ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OInnerNode,type,
    huffma1146269203erNode: 
      !>[A: $tType] : ( ( nat * huffma1450048681e_tree(A) * huffma1450048681e_tree(A) ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OLeaf,type,
    huffma2021818691e_Leaf: 
      !>[A: $tType] : ( ( nat * A ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_Otree__case,type,
    huffma107959123e_case: 
      !>[A: $tType,T2: $tType] : ( ( fun(nat,fun(A,T2)) * fun(nat,fun(huffma1450048681e_tree(A),fun(huffma1450048681e_tree(A),T2))) * huffma1450048681e_tree(A) ) > T2 ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_Otree__rec,type,
    huffma1280178957ee_rec: 
      !>[A: $tType,T2: $tType] : ( ( fun(nat,fun(A,T2)) * fun(nat,fun(huffma1450048681e_tree(A),fun(huffma1450048681e_tree(A),fun(T2,fun(T2,T2))))) * huffma1450048681e_tree(A) ) > T2 ) ).

tff(sy_c_If,type,
    if: 
      !>[A: $tType] : ( ( bool * A * A ) > A ) ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: a1 ).

tff(sy_v_t_092_060_094isub_0621,type,
    t_1: huffma1450048681e_tree(a1) ).

tff(sy_v_t_092_060_094isub_0622,type,
    t_2: huffma1450048681e_tree(a1) ).

tff(sy_v_w,type,
    w: nat ).

%----Relevant facts (99)
tff(fact_0_tree_Osimps_I2_J,axiom,
    ! [B: $tType,Tree23: huffma1450048681e_tree(B),Tree13: huffma1450048681e_tree(B),Nat4: nat,Tree2: huffma1450048681e_tree(B),Tree1: huffma1450048681e_tree(B),Nat: nat] :
      ( ( huffma1146269203erNode(B,Nat,Tree1,Tree2) = huffma1146269203erNode(B,Nat4,Tree13,Tree23) )
    <=> ( ( Nat = Nat4 )
        & ( Tree1 = Tree13 )
        & ( Tree2 = Tree23 ) ) ) ).

tff(fact_1_sibling_Osimps_I4_J,axiom,
    ! [B: $tType,Vb: huffma1450048681e_tree(B),Va: huffma1450048681e_tree(B),V: nat,Wa: nat,T_11: huffma1450048681e_tree(B),Aa: B] :
      ( ( member(B,Aa,huffma675207370phabet(B,T_11))
       => ( huffma1401021291ibling(B,huffma1146269203erNode(B,Wa,T_11,huffma1146269203erNode(B,V,Va,Vb)),Aa) = huffma1401021291ibling(B,T_11,Aa) ) )
      & ( ~ member(B,Aa,huffma675207370phabet(B,T_11))
       => ( ( member(B,Aa,huffma675207370phabet(B,huffma1146269203erNode(B,V,Va,Vb)))
           => ( huffma1401021291ibling(B,huffma1146269203erNode(B,Wa,T_11,huffma1146269203erNode(B,V,Va,Vb)),Aa) = huffma1401021291ibling(B,huffma1146269203erNode(B,V,Va,Vb),Aa) ) )
          & ( ~ member(B,Aa,huffma675207370phabet(B,huffma1146269203erNode(B,V,Va,Vb)))
           => ( huffma1401021291ibling(B,huffma1146269203erNode(B,Wa,T_11,huffma1146269203erNode(B,V,Va,Vb)),Aa) = Aa ) ) ) ) ) ).

tff(fact_2_sibling_Osimps_I3_J,axiom,
    ! [B: $tType,T_21: huffma1450048681e_tree(B),Wa: nat,Vb: huffma1450048681e_tree(B),Va: huffma1450048681e_tree(B),V: nat,Aa: B] :
      ( ( member(B,Aa,huffma675207370phabet(B,huffma1146269203erNode(B,V,Va,Vb)))
       => ( huffma1401021291ibling(B,huffma1146269203erNode(B,Wa,huffma1146269203erNode(B,V,Va,Vb),T_21),Aa) = huffma1401021291ibling(B,huffma1146269203erNode(B,V,Va,Vb),Aa) ) )
      & ( ~ member(B,Aa,huffma675207370phabet(B,huffma1146269203erNode(B,V,Va,Vb)))
       => ( ( member(B,Aa,huffma675207370phabet(B,T_21))
           => ( huffma1401021291ibling(B,huffma1146269203erNode(B,Wa,huffma1146269203erNode(B,V,Va,Vb),T_21),Aa) = huffma1401021291ibling(B,T_21,Aa) ) )
          & ( ~ member(B,Aa,huffma675207370phabet(B,T_21))
           => ( huffma1401021291ibling(B,huffma1146269203erNode(B,Wa,huffma1146269203erNode(B,V,Va,Vb),T_21),Aa) = Aa ) ) ) ) ) ).

tff(fact_3_notin__alphabet__imp__sibling__id,axiom,
    ! [B: $tType,T1: huffma1450048681e_tree(B),Aa: B] :
      ( ~ member(B,Aa,huffma675207370phabet(B,T1))
     => ( huffma1401021291ibling(B,T1,Aa) = Aa ) ) ).

tff(fact_4_height__0__imp__sibling__id,axiom,
    ! [A: $tType,A1: A,T: huffma1450048681e_tree(A)] :
      ( ( huffma945805758height(A,T) = zero_zero(nat) )
     => ( huffma1401021291ibling(A,T,A1) = A1 ) ) ).

tff(fact_5_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_6_less__nat__zero__code,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_7_less__zeroE,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_8_height__gt__0__alphabet__eq__imp__height__gt__0,axiom,
    ! [B: $tType,U1: huffma1450048681e_tree(B),T1: huffma1450048681e_tree(B)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B,T1))
     => ( huffma1518433673istent(B,T1)
       => ( ( huffma675207370phabet(B,T1) = huffma675207370phabet(B,U1) )
         => ord_less(nat,zero_zero(nat),huffma945805758height(B,U1)) ) ) ) ).

tff(fact_9_not__less0,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_10_gr__implies__not0,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,M1,N1)
     => ( N1 != zero_zero(nat) ) ) ).

tff(fact_11_gr0I,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_12_tree_Osimps_I6_J,axiom,
    ! [B: $tType,C1: $tType,Tree2: huffma1450048681e_tree(C1),Tree1: huffma1450048681e_tree(C1),Nat: nat,F2: fun(nat,fun(huffma1450048681e_tree(C1),fun(huffma1450048681e_tree(C1),B))),F1: fun(nat,fun(C1,B))] : ( huffma107959123e_case(C1,B,F1,F2,huffma1146269203erNode(C1,Nat,Tree1,Tree2)) = aa(huffma1450048681e_tree(C1),B,aa(huffma1450048681e_tree(C1),fun(huffma1450048681e_tree(C1),B),aa(nat,fun(huffma1450048681e_tree(C1),fun(huffma1450048681e_tree(C1),B)),F2,Nat),Tree1),Tree2) ) ).

tff(fact_13_exists__in__alphabet,axiom,
    ! [B: $tType,T1: huffma1450048681e_tree(B)] :
    ? [A3: B] : member(B,A3,huffma675207370phabet(B,T1)) ).

tff(fact_14_sibling_Osimps_I2_J,axiom,
    ! [A: $tType,C: A,W_c: nat,W_b: nat,W: nat,B1: A,A1: A] :
      ( ( ( A1 = B1 )
       => ( huffma1401021291ibling(A,huffma1146269203erNode(A,W,huffma2021818691e_Leaf(A,W_b,B1),huffma2021818691e_Leaf(A,W_c,C)),A1) = C ) )
      & ( ( A1 != B1 )
       => ( ( ( A1 = C )
           => ( huffma1401021291ibling(A,huffma1146269203erNode(A,W,huffma2021818691e_Leaf(A,W_b,B1),huffma2021818691e_Leaf(A,W_c,C)),A1) = B1 ) )
          & ( ( A1 != C )
           => ( huffma1401021291ibling(A,huffma1146269203erNode(A,W,huffma2021818691e_Leaf(A,W_b,B1),huffma2021818691e_Leaf(A,W_c,C)),A1) = A1 ) ) ) ) ) ).

tff(fact_15_height__0__imp__cost__0,axiom,
    ! [A: $tType,T: huffma1450048681e_tree(A)] :
      ( ( huffma945805758height(A,T) = zero_zero(nat) )
     => ( huffma1134658180e_cost(A,T) = zero_zero(nat) ) ) ).

tff(fact_16_tree_Osimps_I1_J,axiom,
    ! [B: $tType,A4: B,Nat4: nat,Aa: B,Nat: nat] :
      ( ( huffma2021818691e_Leaf(B,Nat,Aa) = huffma2021818691e_Leaf(B,Nat4,A4) )
    <=> ( ( Nat = Nat4 )
        & ( Aa = A4 ) ) ) ).

tff(fact_17_consistent_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,W: nat] : huffma1518433673istent(A,huffma2021818691e_Leaf(A,W,A1)) ).

tff(fact_18_height_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,W: nat] : ( huffma945805758height(A,huffma2021818691e_Leaf(A,W,A1)) = zero_zero(nat) ) ).

tff(fact_19_cost_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,W: nat] : ( huffma1134658180e_cost(A,huffma2021818691e_Leaf(A,W,A1)) = zero_zero(nat) ) ).

tff(fact_20_tree_Osimps_I5_J,axiom,
    ! [B: $tType,C1: $tType,Aa: C1,Nat: nat,F2: fun(nat,fun(huffma1450048681e_tree(C1),fun(huffma1450048681e_tree(C1),B))),F1: fun(nat,fun(C1,B))] : ( huffma107959123e_case(C1,B,F1,F2,huffma2021818691e_Leaf(C1,Nat,Aa)) = aa(C1,B,aa(nat,fun(C1,B),F1,Nat),Aa) ) ).

tff(fact_21_tree_Osimps_I4_J,axiom,
    ! [A: $tType,A1: A,Nat2: nat,Tree22: huffma1450048681e_tree(A),Tree12: huffma1450048681e_tree(A),Nat3: nat] : ( huffma1146269203erNode(A,Nat3,Tree12,Tree22) != huffma2021818691e_Leaf(A,Nat2,A1) ) ).

tff(fact_22_tree_Osimps_I3_J,axiom,
    ! [A: $tType,Tree22: huffma1450048681e_tree(A),Tree12: huffma1450048681e_tree(A),Nat3: nat,A1: A,Nat2: nat] : ( huffma2021818691e_Leaf(A,Nat2,A1) != huffma1146269203erNode(A,Nat3,Tree12,Tree22) ) ).

tff(fact_23_sibling_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,B1: A,W_b: nat] : ( huffma1401021291ibling(A,huffma2021818691e_Leaf(A,W_b,B1),A1) = A1 ) ).

tff(fact_24_zero__reorient,axiom,
    ! [B: $tType] :
      ( zero(B)
     => ! [X1: B] :
          ( ( zero_zero(B) = X1 )
        <=> ( X1 = zero_zero(B) ) ) ) ).

tff(fact_25_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),N: nat,M: nat] :
      ( ( ord_less(nat,M,N)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M)) )
     => ( ( ( M = N )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M)) )
       => ( ( ord_less(nat,N,M)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M)) ) ) ) ).

tff(fact_26_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_27_less__not__refl2,axiom,
    ! [M1: nat,N1: nat] :
      ( ord_less(nat,N1,M1)
     => ( M1 != N1 ) ) ).

tff(fact_28_less__irrefl__nat,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,N1) ).

tff(fact_29_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_30_nat__neq__iff,axiom,
    ! [N: nat,M: nat] :
      ( ( M != N )
    <=> ( ord_less(nat,M,N)
        | ord_less(nat,N,M) ) ) ).

tff(fact_31_less__not__refl,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,N1) ).

tff(fact_32_tree_Osize_I3_J,axiom,
    ! [A: $tType,A1: A,Nat2: nat] : ( size_size(huffma1450048681e_tree(A),huffma2021818691e_Leaf(A,Nat2,A1)) = zero_zero(nat) ) ).

tff(fact_33_depth_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,B1: A,W: nat] : ( huffma410068972_depth(A,huffma2021818691e_Leaf(A,W,B1),A1) = zero_zero(nat) ) ).

tff(fact_34_of__nat__0__less__iff,axiom,
    ! [B: $tType] :
      ( linordered_semidom(B)
     => ! [N: nat] :
          ( ord_less(B,zero_zero(B),semiring_1_of_nat(B,N))
        <=> ord_less(nat,zero_zero(nat),N) ) ) ).

tff(fact_35_tree_Oexhaust,axiom,
    ! [A: $tType,Y: huffma1450048681e_tree(A)] :
      ( ! [Nat1: nat,A3: A] : ( Y != huffma2021818691e_Leaf(A,Nat1,A3) )
     => ~ ! [Nat1: nat,Tree11: huffma1450048681e_tree(A),Tree21: huffma1450048681e_tree(A)] : ( Y != huffma1146269203erNode(A,Nat1,Tree11,Tree21) ) ) ).

tff(fact_36_freq_Osimps_I1_J,axiom,
    ! [A: $tType,W: nat,A1: A,X4: A] :
      ( ( ( X4 = A1 )
       => ( aa(A,nat,huffma1352802255e_freq(A,huffma2021818691e_Leaf(A,W,A1)),X4) = W ) )
      & ( ( X4 != A1 )
       => ( aa(A,nat,huffma1352802255e_freq(A,huffma2021818691e_Leaf(A,W,A1)),X4) = zero_zero(nat) ) ) ) ).

tff(fact_37_exists__at__height,axiom,
    ! [B: $tType,T1: huffma1450048681e_tree(B)] :
      ( huffma1518433673istent(B,T1)
     => ? [X3: B] :
          ( member(B,X3,huffma675207370phabet(B,T1))
          & ( huffma410068972_depth(B,T1,X3) = huffma945805758height(B,T1) ) ) ) ).

tff(fact_38_infinite__descent0,axiom,
    ! [N: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,zero_zero(nat)))
     => ( ! [N2: nat] :
            ( ord_less(nat,zero_zero(nat),N2)
           => ( ~ pp(aa(nat,bool,P1,N2))
             => ? [M2: nat] :
                  ( ord_less(nat,M2,N2)
                  & ~ pp(aa(nat,bool,P1,M2)) ) ) )
       => pp(aa(nat,bool,P1,N)) ) ) ).

tff(fact_39_tree_Orecs_I1_J,axiom,
    ! [B: $tType,C1: $tType,Aa: C1,Nat: nat,F2: fun(nat,fun(huffma1450048681e_tree(C1),fun(huffma1450048681e_tree(C1),fun(B,fun(B,B))))),F1: fun(nat,fun(C1,B))] : ( huffma1280178957ee_rec(C1,B,F1,F2,huffma2021818691e_Leaf(C1,Nat,Aa)) = aa(C1,B,aa(nat,fun(C1,B),F1,Nat),Aa) ) ).

tff(fact_40_of__nat__eq__iff,axiom,
    ! [B: $tType] :
      ( semiring_char_0(B)
     => ! [N: nat,M: nat] :
          ( ( semiring_1_of_nat(B,M) = semiring_1_of_nat(B,N) )
        <=> ( M = N ) ) ) ).

tff(fact_41_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_42_of__nat__less__iff,axiom,
    ! [B: $tType] :
      ( linordered_semidom(B)
     => ! [N: nat,M: nat] :
          ( ord_less(B,semiring_1_of_nat(B,M),semiring_1_of_nat(B,N))
        <=> ord_less(nat,M,N) ) ) ).

tff(fact_43_of__nat__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [M1: nat] : ~ ord_less(A,semiring_1_of_nat(A,M1),zero_zero(A)) ) ).

tff(fact_44_less__imp__of__nat__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat,M1: nat] :
          ( ord_less(nat,M1,N1)
         => ord_less(A,semiring_1_of_nat(A,M1),semiring_1_of_nat(A,N1)) ) ) ).

tff(fact_45_of__nat__less__imp__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat,M1: nat] :
          ( ord_less(A,semiring_1_of_nat(A,M1),semiring_1_of_nat(A,N1))
         => ord_less(nat,M1,N1) ) ) ).

tff(fact_46_notin__alphabet__imp__freq__0,axiom,
    ! [B: $tType,T1: huffma1450048681e_tree(B),Aa: B] :
      ( ~ member(B,Aa,huffma675207370phabet(B,T1))
     => ( aa(B,nat,huffma1352802255e_freq(B,T1),Aa) = zero_zero(nat) ) ) ).

tff(fact_47_tree_Orecs_I2_J,axiom,
    ! [B: $tType,C1: $tType,Tree2: huffma1450048681e_tree(C1),Tree1: huffma1450048681e_tree(C1),Nat: nat,F2: fun(nat,fun(huffma1450048681e_tree(C1),fun(huffma1450048681e_tree(C1),fun(B,fun(B,B))))),F1: fun(nat,fun(C1,B))] : ( huffma1280178957ee_rec(C1,B,F1,F2,huffma1146269203erNode(C1,Nat,Tree1,Tree2)) = aa(B,B,aa(B,fun(B,B),aa(huffma1450048681e_tree(C1),fun(B,fun(B,B)),aa(huffma1450048681e_tree(C1),fun(huffma1450048681e_tree(C1),fun(B,fun(B,B))),aa(nat,fun(huffma1450048681e_tree(C1),fun(huffma1450048681e_tree(C1),fun(B,fun(B,B)))),F2,Nat),Tree1),Tree2),huffma1280178957ee_rec(C1,B,F1,F2,Tree1)),huffma1280178957ee_rec(C1,B,F1,F2,Tree2)) ) ).

tff(fact_48_zero__less__int__conv,axiom,
    ! [N: nat] :
      ( ord_less(int,zero_zero(int),semiring_1_of_nat(int,N))
    <=> ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_49_optimum__def,axiom,
    ! [B: $tType,T1: huffma1450048681e_tree(B)] :
      ( huffma1393970616ptimum(B,T1)
    <=> ! [U: huffma1450048681e_tree(B)] :
          ( huffma1518433673istent(B,U)
         => ( ( huffma675207370phabet(B,T1) = huffma675207370phabet(B,U) )
           => ( ( huffma1352802255e_freq(B,T1) = huffma1352802255e_freq(B,U) )
             => ord_less_eq(nat,huffma1134658180e_cost(B,T1),huffma1134658180e_cost(B,U)) ) ) ) ) ).

tff(fact_50_transfer__int__nat__relations_I2_J,axiom,
    ! [Y1: nat,X1: nat] :
      ( ord_less(int,semiring_1_of_nat(int,X1),semiring_1_of_nat(int,Y1))
    <=> ord_less(nat,X1,Y1) ) ).

tff(fact_51_zless__int,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(int,semiring_1_of_nat(int,M),semiring_1_of_nat(int,N))
    <=> ord_less(nat,M,N) ) ).

tff(fact_52_zero__less__imp__eq__int,axiom,
    ! [K1: int] :
      ( ord_less(int,zero_zero(int),K1)
     => ? [N2: nat] :
          ( ord_less(nat,zero_zero(nat),N2)
          & ( K1 = semiring_1_of_nat(int,N2) ) ) ) ).

tff(fact_53_le__0__eq,axiom,
    ! [N: nat] :
      ( ord_less_eq(nat,N,zero_zero(nat))
    <=> ( N = zero_zero(nat) ) ) ).

tff(fact_54_less__eq__nat_Osimps_I1_J,axiom,
    ! [N1: nat] : ord_less_eq(nat,zero_zero(nat),N1) ).

tff(fact_55_le0,axiom,
    ! [N1: nat] : ord_less_eq(nat,zero_zero(nat),N1) ).

tff(fact_56_of__nat__le__iff,axiom,
    ! [B: $tType] :
      ( linordered_semidom(B)
     => ! [N: nat,M: nat] :
          ( ord_less_eq(B,semiring_1_of_nat(B,M),semiring_1_of_nat(B,N))
        <=> ord_less_eq(nat,M,N) ) ) ).

tff(fact_57_int__less__0__conv,axiom,
    ! [K1: nat] : ~ ord_less(int,semiring_1_of_nat(int,K1),zero_zero(int)) ).

tff(fact_58_int__if__cong,axiom,
    ! [Y1: nat,X1: nat,P1: bool] :
      ( ( pp(P1)
       => ( semiring_1_of_nat(int,X1) = semiring_1_of_nat(int,if(nat,P1,X1,Y1)) ) )
      & ( ~ pp(P1)
       => ( semiring_1_of_nat(int,Y1) = semiring_1_of_nat(int,if(nat,P1,X1,Y1)) ) ) ) ).

tff(fact_59_transfer__int__nat__relations_I1_J,axiom,
    ! [Y1: nat,X1: nat] :
      ( ( semiring_1_of_nat(int,X1) = semiring_1_of_nat(int,Y1) )
    <=> ( X1 = Y1 ) ) ).

tff(fact_60_int__int__eq,axiom,
    ! [N: nat,M: nat] :
      ( ( semiring_1_of_nat(int,M) = semiring_1_of_nat(int,N) )
    <=> ( M = N ) ) ).

tff(fact_61_nat__less__le,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
    <=> ( ord_less_eq(nat,M,N)
        & ( M != N ) ) ) ).

tff(fact_62_le__eq__less__or__eq,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
    <=> ( ord_less(nat,M,N)
        | ( M = N ) ) ) ).

tff(fact_63_less__imp__le__nat,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,M1,N1)
     => ord_less_eq(nat,M1,N1) ) ).

tff(fact_64_le__neq__implies__less,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less_eq(nat,M1,N1)
     => ( ( M1 != N1 )
       => ord_less(nat,M1,N1) ) ) ).

tff(fact_65_less__or__eq__imp__le,axiom,
    ! [N1: nat,M1: nat] :
      ( ( ord_less(nat,M1,N1)
        | ( M1 = N1 ) )
     => ord_less_eq(nat,M1,N1) ) ).

tff(fact_66_le__antisym,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less_eq(nat,M1,N1)
     => ( ord_less_eq(nat,N1,M1)
       => ( M1 = N1 ) ) ) ).

tff(fact_67_le__trans,axiom,
    ! [K1: nat,J2: nat,I3: nat] :
      ( ord_less_eq(nat,I3,J2)
     => ( ord_less_eq(nat,J2,K1)
       => ord_less_eq(nat,I3,K1) ) ) ).

tff(fact_68_eq__imp__le,axiom,
    ! [N1: nat,M1: nat] :
      ( ( M1 = N1 )
     => ord_less_eq(nat,M1,N1) ) ).

tff(fact_69_nat__le__linear,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less_eq(nat,M1,N1)
      | ord_less_eq(nat,N1,M1) ) ).

tff(fact_70_le__refl,axiom,
    ! [N1: nat] : ord_less_eq(nat,N1,N1) ).

tff(fact_71_of__nat__0__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat] : ord_less_eq(A,zero_zero(A),semiring_1_of_nat(A,N1)) ) ).

tff(fact_72_zero__le__imp__of__nat,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [M1: nat] : ord_less_eq(A,zero_zero(A),semiring_1_of_nat(A,M1)) ) ).

tff(fact_73_depth__le__height,axiom,
    ! [A: $tType,A1: A,T: huffma1450048681e_tree(A)] : ord_less_eq(nat,huffma410068972_depth(A,T,A1),huffma945805758height(A,T)) ).

tff(fact_74_ext,axiom,
    ! [C1: $tType,B: $tType,G: fun(B,C1),F: fun(B,C1)] :
      ( ! [X3: B] : ( aa(B,C1,F,X3) = aa(B,C1,G,X3) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [B: $tType,A2: fun(B,bool),X1: B] :
      ( member(B,X1,A2)
    <=> pp(aa(B,bool,A2,X1)) ) ).

tff(fact_76_int__eq__0__conv,axiom,
    ! [N: nat] :
      ( ( semiring_1_of_nat(int,N) = zero_zero(int) )
    <=> ( N = zero_zero(nat) ) ) ).

tff(fact_77_int__0,axiom,
    semiring_1_of_nat(int,zero_zero(nat)) = zero_zero(int) ).

tff(fact_78_transfer__int__nat__numerals_I1_J,axiom,
    zero_zero(int) = semiring_1_of_nat(int,zero_zero(nat)) ).

tff(fact_79_ex__least__nat__le,axiom,
    ! [N: nat,P1: fun(nat,bool)] :
      ( ~ pp(aa(nat,bool,P1,zero_zero(nat)))
     => ( pp(aa(nat,bool,P1,N))
       => ? [K: nat] :
            ( ord_less_eq(nat,K,N)
            & ! [I2: nat] :
                ( ord_less(nat,I2,K)
               => ~ pp(aa(nat,bool,P1,I2)) )
            & pp(aa(nat,bool,P1,K)) ) ) ) ).

tff(fact_80_less__mono__imp__le__mono,axiom,
    ! [J: nat,I: nat,F: fun(nat,nat)] :
      ( ! [I1: nat,J1: nat] :
          ( ord_less(nat,I1,J1)
         => ord_less(nat,aa(nat,nat,F,I1),aa(nat,nat,F,J1)) )
     => ( ord_less_eq(nat,I,J)
       => ord_less_eq(nat,aa(nat,nat,F,I),aa(nat,nat,F,J)) ) ) ).

tff(fact_81_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ord_less_eq(A,X,X) ) ).

tff(fact_82_termination__basic__simps_I5_J,axiom,
    ! [Y: nat,X: nat] :
      ( ord_less(nat,X,Y)
     => ord_less_eq(nat,X,Y) ) ).

tff(fact_83_less__int__def,axiom,
    ! [Wa: int,Z1: int] :
      ( ord_less(int,Z1,Wa)
    <=> ( ord_less_eq(int,Z1,Wa)
        & ( Z1 != Wa ) ) ) ).

tff(fact_84_Nat__Transfer_Otransfer__nat__int__function__closures_I5_J,axiom,
    ord_less_eq(int,zero_zero(int),zero_zero(int)) ).

tff(fact_85_transfer__int__nat__quantifiers_I1_J,axiom,
    ! [P1: fun(int,bool)] :
      ( ! [X2: int] :
          ( ord_less_eq(int,zero_zero(int),X2)
         => pp(aa(int,bool,P1,X2)) )
    <=> ! [X2: nat] : pp(aa(int,bool,P1,semiring_1_of_nat(int,X2))) ) ).

tff(fact_86_transfer__int__nat__quantifiers_I2_J,axiom,
    ! [P1: fun(int,bool)] :
      ( ? [X2: int] :
          ( ord_less_eq(int,zero_zero(int),X2)
          & pp(aa(int,bool,P1,X2)) )
    <=> ? [X2: nat] : pp(aa(int,bool,P1,semiring_1_of_nat(int,X2))) ) ).

tff(fact_87_Nat__Transfer_Otransfer__nat__int__function__closures_I9_J,axiom,
    ! [Z: nat] : ord_less_eq(int,zero_zero(int),semiring_1_of_nat(int,Z)) ).

tff(fact_88_zero__zle__int,axiom,
    ! [N1: nat] : ord_less_eq(int,zero_zero(int),semiring_1_of_nat(int,N1)) ).

tff(fact_89_zle__int,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(int,semiring_1_of_nat(int,M),semiring_1_of_nat(int,N))
    <=> ord_less_eq(nat,M,N) ) ).

tff(fact_90_transfer__int__nat__relations_I3_J,axiom,
    ! [Y1: nat,X1: nat] :
      ( ord_less_eq(int,semiring_1_of_nat(int,X1),semiring_1_of_nat(int,Y1))
    <=> ord_less_eq(nat,X1,Y1) ) ).

tff(fact_91_int__le__0__conv,axiom,
    ! [N: nat] :
      ( ord_less_eq(int,semiring_1_of_nat(int,N),zero_zero(int))
    <=> ( N = zero_zero(nat) ) ) ).

tff(fact_92_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ ord_less_eq(A,X,Y)
         => ord_less_eq(A,Y,X) ) ) ).

tff(fact_93_le__funE,axiom,
    ! [C1: $tType,B: $tType] :
      ( ord(C1)
     => ! [X1: B,G: fun(B,C1),F: fun(B,C1)] :
          ( ord_less_eq(fun(B,C1),F,G)
         => ord_less_eq(C1,aa(B,C1,F,X1),aa(B,C1,G,X1)) ) ) ).

tff(fact_94_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,Z)
           => ord_less_eq(A,X,Z) ) ) ) ).

tff(fact_95_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,X)
           => ( X = Y ) ) ) ) ).

tff(fact_96_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B1: A,A1: A] :
          ( ord_less_eq(A,A1,B1)
         => ( ( B1 = C )
           => ord_less_eq(A,A1,C) ) ) ) ).

tff(fact_97_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B1: A,A1: A] :
          ( ( A1 = B1 )
         => ( ord_less_eq(A,B1,C)
           => ord_less_eq(A,A1,C) ) ) ) ).

tff(fact_98_order__antisym__conv,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [X1: B,Y1: B] :
          ( ord_less_eq(B,Y1,X1)
         => ( ord_less_eq(B,X1,Y1)
          <=> ( X1 = Y1 ) ) ) ) ).

%----Arities (23)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0(int) ).

tff(arity_Int_Oint___Orderings_Opreorder,axiom,
    preorder(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Orderings_Oorder,axiom,
    order(int) ).

tff(arity_Int_Oint___Orderings_Oord,axiom,
    ord(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (5)
tff(help_If_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fTrue,X,Y) = X ) ).

tff(help_If_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fFalse,X,Y) = Y ) ).

tff(help_If_3_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    ord_less(nat,zero_zero(nat),huffma945805758height(a1,t_1)) ).

tff(conj_1,hypothesis,
    member(a1,a,huffma675207370phabet(a1,t_1)) ).

tff(conj_2,conjecture,
    huffma1401021291ibling(a1,huffma1146269203erNode(a1,w,t_1,t_2),a) = huffma1401021291ibling(a1,t_1,a) ).

%------------------------------------------------------------------------------
