%------------------------------------------------------------------------------
% File     : SWW540_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Huffman's Algorithm line 978
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla09] Blanchette (2009), Proof Pearl: Mechanizing the Textbo
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : huff_978 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  172 (  59 unt;  54 typ;   0 def)
%            Number of atoms       :  210 (  99 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  122 (  30   ~;   7   |;  13   &)
%                                         (  15 <=>;  57  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   5 avg)
%            Maximal term depth    :    6 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   69 (  40   >;  29   *;   0   +;   0  <<)
%            Number of predicates  :   11 (  10 usr;   0 prp; 1-3 aty)
%            Number of functors    :   41 (  41 usr;   4 con; 0-5 aty)
%            Number of variables   :  413 ( 353   !;   7   ?; 413   :)
%                                         (  53  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:18:34
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Huffman__Mirabelle__lalbadcutu_Otree,type,
    huffma1450048681e_tree: $tType > $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (47)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Osemilattice__sup,type,
    semilattice_sup: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Enum_On__lists,type,
    n_lists: 
      !>[A: $tType] : ( ( nat * list(A) ) > list(list(A)) ) ).

tff(sy_c_Enum_Oproduct,type,
    product: 
      !>[A: $tType,B: $tType] : ( ( list(A) * list(B) ) > list(product_prod(A,B)) ) ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_HOL_Oequal__class_Oequal,type,
    equal_equal: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oalphabet,type,
    huffma675207370phabet: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > fun(A,bool) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oalphabet_092_060_094isub_062F,type,
    huffma1516701463abet_F: 
      !>[A: $tType] : ( list(huffma1450048681e_tree(A)) > fun(A,bool) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oconsistent,type,
    huffma1518433673istent: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oconsistent_092_060_094isub_062F,type,
    huffma594769176tent_F: 
      !>[A: $tType] : ( list(huffma1450048681e_tree(A)) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ocost,type,
    huffma1134658180e_cost: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Odepth,type,
    huffma410068972_depth: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ofreq,type,
    huffma1352802255e_freq: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ofreq_092_060_094isub_062F,type,
    huffma409467474freq_F: 
      !>[A: $tType] : ( ( list(huffma1450048681e_tree(A)) * A ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oheight_092_060_094isub_062F,type,
    huffma632063779ight_F: 
      !>[A: $tType] : ( list(huffma1450048681e_tree(A)) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ohuffman,type,
    huffma607257910uffman: 
      !>[A: $tType] : ( list(huffma1450048681e_tree(A)) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_OinsortTree,type,
    huffma1193049432rtTree: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * list(huffma1450048681e_tree(A)) ) > list(huffma1450048681e_tree(A)) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OLeaf,type,
    huffma2021818691e_Leaf: 
      !>[A: $tType] : ( ( nat * A ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_Otree__case,type,
    huffma107959123e_case: 
      !>[A: $tType,T2: $tType] : ( ( fun(nat,fun(A,T2)) * fun(nat,fun(huffma1450048681e_tree(A),fun(huffma1450048681e_tree(A),T2))) * huffma1450048681e_tree(A) ) > T2 ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_OuniteTrees,type,
    huffma921447403eTrees: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * huffma1450048681e_tree(A) ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Lattices_Osup__class_Osup,type,
    sup_sup: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T2: $tType,A: $tType] : ( ( T2 * fun(A,fun(list(A),T2)) * list(A) ) > T2 ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T2: $tType,A: $tType] : ( ( T2 * fun(A,fun(list(A),fun(T2,T2))) * list(A) ) > T2 ) ).

tff(sy_c_List_Olist_Olist__size,type,
    list_size: 
      !>[A: $tType] : ( ( fun(A,nat) * list(A) ) > nat ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Onull,type,
    null: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_ts,type,
    ts: list(huffma1450048681e_tree(a)) ).

%----Relevant facts (99)
tff(fact_0_consistent_092_060_094isub_062F_Osimps_I1_J,axiom,
    ! [A: $tType] : huffma594769176tent_F(A,nil(huffma1450048681e_tree(A))) ).

tff(fact_1_huffman_Osimps_I1_J,axiom,
    ! [A: $tType,T: huffma1450048681e_tree(A)] : ( huffma607257910uffman(A,cons(huffma1450048681e_tree(A),T,nil(huffma1450048681e_tree(A)))) = T ) ).

tff(fact_2_consistent_Osimps_I1_J,axiom,
    ! [A: $tType,A2: A,W: nat] : huffma1518433673istent(A,huffma2021818691e_Leaf(A,W,A2)) ).

tff(fact_3_insortTree__ne__Nil,axiom,
    ! [A: $tType,Ts: list(huffma1450048681e_tree(A)),T: huffma1450048681e_tree(A)] : ( huffma1193049432rtTree(A,T,Ts) != nil(huffma1450048681e_tree(A)) ) ).

tff(fact_4_alphabet__huffman,axiom,
    ! [B: $tType,Tsa: list(huffma1450048681e_tree(B))] :
      ( ( Tsa != nil(huffma1450048681e_tree(B)) )
     => ( huffma675207370phabet(B,huffma607257910uffman(B,Tsa)) = huffma1516701463abet_F(B,Tsa) ) ) ).

tff(fact_5_list_Osimps_I4_J,axiom,
    ! [C: $tType,B: $tType,F2: fun(C,fun(list(C),B)),F1: B] : ( list_case(B,C,F1,F2,nil(C)) = F1 ) ).

tff(fact_6_product_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,Uu: list(B)] : ( product(A,B,nil(A),Uu) = nil(product_prod(A,B)) ) ).

tff(fact_7_list__ex1__simps_I1_J,axiom,
    ! [B: $tType,P1: fun(B,bool)] : ~ list_ex1(B,P1,nil(B)) ).

tff(fact_8_list_Orecs_I1_J,axiom,
    ! [C: $tType,B: $tType,F2: fun(C,fun(list(C),fun(B,B))),F1: B] : ( list_rec(B,C,F1,F2,nil(C)) = F1 ) ).

tff(fact_9_null__rec_I2_J,axiom,
    ! [B: $tType] : null(B,nil(B)) ).

tff(fact_10_List_Onull__def,axiom,
    ! [B: $tType,Xs1: list(B)] :
      ( null(B,Xs1)
    <=> ( Xs1 = nil(B) ) ) ).

tff(fact_11_eq__Nil__null,axiom,
    ! [B: $tType,Xs1: list(B)] :
      ( ( Xs1 = nil(B) )
    <=> null(B,Xs1) ) ).

tff(fact_12_height_092_060_094isub_062F_Osimps_I1_J,axiom,
    ! [A: $tType] : ( huffma632063779ight_F(A,nil(huffma1450048681e_tree(A))) = zero_zero(nat) ) ).

tff(fact_13_list_Oinject,axiom,
    ! [B: $tType,List3: list(B),A6: B,List2: list(B),A1: B] :
      ( ( cons(B,A1,List2) = cons(B,A6,List3) )
    <=> ( ( A1 = A6 )
        & ( List2 = List3 ) ) ) ).

tff(fact_14_tree_Osimps_I1_J,axiom,
    ! [B: $tType,A6: B,Nat2: nat,A1: B,Nat: nat] :
      ( ( huffma2021818691e_Leaf(B,Nat,A1) = huffma2021818691e_Leaf(B,Nat2,A6) )
    <=> ( ( Nat = Nat2 )
        & ( A1 = A6 ) ) ) ).

tff(fact_15_insortTree_Osimps_I1_J,axiom,
    ! [A: $tType,U: huffma1450048681e_tree(A)] : ( huffma1193049432rtTree(A,U,nil(huffma1450048681e_tree(A))) = cons(huffma1450048681e_tree(A),U,nil(huffma1450048681e_tree(A))) ) ).

tff(fact_16_consistent_092_060_094isub_062F__insortTree,axiom,
    ! [B: $tType,Tsa: list(huffma1450048681e_tree(B)),T1: huffma1450048681e_tree(B)] :
      ( huffma594769176tent_F(B,huffma1193049432rtTree(B,T1,Tsa))
    <=> huffma594769176tent_F(B,cons(huffma1450048681e_tree(B),T1,Tsa)) ) ).

tff(fact_17_not__Cons__self,axiom,
    ! [A: $tType,X2: A,Xs: list(A)] : ( Xs != cons(A,X2,Xs) ) ).

tff(fact_18_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X2: A] : ( cons(A,X2,Xs) != Xs ) ).

tff(fact_19_null__rec_I1_J,axiom,
    ! [A: $tType,Xs: list(A),X2: A] : ~ null(A,cons(A,X2,Xs)) ).

tff(fact_20_list_Osimps_I5_J,axiom,
    ! [B: $tType,C: $tType,List2: list(C),A1: C,F2: fun(C,fun(list(C),B)),F1: B] : ( list_case(B,C,F1,F2,cons(C,A1,List2)) = aa(list(C),B,aa(C,fun(list(C),B),F2,A1),List2) ) ).

tff(fact_21_list_Orecs_I2_J,axiom,
    ! [B: $tType,C: $tType,List2: list(C),A1: C,F2: fun(C,fun(list(C),fun(B,B))),F1: B] : ( list_rec(B,C,F1,F2,cons(C,A1,List2)) = aa(B,B,aa(list(C),fun(B,B),aa(C,fun(list(C),fun(B,B)),F2,A1),List2),list_rec(B,C,F1,F2,List2)) ) ).

tff(fact_22_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( cons(A,A5,List1) != nil(A) ) ).

tff(fact_23_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( nil(A) != cons(A,A5,List1) ) ).

tff(fact_24_huffman_Osimps_I2_J,axiom,
    ! [A: $tType,Ts: list(huffma1450048681e_tree(A)),T_22: huffma1450048681e_tree(A),T_12: huffma1450048681e_tree(A)] : ( huffma607257910uffman(A,cons(huffma1450048681e_tree(A),T_12,cons(huffma1450048681e_tree(A),T_22,Ts))) = huffma607257910uffman(A,huffma1193049432rtTree(A,huffma921447403eTrees(A,T_12,T_22),Ts)) ) ).

tff(fact_25_tree_Osize_I3_J,axiom,
    ! [A: $tType,A2: A,Nat1: nat] : ( size_size(huffma1450048681e_tree(A),huffma2021818691e_Leaf(A,Nat1,A2)) = zero_zero(nat) ) ).

tff(fact_26_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A4: A,List: list(A)] : ( Y != cons(A,A4,List) ) ) ).

tff(fact_27_neq__Nil__conv,axiom,
    ! [B: $tType,Xs1: list(B)] :
      ( ( Xs1 != nil(B) )
    <=> ? [Y1: B,Ys1: list(B)] : ( Xs1 = cons(B,Y1,Ys1) ) ) ).

tff(fact_28_freq_092_060_094isub_062F_Osimps_I1_J,axiom,
    ! [A: $tType,X: A] : ( huffma409467474freq_F(A,nil(huffma1450048681e_tree(A)),X) = zero_zero(nat) ) ).

tff(fact_29_cost_Osimps_I1_J,axiom,
    ! [A: $tType,A2: A,W: nat] : ( huffma1134658180e_cost(A,huffma2021818691e_Leaf(A,W,A2)) = zero_zero(nat) ) ).

tff(fact_30_insert__Nil,axiom,
    ! [A: $tType,X2: A] : ( insert(A,X2,nil(A)) = cons(A,X2,nil(A)) ) ).

tff(fact_31_sublist__singleton,axiom,
    ! [B: $tType,X1: B,A3: fun(nat,bool)] :
      ( ( pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),zero_zero(nat)),A3))
       => ( sublist(B,cons(B,X1,nil(B)),A3) = cons(B,X1,nil(B)) ) )
      & ( ~ pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),zero_zero(nat)),A3))
       => ( sublist(B,cons(B,X1,nil(B)),A3) = nil(B) ) ) ) ).

tff(fact_32_sublist__nil,axiom,
    ! [B: $tType,A3: fun(nat,bool)] : ( sublist(B,nil(B),A3) = nil(B) ) ).

tff(fact_33_zero__reorient,axiom,
    ! [B: $tType] :
      ( zero(B)
     => ! [X1: B] :
          ( ( zero_zero(B) = X1 )
        <=> ( X1 = zero_zero(B) ) ) ) ).

tff(fact_34_notin__alphabet_092_060_094isub_062F__imp__freq_092_060_094isub_062F__0,axiom,
    ! [B: $tType,Tsa: list(huffma1450048681e_tree(B)),A1: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),huffma1516701463abet_F(B,Tsa)))
     => ( huffma409467474freq_F(B,Tsa,A1) = zero_zero(nat) ) ) ).

tff(fact_35_height_092_060_094isub_062F__0__imp__Leaf__freq_092_060_094isub_062F__in__set,axiom,
    ! [B: $tType,A1: B,Tsa: list(huffma1450048681e_tree(B))] :
      ( huffma594769176tent_F(B,Tsa)
     => ( ( huffma632063779ight_F(B,Tsa) = zero_zero(nat) )
       => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),huffma1516701463abet_F(B,Tsa)))
         => pp(aa(fun(huffma1450048681e_tree(B),bool),bool,aa(huffma1450048681e_tree(B),fun(fun(huffma1450048681e_tree(B),bool),bool),member(huffma1450048681e_tree(B)),huffma2021818691e_Leaf(B,huffma409467474freq_F(B,Tsa,A1),A1)),set(huffma1450048681e_tree(B),Tsa))) ) ) ) ).

tff(fact_36_depth_Osimps_I1_J,axiom,
    ! [A: $tType,A2: A,B2: A,W: nat] : ( huffma410068972_depth(A,huffma2021818691e_Leaf(A,W,B2),A2) = zero_zero(nat) ) ).

tff(fact_37_tree_Osimps_I5_J,axiom,
    ! [B: $tType,C: $tType,A1: C,Nat: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B))),F1: fun(nat,fun(C,B))] : ( huffma107959123e_case(C,B,F1,F2,huffma2021818691e_Leaf(C,Nat,A1)) = aa(C,B,aa(nat,fun(C,B),F1,Nat),A1) ) ).

tff(fact_38_equal__Nil__null,axiom,
    ! [B: $tType,Xs1: list(B)] :
      ( equal_equal(list(B),Xs1,nil(B))
    <=> null(B,Xs1) ) ).

tff(fact_39_exists__in__alphabet,axiom,
    ! [B: $tType,T1: huffma1450048681e_tree(B)] :
    ? [A4: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A4),huffma675207370phabet(B,T1))) ).

tff(fact_40_n__lists__Nil,axiom,
    ! [A: $tType,N: nat] :
      ( ( ( N = zero_zero(nat) )
       => ( n_lists(A,N,nil(A)) = cons(list(A),nil(A),nil(list(A))) ) )
      & ( ( N != zero_zero(nat) )
       => ( n_lists(A,N,nil(A)) = nil(list(A)) ) ) ) ).

tff(fact_41_n__lists_Osimps_I1_J,axiom,
    ! [A: $tType,Xs: list(A)] : ( n_lists(A,zero_zero(nat),Xs) = cons(list(A),nil(A),nil(list(A))) ) ).

tff(fact_42_equal__list__def,axiom,
    ! [B: $tType,Y2: list(B),X1: list(B)] :
      ( equal_equal(list(B),X1,Y2)
    <=> ( X1 = Y2 ) ) ).

tff(fact_43_set__ConsD,axiom,
    ! [B: $tType,Xs1: list(B),X1: B,Y2: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Y2),set(B,cons(B,X1,Xs1))))
     => ( ( Y2 = X1 )
        | pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Y2),set(B,Xs1))) ) ) ).

tff(fact_44_in__set__sublistD,axiom,
    ! [B: $tType,I: fun(nat,bool),Xs1: list(B),X1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),set(B,sublist(B,Xs1,I))))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),set(B,Xs1))) ) ).

tff(fact_45_notin__set__sublistI,axiom,
    ! [B: $tType,I: fun(nat,bool),Xs1: list(B),X1: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),set(B,Xs1)))
     => ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),set(B,sublist(B,Xs1,I)))) ) ).

tff(fact_46_in__set__insert,axiom,
    ! [B: $tType,Xs1: list(B),X1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),set(B,Xs1)))
     => ( insert(B,X1,Xs1) = Xs1 ) ) ).

tff(fact_47_list__ex1__iff,axiom,
    ! [B: $tType,Xs1: list(B),P1: fun(B,bool)] :
      ( list_ex1(B,P1,Xs1)
    <=> ? [X4: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),set(B,Xs1)))
          & pp(aa(B,bool,P1,X4))
          & ! [Y1: B] :
              ( ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Y1),set(B,Xs1)))
                & pp(aa(B,bool,P1,Y1)) )
             => ( Y1 = X4 ) ) ) ) ).

tff(fact_48_List_Oinsert__def,axiom,
    ! [B: $tType,Xs1: list(B),X1: B] :
      ( ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),set(B,Xs1)))
       => ( insert(B,X1,Xs1) = Xs1 ) )
      & ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),set(B,Xs1)))
       => ( insert(B,X1,Xs1) = cons(B,X1,Xs1) ) ) ) ).

tff(fact_49_not__in__set__insert,axiom,
    ! [B: $tType,Xs1: list(B),X1: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),set(B,Xs1)))
     => ( insert(B,X1,Xs1) = cons(B,X1,Xs1) ) ) ).

tff(fact_50_freq_Osimps_I1_J,axiom,
    ! [A: $tType,W: nat,A2: A,X: A] :
      ( ( ( X = A2 )
       => ( huffma1352802255e_freq(A,huffma2021818691e_Leaf(A,W,A2),X) = W ) )
      & ( ( X != A2 )
       => ( huffma1352802255e_freq(A,huffma2021818691e_Leaf(A,W,A2),X) = zero_zero(nat) ) ) ) ).

tff(fact_51_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_52_alphabet_092_060_094isub_062F__insortTree,axiom,
    ! [B: $tType,Tsa: list(huffma1450048681e_tree(B)),T1: huffma1450048681e_tree(B)] : ( huffma1516701463abet_F(B,huffma1193049432rtTree(B,T1,Tsa)) = sup_sup(fun(B,bool),huffma675207370phabet(B,T1),huffma1516701463abet_F(B,Tsa)) ) ).

tff(fact_53_alphabet_092_060_094isub_062F_Osimps_I2_J,axiom,
    ! [B: $tType,Tsa: list(huffma1450048681e_tree(B)),T1: huffma1450048681e_tree(B)] : ( huffma1516701463abet_F(B,cons(huffma1450048681e_tree(B),T1,Tsa)) = sup_sup(fun(B,bool),huffma675207370phabet(B,T1),huffma1516701463abet_F(B,Tsa)) ) ).

tff(fact_54_list_Osize_I1_J,axiom,
    ! [B: $tType,Fa: fun(B,nat)] : ( list_size(B,Fa,nil(B)) = zero_zero(nat) ) ).

tff(fact_55_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs: list(A),X2: A] : ( splice(A,cons(A,X2,Xs),cons(A,Y,Ys)) = cons(A,X2,cons(A,Y,splice(A,Xs,Ys))) ) ).

tff(fact_56_alphabet__uniteTrees,axiom,
    ! [B: $tType,T_21: huffma1450048681e_tree(B),T_11: huffma1450048681e_tree(B)] : ( huffma675207370phabet(B,huffma921447403eTrees(B,T_11,T_21)) = sup_sup(fun(B,bool),huffma675207370phabet(B,T_11),huffma675207370phabet(B,T_21)) ) ).

tff(fact_57_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys: list(A)] : ( splice(A,nil(A),Ys) = Ys ) ).

tff(fact_58_splice__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( splice(A,Xs,nil(A)) = Xs ) ).

tff(fact_59_notin__alphabet__imp__freq__0,axiom,
    ! [B: $tType,T1: huffma1450048681e_tree(B),A1: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),huffma675207370phabet(B,T1)))
     => ( huffma1352802255e_freq(B,T1,A1) = zero_zero(nat) ) ) ).

tff(fact_60_UnCI,axiom,
    ! [B: $tType,A3: fun(B,bool),B3: fun(B,bool),C1: B] :
      ( ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),B3))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),A3)) )
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),sup_sup(fun(B,bool),A3,B3))) ) ).

tff(fact_61_sup1CI,axiom,
    ! [B: $tType,A3: fun(B,bool),X1: B,B3: fun(B,bool)] :
      ( ( ~ pp(aa(B,bool,B3,X1))
       => pp(aa(B,bool,A3,X1)) )
     => pp(aa(B,bool,sup_sup(fun(B,bool),A3,B3),X1)) ) ).

tff(fact_62_sup1E,axiom,
    ! [B: $tType,X1: B,B3: fun(B,bool),A3: fun(B,bool)] :
      ( pp(aa(B,bool,sup_sup(fun(B,bool),A3,B3),X1))
     => ( ~ pp(aa(B,bool,A3,X1))
       => pp(aa(B,bool,B3,X1)) ) ) ).

tff(fact_63_Un__iff,axiom,
    ! [B: $tType,B3: fun(B,bool),A3: fun(B,bool),C1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),sup_sup(fun(B,bool),A3,B3)))
    <=> ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),A3))
        | pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),B3)) ) ) ).

tff(fact_64_UnE,axiom,
    ! [B: $tType,B3: fun(B,bool),A3: fun(B,bool),C1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),sup_sup(fun(B,bool),A3,B3)))
     => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),A3))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),B3)) ) ) ).

tff(fact_65_Un__absorb,axiom,
    ! [B: $tType,A3: fun(B,bool)] : ( sup_sup(fun(B,bool),A3,A3) = A3 ) ).

tff(fact_66_Un__def,axiom,
    ! [B: $tType,B3: fun(B,bool),A3: fun(B,bool)] : ( sup_sup(fun(B,bool),A3,B3) = collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fdisj,combc(B,fun(B,bool),bool,member(B),A3)),combc(B,fun(B,bool),bool,member(B),B3))) ) ).

tff(fact_67_Un__commute,axiom,
    ! [B: $tType,B3: fun(B,bool),A3: fun(B,bool)] : ( sup_sup(fun(B,bool),A3,B3) = sup_sup(fun(B,bool),B3,A3) ) ).

tff(fact_68_Un__left__absorb,axiom,
    ! [B: $tType,B3: fun(B,bool),A3: fun(B,bool)] : ( sup_sup(fun(B,bool),A3,sup_sup(fun(B,bool),A3,B3)) = sup_sup(fun(B,bool),A3,B3) ) ).

tff(fact_69_Un__left__commute,axiom,
    ! [B: $tType,C3: fun(B,bool),B3: fun(B,bool),A3: fun(B,bool)] : ( sup_sup(fun(B,bool),A3,sup_sup(fun(B,bool),B3,C3)) = sup_sup(fun(B,bool),B3,sup_sup(fun(B,bool),A3,C3)) ) ).

tff(fact_70_Un__assoc,axiom,
    ! [B: $tType,C3: fun(B,bool),B3: fun(B,bool),A3: fun(B,bool)] : ( sup_sup(fun(B,bool),sup_sup(fun(B,bool),A3,B3),C3) = sup_sup(fun(B,bool),A3,sup_sup(fun(B,bool),B3,C3)) ) ).

tff(fact_71_bex__Un,axiom,
    ! [B: $tType,P1: fun(B,bool),B3: fun(B,bool),A3: fun(B,bool)] :
      ( ? [X4: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),sup_sup(fun(B,bool),A3,B3)))
          & pp(aa(B,bool,P1,X4)) )
    <=> ( ? [X4: B] :
            ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),A3))
            & pp(aa(B,bool,P1,X4)) )
        | ? [X4: B] :
            ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),B3))
            & pp(aa(B,bool,P1,X4)) ) ) ) ).

tff(fact_72_ball__Un,axiom,
    ! [B: $tType,P1: fun(B,bool),B3: fun(B,bool),A3: fun(B,bool)] :
      ( ! [X4: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),sup_sup(fun(B,bool),A3,B3)))
         => pp(aa(B,bool,P1,X4)) )
    <=> ( ! [X4: B] :
            ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),A3))
           => pp(aa(B,bool,P1,X4)) )
        & ! [X4: B] :
            ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),B3))
           => pp(aa(B,bool,P1,X4)) ) ) ) ).

tff(fact_73_sup1I1,axiom,
    ! [B: $tType,B3: fun(B,bool),X1: B,A3: fun(B,bool)] :
      ( pp(aa(B,bool,A3,X1))
     => pp(aa(B,bool,sup_sup(fun(B,bool),A3,B3),X1)) ) ).

tff(fact_74_ext,axiom,
    ! [C: $tType,B: $tType,G: fun(B,C),F: fun(B,C)] :
      ( ! [X3: B] : ( aa(B,C,F,X3) = aa(B,C,G,X3) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [B: $tType,A3: fun(B,bool),X1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A3))
    <=> pp(aa(B,bool,A3,X1)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [B: $tType,P1: fun(B,bool)] : ( collect(B,P1) = P1 ) ).

tff(fact_77_sup1I2,axiom,
    ! [B: $tType,A3: fun(B,bool),X1: B,B3: fun(B,bool)] :
      ( pp(aa(B,bool,B3,X1))
     => pp(aa(B,bool,sup_sup(fun(B,bool),A3,B3),X1)) ) ).

tff(fact_78_UnI1,axiom,
    ! [B: $tType,B3: fun(B,bool),A3: fun(B,bool),C1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),A3))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),sup_sup(fun(B,bool),A3,B3))) ) ).

tff(fact_79_UnI2,axiom,
    ! [B: $tType,A3: fun(B,bool),B3: fun(B,bool),C1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),B3))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),sup_sup(fun(B,bool),A3,B3))) ) ).

tff(fact_80_sup_Oleft__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [B2: A,A2: A] : ( sup_sup(A,A2,sup_sup(A,A2,B2)) = sup_sup(A,A2,B2) ) ) ).

tff(fact_81_sup__left__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Y: A,X2: A] : ( sup_sup(A,X2,sup_sup(A,X2,Y)) = sup_sup(A,X2,Y) ) ) ).

tff(fact_82_sup__fun__def,axiom,
    ! [C: $tType,B: $tType] :
      ( lattice(C)
     => ! [G: fun(B,C),F: fun(B,C),X: B] : ( aa(B,C,sup_sup(fun(B,C),F,G),X) = sup_sup(C,aa(B,C,F,X),aa(B,C,G,X)) ) ) ).

tff(fact_83_sup__assoc,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Z: A,Y: A,X2: A] : ( sup_sup(A,sup_sup(A,X2,Y),Z) = sup_sup(A,X2,sup_sup(A,Y,Z)) ) ) ).

tff(fact_84_inf__sup__aci_I6_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z: A,Y: A,X2: A] : ( sup_sup(A,sup_sup(A,X2,Y),Z) = sup_sup(A,X2,sup_sup(A,Y,Z)) ) ) ).

tff(fact_85_sup_Oassoc,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [C2: A,B2: A,A2: A] : ( sup_sup(A,sup_sup(A,A2,B2),C2) = sup_sup(A,A2,sup_sup(A,B2,C2)) ) ) ).

tff(fact_86_sup__left__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Z: A,Y: A,X2: A] : ( sup_sup(A,X2,sup_sup(A,Y,Z)) = sup_sup(A,Y,sup_sup(A,X2,Z)) ) ) ).

tff(fact_87_inf__sup__aci_I7_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z: A,Y: A,X2: A] : ( sup_sup(A,X2,sup_sup(A,Y,Z)) = sup_sup(A,Y,sup_sup(A,X2,Z)) ) ) ).

tff(fact_88_sup_Oleft__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [C2: A,A2: A,B2: A] : ( sup_sup(A,B2,sup_sup(A,A2,C2)) = sup_sup(A,A2,sup_sup(A,B2,C2)) ) ) ).

tff(fact_89_inf__sup__aci_I8_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X2: A] : ( sup_sup(A,X2,sup_sup(A,X2,Y)) = sup_sup(A,X2,Y) ) ) ).

tff(fact_90_sup__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Y: A,X2: A] : ( sup_sup(A,X2,Y) = sup_sup(A,Y,X2) ) ) ).

tff(fact_91_inf__sup__aci_I5_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X2: A] : ( sup_sup(A,X2,Y) = sup_sup(A,Y,X2) ) ) ).

tff(fact_92_sup_Ocommute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [B2: A,A2: A] : ( sup_sup(A,A2,B2) = sup_sup(A,B2,A2) ) ) ).

tff(fact_93_sup__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [X2: A] : ( sup_sup(A,X2,X2) = X2 ) ) ).

tff(fact_94_sup_Oidem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [A2: A] : ( sup_sup(A,A2,A2) = A2 ) ) ).

tff(fact_95_sup__apply,axiom,
    ! [B: $tType,C: $tType] :
      ( lattice(B)
     => ! [X1: C,G: fun(C,B),F: fun(C,B)] : ( aa(C,B,sup_sup(fun(C,B),F,G),X1) = sup_sup(B,aa(C,B,F,X1),aa(C,B,G,X1)) ) ) ).

tff(fact_96_freq_092_060_094isub_062F__insortTree,axiom,
    ! [A: $tType,Ts: list(huffma1450048681e_tree(A)),T: huffma1450048681e_tree(A),X: A] : ( huffma409467474freq_F(A,huffma1193049432rtTree(A,T,Ts),X) = plus_plus(nat,huffma1352802255e_freq(A,T,X),huffma409467474freq_F(A,Ts,X)) ) ).

tff(fact_97_freq_092_060_094isub_062F_Osimps_I2_J,axiom,
    ! [A: $tType,Ts: list(huffma1450048681e_tree(A)),T: huffma1450048681e_tree(A),X: A] : ( huffma409467474freq_F(A,cons(huffma1450048681e_tree(A),T,Ts),X) = plus_plus(nat,huffma1352802255e_freq(A,T,X),huffma409467474freq_F(A,Ts,X)) ) ).

tff(fact_98_add__right__cancel,axiom,
    ! [B: $tType] :
      ( cancel_semigroup_add(B)
     => ! [C1: B,A1: B,B1: B] :
          ( ( plus_plus(B,B1,A1) = plus_plus(B,C1,A1) )
        <=> ( B1 = C1 ) ) ) ).

%----Arities (8)
tff(arity_fun___Lattices_Osemilattice__sup,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => semilattice_sup(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Olattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => lattice(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Lattices_Osemilattice__sup,axiom,
    semilattice_sup(nat) ).

tff(arity_Nat_Onat___Lattices_Olattice,axiom,
    lattice(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Lattices_Osemilattice__sup,axiom,
    semilattice_sup(bool) ).

tff(arity_HOL_Obool___Lattices_Olattice,axiom,
    lattice(bool) ).

%----Helper facts (8)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    huffma594769176tent_F(a,ts) ).

tff(conj_1,hypothesis,
    ts != nil(huffma1450048681e_tree(a)) ).

tff(conj_2,conjecture,
    huffma1518433673istent(a,huffma607257910uffman(a,ts)) ).

%------------------------------------------------------------------------------
