%------------------------------------------------------------------------------
% File     : SWW539_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Huffman's Algorithm line 935
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla09] Blanchette (2009), Proof Pearl: Mechanizing the Textbo
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : huff_935 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  162 (  43 unt;  39 typ;   0 def)
%            Number of atoms       :  288 ( 143 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  197 (  32   ~;   8   |;  29   &)
%                                         (  25 <=>; 103  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   6 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   40 (  23   >;  17   *;   0   +;   0  <<)
%            Number of predicates  :   13 (  12 usr;   0 prp; 1-3 aty)
%            Number of functors    :   24 (  24 usr;   4 con; 0-5 aty)
%            Number of variables   :  417 ( 374   !;  10   ?; 417   :)
%                                         (  33  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:18:22
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Huffman__Mirabelle__lalbadcutu_Otree,type,
    huffma1450048681e_tree: $tType > $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (33)
tff(sy_cl_Enum_Oenum,type,
    enum: 
      !>[A: $tType] : $o ).

tff(sy_cl_HOL_Oequal,type,
    cl_HOL_Oequal: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_c_HOL_Oequal__class_Oequal,type,
    equal_equal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_OcachedWeight,type,
    huffma854194513Weight: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oconsistent_092_060_094isub_062F,type,
    huffma594769176tent_F: 
      !>[A: $tType] : ( list(huffma1450048681e_tree(A)) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_OinsortTree,type,
    huffma1193049432rtTree: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * list(huffma1450048681e_tree(A)) ) > list(huffma1450048681e_tree(A)) ) ).

tff(sy_c_List_OListMem,type,
    listMem: 
      !>[A: $tType] : ( ( A * list(A) ) > $o ) ).

tff(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Obutlast,type,
    butlast: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olast,type,
    last: 
      !>[A: $tType] : ( list(A) > A ) ).

tff(sy_c_List_Olinorder__class_Oinsort__key,type,
    linorder_insort_key: 
      !>[B: $tType,A: $tType] : ( ( fun(B,A) * B * list(B) ) > list(B) ) ).

tff(sy_c_List_Olinorder__class_Osort__key,type,
    linorder_sort_key: 
      !>[B: $tType,A: $tType] : ( ( fun(B,A) * list(B) ) > list(B) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,fun(list(A),T1)) * list(A) ) > T1 ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,fun(list(A),fun(T1,T1))) * list(A) ) > T1 ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Onull,type,
    null: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_Orotate1,type,
    rotate1: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_t,type,
    t: huffma1450048681e_tree(a) ).

tff(sy_v_ts,type,
    ts: list(huffma1450048681e_tree(a)) ).

%----Relevant facts (100)
tff(fact_0_list_Oinject,axiom,
    ! [B: $tType,List3: list(B),A6: B,List2: list(B),A1: B] :
      ( ( cons(B,A1,List2) = cons(B,A6,List3) )
    <=> ( ( A1 = A6 )
        & ( List2 = List3 ) ) ) ).

tff(fact_1_insortTree_Osimps_I1_J,axiom,
    ! [A: $tType,U: huffma1450048681e_tree(A)] : ( huffma1193049432rtTree(A,U,nil(huffma1450048681e_tree(A))) = cons(huffma1450048681e_tree(A),U,nil(huffma1450048681e_tree(A))) ) ).

tff(fact_2_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != cons(A,X,Xs) ) ).

tff(fact_3_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( cons(A,X,Xs) != Xs ) ).

tff(fact_4_insortTree_Osimps_I2_J,axiom,
    ! [A: $tType,Ts: list(huffma1450048681e_tree(A)),T: huffma1450048681e_tree(A),U: huffma1450048681e_tree(A)] :
      ( ( ord_less_eq(nat,huffma854194513Weight(A,U),huffma854194513Weight(A,T))
       => ( huffma1193049432rtTree(A,U,cons(huffma1450048681e_tree(A),T,Ts)) = cons(huffma1450048681e_tree(A),U,cons(huffma1450048681e_tree(A),T,Ts)) ) )
      & ( ~ ord_less_eq(nat,huffma854194513Weight(A,U),huffma854194513Weight(A,T))
       => ( huffma1193049432rtTree(A,U,cons(huffma1450048681e_tree(A),T,Ts)) = cons(huffma1450048681e_tree(A),T,huffma1193049432rtTree(A,U,Ts)) ) ) ) ).

tff(fact_5_consistent_092_060_094isub_062F_Osimps_I1_J,axiom,
    ! [A: $tType] : huffma594769176tent_F(A,nil(huffma1450048681e_tree(A))) ).

tff(fact_6_insortTree__ne__Nil,axiom,
    ! [A: $tType,Ts: list(huffma1450048681e_tree(A)),T: huffma1450048681e_tree(A)] : ( huffma1193049432rtTree(A,T,Ts) != nil(huffma1450048681e_tree(A)) ) ).

tff(fact_7_list_Osimps_I5_J,axiom,
    ! [B: $tType,C: $tType,List2: list(C),A1: C,F2: fun(C,fun(list(C),B)),F1: B] : ( list_case(B,C,F1,F2,cons(C,A1,List2)) = aa(list(C),B,aa(C,fun(list(C),B),F2,A1),List2) ) ).

tff(fact_8_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys1: list(A),Y: A,Xs: list(A),X: A] : ( splice(A,cons(A,X,Xs),cons(A,Y,Ys1)) = cons(A,X,cons(A,Y,splice(A,Xs,Ys1))) ) ).

tff(fact_9_list_Orecs_I2_J,axiom,
    ! [B: $tType,C: $tType,List2: list(C),A1: C,F2: fun(C,fun(list(C),fun(B,B))),F1: B] : ( list_rec(B,C,F1,F2,cons(C,A1,List2)) = aa(B,B,aa(list(C),fun(B,B),aa(C,fun(list(C),fun(B,B)),F2,A1),List2),list_rec(B,C,F1,F2,List2)) ) ).

tff(fact_10_null__rec_I1_J,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ~ null(A,cons(A,X,Xs)) ).

tff(fact_11_elem,axiom,
    ! [A: $tType,Xs: list(A),X: A] : listMem(A,X,cons(A,X,Xs)) ).

tff(fact_12_null__rec_I2_J,axiom,
    ! [B: $tType] : null(B,nil(B)) ).

tff(fact_13_List_Onull__def,axiom,
    ! [B: $tType,Xs1: list(B)] :
      ( null(B,Xs1)
    <=> ( Xs1 = nil(B) ) ) ).

tff(fact_14_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys1: list(A)] : ( splice(A,nil(A),Ys1) = Ys1 ) ).

tff(fact_15_splice__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( splice(A,Xs,nil(A)) = Xs ) ).

tff(fact_16_eq__Nil__null,axiom,
    ! [B: $tType,Xs1: list(B)] :
      ( ( Xs1 = nil(B) )
    <=> null(B,Xs1) ) ).

tff(fact_17_list_Orecs_I1_J,axiom,
    ! [C: $tType,B: $tType,F2: fun(C,fun(list(C),fun(B,B))),F1: B] : ( list_rec(B,C,F1,F2,nil(C)) = F1 ) ).

tff(fact_18_list_Osimps_I4_J,axiom,
    ! [C: $tType,B: $tType,F2: fun(C,fun(list(C),B)),F1: B] : ( list_case(B,C,F1,F2,nil(C)) = F1 ) ).

tff(fact_19_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_20_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( cons(A,A5,List1) != nil(A) ) ).

tff(fact_21_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( nil(A) != cons(A,A5,List1) ) ).

tff(fact_22_insert,axiom,
    ! [A: $tType,Y: A,Xs: list(A),X: A] :
      ( listMem(A,X,Xs)
     => listMem(A,X,cons(A,Y,Xs)) ) ).

tff(fact_23_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A4: A,List: list(A)] : ( Y != cons(A,A4,List) ) ) ).

tff(fact_24_neq__Nil__conv,axiom,
    ! [B: $tType,Xs1: list(B)] :
      ( ( Xs1 != nil(B) )
    <=> ? [Y3: B,Ys4: list(B)] : ( Xs1 = cons(B,Y3,Ys4) ) ) ).

tff(fact_25_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ord_less_eq(A,X,X) ) ).

tff(fact_26_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = cons(A,X,nil(A)) ) ).

tff(fact_27_equal__Nil__null,axiom,
    ! [B: $tType,Xs1: list(B)] :
      ( pp(aa(list(B),bool,aa(list(B),fun(list(B),bool),equal_equal(list(B)),Xs1),nil(B)))
    <=> null(B,Xs1) ) ).

tff(fact_28_list__ex1__simps_I1_J,axiom,
    ! [B: $tType,P: fun(B,bool)] : ~ list_ex1(B,P,nil(B)) ).

tff(fact_29_list__nonempty__induct,axiom,
    ! [B: $tType,P: fun(list(B),bool),Xs1: list(B)] :
      ( ( Xs1 != nil(B) )
     => ( ! [X1: B] : pp(aa(list(B),bool,P,cons(B,X1,nil(B))))
       => ( ! [X1: B,Xs2: list(B)] :
              ( ( Xs2 != nil(B) )
             => ( pp(aa(list(B),bool,P,Xs2))
               => pp(aa(list(B),bool,P,cons(B,X1,Xs2))) ) )
         => pp(aa(list(B),bool,P,Xs1)) ) ) ) ).

tff(fact_30_last_Osimps,axiom,
    ! [A: $tType,X: A,Xs: list(A)] :
      ( ( ( Xs = nil(A) )
       => ( last(A,cons(A,X,Xs)) = X ) )
      & ( ( Xs != nil(A) )
       => ( last(A,cons(A,X,Xs)) = last(A,Xs) ) ) ) ).

tff(fact_31_le__refl,axiom,
    ! [N: nat] : ord_less_eq(nat,N,N) ).

tff(fact_32_equal__list__def,axiom,
    ! [B: $tType,Y2: list(B),X2: list(B)] :
      ( pp(aa(list(B),bool,aa(list(B),fun(list(B),bool),equal_equal(list(B)),X2),Y2))
    <=> ( X2 = Y2 ) ) ).

tff(fact_33_last__ConsL,axiom,
    ! [A: $tType,X: A,Xs: list(A)] :
      ( ( Xs = nil(A) )
     => ( last(A,cons(A,X,Xs)) = X ) ) ).

tff(fact_34_last__ConsR,axiom,
    ! [A: $tType,X: A,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ( last(A,cons(A,X,Xs)) = last(A,Xs) ) ) ).

tff(fact_35_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ ord_less_eq(A,X,Y)
         => ord_less_eq(A,Y,X) ) ) ).

tff(fact_36_le__funE,axiom,
    ! [C: $tType,B: $tType] :
      ( ord(C)
     => ! [X2: B,G: fun(B,C),F: fun(B,C)] :
          ( ord_less_eq(fun(B,C),F,G)
         => ord_less_eq(C,aa(B,C,F,X2),aa(B,C,G,X2)) ) ) ).

tff(fact_37_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,Z)
           => ord_less_eq(A,X,Z) ) ) ) ).

tff(fact_38_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,X)
           => ( X = Y ) ) ) ) ).

tff(fact_39_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A3: A] :
          ( ord_less_eq(A,A3,B2)
         => ( ( B2 = C2 )
           => ord_less_eq(A,A3,C2) ) ) ) ).

tff(fact_40_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A3: A] :
          ( ( A3 = B2 )
         => ( ord_less_eq(A,B2,C2)
           => ord_less_eq(A,A3,C2) ) ) ) ).

tff(fact_41_order__antisym__conv,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [X2: B,Y2: B] :
          ( ord_less_eq(B,Y2,X2)
         => ( ord_less_eq(B,X2,Y2)
          <=> ( X2 = Y2 ) ) ) ) ).

tff(fact_42_le__funD,axiom,
    ! [C: $tType,B: $tType] :
      ( ord(C)
     => ! [X2: B,G: fun(B,C),F: fun(B,C)] :
          ( ord_less_eq(fun(B,C),F,G)
         => ord_less_eq(C,aa(B,C,F,X2),aa(B,C,G,X2)) ) ) ).

tff(fact_43_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ( X = Y )
         => ord_less_eq(A,X,Y) ) ) ).

tff(fact_44_order__eq__iff,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [Y2: B,X2: B] :
          ( ( X2 = Y2 )
        <=> ( ord_less_eq(B,X2,Y2)
            & ord_less_eq(B,Y2,X2) ) ) ) ).

tff(fact_45_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
          | ord_less_eq(A,Y,X) ) ) ).

tff(fact_46_le__fun__def,axiom,
    ! [C: $tType,B: $tType] :
      ( ord(C)
     => ! [G: fun(B,C),F: fun(B,C)] :
          ( ord_less_eq(fun(B,C),F,G)
        <=> ! [X3: B] : ord_less_eq(C,aa(B,C,F,X3),aa(B,C,G,X3)) ) ) ).

tff(fact_47_le__antisym,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
     => ( ord_less_eq(nat,N,M)
       => ( M = N ) ) ) ).

tff(fact_48_le__trans,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less_eq(nat,I,J)
     => ( ord_less_eq(nat,J,K)
       => ord_less_eq(nat,I,K) ) ) ).

tff(fact_49_eq__imp__le,axiom,
    ! [N: nat,M: nat] :
      ( ( M = N )
     => ord_less_eq(nat,M,N) ) ).

tff(fact_50_nat__le__linear,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
      | ord_less_eq(nat,N,M) ) ).

tff(fact_51_order__subst1,axiom,
    ! [B: $tType,C: $tType] :
      ( ( order(C)
        & order(B) )
     => ! [C1: C,B1: C,F: fun(C,B),A1: B] :
          ( ord_less_eq(B,A1,aa(C,B,F,B1))
         => ( ord_less_eq(C,B1,C1)
           => ( ! [X1: C,Y1: C] :
                  ( ord_less_eq(C,X1,Y1)
                 => ord_less_eq(B,aa(C,B,F,X1),aa(C,B,F,Y1)) )
             => ord_less_eq(B,A1,aa(C,B,F,C1)) ) ) ) ) ).

tff(fact_52_ord__eq__le__subst,axiom,
    ! [B: $tType,C: $tType] :
      ( ( ord(C)
        & ord(B) )
     => ! [C1: C,B1: C,F: fun(C,B),A1: B] :
          ( ( A1 = aa(C,B,F,B1) )
         => ( ord_less_eq(C,B1,C1)
           => ( ! [X1: C,Y1: C] :
                  ( ord_less_eq(C,X1,Y1)
                 => ord_less_eq(B,aa(C,B,F,X1),aa(C,B,F,Y1)) )
             => ord_less_eq(B,A1,aa(C,B,F,C1)) ) ) ) ) ).

tff(fact_53_order__subst2,axiom,
    ! [B: $tType,C: $tType] :
      ( ( order(C)
        & order(B) )
     => ! [C1: C,F: fun(B,C),B1: B,A1: B] :
          ( ord_less_eq(B,A1,B1)
         => ( ord_less_eq(C,aa(B,C,F,B1),C1)
           => ( ! [X1: B,Y1: B] :
                  ( ord_less_eq(B,X1,Y1)
                 => ord_less_eq(C,aa(B,C,F,X1),aa(B,C,F,Y1)) )
             => ord_less_eq(C,aa(B,C,F,A1),C1) ) ) ) ) ).

tff(fact_54_ord__le__eq__subst,axiom,
    ! [B: $tType,C: $tType] :
      ( ( ord(C)
        & ord(B) )
     => ! [C1: C,F: fun(B,C),B1: B,A1: B] :
          ( ord_less_eq(B,A1,B1)
         => ( ( aa(B,C,F,B1) = C1 )
           => ( ! [X1: B,Y1: B] :
                  ( ord_less_eq(B,X1,Y1)
                 => ord_less_eq(C,aa(B,C,F,X1),aa(B,C,F,Y1)) )
             => ord_less_eq(C,aa(B,C,F,A1),C1) ) ) ) ) ).

tff(fact_55_le__funI,axiom,
    ! [C: $tType,B: $tType] :
      ( ord(C)
     => ! [G: fun(B,C),F: fun(B,C)] :
          ( ! [X1: B] : ord_less_eq(C,aa(B,C,F,X1),aa(B,C,G,X1))
         => ord_less_eq(fun(B,C),F,G) ) ) ).

tff(fact_56_eq__equal,axiom,
    ! [B: $tType] :
      ( cl_HOL_Oequal(B)
     => ( fequal(B) = equal_equal(B) ) ) ).

tff(fact_57_equal,axiom,
    ! [B: $tType] :
      ( cl_HOL_Oequal(B)
     => ( equal_equal(B) = fequal(B) ) ) ).

tff(fact_58_equal__refl,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ! [X: A] : pp(aa(A,bool,aa(A,fun(A,bool),equal_equal(A),X),X)) ) ).

tff(fact_59_equal__eq,axiom,
    ! [B: $tType] :
      ( cl_HOL_Oequal(B)
     => ! [Y2: B,X2: B] :
          ( pp(aa(B,bool,aa(B,fun(B,bool),equal_equal(B),X2),Y2))
        <=> ( X2 = Y2 ) ) ) ).

tff(fact_60_butlast_Osimps_I2_J,axiom,
    ! [A: $tType,X: A,Xs: list(A)] :
      ( ( ( Xs = nil(A) )
       => ( butlast(A,cons(A,X,Xs)) = nil(A) ) )
      & ( ( Xs != nil(A) )
       => ( butlast(A,cons(A,X,Xs)) = cons(A,X,butlast(A,Xs)) ) ) ) ).

tff(fact_61_ListMem_Osimps,axiom,
    ! [B: $tType,A2: list(B),A11: B] :
      ( listMem(B,A11,A2)
    <=> ( ? [X3: B,Xs3: list(B)] :
            ( ( A11 = X3 )
            & ( A2 = cons(B,X3,Xs3) ) )
        | ? [X3: B,Xs3: list(B),Y3: B] :
            ( ( A11 = X3 )
            & ( A2 = cons(B,Y3,Xs3) )
            & listMem(B,X3,Xs3) ) ) ) ).

tff(fact_62_insort__key_Osimps_I1_J,axiom,
    ! [C: $tType,B: $tType] :
      ( linorder(C)
     => ! [X2: B,F: fun(B,C)] : ( linorder_insort_key(B,C,F,X2,nil(B)) = cons(B,X2,nil(B)) ) ) ).

tff(fact_63_butlast_Osimps_I1_J,axiom,
    ! [A: $tType] : ( butlast(A,nil(A)) = nil(A) ) ).

tff(fact_64_insort__key_Osimps_I2_J,axiom,
    ! [B: $tType,C: $tType] :
      ( linorder(B)
     => ! [Ys2: list(C),Y2: C,X2: C,F: fun(C,B)] :
          ( ( ord_less_eq(B,aa(C,B,F,X2),aa(C,B,F,Y2))
           => ( linorder_insort_key(C,B,F,X2,cons(C,Y2,Ys2)) = cons(C,X2,cons(C,Y2,Ys2)) ) )
          & ( ~ ord_less_eq(B,aa(C,B,F,X2),aa(C,B,F,Y2))
           => ( linorder_insort_key(C,B,F,X2,cons(C,Y2,Ys2)) = cons(C,Y2,linorder_insort_key(C,B,F,X2,Ys2)) ) ) ) ) ).

tff(fact_65_insort__not__Nil,axiom,
    ! [C: $tType,B: $tType] :
      ( linorder(C)
     => ! [Xs1: list(B),A1: B,F: fun(B,C)] : ( linorder_insort_key(B,C,F,A1,Xs1) != nil(B) ) ) ).

tff(fact_66_insort__key__left__comm,axiom,
    ! [B: $tType,C: $tType] :
      ( linorder(B)
     => ! [Xs1: list(C),Y2: C,X2: C,F: fun(C,B)] :
          ( ( aa(C,B,F,X2) != aa(C,B,F,Y2) )
         => ( linorder_insort_key(C,B,F,Y2,linorder_insort_key(C,B,F,X2,Xs1)) = linorder_insort_key(C,B,F,X2,linorder_insort_key(C,B,F,Y2,Xs1)) ) ) ) ).

tff(fact_67_sort__key__simps_I2_J,axiom,
    ! [C: $tType,B: $tType] :
      ( linorder(C)
     => ! [Xs1: list(B),X2: B,F: fun(B,C)] : ( linorder_sort_key(B,C,F,cons(B,X2,Xs1)) = linorder_insort_key(B,C,F,X2,linorder_sort_key(B,C,F,Xs1)) ) ) ).

tff(fact_68_append__butlast__last__id,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ( append(A,butlast(A,Xs),cons(A,last(A,Xs),nil(A))) = Xs ) ) ).

tff(fact_69_snoc__eq__iff__butlast,axiom,
    ! [B: $tType,Ys2: list(B),X2: B,Xs1: list(B)] :
      ( ( append(B,Xs1,cons(B,X2,nil(B))) = Ys2 )
    <=> ( ( Ys2 != nil(B) )
        & ( butlast(B,Ys2) = Xs1 )
        & ( last(B,Ys2) = X2 ) ) ) ).

tff(fact_70_append__same__eq,axiom,
    ! [B: $tType,Zs: list(B),Xs1: list(B),Ys2: list(B)] :
      ( ( append(B,Ys2,Xs1) = append(B,Zs,Xs1) )
    <=> ( Ys2 = Zs ) ) ).

tff(fact_71_same__append__eq,axiom,
    ! [B: $tType,Zs: list(B),Ys2: list(B),Xs1: list(B)] :
      ( ( append(B,Xs1,Ys2) = append(B,Xs1,Zs) )
    <=> ( Ys2 = Zs ) ) ).

tff(fact_72_append__assoc,axiom,
    ! [A: $tType,Zs1: list(A),Ys1: list(A),Xs: list(A)] : ( append(A,append(A,Xs,Ys1),Zs1) = append(A,Xs,append(A,Ys1,Zs1)) ) ).

tff(fact_73_append__Cons,axiom,
    ! [A: $tType,Ys1: list(A),Xs: list(A),X: A] : ( append(A,cons(A,X,Xs),Ys1) = cons(A,X,append(A,Xs,Ys1)) ) ).

tff(fact_74_append__self__conv2,axiom,
    ! [B: $tType,Ys2: list(B),Xs1: list(B)] :
      ( ( append(B,Xs1,Ys2) = Ys2 )
    <=> ( Xs1 = nil(B) ) ) ).

tff(fact_75_ext,axiom,
    ! [C: $tType,B: $tType,G: fun(B,C),F: fun(B,C)] :
      ( ! [X1: B] : ( aa(B,C,F,X1) = aa(B,C,G,X1) )
     => ( F = G ) ) ).

tff(fact_76_append__self__conv,axiom,
    ! [B: $tType,Ys2: list(B),Xs1: list(B)] :
      ( ( append(B,Xs1,Ys2) = Xs1 )
    <=> ( Ys2 = nil(B) ) ) ).

tff(fact_77_append__is__Nil__conv,axiom,
    ! [B: $tType,Ys2: list(B),Xs1: list(B)] :
      ( ( append(B,Xs1,Ys2) = nil(B) )
    <=> ( ( Xs1 = nil(B) )
        & ( Ys2 = nil(B) ) ) ) ).

tff(fact_78_self__append__conv2,axiom,
    ! [B: $tType,Xs1: list(B),Ys2: list(B)] :
      ( ( Ys2 = append(B,Xs1,Ys2) )
    <=> ( Xs1 = nil(B) ) ) ).

tff(fact_79_self__append__conv,axiom,
    ! [B: $tType,Ys2: list(B),Xs1: list(B)] :
      ( ( Xs1 = append(B,Xs1,Ys2) )
    <=> ( Ys2 = nil(B) ) ) ).

tff(fact_80_Nil__is__append__conv,axiom,
    ! [B: $tType,Ys2: list(B),Xs1: list(B)] :
      ( ( nil(B) = append(B,Xs1,Ys2) )
    <=> ( ( Xs1 = nil(B) )
        & ( Ys2 = nil(B) ) ) ) ).

tff(fact_81_sort__key__simps_I1_J,axiom,
    ! [C: $tType,B: $tType] :
      ( linorder(C)
     => ! [F: fun(B,C)] : ( linorder_sort_key(B,C,F,nil(B)) = nil(B) ) ) ).

tff(fact_82_append1__eq__conv,axiom,
    ! [B: $tType,Y2: B,Ys2: list(B),X2: B,Xs1: list(B)] :
      ( ( append(B,Xs1,cons(B,X2,nil(B))) = append(B,Ys2,cons(B,Y2,nil(B))) )
    <=> ( ( Xs1 = Ys2 )
        & ( X2 = Y2 ) ) ) ).

tff(fact_83_append__eq__appendI,axiom,
    ! [A: $tType,Us1: list(A),Ys1: list(A),Zs1: list(A),Xs11: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Xs11) = Zs1 )
     => ( ( Ys1 = append(A,Xs11,Us1) )
       => ( append(A,Xs,Ys1) = append(A,Zs1,Us1) ) ) ) ).

tff(fact_84_append__eq__append__conv2,axiom,
    ! [B: $tType,Tsa: list(B),Zs: list(B),Ys2: list(B),Xs1: list(B)] :
      ( ( append(B,Xs1,Ys2) = append(B,Zs,Tsa) )
    <=> ? [Us: list(B)] :
          ( ( ( Xs1 = append(B,Zs,Us) )
            & ( append(B,Us,Ys2) = Tsa ) )
          | ( ( append(B,Xs1,Us) = Zs )
            & ( Ys2 = append(B,Us,Tsa) ) ) ) ) ).

tff(fact_85_eq__Nil__appendI,axiom,
    ! [A: $tType,Ys1: list(A),Xs: list(A)] :
      ( ( Xs = Ys1 )
     => ( Xs = append(A,nil(A),Ys1) ) ) ).

tff(fact_86_append__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( append(A,Xs,nil(A)) = Xs ) ).

tff(fact_87_append__Nil,axiom,
    ! [A: $tType,Ys1: list(A)] : ( append(A,nil(A),Ys1) = Ys1 ) ).

tff(fact_88_Cons__eq__appendI,axiom,
    ! [A: $tType,Zs1: list(A),Xs: list(A),Ys1: list(A),Xs11: list(A),X: A] :
      ( ( cons(A,X,Xs11) = Ys1 )
     => ( ( Xs = append(A,Xs11,Zs1) )
       => ( cons(A,X,Xs) = append(A,Ys1,Zs1) ) ) ) ).

tff(fact_89_append__eq__Cons__conv,axiom,
    ! [B: $tType,Xs1: list(B),X2: B,Zs: list(B),Ys2: list(B)] :
      ( ( append(B,Ys2,Zs) = cons(B,X2,Xs1) )
    <=> ( ( ( Ys2 = nil(B) )
          & ( Zs = cons(B,X2,Xs1) ) )
        | ? [Ys3: list(B)] :
            ( ( Ys2 = cons(B,X2,Ys3) )
            & ( append(B,Ys3,Zs) = Xs1 ) ) ) ) ).

tff(fact_90_Cons__eq__append__conv,axiom,
    ! [B: $tType,Zs: list(B),Ys2: list(B),Xs1: list(B),X2: B] :
      ( ( cons(B,X2,Xs1) = append(B,Ys2,Zs) )
    <=> ( ( ( Ys2 = nil(B) )
          & ( cons(B,X2,Xs1) = Zs ) )
        | ? [Ys3: list(B)] :
            ( ( cons(B,X2,Ys3) = Ys2 )
            & ( Xs1 = append(B,Ys3,Zs) ) ) ) ) ).

tff(fact_91_butlast__append,axiom,
    ! [A: $tType,Xs: list(A),Ys1: list(A)] :
      ( ( ( Ys1 = nil(A) )
       => ( butlast(A,append(A,Xs,Ys1)) = butlast(A,Xs) ) )
      & ( ( Ys1 != nil(A) )
       => ( butlast(A,append(A,Xs,Ys1)) = append(A,Xs,butlast(A,Ys1)) ) ) ) ).

tff(fact_92_last__appendL,axiom,
    ! [A: $tType,Xs: list(A),Ys1: list(A)] :
      ( ( Ys1 = nil(A) )
     => ( last(A,append(A,Xs,Ys1)) = last(A,Xs) ) ) ).

tff(fact_93_last__appendR,axiom,
    ! [A: $tType,Xs: list(A),Ys1: list(A)] :
      ( ( Ys1 != nil(A) )
     => ( last(A,append(A,Xs,Ys1)) = last(A,Ys1) ) ) ).

tff(fact_94_last__append,axiom,
    ! [A: $tType,Xs: list(A),Ys1: list(A)] :
      ( ( ( Ys1 = nil(A) )
       => ( last(A,append(A,Xs,Ys1)) = last(A,Xs) ) )
      & ( ( Ys1 != nil(A) )
       => ( last(A,append(A,Xs,Ys1)) = last(A,Ys1) ) ) ) ).

tff(fact_95_butlast__snoc,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( butlast(A,append(A,Xs,cons(A,X,nil(A)))) = Xs ) ).

tff(fact_96_last__snoc,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( last(A,append(A,Xs,cons(A,X,nil(A)))) = X ) ).

tff(fact_97_rev__cases,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ~ ! [Ys: list(A),Y1: A] : ( Xs != append(A,Ys,cons(A,Y1,nil(A))) ) ) ).

tff(fact_98_rev__induct,axiom,
    ! [B: $tType,Xs1: list(B),P: fun(list(B),bool)] :
      ( pp(aa(list(B),bool,P,nil(B)))
     => ( ! [X1: B,Xs2: list(B)] :
            ( pp(aa(list(B),bool,P,Xs2))
           => pp(aa(list(B),bool,P,append(B,Xs2,cons(B,X1,nil(B))))) )
       => pp(aa(list(B),bool,P,Xs1)) ) ) ).

tff(fact_99_rotate__simps,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X: B] :
      ( ( rotate1(A,nil(A)) = nil(A) )
      & ( rotate1(B,cons(B,X,Xs)) = append(B,Xs,cons(B,X,nil(B))) ) ) ).

%----Arities (18)
tff(arity_HOL_Obool___Enum_Oenum,axiom,
    enum(bool) ).

tff(arity_fun___Enum_Oenum,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( enum(T_2)
        & enum(T_1) )
     => enum(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_fun___HOL_Oequal,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( cl_HOL_Oequal(T_2)
        & enum(T_1) )
     => cl_HOL_Oequal(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_Nat_Onat___HOL_Oequal,axiom,
    cl_HOL_Oequal(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

tff(arity_HOL_Obool___HOL_Oequal,axiom,
    cl_HOL_Oequal(bool) ).

tff(arity_List_Olist___HOL_Oequal,axiom,
    ! [T_1: $tType] : cl_HOL_Oequal(list(T_1)) ).

tff(arity_Huffman__Mirabelle__lalbadcutu_Otree___HOL_Oequal,axiom,
    ! [T_1: $tType] : cl_HOL_Oequal(huffma1450048681e_tree(T_1)) ).

%----Helper facts (4)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ( huffma594769176tent_F(a,huffma1193049432rtTree(a,t,ts))
  <=> huffma594769176tent_F(a,cons(huffma1450048681e_tree(a),t,ts)) ) ).

%------------------------------------------------------------------------------
