%------------------------------------------------------------------------------
% File     : SWW538_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Huffman's Algorithm line 895
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla09] Blanchette (2009), Proof Pearl: Mechanizing the Textbo
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : huff_895 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v7.5.0, 0.00 v7.4.0, 0.50 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  174 (  73 unt;  48 typ;   0 def)
%            Number of atoms       :  213 ( 141 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  110 (  23   ~;   3   |;  13   &)
%                                         (  19 <=>;  52  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   4 avg)
%            Maximal term depth    :   10 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   44 (  26   >;  18   *;   0   +;   0  <<)
%            Number of predicates  :   17 (  16 usr;   0 prp; 1-4 aty)
%            Number of functors    :   28 (  28 usr;   4 con; 0-5 aty)
%            Number of variables   :  338 ( 297   !;   2   ?; 338   :)
%                                         (  39  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:18:15
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Huffman__Mirabelle__lalbadcutu_Otree,type,
    huffma1450048681e_tree: $tType > $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (42)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oalphabet,type,
    huffma675207370phabet: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > fun(A,bool) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_OcachedWeight,type,
    huffma854194513Weight: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oconsistent,type,
    huffma1518433673istent: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ocost,type,
    huffma1134658180e_cost: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Odepth,type,
    huffma410068972_depth: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ofreq,type,
    huffma1352802255e_freq: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oheight,type,
    huffma945805758height: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OInnerNode,type,
    huffma1146269203erNode: 
      !>[A: $tType] : ( ( nat * huffma1450048681e_tree(A) * huffma1450048681e_tree(A) ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OLeaf,type,
    huffma2021818691e_Leaf: 
      !>[A: $tType] : ( ( nat * A ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_Otree__case,type,
    huffma107959123e_case: 
      !>[A: $tType,T2: $tType] : ( ( fun(nat,fun(A,T2)) * fun(nat,fun(huffma1450048681e_tree(A),fun(huffma1450048681e_tree(A),T2))) * huffma1450048681e_tree(A) ) > T2 ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_Otree__rec,type,
    huffma1280178957ee_rec: 
      !>[A: $tType,T2: $tType] : ( ( fun(nat,fun(A,T2)) * fun(nat,fun(huffma1450048681e_tree(A),fun(huffma1450048681e_tree(A),fun(T2,fun(T2,T2))))) * huffma1450048681e_tree(A) ) > T2 ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_Otree__size,type,
    huffma1926487300e_size: 
      !>[A: $tType] : ( ( fun(A,nat) * huffma1450048681e_tree(A) ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_OuniteTrees,type,
    huffma921447403eTrees: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * huffma1450048681e_tree(A) ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oweight,type,
    huffma83463279weight: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_If,type,
    if: 
      !>[A: $tType] : ( ( bool * A * A ) > A ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Nat_Onat_Onat__size,type,
    nat_size: nat > nat ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Nat__Transfer_Otransfer__morphism,type,
    nat_tr1645093318rphism: 
      !>[B: $tType,A: $tType] : ( ( fun(B,A) * fun(B,bool) ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_t_092_060_094isub_0621,type,
    t_1: huffma1450048681e_tree(a) ).

tff(sy_v_t_092_060_094isub_0622,type,
    t_2: huffma1450048681e_tree(a) ).

%----Relevant facts (97)
tff(fact_0_nat__add__left__cancel,axiom,
    ! [N1: nat,M1: nat,K: nat] :
      ( ( plus_plus(nat,K,M1) = plus_plus(nat,K,N1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_1_nat__add__right__cancel,axiom,
    ! [N1: nat,K: nat,M1: nat] :
      ( ( plus_plus(nat,M1,K) = plus_plus(nat,N1,K) )
    <=> ( M1 = N1 ) ) ).

tff(fact_2_add__left__cancel,axiom,
    ! [B: $tType] :
      ( cancel_semigroup_add(B)
     => ! [C2: B,B2: B,A1: B] :
          ( ( plus_plus(B,A1,B2) = plus_plus(B,A1,C2) )
        <=> ( B2 = C2 ) ) ) ).

tff(fact_3_add__right__cancel,axiom,
    ! [B: $tType] :
      ( cancel_semigroup_add(B)
     => ! [C2: B,A1: B,B2: B] :
          ( ( plus_plus(B,B2,A1) = plus_plus(B,C2,A1) )
        <=> ( B2 = C2 ) ) ) ).

tff(fact_4_freq_Osimps_I2_J,axiom,
    ! [A: $tType,T_21: huffma1450048681e_tree(A),T_11: huffma1450048681e_tree(A),W1: nat,X3: A] : ( huffma1352802255e_freq(A,huffma1146269203erNode(A,W1,T_11,T_21),X3) = plus_plus(nat,huffma1352802255e_freq(A,T_11,X3),huffma1352802255e_freq(A,T_21,X3)) ) ).

tff(fact_5_nat__add__commute,axiom,
    ! [N2: nat,M2: nat] : ( plus_plus(nat,M2,N2) = plus_plus(nat,N2,M2) ) ).

tff(fact_6_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X1: nat] : ( plus_plus(nat,X1,plus_plus(nat,Y,Z)) = plus_plus(nat,Y,plus_plus(nat,X1,Z)) ) ).

tff(fact_7_nat__add__assoc,axiom,
    ! [K1: nat,N2: nat,M2: nat] : ( plus_plus(nat,plus_plus(nat,M2,N2),K1) = plus_plus(nat,M2,plus_plus(nat,N2,K1)) ) ).

tff(fact_8_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,A3: A] : ( plus_plus(A,A3,C1) = plus_plus(A,C1,A3) ) ) ).

tff(fact_9_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,A3: A] : ( plus_plus(A,A3,plus_plus(A,C1,D)) = plus_plus(A,C1,plus_plus(A,A3,D)) ) ) ).

tff(fact_10_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,A3: A] : ( plus_plus(A,A3,plus_plus(A,C1,D)) = plus_plus(A,plus_plus(A,A3,C1),D) ) ) ).

tff(fact_11_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B1: A,A3: A] : ( plus_plus(A,plus_plus(A,A3,B1),C1) = plus_plus(A,A3,plus_plus(A,B1,C1)) ) ) ).

tff(fact_12_tree_Osimps_I2_J,axiom,
    ! [B: $tType,Tree24: huffma1450048681e_tree(B),Tree14: huffma1450048681e_tree(B),Nat5: nat,Tree2: huffma1450048681e_tree(B),Tree1: huffma1450048681e_tree(B),Nat2: nat] :
      ( ( huffma1146269203erNode(B,Nat2,Tree1,Tree2) = huffma1146269203erNode(B,Nat5,Tree14,Tree24) )
    <=> ( ( Nat2 = Nat5 )
        & ( Tree1 = Tree14 )
        & ( Tree2 = Tree24 ) ) ) ).

tff(fact_13_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A3: A,B1: A] :
          ( ( plus_plus(A,B1,A3) = plus_plus(A,C1,A3) )
         => ( B1 = C1 ) ) ) ).

tff(fact_14_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C1: A,B1: A,A3: A] :
          ( ( plus_plus(A,A3,B1) = plus_plus(A,A3,C1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_15_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B1: A,A3: A] :
          ( ( plus_plus(A,A3,B1) = plus_plus(A,A3,C1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_16_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,B1: A,A3: A] : ( plus_plus(A,plus_plus(A,A3,B1),plus_plus(A,C1,D)) = plus_plus(A,plus_plus(A,A3,C1),plus_plus(A,B1,D)) ) ) ).

tff(fact_17_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B1: A,A3: A] : ( plus_plus(A,plus_plus(A,A3,B1),C1) = plus_plus(A,plus_plus(A,A3,C1),B1) ) ) ).

tff(fact_18_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C1: A,B1: A,A3: A] : ( plus_plus(A,plus_plus(A,A3,B1),C1) = plus_plus(A,A3,plus_plus(A,B1,C1)) ) ) ).

tff(fact_19_uniteTrees__def,axiom,
    ! [A: $tType,T_21: huffma1450048681e_tree(A),T_11: huffma1450048681e_tree(A)] : ( huffma921447403eTrees(A,T_11,T_21) = huffma1146269203erNode(A,plus_plus(nat,huffma854194513Weight(A,T_11),huffma854194513Weight(A,T_21)),T_11,T_21) ) ).

tff(fact_20_weight_Osimps_I2_J,axiom,
    ! [A: $tType,T_21: huffma1450048681e_tree(A),T_11: huffma1450048681e_tree(A),W1: nat] : ( huffma83463279weight(A,huffma1146269203erNode(A,W1,T_11,T_21)) = plus_plus(nat,huffma83463279weight(A,T_11),huffma83463279weight(A,T_21)) ) ).

tff(fact_21_tree_Osimps_I6_J,axiom,
    ! [B: $tType,C: $tType,Tree2: huffma1450048681e_tree(C),Tree1: huffma1450048681e_tree(C),Nat2: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B))),F1: fun(nat,fun(C,B))] : ( huffma107959123e_case(C,B,F1,F2,huffma1146269203erNode(C,Nat2,Tree1,Tree2)) = aa(huffma1450048681e_tree(C),B,aa(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B),aa(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B)),F2,Nat2),Tree1),Tree2) ) ).

tff(fact_22_tree_Orecs_I2_J,axiom,
    ! [B: $tType,C: $tType,Tree2: huffma1450048681e_tree(C),Tree1: huffma1450048681e_tree(C),Nat2: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B,fun(B,B))))),F1: fun(nat,fun(C,B))] : ( huffma1280178957ee_rec(C,B,F1,F2,huffma1146269203erNode(C,Nat2,Tree1,Tree2)) = aa(B,B,aa(B,fun(B,B),aa(huffma1450048681e_tree(C),fun(B,fun(B,B)),aa(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B,fun(B,B))),aa(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B,fun(B,B)))),F2,Nat2),Tree1),Tree2),huffma1280178957ee_rec(C,B,F1,F2,Tree1)),huffma1280178957ee_rec(C,B,F1,F2,Tree2)) ) ).

tff(fact_23_cachedWeight_Osimps_I2_J,axiom,
    ! [A: $tType,T_21: huffma1450048681e_tree(A),T_11: huffma1450048681e_tree(A),W1: nat] : ( huffma854194513Weight(A,huffma1146269203erNode(A,W1,T_11,T_21)) = W1 ) ).

tff(fact_24_cost_Osimps_I2_J,axiom,
    ! [A: $tType,T_21: huffma1450048681e_tree(A),T_11: huffma1450048681e_tree(A),W1: nat] : ( huffma1134658180e_cost(A,huffma1146269203erNode(A,W1,T_11,T_21)) = plus_plus(nat,plus_plus(nat,plus_plus(nat,huffma83463279weight(A,T_11),huffma1134658180e_cost(A,T_11)),huffma83463279weight(A,T_21)),huffma1134658180e_cost(A,T_21)) ) ).

tff(fact_25_of__nat__add,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [N2: nat,M2: nat] : ( semiring_1_of_nat(A,plus_plus(nat,M2,N2)) = plus_plus(A,semiring_1_of_nat(A,M2),semiring_1_of_nat(A,N2)) ) ) ).

tff(fact_26_tree_Osimps_I3_J,axiom,
    ! [A: $tType,Tree23: huffma1450048681e_tree(A),Tree13: huffma1450048681e_tree(A),Nat3: nat,A3: A,Nat: nat] : ( huffma2021818691e_Leaf(A,Nat,A3) != huffma1146269203erNode(A,Nat3,Tree13,Tree23) ) ).

tff(fact_27_tree_Osimps_I4_J,axiom,
    ! [A: $tType,A3: A,Nat: nat,Tree23: huffma1450048681e_tree(A),Tree13: huffma1450048681e_tree(A),Nat3: nat] : ( huffma1146269203erNode(A,Nat3,Tree13,Tree23) != huffma2021818691e_Leaf(A,Nat,A3) ) ).

tff(fact_28_of__nat__eq__iff,axiom,
    ! [B: $tType] :
      ( semiring_char_0(B)
     => ! [N1: nat,M1: nat] :
          ( ( semiring_1_of_nat(B,M1) = semiring_1_of_nat(B,N1) )
        <=> ( M1 = N1 ) ) ) ).

tff(fact_29_tree_Osimps_I1_J,axiom,
    ! [B: $tType,A5: B,Nat5: nat,A1: B,Nat2: nat] :
      ( ( huffma2021818691e_Leaf(B,Nat2,A1) = huffma2021818691e_Leaf(B,Nat5,A5) )
    <=> ( ( Nat2 = Nat5 )
        & ( A1 = A5 ) ) ) ).

tff(fact_30_tree_Osimps_I5_J,axiom,
    ! [B: $tType,C: $tType,A1: C,Nat2: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B))),F1: fun(nat,fun(C,B))] : ( huffma107959123e_case(C,B,F1,F2,huffma2021818691e_Leaf(C,Nat2,A1)) = aa(C,B,aa(nat,fun(C,B),F1,Nat2),A1) ) ).

tff(fact_31_tree_Orecs_I1_J,axiom,
    ! [B: $tType,C: $tType,A1: C,Nat2: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B,fun(B,B))))),F1: fun(nat,fun(C,B))] : ( huffma1280178957ee_rec(C,B,F1,F2,huffma2021818691e_Leaf(C,Nat2,A1)) = aa(C,B,aa(nat,fun(C,B),F1,Nat2),A1) ) ).

tff(fact_32_cachedWeight_Osimps_I1_J,axiom,
    ! [A: $tType,A3: A,W1: nat] : ( huffma854194513Weight(A,huffma2021818691e_Leaf(A,W1,A3)) = W1 ) ).

tff(fact_33_weight_Osimps_I1_J,axiom,
    ! [A: $tType,A3: A,W1: nat] : ( huffma83463279weight(A,huffma2021818691e_Leaf(A,W1,A3)) = W1 ) ).

tff(fact_34_tree_Oexhaust,axiom,
    ! [A: $tType,Y: huffma1450048681e_tree(A)] :
      ( ! [Nat1: nat,A4: A] : ( Y != huffma2021818691e_Leaf(A,Nat1,A4) )
     => ~ ! [Nat1: nat,Tree12: huffma1450048681e_tree(A),Tree22: huffma1450048681e_tree(A)] : ( Y != huffma1146269203erNode(A,Nat1,Tree12,Tree22) ) ) ).

tff(fact_35_cost_Osimps_I1_J,axiom,
    ! [A: $tType,A3: A,W1: nat] : ( huffma1134658180e_cost(A,huffma2021818691e_Leaf(A,W1,A3)) = zero_zero(nat) ) ).

tff(fact_36_freq_Osimps_I1_J,axiom,
    ! [A: $tType,W1: nat,A3: A,X3: A] :
      ( ( ( X3 = A3 )
       => ( huffma1352802255e_freq(A,huffma2021818691e_Leaf(A,W1,A3),X3) = W1 ) )
      & ( ( X3 != A3 )
       => ( huffma1352802255e_freq(A,huffma2021818691e_Leaf(A,W1,A3),X3) = zero_zero(nat) ) ) ) ).

tff(fact_37_consistent_Osimps_I1_J,axiom,
    ! [A: $tType,A3: A,W1: nat] : huffma1518433673istent(A,huffma2021818691e_Leaf(A,W1,A3)) ).

tff(fact_38_zadd__int,axiom,
    ! [N2: nat,M2: nat] : ( plus_plus(int,semiring_1_of_nat(int,M2),semiring_1_of_nat(int,N2)) = semiring_1_of_nat(int,plus_plus(nat,M2,N2)) ) ).

tff(fact_39_Nat__Transfer_Otransfer__int__nat__functions_I1_J,axiom,
    ! [Y: nat,X1: nat] : ( plus_plus(int,semiring_1_of_nat(int,X1),semiring_1_of_nat(int,Y)) = semiring_1_of_nat(int,plus_plus(nat,X1,Y)) ) ).

tff(fact_40_double__eq__0__iff,axiom,
    ! [B: $tType] :
      ( linord219039673up_add(B)
     => ! [A1: B] :
          ( ( plus_plus(B,A1,A1) = zero_zero(B) )
        <=> ( A1 = zero_zero(B) ) ) ) ).

tff(fact_41_double__zero__sym,axiom,
    ! [B: $tType] :
      ( linord219039673up_add(B)
     => ! [A1: B] :
          ( ( zero_zero(B) = plus_plus(B,A1,A1) )
        <=> ( A1 = zero_zero(B) ) ) ) ).

tff(fact_42_add__is__0,axiom,
    ! [N1: nat,M1: nat] :
      ( ( plus_plus(nat,M1,N1) = zero_zero(nat) )
    <=> ( ( M1 = zero_zero(nat) )
        & ( N1 = zero_zero(nat) ) ) ) ).

tff(fact_43_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_44_int__if__cong,axiom,
    ! [Y1: nat,X2: nat,P1: bool] :
      ( ( pp(P1)
       => ( semiring_1_of_nat(int,X2) = semiring_1_of_nat(int,if(nat,P1,X2,Y1)) ) )
      & ( ~ pp(P1)
       => ( semiring_1_of_nat(int,Y1) = semiring_1_of_nat(int,if(nat,P1,X2,Y1)) ) ) ) ).

tff(fact_45_transfer__int__nat__relations_I1_J,axiom,
    ! [Y1: nat,X2: nat] :
      ( ( semiring_1_of_nat(int,X2) = semiring_1_of_nat(int,Y1) )
    <=> ( X2 = Y1 ) ) ).

tff(fact_46_int__int__eq,axiom,
    ! [N1: nat,M1: nat] :
      ( ( semiring_1_of_nat(int,M1) = semiring_1_of_nat(int,N1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_47_zero__reorient,axiom,
    ! [B: $tType] :
      ( zero(B)
     => ! [X2: B] :
          ( ( zero_zero(B) = X2 )
        <=> ( X2 = zero_zero(B) ) ) ) ).

tff(fact_48_add__0__iff,axiom,
    ! [B: $tType] :
      ( semiri456707255roduct(B)
     => ! [A1: B,B2: B] :
          ( ( B2 = plus_plus(B,B2,A1) )
        <=> ( A1 = zero_zero(B) ) ) ) ).

tff(fact_49_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A3: A] : ( plus_plus(A,A3,zero_zero(A)) = A3 ) ) ).

tff(fact_50_comm__semiring__1__class_Onormalizing__semiring__rules_I6_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A3: A] : ( plus_plus(A,A3,zero_zero(A)) = A3 ) ) ).

tff(fact_51_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A3: A] : ( plus_plus(A,A3,zero_zero(A)) = A3 ) ) ).

tff(fact_52_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A3: A] : ( plus_plus(A,zero_zero(A),A3) = A3 ) ) ).

tff(fact_53_comm__semiring__1__class_Onormalizing__semiring__rules_I5_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A3: A] : ( plus_plus(A,zero_zero(A),A3) = A3 ) ) ).

tff(fact_54_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A3: A] : ( plus_plus(A,zero_zero(A),A3) = A3 ) ) ).

tff(fact_55_add__eq__self__zero,axiom,
    ! [N2: nat,M2: nat] :
      ( ( plus_plus(nat,M2,N2) = M2 )
     => ( N2 = zero_zero(nat) ) ) ).

tff(fact_56_Nat_Oadd__0__right,axiom,
    ! [M2: nat] : ( plus_plus(nat,M2,zero_zero(nat)) = M2 ) ).

tff(fact_57_plus__nat_Oadd__0,axiom,
    ! [N2: nat] : ( plus_plus(nat,zero_zero(nat),N2) = N2 ) ).

tff(fact_58_zadd__int__left,axiom,
    ! [Z: int,N2: nat,M2: nat] : ( plus_plus(int,semiring_1_of_nat(int,M2),plus_plus(int,semiring_1_of_nat(int,N2),Z)) = plus_plus(int,semiring_1_of_nat(int,plus_plus(nat,M2,N2)),Z) ) ).

tff(fact_59_tree_Osize_I3_J,axiom,
    ! [A: $tType,A3: A,Nat: nat] : ( size_size(huffma1450048681e_tree(A),huffma2021818691e_Leaf(A,Nat,A3)) = zero_zero(nat) ) ).

tff(fact_60_depth_Osimps_I1_J,axiom,
    ! [A: $tType,A3: A,B1: A,W1: nat] : ( huffma410068972_depth(A,huffma2021818691e_Leaf(A,W1,B1),A3) = zero_zero(nat) ) ).

tff(fact_61_height__0__imp__cachedWeight__eq__weight,axiom,
    ! [A: $tType,T1: huffma1450048681e_tree(A)] :
      ( ( huffma945805758height(A,T1) = zero_zero(nat) )
     => ( huffma854194513Weight(A,T1) = huffma83463279weight(A,T1) ) ) ).

tff(fact_62_height_Osimps_I1_J,axiom,
    ! [A: $tType,A3: A,W1: nat] : ( huffma945805758height(A,huffma2021818691e_Leaf(A,W1,A3)) = zero_zero(nat) ) ).

tff(fact_63_height__0__imp__cost__0,axiom,
    ! [A: $tType,T1: huffma1450048681e_tree(A)] :
      ( ( huffma945805758height(A,T1) = zero_zero(nat) )
     => ( huffma1134658180e_cost(A,T1) = zero_zero(nat) ) ) ).

tff(fact_64_transfer__int__nat__numerals_I1_J,axiom,
    zero_zero(int) = semiring_1_of_nat(int,zero_zero(nat)) ).

tff(fact_65_int__0,axiom,
    semiring_1_of_nat(int,zero_zero(nat)) = zero_zero(int) ).

tff(fact_66_int__eq__0__conv,axiom,
    ! [N1: nat] :
      ( ( semiring_1_of_nat(int,N1) = zero_zero(int) )
    <=> ( N1 = zero_zero(nat) ) ) ).

tff(fact_67_tree_Osize_I4_J,axiom,
    ! [A: $tType,Tree21: huffma1450048681e_tree(A),Tree11: huffma1450048681e_tree(A),Nat: nat] : ( size_size(huffma1450048681e_tree(A),huffma1146269203erNode(A,Nat,Tree11,Tree21)) = plus_plus(nat,plus_plus(nat,size_size(huffma1450048681e_tree(A),Tree11),size_size(huffma1450048681e_tree(A),Tree21)),suc(zero_zero(nat))) ) ).

tff(fact_68_exists__at__height,axiom,
    ! [B: $tType,T: huffma1450048681e_tree(B)] :
      ( huffma1518433673istent(B,T)
     => ? [X: B] :
          ( member(B,X,huffma675207370phabet(B,T))
          & ( huffma410068972_depth(B,T,X) = huffma945805758height(B,T) ) ) ) ).

tff(fact_69_transfer__morphismI,axiom,
    ! [C: $tType,B: $tType,A2: fun(B,bool),F: fun(B,C)] : nat_tr1645093318rphism(B,C,F,A2) ).

tff(fact_70_nat_Oinject,axiom,
    ! [Nat5: nat,Nat2: nat] :
      ( ( suc(Nat2) = suc(Nat5) )
    <=> ( Nat2 = Nat5 ) ) ).

tff(fact_71_add__Suc__right,axiom,
    ! [N2: nat,M2: nat] : ( plus_plus(nat,M2,suc(N2)) = suc(plus_plus(nat,M2,N2)) ) ).

tff(fact_72_add__Suc,axiom,
    ! [N2: nat,M2: nat] : ( plus_plus(nat,suc(M2),N2) = suc(plus_plus(nat,M2,N2)) ) ).

tff(fact_73_Suc__neq__Zero,axiom,
    ! [M2: nat] : ( suc(M2) != zero_zero(nat) ) ).

tff(fact_74_ext,axiom,
    ! [C: $tType,B: $tType,G: fun(B,C),F: fun(B,C)] :
      ( ! [X: B] : ( aa(B,C,F,X) = aa(B,C,G,X) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [B: $tType,A2: fun(B,bool),X2: B] :
      ( member(B,X2,A2)
    <=> pp(aa(B,bool,A2,X2)) ) ).

tff(fact_76_Zero__neq__Suc,axiom,
    ! [M2: nat] : ( zero_zero(nat) != suc(M2) ) ).

tff(fact_77_nat_Osimps_I3_J,axiom,
    ! [Nat4: nat] : ( suc(Nat4) != zero_zero(nat) ) ).

tff(fact_78_Suc__not__Zero,axiom,
    ! [M2: nat] : ( suc(M2) != zero_zero(nat) ) ).

tff(fact_79_nat_Osimps_I2_J,axiom,
    ! [Nat3: nat] : ( zero_zero(nat) != suc(Nat3) ) ).

tff(fact_80_Zero__not__Suc,axiom,
    ! [M2: nat] : ( zero_zero(nat) != suc(M2) ) ).

tff(fact_81_Suc__inject,axiom,
    ! [Y: nat,X1: nat] :
      ( ( suc(X1) = suc(Y) )
     => ( X1 = Y ) ) ).

tff(fact_82_Suc__n__not__n,axiom,
    ! [N2: nat] : ( suc(N2) != N2 ) ).

tff(fact_83_n__not__Suc__n,axiom,
    ! [N2: nat] : ( N2 != suc(N2) ) ).

tff(fact_84_add__Suc__shift,axiom,
    ! [N2: nat,M2: nat] : ( plus_plus(nat,suc(M2),N2) = plus_plus(nat,M2,suc(N2)) ) ).

tff(fact_85_transfer__morphism__def,axiom,
    ! [C: $tType,B: $tType,A2: fun(B,bool),F: fun(B,C)] : nat_tr1645093318rphism(B,C,F,A2) ).

tff(fact_86_add__is__1,axiom,
    ! [N1: nat,M1: nat] :
      ( ( plus_plus(nat,M1,N1) = suc(zero_zero(nat)) )
    <=> ( ( ( M1 = suc(zero_zero(nat)) )
          & ( N1 = zero_zero(nat) ) )
        | ( ( M1 = zero_zero(nat) )
          & ( N1 = suc(zero_zero(nat)) ) ) ) ) ).

tff(fact_87_one__is__add,axiom,
    ! [N1: nat,M1: nat] :
      ( ( suc(zero_zero(nat)) = plus_plus(nat,M1,N1) )
    <=> ( ( ( M1 = suc(zero_zero(nat)) )
          & ( N1 = zero_zero(nat) ) )
        | ( ( M1 = zero_zero(nat) )
          & ( N1 = suc(zero_zero(nat)) ) ) ) ) ).

tff(fact_88_notin__alphabet__imp__freq__0,axiom,
    ! [B: $tType,T: huffma1450048681e_tree(B),A1: B] :
      ( ~ member(B,A1,huffma675207370phabet(B,T))
     => ( huffma1352802255e_freq(B,T,A1) = zero_zero(nat) ) ) ).

tff(fact_89_tree_Osize_I2_J,axiom,
    ! [B: $tType,Tree2: huffma1450048681e_tree(B),Tree1: huffma1450048681e_tree(B),Nat2: nat,Fa: fun(B,nat)] : ( huffma1926487300e_size(B,Fa,huffma1146269203erNode(B,Nat2,Tree1,Tree2)) = plus_plus(nat,plus_plus(nat,huffma1926487300e_size(B,Fa,Tree1),huffma1926487300e_size(B,Fa,Tree2)),suc(zero_zero(nat))) ) ).

tff(fact_90_tree_Osize_I1_J,axiom,
    ! [B: $tType,A1: B,Nat2: nat,Fa: fun(B,nat)] : ( huffma1926487300e_size(B,Fa,huffma2021818691e_Leaf(B,Nat2,A1)) = plus_plus(nat,aa(B,nat,Fa,A1),suc(zero_zero(nat))) ) ).

tff(fact_91_not0__implies__Suc,axiom,
    ! [N2: nat] :
      ( ( N2 != zero_zero(nat) )
     => ? [M: nat] : ( N2 = suc(M) ) ) ).

tff(fact_92_nat__induct,axiom,
    ! [N1: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,zero_zero(nat)))
     => ( ! [N: nat] :
            ( pp(aa(nat,bool,P1,N))
           => pp(aa(nat,bool,P1,suc(N))) )
       => pp(aa(nat,bool,P1,N1)) ) ) ).

tff(fact_93_nat_Oexhaust,axiom,
    ! [Y: nat] :
      ( ( Y != zero_zero(nat) )
     => ~ ! [Nat1: nat] : ( Y != suc(Nat1) ) ) ).

tff(fact_94_zero__induct,axiom,
    ! [K: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,K))
     => ( ! [N: nat] :
            ( pp(aa(nat,bool,P1,suc(N)))
           => pp(aa(nat,bool,P1,N)) )
       => pp(aa(nat,bool,P1,zero_zero(nat))) ) ) ).

tff(fact_95_depth_Osimps_I2_J,axiom,
    ! [B: $tType,T_2: huffma1450048681e_tree(B),W: nat,T_1: huffma1450048681e_tree(B),A1: B] :
      ( ( member(B,A1,huffma675207370phabet(B,T_1))
       => ( huffma410068972_depth(B,huffma1146269203erNode(B,W,T_1,T_2),A1) = plus_plus(nat,huffma410068972_depth(B,T_1,A1),one_one(nat)) ) )
      & ( ~ member(B,A1,huffma675207370phabet(B,T_1))
       => ( ( member(B,A1,huffma675207370phabet(B,T_2))
           => ( huffma410068972_depth(B,huffma1146269203erNode(B,W,T_1,T_2),A1) = plus_plus(nat,huffma410068972_depth(B,T_2,A1),one_one(nat)) ) )
          & ( ~ member(B,A1,huffma675207370phabet(B,T_2))
           => ( huffma410068972_depth(B,huffma1146269203erNode(B,W,T_1,T_2),A1) = zero_zero(nat) ) ) ) ) ) ).

tff(fact_96_nat_Osize_I2_J,axiom,
    ! [Nat: nat] : ( nat_size(suc(Nat)) = plus_plus(nat,nat_size(Nat),suc(zero_zero(nat))) ) ).

%----Arities (23)
tff(arity_Int_Oint___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(int) ).

tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0(int) ).

tff(arity_Int_Oint___Groups_Omonoid__add,axiom,
    monoid_add(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

%----Helper facts (5)
tff(help_If_1_1_T,axiom,
    ! [A: $tType,Y: A,X1: A] : ( if(A,fTrue,X1,Y) = X1 ) ).

tff(help_If_2_1_T,axiom,
    ! [A: $tType,Y: A,X1: A] : ( if(A,fFalse,X1,Y) = Y ) ).

tff(help_If_3_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ! [X: a] : ( huffma1352802255e_freq(a,huffma921447403eTrees(a,t_1,t_2),X) = plus_plus(nat,huffma1352802255e_freq(a,t_1,X),huffma1352802255e_freq(a,t_2,X)) ) ).

%------------------------------------------------------------------------------
