%------------------------------------------------------------------------------
% File     : SWW537_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Huffman's Algorithm line 822
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla09] Blanchette (2009), Proof Pearl: Mechanizing the Textbo
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : huff_822 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  161 (  59 unt;  45 typ;   0 def)
%            Number of atoms       :  216 ( 102 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  126 (  26   ~;   4   |;   8   &)
%                                         (  20 <=>;  68  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   5 avg)
%            Maximal term depth    :   10 (   1 avg)
%            Number of types       :    7 (   6 usr)
%            Number of type conns  :   42 (  25   >;  17   *;   0   +;   0  <<)
%            Number of predicates  :   15 (  14 usr;   0 prp; 1-3 aty)
%            Number of functors    :   25 (  25 usr;   3 con; 0-5 aty)
%            Number of variables   :  320 ( 285   !;   3   ?; 320   :)
%                                         (  32  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:17:59
%------------------------------------------------------------------------------
%----Should-be-implicit typings (8)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Huffman__Mirabelle__lalbadcutu_Otree,type,
    huffma1450048681e_tree: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_String_Ochar,type,
    char1: $tType ).

tff(ty_tc_String_Oliteral,type,
    literal: $tType ).

tff(ty_tc_String_Onibble,type,
    nibble: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (37)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A2: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A2: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A2: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A2: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A2: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A2: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A2: $tType] : $o ).

tff(sy_cl_Groups_Oordered__comm__monoid__add,type,
    ordere216010020id_add: 
      !>[A2: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A2: $tType] : $o ).

tff(sy_cl_Groups_Oordered__cancel__ab__semigroup__add,type,
    ordere223160158up_add: 
      !>[A2: $tType] : $o ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A2: $tType] : ( ( A2 * A2 ) > A2 ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A2: $tType] : A2 ).

tff(sy_c_HOL_Obool_Obool__size,type,
    bool_size: bool > nat ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oalphabet,type,
    huffma675207370phabet: 
      !>[A2: $tType] : ( huffma1450048681e_tree(A2) > fun(A2,bool) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oconsistent,type,
    huffma1518433673istent: 
      !>[A2: $tType] : ( huffma1450048681e_tree(A2) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ocost,type,
    huffma1134658180e_cost: 
      !>[A2: $tType] : ( huffma1450048681e_tree(A2) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Odepth,type,
    huffma410068972_depth: 
      !>[A2: $tType] : ( ( huffma1450048681e_tree(A2) * A2 ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ofreq,type,
    huffma1352802255e_freq: 
      !>[A2: $tType] : ( ( huffma1450048681e_tree(A2) * A2 ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oheight,type,
    huffma945805758height: 
      !>[A2: $tType] : ( huffma1450048681e_tree(A2) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OInnerNode,type,
    huffma1146269203erNode: 
      !>[A2: $tType] : ( ( nat * huffma1450048681e_tree(A2) * huffma1450048681e_tree(A2) ) > huffma1450048681e_tree(A2) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OLeaf,type,
    huffma2021818691e_Leaf: 
      !>[A2: $tType] : ( ( nat * A2 ) > huffma1450048681e_tree(A2) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_Otree__case,type,
    huffma107959123e_case: 
      !>[A2: $tType,T1: $tType] : ( ( fun(nat,fun(A2,T1)) * fun(nat,fun(huffma1450048681e_tree(A2),fun(huffma1450048681e_tree(A2),T1))) * huffma1450048681e_tree(A2) ) > T1 ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_Otree__rec,type,
    huffma1280178957ee_rec: 
      !>[A2: $tType,T1: $tType] : ( ( fun(nat,fun(A2,T1)) * fun(nat,fun(huffma1450048681e_tree(A2),fun(huffma1450048681e_tree(A2),fun(T1,fun(T1,T1))))) * huffma1450048681e_tree(A2) ) > T1 ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oweight,type,
    huffma83463279weight: 
      !>[A2: $tType] : ( huffma1450048681e_tree(A2) > nat ) ).

tff(sy_c_Nat_Onat_Onat__size,type,
    nat_size: nat > nat ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A2: $tType] : ( A2 > nat ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A2: $tType] : ( ( A2 * A2 ) > $o ) ).

tff(sy_c_String_Ochar_OChar,type,
    char: ( nibble * nibble ) > char1 ).

tff(sy_c_String_Ochar_Ochar__case,type,
    char_case: 
      !>[T1: $tType] : ( ( fun(nibble,fun(nibble,T1)) * char1 ) > T1 ) ).

tff(sy_c_String_Ochar_Ochar__rec,type,
    char_rec: 
      !>[T1: $tType] : ( ( fun(nibble,fun(nibble,T1)) * char1 ) > T1 ) ).

tff(sy_c_String_Ochar_Ochar__size,type,
    char_size: char1 > nat ).

tff(sy_c_aa,type,
    aa: 
      !>[A2: $tType,B: $tType] : ( ( fun(A2,B) * A2 ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A2: $tType] : ( ( A2 * fun(A2,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_t,type,
    t: huffma1450048681e_tree(a) ).

%----Relevant facts (99)
tff(fact_0_cost_Osimps_I1_J,axiom,
    ! [A2: $tType,A3: A2,W: nat] : ( huffma1134658180e_cost(A2,huffma2021818691e_Leaf(A2,W,A3)) = zero_zero(nat) ) ).

tff(fact_1_height_Osimps_I1_J,axiom,
    ! [A2: $tType,A3: A2,W: nat] : ( huffma945805758height(A2,huffma2021818691e_Leaf(A2,W,A3)) = zero_zero(nat) ) ).

tff(fact_2_zero__reorient,axiom,
    ! [B: $tType] :
      ( zero(B)
     => ! [X1: B] :
          ( ( zero_zero(B) = X1 )
        <=> ( X1 = zero_zero(B) ) ) ) ).

tff(fact_3_bool_Osize_I1_J,axiom,
    bool_size(fTrue) = zero_zero(nat) ).

tff(fact_4_bool_Osize_I2_J,axiom,
    bool_size(fFalse) = zero_zero(nat) ).

tff(fact_5_char__size,axiom,
    ! [C1: char1] : ( char_size(C1) = zero_zero(nat) ) ).

tff(fact_6_nat_Osize_I1_J,axiom,
    nat_size(zero_zero(nat)) = zero_zero(nat) ).

tff(fact_7_size__char,axiom,
    ! [C1: char1] : ( size_size(char1,C1) = zero_zero(nat) ) ).

tff(fact_8_bool_Osize_I3_J,axiom,
    size_size(bool,fTrue) = zero_zero(nat) ).

tff(fact_9_bool_Osize_I4_J,axiom,
    size_size(bool,fFalse) = zero_zero(nat) ).

tff(fact_10_size__literal__def,axiom,
    ! [S: literal] : ( size_size(literal,S) = zero_zero(nat) ) ).

tff(fact_11_tree_Osimps_I1_J,axiom,
    ! [B: $tType,A5: B,Nat4: nat,A: B,Nat1: nat] :
      ( ( huffma2021818691e_Leaf(B,Nat1,A) = huffma2021818691e_Leaf(B,Nat4,A5) )
    <=> ( ( Nat1 = Nat4 )
        & ( A = A5 ) ) ) ).

tff(fact_12_size__bool,axiom,
    ! [B2: bool] : ( size_size(bool,B2) = zero_zero(nat) ) ).

tff(fact_13_tree_Osize_I3_J,axiom,
    ! [A2: $tType,A3: A2,Nat3: nat] : ( size_size(huffma1450048681e_tree(A2),huffma2021818691e_Leaf(A2,Nat3,A3)) = zero_zero(nat) ) ).

tff(fact_14_freq_Osimps_I1_J,axiom,
    ! [A2: $tType,W: nat,A3: A2,X3: A2] :
      ( ( ( X3 = A3 )
       => ( huffma1352802255e_freq(A2,huffma2021818691e_Leaf(A2,W,A3),X3) = W ) )
      & ( ( X3 != A3 )
       => ( huffma1352802255e_freq(A2,huffma2021818691e_Leaf(A2,W,A3),X3) = zero_zero(nat) ) ) ) ).

tff(fact_15_depth_Osimps_I1_J,axiom,
    ! [A2: $tType,A3: A2,B1: A2,W: nat] : ( huffma410068972_depth(A2,huffma2021818691e_Leaf(A2,W,B1),A3) = zero_zero(nat) ) ).

tff(fact_16_tree_Osimps_I5_J,axiom,
    ! [B: $tType,C: $tType,A: C,Nat1: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B))),F1: fun(nat,fun(C,B))] : ( huffma107959123e_case(C,B,F1,F2,huffma2021818691e_Leaf(C,Nat1,A)) = aa(C,B,aa(nat,fun(C,B),F1,Nat1),A) ) ).

tff(fact_17_nat_Osize_I3_J,axiom,
    size_size(nat,zero_zero(nat)) = zero_zero(nat) ).

tff(fact_18_consistent_Osimps_I1_J,axiom,
    ! [A2: $tType,A3: A2,W: nat] : huffma1518433673istent(A2,huffma2021818691e_Leaf(A2,W,A3)) ).

tff(fact_19_tree_Orecs_I1_J,axiom,
    ! [B: $tType,C: $tType,A: C,Nat1: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B,fun(B,B))))),F1: fun(nat,fun(C,B))] : ( huffma1280178957ee_rec(C,B,F1,F2,huffma2021818691e_Leaf(C,Nat1,A)) = aa(C,B,aa(nat,fun(C,B),F1,Nat1),A) ) ).

tff(fact_20_char_Osize_I2_J,axiom,
    ! [Nibble23: nibble,Nibble13: nibble] : ( size_size(char1,char(Nibble13,Nibble23)) = zero_zero(nat) ) ).

tff(fact_21_char_Osize_I1_J,axiom,
    ! [Nibble23: nibble,Nibble13: nibble] : ( char_size(char(Nibble13,Nibble23)) = zero_zero(nat) ) ).

tff(fact_22_char_Oinject,axiom,
    ! [Nibble22: nibble,Nibble12: nibble,Nibble2: nibble,Nibble1: nibble] :
      ( ( char(Nibble1,Nibble2) = char(Nibble12,Nibble22) )
    <=> ( ( Nibble1 = Nibble12 )
        & ( Nibble2 = Nibble22 ) ) ) ).

tff(fact_23_nat__size,axiom,
    ! [N: nat] : ( size_size(nat,N) = N ) ).

tff(fact_24_char_Oexhaust,axiom,
    ! [Y: char1] :
      ~ ! [Nibble11: nibble,Nibble21: nibble] : ( Y != char(Nibble11,Nibble21) ) ).

tff(fact_25_char_Orecs,axiom,
    ! [B: $tType,Nibble2: nibble,Nibble1: nibble,F1: fun(nibble,fun(nibble,B))] : ( char_rec(B,F1,char(Nibble1,Nibble2)) = aa(nibble,B,aa(nibble,fun(nibble,B),F1,Nibble1),Nibble2) ) ).

tff(fact_26_char_Osimps_I2_J,axiom,
    ! [B: $tType,Nibble2: nibble,Nibble1: nibble,F1: fun(nibble,fun(nibble,B))] : ( char_case(B,F1,char(Nibble1,Nibble2)) = aa(nibble,B,aa(nibble,fun(nibble,B),F1,Nibble1),Nibble2) ) ).

tff(fact_27_exists__at__height,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B)] :
      ( huffma1518433673istent(B,Ta)
     => ? [X2: B] :
          ( member(B,X2,huffma675207370phabet(B,Ta))
          & ( huffma410068972_depth(B,Ta,X2) = huffma945805758height(B,Ta) ) ) ) ).

tff(fact_28_tree_Osimps_I6_J,axiom,
    ! [B: $tType,C: $tType,Tree21: huffma1450048681e_tree(C),Tree11: huffma1450048681e_tree(C),Nat1: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B))),F1: fun(nat,fun(C,B))] : ( huffma107959123e_case(C,B,F1,F2,huffma1146269203erNode(C,Nat1,Tree11,Tree21)) = aa(huffma1450048681e_tree(C),B,aa(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B),aa(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B)),F2,Nat1),Tree11),Tree21) ) ).

tff(fact_29_notin__alphabet__imp__freq__0,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B),A: B] :
      ( ~ member(B,A,huffma675207370phabet(B,Ta))
     => ( huffma1352802255e_freq(B,Ta,A) = zero_zero(nat) ) ) ).

tff(fact_30_weight_Osimps_I1_J,axiom,
    ! [A2: $tType,A3: A2,W: nat] : ( huffma83463279weight(A2,huffma2021818691e_Leaf(A2,W,A3)) = W ) ).

tff(fact_31_tree_Osimps_I2_J,axiom,
    ! [B: $tType,Tree23: huffma1450048681e_tree(B),Tree13: huffma1450048681e_tree(B),Nat4: nat,Tree21: huffma1450048681e_tree(B),Tree11: huffma1450048681e_tree(B),Nat1: nat] :
      ( ( huffma1146269203erNode(B,Nat1,Tree11,Tree21) = huffma1146269203erNode(B,Nat4,Tree13,Tree23) )
    <=> ( ( Nat1 = Nat4 )
        & ( Tree11 = Tree13 )
        & ( Tree21 = Tree23 ) ) ) ).

tff(fact_32_tree_Osimps_I3_J,axiom,
    ! [A2: $tType,Tree22: huffma1450048681e_tree(A2),Tree12: huffma1450048681e_tree(A2),Nat2: nat,A3: A2,Nat3: nat] : ( huffma2021818691e_Leaf(A2,Nat3,A3) != huffma1146269203erNode(A2,Nat2,Tree12,Tree22) ) ).

tff(fact_33_tree_Osimps_I4_J,axiom,
    ! [A2: $tType,A3: A2,Nat3: nat,Tree22: huffma1450048681e_tree(A2),Tree12: huffma1450048681e_tree(A2),Nat2: nat] : ( huffma1146269203erNode(A2,Nat2,Tree12,Tree22) != huffma2021818691e_Leaf(A2,Nat3,A3) ) ).

tff(fact_34_tree_Orecs_I2_J,axiom,
    ! [B: $tType,C: $tType,Tree21: huffma1450048681e_tree(C),Tree11: huffma1450048681e_tree(C),Nat1: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B,fun(B,B))))),F1: fun(nat,fun(C,B))] : ( huffma1280178957ee_rec(C,B,F1,F2,huffma1146269203erNode(C,Nat1,Tree11,Tree21)) = aa(B,B,aa(B,fun(B,B),aa(huffma1450048681e_tree(C),fun(B,fun(B,B)),aa(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B,fun(B,B))),aa(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B,fun(B,B)))),F2,Nat1),Tree11),Tree21),huffma1280178957ee_rec(C,B,F1,F2,Tree11)),huffma1280178957ee_rec(C,B,F1,F2,Tree21)) ) ).

tff(fact_35_exists__in__alphabet,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B)] :
    ? [A4: B] : member(B,A4,huffma675207370phabet(B,Ta)) ).

tff(fact_36_cost_Osimps_I2_J,axiom,
    ! [A2: $tType,T_2: huffma1450048681e_tree(A2),T_1: huffma1450048681e_tree(A2),W: nat] : ( huffma1134658180e_cost(A2,huffma1146269203erNode(A2,W,T_1,T_2)) = plus_plus(nat,plus_plus(nat,plus_plus(nat,huffma83463279weight(A2,T_1),huffma1134658180e_cost(A2,T_1)),huffma83463279weight(A2,T_2)),huffma1134658180e_cost(A2,T_2)) ) ).

tff(fact_37_tree_Oexhaust,axiom,
    ! [A2: $tType,Y: huffma1450048681e_tree(A2)] :
      ( ! [Nat: nat,A4: A2] : ( Y != huffma2021818691e_Leaf(A2,Nat,A4) )
     => ~ ! [Nat: nat,Tree1: huffma1450048681e_tree(A2),Tree2: huffma1450048681e_tree(A2)] : ( Y != huffma1146269203erNode(A2,Nat,Tree1,Tree2) ) ) ).

tff(fact_38_height__gt__0__alphabet__eq__imp__height__gt__0,axiom,
    ! [B: $tType,U: huffma1450048681e_tree(B),Ta: huffma1450048681e_tree(B)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B,Ta))
     => ( huffma1518433673istent(B,Ta)
       => ( ( huffma675207370phabet(B,Ta) = huffma675207370phabet(B,U) )
         => ord_less(nat,zero_zero(nat),huffma945805758height(B,U)) ) ) ) ).

tff(fact_39_weight_Osimps_I2_J,axiom,
    ! [A2: $tType,T_2: huffma1450048681e_tree(A2),T_1: huffma1450048681e_tree(A2),W: nat] : ( huffma83463279weight(A2,huffma1146269203erNode(A2,W,T_1,T_2)) = plus_plus(nat,huffma83463279weight(A2,T_1),huffma83463279weight(A2,T_2)) ) ).

tff(fact_40_freq_Osimps_I2_J,axiom,
    ! [A2: $tType,T_2: huffma1450048681e_tree(A2),T_1: huffma1450048681e_tree(A2),W: nat,X3: A2] : ( huffma1352802255e_freq(A2,huffma1146269203erNode(A2,W,T_1,T_2),X3) = plus_plus(nat,huffma1352802255e_freq(A2,T_1,X3),huffma1352802255e_freq(A2,T_2,X3)) ) ).

tff(fact_41_add__left__cancel,axiom,
    ! [B: $tType] :
      ( cancel_semigroup_add(B)
     => ! [C2: B,B2: B,A: B] :
          ( ( plus_plus(B,A,B2) = plus_plus(B,A,C2) )
        <=> ( B2 = C2 ) ) ) ).

tff(fact_42_add__right__cancel,axiom,
    ! [B: $tType] :
      ( cancel_semigroup_add(B)
     => ! [C2: B,A: B,B2: B] :
          ( ( plus_plus(B,B2,A) = plus_plus(B,C2,A) )
        <=> ( B2 = C2 ) ) ) ).

tff(fact_43_double__zero__sym,axiom,
    ! [B: $tType] :
      ( linord219039673up_add(B)
     => ! [A: B] :
          ( ( zero_zero(B) = plus_plus(B,A,A) )
        <=> ( A = zero_zero(B) ) ) ) ).

tff(fact_44_add__less__cancel__right,axiom,
    ! [B: $tType] :
      ( ordere236663937imp_le(B)
     => ! [B2: B,C2: B,A: B] :
          ( ord_less(B,plus_plus(B,A,C2),plus_plus(B,B2,C2))
        <=> ord_less(B,A,B2) ) ) ).

tff(fact_45_add__less__cancel__left,axiom,
    ! [B: $tType] :
      ( ordere236663937imp_le(B)
     => ! [B2: B,A: B,C2: B] :
          ( ord_less(B,plus_plus(B,C2,A),plus_plus(B,C2,B2))
        <=> ord_less(B,A,B2) ) ) ).

tff(fact_46_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [B: $tType] :
      ( linord219039673up_add(B)
     => ! [A: B] :
          ( ord_less(B,zero_zero(B),plus_plus(B,A,A))
        <=> ord_less(B,zero_zero(B),A) ) ) ).

tff(fact_47_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [B: $tType] :
      ( linord219039673up_add(B)
     => ! [A: B] :
          ( ord_less(B,plus_plus(B,A,A),zero_zero(B))
        <=> ord_less(B,A,zero_zero(B)) ) ) ).

tff(fact_48_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A2: $tType] :
      ( ab_semigroup_add(A2)
     => ! [C1: A2,B1: A2,A3: A2] : ( plus_plus(A2,plus_plus(A2,A3,B1),C1) = plus_plus(A2,A3,plus_plus(A2,B1,C1)) ) ) ).

tff(fact_49_add__pos__pos,axiom,
    ! [A2: $tType] :
      ( ordere216010020id_add(A2)
     => ! [B1: A2,A3: A2] :
          ( ord_less(A2,zero_zero(A2),A3)
         => ( ord_less(A2,zero_zero(A2),B1)
           => ord_less(A2,zero_zero(A2),plus_plus(A2,A3,B1)) ) ) ) ).

tff(fact_50_add__neg__neg,axiom,
    ! [A2: $tType] :
      ( ordere216010020id_add(A2)
     => ! [B1: A2,A3: A2] :
          ( ord_less(A2,A3,zero_zero(A2))
         => ( ord_less(A2,B1,zero_zero(A2))
           => ord_less(A2,plus_plus(A2,A3,B1),zero_zero(A2)) ) ) ) ).

tff(fact_51_add__strict__right__mono,axiom,
    ! [A2: $tType] :
      ( ordere223160158up_add(A2)
     => ! [C1: A2,B1: A2,A3: A2] :
          ( ord_less(A2,A3,B1)
         => ord_less(A2,plus_plus(A2,A3,C1),plus_plus(A2,B1,C1)) ) ) ).

tff(fact_52_add__strict__left__mono,axiom,
    ! [A2: $tType] :
      ( ordere223160158up_add(A2)
     => ! [C1: A2,B1: A2,A3: A2] :
          ( ord_less(A2,A3,B1)
         => ord_less(A2,plus_plus(A2,C1,A3),plus_plus(A2,C1,B1)) ) ) ).

tff(fact_53_add__strict__mono,axiom,
    ! [A2: $tType] :
      ( ordere223160158up_add(A2)
     => ! [D: A2,C1: A2,B1: A2,A3: A2] :
          ( ord_less(A2,A3,B1)
         => ( ord_less(A2,C1,D)
           => ord_less(A2,plus_plus(A2,A3,C1),plus_plus(A2,B1,D)) ) ) ) ).

tff(fact_54_add__left__imp__eq,axiom,
    ! [A2: $tType] :
      ( cancel_semigroup_add(A2)
     => ! [C1: A2,B1: A2,A3: A2] :
          ( ( plus_plus(A2,A3,B1) = plus_plus(A2,A3,C1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_55_add__imp__eq,axiom,
    ! [A2: $tType] :
      ( cancel146912293up_add(A2)
     => ! [C1: A2,B1: A2,A3: A2] :
          ( ( plus_plus(A2,A3,B1) = plus_plus(A2,A3,C1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_56_add__right__imp__eq,axiom,
    ! [A2: $tType] :
      ( cancel_semigroup_add(A2)
     => ! [C1: A2,A3: A2,B1: A2] :
          ( ( plus_plus(A2,B1,A3) = plus_plus(A2,C1,A3) )
         => ( B1 = C1 ) ) ) ).

tff(fact_57_add__less__imp__less__right,axiom,
    ! [A2: $tType] :
      ( ordere236663937imp_le(A2)
     => ! [B1: A2,C1: A2,A3: A2] :
          ( ord_less(A2,plus_plus(A2,A3,C1),plus_plus(A2,B1,C1))
         => ord_less(A2,A3,B1) ) ) ).

tff(fact_58_add__less__imp__less__left,axiom,
    ! [A2: $tType] :
      ( ordere236663937imp_le(A2)
     => ! [B1: A2,A3: A2,C1: A2] :
          ( ord_less(A2,plus_plus(A2,C1,A3),plus_plus(A2,C1,B1))
         => ord_less(A2,A3,B1) ) ) ).

tff(fact_59_add__0__left,axiom,
    ! [A2: $tType] :
      ( monoid_add(A2)
     => ! [A3: A2] : ( plus_plus(A2,zero_zero(A2),A3) = A3 ) ) ).

tff(fact_60_add__0,axiom,
    ! [A2: $tType] :
      ( comm_monoid_add(A2)
     => ! [A3: A2] : ( plus_plus(A2,zero_zero(A2),A3) = A3 ) ) ).

tff(fact_61_add__0__right,axiom,
    ! [A2: $tType] :
      ( monoid_add(A2)
     => ! [A3: A2] : ( plus_plus(A2,A3,zero_zero(A2)) = A3 ) ) ).

tff(fact_62_add_Ocomm__neutral,axiom,
    ! [A2: $tType] :
      ( comm_monoid_add(A2)
     => ! [A3: A2] : ( plus_plus(A2,A3,zero_zero(A2)) = A3 ) ) ).

tff(fact_63_add__gr__0,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,zero_zero(nat),plus_plus(nat,M1,N1))
    <=> ( ord_less(nat,zero_zero(nat),M1)
        | ord_less(nat,zero_zero(nat),N1) ) ) ).

tff(fact_64_nat__add__left__cancel__less,axiom,
    ! [N1: nat,M1: nat,K2: nat] :
      ( ord_less(nat,plus_plus(nat,K2,M1),plus_plus(nat,K2,N1))
    <=> ord_less(nat,M1,N1) ) ).

tff(fact_65_add__is__0,axiom,
    ! [N1: nat,M1: nat] :
      ( ( plus_plus(nat,M1,N1) = zero_zero(nat) )
    <=> ( ( M1 = zero_zero(nat) )
        & ( N1 = zero_zero(nat) ) ) ) ).

tff(fact_66_less__zeroE,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_67_less__nat__zero__code,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_68_nat__add__left__cancel,axiom,
    ! [N1: nat,M1: nat,K2: nat] :
      ( ( plus_plus(nat,K2,M1) = plus_plus(nat,K2,N1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_69_nat__add__right__cancel,axiom,
    ! [N1: nat,K2: nat,M1: nat] :
      ( ( plus_plus(nat,M1,K2) = plus_plus(nat,N1,K2) )
    <=> ( M1 = N1 ) ) ).

tff(fact_70_neq0__conv,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_71_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_72_nat__neq__iff,axiom,
    ! [N1: nat,M1: nat] :
      ( ( M1 != N1 )
    <=> ( ord_less(nat,M1,N1)
        | ord_less(nat,N1,M1) ) ) ).

tff(fact_73_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_74_ext,axiom,
    ! [C: $tType,B: $tType,G: fun(B,C),F: fun(B,C)] :
      ( ! [X2: B] : ( aa(B,C,F,X2) = aa(B,C,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [B: $tType,A1: fun(B,bool),X1: B] :
      ( member(B,X1,A1)
    <=> pp(aa(B,bool,A1,X1)) ) ).

tff(fact_76_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_77_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( ord_less(nat,N,M)
     => ( M != N ) ) ).

tff(fact_78_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_79_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),N1: nat,M1: nat] :
      ( ( ord_less(nat,M1,N1)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) )
     => ( ( ( M1 = N1 )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) )
       => ( ( ord_less(nat,N1,M1)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) ) ) ) ).

tff(fact_80_nat__add__commute,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,M,N) = plus_plus(nat,N,M) ) ).

tff(fact_81_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X: nat] : ( plus_plus(nat,X,plus_plus(nat,Y,Z)) = plus_plus(nat,Y,plus_plus(nat,X,Z)) ) ).

tff(fact_82_nat__add__assoc,axiom,
    ! [K1: nat,N: nat,M: nat] : ( plus_plus(nat,plus_plus(nat,M,N),K1) = plus_plus(nat,M,plus_plus(nat,N,K1)) ) ).

tff(fact_83_not__less0,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_84_gr__implies__not0,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ( N != zero_zero(nat) ) ) ).

tff(fact_85_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_86_plus__nat_Oadd__0,axiom,
    ! [N: nat] : ( plus_plus(nat,zero_zero(nat),N) = N ) ).

tff(fact_87_Nat_Oadd__0__right,axiom,
    ! [M: nat] : ( plus_plus(nat,M,zero_zero(nat)) = M ) ).

tff(fact_88_add__eq__self__zero,axiom,
    ! [N: nat,M: nat] :
      ( ( plus_plus(nat,M,N) = M )
     => ( N = zero_zero(nat) ) ) ).

tff(fact_89_not__add__less1,axiom,
    ! [J: nat,I: nat] : ~ ord_less(nat,plus_plus(nat,I,J),I) ).

tff(fact_90_not__add__less2,axiom,
    ! [I: nat,J: nat] : ~ ord_less(nat,plus_plus(nat,J,I),I) ).

tff(fact_91_trans__less__add1,axiom,
    ! [M: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,I,plus_plus(nat,J,M)) ) ).

tff(fact_92_trans__less__add2,axiom,
    ! [M: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,I,plus_plus(nat,M,J)) ) ).

tff(fact_93_add__less__mono1,axiom,
    ! [K1: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,plus_plus(nat,I,K1),plus_plus(nat,J,K1)) ) ).

tff(fact_94_add__less__mono,axiom,
    ! [L: nat,K1: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ( ord_less(nat,K1,L)
       => ord_less(nat,plus_plus(nat,I,K1),plus_plus(nat,J,L)) ) ) ).

tff(fact_95_less__add__eq__less,axiom,
    ! [N: nat,M: nat,L: nat,K1: nat] :
      ( ord_less(nat,K1,L)
     => ( ( plus_plus(nat,M,L) = plus_plus(nat,K1,N) )
       => ord_less(nat,M,N) ) ) ).

tff(fact_96_add__lessD1,axiom,
    ! [K1: nat,J: nat,I: nat] :
      ( ord_less(nat,plus_plus(nat,I,J),K1)
     => ord_less(nat,I,K1) ) ).

tff(fact_97_double__eq__0__iff,axiom,
    ! [B: $tType] :
      ( linord219039673up_add(B)
     => ! [A: B] :
          ( ( plus_plus(B,A,A) = zero_zero(B) )
        <=> ( A = zero_zero(B) ) ) ) ).

tff(fact_98_less__imp__add__positive,axiom,
    ! [J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ? [K: nat] :
          ( ord_less(nat,zero_zero(nat),K)
          & ( plus_plus(nat,I,K) = J ) ) ) ).

%----Arities (9)
tff(arity_Nat_Onat___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (6)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    huffma945805758height(a,t) = zero_zero(nat) ).

tff(conj_1,conjecture,
    huffma1134658180e_cost(a,t) = zero_zero(nat) ).

%------------------------------------------------------------------------------
