%------------------------------------------------------------------------------
% File     : SWW536_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Huffman's Algorithm line 806
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla09] Blanchette (2009), Proof Pearl: Mechanizing the Textbo
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : huff_806 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  182 (  54 unt;  55 typ;   0 def)
%            Number of atoms       :  224 ( 127 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  103 (   6   ~;   1   |;   7   &)
%                                         (  14 <=>;  75  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   5 avg)
%            Maximal term depth    :   18 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   25 (  16   >;   9   *;   0   +;   0  <<)
%            Number of predicates  :   27 (  26 usr;   0 prp; 1-3 aty)
%            Number of functors    :   26 (  26 usr;   5 con; 0-5 aty)
%            Number of variables   :  400 ( 347   !;   0   ?; 400   :)
%                                         (  53  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:17:35
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Huffman__Mirabelle__lalbadcutu_Otree,type,
    huffma1450048681e_tree: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (50)
tff(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ominus,type,
    cl_Groups_Ominus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__ring,type,
    comm_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__0,type,
    semiring_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__group__add,type,
    ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring,type,
    comm_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__mult,type,
    comm_monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Osemilattice__inf,type,
    semilattice_inf: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Oab__semigroup__idem__mult,type,
    ab_sem1668676832m_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_Big__Operators_Ocomm__monoid__add__class_Osetsum,type,
    big_co1399186613setsum: 
      !>[B: $tType,A: $tType] : fun(fun(B,A),fun(fun(B,bool),A)) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(A,fun(B,C)) > fun(B,fun(A,C)) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oalphabet,type,
    huffma675207370phabet: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > fun(A,bool) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oconsistent,type,
    huffma1518433673istent: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ocost,type,
    huffma1134658180e_cost: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Odepth,type,
    huffma410068972_depth: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > fun(A,nat) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ofreq,type,
    huffma1352802255e_freq: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > fun(A,nat) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OInnerNode,type,
    huffma1146269203erNode: 
      !>[A: $tType] : ( ( nat * huffma1450048681e_tree(A) * huffma1450048681e_tree(A) ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_Otree__case,type,
    huffma107959123e_case: 
      !>[A: $tType,T: $tType] : ( ( fun(nat,fun(A,T)) * fun(nat,fun(huffma1450048681e_tree(A),fun(huffma1450048681e_tree(A),T))) * huffma1450048681e_tree(A) ) > T ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oweight,type,
    huffma83463279weight: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Lattices_Oinf__class_Oinf,type,
    inf_inf: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_t_092_060_094isub_0621____,type,
    t_1: huffma1450048681e_tree(a) ).

tff(sy_v_t_092_060_094isub_0622____,type,
    t_2: huffma1450048681e_tree(a) ).

tff(sy_v_w____,type,
    w: nat ).

%----Relevant facts (98)
tff(fact_0_InnerNode_Oprems,axiom,
    huffma1518433673istent(a,huffma1146269203erNode(a,w,t_1,t_2)) ).

tff(fact_1_tree_Osimps_I2_J,axiom,
    ! [B: $tType,Tree21: huffma1450048681e_tree(B),Tree11: huffma1450048681e_tree(B),Nat1: nat,Tree2: huffma1450048681e_tree(B),Tree1: huffma1450048681e_tree(B),Nat: nat] :
      ( ( huffma1146269203erNode(B,Nat,Tree1,Tree2) = huffma1146269203erNode(B,Nat1,Tree11,Tree21) )
    <=> ( ( Nat = Nat1 )
        & ( Tree1 = Tree11 )
        & ( Tree2 = Tree21 ) ) ) ).

tff(fact_2_InnerNode_I2_J,axiom,
    ( huffma1518433673istent(a,t_2)
   => ( huffma1134658180e_cost(a,t_2) = aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),combs(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),times_times(nat)),huffma1352802255e_freq(a,t_2)),huffma410068972_depth(a,t_2))),huffma675207370phabet(a,t_2)) ) ) ).

tff(fact_3_InnerNode_I1_J,axiom,
    ( huffma1518433673istent(a,t_1)
   => ( huffma1134658180e_cost(a,t_1) = aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),combs(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),times_times(nat)),huffma1352802255e_freq(a,t_1)),huffma410068972_depth(a,t_1))),huffma675207370phabet(a,t_1)) ) ) ).

tff(fact_4_freq_Osimps_I2_J,axiom,
    ! [A: $tType,T_22: huffma1450048681e_tree(A),T_12: huffma1450048681e_tree(A),W: nat,X3: A] : ( aa(A,nat,huffma1352802255e_freq(A,huffma1146269203erNode(A,W,T_12,T_22)),X3) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(A,nat,huffma1352802255e_freq(A,T_12),X3)),aa(A,nat,huffma1352802255e_freq(A,T_22),X3)) ) ).

tff(fact_5_weight_Osimps_I2_J,axiom,
    ! [A: $tType,T_22: huffma1450048681e_tree(A),T_12: huffma1450048681e_tree(A),W: nat] : ( huffma83463279weight(A,huffma1146269203erNode(A,W,T_12,T_22)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),huffma83463279weight(A,T_12)),huffma83463279weight(A,T_22)) ) ).

tff(fact_6_calculation,axiom,
    huffma1134658180e_cost(a,huffma1146269203erNode(a,w,t_1,t_2)) = aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),huffma83463279weight(a,t_1)),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),combs(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),times_times(nat)),huffma1352802255e_freq(a,t_1)),huffma410068972_depth(a,huffma1146269203erNode(a,w,t_1,t_2)))),huffma675207370phabet(a,t_1)))),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),huffma1352802255e_freq(a,t_1)),huffma675207370phabet(a,t_1)))),huffma83463279weight(a,t_2))),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),combs(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),times_times(nat)),huffma1352802255e_freq(a,t_2)),huffma410068972_depth(a,huffma1146269203erNode(a,w,t_1,t_2)))),huffma675207370phabet(a,t_2)))),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),huffma1352802255e_freq(a,t_2)),huffma675207370phabet(a,t_2))) ).

tff(fact_7__096weight_At_092_060_094isub_0621_A_L_Acost_At_092_060_094isub_0621_A_L_Aweight_At_092_060_094isub_0622_A_L_Acost_At_092_060_094isub_0622_A_061weight_At_092_060_094isub_0621_A_L_ISUM_Aa_058alphabet_At_092_060_094isub_0621_O_Afreq_At_092_060_094isub_0621_Aa_A_K_Adepth_At_092_060_094isub_0621_Aa_J_A_Lweight_At_092_060_094isub_0622_A_L_ISUM_Aa_058alphabet_At_092_060_094isub_0622_O_Afreq_At_092_060_094isub_0622_Aa_A_K_Adepth_At_092_060_094isub_0622_Aa_J_096,axiom,
    aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),huffma83463279weight(a,t_1)),huffma1134658180e_cost(a,t_1))),huffma83463279weight(a,t_2))),huffma1134658180e_cost(a,t_2)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),huffma83463279weight(a,t_1)),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),combs(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),times_times(nat)),huffma1352802255e_freq(a,t_1)),huffma410068972_depth(a,t_1))),huffma675207370phabet(a,t_1)))),huffma83463279weight(a,t_2))),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),combs(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),times_times(nat)),huffma1352802255e_freq(a,t_2)),huffma410068972_depth(a,t_2))),huffma675207370phabet(a,t_2))) ).

tff(fact_8__096cost_A_IInnerNode_Aw_At_092_060_094isub_0621_At_092_060_094isub_0622_J_A_061weight_At_092_060_094isub_0621_A_L_Acost_At_092_060_094isub_0621_A_L_Aweight_At_092_060_094isub_0622_A_L_Acost_At_092_060_094isub_0622_096,axiom,
    huffma1134658180e_cost(a,huffma1146269203erNode(a,w,t_1,t_2)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),huffma83463279weight(a,t_1)),huffma1134658180e_cost(a,t_1))),huffma83463279weight(a,t_2))),huffma1134658180e_cost(a,t_2)) ).

tff(fact_9__096weight_At_092_060_094isub_0621_A_L_ISUM_Aa_058alphabet_At_092_060_094isub_0621_O_Afreq_At_092_060_094isub_0621_Aa_A_K_Adepth_At_092_060_094isub_0621_Aa_J_A_Lweight_At_092_060_094isub_0622_A_L_ISUM_Aa_058alphabet_At_092_060_094isub_0622_O_Afreq_At_092_060_094isub_0622_Aa_A_K_Adepth_At_092_060_094isub_0622_Aa_J_A_061weight_At_092_060_094isub_0621_A_L_ISUM_Aa_058alphabet_At_092_060_094isub_0621_O_Afreq_At_092_060_094isub_0621_Aa_A_K_A_Idepth_A_IInnerNode_Aw_At_092_060_094isub_0621_At_092_060_094isub_0622_J_Aa_A_N_A1_J_J_A_Lweight_At_092_060_094isub_0622_A_L_ISUM_Aa_058alphabet_At_092_060_094isub_0622_O_Afreq_At_092_060_094isub_0622_Aa_A_K_A_Idepth_A_IInnerNode_Aw_At_092_060_094isub_0621_At_092_060_094isub_0622_J_Aa_A_N_A1_J_J_096,axiom,
    aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),huffma83463279weight(a,t_1)),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),combs(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),times_times(nat)),huffma1352802255e_freq(a,t_1)),huffma410068972_depth(a,t_1))),huffma675207370phabet(a,t_1)))),huffma83463279weight(a,t_2))),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),combs(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),times_times(nat)),huffma1352802255e_freq(a,t_2)),huffma410068972_depth(a,t_2))),huffma675207370phabet(a,t_2))) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),huffma83463279weight(a,t_1)),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),combs(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),times_times(nat)),huffma1352802255e_freq(a,t_1)),aa(nat,fun(a,nat),combc(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),minus_minus(nat)),huffma410068972_depth(a,huffma1146269203erNode(a,w,t_1,t_2)))),one_one(nat)))),huffma675207370phabet(a,t_1)))),huffma83463279weight(a,t_2))),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),combs(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),times_times(nat)),huffma1352802255e_freq(a,t_2)),aa(nat,fun(a,nat),combc(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),minus_minus(nat)),huffma410068972_depth(a,huffma1146269203erNode(a,w,t_1,t_2)))),one_one(nat)))),huffma675207370phabet(a,t_2))) ).

tff(fact_10__096weight_At_092_060_094isub_0621_A_L_ISUM_Aa_058alphabet_At_092_060_094isub_0621_O_Afreq_At_092_060_094isub_0621_Aa_A_K_A_Idepth_A_IInnerNode_Aw_At_092_060_094isub_0621_At_092_060_094isub_0622_J_Aa_A_N_A1_J_J_A_Lweight_At_092_060_094isub_0622_A_L_ISUM_Aa_058alphabet_At_092_060_094isub_0622_O_Afreq_At_092_060_094isub_0622_Aa_A_K_A_Idepth_A_IInnerNode_Aw_At_092_060_094isub_0621_At_092_060_094isub_0622_J_Aa_A_N_A1_J_J_A_061weight_At_092_060_094isub_0621_A_L_ISUM_Aa_058alphabet_At_092_060_094isub_0621_O_Afreq_At_092_060_094isub_0621_Aa_A_K_Adepth_A_IInnerNode_Aw_At_092_060_094isub_0621_At_092_060_094isub_0622_J_Aa_J_A_Nsetsum_A_Ifreq_At_092_060_094isub_0621_J_A_Ialphabet_At_092_060_094isub_0621_J_A_Lweight_At_092_060_094isub_0622_A_L_ISUM_Aa_058alphabet_At_092_060_094isub_0622_O_Afreq_At_092_060_094isub_0622_Aa_A_K_Adepth_A_IInnerNode_Aw_At_092_060_094isub_0621_At_092_060_094isub_0622_J_Aa_J_A_Nsetsum_A_Ifreq_At_092_060_094isub_0622_J_A_Ialphabet_At_092_060_094isub_0622_J_096,axiom,
    aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),huffma83463279weight(a,t_1)),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),combs(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),times_times(nat)),huffma1352802255e_freq(a,t_1)),aa(nat,fun(a,nat),combc(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),minus_minus(nat)),huffma410068972_depth(a,huffma1146269203erNode(a,w,t_1,t_2)))),one_one(nat)))),huffma675207370phabet(a,t_1)))),huffma83463279weight(a,t_2))),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),combs(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),times_times(nat)),huffma1352802255e_freq(a,t_2)),aa(nat,fun(a,nat),combc(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),minus_minus(nat)),huffma410068972_depth(a,huffma1146269203erNode(a,w,t_1,t_2)))),one_one(nat)))),huffma675207370phabet(a,t_2))) = aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),huffma83463279weight(a,t_1)),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),combs(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),times_times(nat)),huffma1352802255e_freq(a,t_1)),huffma410068972_depth(a,huffma1146269203erNode(a,w,t_1,t_2)))),huffma675207370phabet(a,t_1)))),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),huffma1352802255e_freq(a,t_1)),huffma675207370phabet(a,t_1)))),huffma83463279weight(a,t_2))),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),combs(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),times_times(nat)),huffma1352802255e_freq(a,t_2)),huffma410068972_depth(a,huffma1146269203erNode(a,w,t_1,t_2)))),huffma675207370phabet(a,t_2)))),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),huffma1352802255e_freq(a,t_2)),huffma675207370phabet(a,t_2))) ).

tff(fact_11_weight__eq__Sum__freq,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B)] :
      ( huffma1518433673istent(B,Ta)
     => ( huffma83463279weight(B,Ta) = aa(fun(B,bool),nat,aa(fun(B,nat),fun(fun(B,bool),nat),big_co1399186613setsum(B,nat),huffma1352802255e_freq(B,Ta)),huffma675207370phabet(B,Ta)) ) ) ).

tff(fact_12_diff__diff__left,axiom,
    ! [K: nat,J: nat,I: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),I),J)),K) = aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),I),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),J),K)) ) ).

tff(fact_13_cost_Osimps_I2_J,axiom,
    ! [A: $tType,T_22: huffma1450048681e_tree(A),T_12: huffma1450048681e_tree(A),W: nat] : ( huffma1134658180e_cost(A,huffma1146269203erNode(A,W,T_12,T_22)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),huffma83463279weight(A,T_12)),huffma1134658180e_cost(A,T_12))),huffma83463279weight(A,T_22))),huffma1134658180e_cost(A,T_22)) ) ).

tff(fact_14_square__diff__square__factored,axiom,
    ! [A: $tType] :
      ( comm_ring(A)
     => ! [Y: A,X: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(A,A,aa(A,fun(A,A),times_times(A),X),X)),aa(A,A,aa(A,fun(A,A),times_times(A),Y),Y)) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),X),Y)),aa(A,A,aa(A,fun(A,A),minus_minus(A),X),Y)) ) ) ).

tff(fact_15_eq__add__iff2,axiom,
    ! [B: $tType] :
      ( ring(B)
     => ! [D1: B,B3: B,C2: B,E1: B,A2: B] :
          ( ( aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(B,B,aa(B,fun(B,B),times_times(B),A2),E1)),C2) = aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(B,B,aa(B,fun(B,B),times_times(B),B3),E1)),D1) )
        <=> ( C2 = aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(B,B,aa(B,fun(B,B),times_times(B),aa(B,B,aa(B,fun(B,B),minus_minus(B),B3),A2)),E1)),D1) ) ) ) ).

tff(fact_16_eq__add__iff1,axiom,
    ! [B: $tType] :
      ( ring(B)
     => ! [D1: B,B3: B,C2: B,E1: B,A2: B] :
          ( ( aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(B,B,aa(B,fun(B,B),times_times(B),A2),E1)),C2) = aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(B,B,aa(B,fun(B,B),times_times(B),B3),E1)),D1) )
        <=> ( aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(B,B,aa(B,fun(B,B),times_times(B),aa(B,B,aa(B,fun(B,B),minus_minus(B),A2),B3)),E1)),C2) = D1 ) ) ) ).

tff(fact_17_nat__add__left__cancel,axiom,
    ! [N1: nat,M1: nat,K1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K1),M1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K1),N1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_18_nat__add__right__cancel,axiom,
    ! [N1: nat,K1: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),K1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N1),K1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_19_nat__mult__eq__1__iff,axiom,
    ! [N1: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M1),N1) = one_one(nat) )
    <=> ( ( M1 = one_one(nat) )
        & ( N1 = one_one(nat) ) ) ) ).

tff(fact_20_nat__1__eq__mult__iff,axiom,
    ! [N1: nat,M1: nat] :
      ( ( one_one(nat) = aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M1),N1) )
    <=> ( ( M1 = one_one(nat) )
        & ( N1 = one_one(nat) ) ) ) ).

tff(fact_21_nat__mult__1__right,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N),one_one(nat)) = N ) ).

tff(fact_22_nat__mult__1,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),one_one(nat)),N) = N ) ).

tff(fact_23_square__diff__one__factored,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ! [X: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(A,A,aa(A,fun(A,A),times_times(A),X),X)),one_one(A)) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),X),one_one(A))),aa(A,A,aa(A,fun(A,A),minus_minus(A),X),one_one(A))) ) ) ).

tff(fact_24_nat__add__assoc,axiom,
    ! [K: nat,N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N)),K) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),K)) ) ).

tff(fact_25_nat__add__left__commute,axiom,
    ! [Z1: nat,Y: nat,X: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),X),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),Z1)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),X),Z1)) ) ).

tff(fact_26_nat__add__commute,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),M) ) ).

tff(fact_27_nat__mult__assoc,axiom,
    ! [K: nat,N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),N)),K) = aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N),K)) ) ).

tff(fact_28_nat__mult__commute,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),N) = aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N),M) ) ).

tff(fact_29_diff__commute,axiom,
    ! [K: nat,J: nat,I: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),I),J)),K) = aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),I),K)),J) ) ).

tff(fact_30_combine__common__factor,axiom,
    ! [A: $tType] :
      ( semiring(A)
     => ! [C1: A,B1: A,E: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),times_times(A),A1),E)),aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),times_times(A),B1),E)),C1)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1)),E)),C1) ) ) ).

tff(fact_31_comm__semiring__class_Odistrib,axiom,
    ! [A: $tType] :
      ( comm_semiring(A)
     => ! [C1: A,B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),times_times(A),A1),C1)),aa(A,A,aa(A,fun(A,A),times_times(A),B1),C1)) ) ) ).

tff(fact_32_add__mult__distrib,axiom,
    ! [K: nat,N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N)),K) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),K)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N),K)) ) ).

tff(fact_33_add__mult__distrib2,axiom,
    ! [N: nat,M: nat,K: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),M)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),N)) ) ).

tff(fact_34_diff__cancel2,axiom,
    ! [N: nat,K: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),K)),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),K)) = aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),N) ) ).

tff(fact_35_diff__cancel,axiom,
    ! [N: nat,M: nat,K: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K),M)),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K),N)) = aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),N) ) ).

tff(fact_36_diff__add__inverse,axiom,
    ! [M: nat,N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),M)),N) = M ) ).

tff(fact_37_diff__add__inverse2,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N)),N) = M ) ).

tff(fact_38_diff__mult__distrib,axiom,
    ! [K: nat,N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),N)),K) = aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),K)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N),K)) ) ).

tff(fact_39_diff__mult__distrib2,axiom,
    ! [N: nat,M: nat,K: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),N)) = aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),M)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),N)) ) ).

tff(fact_40_comm__semiring__1__class_Onormalizing__semiring__rules_I2_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [M: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),times_times(A),A1),M)),M) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),one_one(A))),M) ) ) ).

tff(fact_41_comm__semiring__1__class_Onormalizing__semiring__rules_I3_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A,M: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),M),aa(A,A,aa(A,fun(A,A),times_times(A),A1),M)) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),one_one(A))),M) ) ) ).

tff(fact_42_comm__semiring__1__class_Onormalizing__semiring__rules_I4_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [M: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),M),M) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),one_one(A))),M) ) ) ).

tff(fact_43_mult__left__idem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),A1),aa(A,A,aa(A,fun(A,A),times_times(A),A1),B1)) = aa(A,A,aa(A,fun(A,A),times_times(A),A1),B1) ) ) ).

tff(fact_44_add__right__cancel,axiom,
    ! [B: $tType] :
      ( cancel_semigroup_add(B)
     => ! [C2: B,A2: B,B3: B] :
          ( ( aa(B,B,aa(B,fun(B,B),plus_plus(B),B3),A2) = aa(B,B,aa(B,fun(B,B),plus_plus(B),C2),A2) )
        <=> ( B3 = C2 ) ) ) ).

tff(fact_45_add__left__cancel,axiom,
    ! [B: $tType] :
      ( cancel_semigroup_add(B)
     => ! [C2: B,B3: B,A2: B] :
          ( ( aa(B,B,aa(B,fun(B,B),plus_plus(B),A2),B3) = aa(B,B,aa(B,fun(B,B),plus_plus(B),A2),C2) )
        <=> ( B3 = C2 ) ) ) ).

tff(fact_46_setsum__subtractf,axiom,
    ! [B: $tType,C: $tType] :
      ( ab_group_add(B)
     => ! [A3: fun(C,bool),G: fun(C,B),F: fun(C,B)] : ( aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),combs(C,B,B,aa(fun(C,B),fun(C,fun(B,B)),aa(fun(B,fun(B,B)),fun(fun(C,B),fun(C,fun(B,B))),combb(B,fun(B,B),C),minus_minus(B)),F),G)),A3) = aa(B,B,aa(B,fun(B,B),minus_minus(B),aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),F),A3)),aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),G),A3)) ) ) ).

tff(fact_47_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),A1) ) ) ).

tff(fact_48_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D2: A,C1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),D2)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),D2)) ) ) ).

tff(fact_49_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D2: A,C1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),D2)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1)),D2) ) ) ).

tff(fact_50_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),C1)) ) ) ).

tff(fact_51_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C1: A,B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),C1)) ) ) ).

tff(fact_52_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1)),B1) ) ) ).

tff(fact_53_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D2: A,C1: A,B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1)),aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),D2)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1)),aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),D2)) ) ) ).

tff(fact_54_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_55_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_56_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A1: A,B1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),A1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),A1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_57_times_Oidem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),A1),A1) = A1 ) ) ).

tff(fact_58_mult__idem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [X: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),X),X) = X ) ) ).

tff(fact_59_comm__semiring__1__class_Onormalizing__semiring__rules_I7_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),A1),B1) = aa(A,A,aa(A,fun(A,A),times_times(A),B1),A1) ) ) ).

tff(fact_60_comm__semiring__1__class_Onormalizing__semiring__rules_I19_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),Lx),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),Rx),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ry)) ) ) ).

tff(fact_61_comm__semiring__1__class_Onormalizing__semiring__rules_I18_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),Lx),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Rx)),Ry) ) ) ).

tff(fact_62_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_mult(A)
     => ! [C1: A,B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),A1),B1)),C1) = aa(A,A,aa(A,fun(A,A),times_times(A),A1),aa(A,A,aa(A,fun(A,A),times_times(A),B1),C1)) ) ) ).

tff(fact_63_comm__semiring__1__class_Onormalizing__semiring__rules_I17_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),Rx) = aa(A,A,aa(A,fun(A,A),times_times(A),Lx),aa(A,A,aa(A,fun(A,A),times_times(A),Ly),Rx)) ) ) ).

tff(fact_64_comm__semiring__1__class_Onormalizing__semiring__rules_I16_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),Rx) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Rx)),Ly) ) ) ).

tff(fact_65_comm__semiring__1__class_Onormalizing__semiring__rules_I14_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),Lx),aa(A,A,aa(A,fun(A,A),times_times(A),Ly),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry))) ) ) ).

tff(fact_66_comm__semiring__1__class_Onormalizing__semiring__rules_I15_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),Rx),aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),Ry)) ) ) ).

tff(fact_67_comm__semiring__1__class_Onormalizing__semiring__rules_I13_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Rx)),aa(A,A,aa(A,fun(A,A),times_times(A),Ly),Ry)) ) ) ).

tff(fact_68_fun__diff__def,axiom,
    ! [C: $tType,B: $tType] :
      ( cl_Groups_Ominus(C)
     => ! [B2: fun(B,C),A3: fun(B,C),X3: B] : ( aa(B,C,aa(fun(B,C),fun(B,C),aa(fun(B,C),fun(fun(B,C),fun(B,C)),minus_minus(fun(B,C)),A3),B2),X3) = aa(C,C,aa(C,fun(C,C),minus_minus(C),aa(B,C,A3,X3)),aa(B,C,B2,X3)) ) ) ).

tff(fact_69_minus__apply,axiom,
    ! [B: $tType,C: $tType] :
      ( cl_Groups_Ominus(B)
     => ! [X1: C,B2: fun(C,B),A3: fun(C,B)] : ( aa(C,B,aa(fun(C,B),fun(C,B),aa(fun(C,B),fun(fun(C,B),fun(C,B)),minus_minus(fun(C,B)),A3),B2),X1) = aa(B,B,aa(B,fun(B,B),minus_minus(B),aa(C,B,A3,X1)),aa(C,B,B2,X1)) ) ) ).

tff(fact_70_diff__eq__diff__eq,axiom,
    ! [B: $tType] :
      ( group_add(B)
     => ! [D1: B,C2: B,B3: B,A2: B] :
          ( ( aa(B,B,aa(B,fun(B,B),minus_minus(B),A2),B3) = aa(B,B,aa(B,fun(B,B),minus_minus(B),C2),D1) )
         => ( ( A2 = B3 )
          <=> ( C2 = D1 ) ) ) ) ).

tff(fact_71_one__reorient,axiom,
    ! [B: $tType] :
      ( one(B)
     => ! [X1: B] :
          ( ( one_one(B) = X1 )
        <=> ( X1 = one_one(B) ) ) ) ).

tff(fact_72_setsum__commute,axiom,
    ! [C: $tType,B: $tType,D: $tType] :
      ( comm_monoid_add(B)
     => ! [A3: fun(C,bool),B2: fun(D,bool),F: fun(C,fun(D,B))] : ( aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),aa(fun(D,bool),fun(C,B),combc(C,fun(D,bool),B,aa(fun(C,fun(D,B)),fun(C,fun(fun(D,bool),B)),aa(fun(fun(D,B),fun(fun(D,bool),B)),fun(fun(C,fun(D,B)),fun(C,fun(fun(D,bool),B))),combb(fun(D,B),fun(fun(D,bool),B),C),big_co1399186613setsum(D,B)),F)),B2)),A3) = aa(fun(D,bool),B,aa(fun(D,B),fun(fun(D,bool),B),big_co1399186613setsum(D,B),aa(fun(C,bool),fun(D,B),combc(D,fun(C,bool),B,aa(fun(D,fun(C,B)),fun(D,fun(fun(C,bool),B)),aa(fun(fun(C,B),fun(fun(C,bool),B)),fun(fun(D,fun(C,B)),fun(D,fun(fun(C,bool),B))),combb(fun(C,B),fun(fun(C,bool),B),D),big_co1399186613setsum(C,B)),combc(C,D,B,F))),A3)),B2) ) ) ).

tff(fact_73_comm__semiring__1__class_Onormalizing__semiring__rules_I34_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Z1: A,Y: A,X: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),X),aa(A,A,aa(A,fun(A,A),plus_plus(A),Y),Z1)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),times_times(A),X),Y)),aa(A,A,aa(A,fun(A,A),times_times(A),X),Z1)) ) ) ).

tff(fact_74_ext,axiom,
    ! [C: $tType,B: $tType,G: fun(B,C),F: fun(B,C)] :
      ( ! [X2: B] : ( aa(B,C,F,X2) = aa(B,C,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [B: $tType,A3: fun(B,bool),X1: B] :
      ( member(B,X1,A3)
    <=> pp(aa(B,bool,A3,X1)) ) ).

tff(fact_76_crossproduct__noteq,axiom,
    ! [B: $tType] :
      ( semiri456707255roduct(B)
     => ! [D1: B,C2: B,B3: B,A2: B] :
          ( ( ( A2 != B3 )
            & ( C2 != D1 ) )
        <=> ( aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(B,B,aa(B,fun(B,B),times_times(B),A2),C2)),aa(B,B,aa(B,fun(B,B),times_times(B),B3),D1)) != aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(B,B,aa(B,fun(B,B),times_times(B),A2),D1)),aa(B,B,aa(B,fun(B,B),times_times(B),B3),C2)) ) ) ) ).

tff(fact_77_comm__semiring__1__class_Onormalizing__semiring__rules_I8_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),times_times(A),A1),C1)),aa(A,A,aa(A,fun(A,A),times_times(A),B1),C1)) ) ) ).

tff(fact_78_comm__semiring__1__class_Onormalizing__semiring__rules_I1_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B1: A,M: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),times_times(A),A1),M)),aa(A,A,aa(A,fun(A,A),times_times(A),B1),M)) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1)),M) ) ) ).

tff(fact_79_crossproduct__eq,axiom,
    ! [B: $tType] :
      ( semiri456707255roduct(B)
     => ! [Z: B,X1: B,Y1: B,Wa: B] :
          ( ( aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(B,B,aa(B,fun(B,B),times_times(B),Wa),Y1)),aa(B,B,aa(B,fun(B,B),times_times(B),X1),Z)) = aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(B,B,aa(B,fun(B,B),times_times(B),Wa),Z)),aa(B,B,aa(B,fun(B,B),times_times(B),X1),Y1)) )
        <=> ( ( Wa = X1 )
            | ( Y1 = Z ) ) ) ) ).

tff(fact_80_diff__add__cancel,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1)),B1) = A1 ) ) ).

tff(fact_81_add__diff__cancel,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1)),B1) = A1 ) ) ).

tff(fact_82_mult__1__left,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),one_one(A)),A1) = A1 ) ) ).

tff(fact_83_comm__semiring__1__class_Onormalizing__semiring__rules_I11_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),one_one(A)),A1) = A1 ) ) ).

tff(fact_84_mult__1,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),one_one(A)),A1) = A1 ) ) ).

tff(fact_85_mult__1__right,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),A1),one_one(A)) = A1 ) ) ).

tff(fact_86_comm__semiring__1__class_Onormalizing__semiring__rules_I12_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),A1),one_one(A)) = A1 ) ) ).

tff(fact_87_mult_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),A1),one_one(A)) = A1 ) ) ).

tff(fact_88_setsum__addf,axiom,
    ! [B: $tType,C: $tType] :
      ( comm_monoid_add(B)
     => ! [A3: fun(C,bool),G: fun(C,B),F: fun(C,B)] : ( aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),combs(C,B,B,aa(fun(C,B),fun(C,fun(B,B)),aa(fun(B,fun(B,B)),fun(fun(C,B),fun(C,fun(B,B))),combb(B,fun(B,B),C),plus_plus(B)),F),G)),A3) = aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),F),A3)),aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),G),A3)) ) ) ).

tff(fact_89_setsum__right__distrib,axiom,
    ! [B: $tType,C: $tType] :
      ( semiring_0(B)
     => ! [A3: fun(C,bool),F: fun(C,B),R1: B] : ( aa(B,B,aa(B,fun(B,B),times_times(B),R1),aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),F),A3)) = aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),aa(fun(C,B),fun(C,B),aa(fun(B,B),fun(fun(C,B),fun(C,B)),combb(B,B,C),aa(B,fun(B,B),times_times(B),R1)),F)),A3) ) ) ).

tff(fact_90_setsum__left__distrib,axiom,
    ! [B: $tType,C: $tType] :
      ( semiring_0(B)
     => ! [R1: B,A3: fun(C,bool),F: fun(C,B)] : ( aa(B,B,aa(B,fun(B,B),times_times(B),aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),F),A3)),R1) = aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),aa(B,fun(C,B),combc(C,B,B,aa(fun(C,B),fun(C,fun(B,B)),aa(fun(B,fun(B,B)),fun(fun(C,B),fun(C,fun(B,B))),combb(B,fun(B,B),C),times_times(B)),F)),R1)),A3) ) ) ).

tff(fact_91_setsum__product,axiom,
    ! [D: $tType,B: $tType,C: $tType] :
      ( semiring_0(B)
     => ! [B2: fun(D,bool),G: fun(D,B),A3: fun(C,bool),F: fun(C,B)] : ( aa(B,B,aa(B,fun(B,B),times_times(B),aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),F),A3)),aa(fun(D,bool),B,aa(fun(D,B),fun(fun(D,bool),B),big_co1399186613setsum(D,B),G),B2)) = aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),aa(fun(D,bool),fun(C,B),combc(C,fun(D,bool),B,aa(fun(C,fun(D,B)),fun(C,fun(fun(D,bool),B)),aa(fun(fun(D,B),fun(fun(D,bool),B)),fun(fun(C,fun(D,B)),fun(C,fun(fun(D,bool),B))),combb(fun(D,B),fun(fun(D,bool),B),C),big_co1399186613setsum(D,B)),aa(fun(D,B),fun(C,fun(D,B)),combc(C,fun(D,B),fun(D,B),aa(fun(C,fun(B,B)),fun(C,fun(fun(D,B),fun(D,B))),aa(fun(fun(B,B),fun(fun(D,B),fun(D,B))),fun(fun(C,fun(B,B)),fun(C,fun(fun(D,B),fun(D,B)))),combb(fun(B,B),fun(fun(D,B),fun(D,B)),C),combb(B,B,D)),aa(fun(C,B),fun(C,fun(B,B)),aa(fun(B,fun(B,B)),fun(fun(C,B),fun(C,fun(B,B))),combb(B,fun(B,B),C),times_times(B)),F))),G))),B2)),A3) ) ) ).

tff(fact_92_d_092_060_094isub_0622,axiom,
    ! [A2: a] :
      ( ( inf_inf(fun(a,bool),huffma675207370phabet(a,t_1),huffma675207370phabet(a,t_2)) = bot_bot(fun(a,bool)) )
     => ( member(a,A2,huffma675207370phabet(a,t_2))
       => ( aa(a,nat,huffma410068972_depth(a,huffma1146269203erNode(a,w,t_1,t_2)),A2) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(a,nat,huffma410068972_depth(a,t_2),A2)),one_one(nat)) ) ) ) ).

tff(fact_93_depth_Osimps_I2_J,axiom,
    ! [B: $tType,T_21: huffma1450048681e_tree(B),Wa: nat,T_11: huffma1450048681e_tree(B),A2: B] :
      ( ( member(B,A2,huffma675207370phabet(B,T_11))
       => ( aa(B,nat,huffma410068972_depth(B,huffma1146269203erNode(B,Wa,T_11,T_21)),A2) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(B,nat,huffma410068972_depth(B,T_11),A2)),one_one(nat)) ) )
      & ( ~ member(B,A2,huffma675207370phabet(B,T_11))
       => ( ( member(B,A2,huffma675207370phabet(B,T_21))
           => ( aa(B,nat,huffma410068972_depth(B,huffma1146269203erNode(B,Wa,T_11,T_21)),A2) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(B,nat,huffma410068972_depth(B,T_21),A2)),one_one(nat)) ) )
          & ( ~ member(B,A2,huffma675207370phabet(B,T_21))
           => ( aa(B,nat,huffma410068972_depth(B,huffma1146269203erNode(B,Wa,T_11,T_21)),A2) = zero_zero(nat) ) ) ) ) ) ).

tff(fact_94_left__add__mult__distrib,axiom,
    ! [K: nat,J: nat,U: nat,I: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),I),U)),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),J),U)),K)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),I),J)),U)),K) ) ).

tff(fact_95_tree_Osimps_I6_J,axiom,
    ! [B: $tType,C: $tType,Tree2: huffma1450048681e_tree(C),Tree1: huffma1450048681e_tree(C),Nat: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B))),F1: fun(nat,fun(C,B))] : ( huffma107959123e_case(C,B,F1,F2,huffma1146269203erNode(C,Nat,Tree1,Tree2)) = aa(huffma1450048681e_tree(C),B,aa(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B),aa(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B)),F2,Nat),Tree1),Tree2) ) ).

tff(fact_96_inf__left__idem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Y: A,X: A] : ( inf_inf(A,X,inf_inf(A,X,Y)) = inf_inf(A,X,Y) ) ) ).

tff(fact_97_inf_Oleft__idem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [B1: A,A1: A] : ( inf_inf(A,A1,inf_inf(A,A1,B1)) = inf_inf(A,A1,B1) ) ) ).

%----Arities (23)
tff(arity_HOL_Obool___Lattices_Olattice,axiom,
    lattice(bool) ).

tff(arity_Nat_Onat___Lattices_Olattice,axiom,
    lattice(nat) ).

tff(arity_fun___Lattices_Olattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => lattice(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Osemilattice__inf,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => semilattice_inf(fun(T_1,T_2)) ) ).

tff(arity_fun___Groups_Ominus,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( cl_Groups_Ominus(T_2)
     => cl_Groups_Ominus(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Lattices_Osemilattice__inf,axiom,
    semilattice_inf(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring,axiom,
    comm_semiring(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__0,axiom,
    semiring_0(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring,axiom,
    semiring(nat) ).

tff(arity_Nat_Onat___Groups_Ominus,axiom,
    cl_Groups_Ominus(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_HOL_Obool___Lattices_Osemilattice__inf,axiom,
    semilattice_inf(bool) ).

tff(arity_HOL_Obool___Groups_Ominus,axiom,
    cl_Groups_Ominus(bool) ).

%----Helper facts (5)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),combc(A,B,C,P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),huffma83463279weight(a,t_1)),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),combs(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),times_times(nat)),huffma1352802255e_freq(a,t_1)),huffma410068972_depth(a,huffma1146269203erNode(a,w,t_1,t_2)))),huffma675207370phabet(a,t_1)))),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),huffma1352802255e_freq(a,t_1)),huffma675207370phabet(a,t_1)))),huffma83463279weight(a,t_2))),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),combs(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),times_times(nat)),huffma1352802255e_freq(a,t_2)),huffma410068972_depth(a,huffma1146269203erNode(a,w,t_1,t_2)))),huffma675207370phabet(a,t_2)))),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),huffma1352802255e_freq(a,t_2)),huffma675207370phabet(a,t_2))) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),combs(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),times_times(nat)),huffma1352802255e_freq(a,t_1)),huffma410068972_depth(a,huffma1146269203erNode(a,w,t_1,t_2)))),huffma675207370phabet(a,t_1))),aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),combs(a,nat,nat,aa(fun(a,nat),fun(a,fun(nat,nat)),aa(fun(nat,fun(nat,nat)),fun(fun(a,nat),fun(a,fun(nat,nat))),combb(nat,fun(nat,nat),a),times_times(nat)),huffma1352802255e_freq(a,t_2)),huffma410068972_depth(a,huffma1146269203erNode(a,w,t_1,t_2)))),huffma675207370phabet(a,t_2))) ).

%------------------------------------------------------------------------------
