%------------------------------------------------------------------------------
% File     : SWW535_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Huffman's Algorithm line 792
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla09] Blanchette (2009), Proof Pearl: Mechanizing the Textbo
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : huff_792 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.50 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  184 (  57 unt;  51 typ;   0 def)
%            Number of atoms       :  240 ( 115 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  130 (  23   ~;   5   |;  10   &)
%                                         (  20 <=>;  72  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   5 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   38 (  22   >;  16   *;   0   +;   0  <<)
%            Number of predicates  :   19 (  18 usr;   0 prp; 1-2 aty)
%            Number of functors    :   30 (  30 usr;   6 con; 0-5 aty)
%            Number of variables   :  424 ( 373   !;   2   ?; 424   :)
%                                         (  49  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:52
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Huffman__Mirabelle__lalbadcutu_Otree,type,
    huffma1450048681e_tree: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (46)
tff(sy_cl_Lattices_Obounded__lattice,type,
    bounded_lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Osemilattice__inf,type,
    semilattice_inf: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Obounded__lattice__bot,type,
    bounded_lattice_bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oalphabet,type,
    huffma675207370phabet: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > fun(A,bool) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oconsistent,type,
    huffma1518433673istent: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ocost,type,
    huffma1134658180e_cost: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Odepth,type,
    huffma410068972_depth: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ofreq,type,
    huffma1352802255e_freq: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OInnerNode,type,
    huffma1146269203erNode: 
      !>[A: $tType] : ( ( nat * huffma1450048681e_tree(A) * huffma1450048681e_tree(A) ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OLeaf,type,
    huffma2021818691e_Leaf: 
      !>[A: $tType] : ( ( nat * A ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_Otree__case,type,
    huffma107959123e_case: 
      !>[A: $tType,T: $tType] : ( ( fun(nat,fun(A,T)) * fun(nat,fun(huffma1450048681e_tree(A),fun(huffma1450048681e_tree(A),T))) * huffma1450048681e_tree(A) ) > T ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_Otree__rec,type,
    huffma1280178957ee_rec: 
      !>[A: $tType,T: $tType] : ( ( fun(nat,fun(A,T)) * fun(nat,fun(huffma1450048681e_tree(A),fun(huffma1450048681e_tree(A),fun(T,fun(T,T))))) * huffma1450048681e_tree(A) ) > T ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oweight,type,
    huffma83463279weight: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Lattices_Oinf__class_Oinf,type,
    inf_inf: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_t_092_060_094isub_0621____,type,
    t_1: huffma1450048681e_tree(a) ).

tff(sy_v_t_092_060_094isub_0622____,type,
    t_2: huffma1450048681e_tree(a) ).

tff(sy_v_w____,type,
    w: nat ).

%----Relevant facts (98)
tff(fact_0_tree_Osimps_I2_J,axiom,
    ! [B: $tType,Tree22: huffma1450048681e_tree(B),Tree12: huffma1450048681e_tree(B),Nat1: nat,Tree21: huffma1450048681e_tree(B),Tree11: huffma1450048681e_tree(B),Nat: nat] :
      ( ( huffma1146269203erNode(B,Nat,Tree11,Tree21) = huffma1146269203erNode(B,Nat1,Tree12,Tree22) )
    <=> ( ( Nat = Nat1 )
        & ( Tree11 = Tree12 )
        & ( Tree21 = Tree22 ) ) ) ).

tff(fact_1_InnerNode_Oprems,axiom,
    huffma1518433673istent(a,huffma1146269203erNode(a,w,t_1,t_2)) ).

tff(fact_2_weight_Osimps_I2_J,axiom,
    ! [A: $tType,T_22: huffma1450048681e_tree(A),T_12: huffma1450048681e_tree(A),W: nat] : ( huffma83463279weight(A,huffma1146269203erNode(A,W,T_12,T_22)) = plus_plus(nat,huffma83463279weight(A,T_12),huffma83463279weight(A,T_22)) ) ).

tff(fact_3_cost_Osimps_I2_J,axiom,
    ! [A: $tType,T_22: huffma1450048681e_tree(A),T_12: huffma1450048681e_tree(A),W: nat] : ( huffma1134658180e_cost(A,huffma1146269203erNode(A,W,T_12,T_22)) = plus_plus(nat,plus_plus(nat,plus_plus(nat,huffma83463279weight(A,T_12),huffma1134658180e_cost(A,T_12)),huffma83463279weight(A,T_22)),huffma1134658180e_cost(A,T_22)) ) ).

tff(fact_4_nat__add__left__cancel,axiom,
    ! [N: nat,M: nat,K1: nat] :
      ( ( plus_plus(nat,K1,M) = plus_plus(nat,K1,N) )
    <=> ( M = N ) ) ).

tff(fact_5_nat__add__right__cancel,axiom,
    ! [N: nat,K1: nat,M: nat] :
      ( ( plus_plus(nat,M,K1) = plus_plus(nat,N,K1) )
    <=> ( M = N ) ) ).

tff(fact_6_add__left__cancel,axiom,
    ! [B: $tType] :
      ( cancel_semigroup_add(B)
     => ! [C1: B,B1: B,A2: B] :
          ( ( plus_plus(B,A2,B1) = plus_plus(B,A2,C1) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_7_add__right__cancel,axiom,
    ! [B: $tType] :
      ( cancel_semigroup_add(B)
     => ! [C1: B,A2: B,B1: B] :
          ( ( plus_plus(B,B1,A2) = plus_plus(B,C1,A2) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_8_freq_Osimps_I2_J,axiom,
    ! [A: $tType,T_22: huffma1450048681e_tree(A),T_12: huffma1450048681e_tree(A),W: nat,X: A] : ( huffma1352802255e_freq(A,huffma1146269203erNode(A,W,T_12,T_22),X) = plus_plus(nat,huffma1352802255e_freq(A,T_12,X),huffma1352802255e_freq(A,T_22,X)) ) ).

tff(fact_9_tree_Osimps_I6_J,axiom,
    ! [B: $tType,C: $tType,Tree21: huffma1450048681e_tree(C),Tree11: huffma1450048681e_tree(C),Nat: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B))),F1: fun(nat,fun(C,B))] : ( huffma107959123e_case(C,B,F1,F2,huffma1146269203erNode(C,Nat,Tree11,Tree21)) = aa(huffma1450048681e_tree(C),B,aa(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B),aa(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B)),F2,Nat),Tree11),Tree21) ) ).

tff(fact_10_tree_Orecs_I2_J,axiom,
    ! [B: $tType,C: $tType,Tree21: huffma1450048681e_tree(C),Tree11: huffma1450048681e_tree(C),Nat: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B,fun(B,B))))),F1: fun(nat,fun(C,B))] : ( huffma1280178957ee_rec(C,B,F1,F2,huffma1146269203erNode(C,Nat,Tree11,Tree21)) = aa(B,B,aa(B,fun(B,B),aa(huffma1450048681e_tree(C),fun(B,fun(B,B)),aa(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B,fun(B,B))),aa(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B,fun(B,B)))),F2,Nat),Tree11),Tree21),huffma1280178957ee_rec(C,B,F1,F2,Tree11)),huffma1280178957ee_rec(C,B,F1,F2,Tree21)) ) ).

tff(fact_11_nat__add__commute,axiom,
    ! [N1: nat,M1: nat] : ( plus_plus(nat,M1,N1) = plus_plus(nat,N1,M1) ) ).

tff(fact_12_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X4: nat] : ( plus_plus(nat,X4,plus_plus(nat,Y,Z)) = plus_plus(nat,Y,plus_plus(nat,X4,Z)) ) ).

tff(fact_13_nat__add__assoc,axiom,
    ! [K: nat,N1: nat,M1: nat] : ( plus_plus(nat,plus_plus(nat,M1,N1),K) = plus_plus(nat,M1,plus_plus(nat,N1,K)) ) ).

tff(fact_14_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C3: A,A1: A] : ( plus_plus(A,A1,C3) = plus_plus(A,C3,A1) ) ) ).

tff(fact_15_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C3: A,A1: A] : ( plus_plus(A,A1,plus_plus(A,C3,D)) = plus_plus(A,C3,plus_plus(A,A1,D)) ) ) ).

tff(fact_16_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C3: A,A1: A,B2: A] :
          ( ( plus_plus(A,B2,A1) = plus_plus(A,C3,A1) )
         => ( B2 = C3 ) ) ) ).

tff(fact_17_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C3: A,B2: A,A1: A] :
          ( ( plus_plus(A,A1,B2) = plus_plus(A,A1,C3) )
         => ( B2 = C3 ) ) ) ).

tff(fact_18_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C3: A,B2: A,A1: A] :
          ( ( plus_plus(A,A1,B2) = plus_plus(A,A1,C3) )
         => ( B2 = C3 ) ) ) ).

tff(fact_19_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C3: A,B2: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B2),plus_plus(A,C3,D)) = plus_plus(A,plus_plus(A,A1,C3),plus_plus(A,B2,D)) ) ) ).

tff(fact_20_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C3: A,B2: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B2),C3) = plus_plus(A,plus_plus(A,A1,C3),B2) ) ) ).

tff(fact_21_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C3: A,B2: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B2),C3) = plus_plus(A,A1,plus_plus(A,B2,C3)) ) ) ).

tff(fact_22_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C3: A,B2: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B2),C3) = plus_plus(A,A1,plus_plus(A,B2,C3)) ) ) ).

tff(fact_23_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C3: A,A1: A] : ( plus_plus(A,A1,plus_plus(A,C3,D)) = plus_plus(A,plus_plus(A,A1,C3),D) ) ) ).

tff(fact_24_tree_Osimps_I5_J,axiom,
    ! [B: $tType,C: $tType,A2: C,Nat: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B))),F1: fun(nat,fun(C,B))] : ( huffma107959123e_case(C,B,F1,F2,huffma2021818691e_Leaf(C,Nat,A2)) = aa(C,B,aa(nat,fun(C,B),F1,Nat),A2) ) ).

tff(fact_25_consistent_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,W: nat] : huffma1518433673istent(A,huffma2021818691e_Leaf(A,W,A1)) ).

tff(fact_26_tree_Orecs_I1_J,axiom,
    ! [B: $tType,C: $tType,A2: C,Nat: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B,fun(B,B))))),F1: fun(nat,fun(C,B))] : ( huffma1280178957ee_rec(C,B,F1,F2,huffma2021818691e_Leaf(C,Nat,A2)) = aa(C,B,aa(nat,fun(C,B),F1,Nat),A2) ) ).

tff(fact_27_d_092_060_094isub_0622,axiom,
    ! [A2: a] :
      ( ( inf_inf(fun(a,bool),huffma675207370phabet(a,t_1),huffma675207370phabet(a,t_2)) = bot_bot(fun(a,bool)) )
     => ( pp(aa(fun(a,bool),bool,aa(a,fun(fun(a,bool),bool),member(a),A2),huffma675207370phabet(a,t_2)))
       => ( huffma410068972_depth(a,huffma1146269203erNode(a,w,t_1,t_2),A2) = plus_plus(nat,huffma410068972_depth(a,t_2,A2),one_one(nat)) ) ) ) ).

tff(fact_28_of__nat__add,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [N1: nat,M1: nat] : ( semiring_1_of_nat(A,plus_plus(nat,M1,N1)) = plus_plus(A,semiring_1_of_nat(A,M1),semiring_1_of_nat(A,N1)) ) ) ).

tff(fact_29_weight_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,W: nat] : ( huffma83463279weight(A,huffma2021818691e_Leaf(A,W,A1)) = W ) ).

tff(fact_30_tree_Osimps_I4_J,axiom,
    ! [A: $tType,A1: A,Nat2: nat,Tree2: huffma1450048681e_tree(A),Tree1: huffma1450048681e_tree(A),Nat3: nat] : ( huffma1146269203erNode(A,Nat3,Tree1,Tree2) != huffma2021818691e_Leaf(A,Nat2,A1) ) ).

tff(fact_31_tree_Osimps_I3_J,axiom,
    ! [A: $tType,Tree2: huffma1450048681e_tree(A),Tree1: huffma1450048681e_tree(A),Nat3: nat,A1: A,Nat2: nat] : ( huffma2021818691e_Leaf(A,Nat2,A1) != huffma1146269203erNode(A,Nat3,Tree1,Tree2) ) ).

tff(fact_32_of__nat__eq__iff,axiom,
    ! [B: $tType] :
      ( semiring_char_0(B)
     => ! [N: nat,M: nat] :
          ( ( semiring_1_of_nat(B,M) = semiring_1_of_nat(B,N) )
        <=> ( M = N ) ) ) ).

tff(fact_33_tree_Osimps_I1_J,axiom,
    ! [B: $tType,A5: B,Nat1: nat,A2: B,Nat: nat] :
      ( ( huffma2021818691e_Leaf(B,Nat,A2) = huffma2021818691e_Leaf(B,Nat1,A5) )
    <=> ( ( Nat = Nat1 )
        & ( A2 = A5 ) ) ) ).

tff(fact_34_of__nat__1,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,one_one(nat)) = one_one(A) ) ) ).

tff(fact_35_consistent_Osimps_I2_J,axiom,
    ! [B: $tType,T_21: huffma1450048681e_tree(B),T_11: huffma1450048681e_tree(B),Wa: nat] :
      ( huffma1518433673istent(B,huffma1146269203erNode(B,Wa,T_11,T_21))
    <=> ( huffma1518433673istent(B,T_11)
        & huffma1518433673istent(B,T_21)
        & ( inf_inf(fun(B,bool),huffma675207370phabet(B,T_11),huffma675207370phabet(B,T_21)) = bot_bot(fun(B,bool)) ) ) ) ).

tff(fact_36_one__reorient,axiom,
    ! [B: $tType] :
      ( one(B)
     => ! [X1: B] :
          ( ( one_one(B) = X1 )
        <=> ( X1 = one_one(B) ) ) ) ).

tff(fact_37_inf__bot__right,axiom,
    ! [A: $tType] :
      ( bounded_lattice_bot(A)
     => ! [X4: A] : ( inf_inf(A,X4,bot_bot(A)) = bot_bot(A) ) ) ).

tff(fact_38_inf__bot__left,axiom,
    ! [A: $tType] :
      ( bounded_lattice_bot(A)
     => ! [X4: A] : ( inf_inf(A,bot_bot(A),X4) = bot_bot(A) ) ) ).

tff(fact_39_inf1E,axiom,
    ! [B: $tType,X1: B,B3: fun(B,bool),A4: fun(B,bool)] :
      ( pp(aa(B,bool,inf_inf(fun(B,bool),A4,B3),X1))
     => ~ ( pp(aa(B,bool,A4,X1))
         => ~ pp(aa(B,bool,B3,X1)) ) ) ).

tff(fact_40_IntE,axiom,
    ! [B: $tType,B3: fun(B,bool),A4: fun(B,bool),C1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),inf_inf(fun(B,bool),A4,B3)))
     => ~ ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),A4))
         => ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),B3)) ) ) ).

tff(fact_41_IntI,axiom,
    ! [B: $tType,B3: fun(B,bool),A4: fun(B,bool),C1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),A4))
     => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),B3))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),inf_inf(fun(B,bool),A4,B3))) ) ) ).

tff(fact_42_inf1I,axiom,
    ! [B: $tType,B3: fun(B,bool),X1: B,A4: fun(B,bool)] :
      ( pp(aa(B,bool,A4,X1))
     => ( pp(aa(B,bool,B3,X1))
       => pp(aa(B,bool,inf_inf(fun(B,bool),A4,B3),X1)) ) ) ).

tff(fact_43_all__not__in__conv,axiom,
    ! [B: $tType,A4: fun(B,bool)] :
      ( ! [X2: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A4))
    <=> ( A4 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_44_empty__Collect__eq,axiom,
    ! [B: $tType,P1: fun(B,bool)] :
      ( ( bot_bot(fun(B,bool)) = collect(B,P1) )
    <=> ! [X2: B] : ~ pp(aa(B,bool,P1,X2)) ) ).

tff(fact_45_empty__iff,axiom,
    ! [B: $tType,C1: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),bot_bot(fun(B,bool)))) ).

tff(fact_46_Collect__empty__eq,axiom,
    ! [B: $tType,P1: fun(B,bool)] :
      ( ( collect(B,P1) = bot_bot(fun(B,bool)) )
    <=> ! [X2: B] : ~ pp(aa(B,bool,P1,X2)) ) ).

tff(fact_47_emptyE,axiom,
    ! [B: $tType,A2: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A2),bot_bot(fun(B,bool)))) ).

tff(fact_48_inf_Oleft__idem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [B2: A,A1: A] : ( inf_inf(A,A1,inf_inf(A,A1,B2)) = inf_inf(A,A1,B2) ) ) ).

tff(fact_49_inf__left__idem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Y: A,X4: A] : ( inf_inf(A,X4,inf_inf(A,X4,Y)) = inf_inf(A,X4,Y) ) ) ).

tff(fact_50_Int__iff,axiom,
    ! [B: $tType,B3: fun(B,bool),A4: fun(B,bool),C1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),inf_inf(fun(B,bool),A4,B3)))
    <=> ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),A4))
        & pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),B3)) ) ) ).

tff(fact_51_bot__empty__eq,axiom,
    ! [B: $tType,X: B] :
      ( pp(aa(B,bool,bot_bot(fun(B,bool)),X))
    <=> pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X),bot_bot(fun(B,bool)))) ) ).

tff(fact_52_empty__def,axiom,
    ! [B: $tType] : ( bot_bot(fun(B,bool)) = collect(B,combk(bool,B,fFalse)) ) ).

tff(fact_53_ex__in__conv,axiom,
    ! [B: $tType,A4: fun(B,bool)] :
      ( ? [X2: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A4))
    <=> ( A4 != bot_bot(fun(B,bool)) ) ) ).

tff(fact_54_equals0D,axiom,
    ! [B: $tType,A2: B,A4: fun(B,bool)] :
      ( ( A4 = bot_bot(fun(B,bool)) )
     => ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A2),A4)) ) ).

tff(fact_55_inf_Oidem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [A1: A] : ( inf_inf(A,A1,A1) = A1 ) ) ).

tff(fact_56_inf__idem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [X4: A] : ( inf_inf(A,X4,X4) = X4 ) ) ).

tff(fact_57_inf_Ocommute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [B2: A,A1: A] : ( inf_inf(A,A1,B2) = inf_inf(A,B2,A1) ) ) ).

tff(fact_58_inf__sup__aci_I1_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X4: A] : ( inf_inf(A,X4,Y) = inf_inf(A,Y,X4) ) ) ).

tff(fact_59_inf__commute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Y: A,X4: A] : ( inf_inf(A,X4,Y) = inf_inf(A,Y,X4) ) ) ).

tff(fact_60_inf__sup__aci_I4_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X4: A] : ( inf_inf(A,X4,inf_inf(A,X4,Y)) = inf_inf(A,X4,Y) ) ) ).

tff(fact_61_inf_Oleft__commute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [C3: A,A1: A,B2: A] : ( inf_inf(A,B2,inf_inf(A,A1,C3)) = inf_inf(A,A1,inf_inf(A,B2,C3)) ) ) ).

tff(fact_62_inf__sup__aci_I3_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z: A,Y: A,X4: A] : ( inf_inf(A,X4,inf_inf(A,Y,Z)) = inf_inf(A,Y,inf_inf(A,X4,Z)) ) ) ).

tff(fact_63_inf__left__commute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Z: A,Y: A,X4: A] : ( inf_inf(A,X4,inf_inf(A,Y,Z)) = inf_inf(A,Y,inf_inf(A,X4,Z)) ) ) ).

tff(fact_64_inf_Oassoc,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [C3: A,B2: A,A1: A] : ( inf_inf(A,inf_inf(A,A1,B2),C3) = inf_inf(A,A1,inf_inf(A,B2,C3)) ) ) ).

tff(fact_65_inf__sup__aci_I2_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z: A,Y: A,X4: A] : ( inf_inf(A,inf_inf(A,X4,Y),Z) = inf_inf(A,X4,inf_inf(A,Y,Z)) ) ) ).

tff(fact_66_inf__assoc,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Z: A,Y: A,X4: A] : ( inf_inf(A,inf_inf(A,X4,Y),Z) = inf_inf(A,X4,inf_inf(A,Y,Z)) ) ) ).

tff(fact_67_Int__absorb,axiom,
    ! [B: $tType,A4: fun(B,bool)] : ( inf_inf(fun(B,bool),A4,A4) = A4 ) ).

tff(fact_68_Int__def,axiom,
    ! [B: $tType,B3: fun(B,bool),A4: fun(B,bool)] : ( inf_inf(fun(B,bool),A4,B3) = collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,combc(B,fun(B,bool),bool,member(B),A4)),combc(B,fun(B,bool),bool,member(B),B3))) ) ).

tff(fact_69_Int__commute,axiom,
    ! [B: $tType,B3: fun(B,bool),A4: fun(B,bool)] : ( inf_inf(fun(B,bool),A4,B3) = inf_inf(fun(B,bool),B3,A4) ) ).

tff(fact_70_Int__left__absorb,axiom,
    ! [B: $tType,B3: fun(B,bool),A4: fun(B,bool)] : ( inf_inf(fun(B,bool),A4,inf_inf(fun(B,bool),A4,B3)) = inf_inf(fun(B,bool),A4,B3) ) ).

tff(fact_71_Int__left__commute,axiom,
    ! [B: $tType,C2: fun(B,bool),B3: fun(B,bool),A4: fun(B,bool)] : ( inf_inf(fun(B,bool),A4,inf_inf(fun(B,bool),B3,C2)) = inf_inf(fun(B,bool),B3,inf_inf(fun(B,bool),A4,C2)) ) ).

tff(fact_72_Int__assoc,axiom,
    ! [B: $tType,C2: fun(B,bool),B3: fun(B,bool),A4: fun(B,bool)] : ( inf_inf(fun(B,bool),inf_inf(fun(B,bool),A4,B3),C2) = inf_inf(fun(B,bool),A4,inf_inf(fun(B,bool),B3,C2)) ) ).

tff(fact_73_IntD1,axiom,
    ! [B: $tType,B3: fun(B,bool),A4: fun(B,bool),C1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),inf_inf(fun(B,bool),A4,B3)))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),A4)) ) ).

tff(fact_74_ext,axiom,
    ! [C: $tType,B: $tType,G: fun(B,C),F: fun(B,C)] :
      ( ! [X3: B] : ( aa(B,C,F,X3) = aa(B,C,G,X3) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [B: $tType,A4: fun(B,bool),X1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A4))
    <=> pp(aa(B,bool,A4,X1)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [B: $tType,P1: fun(B,bool)] : ( collect(B,P1) = P1 ) ).

tff(fact_77_IntD2,axiom,
    ! [B: $tType,B3: fun(B,bool),A4: fun(B,bool),C1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),inf_inf(fun(B,bool),A4,B3)))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),B3)) ) ).

tff(fact_78_inf1D1,axiom,
    ! [B: $tType,X1: B,B3: fun(B,bool),A4: fun(B,bool)] :
      ( pp(aa(B,bool,inf_inf(fun(B,bool),A4,B3),X1))
     => pp(aa(B,bool,A4,X1)) ) ).

tff(fact_79_inf1D2,axiom,
    ! [B: $tType,X1: B,B3: fun(B,bool),A4: fun(B,bool)] :
      ( pp(aa(B,bool,inf_inf(fun(B,bool),A4,B3),X1))
     => pp(aa(B,bool,B3,X1)) ) ).

tff(fact_80_Int__empty__left,axiom,
    ! [B: $tType,B3: fun(B,bool)] : ( inf_inf(fun(B,bool),bot_bot(fun(B,bool)),B3) = bot_bot(fun(B,bool)) ) ).

tff(fact_81_Int__empty__right,axiom,
    ! [B: $tType,A4: fun(B,bool)] : ( inf_inf(fun(B,bool),A4,bot_bot(fun(B,bool))) = bot_bot(fun(B,bool)) ) ).

tff(fact_82_disjoint__iff__not__equal,axiom,
    ! [B: $tType,B3: fun(B,bool),A4: fun(B,bool)] :
      ( ( inf_inf(fun(B,bool),A4,B3) = bot_bot(fun(B,bool)) )
    <=> ! [X2: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A4))
         => ! [Xa: B] :
              ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Xa),B3))
             => ( X2 != Xa ) ) ) ) ).

tff(fact_83_inf__fun__def,axiom,
    ! [C: $tType,B: $tType] :
      ( lattice(C)
     => ! [G: fun(B,C),F: fun(B,C),X: B] : ( aa(B,C,inf_inf(fun(B,C),F,G),X) = inf_inf(C,aa(B,C,F,X),aa(B,C,G,X)) ) ) ).

tff(fact_84_inf__apply,axiom,
    ! [B: $tType,C: $tType] :
      ( lattice(B)
     => ! [X1: C,G: fun(C,B),F: fun(C,B)] : ( aa(C,B,inf_inf(fun(C,B),F,G),X1) = inf_inf(B,aa(C,B,F,X1),aa(C,B,G,X1)) ) ) ).

tff(fact_85_depth_Osimps_I2_J,axiom,
    ! [B: $tType,T_21: huffma1450048681e_tree(B),Wa: nat,T_11: huffma1450048681e_tree(B),A2: B] :
      ( ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A2),huffma675207370phabet(B,T_11)))
       => ( huffma410068972_depth(B,huffma1146269203erNode(B,Wa,T_11,T_21),A2) = plus_plus(nat,huffma410068972_depth(B,T_11,A2),one_one(nat)) ) )
      & ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A2),huffma675207370phabet(B,T_11)))
       => ( ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A2),huffma675207370phabet(B,T_21)))
           => ( huffma410068972_depth(B,huffma1146269203erNode(B,Wa,T_11,T_21),A2) = plus_plus(nat,huffma410068972_depth(B,T_21,A2),one_one(nat)) ) )
          & ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A2),huffma675207370phabet(B,T_21)))
           => ( huffma410068972_depth(B,huffma1146269203erNode(B,Wa,T_11,T_21),A2) = zero_zero(nat) ) ) ) ) ) ).

tff(fact_86_bot__fun__def,axiom,
    ! [B: $tType,C: $tType] :
      ( bot(C)
     => ! [X: B] : ( aa(B,C,bot_bot(fun(B,C)),X) = bot_bot(C) ) ) ).

tff(fact_87_bot__apply,axiom,
    ! [C: $tType,B: $tType] :
      ( bot(B)
     => ! [X1: C] : ( aa(C,B,bot_bot(fun(C,B)),X1) = bot_bot(B) ) ) ).

tff(fact_88_exists__in__alphabet,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B)] :
    ? [A3: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A3),huffma675207370phabet(B,Ta))) ).

tff(fact_89_double__zero__sym,axiom,
    ! [B: $tType] :
      ( linord219039673up_add(B)
     => ! [A2: B] :
          ( ( zero_zero(B) = plus_plus(B,A2,A2) )
        <=> ( A2 = zero_zero(B) ) ) ) ).

tff(fact_90_add__is__0,axiom,
    ! [N: nat,M: nat] :
      ( ( plus_plus(nat,M,N) = zero_zero(nat) )
    <=> ( ( M = zero_zero(nat) )
        & ( N = zero_zero(nat) ) ) ) ).

tff(fact_91_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_92_depth_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,B2: A,W: nat] : ( huffma410068972_depth(A,huffma2021818691e_Leaf(A,W,B2),A1) = zero_zero(nat) ) ).

tff(fact_93_freq_Osimps_I1_J,axiom,
    ! [A: $tType,W: nat,A1: A,X: A] :
      ( ( ( X = A1 )
       => ( huffma1352802255e_freq(A,huffma2021818691e_Leaf(A,W,A1),X) = W ) )
      & ( ( X != A1 )
       => ( huffma1352802255e_freq(A,huffma2021818691e_Leaf(A,W,A1),X) = zero_zero(nat) ) ) ) ).

tff(fact_94_cost_Osimps_I1_J,axiom,
    ! [A: $tType,A1: A,W: nat] : ( huffma1134658180e_cost(A,huffma2021818691e_Leaf(A,W,A1)) = zero_zero(nat) ) ).

tff(fact_95_bot__nat__def,axiom,
    bot_bot(nat) = zero_zero(nat) ).

tff(fact_96_add__0__iff,axiom,
    ! [B: $tType] :
      ( semiri456707255roduct(B)
     => ! [A2: B,B1: B] :
          ( ( B1 = plus_plus(B,B1,A2) )
        <=> ( A2 = zero_zero(B) ) ) ) ).

tff(fact_97_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

%----Arities (23)
tff(arity_HOL_Obool___Lattices_Obounded__lattice,axiom,
    bounded_lattice(bool) ).

tff(arity_fun___Lattices_Obounded__lattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bounded_lattice(T_2)
     => bounded_lattice(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Obounded__lattice__bot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bounded_lattice(T_2)
     => bounded_lattice_bot(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Osemilattice__inf,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => semilattice_inf(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Olattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => lattice(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Lattices_Osemilattice__inf,axiom,
    semilattice_inf(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Lattices_Olattice,axiom,
    lattice(nat) ).

tff(arity_Nat_Onat___Orderings_Obot,axiom,
    bot(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_HOL_Obool___Lattices_Obounded__lattice__bot,axiom,
    bounded_lattice_bot(bool) ).

tff(arity_HOL_Obool___Lattices_Osemilattice__inf,axiom,
    semilattice_inf(bool) ).

tff(arity_HOL_Obool___Lattices_Olattice,axiom,
    lattice(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (11)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    huffma1134658180e_cost(a,huffma1146269203erNode(a,w,t_1,t_2)) = plus_plus(nat,plus_plus(nat,plus_plus(nat,huffma83463279weight(a,t_1),huffma1134658180e_cost(a,t_1)),huffma83463279weight(a,t_2)),huffma1134658180e_cost(a,t_2)) ).

%------------------------------------------------------------------------------
