%------------------------------------------------------------------------------
% File     : SWW534_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Huffman's Algorithm line 689
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla09] Blanchette (2009), Proof Pearl: Mechanizing the Textbo
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : huff_689 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  195 (  62 unt;  51 typ;   0 def)
%            Number of atoms       :  301 ( 145 equ)
%            Maximal formula atoms :    9 (   1 avg)
%            Number of connectives :  182 (  25   ~;  12   |;  16   &)
%                                         (  20 <=>; 109  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   5 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   28 (  19   >;   9   *;   0   +;   0  <<)
%            Number of predicates  :   18 (  17 usr;   0 prp; 1-2 aty)
%            Number of functors    :   30 (  30 usr;   5 con; 0-5 aty)
%            Number of variables   :  425 ( 374   !;   3   ?; 425   :)
%                                         (  48  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:30
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Huffman__Mirabelle__lalbadcutu_Otree,type,
    huffma1450048681e_tree: $tType > $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (45)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Finite__Set_Ofinite,type,
    finite_finite: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_Big__Operators_Ocomm__monoid__add__class_Osetsum,type,
    big_co1399186613setsum: 
      !>[B: $tType,A: $tType] : fun(fun(B,A),fun(fun(B,bool),A)) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(A,fun(B,C)) > fun(B,fun(A,C)) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(A,fun(B,C)) > fun(fun(A,B),fun(A,C)) ) ).

tff(sy_c_Finite__Set_Ofinite,type,
    finite_finite1: 
      !>[A: $tType] : ( fun(A,bool) > $o ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oalphabet,type,
    huffma675207370phabet: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > fun(A,bool) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oconsistent,type,
    huffma1518433673istent: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Odepth,type,
    huffma410068972_depth: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ofreq,type,
    huffma1352802255e_freq: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > fun(A,nat) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oheight,type,
    huffma945805758height: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OInnerNode,type,
    huffma1146269203erNode: 
      !>[A: $tType] : ( ( nat * huffma1450048681e_tree(A) * huffma1450048681e_tree(A) ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OLeaf,type,
    huffma2021818691e_Leaf: 
      !>[A: $tType] : ( ( nat * A ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oweight,type,
    huffma83463279weight: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_If,type,
    if: 
      !>[A: $tType] : fun(bool,fun(A,fun(A,A))) ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : fun(nat,A) ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat__aux,type,
    semiri532925092at_aux: 
      !>[A: $tType] : ( ( fun(A,A) * nat * A ) > A ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : fun(fun(A,bool),fun(A,bool)) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_t,type,
    t: huffma1450048681e_tree(a) ).

%----Relevant facts (98)
tff(fact_0_exists__in__alphabet,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B)] :
    ? [A5: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),huffma675207370phabet(B,Ta))) ).

tff(fact_1_setsum__commute,axiom,
    ! [C: $tType,B: $tType,D1: $tType] :
      ( comm_monoid_add(B)
     => ! [A3: fun(C,bool),B3: fun(D1,bool),F: fun(C,fun(D1,B))] : ( aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),aa(fun(D1,bool),fun(C,B),combc(C,fun(D1,bool),B,combb(fun(D1,B),fun(fun(D1,bool),B),C,big_co1399186613setsum(D1,B),F)),B3)),A3) = aa(fun(D1,bool),B,aa(fun(D1,B),fun(fun(D1,bool),B),big_co1399186613setsum(D1,B),aa(fun(C,bool),fun(D1,B),combc(D1,fun(C,bool),B,combb(fun(C,B),fun(fun(C,bool),B),D1,big_co1399186613setsum(C,B),combc(C,D1,B,F))),A3)),B3) ) ) ).

tff(fact_2_consistent_Osimps_I1_J,axiom,
    ! [A: $tType,A2: A,W1: nat] : huffma1518433673istent(A,huffma2021818691e_Leaf(A,W1,A2)) ).

tff(fact_3_notin__alphabet__imp__freq__0,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B),A1: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),huffma675207370phabet(B,Ta)))
     => ( aa(B,nat,huffma1352802255e_freq(B,Ta),A1) = zero_zero(nat) ) ) ).

tff(fact_4_weight_Osimps_I1_J,axiom,
    ! [A: $tType,A2: A,W1: nat] : ( huffma83463279weight(A,huffma2021818691e_Leaf(A,W1,A2)) = W1 ) ).

tff(fact_5_of__nat__setsum,axiom,
    ! [B: $tType,C: $tType] :
      ( semiring_1(B)
     => ! [A3: fun(C,bool),F: fun(C,nat)] : ( aa(nat,B,semiring_1_of_nat(B),aa(fun(C,bool),nat,aa(fun(C,nat),fun(fun(C,bool),nat),big_co1399186613setsum(C,nat),F),A3)) = aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),combb(nat,B,C,semiring_1_of_nat(B),F)),A3) ) ) ).

tff(fact_6_exists__at__height,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B)] :
      ( huffma1518433673istent(B,Ta)
     => ? [X3: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),huffma675207370phabet(B,Ta)))
          & ( huffma410068972_depth(B,Ta,X3) = huffma945805758height(B,Ta) ) ) ) ).

tff(fact_7_setsum__cong2,axiom,
    ! [C: $tType,B: $tType] :
      ( comm_monoid_add(C)
     => ! [G: fun(B,C),F: fun(B,C),A3: fun(B,bool)] :
          ( ! [X3: B] :
              ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A3))
             => ( aa(B,C,F,X3) = aa(B,C,G,X3) ) )
         => ( aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),F),A3) = aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),G),A3) ) ) ) ).

tff(fact_8_setsum__cong,axiom,
    ! [C: $tType,B: $tType] :
      ( comm_monoid_add(C)
     => ! [G: fun(B,C),F: fun(B,C),B3: fun(B,bool),A3: fun(B,bool)] :
          ( ( A3 = B3 )
         => ( ! [X3: B] :
                ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),B3))
               => ( aa(B,C,F,X3) = aa(B,C,G,X3) ) )
           => ( aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),F),A3) = aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),G),B3) ) ) ) ) ).

tff(fact_9_setsum_OF__cong,axiom,
    ! [C: $tType,B: $tType] :
      ( comm_monoid_add(C)
     => ! [G: fun(B,C),H: fun(B,C),B3: fun(B,bool),A3: fun(B,bool)] :
          ( ( A3 = B3 )
         => ( ! [X3: B] :
                ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),B3))
               => ( aa(B,C,H,X3) = aa(B,C,G,X3) ) )
           => ( aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),H),A3) = aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),G),B3) ) ) ) ) ).

tff(fact_10_finite__alphabet,axiom,
    ! [B: $tType,Ta: huffma1450048681e_tree(B)] : finite_finite1(B,huffma675207370phabet(B,Ta)) ).

tff(fact_11_weight_Osimps_I2_J,axiom,
    ! [A: $tType,T_22: huffma1450048681e_tree(A),T_12: huffma1450048681e_tree(A),W1: nat] : ( huffma83463279weight(A,huffma1146269203erNode(A,W1,T_12,T_22)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),huffma83463279weight(A,T_12)),huffma83463279weight(A,T_22)) ) ).

tff(fact_12_tree_Osimps_I1_J,axiom,
    ! [B: $tType,A4: B,Nat3: nat,A1: B,Nat2: nat] :
      ( ( huffma2021818691e_Leaf(B,Nat2,A1) = huffma2021818691e_Leaf(B,Nat3,A4) )
    <=> ( ( Nat2 = Nat3 )
        & ( A1 = A4 ) ) ) ).

tff(fact_13_tree_Osimps_I2_J,axiom,
    ! [B: $tType,Tree22: huffma1450048681e_tree(B),Tree12: huffma1450048681e_tree(B),Nat3: nat,Tree21: huffma1450048681e_tree(B),Tree11: huffma1450048681e_tree(B),Nat2: nat] :
      ( ( huffma1146269203erNode(B,Nat2,Tree11,Tree21) = huffma1146269203erNode(B,Nat3,Tree12,Tree22) )
    <=> ( ( Nat2 = Nat3 )
        & ( Tree11 = Tree12 )
        & ( Tree21 = Tree22 ) ) ) ).

tff(fact_14_double__eq__0__iff,axiom,
    ! [B: $tType] :
      ( linord219039673up_add(B)
     => ! [A1: B] :
          ( ( aa(B,B,aa(B,fun(B,B),plus_plus(B),A1),A1) = zero_zero(B) )
        <=> ( A1 = zero_zero(B) ) ) ) ).

tff(fact_15_setsum__0,axiom,
    ! [C: $tType,B: $tType] :
      ( comm_monoid_add(B)
     => ! [A3: fun(C,bool)] : ( aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),combk(B,C,zero_zero(B))),A3) = zero_zero(B) ) ) ).

tff(fact_16_height_Osimps_I1_J,axiom,
    ! [A: $tType,A2: A,W1: nat] : ( huffma945805758height(A,huffma2021818691e_Leaf(A,W1,A2)) = zero_zero(nat) ) ).

tff(fact_17_depth_Osimps_I1_J,axiom,
    ! [A: $tType,A2: A,B2: A,W1: nat] : ( huffma410068972_depth(A,huffma2021818691e_Leaf(A,W1,B2),A2) = zero_zero(nat) ) ).

tff(fact_18_freq_Osimps_I1_J,axiom,
    ! [A: $tType,W1: nat,A2: A,X4: A] :
      ( ( ( X4 = A2 )
       => ( aa(A,nat,huffma1352802255e_freq(A,huffma2021818691e_Leaf(A,W1,A2)),X4) = W1 ) )
      & ( ( X4 != A2 )
       => ( aa(A,nat,huffma1352802255e_freq(A,huffma2021818691e_Leaf(A,W1,A2)),X4) = zero_zero(nat) ) ) ) ).

tff(fact_19_freq_Osimps_I2_J,axiom,
    ! [A: $tType,T_22: huffma1450048681e_tree(A),T_12: huffma1450048681e_tree(A),W1: nat,X4: A] : ( aa(A,nat,huffma1352802255e_freq(A,huffma1146269203erNode(A,W1,T_12,T_22)),X4) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(A,nat,huffma1352802255e_freq(A,T_12),X4)),aa(A,nat,huffma1352802255e_freq(A,T_22),X4)) ) ).

tff(fact_20_tree_Osimps_I3_J,axiom,
    ! [A: $tType,Tree2: huffma1450048681e_tree(A),Tree1: huffma1450048681e_tree(A),Nat1: nat,A2: A,Nat: nat] : ( huffma2021818691e_Leaf(A,Nat,A2) != huffma1146269203erNode(A,Nat1,Tree1,Tree2) ) ).

tff(fact_21_tree_Osimps_I4_J,axiom,
    ! [A: $tType,A2: A,Nat: nat,Tree2: huffma1450048681e_tree(A),Tree1: huffma1450048681e_tree(A),Nat1: nat] : ( huffma1146269203erNode(A,Nat1,Tree1,Tree2) != huffma2021818691e_Leaf(A,Nat,A2) ) ).

tff(fact_22_setsum__eq__0__iff,axiom,
    ! [B: $tType,F: fun(B,nat),F1: fun(B,bool)] :
      ( finite_finite1(B,F1)
     => ( ( aa(fun(B,bool),nat,aa(fun(B,nat),fun(fun(B,bool),nat),big_co1399186613setsum(B,nat),F),F1) = zero_zero(nat) )
      <=> ! [X2: B] :
            ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),F1))
           => ( aa(B,nat,F,X2) = zero_zero(nat) ) ) ) ) ).

tff(fact_23_setsum__infinite,axiom,
    ! [B: $tType,C: $tType] :
      ( comm_monoid_add(C)
     => ! [F: fun(B,C),A3: fun(B,bool)] :
          ( ~ finite_finite1(B,A3)
         => ( aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),F),A3) = zero_zero(C) ) ) ) ).

tff(fact_24_setsum_Oinfinite,axiom,
    ! [B: $tType,C: $tType] :
      ( comm_monoid_add(C)
     => ! [G: fun(B,C),A3: fun(B,bool)] :
          ( ~ finite_finite1(B,A3)
         => ( aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),G),A3) = zero_zero(C) ) ) ) ).

tff(fact_25_setsum_Odistrib,axiom,
    ! [C: $tType,B: $tType] :
      ( comm_monoid_add(C)
     => ! [H: fun(B,C),G: fun(B,C),A3: fun(B,bool)] :
          ( finite_finite1(B,A3)
         => ( aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),aa(fun(B,C),fun(B,C),combs(B,C,C,combb(C,fun(C,C),B,plus_plus(C),G)),H)),A3) = aa(C,C,aa(C,fun(C,C),plus_plus(C),aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),G),A3)),aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),H),A3)) ) ) ) ).

tff(fact_26_setsum__delta,axiom,
    ! [B: $tType,C: $tType] :
      ( comm_monoid_add(C)
     => ! [B1: fun(B,C),A1: B,S: fun(B,bool)] :
          ( finite_finite1(B,S)
         => ( ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),S))
             => ( aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),aa(C,fun(B,C),combc(B,C,C,aa(fun(B,C),fun(B,fun(C,C)),combs(B,C,fun(C,C),combb(bool,fun(C,fun(C,C)),B,if(C),aa(B,fun(B,bool),combc(B,B,bool,fequal(B)),A1))),B1)),zero_zero(C))),S) = aa(B,C,B1,A1) ) )
            & ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),S))
             => ( aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),aa(C,fun(B,C),combc(B,C,C,aa(fun(B,C),fun(B,fun(C,C)),combs(B,C,fun(C,C),combb(bool,fun(C,fun(C,C)),B,if(C),aa(B,fun(B,bool),combc(B,B,bool,fequal(B)),A1))),B1)),zero_zero(C))),S) = zero_zero(C) ) ) ) ) ) ).

tff(fact_27_setsum__delta_H,axiom,
    ! [B: $tType,C: $tType] :
      ( comm_monoid_add(C)
     => ! [B1: fun(B,C),A1: B,S: fun(B,bool)] :
          ( finite_finite1(B,S)
         => ( ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),S))
             => ( aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),aa(C,fun(B,C),combc(B,C,C,aa(fun(B,C),fun(B,fun(C,C)),combs(B,C,fun(C,C),combb(bool,fun(C,fun(C,C)),B,if(C),aa(B,fun(B,bool),fequal(B),A1))),B1)),zero_zero(C))),S) = aa(B,C,B1,A1) ) )
            & ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),S))
             => ( aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),aa(C,fun(B,C),combc(B,C,C,aa(fun(B,C),fun(B,fun(C,C)),combs(B,C,fun(C,C),combb(bool,fun(C,fun(C,C)),B,if(C),aa(B,fun(B,bool),fequal(B),A1))),B1)),zero_zero(C))),S) = zero_zero(C) ) ) ) ) ) ).

tff(fact_28_int__setsum,axiom,
    ! [B: $tType,A3: fun(B,bool),F: fun(B,nat)] : ( aa(nat,int,semiring_1_of_nat(int),aa(fun(B,bool),nat,aa(fun(B,nat),fun(fun(B,bool),nat),big_co1399186613setsum(B,nat),F),A3)) = aa(fun(B,bool),int,aa(fun(B,int),fun(fun(B,bool),int),big_co1399186613setsum(B,int),combb(nat,int,B,semiring_1_of_nat(int),F)),A3) ) ).

tff(fact_29_setsum__addf,axiom,
    ! [B: $tType,C: $tType] :
      ( comm_monoid_add(B)
     => ! [A3: fun(C,bool),G: fun(C,B),F: fun(C,B)] : ( aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),aa(fun(C,B),fun(C,B),combs(C,B,B,combb(B,fun(B,B),C,plus_plus(B),F)),G)),A3) = aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),F),A3)),aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),G),A3)) ) ) ).

tff(fact_30_of__nat__add,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [N1: nat,M: nat] : ( aa(nat,A,semiring_1_of_nat(A),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N1)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(nat,A,semiring_1_of_nat(A),M)),aa(nat,A,semiring_1_of_nat(A),N1)) ) ) ).

tff(fact_31_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( aa(nat,A,semiring_1_of_nat(A),zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_32_add__is__0,axiom,
    ! [N: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),N) = zero_zero(nat) )
    <=> ( ( M1 = zero_zero(nat) )
        & ( N = zero_zero(nat) ) ) ) ).

tff(fact_33_double__zero__sym,axiom,
    ! [B: $tType] :
      ( linord219039673up_add(B)
     => ! [A1: B] :
          ( ( zero_zero(B) = aa(B,B,aa(B,fun(B,B),plus_plus(B),A1),A1) )
        <=> ( A1 = zero_zero(B) ) ) ) ).

tff(fact_34_finite__Collect__disjI,axiom,
    ! [B: $tType,Q1: fun(B,bool),P1: fun(B,bool)] :
      ( finite_finite1(B,aa(fun(B,bool),fun(B,bool),collect(B),aa(fun(B,bool),fun(B,bool),combs(B,bool,bool,combb(bool,fun(bool,bool),B,fdisj,P1)),Q1)))
    <=> ( finite_finite1(B,aa(fun(B,bool),fun(B,bool),collect(B),P1))
        & finite_finite1(B,aa(fun(B,bool),fun(B,bool),collect(B),Q1)) ) ) ).

tff(fact_35_finite__Collect__conjI,axiom,
    ! [B: $tType,Q1: fun(B,bool),P1: fun(B,bool)] :
      ( ( finite_finite1(B,aa(fun(B,bool),fun(B,bool),collect(B),P1))
        | finite_finite1(B,aa(fun(B,bool),fun(B,bool),collect(B),Q1)) )
     => finite_finite1(B,aa(fun(B,bool),fun(B,bool),collect(B),aa(fun(B,bool),fun(B,bool),combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,P1)),Q1))) ) ).

tff(fact_36_setsum_Oneutral,axiom,
    ! [B: $tType,C: $tType] :
      ( comm_monoid_add(C)
     => ! [G: fun(B,C),A3: fun(B,bool)] :
          ( finite_finite1(B,A3)
         => ( ! [X3: B] :
                ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A3))
               => ( aa(B,C,G,X3) = zero_zero(C) ) )
           => ( aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),G),A3) = zero_zero(C) ) ) ) ) ).

tff(fact_37_setsum__restrict__set_H,axiom,
    ! [C: $tType,B: $tType] :
      ( comm_monoid_add(C)
     => ! [B3: fun(B,bool),F: fun(B,C),A3: fun(B,bool)] :
          ( finite_finite1(B,A3)
         => ( aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),F),aa(fun(B,bool),fun(B,bool),collect(B),aa(fun(B,bool),fun(B,bool),combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,aa(fun(B,bool),fun(B,bool),combc(B,fun(B,bool),bool,member(B)),A3))),aa(fun(B,bool),fun(B,bool),combc(B,fun(B,bool),bool,member(B)),B3)))) = aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),aa(C,fun(B,C),combc(B,C,C,aa(fun(B,C),fun(B,fun(C,C)),combs(B,C,fun(C,C),combb(bool,fun(C,fun(C,C)),B,if(C),aa(fun(B,bool),fun(B,bool),combc(B,fun(B,bool),bool,member(B)),B3))),F)),zero_zero(C))),A3) ) ) ) ).

tff(fact_38_setsum__restrict__set_H_H,axiom,
    ! [C: $tType,B: $tType] :
      ( comm_monoid_add(C)
     => ! [P1: fun(B,bool),F: fun(B,C),A3: fun(B,bool)] :
          ( finite_finite1(B,A3)
         => ( aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),F),aa(fun(B,bool),fun(B,bool),collect(B),aa(fun(B,bool),fun(B,bool),combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,aa(fun(B,bool),fun(B,bool),combc(B,fun(B,bool),bool,member(B)),A3))),P1))) = aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),aa(C,fun(B,C),combc(B,C,C,aa(fun(B,C),fun(B,fun(C,C)),combs(B,C,fun(C,C),combb(bool,fun(C,fun(C,C)),B,if(C),P1)),F)),zero_zero(C))),A3) ) ) ) ).

tff(fact_39_add__right__cancel,axiom,
    ! [B: $tType] :
      ( cancel_semigroup_add(B)
     => ! [C2: B,A1: B,B1: B] :
          ( ( aa(B,B,aa(B,fun(B,B),plus_plus(B),B1),A1) = aa(B,B,aa(B,fun(B,B),plus_plus(B),C2),A1) )
        <=> ( B1 = C2 ) ) ) ).

tff(fact_40_add__left__cancel,axiom,
    ! [B: $tType] :
      ( cancel_semigroup_add(B)
     => ! [C2: B,B1: B,A1: B] :
          ( ( aa(B,B,aa(B,fun(B,B),plus_plus(B),A1),B1) = aa(B,B,aa(B,fun(B,B),plus_plus(B),A1),C2) )
        <=> ( B1 = C2 ) ) ) ).

tff(fact_41_finite__code,axiom,
    ! [B: $tType] :
      ( finite_finite(B)
     => ! [A3: fun(B,bool)] : finite_finite1(B,A3) ) ).

tff(fact_42_nat__add__right__cancel,axiom,
    ! [N: nat,K1: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),K1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),K1) )
    <=> ( M1 = N ) ) ).

tff(fact_43_nat__add__left__cancel,axiom,
    ! [N: nat,M1: nat,K1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K1),M1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K1),N) )
    <=> ( M1 = N ) ) ).

tff(fact_44_of__nat__eq__iff,axiom,
    ! [B: $tType] :
      ( semiring_char_0(B)
     => ! [N: nat,M1: nat] :
          ( ( aa(nat,B,semiring_1_of_nat(B),M1) = aa(nat,B,semiring_1_of_nat(B),N) )
        <=> ( M1 = N ) ) ) ).

tff(fact_45_int__int__eq,axiom,
    ! [N: nat,M1: nat] :
      ( ( aa(nat,int,semiring_1_of_nat(int),M1) = aa(nat,int,semiring_1_of_nat(int),N) )
    <=> ( M1 = N ) ) ).

tff(fact_46_zadd__int__left,axiom,
    ! [Z: int,N1: nat,M: nat] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(nat,int,semiring_1_of_nat(int),M)),aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(nat,int,semiring_1_of_nat(int),N1)),Z)) = aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(nat,int,semiring_1_of_nat(int),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N1))),Z) ) ).

tff(fact_47_zadd__int,axiom,
    ! [N1: nat,M: nat] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(nat,int,semiring_1_of_nat(int),M)),aa(nat,int,semiring_1_of_nat(int),N1)) = aa(nat,int,semiring_1_of_nat(int),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N1)) ) ).

tff(fact_48_int__eq__0__conv,axiom,
    ! [N: nat] :
      ( ( aa(nat,int,semiring_1_of_nat(int),N) = zero_zero(int) )
    <=> ( N = zero_zero(nat) ) ) ).

tff(fact_49_int__0,axiom,
    aa(nat,int,semiring_1_of_nat(int),zero_zero(nat)) = zero_zero(int) ).

tff(fact_50_zero__reorient,axiom,
    ! [B: $tType] :
      ( zero(B)
     => ! [X1: B] :
          ( ( zero_zero(B) = X1 )
        <=> ( X1 = zero_zero(B) ) ) ) ).

tff(fact_51_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A2: A,B2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),A2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),A2) )
         => ( B2 = C1 ) ) ) ).

tff(fact_52_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),B2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),C1) )
         => ( B2 = C1 ) ) ) ).

tff(fact_53_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),B2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),C1) )
         => ( B2 = C1 ) ) ) ).

tff(fact_54_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C1: A,B2: A,A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),B2)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),C1)) ) ) ).

tff(fact_55_finite,axiom,
    ! [B: $tType] :
      ( finite_finite(B)
     => ! [A3: fun(B,bool)] : finite_finite1(B,A3) ) ).

tff(fact_56_nat__add__assoc,axiom,
    ! [K: nat,N1: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N1)),K) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N1),K)) ) ).

tff(fact_57_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),X),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),Z)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),X),Z)) ) ).

tff(fact_58_nat__add__commute,axiom,
    ! [N1: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N1),M) ) ).

tff(fact_59_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),zero_zero(A)) = A2 ) ) ).

tff(fact_60_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),zero_zero(A)) = A2 ) ) ).

tff(fact_61_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A2) = A2 ) ) ).

tff(fact_62_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A2) = A2 ) ) ).

tff(fact_63_add__eq__self__zero,axiom,
    ! [N1: nat,M: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N1) = M )
     => ( N1 = zero_zero(nat) ) ) ).

tff(fact_64_Nat_Oadd__0__right,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),zero_zero(nat)) = M ) ).

tff(fact_65_plus__nat_Oadd__0,axiom,
    ! [N1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),zero_zero(nat)),N1) = N1 ) ).

tff(fact_66_setsum__setsum__restrict,axiom,
    ! [B: $tType,D1: $tType,C: $tType] :
      ( comm_monoid_add(D1)
     => ! [R1: fun(B,fun(C,bool)),F: fun(B,fun(C,D1)),T: fun(C,bool),S: fun(B,bool)] :
          ( finite_finite1(B,S)
         => ( finite_finite1(C,T)
           => ( aa(fun(B,bool),D1,aa(fun(B,D1),fun(fun(B,bool),D1),big_co1399186613setsum(B,D1),aa(fun(B,fun(C,bool)),fun(B,D1),combs(B,fun(C,bool),D1,combb(fun(C,D1),fun(fun(C,bool),D1),B,big_co1399186613setsum(C,D1),F)),combb(fun(C,bool),fun(C,bool),B,collect(C),combb(fun(C,bool),fun(C,bool),B,combs(C,bool,bool,combb(bool,fun(bool,bool),C,fconj,aa(fun(C,bool),fun(C,bool),combc(C,fun(C,bool),bool,member(C)),T))),R1)))),S) = aa(fun(C,bool),D1,aa(fun(C,D1),fun(fun(C,bool),D1),big_co1399186613setsum(C,D1),aa(fun(C,fun(B,bool)),fun(C,D1),combs(C,fun(B,bool),D1,combb(fun(B,D1),fun(fun(B,bool),D1),C,big_co1399186613setsum(B,D1),combc(B,C,D1,F))),combb(fun(B,bool),fun(B,bool),C,collect(B),combb(fun(B,bool),fun(B,bool),C,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,aa(fun(B,bool),fun(B,bool),combc(B,fun(B,bool),bool,member(B)),S))),combc(B,C,bool,R1))))),T) ) ) ) ) ).

tff(fact_67_tree_Osize_I3_J,axiom,
    ! [A: $tType,A2: A,Nat: nat] : ( size_size(huffma1450048681e_tree(A),huffma2021818691e_Leaf(A,Nat,A2)) = zero_zero(nat) ) ).

tff(fact_68_setsum_Ocong,axiom,
    ! [C: $tType,B: $tType] :
      ( comm_monoid_add(C)
     => ! [H: fun(B,C),G: fun(B,C),A3: fun(B,bool)] :
          ( finite_finite1(B,A3)
         => ( ! [X3: B] :
                ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A3))
               => ( aa(B,C,G,X3) = aa(B,C,H,X3) ) )
           => ( aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),G),A3) = aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),H),A3) ) ) ) ) ).

tff(fact_69_setsum__0_H,axiom,
    ! [B: $tType,C: $tType] :
      ( comm_monoid_add(C)
     => ! [F: fun(B,C),A3: fun(B,bool)] :
          ( ! [X3: B] :
              ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A3))
             => ( aa(B,C,F,X3) = zero_zero(C) ) )
         => ( aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),F),A3) = zero_zero(C) ) ) ) ).

tff(fact_70_setsum_Orelated,axiom,
    ! [B: $tType,C: $tType] :
      ( comm_monoid_add(B)
     => ! [G: fun(C,B),H: fun(C,B),S: fun(C,bool),R1: fun(B,fun(B,bool))] :
          ( pp(aa(B,bool,aa(B,fun(B,bool),R1,zero_zero(B)),zero_zero(B)))
         => ( ! [X11: B,Y11: B,X21: B,Y2: B] :
                ( ( pp(aa(B,bool,aa(B,fun(B,bool),R1,X11),X21))
                  & pp(aa(B,bool,aa(B,fun(B,bool),R1,Y11),Y2)) )
               => pp(aa(B,bool,aa(B,fun(B,bool),R1,aa(B,B,aa(B,fun(B,B),plus_plus(B),X11),Y11)),aa(B,B,aa(B,fun(B,B),plus_plus(B),X21),Y2))) )
           => ( finite_finite1(C,S)
             => ( ! [X3: C] :
                    ( pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),X3),S))
                   => pp(aa(B,bool,aa(B,fun(B,bool),R1,aa(C,B,H,X3)),aa(C,B,G,X3))) )
               => pp(aa(B,bool,aa(B,fun(B,bool),R1,aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),H),S)),aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),G),S))) ) ) ) ) ) ).

tff(fact_71_depth_Osimps_I2_J,axiom,
    ! [B: $tType,T_21: huffma1450048681e_tree(B),W: nat,T_11: huffma1450048681e_tree(B),A1: B] :
      ( ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),huffma675207370phabet(B,T_11)))
       => ( huffma410068972_depth(B,huffma1146269203erNode(B,W,T_11,T_21),A1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),huffma410068972_depth(B,T_11,A1)),one_one(nat)) ) )
      & ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),huffma675207370phabet(B,T_11)))
       => ( ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),huffma675207370phabet(B,T_21)))
           => ( huffma410068972_depth(B,huffma1146269203erNode(B,W,T_11,T_21),A1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),huffma410068972_depth(B,T_21,A1)),one_one(nat)) ) )
          & ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),huffma675207370phabet(B,T_21)))
           => ( huffma410068972_depth(B,huffma1146269203erNode(B,W,T_11,T_21),A1) = zero_zero(nat) ) ) ) ) ) ).

tff(fact_72_of__nat__1,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( aa(nat,A,semiring_1_of_nat(A),one_one(nat)) = one_one(A) ) ) ).

tff(fact_73_ext,axiom,
    ! [C: $tType,B: $tType,G: fun(B,C),F: fun(B,C)] :
      ( ! [X3: B] : ( aa(B,C,F,X3) = aa(B,C,G,X3) )
     => ( F = G ) ) ).

tff(fact_74_mem__def,axiom,
    ! [B: $tType,A3: fun(B,bool),X1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A3))
    <=> pp(aa(B,bool,A3,X1)) ) ).

tff(fact_75_Collect__def,axiom,
    ! [B: $tType,P1: fun(B,bool)] : ( aa(fun(B,bool),fun(B,bool),collect(B),P1) = P1 ) ).

tff(fact_76_one__reorient,axiom,
    ! [B: $tType] :
      ( one(B)
     => ! [X1: B] :
          ( ( one_one(B) = X1 )
        <=> ( X1 = one_one(B) ) ) ) ).

tff(fact_77_setsum__eq__1__iff,axiom,
    ! [B: $tType,F: fun(B,nat),A3: fun(B,bool)] :
      ( finite_finite1(B,A3)
     => ( ( aa(fun(B,bool),nat,aa(fun(B,nat),fun(fun(B,bool),nat),big_co1399186613setsum(B,nat),F),A3) = one_one(nat) )
      <=> ? [X2: B] :
            ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A3))
            & ( aa(B,nat,F,X2) = one_one(nat) )
            & ! [Xa: B] :
                ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Xa),A3))
               => ( ( X2 != Xa )
                 => ( aa(B,nat,F,Xa) = zero_zero(nat) ) ) ) ) ) ) ).

tff(fact_78_semiring__1__class_Oof__nat__code,axiom,
    ! [B: $tType] :
      ( semiring_1(B)
     => ! [N: nat] : ( aa(nat,B,semiring_1_of_nat(B),N) = semiri532925092at_aux(B,aa(B,fun(B,B),combc(B,B,B,plus_plus(B)),one_one(B)),N,zero_zero(B)) ) ) ).

tff(fact_79_Nat__Transfer_Otransfer__int__nat__functions_I1_J,axiom,
    ! [Y: nat,X: nat] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(nat,int,semiring_1_of_nat(int),X)),aa(nat,int,semiring_1_of_nat(int),Y)) = aa(nat,int,semiring_1_of_nat(int),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),X),Y)) ) ).

tff(fact_80_odd__nonzero,axiom,
    ! [Z: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(int,int,aa(int,fun(int,int),plus_plus(int),one_one(int)),Z)),Z) != zero_zero(int) ) ).

tff(fact_81_transfer__int__nat__numerals_I2_J,axiom,
    one_one(int) = aa(nat,int,semiring_1_of_nat(int),one_one(nat)) ).

tff(fact_82_int__1,axiom,
    aa(nat,int,semiring_1_of_nat(int),one_one(nat)) = one_one(int) ).

tff(fact_83_of__nat__aux_Osimps_I1_J,axiom,
    ! [B: $tType] :
      ( semiring_1(B)
     => ! [I: B,Inc: fun(B,B)] : ( semiri532925092at_aux(B,Inc,zero_zero(nat),I) = I ) ) ).

tff(fact_84_transfer__int__nat__relations_I1_J,axiom,
    ! [Y1: nat,X1: nat] :
      ( ( aa(nat,int,semiring_1_of_nat(int),X1) = aa(nat,int,semiring_1_of_nat(int),Y1) )
    <=> ( X1 = Y1 ) ) ).

tff(fact_85_int__if__cong,axiom,
    ! [Y1: nat,X1: nat,P1: bool] :
      ( ( pp(P1)
       => ( aa(nat,int,semiring_1_of_nat(int),X1) = aa(nat,int,semiring_1_of_nat(int),aa(nat,nat,aa(nat,fun(nat,nat),aa(bool,fun(nat,fun(nat,nat)),if(nat),P1),X1),Y1)) ) )
      & ( ~ pp(P1)
       => ( aa(nat,int,semiring_1_of_nat(int),Y1) = aa(nat,int,semiring_1_of_nat(int),aa(nat,nat,aa(nat,fun(nat,nat),aa(bool,fun(nat,fun(nat,nat)),if(nat),P1),X1),Y1)) ) ) ) ).

tff(fact_86_transfer__int__nat__numerals_I1_J,axiom,
    zero_zero(int) = aa(nat,int,semiring_1_of_nat(int),zero_zero(nat)) ).

tff(fact_87_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_88_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_89_comm__semiring__1__class_Onormalizing__semiring__rules_I5_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A2) = A2 ) ) ).

tff(fact_90_comm__semiring__1__class_Onormalizing__semiring__rules_I6_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),zero_zero(A)) = A2 ) ) ).

tff(fact_91_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,B2: A,A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),B2)),aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),D)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),C1)),aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),D)) ) ) ).

tff(fact_92_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B2: A,A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),B2)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),C1)),B2) ) ) ).

tff(fact_93_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B2: A,A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),B2)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),C1)) ) ) ).

tff(fact_94_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),D)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),C1)),D) ) ) ).

tff(fact_95_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),D)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),D)) ) ) ).

tff(fact_96_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),A2) ) ) ).

tff(fact_97_add__0__iff,axiom,
    ! [B: $tType] :
      ( semiri456707255roduct(B)
     => ! [A1: B,B1: B] :
          ( ( B1 = aa(B,B,aa(B,fun(B,B),plus_plus(B),B1),A1) )
        <=> ( A1 = zero_zero(B) ) ) ) ).

%----Arities (27)
tff(arity_fun___Finite__Set_Ofinite,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( finite_finite(T_2)
        & finite_finite(T_1) )
     => finite_finite(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(int) ).

tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Groups_Omonoid__add,axiom,
    monoid_add(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_HOL_Obool___Finite__Set_Ofinite,axiom,
    finite_finite(bool) ).

%----Helper facts (17)
tff(help_If_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( aa(A,A,aa(A,fun(A,A),aa(bool,fun(A,fun(A,A)),if(A),fTrue),X),Y) = X ) ).

tff(help_If_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( aa(A,A,aa(A,fun(A,A),aa(bool,fun(A,fun(A,A)),if(A),fFalse),X),Y) = Y ) ).

tff(help_If_3_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),combc(A,B,C,P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),combs(A,B,C,P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    huffma1518433673istent(a,t) ).

tff(conj_1,conjecture,
    huffma83463279weight(a,t) = aa(fun(a,bool),nat,aa(fun(a,nat),fun(fun(a,bool),nat),big_co1399186613setsum(a,nat),huffma1352802255e_freq(a,t)),huffma675207370phabet(a,t)) ).

%------------------------------------------------------------------------------
