%------------------------------------------------------------------------------
% File     : SWW533_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Huffman's Algorithm line 648
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla09] Blanchette (2009), Proof Pearl: Mechanizing the Textbo
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : huff_648 [Bla13]

% Status   : ContradictoryAxioms
% Rating   : 0.00 v8.1.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  192 (  65 unt;  56 typ;   0 def)
%            Number of atoms       :  264 (  96 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  175 (  47   ~;   9   |;  12   &)
%                                         (  22 <=>;  85  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   5 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   61 (  35   >;  26   *;   0   +;   0  <<)
%            Number of predicates  :   16 (  15 usr;   0 prp; 1-3 aty)
%            Number of functors    :   38 (  38 usr;   4 con; 0-5 aty)
%            Number of variables   :  414 ( 354   !;   4   ?; 414   :)
%                                         (  56  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:16
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Huffman__Mirabelle__lalbadcutu_Otree,type,
    huffma1450048681e_tree: $tType > $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (49)
tff(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Obounded__lattice,type,
    bounded_lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Osemilattice__inf,type,
    semilattice_inf: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Obounded__lattice__bot,type,
    bounded_lattice_bot: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oalphabet,type,
    huffma675207370phabet: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > fun(A,bool) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oalphabet_092_060_094isub_062F,type,
    huffma1516701463abet_F: 
      !>[A: $tType] : ( list(huffma1450048681e_tree(A)) > fun(A,bool) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oconsistent,type,
    huffma1518433673istent: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oconsistent_092_060_094isub_062F,type,
    huffma594769176tent_F: 
      !>[A: $tType] : ( list(huffma1450048681e_tree(A)) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Odepth,type,
    huffma410068972_depth: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ofreq,type,
    huffma1352802255e_freq: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Ofreq_092_060_094isub_062F,type,
    huffma409467474freq_F: 
      !>[A: $tType] : ( ( list(huffma1450048681e_tree(A)) * A ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oheight,type,
    huffma945805758height: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oheight_092_060_094isub_062F,type,
    huffma632063779ight_F: 
      !>[A: $tType] : ( list(huffma1450048681e_tree(A)) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OInnerNode,type,
    huffma1146269203erNode: 
      !>[A: $tType] : ( ( nat * huffma1450048681e_tree(A) * huffma1450048681e_tree(A) ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OLeaf,type,
    huffma2021818691e_Leaf: 
      !>[A: $tType] : ( ( nat * A ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_Otree__case,type,
    huffma107959123e_case: 
      !>[A: $tType,T1: $tType] : ( ( fun(nat,fun(A,T1)) * fun(nat,fun(huffma1450048681e_tree(A),fun(huffma1450048681e_tree(A),T1))) * huffma1450048681e_tree(A) ) > T1 ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_Otree__rec,type,
    huffma1280178957ee_rec: 
      !>[A: $tType,T1: $tType] : ( ( fun(nat,fun(A,T1)) * fun(nat,fun(huffma1450048681e_tree(A),fun(huffma1450048681e_tree(A),fun(T1,fun(T1,T1))))) * huffma1450048681e_tree(A) ) > T1 ) ).

tff(sy_c_Lattices_Oinf__class_Oinf,type,
    inf_inf: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_List_OdropWhile,type,
    dropWhile: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > list(A) ) ).

tff(sy_c_List_Olexn,type,
    lexn: 
      !>[A: $tType] : ( ( fun(product_prod(A,A),bool) * nat ) > fun(product_prod(list(A),list(A)),bool) ) ).

tff(sy_c_List_Olinorder__class_Osorted__list__of__set,type,
    linord467138063of_set: 
      !>[A: $tType] : ( fun(A,bool) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,fun(list(A),T1)) * list(A) ) > T1 ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,fun(list(A),fun(T1,T1))) * list(A) ) > T1 ) ).

tff(sy_c_List_Olist_Olist__size,type,
    list_size: 
      !>[A: $tType] : ( ( fun(A,nat) * list(A) ) > nat ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a1: a ).

%----Relevant facts (99)
tff(fact_0_Nil_I1_J,axiom,
    huffma594769176tent_F(a,nil(huffma1450048681e_tree(a))) ).

tff(fact_1_Nil_I2_J,axiom,
    huffma632063779ight_F(a,nil(huffma1450048681e_tree(a))) = zero_zero(nat) ).

tff(fact_2_Nil_I3_J,axiom,
    pp(aa(fun(a,bool),bool,aa(a,fun(fun(a,bool),bool),member(a),a1),huffma1516701463abet_F(a,nil(huffma1450048681e_tree(a))))) ).

tff(fact_3_tree_Osimps_I1_J,axiom,
    ! [B: $tType,A4: B,Nat2: nat,Aa: B,Nat1: nat] :
      ( ( huffma2021818691e_Leaf(B,Nat1,Aa) = huffma2021818691e_Leaf(B,Nat2,A4) )
    <=> ( ( Nat1 = Nat2 )
        & ( Aa = A4 ) ) ) ).

tff(fact_4_consistent_092_060_094isub_062F_Osimps_I1_J,axiom,
    ! [A: $tType] : huffma594769176tent_F(A,nil(huffma1450048681e_tree(A))) ).

tff(fact_5_freq_092_060_094isub_062F_Osimps_I1_J,axiom,
    ! [A: $tType,X4: A] : ( huffma409467474freq_F(A,nil(huffma1450048681e_tree(A)),X4) = zero_zero(nat) ) ).

tff(fact_6_height_092_060_094isub_062F_Osimps_I1_J,axiom,
    ! [A: $tType] : ( huffma632063779ight_F(A,nil(huffma1450048681e_tree(A))) = zero_zero(nat) ) ).

tff(fact_7_tree_Osimps_I5_J,axiom,
    ! [B: $tType,C: $tType,Aa: C,Nat1: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B))),F1: fun(nat,fun(C,B))] : ( huffma107959123e_case(C,B,F1,F2,huffma2021818691e_Leaf(C,Nat1,Aa)) = aa(C,B,aa(nat,fun(C,B),F1,Nat1),Aa) ) ).

tff(fact_8_notin__alphabet_092_060_094isub_062F__imp__freq_092_060_094isub_062F__0,axiom,
    ! [B: $tType,Tsa: list(huffma1450048681e_tree(B)),Aa: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Aa),huffma1516701463abet_F(B,Tsa)))
     => ( huffma409467474freq_F(B,Tsa,Aa) = zero_zero(nat) ) ) ).

tff(fact_9_consistent_Osimps_I1_J,axiom,
    ! [A: $tType,A2: A,W1: nat] : huffma1518433673istent(A,huffma2021818691e_Leaf(A,W1,A2)) ).

tff(fact_10_tree_Orecs_I1_J,axiom,
    ! [B: $tType,C: $tType,Aa: C,Nat1: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B,fun(B,B))))),F1: fun(nat,fun(C,B))] : ( huffma1280178957ee_rec(C,B,F1,F2,huffma2021818691e_Leaf(C,Nat1,Aa)) = aa(C,B,aa(nat,fun(C,B),F1,Nat1),Aa) ) ).

tff(fact_11_tree_Osize_I3_J,axiom,
    ! [A: $tType,A2: A,Nat4: nat] : ( size_size(huffma1450048681e_tree(A),huffma2021818691e_Leaf(A,Nat4,A2)) = zero_zero(nat) ) ).

tff(fact_12_freq_Osimps_I1_J,axiom,
    ! [A: $tType,W1: nat,A2: A,X4: A] :
      ( ( ( X4 = A2 )
       => ( huffma1352802255e_freq(A,huffma2021818691e_Leaf(A,W1,A2),X4) = W1 ) )
      & ( ( X4 != A2 )
       => ( huffma1352802255e_freq(A,huffma2021818691e_Leaf(A,W1,A2),X4) = zero_zero(nat) ) ) ) ).

tff(fact_13_depth_Osimps_I1_J,axiom,
    ! [A: $tType,A2: A,B2: A,W1: nat] : ( huffma410068972_depth(A,huffma2021818691e_Leaf(A,W1,B2),A2) = zero_zero(nat) ) ).

tff(fact_14_tree_Osimps_I3_J,axiom,
    ! [A: $tType,Tree23: huffma1450048681e_tree(A),Tree13: huffma1450048681e_tree(A),Nat3: nat,A2: A,Nat4: nat] : ( huffma2021818691e_Leaf(A,Nat4,A2) != huffma1146269203erNode(A,Nat3,Tree13,Tree23) ) ).

tff(fact_15_tree_Osimps_I4_J,axiom,
    ! [A: $tType,A2: A,Nat4: nat,Tree23: huffma1450048681e_tree(A),Tree13: huffma1450048681e_tree(A),Nat3: nat] : ( huffma1146269203erNode(A,Nat3,Tree13,Tree23) != huffma2021818691e_Leaf(A,Nat4,A2) ) ).

tff(fact_16_dropWhile__eq__Nil__conv,axiom,
    ! [B: $tType,Xs: list(B),P1: fun(B,bool)] :
      ( ( dropWhile(B,P1,Xs) = nil(B) )
    <=> ! [X3: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),set(B,Xs)))
         => pp(aa(B,bool,P1,X3)) ) ) ).

tff(fact_17_tree_Osimps_I2_J,axiom,
    ! [B: $tType,Tree22: huffma1450048681e_tree(B),Tree12: huffma1450048681e_tree(B),Nat2: nat,Tree21: huffma1450048681e_tree(B),Tree11: huffma1450048681e_tree(B),Nat1: nat] :
      ( ( huffma1146269203erNode(B,Nat1,Tree11,Tree21) = huffma1146269203erNode(B,Nat2,Tree12,Tree22) )
    <=> ( ( Nat1 = Nat2 )
        & ( Tree11 = Tree12 )
        & ( Tree21 = Tree22 ) ) ) ).

tff(fact_18_dropWhile_Osimps_I1_J,axiom,
    ! [B: $tType,P1: fun(B,bool)] : ( dropWhile(B,P1,nil(B)) = nil(B) ) ).

tff(fact_19_tree_Osimps_I6_J,axiom,
    ! [B: $tType,C: $tType,Tree21: huffma1450048681e_tree(C),Tree11: huffma1450048681e_tree(C),Nat1: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B))),F1: fun(nat,fun(C,B))] : ( huffma107959123e_case(C,B,F1,F2,huffma1146269203erNode(C,Nat1,Tree11,Tree21)) = aa(huffma1450048681e_tree(C),B,aa(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B),aa(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B)),F2,Nat1),Tree11),Tree21) ) ).

tff(fact_20_tree_Orecs_I2_J,axiom,
    ! [B: $tType,C: $tType,Tree21: huffma1450048681e_tree(C),Tree11: huffma1450048681e_tree(C),Nat1: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B,fun(B,B))))),F1: fun(nat,fun(C,B))] : ( huffma1280178957ee_rec(C,B,F1,F2,huffma1146269203erNode(C,Nat1,Tree11,Tree21)) = aa(B,B,aa(B,fun(B,B),aa(huffma1450048681e_tree(C),fun(B,fun(B,B)),aa(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B,fun(B,B))),aa(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B,fun(B,B)))),F2,Nat1),Tree11),Tree21),huffma1280178957ee_rec(C,B,F1,F2,Tree11)),huffma1280178957ee_rec(C,B,F1,F2,Tree21)) ) ).

tff(fact_21_dropWhile__cong,axiom,
    ! [B: $tType,Q1: fun(B,bool),P1: fun(B,bool),K: list(B),L: list(B)] :
      ( ( L = K )
     => ( ! [X2: B] :
            ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),set(B,L)))
           => ( pp(aa(B,bool,P1,X2))
            <=> pp(aa(B,bool,Q1,X2)) ) )
       => ( dropWhile(B,P1,L) = dropWhile(B,Q1,K) ) ) ) ).

tff(fact_22_tree_Oexhaust,axiom,
    ! [A: $tType,Y: huffma1450048681e_tree(A)] :
      ( ! [Nat: nat,A3: A] : ( Y != huffma2021818691e_Leaf(A,Nat,A3) )
     => ~ ! [Nat: nat,Tree1: huffma1450048681e_tree(A),Tree2: huffma1450048681e_tree(A)] : ( Y != huffma1146269203erNode(A,Nat,Tree1,Tree2) ) ) ).

tff(fact_23_list_Osimps_I4_J,axiom,
    ! [C: $tType,B: $tType,F2: fun(C,fun(list(C),B)),F1: B] : ( list_case(B,C,F1,F2,nil(C)) = F1 ) ).

tff(fact_24_height_Osimps_I1_J,axiom,
    ! [A: $tType,A2: A,W1: nat] : ( huffma945805758height(A,huffma2021818691e_Leaf(A,W1,A2)) = zero_zero(nat) ) ).

tff(fact_25_list_Osize_I1_J,axiom,
    ! [B: $tType,Fa: fun(B,nat)] : ( list_size(B,Fa,nil(B)) = zero_zero(nat) ) ).

tff(fact_26_list__ex1__simps_I1_J,axiom,
    ! [B: $tType,P1: fun(B,bool)] : ~ list_ex1(B,P1,nil(B)) ).

tff(fact_27_alphabet_092_060_094isub_062F_Osimps_I1_J,axiom,
    ! [B: $tType] : ( huffma1516701463abet_F(B,nil(huffma1450048681e_tree(B))) = bot_bot(fun(B,bool)) ) ).

tff(fact_28_List_Oset_Osimps_I1_J,axiom,
    ! [B: $tType] : ( set(B,nil(B)) = bot_bot(fun(B,bool)) ) ).

tff(fact_29_set__empty2,axiom,
    ! [B: $tType,Xs: list(B)] :
      ( ( bot_bot(fun(B,bool)) = set(B,Xs) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_30_set__empty,axiom,
    ! [B: $tType,Xs: list(B)] :
      ( ( set(B,Xs) = bot_bot(fun(B,bool)) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_31_list__ex1__iff,axiom,
    ! [B: $tType,Xs: list(B),P1: fun(B,bool)] :
      ( list_ex1(B,P1,Xs)
    <=> ? [X3: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),set(B,Xs)))
          & pp(aa(B,bool,P1,X3))
          & ! [Y3: B] :
              ( ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Y3),set(B,Xs)))
                & pp(aa(B,bool,P1,Y3)) )
             => ( Y3 = X3 ) ) ) ) ).

tff(fact_32_zero__reorient,axiom,
    ! [B: $tType] :
      ( zero(B)
     => ! [X1: B] :
          ( ( zero_zero(B) = X1 )
        <=> ( X1 = zero_zero(B) ) ) ) ).

tff(fact_33_emptyE,axiom,
    ! [B: $tType,Aa: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Aa),bot_bot(fun(B,bool)))) ).

tff(fact_34_Collect__empty__eq,axiom,
    ! [B: $tType,P1: fun(B,bool)] :
      ( ( collect(B,P1) = bot_bot(fun(B,bool)) )
    <=> ! [X3: B] : ~ pp(aa(B,bool,P1,X3)) ) ).

tff(fact_35_empty__iff,axiom,
    ! [B: $tType,C3: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C3),bot_bot(fun(B,bool)))) ).

tff(fact_36_empty__Collect__eq,axiom,
    ! [B: $tType,P1: fun(B,bool)] :
      ( ( bot_bot(fun(B,bool)) = collect(B,P1) )
    <=> ! [X3: B] : ~ pp(aa(B,bool,P1,X3)) ) ).

tff(fact_37_all__not__in__conv,axiom,
    ! [B: $tType,A1: fun(B,bool)] :
      ( ! [X3: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A1))
    <=> ( A1 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_38_bot__apply,axiom,
    ! [C: $tType,B: $tType] :
      ( bot(B)
     => ! [X1: C] : ( aa(C,B,bot_bot(fun(C,B)),X1) = bot_bot(B) ) ) ).

tff(fact_39_empty__def,axiom,
    ! [B: $tType] : ( bot_bot(fun(B,bool)) = collect(B,combk(bool,B,fFalse)) ) ).

tff(fact_40_ex__in__conv,axiom,
    ! [B: $tType,A1: fun(B,bool)] :
      ( ? [X3: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A1))
    <=> ( A1 != bot_bot(fun(B,bool)) ) ) ).

tff(fact_41_equals0D,axiom,
    ! [B: $tType,Aa: B,A1: fun(B,bool)] :
      ( ( A1 = bot_bot(fun(B,bool)) )
     => ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Aa),A1)) ) ).

tff(fact_42_bot__fun__def,axiom,
    ! [B: $tType,C: $tType] :
      ( bot(C)
     => ! [X4: B] : ( aa(B,C,bot_bot(fun(B,C)),X4) = bot_bot(C) ) ) ).

tff(fact_43_sorted__list__of__set__empty,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ( linord467138063of_set(B,bot_bot(fun(B,bool))) = nil(B) ) ) ).

tff(fact_44_equals0I,axiom,
    ! [B: $tType,A1: fun(B,bool)] :
      ( ! [Y2: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Y2),A1))
     => ( A1 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_45_lexn_Osimps_I1_J,axiom,
    ! [B: $tType,R1: fun(product_prod(B,B),bool)] : ( lexn(B,R1,zero_zero(nat)) = bot_bot(fun(product_prod(list(B),list(B)),bool)) ) ).

tff(fact_46_exists__at__height,axiom,
    ! [B: $tType,T: huffma1450048681e_tree(B)] :
      ( huffma1518433673istent(B,T)
     => ? [X2: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),huffma675207370phabet(B,T)))
          & ( huffma410068972_depth(B,T,X2) = huffma945805758height(B,T) ) ) ) ).

tff(fact_47_list_Orecs_I1_J,axiom,
    ! [C: $tType,B: $tType,F2: fun(C,fun(list(C),fun(B,B))),F1: B] : ( list_rec(B,C,F1,F2,nil(C)) = F1 ) ).

tff(fact_48_notin__alphabet__imp__freq__0,axiom,
    ! [B: $tType,T: huffma1450048681e_tree(B),Aa: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Aa),huffma675207370phabet(B,T)))
     => ( huffma1352802255e_freq(B,T,Aa) = zero_zero(nat) ) ) ).

tff(fact_49_consistent_Osimps_I2_J,axiom,
    ! [B: $tType,T_21: huffma1450048681e_tree(B),T_11: huffma1450048681e_tree(B),W: nat] :
      ( huffma1518433673istent(B,huffma1146269203erNode(B,W,T_11,T_21))
    <=> ( huffma1518433673istent(B,T_11)
        & huffma1518433673istent(B,T_21)
        & ( inf_inf(fun(B,bool),huffma675207370phabet(B,T_11),huffma675207370phabet(B,T_21)) = bot_bot(fun(B,bool)) ) ) ) ).

tff(fact_50_exists__in__alphabet,axiom,
    ! [B: $tType,T: huffma1450048681e_tree(B)] :
    ? [A3: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A3),huffma675207370phabet(B,T))) ).

tff(fact_51_height__gt__0__alphabet__eq__imp__height__gt__0,axiom,
    ! [B: $tType,U: huffma1450048681e_tree(B),T: huffma1450048681e_tree(B)] :
      ( ord_less(nat,zero_zero(nat),huffma945805758height(B,T))
     => ( huffma1518433673istent(B,T)
       => ( ( huffma675207370phabet(B,T) = huffma675207370phabet(B,U) )
         => ord_less(nat,zero_zero(nat),huffma945805758height(B,U)) ) ) ) ).

tff(fact_52_freq__0__left,axiom,
    ! [B: $tType,Aa: B,T_21: huffma1450048681e_tree(B),T_11: huffma1450048681e_tree(B)] :
      ( ( inf_inf(fun(B,bool),huffma675207370phabet(B,T_11),huffma675207370phabet(B,T_21)) = bot_bot(fun(B,bool)) )
     => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Aa),huffma675207370phabet(B,T_21)))
       => ( huffma1352802255e_freq(B,T_11,Aa) = zero_zero(nat) ) ) ) ).

tff(fact_53_IntE,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool),C3: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C3),inf_inf(fun(B,bool),A1,B1)))
     => ~ ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C3),A1))
         => ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C3),B1)) ) ) ).

tff(fact_54_IntI,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool),C3: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C3),A1))
     => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C3),B1))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C3),inf_inf(fun(B,bool),A1,B1))) ) ) ).

tff(fact_55_Int__iff,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool),C3: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C3),inf_inf(fun(B,bool),A1,B1)))
    <=> ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C3),A1))
        & pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C3),B1)) ) ) ).

tff(fact_56_disjoint__iff__not__equal,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool)] :
      ( ( inf_inf(fun(B,bool),A1,B1) = bot_bot(fun(B,bool)) )
    <=> ! [X3: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A1))
         => ! [Xa: B] :
              ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Xa),B1))
             => ( X3 != Xa ) ) ) ) ).

tff(fact_57_Int__empty__right,axiom,
    ! [B: $tType,A1: fun(B,bool)] : ( inf_inf(fun(B,bool),A1,bot_bot(fun(B,bool))) = bot_bot(fun(B,bool)) ) ).

tff(fact_58_Int__empty__left,axiom,
    ! [B: $tType,B1: fun(B,bool)] : ( inf_inf(fun(B,bool),bot_bot(fun(B,bool)),B1) = bot_bot(fun(B,bool)) ) ).

tff(fact_59_bot__less,axiom,
    ! [B: $tType] :
      ( bot(B)
     => ! [Aa: B] :
          ( ( Aa != bot_bot(B) )
        <=> ord_less(B,bot_bot(B),Aa) ) ) ).

tff(fact_60_not__less__bot,axiom,
    ! [A: $tType] :
      ( bot(A)
     => ! [A2: A] : ~ ord_less(A,A2,bot_bot(A)) ) ).

tff(fact_61_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ ord_less(A,X,Y)
         => ( ( X != Y )
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_62_IntD2,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool),C3: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C3),inf_inf(fun(B,bool),A1,B1)))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C3),B1)) ) ).

tff(fact_63_IntD1,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool),C3: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C3),inf_inf(fun(B,bool),A1,B1)))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C3),A1)) ) ).

tff(fact_64_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_65_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( ord_less(A,Y,Z)
           => ord_less(A,X,Z) ) ) ) ).

tff(fact_66_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A2: A] :
          ( ord_less(A,A2,B2)
         => ( ( B2 = C2 )
           => ord_less(A,A2,C2) ) ) ) ).

tff(fact_67_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A2: A] :
          ( ( A2 = B2 )
         => ( ord_less(A,B2,C2)
           => ord_less(A,A2,C2) ) ) ) ).

tff(fact_68_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B2: A,A2: A] :
          ( ord_less(A,A2,B2)
         => ~ ord_less(A,B2,A2) ) ) ).

tff(fact_69_order__less__imp__triv,axiom,
    ! [B: $tType] :
      ( preorder(B)
     => ! [P1: bool,Y1: B,X1: B] :
          ( ord_less(B,X1,Y1)
         => ( ord_less(B,Y1,X1)
           => pp(P1) ) ) ) ).

tff(fact_70_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( Y != X ) ) ) ).

tff(fact_71_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( X != Y ) ) ) ).

tff(fact_72_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_73_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_74_ext,axiom,
    ! [C: $tType,B: $tType,G: fun(B,C),F: fun(B,C)] :
      ( ! [X2: B] : ( aa(B,C,F,X2) = aa(B,C,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [B: $tType,A1: fun(B,bool),X1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A1))
    <=> pp(aa(B,bool,A1,X1)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [B: $tType,P1: fun(B,bool)] : ( collect(B,P1) = P1 ) ).

tff(fact_77_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( X != Y ) ) ) ).

tff(fact_78_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ ord_less(A,X,Y)
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_79_linorder__antisym__conv3,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [X1: B,Y1: B] :
          ( ~ ord_less(B,Y1,X1)
         => ( ~ ord_less(B,X1,Y1)
          <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_80_Int__assoc,axiom,
    ! [B: $tType,C1: fun(B,bool),B1: fun(B,bool),A1: fun(B,bool)] : ( inf_inf(fun(B,bool),inf_inf(fun(B,bool),A1,B1),C1) = inf_inf(fun(B,bool),A1,inf_inf(fun(B,bool),B1,C1)) ) ).

tff(fact_81_Int__Collect,axiom,
    ! [B: $tType,P1: fun(B,bool),A1: fun(B,bool),X1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),inf_inf(fun(B,bool),A1,collect(B,P1))))
    <=> ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A1))
        & pp(aa(B,bool,P1,X1)) ) ) ).

tff(fact_82_Int__left__commute,axiom,
    ! [B: $tType,C1: fun(B,bool),B1: fun(B,bool),A1: fun(B,bool)] : ( inf_inf(fun(B,bool),A1,inf_inf(fun(B,bool),B1,C1)) = inf_inf(fun(B,bool),B1,inf_inf(fun(B,bool),A1,C1)) ) ).

tff(fact_83_Int__left__absorb,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool)] : ( inf_inf(fun(B,bool),A1,inf_inf(fun(B,bool),A1,B1)) = inf_inf(fun(B,bool),A1,B1) ) ).

tff(fact_84_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
          | ( X = Y )
          | ord_less(A,Y,X) ) ) ).

tff(fact_85_Int__commute,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool)] : ( inf_inf(fun(B,bool),A1,B1) = inf_inf(fun(B,bool),B1,A1) ) ).

tff(fact_86_Int__def,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool)] : ( inf_inf(fun(B,bool),A1,B1) = collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,combc(B,fun(B,bool),bool,member(B),A1)),combc(B,fun(B,bool),bool,member(B),B1))) ) ).

tff(fact_87_Int__absorb,axiom,
    ! [B: $tType,A1: fun(B,bool)] : ( inf_inf(fun(B,bool),A1,A1) = A1 ) ).

tff(fact_88_not__less__iff__gr__or__eq,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [Y1: B,X1: B] :
          ( ~ ord_less(B,X1,Y1)
        <=> ( ord_less(B,Y1,X1)
            | ( X1 = Y1 ) ) ) ) ).

tff(fact_89_linorder__neq__iff,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [Y1: B,X1: B] :
          ( ( X1 != Y1 )
        <=> ( ord_less(B,X1,Y1)
            | ord_less(B,Y1,X1) ) ) ) ).

tff(fact_90_Collect__conj__eq,axiom,
    ! [B: $tType,Q1: fun(B,bool),P1: fun(B,bool)] : ( collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,P1),Q1)) = inf_inf(fun(B,bool),collect(B,P1),collect(B,Q1)) ) ).

tff(fact_91_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ~ ord_less(A,X,X) ) ).

tff(fact_92_list__size__estimation,axiom,
    ! [B: $tType,F: fun(B,nat),Y1: nat,Xs: list(B),X1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),set(B,Xs)))
     => ( ord_less(nat,Y1,aa(B,nat,F,X1))
       => ord_less(nat,Y1,list_size(B,F,Xs)) ) ) ).

tff(fact_93_freq__0__right,axiom,
    ! [B: $tType,Aa: B,T_21: huffma1450048681e_tree(B),T_11: huffma1450048681e_tree(B)] :
      ( ( inf_inf(fun(B,bool),huffma675207370phabet(B,T_11),huffma675207370phabet(B,T_21)) = bot_bot(fun(B,bool)) )
     => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Aa),huffma675207370phabet(B,T_11)))
       => ( huffma1352802255e_freq(B,T_21,Aa) = zero_zero(nat) ) ) ) ).

tff(fact_94_less__zeroE,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_95_less__nat__zero__code,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_96_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_97_inf__bot__right,axiom,
    ! [A: $tType] :
      ( bounded_lattice_bot(A)
     => ! [X: A] : ( inf_inf(A,X,bot_bot(A)) = bot_bot(A) ) ) ).

tff(fact_98_inf__left__idem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Y: A,X: A] : ( inf_inf(A,X,inf_inf(A,X,Y)) = inf_inf(A,X,Y) ) ) ).

%----Arities (25)
tff(arity_HOL_Obool___Lattices_Obounded__lattice,axiom,
    bounded_lattice(bool) ).

tff(arity_HOL_Obool___Lattices_Olattice,axiom,
    lattice(bool) ).

tff(arity_Nat_Onat___Lattices_Olattice,axiom,
    lattice(nat) ).

tff(arity_fun___Lattices_Obounded__lattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bounded_lattice(T_2)
     => bounded_lattice(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Olattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => lattice(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Obounded__lattice__bot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bounded_lattice(T_2)
     => bounded_lattice_bot(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Osemilattice__inf,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => semilattice_inf(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Lattices_Osemilattice__inf,axiom,
    semilattice_inf(nat) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_Nat_Onat___Orderings_Obot,axiom,
    bot(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Lattices_Obounded__lattice__bot,axiom,
    bounded_lattice_bot(bool) ).

tff(arity_HOL_Obool___Lattices_Osemilattice__inf,axiom,
    semilattice_inf(bool) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (11)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(fun(huffma1450048681e_tree(a),bool),bool,aa(huffma1450048681e_tree(a),fun(fun(huffma1450048681e_tree(a),bool),bool),member(huffma1450048681e_tree(a)),huffma2021818691e_Leaf(a,huffma409467474freq_F(a,nil(huffma1450048681e_tree(a)),a1),a1)),set(huffma1450048681e_tree(a),nil(huffma1450048681e_tree(a))))) ).

%------------------------------------------------------------------------------
