%------------------------------------------------------------------------------
% File     : SWW530_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Huffman's Algorithm line 569
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla09] Blanchette (2009), Proof Pearl: Mechanizing the Textbo
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : huff_569 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v7.5.0, 0.67 v7.4.0, 0.50 v7.3.0, 0.25 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  177 (  43 unt;  45 typ;   0 def)
%            Number of atoms       :  322 (  78 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  204 (  14   ~;   4   |;  15   &)
%                                         (  28 <=>; 143  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   40 (  23   >;  17   *;   0   +;   0  <<)
%            Number of predicates  :   17 (  16 usr;   1 prp; 0-4 aty)
%            Number of functors    :   24 (  24 usr;   5 con; 0-5 aty)
%            Number of variables   :  388 ( 348   !;   4   ?; 388   :)
%                                         (  36  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:44
%------------------------------------------------------------------------------
%----Should-be-implicit typings (8)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_t_b,type,
    b: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Huffman__Mirabelle__lalbadcutu_Otree,type,
    huffma1450048681e_tree: $tType > $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (37)
tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Odepth,type,
    huffma410068972_depth: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oheight,type,
    huffma945805758height: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oheight_092_060_094isub_062F,type,
    huffma632063779ight_F: 
      !>[A: $tType] : ( list(huffma1450048681e_tree(A)) > nat ) ).

tff(sy_c_If,type,
    if: 
      !>[A: $tType] : ( ( bool * A * A ) > A ) ).

tff(sy_c_Int_Onat,type,
    nat1: int > nat ).

tff(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_List_Olinorder__class_Oinsort__key,type,
    linorder_insort_key: 
      !>[B2: $tType,A: $tType] : ( ( fun(B2,A) * B2 * list(B2) ) > list(B2) ) ).

tff(sy_c_List_Olinorder__class_Osort__key,type,
    linorder_sort_key: 
      !>[B2: $tType,A: $tType] : ( ( fun(B2,A) * list(B2) ) > list(B2) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,fun(list(A),T1)) * list(A) ) > T1 ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,fun(list(A),fun(T1,T1))) * list(A) ) > T1 ) ).

tff(sy_c_List_Onull,type,
    null: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Nat__Transfer_Otransfer__morphism,type,
    nat_tr1645093318rphism: 
      !>[B2: $tType,A: $tType] : ( ( fun(B2,A) * fun(B2,bool) ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Omax,type,
    ord_max: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Orderings_Oorder__class_Ostrict__mono,type,
    order_strict_mono: 
      !>[A: $tType,B2: $tType] : ( fun(A,B2) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B2: $tType] : ( ( fun(A,B2) * A ) > B2 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_P,type,
    p: $o ).

tff(sy_v_a,type,
    a1: a ).

tff(sy_v_t_092_060_094isub_0621,type,
    t_1: huffma1450048681e_tree(b) ).

tff(sy_v_t_092_060_094isub_0622,type,
    t_2: huffma1450048681e_tree(a) ).

%----Relevant facts (100)
tff(fact_0_depth__max__heightE__left,axiom,
    ! [B2: $tType,A: $tType,T_21: huffma1450048681e_tree(B2),A3: A,T_11: huffma1450048681e_tree(A)] :
      ( ( huffma410068972_depth(A,T_11,A3) = ord_max(nat,huffma945805758height(A,T_11),huffma945805758height(B2,T_21)) )
     => ~ ( ( huffma410068972_depth(A,T_11,A3) = huffma945805758height(A,T_11) )
         => ~ ord_less_eq(nat,huffma945805758height(B2,T_21),huffma945805758height(A,T_11)) ) ) ).

tff(fact_1_depth__le__height,axiom,
    ! [A: $tType,A3: A,T: huffma1450048681e_tree(A)] : ord_less_eq(nat,huffma410068972_depth(A,T,A3),huffma945805758height(A,T)) ).

tff(fact_2_min__max_Ole__sup__iff,axiom,
    ! [C: $tType] :
      ( linorder(C)
     => ! [Z: C,Y1: C,X1: C] :
          ( ord_less_eq(C,ord_max(C,X1,Y1),Z)
        <=> ( ord_less_eq(C,X1,Z)
            & ord_less_eq(C,Y1,Z) ) ) ) ).

tff(fact_3_min__max_Osup_Oleft__idem,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [B1: A,A3: A] : ( ord_max(A,A3,ord_max(A,A3,B1)) = ord_max(A,A3,B1) ) ) ).

tff(fact_4_min__max_Osup__left__idem,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] : ( ord_max(A,X,ord_max(A,X,Y)) = ord_max(A,X,Y) ) ) ).

tff(fact_5_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ord_less_eq(A,X,X) ) ).

tff(fact_6_le__maxI1,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] : ord_less_eq(A,X,ord_max(A,X,Y)) ) ).

tff(fact_7_le__maxI2,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X: A,Y: A] : ord_less_eq(A,Y,ord_max(A,X,Y)) ) ).

tff(fact_8_min__max_Ole__iff__sup,axiom,
    ! [C: $tType] :
      ( linorder(C)
     => ! [Y1: C,X1: C] :
          ( ord_less_eq(C,X1,Y1)
        <=> ( ord_max(C,X1,Y1) = Y1 ) ) ) ).

tff(fact_9_le__max__iff__disj,axiom,
    ! [C: $tType] :
      ( linorder(C)
     => ! [Y1: C,X1: C,Z: C] :
          ( ord_less_eq(C,Z,ord_max(C,X1,Y1))
        <=> ( ord_less_eq(C,Z,X1)
            | ord_less_eq(C,Z,Y1) ) ) ) ).

tff(fact_10_min__max_Ole__supI1,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [B1: A,A3: A,X: A] :
          ( ord_less_eq(A,X,A3)
         => ord_less_eq(A,X,ord_max(A,A3,B1)) ) ) ).

tff(fact_11_min__max_Ole__supI2,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [A3: A,B1: A,X: A] :
          ( ord_less_eq(A,X,B1)
         => ord_less_eq(A,X,ord_max(A,A3,B1)) ) ) ).

tff(fact_12_min__max_Osup__absorb2,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_max(A,X,Y) = Y ) ) ) ).

tff(fact_13_min__max_Osup__absorb1,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X: A,Y: A] :
          ( ord_less_eq(A,Y,X)
         => ( ord_max(A,X,Y) = X ) ) ) ).

tff(fact_14_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ ord_less_eq(A,X,Y)
         => ord_less_eq(A,Y,X) ) ) ).

tff(fact_15_le__funE,axiom,
    ! [D: $tType,C: $tType] :
      ( ord(D)
     => ! [X1: C,G: fun(C,D),F: fun(C,D)] :
          ( ord_less_eq(fun(C,D),F,G)
         => ord_less_eq(D,aa(C,D,F,X1),aa(C,D,G,X1)) ) ) ).

tff(fact_16_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z2: A,Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,Z2)
           => ord_less_eq(A,X,Z2) ) ) ) ).

tff(fact_17_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,X)
           => ( X = Y ) ) ) ) ).

tff(fact_18_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B1: A,A3: A] :
          ( ord_less_eq(A,A3,B1)
         => ( ( B1 = C2 )
           => ord_less_eq(A,A3,C2) ) ) ) ).

tff(fact_19_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B1: A,A3: A] :
          ( ( A3 = B1 )
         => ( ord_less_eq(A,B1,C2)
           => ord_less_eq(A,A3,C2) ) ) ) ).

tff(fact_20_order__antisym__conv,axiom,
    ! [C: $tType] :
      ( order(C)
     => ! [X1: C,Y1: C] :
          ( ord_less_eq(C,Y1,X1)
         => ( ord_less_eq(C,X1,Y1)
          <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_21_le__funD,axiom,
    ! [D: $tType,C: $tType] :
      ( ord(D)
     => ! [X1: C,G: fun(C,D),F: fun(C,D)] :
          ( ord_less_eq(fun(C,D),F,G)
         => ord_less_eq(D,aa(C,D,F,X1),aa(C,D,G,X1)) ) ) ).

tff(fact_22_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ( X = Y )
         => ord_less_eq(A,X,Y) ) ) ).

tff(fact_23_order__eq__iff,axiom,
    ! [C: $tType] :
      ( order(C)
     => ! [Y1: C,X1: C] :
          ( ( X1 = Y1 )
        <=> ( ord_less_eq(C,X1,Y1)
            & ord_less_eq(C,Y1,X1) ) ) ) ).

tff(fact_24_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
          | ord_less_eq(A,Y,X) ) ) ).

tff(fact_25_le__fun__def,axiom,
    ! [D: $tType,C: $tType] :
      ( ord(D)
     => ! [G: fun(C,D),F: fun(C,D)] :
          ( ord_less_eq(fun(C,D),F,G)
        <=> ! [X2: C] : ord_less_eq(D,aa(C,D,F,X2),aa(C,D,G,X2)) ) ) ).

tff(fact_26_min__max_Osup__assoc,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Z2: A,Y: A,X: A] : ( ord_max(A,ord_max(A,X,Y),Z2) = ord_max(A,X,ord_max(A,Y,Z2)) ) ) ).

tff(fact_27_min__max_Osup_Oassoc,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [C2: A,B1: A,A3: A] : ( ord_max(A,ord_max(A,A3,B1),C2) = ord_max(A,A3,ord_max(A,B1,C2)) ) ) ).

tff(fact_28_min__max_Osup__left__commute,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Z2: A,Y: A,X: A] : ( ord_max(A,X,ord_max(A,Y,Z2)) = ord_max(A,Y,ord_max(A,X,Z2)) ) ) ).

tff(fact_29_min__max_Osup_Oleft__commute,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [C2: A,A3: A,B1: A] : ( ord_max(A,B1,ord_max(A,A3,C2)) = ord_max(A,A3,ord_max(A,B1,C2)) ) ) ).

tff(fact_30_min__max_Osup__commute,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] : ( ord_max(A,X,Y) = ord_max(A,Y,X) ) ) ).

tff(fact_31_min__max_Osup_Ocommute,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [B1: A,A3: A] : ( ord_max(A,A3,B1) = ord_max(A,B1,A3) ) ) ).

tff(fact_32_min__max_Osup_Oidem,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [A3: A] : ( ord_max(A,A3,A3) = A3 ) ) ).

tff(fact_33_min__max_Ole__supE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X: A,B1: A,A3: A] :
          ( ord_less_eq(A,ord_max(A,A3,B1),X)
         => ~ ( ord_less_eq(A,A3,X)
             => ~ ord_less_eq(A,B1,X) ) ) ) ).

tff(fact_34_min__max_Osup__mono,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [D1: A,B1: A,C2: A,A3: A] :
          ( ord_less_eq(A,A3,C2)
         => ( ord_less_eq(A,B1,D1)
           => ord_less_eq(A,ord_max(A,A3,B1),ord_max(A,C2,D1)) ) ) ) ).

tff(fact_35_min__max_Osup__least,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Z2: A,X: A,Y: A] :
          ( ord_less_eq(A,Y,X)
         => ( ord_less_eq(A,Z2,X)
           => ord_less_eq(A,ord_max(A,Y,Z2),X) ) ) ) ).

tff(fact_36_min__max_Ole__supI,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [B1: A,X: A,A3: A] :
          ( ord_less_eq(A,A3,X)
         => ( ord_less_eq(A,B1,X)
           => ord_less_eq(A,ord_max(A,A3,B1),X) ) ) ) ).

tff(fact_37_max__leastL,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [X: A,Least: A] :
          ( ! [X3: A] : ord_less_eq(A,Least,X3)
         => ( ord_max(A,Least,X) = X ) ) ) ).

tff(fact_38_max__leastR,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [X: A,Least: A] :
          ( ! [X3: A] : ord_less_eq(A,Least,X3)
         => ( ord_max(A,X,Least) = X ) ) ) ).

tff(fact_39_order__subst1,axiom,
    ! [C: $tType,D: $tType] :
      ( ( order(D)
        & order(C) )
     => ! [C1: D,B: D,F: fun(D,C),Aa: C] :
          ( ord_less_eq(C,Aa,aa(D,C,F,B))
         => ( ord_less_eq(D,B,C1)
           => ( ! [X3: D,Y2: D] :
                  ( ord_less_eq(D,X3,Y2)
                 => ord_less_eq(C,aa(D,C,F,X3),aa(D,C,F,Y2)) )
             => ord_less_eq(C,Aa,aa(D,C,F,C1)) ) ) ) ) ).

tff(fact_40_ord__eq__le__subst,axiom,
    ! [C: $tType,D: $tType] :
      ( ( ord(D)
        & ord(C) )
     => ! [C1: D,B: D,F: fun(D,C),Aa: C] :
          ( ( Aa = aa(D,C,F,B) )
         => ( ord_less_eq(D,B,C1)
           => ( ! [X3: D,Y2: D] :
                  ( ord_less_eq(D,X3,Y2)
                 => ord_less_eq(C,aa(D,C,F,X3),aa(D,C,F,Y2)) )
             => ord_less_eq(C,Aa,aa(D,C,F,C1)) ) ) ) ) ).

tff(fact_41_order__subst2,axiom,
    ! [C: $tType,D: $tType] :
      ( ( order(D)
        & order(C) )
     => ! [C1: D,F: fun(C,D),B: C,Aa: C] :
          ( ord_less_eq(C,Aa,B)
         => ( ord_less_eq(D,aa(C,D,F,B),C1)
           => ( ! [X3: C,Y2: C] :
                  ( ord_less_eq(C,X3,Y2)
                 => ord_less_eq(D,aa(C,D,F,X3),aa(C,D,F,Y2)) )
             => ord_less_eq(D,aa(C,D,F,Aa),C1) ) ) ) ) ).

tff(fact_42_ord__le__eq__subst,axiom,
    ! [C: $tType,D: $tType] :
      ( ( ord(D)
        & ord(C) )
     => ! [C1: D,F: fun(C,D),B: C,Aa: C] :
          ( ord_less_eq(C,Aa,B)
         => ( ( aa(C,D,F,B) = C1 )
           => ( ! [X3: C,Y2: C] :
                  ( ord_less_eq(C,X3,Y2)
                 => ord_less_eq(D,aa(C,D,F,X3),aa(C,D,F,Y2)) )
             => ord_less_eq(D,aa(C,D,F,Aa),C1) ) ) ) ) ).

tff(fact_43_le__funI,axiom,
    ! [D: $tType,C: $tType] :
      ( ord(D)
     => ! [G: fun(C,D),F: fun(C,D)] :
          ( ! [X3: C] : ord_less_eq(D,aa(C,D,F,X3),aa(C,D,G,X3))
         => ord_less_eq(fun(C,D),F,G) ) ) ).

tff(fact_44_Max_Oidem,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X: A] : ( ord_max(A,X,X) = X ) ) ).

tff(fact_45_le__antisym,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
     => ( ord_less_eq(nat,N,M)
       => ( M = N ) ) ) ).

tff(fact_46_le__refl,axiom,
    ! [N: nat] : ord_less_eq(nat,N,N) ).

tff(fact_47_nat__le__linear,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
      | ord_less_eq(nat,N,M) ) ).

tff(fact_48_eq__imp__le,axiom,
    ! [N: nat,M: nat] :
      ( ( M = N )
     => ord_less_eq(nat,M,N) ) ).

tff(fact_49_le__trans,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less_eq(nat,I,J)
     => ( ord_less_eq(nat,J,K)
       => ord_less_eq(nat,I,K) ) ) ).

tff(fact_50_min__max_Osup__unique,axiom,
    ! [C: $tType] :
      ( linorder(C)
     => ! [Y1: C,X1: C,F: fun(C,fun(C,C))] :
          ( ! [X3: C,Y2: C] : ord_less_eq(C,X3,aa(C,C,aa(C,fun(C,C),F,X3),Y2))
         => ( ! [X3: C,Y2: C] : ord_less_eq(C,Y2,aa(C,C,aa(C,fun(C,C),F,X3),Y2))
           => ( ! [X3: C,Y2: C,Z3: C] :
                  ( ord_less_eq(C,Y2,X3)
                 => ( ord_less_eq(C,Z3,X3)
                   => ord_less_eq(C,aa(C,C,aa(C,fun(C,C),F,Y2),Z3),X3) ) )
             => ( ord_max(C,X1,Y1) = aa(C,C,aa(C,fun(C,C),F,X1),Y1) ) ) ) ) ) ).

tff(fact_51_of__nat__le__iff,axiom,
    ! [C: $tType] :
      ( linordered_semidom(C)
     => ! [N1: nat,M1: nat] :
          ( ord_less_eq(C,semiring_1_of_nat(C,M1),semiring_1_of_nat(C,N1))
        <=> ord_less_eq(nat,M1,N1) ) ) ).

tff(fact_52_strict__mono__less__eq,axiom,
    ! [D: $tType,C: $tType] :
      ( ( linorder(C)
        & order(D) )
     => ! [Y1: C,X1: C,F: fun(C,D)] :
          ( order_strict_mono(C,D,F)
         => ( ord_less_eq(D,aa(C,D,F,X1),aa(C,D,F,Y1))
          <=> ord_less_eq(C,X1,Y1) ) ) ) ).

tff(fact_53_height_092_060_094isub_062F_Osimps_I2_J,axiom,
    ! [A: $tType,Ts: list(huffma1450048681e_tree(A)),T: huffma1450048681e_tree(A)] : ( huffma632063779ight_F(A,cons(huffma1450048681e_tree(A),T,Ts)) = ord_max(nat,huffma945805758height(A,T),huffma632063779ight_F(A,Ts)) ) ).

tff(fact_54_of__nat__eq__iff,axiom,
    ! [C: $tType] :
      ( semiring_char_0(C)
     => ! [N1: nat,M1: nat] :
          ( ( semiring_1_of_nat(C,M1) = semiring_1_of_nat(C,N1) )
        <=> ( M1 = N1 ) ) ) ).

tff(fact_55_strict__mono__eq,axiom,
    ! [D: $tType,C: $tType] :
      ( ( linorder(C)
        & order(D) )
     => ! [Y1: C,X1: C,F: fun(C,D)] :
          ( order_strict_mono(C,D,F)
         => ( ( aa(C,D,F,X1) = aa(C,D,F,Y1) )
          <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_56_list_Oinject,axiom,
    ! [C: $tType,List1: list(C),A2: C,List: list(C),Aa: C] :
      ( ( cons(C,Aa,List) = cons(C,A2,List1) )
    <=> ( ( Aa = A2 )
        & ( List = List1 ) ) ) ).

tff(fact_57_zle__int,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less_eq(int,semiring_1_of_nat(int,M1),semiring_1_of_nat(int,N1))
    <=> ord_less_eq(nat,M1,N1) ) ).

tff(fact_58_transfer__int__nat__relations_I3_J,axiom,
    ! [Y1: nat,X1: nat] :
      ( ord_less_eq(int,semiring_1_of_nat(int,X1),semiring_1_of_nat(int,Y1))
    <=> ord_less_eq(nat,X1,Y1) ) ).

tff(fact_59_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] : ( Xs1 != cons(A,X,Xs1) ) ).

tff(fact_60_int__int__eq,axiom,
    ! [N1: nat,M1: nat] :
      ( ( semiring_1_of_nat(int,M1) = semiring_1_of_nat(int,N1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_61_transfer__int__nat__relations_I1_J,axiom,
    ! [Y1: nat,X1: nat] :
      ( ( semiring_1_of_nat(int,X1) = semiring_1_of_nat(int,Y1) )
    <=> ( X1 = Y1 ) ) ).

tff(fact_62_int__if__cong,axiom,
    ! [Y1: nat,X1: nat,Pa: bool] :
      ( ( pp(Pa)
       => ( semiring_1_of_nat(int,X1) = semiring_1_of_nat(int,if(nat,Pa,X1,Y1)) ) )
      & ( ~ pp(Pa)
       => ( semiring_1_of_nat(int,Y1) = semiring_1_of_nat(int,if(nat,Pa,X1,Y1)) ) ) ) ).

tff(fact_63_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ( cons(A,X,Xs1) != Xs1 ) ).

tff(fact_64_list_Osimps_I5_J,axiom,
    ! [C: $tType,D: $tType,List: list(D),Aa: D,F2: fun(D,fun(list(D),C)),F1: C] : ( list_case(C,D,F1,F2,cons(D,Aa,List)) = aa(list(D),C,aa(D,fun(list(D),C),F2,Aa),List) ) ).

tff(fact_65_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys1: list(A),Y: A,Xs1: list(A),X: A] : ( splice(A,cons(A,X,Xs1),cons(A,Y,Ys1)) = cons(A,X,cons(A,Y,splice(A,Xs1,Ys1))) ) ).

tff(fact_66_list_Orecs_I2_J,axiom,
    ! [C: $tType,D: $tType,List: list(D),Aa: D,F2: fun(D,fun(list(D),fun(C,C))),F1: C] : ( list_rec(C,D,F1,F2,cons(D,Aa,List)) = aa(C,C,aa(list(D),fun(C,C),aa(D,fun(list(D),fun(C,C)),F2,Aa),List),list_rec(C,D,F1,F2,List)) ) ).

tff(fact_67_transfer__morphismI,axiom,
    ! [D: $tType,C: $tType,A1: fun(C,bool),F: fun(C,D)] : nat_tr1645093318rphism(C,D,F,A1) ).

tff(fact_68_null__rec_I1_J,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ~ null(A,cons(A,X,Xs1)) ).

tff(fact_69_insort__key_Osimps_I2_J,axiom,
    ! [C: $tType,D: $tType] :
      ( linorder(C)
     => ! [Ys: list(D),Y1: D,X1: D,F: fun(D,C)] :
          ( ( ord_less_eq(C,aa(D,C,F,X1),aa(D,C,F,Y1))
           => ( linorder_insort_key(D,C,F,X1,cons(D,Y1,Ys)) = cons(D,X1,cons(D,Y1,Ys)) ) )
          & ( ~ ord_less_eq(C,aa(D,C,F,X1),aa(D,C,F,Y1))
           => ( linorder_insort_key(D,C,F,X1,cons(D,Y1,Ys)) = cons(D,Y1,linorder_insort_key(D,C,F,X1,Ys)) ) ) ) ) ).

tff(fact_70_transfer__morphism__def,axiom,
    ! [D: $tType,C: $tType,A1: fun(C,bool),F: fun(C,D)] : nat_tr1645093318rphism(C,D,F,A1) ).

tff(fact_71_insort__key__left__comm,axiom,
    ! [C: $tType,D: $tType] :
      ( linorder(C)
     => ! [Xs: list(D),Y1: D,X1: D,F: fun(D,C)] :
          ( ( aa(D,C,F,X1) != aa(D,C,F,Y1) )
         => ( linorder_insort_key(D,C,F,Y1,linorder_insort_key(D,C,F,X1,Xs)) = linorder_insort_key(D,C,F,X1,linorder_insort_key(D,C,F,Y1,Xs)) ) ) ) ).

tff(fact_72_sort__key__simps_I2_J,axiom,
    ! [D: $tType,C: $tType] :
      ( linorder(D)
     => ! [Xs: list(C),X1: C,F: fun(C,D)] : ( linorder_sort_key(C,D,F,cons(C,X1,Xs)) = linorder_insort_key(C,D,F,X1,linorder_sort_key(C,D,F,Xs)) ) ) ).

tff(fact_73_nat__le__iff,axiom,
    ! [N1: nat,X1: int] :
      ( ord_less_eq(nat,nat1(X1),N1)
    <=> ord_less_eq(int,X1,semiring_1_of_nat(int,N1)) ) ).

tff(fact_74_of__int__of__nat__eq,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ! [N: nat] : ( ring_1_of_int(A,semiring_1_of_nat(int,N)) = semiring_1_of_nat(A,N) ) ) ).

tff(fact_75_of__int__eq__iff,axiom,
    ! [C: $tType] :
      ( ring_char_0(C)
     => ! [Z: int,W: int] :
          ( ( ring_1_of_int(C,W) = ring_1_of_int(C,Z) )
        <=> ( W = Z ) ) ) ).

tff(fact_76_of__int__le__iff,axiom,
    ! [C: $tType] :
      ( linordered_idom(C)
     => ! [Z: int,W: int] :
          ( ord_less_eq(C,ring_1_of_int(C,W),ring_1_of_int(C,Z))
        <=> ord_less_eq(int,W,Z) ) ) ).

tff(fact_77_nat__mono,axiom,
    ! [Y: int,X: int] :
      ( ord_less_eq(int,X,Y)
     => ord_less_eq(nat,nat1(X),nat1(Y)) ) ).

tff(fact_78_nat__int,axiom,
    ! [N: nat] : ( nat1(semiring_1_of_nat(int,N)) = N ) ).

tff(fact_79_of__int__int__eq,axiom,
    ! [N: nat] : ( ring_1_of_int(int,semiring_1_of_nat(int,N)) = semiring_1_of_nat(int,N) ) ).

tff(fact_80_nat__if__cong,axiom,
    ! [Y1: int,X1: int,Pa: bool] :
      ( ( pp(Pa)
       => ( nat1(X1) = nat1(if(int,Pa,X1,Y1)) ) )
      & ( ~ pp(Pa)
       => ( nat1(Y1) = nat1(if(int,Pa,X1,Y1)) ) ) ) ).

tff(fact_81_of__nat__nat,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ! [Z2: int] :
          ( ord_less_eq(int,zero_zero(int),Z2)
         => ( semiring_1_of_nat(A,nat1(Z2)) = ring_1_of_int(A,Z2) ) ) ) ).

tff(fact_82_int__nat__eq,axiom,
    ! [Z2: int] :
      ( ( ord_less_eq(int,zero_zero(int),Z2)
       => ( semiring_1_of_nat(int,nat1(Z2)) = Z2 ) )
      & ( ~ ord_less_eq(int,zero_zero(int),Z2)
       => ( semiring_1_of_nat(int,nat1(Z2)) = zero_zero(int) ) ) ) ).

tff(fact_83_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_84_of__int__eq__0__iff,axiom,
    ! [C: $tType] :
      ( ring_char_0(C)
     => ! [Z: int] :
          ( ( ring_1_of_int(C,Z) = zero_zero(C) )
        <=> ( Z = zero_zero(int) ) ) ) ).

tff(fact_85_of__int__0__eq__iff,axiom,
    ! [C: $tType] :
      ( ring_char_0(C)
     => ! [Z: int] :
          ( ( zero_zero(C) = ring_1_of_int(C,Z) )
        <=> ( Z = zero_zero(int) ) ) ) ).

tff(fact_86_of__int__0,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,zero_zero(int)) = zero_zero(A) ) ) ).

tff(fact_87_of__int__le__0__iff,axiom,
    ! [C: $tType] :
      ( linordered_idom(C)
     => ! [Z: int] :
          ( ord_less_eq(C,ring_1_of_int(C,Z),zero_zero(C))
        <=> ord_less_eq(int,Z,zero_zero(int)) ) ) ).

tff(fact_88_of__int__0__le__iff,axiom,
    ! [C: $tType] :
      ( linordered_idom(C)
     => ! [Z: int] :
          ( ord_less_eq(C,zero_zero(C),ring_1_of_int(C,Z))
        <=> ord_less_eq(int,zero_zero(int),Z) ) ) ).

tff(fact_89_zero__le__imp__of__nat,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [M: nat] : ord_less_eq(A,zero_zero(A),semiring_1_of_nat(A,M)) ) ).

tff(fact_90_of__nat__0__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat] : ord_less_eq(A,zero_zero(A),semiring_1_of_nat(A,N)) ) ).

tff(fact_91_Nat__Transfer_Otransfer__nat__int__function__closures_I5_J,axiom,
    ord_less_eq(int,zero_zero(int),zero_zero(int)) ).

tff(fact_92_zero__zle__int,axiom,
    ! [N: nat] : ord_less_eq(int,zero_zero(int),semiring_1_of_nat(int,N)) ).

tff(fact_93_Nat__Transfer_Otransfer__nat__int__function__closures_I9_J,axiom,
    ! [Z2: nat] : ord_less_eq(int,zero_zero(int),semiring_1_of_nat(int,Z2)) ).

tff(fact_94_transfer__int__nat__quantifiers_I2_J,axiom,
    ! [Pa: fun(int,bool)] :
      ( ? [X2: int] :
          ( ord_less_eq(int,zero_zero(int),X2)
          & pp(aa(int,bool,Pa,X2)) )
    <=> ? [X2: nat] : pp(aa(int,bool,Pa,semiring_1_of_nat(int,X2))) ) ).

tff(fact_95_transfer__int__nat__quantifiers_I1_J,axiom,
    ! [Pa: fun(int,bool)] :
      ( ! [X2: int] :
          ( ord_less_eq(int,zero_zero(int),X2)
         => pp(aa(int,bool,Pa,X2)) )
    <=> ! [X2: nat] : pp(aa(int,bool,Pa,semiring_1_of_nat(int,X2))) ) ).

tff(fact_96_ex__nat,axiom,
    ! [Pa: fun(nat,bool)] :
      ( ? [X11: nat] : pp(aa(nat,bool,Pa,X11))
    <=> ? [X2: int] :
          ( ord_less_eq(int,zero_zero(int),X2)
          & pp(aa(nat,bool,Pa,nat1(X2))) ) ) ).

tff(fact_97_all__nat,axiom,
    ! [Pa: fun(nat,bool)] :
      ( ! [X11: nat] : pp(aa(nat,bool,Pa,X11))
    <=> ! [X2: int] :
          ( ord_less_eq(int,zero_zero(int),X2)
         => pp(aa(nat,bool,Pa,nat1(X2))) ) ) ).

tff(fact_98_transfer__nat__int__relations_I1_J,axiom,
    ! [Y1: int,X1: int] :
      ( ord_less_eq(int,zero_zero(int),X1)
     => ( ord_less_eq(int,zero_zero(int),Y1)
       => ( ( nat1(X1) = nat1(Y1) )
        <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_99_eq__nat__nat__iff,axiom,
    ! [Z1: int,Z: int] :
      ( ord_less_eq(int,zero_zero(int),Z)
     => ( ord_less_eq(int,zero_zero(int),Z1)
       => ( ( nat1(Z) = nat1(Z1) )
        <=> ( Z = Z1 ) ) ) ) ).

%----Arities (24)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0(int) ).

tff(arity_Int_Oint___Orderings_Opreorder,axiom,
    preorder(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Orderings_Oorder,axiom,
    order(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Orderings_Oord,axiom,
    ord(int) ).

tff(arity_Int_Oint___Rings_Oring__1,axiom,
    ring_1(int) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (5)
tff(help_If_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fTrue,X,Y) = X ) ).

tff(help_If_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fFalse,X,Y) = Y ) ).

tff(help_If_3_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    huffma410068972_depth(a,t_2,a1) = ord_max(nat,huffma945805758height(b,t_1),huffma945805758height(a,t_2)) ).

tff(conj_1,hypothesis,
    ( ( huffma410068972_depth(a,t_2,a1) = huffma945805758height(a,t_2) )
   => ( ord_less_eq(nat,huffma945805758height(b,t_1),huffma945805758height(a,t_2))
     => p ) ) ).

tff(conj_2,conjecture,
    p ).

%------------------------------------------------------------------------------
