%------------------------------------------------------------------------------
% File     : SWW529_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Huffman's Algorithm line 545
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla09] Blanchette (2009), Proof Pearl: Mechanizing the Textbo
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : huff_545 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  217 (  84 unt;  55 typ;   0 def)
%            Number of atoms       :  299 (  89 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  161 (  24   ~;  11   |;  26   &)
%                                         (  31 <=>;  69  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   4 avg)
%            Maximal term depth    :    7 (   2 avg)
%            Number of types       :    7 (   6 usr)
%            Number of type conns  :   43 (  25   >;  18   *;   0   +;   0  <<)
%            Number of predicates  :   19 (  18 usr;   1 prp; 0-3 aty)
%            Number of functors    :   31 (  31 usr;   7 con; 0-5 aty)
%            Number of variables   :  431 ( 378   !;   7   ?; 431   :)
%                                         (  46  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:38
%------------------------------------------------------------------------------
%----Should-be-implicit typings (9)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_Code__Evaluation_Oterm,type,
    code_term: $tType ).

tff(ty_tc_Code__Numeral_Ocode__numeral,type,
    code_code_numeral: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Huffman__Mirabelle__lalbadcutu_Otree,type,
    huffma1450048681e_tree: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Product__Type_Ounit,type,
    product_unit: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (46)
tff(sy_cl_Enum_Oenum,type,
    enum: 
      !>[A: $tType] : $o ).

tff(sy_cl_Typerep_Otyperep,type,
    typerep: 
      !>[A: $tType] : $o ).

tff(sy_cl_HOL_Oequal,type,
    cl_HOL_Oequal: 
      !>[A: $tType] : $o ).

tff(sy_cl_Code__Evaluation_Oterm__of,type,
    code_term_of: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Quickcheck_Orandom,type,
    random: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B1: $tType,C: $tType,A: $tType] : ( ( fun(B1,C) * fun(A,B1) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B1: $tType,C: $tType] : ( ( fun(A,fun(B1,C)) * B1 ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B1: $tType] : ( A > fun(B1,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B1: $tType,C: $tType] : ( ( fun(A,fun(B1,C)) * fun(A,B1) ) > fun(A,C) ) ).

tff(sy_c_Finite__Set_Ofinite,type,
    finite_finite: 
      !>[A: $tType] : ( fun(A,bool) > $o ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_HOL_Oequal__class_Oequal,type,
    equal_equal: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oalphabet,type,
    huffma675207370phabet: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > fun(A,bool) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oconsistent,type,
    huffma1518433673istent: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Odepth,type,
    huffma410068972_depth: 
      !>[A: $tType] : ( ( huffma1450048681e_tree(A) * A ) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oheight,type,
    huffma945805758height: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > nat ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Orandom__aux__tree,type,
    huffma928900296x_tree: 
      !>[A: $tType] : ( ( code_code_numeral * code_code_numeral ) > fun(product_prod(code_code_numeral,code_code_numeral),product_prod(product_prod(huffma1450048681e_tree(A),fun(product_unit,code_term)),product_prod(code_code_numeral,code_code_numeral))) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OInnerNode,type,
    huffma1146269203erNode: 
      !>[A: $tType] : ( ( nat * huffma1450048681e_tree(A) * huffma1450048681e_tree(A) ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OLeaf,type,
    huffma2021818691e_Leaf: 
      !>[A: $tType] : ( ( nat * A ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_Otree__case,type,
    huffma107959123e_case: 
      !>[A: $tType,T1: $tType] : ( ( fun(nat,fun(A,T1)) * fun(nat,fun(huffma1450048681e_tree(A),fun(huffma1450048681e_tree(A),T1))) * huffma1450048681e_tree(A) ) > T1 ) ).

tff(sy_c_Lattices_Oinf__class_Oinf,type,
    inf_inf: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Lattices_Osup__class_Osup,type,
    sup_sup: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Quickcheck_Orandom__class_Orandom,type,
    random_random: 
      !>[A: $tType] : ( code_code_numeral > fun(product_prod(code_code_numeral,code_code_numeral),product_prod(product_prod(A,fun(product_unit,code_term)),product_prod(code_code_numeral,code_code_numeral))) ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,B1) * A ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_t_092_060_094isub_0621____,type,
    t_1: huffma1450048681e_tree(a) ).

tff(sy_v_t_092_060_094isub_0622____,type,
    t_2: huffma1450048681e_tree(a) ).

tff(sy_v_thesis____,type,
    thesis: $o ).

tff(sy_v_w____,type,
    w: nat ).

%----Relevant facts (98)
tff(fact_0_InnerNode_Oprems,axiom,
    huffma1518433673istent(a,huffma1146269203erNode(a,w,t_1,t_2)) ).

tff(fact_1_InnerNode_I2_J,axiom,
    ( huffma1518433673istent(a,t_2)
   => ? [X3: a] :
        ( pp(aa(fun(a,bool),bool,aa(a,fun(fun(a,bool),bool),member(a),X3),huffma675207370phabet(a,t_2)))
        & ( huffma410068972_depth(a,t_2,X3) = huffma945805758height(a,t_2) ) ) ) ).

tff(fact_2_InnerNode_I1_J,axiom,
    ( huffma1518433673istent(a,t_1)
   => ? [X3: a] :
        ( pp(aa(fun(a,bool),bool,aa(a,fun(fun(a,bool),bool),member(a),X3),huffma675207370phabet(a,t_1)))
        & ( huffma410068972_depth(a,t_1,X3) = huffma945805758height(a,t_1) ) ) ) ).

tff(fact_3_tree_Osimps_I2_J,axiom,
    ! [B1: $tType,Tree22: huffma1450048681e_tree(B1),Tree12: huffma1450048681e_tree(B1),Nat3: nat,Tree21: huffma1450048681e_tree(B1),Tree11: huffma1450048681e_tree(B1),Nat: nat] :
      ( ( huffma1146269203erNode(B1,Nat,Tree11,Tree21) = huffma1146269203erNode(B1,Nat3,Tree12,Tree22) )
    <=> ( ( Nat = Nat3 )
        & ( Tree11 = Tree12 )
        & ( Tree21 = Tree22 ) ) ) ).

tff(fact_4_exists__in__alphabet,axiom,
    ! [B1: $tType,Ta: huffma1450048681e_tree(B1)] :
    ? [A5: B1] : pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),A5),huffma675207370phabet(B1,Ta))) ).

tff(fact_5_depth__le__height,axiom,
    ! [A: $tType,A3: A,T: huffma1450048681e_tree(A)] : ord_less_eq(nat,huffma410068972_depth(A,T,A3),huffma945805758height(A,T)) ).

tff(fact_6_finite__alphabet,axiom,
    ! [B1: $tType,Ta: huffma1450048681e_tree(B1)] : finite_finite(B1,huffma675207370phabet(B1,Ta)) ).

tff(fact_7_alphabet_Osimps_I2_J,axiom,
    ! [B1: $tType,T_21: huffma1450048681e_tree(B1),T_11: huffma1450048681e_tree(B1),Wa: nat] : ( huffma675207370phabet(B1,huffma1146269203erNode(B1,Wa,T_11,T_21)) = sup_sup(fun(B1,bool),huffma675207370phabet(B1,T_11),huffma675207370phabet(B1,T_21)) ) ).

tff(fact_8_depth_Osimps_I1_J,axiom,
    ! [A: $tType,A3: A,B3: A,W: nat] : ( huffma410068972_depth(A,huffma2021818691e_Leaf(A,W,B3),A3) = zero_zero(nat) ) ).

tff(fact_9_height_Osimps_I1_J,axiom,
    ! [A: $tType,A3: A,W: nat] : ( huffma945805758height(A,huffma2021818691e_Leaf(A,W,A3)) = zero_zero(nat) ) ).

tff(fact_10_depth_Osimps_I2_J,axiom,
    ! [B1: $tType,T_21: huffma1450048681e_tree(B1),Wa: nat,T_11: huffma1450048681e_tree(B1),A2: B1] :
      ( ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),A2),huffma675207370phabet(B1,T_11)))
       => ( huffma410068972_depth(B1,huffma1146269203erNode(B1,Wa,T_11,T_21),A2) = plus_plus(nat,huffma410068972_depth(B1,T_11,A2),one_one(nat)) ) )
      & ( ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),A2),huffma675207370phabet(B1,T_11)))
       => ( ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),A2),huffma675207370phabet(B1,T_21)))
           => ( huffma410068972_depth(B1,huffma1146269203erNode(B1,Wa,T_11,T_21),A2) = plus_plus(nat,huffma410068972_depth(B1,T_21,A2),one_one(nat)) ) )
          & ( ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),A2),huffma675207370phabet(B1,T_21)))
           => ( huffma410068972_depth(B1,huffma1146269203erNode(B1,Wa,T_11,T_21),A2) = zero_zero(nat) ) ) ) ) ) ).

tff(fact_11_random__tree__def,axiom,
    ! [B1: $tType] :
      ( random(B1)
     => ! [I1: code_code_numeral] : ( random_random(huffma1450048681e_tree(B1),I1) = huffma928900296x_tree(B1,I1,I1) ) ) ).

tff(fact_12_tree_Osimps_I6_J,axiom,
    ! [B1: $tType,C: $tType,Tree21: huffma1450048681e_tree(C),Tree11: huffma1450048681e_tree(C),Nat: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B1))),F1: fun(nat,fun(C,B1))] : ( huffma107959123e_case(C,B1,F1,F2,huffma1146269203erNode(C,Nat,Tree11,Tree21)) = aa(huffma1450048681e_tree(C),B1,aa(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B1),aa(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B1)),F2,Nat),Tree11),Tree21) ) ).

tff(fact_13_consistent_Osimps_I2_J,axiom,
    ! [B1: $tType,T_21: huffma1450048681e_tree(B1),T_11: huffma1450048681e_tree(B1),Wa: nat] :
      ( huffma1518433673istent(B1,huffma1146269203erNode(B1,Wa,T_11,T_21))
    <=> ( huffma1518433673istent(B1,T_11)
        & huffma1518433673istent(B1,T_21)
        & ( inf_inf(fun(B1,bool),huffma675207370phabet(B1,T_11),huffma675207370phabet(B1,T_21)) = bot_bot(fun(B1,bool)) ) ) ) ).

tff(fact_14_equal__tree__def,axiom,
    ! [B1: $tType,Y1: huffma1450048681e_tree(B1),X2: huffma1450048681e_tree(B1)] :
      ( equal_equal(huffma1450048681e_tree(B1),X2,Y1)
    <=> ( X2 = Y1 ) ) ).

tff(fact_15_tree_Osimps_I1_J,axiom,
    ! [B1: $tType,A4: B1,Nat3: nat,A2: B1,Nat: nat] :
      ( ( huffma2021818691e_Leaf(B1,Nat,A2) = huffma2021818691e_Leaf(B1,Nat3,A4) )
    <=> ( ( Nat = Nat3 )
        & ( A2 = A4 ) ) ) ).

tff(fact_16_consistent_Osimps_I1_J,axiom,
    ! [A: $tType,A3: A,W: nat] : huffma1518433673istent(A,huffma2021818691e_Leaf(A,W,A3)) ).

tff(fact_17_tree_Osimps_I3_J,axiom,
    ! [A: $tType,Tree2: huffma1450048681e_tree(A),Tree1: huffma1450048681e_tree(A),Nat1: nat,A3: A,Nat2: nat] : ( huffma2021818691e_Leaf(A,Nat2,A3) != huffma1146269203erNode(A,Nat1,Tree1,Tree2) ) ).

tff(fact_18_tree_Osimps_I4_J,axiom,
    ! [A: $tType,A3: A,Nat2: nat,Tree2: huffma1450048681e_tree(A),Tree1: huffma1450048681e_tree(A),Nat1: nat] : ( huffma1146269203erNode(A,Nat1,Tree1,Tree2) != huffma2021818691e_Leaf(A,Nat2,A3) ) ).

tff(fact_19_tree_Osimps_I5_J,axiom,
    ! [B1: $tType,C: $tType,A2: C,Nat: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B1))),F1: fun(nat,fun(C,B1))] : ( huffma107959123e_case(C,B1,F1,F2,huffma2021818691e_Leaf(C,Nat,A2)) = aa(C,B1,aa(nat,fun(C,B1),F1,Nat),A2) ) ).

tff(fact_20_zero__le__double__add__iff__zero__le__single__add,axiom,
    ! [B1: $tType] :
      ( linord219039673up_add(B1)
     => ! [A2: B1] :
          ( ord_less_eq(B1,zero_zero(B1),plus_plus(B1,A2,A2))
        <=> ord_less_eq(B1,zero_zero(B1),A2) ) ) ).

tff(fact_21_double__add__le__zero__iff__single__add__le__zero,axiom,
    ! [B1: $tType] :
      ( linord219039673up_add(B1)
     => ! [A2: B1] :
          ( ord_less_eq(B1,plus_plus(B1,A2,A2),zero_zero(B1))
        <=> ord_less_eq(B1,A2,zero_zero(B1)) ) ) ).

tff(fact_22_nat__add__left__cancel__le,axiom,
    ! [N1: nat,M1: nat,K1: nat] :
      ( ord_less_eq(nat,plus_plus(nat,K1,M1),plus_plus(nat,K1,N1))
    <=> ord_less_eq(nat,M1,N1) ) ).

tff(fact_23_Int__Un__distrib,axiom,
    ! [B1: $tType,C1: fun(B1,bool),B2: fun(B1,bool),A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A1,sup_sup(fun(B1,bool),B2,C1)) = sup_sup(fun(B1,bool),inf_inf(fun(B1,bool),A1,B2),inf_inf(fun(B1,bool),A1,C1)) ) ).

tff(fact_24_Int__Un__distrib2,axiom,
    ! [B1: $tType,A1: fun(B1,bool),C1: fun(B1,bool),B2: fun(B1,bool)] : ( inf_inf(fun(B1,bool),sup_sup(fun(B1,bool),B2,C1),A1) = sup_sup(fun(B1,bool),inf_inf(fun(B1,bool),B2,A1),inf_inf(fun(B1,bool),C1,A1)) ) ).

tff(fact_25_le0,axiom,
    ! [N: nat] : ord_less_eq(nat,zero_zero(nat),N) ).

tff(fact_26_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : ord_less_eq(nat,zero_zero(nat),N) ).

tff(fact_27_le__0__eq,axiom,
    ! [N1: nat] :
      ( ord_less_eq(nat,N1,zero_zero(nat))
    <=> ( N1 = zero_zero(nat) ) ) ).

tff(fact_28_add__right__cancel,axiom,
    ! [B1: $tType] :
      ( cancel_semigroup_add(B1)
     => ! [C2: B1,A2: B1,B4: B1] :
          ( ( plus_plus(B1,B4,A2) = plus_plus(B1,C2,A2) )
        <=> ( B4 = C2 ) ) ) ).

tff(fact_29_add__left__cancel,axiom,
    ! [B1: $tType] :
      ( cancel_semigroup_add(B1)
     => ! [C2: B1,B4: B1,A2: B1] :
          ( ( plus_plus(B1,A2,B4) = plus_plus(B1,A2,C2) )
        <=> ( B4 = C2 ) ) ) ).

tff(fact_30_subset__empty,axiom,
    ! [B1: $tType,A1: fun(B1,bool)] :
      ( ord_less_eq(fun(B1,bool),A1,bot_bot(fun(B1,bool)))
    <=> ( A1 = bot_bot(fun(B1,bool)) ) ) ).

tff(fact_31_empty__subsetI,axiom,
    ! [B1: $tType,A1: fun(B1,bool)] : ord_less_eq(fun(B1,bool),bot_bot(fun(B1,bool)),A1) ).

tff(fact_32_emptyE,axiom,
    ! [B1: $tType,A2: B1] : ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),A2),bot_bot(fun(B1,bool)))) ).

tff(fact_33_Collect__empty__eq,axiom,
    ! [B1: $tType,P1: fun(B1,bool)] :
      ( ( collect(B1,P1) = bot_bot(fun(B1,bool)) )
    <=> ! [X: B1] : ~ pp(aa(B1,bool,P1,X)) ) ).

tff(fact_34_empty__iff,axiom,
    ! [B1: $tType,C2: B1] : ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),bot_bot(fun(B1,bool)))) ).

tff(fact_35_empty__Collect__eq,axiom,
    ! [B1: $tType,P1: fun(B1,bool)] :
      ( ( bot_bot(fun(B1,bool)) = collect(B1,P1) )
    <=> ! [X: B1] : ~ pp(aa(B1,bool,P1,X)) ) ).

tff(fact_36_all__not__in__conv,axiom,
    ! [B1: $tType,A1: fun(B1,bool)] :
      ( ! [X: B1] : ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),X),A1))
    <=> ( A1 = bot_bot(fun(B1,bool)) ) ) ).

tff(fact_37_nat__add__right__cancel,axiom,
    ! [N1: nat,K1: nat,M1: nat] :
      ( ( plus_plus(nat,M1,K1) = plus_plus(nat,N1,K1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_38_nat__add__left__cancel,axiom,
    ! [N1: nat,M1: nat,K1: nat] :
      ( ( plus_plus(nat,K1,M1) = plus_plus(nat,K1,N1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_39_IntE,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool),C2: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),inf_inf(fun(B1,bool),A1,B2)))
     => ~ ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),A1))
         => ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),B2)) ) ) ).

tff(fact_40_IntI,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool),C2: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),A1))
     => ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),B2))
       => pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),inf_inf(fun(B1,bool),A1,B2))) ) ) ).

tff(fact_41_Int__iff,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool),C2: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),inf_inf(fun(B1,bool),A1,B2)))
    <=> ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),A1))
        & pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),B2)) ) ) ).

tff(fact_42_UnCI,axiom,
    ! [B1: $tType,A1: fun(B1,bool),B2: fun(B1,bool),C2: B1] :
      ( ( ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),B2))
       => pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),A1)) )
     => pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),sup_sup(fun(B1,bool),A1,B2))) ) ).

tff(fact_43_UnE,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool),C2: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),sup_sup(fun(B1,bool),A1,B2)))
     => ( ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),A1))
       => pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),B2)) ) ) ).

tff(fact_44_Un__iff,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool),C2: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),sup_sup(fun(B1,bool),A1,B2)))
    <=> ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),A1))
        | pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),B2)) ) ) ).

tff(fact_45_add__le__cancel__left,axiom,
    ! [B1: $tType] :
      ( ordere236663937imp_le(B1)
     => ! [B4: B1,A2: B1,C2: B1] :
          ( ord_less_eq(B1,plus_plus(B1,C2,A2),plus_plus(B1,C2,B4))
        <=> ord_less_eq(B1,A2,B4) ) ) ).

tff(fact_46_add__le__cancel__right,axiom,
    ! [B1: $tType] :
      ( ordere236663937imp_le(B1)
     => ! [B4: B1,C2: B1,A2: B1] :
          ( ord_less_eq(B1,plus_plus(B1,A2,C2),plus_plus(B1,B4,C2))
        <=> ord_less_eq(B1,A2,B4) ) ) ).

tff(fact_47_double__zero__sym,axiom,
    ! [B1: $tType] :
      ( linord219039673up_add(B1)
     => ! [A2: B1] :
          ( ( zero_zero(B1) = plus_plus(B1,A2,A2) )
        <=> ( A2 = zero_zero(B1) ) ) ) ).

tff(fact_48_Un__empty,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool)] :
      ( ( sup_sup(fun(B1,bool),A1,B2) = bot_bot(fun(B1,bool)) )
    <=> ( ( A1 = bot_bot(fun(B1,bool)) )
        & ( B2 = bot_bot(fun(B1,bool)) ) ) ) ).

tff(fact_49_add__is__0,axiom,
    ! [N1: nat,M1: nat] :
      ( ( plus_plus(nat,M1,N1) = zero_zero(nat) )
    <=> ( ( M1 = zero_zero(nat) )
        & ( N1 = zero_zero(nat) ) ) ) ).

tff(fact_50_Un__upper1,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool)] : ord_less_eq(fun(B1,bool),A1,sup_sup(fun(B1,bool),A1,B2)) ).

tff(fact_51_Un__upper2,axiom,
    ! [B1: $tType,A1: fun(B1,bool),B2: fun(B1,bool)] : ord_less_eq(fun(B1,bool),B2,sup_sup(fun(B1,bool),A1,B2)) ).

tff(fact_52_Int__lower1,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool)] : ord_less_eq(fun(B1,bool),inf_inf(fun(B1,bool),A1,B2),A1) ).

tff(fact_53_Int__lower2,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool)] : ord_less_eq(fun(B1,bool),inf_inf(fun(B1,bool),A1,B2),B2) ).

tff(fact_54_subset__Un__eq,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool)] :
      ( ord_less_eq(fun(B1,bool),A1,B2)
    <=> ( sup_sup(fun(B1,bool),A1,B2) = B2 ) ) ).

tff(fact_55_Int__absorb2,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool)] :
      ( ord_less_eq(fun(B1,bool),A1,B2)
     => ( inf_inf(fun(B1,bool),A1,B2) = A1 ) ) ).

tff(fact_56_Un__absorb1,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool)] :
      ( ord_less_eq(fun(B1,bool),A1,B2)
     => ( sup_sup(fun(B1,bool),A1,B2) = B2 ) ) ).

tff(fact_57_Int__absorb1,axiom,
    ! [B1: $tType,A1: fun(B1,bool),B2: fun(B1,bool)] :
      ( ord_less_eq(fun(B1,bool),B2,A1)
     => ( inf_inf(fun(B1,bool),A1,B2) = B2 ) ) ).

tff(fact_58_Un__absorb2,axiom,
    ! [B1: $tType,A1: fun(B1,bool),B2: fun(B1,bool)] :
      ( ord_less_eq(fun(B1,bool),B2,A1)
     => ( sup_sup(fun(B1,bool),A1,B2) = A1 ) ) ).

tff(fact_59_Int__greatest,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool),C1: fun(B1,bool)] :
      ( ord_less_eq(fun(B1,bool),C1,A1)
     => ( ord_less_eq(fun(B1,bool),C1,B2)
       => ord_less_eq(fun(B1,bool),C1,inf_inf(fun(B1,bool),A1,B2)) ) ) ).

tff(fact_60_Un__least,axiom,
    ! [B1: $tType,B2: fun(B1,bool),C1: fun(B1,bool),A1: fun(B1,bool)] :
      ( ord_less_eq(fun(B1,bool),A1,C1)
     => ( ord_less_eq(fun(B1,bool),B2,C1)
       => ord_less_eq(fun(B1,bool),sup_sup(fun(B1,bool),A1,B2),C1) ) ) ).

tff(fact_61_Int__mono,axiom,
    ! [B1: $tType,D: fun(B1,bool),B2: fun(B1,bool),C1: fun(B1,bool),A1: fun(B1,bool)] :
      ( ord_less_eq(fun(B1,bool),A1,C1)
     => ( ord_less_eq(fun(B1,bool),B2,D)
       => ord_less_eq(fun(B1,bool),inf_inf(fun(B1,bool),A1,B2),inf_inf(fun(B1,bool),C1,D)) ) ) ).

tff(fact_62_Un__mono,axiom,
    ! [B1: $tType,D: fun(B1,bool),B2: fun(B1,bool),C1: fun(B1,bool),A1: fun(B1,bool)] :
      ( ord_less_eq(fun(B1,bool),A1,C1)
     => ( ord_less_eq(fun(B1,bool),B2,D)
       => ord_less_eq(fun(B1,bool),sup_sup(fun(B1,bool),A1,B2),sup_sup(fun(B1,bool),C1,D)) ) ) ).

tff(fact_63_Un__Int__assoc__eq,axiom,
    ! [B1: $tType,C1: fun(B1,bool),B2: fun(B1,bool),A1: fun(B1,bool)] :
      ( ( sup_sup(fun(B1,bool),inf_inf(fun(B1,bool),A1,B2),C1) = inf_inf(fun(B1,bool),A1,sup_sup(fun(B1,bool),B2,C1)) )
    <=> ord_less_eq(fun(B1,bool),C1,A1) ) ).

tff(fact_64_zero__reorient,axiom,
    ! [B1: $tType] :
      ( zero(B1)
     => ! [X2: B1] :
          ( ( zero_zero(B1) = X2 )
        <=> ( X2 = zero_zero(B1) ) ) ) ).

tff(fact_65_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C3: A,A3: A,B3: A] :
          ( ( plus_plus(A,B3,A3) = plus_plus(A,C3,A3) )
         => ( B3 = C3 ) ) ) ).

tff(fact_66_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C3: A,B3: A,A3: A] :
          ( ( plus_plus(A,A3,B3) = plus_plus(A,A3,C3) )
         => ( B3 = C3 ) ) ) ).

tff(fact_67_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C3: A,B3: A,A3: A] :
          ( ( plus_plus(A,A3,B3) = plus_plus(A,A3,C3) )
         => ( B3 = C3 ) ) ) ).

tff(fact_68_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C3: A,B3: A,A3: A] : ( plus_plus(A,plus_plus(A,A3,B3),C3) = plus_plus(A,A3,plus_plus(A,B3,C3)) ) ) ).

tff(fact_69_equals0D,axiom,
    ! [B1: $tType,A2: B1,A1: fun(B1,bool)] :
      ( ( A1 = bot_bot(fun(B1,bool)) )
     => ~ pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),A2),A1)) ) ).

tff(fact_70_ex__in__conv,axiom,
    ! [B1: $tType,A1: fun(B1,bool)] :
      ( ? [X: B1] : pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),X),A1))
    <=> ( A1 != bot_bot(fun(B1,bool)) ) ) ).

tff(fact_71_empty__def,axiom,
    ! [B1: $tType] : ( bot_bot(fun(B1,bool)) = collect(B1,combk(bool,B1,fFalse)) ) ).

tff(fact_72_one__reorient,axiom,
    ! [B1: $tType] :
      ( one(B1)
     => ! [X2: B1] :
          ( ( one_one(B1) = X2 )
        <=> ( X2 = one_one(B1) ) ) ) ).

tff(fact_73_mem__def,axiom,
    ! [B1: $tType,A1: fun(B1,bool),X2: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),X2),A1))
    <=> pp(aa(B1,bool,A1,X2)) ) ).

tff(fact_74_Collect__def,axiom,
    ! [B1: $tType,P1: fun(B1,bool)] : ( collect(B1,P1) = P1 ) ).

tff(fact_75_nat__add__assoc,axiom,
    ! [K: nat,N: nat,M: nat] : ( plus_plus(nat,plus_plus(nat,M,N),K) = plus_plus(nat,M,plus_plus(nat,N,K)) ) ).

tff(fact_76_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X1: nat] : ( plus_plus(nat,X1,plus_plus(nat,Y,Z)) = plus_plus(nat,Y,plus_plus(nat,X1,Z)) ) ).

tff(fact_77_nat__add__commute,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,M,N) = plus_plus(nat,N,M) ) ).

tff(fact_78_IntD2,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool),C2: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),inf_inf(fun(B1,bool),A1,B2)))
     => pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),B2)) ) ).

tff(fact_79_IntD1,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool),C2: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),inf_inf(fun(B1,bool),A1,B2)))
     => pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),A1)) ) ).

tff(fact_80_Int__assoc,axiom,
    ! [B1: $tType,C1: fun(B1,bool),B2: fun(B1,bool),A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),inf_inf(fun(B1,bool),A1,B2),C1) = inf_inf(fun(B1,bool),A1,inf_inf(fun(B1,bool),B2,C1)) ) ).

tff(fact_81_Int__left__commute,axiom,
    ! [B1: $tType,C1: fun(B1,bool),B2: fun(B1,bool),A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A1,inf_inf(fun(B1,bool),B2,C1)) = inf_inf(fun(B1,bool),B2,inf_inf(fun(B1,bool),A1,C1)) ) ).

tff(fact_82_Int__left__absorb,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A1,inf_inf(fun(B1,bool),A1,B2)) = inf_inf(fun(B1,bool),A1,B2) ) ).

tff(fact_83_Int__commute,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A1,B2) = inf_inf(fun(B1,bool),B2,A1) ) ).

tff(fact_84_Int__def,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A1,B2) = collect(B1,combs(B1,bool,bool,combb(bool,fun(bool,bool),B1,fconj,combc(B1,fun(B1,bool),bool,member(B1),A1)),combc(B1,fun(B1,bool),bool,member(B1),B2))) ) ).

tff(fact_85_Int__absorb,axiom,
    ! [B1: $tType,A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A1,A1) = A1 ) ).

tff(fact_86_UnI2,axiom,
    ! [B1: $tType,A1: fun(B1,bool),B2: fun(B1,bool),C2: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),B2))
     => pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),sup_sup(fun(B1,bool),A1,B2))) ) ).

tff(fact_87_UnI1,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool),C2: B1] :
      ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),A1))
     => pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),C2),sup_sup(fun(B1,bool),A1,B2))) ) ).

tff(fact_88_ball__Un,axiom,
    ! [B1: $tType,P1: fun(B1,bool),B2: fun(B1,bool),A1: fun(B1,bool)] :
      ( ! [X: B1] :
          ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),X),sup_sup(fun(B1,bool),A1,B2)))
         => pp(aa(B1,bool,P1,X)) )
    <=> ( ! [X: B1] :
            ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),X),A1))
           => pp(aa(B1,bool,P1,X)) )
        & ! [X: B1] :
            ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),X),B2))
           => pp(aa(B1,bool,P1,X)) ) ) ) ).

tff(fact_89_bex__Un,axiom,
    ! [B1: $tType,P1: fun(B1,bool),B2: fun(B1,bool),A1: fun(B1,bool)] :
      ( ? [X: B1] :
          ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),X),sup_sup(fun(B1,bool),A1,B2)))
          & pp(aa(B1,bool,P1,X)) )
    <=> ( ? [X: B1] :
            ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),X),A1))
            & pp(aa(B1,bool,P1,X)) )
        | ? [X: B1] :
            ( pp(aa(fun(B1,bool),bool,aa(B1,fun(fun(B1,bool),bool),member(B1),X),B2))
            & pp(aa(B1,bool,P1,X)) ) ) ) ).

tff(fact_90_Un__assoc,axiom,
    ! [B1: $tType,C1: fun(B1,bool),B2: fun(B1,bool),A1: fun(B1,bool)] : ( sup_sup(fun(B1,bool),sup_sup(fun(B1,bool),A1,B2),C1) = sup_sup(fun(B1,bool),A1,sup_sup(fun(B1,bool),B2,C1)) ) ).

tff(fact_91_Un__left__commute,axiom,
    ! [B1: $tType,C1: fun(B1,bool),B2: fun(B1,bool),A1: fun(B1,bool)] : ( sup_sup(fun(B1,bool),A1,sup_sup(fun(B1,bool),B2,C1)) = sup_sup(fun(B1,bool),B2,sup_sup(fun(B1,bool),A1,C1)) ) ).

tff(fact_92_Un__left__absorb,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool)] : ( sup_sup(fun(B1,bool),A1,sup_sup(fun(B1,bool),A1,B2)) = sup_sup(fun(B1,bool),A1,B2) ) ).

tff(fact_93_Un__commute,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool)] : ( sup_sup(fun(B1,bool),A1,B2) = sup_sup(fun(B1,bool),B2,A1) ) ).

tff(fact_94_Un__def,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool)] : ( sup_sup(fun(B1,bool),A1,B2) = collect(B1,combs(B1,bool,bool,combb(bool,fun(bool,bool),B1,fdisj,combc(B1,fun(B1,bool),bool,member(B1),A1)),combc(B1,fun(B1,bool),bool,member(B1),B2))) ) ).

tff(fact_95_Un__absorb,axiom,
    ! [B1: $tType,A1: fun(B1,bool)] : ( sup_sup(fun(B1,bool),A1,A1) = A1 ) ).

tff(fact_96_le__antisym,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
     => ( ord_less_eq(nat,N,M)
       => ( M = N ) ) ) ).

tff(fact_97_le__trans,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less_eq(nat,I,J)
     => ( ord_less_eq(nat,J,K)
       => ord_less_eq(nat,I,K) ) ) ).

%----Arities (48)
tff(arity_Huffman__Mirabelle__lalbadcutu_Otree___Code__Evaluation_Oterm__of,axiom,
    ! [T_1: $tType] :
      ( typerep(T_1)
     => code_term_of(huffma1450048681e_tree(T_1)) ) ).

tff(arity_Huffman__Mirabelle__lalbadcutu_Otree___HOL_Oequal,axiom,
    ! [T_1: $tType] : cl_HOL_Oequal(huffma1450048681e_tree(T_1)) ).

tff(arity_Code__Numeral_Ocode__numeral___Code__Evaluation_Oterm__of,axiom,
    code_term_of(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___HOL_Oequal,axiom,
    cl_HOL_Oequal(code_code_numeral) ).

tff(arity_Code__Evaluation_Oterm___Code__Evaluation_Oterm__of,axiom,
    code_term_of(code_term) ).

tff(arity_Code__Evaluation_Oterm___HOL_Oequal,axiom,
    cl_HOL_Oequal(code_term) ).

tff(arity_Product__Type_Ounit___Code__Evaluation_Oterm__of,axiom,
    code_term_of(product_unit) ).

tff(arity_Product__Type_Ounit___HOL_Oequal,axiom,
    cl_HOL_Oequal(product_unit) ).

tff(arity_prod___Code__Evaluation_Oterm__of,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( typerep(T_2)
        & typerep(T_1) )
     => code_term_of(product_prod(T_1,T_2)) ) ).

tff(arity_prod___HOL_Oequal,axiom,
    ! [T_1: $tType,T_2: $tType] : cl_HOL_Oequal(product_prod(T_1,T_2)) ).

tff(arity_HOL_Obool___Code__Evaluation_Oterm__of,axiom,
    code_term_of(bool) ).

tff(arity_HOL_Obool___HOL_Oequal,axiom,
    cl_HOL_Oequal(bool) ).

tff(arity_Nat_Onat___Code__Evaluation_Oterm__of,axiom,
    code_term_of(nat) ).

tff(arity_Nat_Onat___HOL_Oequal,axiom,
    cl_HOL_Oequal(nat) ).

tff(arity_fun___Code__Evaluation_Oterm__of,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( typerep(T_2)
        & typerep(T_1) )
     => code_term_of(fun(T_1,T_2)) ) ).

tff(arity_fun___HOL_Oequal,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( cl_HOL_Oequal(T_2)
        & enum(T_1) )
     => cl_HOL_Oequal(fun(T_1,T_2)) ) ).

tff(arity_fun___Typerep_Otyperep,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( typerep(T_2)
        & typerep(T_1) )
     => typerep(fun(T_1,T_2)) ) ).

tff(arity_fun___Enum_Oenum,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( enum(T_2)
        & enum(T_1) )
     => enum(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Typerep_Otyperep,axiom,
    typerep(nat) ).

tff(arity_HOL_Obool___Typerep_Otyperep,axiom,
    typerep(bool) ).

tff(arity_HOL_Obool___Enum_Oenum,axiom,
    enum(bool) ).

tff(arity_prod___Typerep_Otyperep,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( typerep(T_2)
        & typerep(T_1) )
     => typerep(product_prod(T_1,T_2)) ) ).

tff(arity_prod___Enum_Oenum,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( enum(T_2)
        & enum(T_1) )
     => enum(product_prod(T_1,T_2)) ) ).

tff(arity_Product__Type_Ounit___Typerep_Otyperep,axiom,
    typerep(product_unit) ).

tff(arity_Product__Type_Ounit___Enum_Oenum,axiom,
    enum(product_unit) ).

tff(arity_Code__Evaluation_Oterm___Typerep_Otyperep,axiom,
    typerep(code_term) ).

tff(arity_Code__Numeral_Ocode__numeral___Typerep_Otyperep,axiom,
    typerep(code_code_numeral) ).

tff(arity_Huffman__Mirabelle__lalbadcutu_Otree___Typerep_Otyperep,axiom,
    ! [T_1: $tType] :
      ( typerep(T_1)
     => typerep(huffma1450048681e_tree(T_1)) ) ).

tff(arity_fun___Quickcheck_Orandom,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( random(T_2)
        & cl_HOL_Oequal(T_1)
        & code_term_of(T_1) )
     => random(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Quickcheck_Orandom,axiom,
    random(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_HOL_Obool___Quickcheck_Orandom,axiom,
    random(bool) ).

tff(arity_prod___Quickcheck_Orandom,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( random(T_2)
        & random(T_1) )
     => random(product_prod(T_1,T_2)) ) ).

tff(arity_Product__Type_Ounit___Quickcheck_Orandom,axiom,
    random(product_unit) ).

tff(arity_Code__Evaluation_Oterm___Quickcheck_Orandom,axiom,
    random(code_term) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Quickcheck_Orandom,axiom,
    random(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Ozero,axiom,
    zero(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Oone,axiom,
    one(code_code_numeral) ).

tff(arity_Huffman__Mirabelle__lalbadcutu_Otree___Quickcheck_Orandom,axiom,
    ! [T_1: $tType] :
      ( random(T_1)
     => random(huffma1450048681e_tree(T_1)) ) ).

%----Helper facts (14)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B1: $tType,A: $tType,R: A,Q: fun(A,B1),P: fun(B1,C)] : ( aa(A,C,combb(B1,C,A,P,Q),R) = aa(B1,C,P,aa(A,B1,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B1: $tType,R: A,Q: B1,P: fun(A,fun(B1,C))] : ( aa(A,C,combc(A,B1,C,P,Q),R) = aa(B1,C,aa(A,fun(B1,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B1: $tType,A: $tType,Q: B1,P: A] : ( aa(B1,A,combk(A,B1,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B1: $tType,A: $tType,R: A,Q: fun(A,B1),P: fun(A,fun(B1,C))] : ( aa(A,C,combs(A,B1,C,P,Q),R) = aa(B1,C,aa(A,fun(B1,C),P,R),aa(A,B1,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    ! [B: a] :
      ( pp(aa(fun(a,bool),bool,aa(a,fun(fun(a,bool),bool),member(a),B),huffma675207370phabet(a,t_1)))
     => ( ( huffma410068972_depth(a,t_1,B) = huffma945805758height(a,t_1) )
       => thesis ) ) ).

tff(conj_1,conjecture,
    thesis ).

%------------------------------------------------------------------------------
