%------------------------------------------------------------------------------
% File     : SWW527_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Huffman's Algorithm line 464
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla09] Blanchette (2009), Proof Pearl: Mechanizing the Textbo
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : huff_464 [Bla13]

% Status   : Theorem
% Rating   : 0.67 v9.1.0, 0.33 v7.4.0, 1.00 v6.4.0
% Syntax   : Number of formulae    :  183 (  50 unt;  40 typ;   0 def)
%            Number of atoms       :  296 ( 120 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  211 (  58   ~;  20   |;  15   &)
%                                         (  17 <=>; 101  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   5 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   34 (  19   >;  15   *;   0   +;   0  <<)
%            Number of predicates  :   10 (   9 usr;   1 prp; 0-2 aty)
%            Number of functors    :   28 (  28 usr;   8 con; 0-5 aty)
%            Number of variables   :  477 ( 438   !;   4   ?; 477   :)
%                                         (  35  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:02
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Huffman__Mirabelle__lalbadcutu_Otree,type,
    huffma1450048681e_tree: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (35)
tff(sy_cl_Lattices_Obounded__lattice,type,
    bounded_lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Osemilattice__inf,type,
    semilattice_inf: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Osemilattice__sup,type,
    semilattice_sup: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Obounded__lattice__bot,type,
    bounded_lattice_bot: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B1: $tType,C: $tType,A: $tType] : ( ( fun(B1,C) * fun(A,B1) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B1: $tType,C: $tType] : ( ( fun(A,fun(B1,C)) * B1 ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B1: $tType] : ( A > fun(B1,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B1: $tType,C: $tType] : ( ( fun(A,fun(B1,C)) * fun(A,B1) ) > fun(A,C) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oalphabet,type,
    huffma675207370phabet: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > fun(A,bool) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Oconsistent,type,
    huffma1518433673istent: 
      !>[A: $tType] : ( huffma1450048681e_tree(A) > $o ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OInnerNode,type,
    huffma1146269203erNode: 
      !>[A: $tType] : ( ( nat * huffma1450048681e_tree(A) * huffma1450048681e_tree(A) ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_OLeaf,type,
    huffma2021818691e_Leaf: 
      !>[A: $tType] : ( ( nat * A ) > huffma1450048681e_tree(A) ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_Otree__case,type,
    huffma107959123e_case: 
      !>[A: $tType,T: $tType] : ( ( fun(nat,fun(A,T)) * fun(nat,fun(huffma1450048681e_tree(A),fun(huffma1450048681e_tree(A),T))) * huffma1450048681e_tree(A) ) > T ) ).

tff(sy_c_Huffman__Mirabelle__lalbadcutu_Otree_Otree__rec,type,
    huffma1280178957ee_rec: 
      !>[A: $tType,T: $tType] : ( ( fun(nat,fun(A,T)) * fun(nat,fun(huffma1450048681e_tree(A),fun(huffma1450048681e_tree(A),fun(T,fun(T,T))))) * huffma1450048681e_tree(A) ) > T ) ).

tff(sy_c_Lattices_Oinf__class_Oinf,type,
    inf_inf: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Lattices_Osup__class_Osup,type,
    sup_sup: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_aa,type,
    aa1: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,B1) * A ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_Pa,type,
    pa: $o ).

tff(sy_v_aa,type,
    aa: a ).

tff(sy_v_ta,type,
    ta: huffma1450048681e_tree(a) ).

%----Relevant facts (100)
tff(fact_0_tree_Osimps_I1_J,axiom,
    ! [B1: $tType,A4: B1,Nat4: nat,Aa1: B1,Nat: nat] :
      ( ( huffma2021818691e_Leaf(B1,Nat,Aa1) = huffma2021818691e_Leaf(B1,Nat4,A4) )
    <=> ( ( Nat = Nat4 )
        & ( Aa1 = A4 ) ) ) ).

tff(fact_1_tree_Osimps_I2_J,axiom,
    ! [B1: $tType,Tree23: huffma1450048681e_tree(B1),Tree13: huffma1450048681e_tree(B1),Nat4: nat,Tree2: huffma1450048681e_tree(B1),Tree1: huffma1450048681e_tree(B1),Nat: nat] :
      ( ( huffma1146269203erNode(B1,Nat,Tree1,Tree2) = huffma1146269203erNode(B1,Nat4,Tree13,Tree23) )
    <=> ( ( Nat = Nat4 )
        & ( Tree1 = Tree13 )
        & ( Tree2 = Tree23 ) ) ) ).

tff(fact_2_consistent_Osimps_I1_J,axiom,
    ! [A: $tType,A2: A,W2: nat] : huffma1518433673istent(A,huffma2021818691e_Leaf(A,W2,A2)) ).

tff(fact_3_consistent_Osimps_I2_J,axiom,
    ! [B1: $tType,T_22: huffma1450048681e_tree(B1),T_12: huffma1450048681e_tree(B1),W1: nat] :
      ( huffma1518433673istent(B1,huffma1146269203erNode(B1,W1,T_12,T_22))
    <=> ( huffma1518433673istent(B1,T_12)
        & huffma1518433673istent(B1,T_22)
        & ( inf_inf(fun(B1,bool),huffma675207370phabet(B1,T_12),huffma675207370phabet(B1,T_22)) = bot_bot(fun(B1,bool)) ) ) ) ).

tff(fact_4_tree_Osimps_I3_J,axiom,
    ! [A: $tType,Tree22: huffma1450048681e_tree(A),Tree12: huffma1450048681e_tree(A),Nat2: nat,A2: A,Nat3: nat] : ( huffma2021818691e_Leaf(A,Nat3,A2) != huffma1146269203erNode(A,Nat2,Tree12,Tree22) ) ).

tff(fact_5_tree_Osimps_I4_J,axiom,
    ! [A: $tType,A2: A,Nat3: nat,Tree22: huffma1450048681e_tree(A),Tree12: huffma1450048681e_tree(A),Nat2: nat] : ( huffma1146269203erNode(A,Nat2,Tree12,Tree22) != huffma2021818691e_Leaf(A,Nat3,A2) ) ).

tff(fact_6_inf__bot__left,axiom,
    ! [A: $tType] :
      ( bounded_lattice_bot(A)
     => ! [X: A] : ( inf_inf(A,bot_bot(A),X) = bot_bot(A) ) ) ).

tff(fact_7_inf__bot__right,axiom,
    ! [A: $tType] :
      ( bounded_lattice_bot(A)
     => ! [X: A] : ( inf_inf(A,X,bot_bot(A)) = bot_bot(A) ) ) ).

tff(fact_8_Int__iff,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool),C1: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C1),inf_inf(fun(B1,bool),A1,B2)))
    <=> ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C1),A1))
        & pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C1),B2)) ) ) ).

tff(fact_9_inf1I,axiom,
    ! [B1: $tType,B2: fun(B1,bool),X1: B1,A1: fun(B1,bool)] :
      ( pp(aa1(B1,bool,A1,X1))
     => ( pp(aa1(B1,bool,B2,X1))
       => pp(aa1(B1,bool,inf_inf(fun(B1,bool),A1,B2),X1)) ) ) ).

tff(fact_10_IntI,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool),C1: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C1),A1))
     => ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C1),B2))
       => pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C1),inf_inf(fun(B1,bool),A1,B2))) ) ) ).

tff(fact_11_IntE,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool),C1: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C1),inf_inf(fun(B1,bool),A1,B2)))
     => ~ ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C1),A1))
         => ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C1),B2)) ) ) ).

tff(fact_12_inf1E,axiom,
    ! [B1: $tType,X1: B1,B2: fun(B1,bool),A1: fun(B1,bool)] :
      ( pp(aa1(B1,bool,inf_inf(fun(B1,bool),A1,B2),X1))
     => ~ ( pp(aa1(B1,bool,A1,X1))
         => ~ pp(aa1(B1,bool,B2,X1)) ) ) ).

tff(fact_13_inf_Oleft__idem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [B3: A,A2: A] : ( inf_inf(A,A2,inf_inf(A,A2,B3)) = inf_inf(A,A2,B3) ) ) ).

tff(fact_14_inf__left__idem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Y: A,X: A] : ( inf_inf(A,X,inf_inf(A,X,Y)) = inf_inf(A,X,Y) ) ) ).

tff(fact_15_all__not__in__conv,axiom,
    ! [B1: $tType,A1: fun(B1,bool)] :
      ( ! [X4: B1] : ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),X4),A1))
    <=> ( A1 = bot_bot(fun(B1,bool)) ) ) ).

tff(fact_16_empty__Collect__eq,axiom,
    ! [B1: $tType,Pa: fun(B1,bool)] :
      ( ( bot_bot(fun(B1,bool)) = collect(B1,Pa) )
    <=> ! [X4: B1] : ~ pp(aa1(B1,bool,Pa,X4)) ) ).

tff(fact_17_empty__iff,axiom,
    ! [B1: $tType,C1: B1] : ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C1),bot_bot(fun(B1,bool)))) ).

tff(fact_18_emptyE,axiom,
    ! [B1: $tType,Aa1: B1] : ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),bot_bot(fun(B1,bool)))) ).

tff(fact_19_Collect__empty__eq,axiom,
    ! [B1: $tType,Pa: fun(B1,bool)] :
      ( ( collect(B1,Pa) = bot_bot(fun(B1,bool)) )
    <=> ! [X4: B1] : ~ pp(aa1(B1,bool,Pa,X4)) ) ).

tff(fact_20_equals0D,axiom,
    ! [B1: $tType,Aa1: B1,A1: fun(B1,bool)] :
      ( ( A1 = bot_bot(fun(B1,bool)) )
     => ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),A1)) ) ).

tff(fact_21_ex__in__conv,axiom,
    ! [B1: $tType,A1: fun(B1,bool)] :
      ( ? [X4: B1] : pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),X4),A1))
    <=> ( A1 != bot_bot(fun(B1,bool)) ) ) ).

tff(fact_22_empty__def,axiom,
    ! [B1: $tType] : ( bot_bot(fun(B1,bool)) = collect(B1,combk(bool,B1,fFalse)) ) ).

tff(fact_23_bot__empty__eq,axiom,
    ! [B1: $tType,X3: B1] :
      ( pp(aa1(B1,bool,bot_bot(fun(B1,bool)),X3))
    <=> pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),X3),bot_bot(fun(B1,bool)))) ) ).

tff(fact_24_inf__assoc,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Z: A,Y: A,X: A] : ( inf_inf(A,inf_inf(A,X,Y),Z) = inf_inf(A,X,inf_inf(A,Y,Z)) ) ) ).

tff(fact_25_inf__sup__aci_I2_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z: A,Y: A,X: A] : ( inf_inf(A,inf_inf(A,X,Y),Z) = inf_inf(A,X,inf_inf(A,Y,Z)) ) ) ).

tff(fact_26_inf_Oassoc,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [C4: A,B3: A,A2: A] : ( inf_inf(A,inf_inf(A,A2,B3),C4) = inf_inf(A,A2,inf_inf(A,B3,C4)) ) ) ).

tff(fact_27_inf__left__commute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Z: A,Y: A,X: A] : ( inf_inf(A,X,inf_inf(A,Y,Z)) = inf_inf(A,Y,inf_inf(A,X,Z)) ) ) ).

tff(fact_28_inf__sup__aci_I3_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z: A,Y: A,X: A] : ( inf_inf(A,X,inf_inf(A,Y,Z)) = inf_inf(A,Y,inf_inf(A,X,Z)) ) ) ).

tff(fact_29_inf_Oleft__commute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [C4: A,A2: A,B3: A] : ( inf_inf(A,B3,inf_inf(A,A2,C4)) = inf_inf(A,A2,inf_inf(A,B3,C4)) ) ) ).

tff(fact_30_inf__sup__aci_I4_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X: A] : ( inf_inf(A,X,inf_inf(A,X,Y)) = inf_inf(A,X,Y) ) ) ).

tff(fact_31_inf__commute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [Y: A,X: A] : ( inf_inf(A,X,Y) = inf_inf(A,Y,X) ) ) ).

tff(fact_32_inf__sup__aci_I1_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X: A] : ( inf_inf(A,X,Y) = inf_inf(A,Y,X) ) ) ).

tff(fact_33_inf_Ocommute,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [B3: A,A2: A] : ( inf_inf(A,A2,B3) = inf_inf(A,B3,A2) ) ) ).

tff(fact_34_inf__idem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [X: A] : ( inf_inf(A,X,X) = X ) ) ).

tff(fact_35_inf_Oidem,axiom,
    ! [A: $tType] :
      ( semilattice_inf(A)
     => ! [A2: A] : ( inf_inf(A,A2,A2) = A2 ) ) ).

tff(fact_36_inf1D2,axiom,
    ! [B1: $tType,X1: B1,B2: fun(B1,bool),A1: fun(B1,bool)] :
      ( pp(aa1(B1,bool,inf_inf(fun(B1,bool),A1,B2),X1))
     => pp(aa1(B1,bool,B2,X1)) ) ).

tff(fact_37_inf1D1,axiom,
    ! [B1: $tType,X1: B1,B2: fun(B1,bool),A1: fun(B1,bool)] :
      ( pp(aa1(B1,bool,inf_inf(fun(B1,bool),A1,B2),X1))
     => pp(aa1(B1,bool,A1,X1)) ) ).

tff(fact_38_IntD2,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool),C1: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C1),inf_inf(fun(B1,bool),A1,B2)))
     => pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C1),B2)) ) ).

tff(fact_39_IntD1,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool),C1: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C1),inf_inf(fun(B1,bool),A1,B2)))
     => pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C1),A1)) ) ).

tff(fact_40_Int__assoc,axiom,
    ! [B1: $tType,C2: fun(B1,bool),B2: fun(B1,bool),A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),inf_inf(fun(B1,bool),A1,B2),C2) = inf_inf(fun(B1,bool),A1,inf_inf(fun(B1,bool),B2,C2)) ) ).

tff(fact_41_Int__left__commute,axiom,
    ! [B1: $tType,C2: fun(B1,bool),B2: fun(B1,bool),A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A1,inf_inf(fun(B1,bool),B2,C2)) = inf_inf(fun(B1,bool),B2,inf_inf(fun(B1,bool),A1,C2)) ) ).

tff(fact_42_Int__left__absorb,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A1,inf_inf(fun(B1,bool),A1,B2)) = inf_inf(fun(B1,bool),A1,B2) ) ).

tff(fact_43_Int__commute,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A1,B2) = inf_inf(fun(B1,bool),B2,A1) ) ).

tff(fact_44_Int__def,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A1,B2) = collect(B1,combs(B1,bool,bool,combb(bool,fun(bool,bool),B1,fconj,combc(B1,fun(B1,bool),bool,member(B1),A1)),combc(B1,fun(B1,bool),bool,member(B1),B2))) ) ).

tff(fact_45_Int__absorb,axiom,
    ! [B1: $tType,A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A1,A1) = A1 ) ).

tff(fact_46_disjoint__iff__not__equal,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool)] :
      ( ( inf_inf(fun(B1,bool),A1,B2) = bot_bot(fun(B1,bool)) )
    <=> ! [X4: B1] :
          ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),X4),A1))
         => ! [Xa: B1] :
              ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Xa),B2))
             => ( X4 != Xa ) ) ) ) ).

tff(fact_47_Int__empty__right,axiom,
    ! [B1: $tType,A1: fun(B1,bool)] : ( inf_inf(fun(B1,bool),A1,bot_bot(fun(B1,bool))) = bot_bot(fun(B1,bool)) ) ).

tff(fact_48_Int__empty__left,axiom,
    ! [B1: $tType,B2: fun(B1,bool)] : ( inf_inf(fun(B1,bool),bot_bot(fun(B1,bool)),B2) = bot_bot(fun(B1,bool)) ) ).

tff(fact_49_inf__apply,axiom,
    ! [B1: $tType,C: $tType] :
      ( lattice(B1)
     => ! [X1: C,G: fun(C,B1),F: fun(C,B1)] : ( aa1(C,B1,inf_inf(fun(C,B1),F,G),X1) = inf_inf(B1,aa1(C,B1,F,X1),aa1(C,B1,G,X1)) ) ) ).

tff(fact_50_inf__fun__def,axiom,
    ! [C: $tType,B1: $tType] :
      ( lattice(C)
     => ! [G: fun(B1,C),F: fun(B1,C),X3: B1] : ( aa1(B1,C,inf_inf(fun(B1,C),F,G),X3) = inf_inf(C,aa1(B1,C,F,X3),aa1(B1,C,G,X3)) ) ) ).

tff(fact_51_bot__apply,axiom,
    ! [C: $tType,B1: $tType] :
      ( bot(B1)
     => ! [X1: C] : ( aa1(C,B1,bot_bot(fun(C,B1)),X1) = bot_bot(B1) ) ) ).

tff(fact_52_bot__fun__def,axiom,
    ! [B1: $tType,C: $tType] :
      ( bot(C)
     => ! [X3: B1] : ( aa1(B1,C,bot_bot(fun(B1,C)),X3) = bot_bot(C) ) ) ).

tff(fact_53_exists__in__alphabet,axiom,
    ! [B1: $tType,Ta: huffma1450048681e_tree(B1)] :
    ? [A3: B1] : pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),A3),huffma675207370phabet(B1,Ta))) ).

tff(fact_54_tree_Osimps_I6_J,axiom,
    ! [B1: $tType,C: $tType,Tree2: huffma1450048681e_tree(C),Tree1: huffma1450048681e_tree(C),Nat: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B1))),F1: fun(nat,fun(C,B1))] : ( huffma107959123e_case(C,B1,F1,F2,huffma1146269203erNode(C,Nat,Tree1,Tree2)) = aa1(huffma1450048681e_tree(C),B1,aa1(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B1),aa1(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B1)),F2,Nat),Tree1),Tree2) ) ).

tff(fact_55_tree_Osimps_I5_J,axiom,
    ! [B1: $tType,C: $tType,Aa1: C,Nat: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),B1))),F1: fun(nat,fun(C,B1))] : ( huffma107959123e_case(C,B1,F1,F2,huffma2021818691e_Leaf(C,Nat,Aa1)) = aa1(C,B1,aa1(nat,fun(C,B1),F1,Nat),Aa1) ) ).

tff(fact_56_tree_Oexhaust,axiom,
    ! [A: $tType,Y: huffma1450048681e_tree(A)] :
      ( ! [Nat1: nat,A3: A] : ( Y != huffma2021818691e_Leaf(A,Nat1,A3) )
     => ~ ! [Nat1: nat,Tree11: huffma1450048681e_tree(A),Tree21: huffma1450048681e_tree(A)] : ( Y != huffma1146269203erNode(A,Nat1,Tree11,Tree21) ) ) ).

tff(fact_57_equals0I,axiom,
    ! [B1: $tType,A1: fun(B1,bool)] :
      ( ! [Y2: B1] : ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Y2),A1))
     => ( A1 = bot_bot(fun(B1,bool)) ) ) ).

tff(fact_58_alphabet_Osimps_I1_J,axiom,
    ! [B1: $tType,Aa1: B1,W1: nat] : ( huffma675207370phabet(B1,huffma2021818691e_Leaf(B1,W1,Aa1)) = insert(B1,Aa1,bot_bot(fun(B1,bool))) ) ).

tff(fact_59_insert__absorb2,axiom,
    ! [B1: $tType,A1: fun(B1,bool),X1: B1] : ( insert(B1,X1,insert(B1,X1,A1)) = insert(B1,X1,A1) ) ).

tff(fact_60_insert__iff,axiom,
    ! [B1: $tType,A1: fun(B1,bool),B5: B1,Aa1: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),insert(B1,B5,A1)))
    <=> ( ( Aa1 = B5 )
        | pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),A1)) ) ) ).

tff(fact_61_insertE,axiom,
    ! [B1: $tType,A1: fun(B1,bool),B5: B1,Aa1: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),insert(B1,B5,A1)))
     => ( ( Aa1 != B5 )
       => pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),A1)) ) ) ).

tff(fact_62_insertCI,axiom,
    ! [B1: $tType,B5: B1,B2: fun(B1,bool),Aa1: B1] :
      ( ( ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),B2))
       => ( Aa1 = B5 ) )
     => pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),insert(B1,B5,B2))) ) ).

tff(fact_63_insert__inter__insert,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool),Aa1: B1] : ( inf_inf(fun(B1,bool),insert(B1,Aa1,A1),insert(B1,Aa1,B2)) = insert(B1,Aa1,inf_inf(fun(B1,bool),A1,B2)) ) ).

tff(fact_64_insertI1,axiom,
    ! [B1: $tType,B2: fun(B1,bool),Aa1: B1] : pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),insert(B1,Aa1,B2))) ).

tff(fact_65_insert__compr,axiom,
    ! [B1: $tType,B2: fun(B1,bool),Aa1: B1] : ( insert(B1,Aa1,B2) = collect(B1,combs(B1,bool,bool,combb(bool,fun(bool,bool),B1,fdisj,combc(B1,B1,bool,fequal(B1),Aa1)),combc(B1,fun(B1,bool),bool,member(B1),B2))) ) ).

tff(fact_66_insert__Collect,axiom,
    ! [B1: $tType,Pa: fun(B1,bool),Aa1: B1] : ( insert(B1,Aa1,collect(B1,Pa)) = collect(B1,combs(B1,bool,bool,combb(bool,fun(bool,bool),B1,fimplies,combb(bool,bool,B1,fNot,combc(B1,B1,bool,fequal(B1),Aa1))),Pa)) ) ).

tff(fact_67_insert__commute,axiom,
    ! [B1: $tType,A1: fun(B1,bool),Y1: B1,X1: B1] : ( insert(B1,X1,insert(B1,Y1,A1)) = insert(B1,Y1,insert(B1,X1,A1)) ) ).

tff(fact_68_insert__code,axiom,
    ! [B1: $tType,X1: B1,A1: fun(B1,bool),Y1: B1] :
      ( pp(aa1(B1,bool,insert(B1,Y1,A1),X1))
    <=> ( ( Y1 = X1 )
        | pp(aa1(B1,bool,A1,X1)) ) ) ).

tff(fact_69_insert__ident,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool),X1: B1] :
      ( ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),X1),A1))
     => ( ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),X1),B2))
       => ( ( insert(B1,X1,A1) = insert(B1,X1,B2) )
        <=> ( A1 = B2 ) ) ) ) ).

tff(fact_70_insert__eq__iff,axiom,
    ! [B1: $tType,B2: fun(B1,bool),B5: B1,A1: fun(B1,bool),Aa1: B1] :
      ( ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),A1))
     => ( ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),B5),B2))
       => ( ( insert(B1,Aa1,A1) = insert(B1,B5,B2) )
        <=> ( ( ( Aa1 = B5 )
             => ( A1 = B2 ) )
            & ( ( Aa1 != B5 )
             => ? [C3: fun(B1,bool)] :
                  ( ( A1 = insert(B1,B5,C3) )
                  & ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),B5),C3))
                  & ( B2 = insert(B1,Aa1,C3) )
                  & ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),C3)) ) ) ) ) ) ) ).

tff(fact_71_insertI2,axiom,
    ! [B1: $tType,B5: B1,B2: fun(B1,bool),Aa1: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),B2))
     => pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),insert(B1,B5,B2))) ) ).

tff(fact_72_insert__absorb,axiom,
    ! [B1: $tType,A1: fun(B1,bool),Aa1: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),A1))
     => ( insert(B1,Aa1,A1) = A1 ) ) ).

tff(fact_73_empty__not__insert,axiom,
    ! [B1: $tType,A1: fun(B1,bool),Aa1: B1] : ( bot_bot(fun(B1,bool)) != insert(B1,Aa1,A1) ) ).

tff(fact_74_insert__not__empty,axiom,
    ! [B1: $tType,A1: fun(B1,bool),Aa1: B1] : ( insert(B1,Aa1,A1) != bot_bot(fun(B1,bool)) ) ).

tff(fact_75_ext,axiom,
    ! [C: $tType,B1: $tType,G: fun(B1,C),F: fun(B1,C)] :
      ( ! [X2: B1] : ( aa1(B1,C,F,X2) = aa1(B1,C,G,X2) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [B1: $tType,A1: fun(B1,bool),X1: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),X1),A1))
    <=> pp(aa1(B1,bool,A1,X1)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [B1: $tType,Pa: fun(B1,bool)] : ( collect(B1,Pa) = Pa ) ).

tff(fact_78_singleton__iff,axiom,
    ! [B1: $tType,Aa1: B1,B5: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),B5),insert(B1,Aa1,bot_bot(fun(B1,bool)))))
    <=> ( B5 = Aa1 ) ) ).

tff(fact_79_doubleton__eq__iff,axiom,
    ! [B1: $tType,D: B1,C1: B1,B5: B1,Aa1: B1] :
      ( ( insert(B1,Aa1,insert(B1,B5,bot_bot(fun(B1,bool)))) = insert(B1,C1,insert(B1,D,bot_bot(fun(B1,bool)))) )
    <=> ( ( ( Aa1 = C1 )
          & ( B5 = D ) )
        | ( ( Aa1 = D )
          & ( B5 = C1 ) ) ) ) ).

tff(fact_80_singletonE,axiom,
    ! [B1: $tType,Aa1: B1,B5: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),B5),insert(B1,Aa1,bot_bot(fun(B1,bool)))))
     => ( B5 = Aa1 ) ) ).

tff(fact_81_singleton__inject,axiom,
    ! [B1: $tType,B5: B1,Aa1: B1] :
      ( ( insert(B1,Aa1,bot_bot(fun(B1,bool))) = insert(B1,B5,bot_bot(fun(B1,bool))) )
     => ( Aa1 = B5 ) ) ).

tff(fact_82_Int__insert__right,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool),Aa1: B1] :
      ( ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),A1))
       => ( inf_inf(fun(B1,bool),A1,insert(B1,Aa1,B2)) = insert(B1,Aa1,inf_inf(fun(B1,bool),A1,B2)) ) )
      & ( ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),A1))
       => ( inf_inf(fun(B1,bool),A1,insert(B1,Aa1,B2)) = inf_inf(fun(B1,bool),A1,B2) ) ) ) ).

tff(fact_83_Int__insert__left,axiom,
    ! [B1: $tType,B2: fun(B1,bool),C2: fun(B1,bool),Aa1: B1] :
      ( ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),C2))
       => ( inf_inf(fun(B1,bool),insert(B1,Aa1,B2),C2) = insert(B1,Aa1,inf_inf(fun(B1,bool),B2,C2)) ) )
      & ( ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),C2))
       => ( inf_inf(fun(B1,bool),insert(B1,Aa1,B2),C2) = inf_inf(fun(B1,bool),B2,C2) ) ) ) ).

tff(fact_84_Int__insert__right__if0,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool),Aa1: B1] :
      ( ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),A1))
     => ( inf_inf(fun(B1,bool),A1,insert(B1,Aa1,B2)) = inf_inf(fun(B1,bool),A1,B2) ) ) ).

tff(fact_85_Int__insert__left__if0,axiom,
    ! [B1: $tType,B2: fun(B1,bool),C2: fun(B1,bool),Aa1: B1] :
      ( ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),C2))
     => ( inf_inf(fun(B1,bool),insert(B1,Aa1,B2),C2) = inf_inf(fun(B1,bool),B2,C2) ) ) ).

tff(fact_86_Int__insert__right__if1,axiom,
    ! [B1: $tType,B2: fun(B1,bool),A1: fun(B1,bool),Aa1: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),A1))
     => ( inf_inf(fun(B1,bool),A1,insert(B1,Aa1,B2)) = insert(B1,Aa1,inf_inf(fun(B1,bool),A1,B2)) ) ) ).

tff(fact_87_Int__insert__left__if1,axiom,
    ! [B1: $tType,B2: fun(B1,bool),C2: fun(B1,bool),Aa1: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),C2))
     => ( inf_inf(fun(B1,bool),insert(B1,Aa1,B2),C2) = insert(B1,Aa1,inf_inf(fun(B1,bool),B2,C2)) ) ) ).

tff(fact_88_the__elem__eq,axiom,
    ! [B1: $tType,X1: B1] : ( the_elem(B1,insert(B1,X1,bot_bot(fun(B1,bool)))) = X1 ) ).

tff(fact_89_mk__disjoint__insert,axiom,
    ! [B1: $tType,A1: fun(B1,bool),Aa1: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),A1))
     => ? [B4: fun(B1,bool)] :
          ( ( A1 = insert(B1,Aa1,B4) )
          & ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),Aa1),B4)) ) ) ).

tff(fact_90_Set_Oset__insert,axiom,
    ! [B1: $tType,A1: fun(B1,bool),X1: B1] :
      ( pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),X1),A1))
     => ~ ! [B4: fun(B1,bool)] :
            ( ( A1 = insert(B1,X1,B4) )
           => pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),X1),B4)) ) ) ).

tff(fact_91_tree_Orecs_I2_J,axiom,
    ! [B1: $tType,C: $tType,Tree2: huffma1450048681e_tree(C),Tree1: huffma1450048681e_tree(C),Nat: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B1,fun(B1,B1))))),F1: fun(nat,fun(C,B1))] : ( huffma1280178957ee_rec(C,B1,F1,F2,huffma1146269203erNode(C,Nat,Tree1,Tree2)) = aa1(B1,B1,aa1(B1,fun(B1,B1),aa1(huffma1450048681e_tree(C),fun(B1,fun(B1,B1)),aa1(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B1,fun(B1,B1))),aa1(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B1,fun(B1,B1)))),F2,Nat),Tree1),Tree2),huffma1280178957ee_rec(C,B1,F1,F2,Tree1)),huffma1280178957ee_rec(C,B1,F1,F2,Tree2)) ) ).

tff(fact_92_tree_Orecs_I1_J,axiom,
    ! [B1: $tType,C: $tType,Aa1: C,Nat: nat,F2: fun(nat,fun(huffma1450048681e_tree(C),fun(huffma1450048681e_tree(C),fun(B1,fun(B1,B1))))),F1: fun(nat,fun(C,B1))] : ( huffma1280178957ee_rec(C,B1,F1,F2,huffma2021818691e_Leaf(C,Nat,Aa1)) = aa1(C,B1,aa1(nat,fun(C,B1),F1,Nat),Aa1) ) ).

tff(fact_93_alphabet_Osimps_I2_J,axiom,
    ! [B1: $tType,T_22: huffma1450048681e_tree(B1),T_12: huffma1450048681e_tree(B1),W1: nat] : ( huffma675207370phabet(B1,huffma1146269203erNode(B1,W1,T_12,T_22)) = sup_sup(fun(B1,bool),huffma675207370phabet(B1,T_12),huffma675207370phabet(B1,T_22)) ) ).

tff(fact_94_Inf__fin_Oidem,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [X: A] : ( inf_inf(A,X,X) = X ) ) ).

tff(fact_95_sup__left__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Y: A,X: A] : ( sup_sup(A,X,sup_sup(A,X,Y)) = sup_sup(A,X,Y) ) ) ).

tff(fact_96_sup_Oleft__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [B3: A,A2: A] : ( sup_sup(A,A2,sup_sup(A,A2,B3)) = sup_sup(A,A2,B3) ) ) ).

tff(fact_97_UnCI,axiom,
    ! [B1: $tType,A1: fun(B1,bool),B2: fun(B1,bool),C1: B1] :
      ( ( ~ pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C1),B2))
       => pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C1),A1)) )
     => pp(aa1(fun(B1,bool),bool,aa1(B1,fun(fun(B1,bool),bool),member(B1),C1),sup_sup(fun(B1,bool),A1,B2))) ) ).

tff(fact_98_sup1CI,axiom,
    ! [B1: $tType,A1: fun(B1,bool),X1: B1,B2: fun(B1,bool)] :
      ( ( ~ pp(aa1(B1,bool,B2,X1))
       => pp(aa1(B1,bool,A1,X1)) )
     => pp(aa1(B1,bool,sup_sup(fun(B1,bool),A1,B2),X1)) ) ).

tff(fact_99_sup1E,axiom,
    ! [B1: $tType,X1: B1,B2: fun(B1,bool),A1: fun(B1,bool)] :
      ( pp(aa1(B1,bool,sup_sup(fun(B1,bool),A1,B2),X1))
     => ( ~ pp(aa1(B1,bool,A1,X1))
       => pp(aa1(B1,bool,B2,X1)) ) ) ).

%----Arities (16)
tff(arity_HOL_Obool___Lattices_Obounded__lattice,axiom,
    bounded_lattice(bool) ).

tff(arity_fun___Lattices_Obounded__lattice,axiom,
    ! [T_11: $tType,T_21: $tType] :
      ( bounded_lattice(T_21)
     => bounded_lattice(fun(T_11,T_21)) ) ).

tff(arity_fun___Lattices_Obounded__lattice__bot,axiom,
    ! [T_11: $tType,T_21: $tType] :
      ( bounded_lattice(T_21)
     => bounded_lattice_bot(fun(T_11,T_21)) ) ).

tff(arity_fun___Lattices_Osemilattice__sup,axiom,
    ! [T_11: $tType,T_21: $tType] :
      ( lattice(T_21)
     => semilattice_sup(fun(T_11,T_21)) ) ).

tff(arity_fun___Lattices_Osemilattice__inf,axiom,
    ! [T_11: $tType,T_21: $tType] :
      ( lattice(T_21)
     => semilattice_inf(fun(T_11,T_21)) ) ).

tff(arity_fun___Lattices_Olattice,axiom,
    ! [T_11: $tType,T_21: $tType] :
      ( lattice(T_21)
     => lattice(fun(T_11,T_21)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_11: $tType,T_21: $tType] :
      ( bot(T_21)
     => bot(fun(T_11,T_21)) ) ).

tff(arity_Nat_Onat___Lattices_Osemilattice__sup,axiom,
    semilattice_sup(nat) ).

tff(arity_Nat_Onat___Lattices_Osemilattice__inf,axiom,
    semilattice_inf(nat) ).

tff(arity_Nat_Onat___Lattices_Olattice,axiom,
    lattice(nat) ).

tff(arity_Nat_Onat___Orderings_Obot,axiom,
    bot(nat) ).

tff(arity_HOL_Obool___Lattices_Obounded__lattice__bot,axiom,
    bounded_lattice_bot(bool) ).

tff(arity_HOL_Obool___Lattices_Osemilattice__sup,axiom,
    semilattice_sup(bool) ).

tff(arity_HOL_Obool___Lattices_Osemilattice__inf,axiom,
    semilattice_inf(bool) ).

tff(arity_HOL_Obool___Lattices_Olattice,axiom,
    lattice(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (21)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa1(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa1(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B1: $tType,A: $tType,R: A,Q: fun(A,B1),P: fun(B1,C)] : ( aa1(A,C,combb(B1,C,A,P,Q),R) = aa1(B1,C,P,aa1(A,B1,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B1: $tType,R: A,Q: B1,P: fun(A,fun(B1,C))] : ( aa1(A,C,combc(A,B1,C,P,Q),R) = aa1(B1,C,aa1(A,fun(B1,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B1: $tType,A: $tType,Q: B1,P: A] : ( aa1(B1,A,combk(A,B1,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B1: $tType,A: $tType,R: A,Q: fun(A,B1),P: fun(A,fun(B1,C))] : ( aa1(A,C,combs(A,B1,C,P,Q),R) = aa1(B1,C,aa1(A,fun(B1,C),P,R),aa1(A,B1,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa1(bool,bool,aa1(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa1(bool,bool,aa1(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa1(bool,bool,aa1(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa1(bool,bool,aa1(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa1(bool,bool,aa1(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa1(bool,bool,aa1(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa1(A,bool,aa1(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa1(A,bool,aa1(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa1(bool,bool,aa1(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa1(bool,bool,aa1(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa1(bool,bool,aa1(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (6)
tff(conj_0,hypothesis,
    huffma1518433673istent(a,ta) ).

tff(conj_1,hypothesis,
    ! [W_b: nat,B: a,Aa: a] :
      ( ( ta = huffma2021818691e_Leaf(a,W_b,B) )
     => ( ( aa = Aa )
       => pa ) ) ).

tff(conj_2,hypothesis,
    ! [W: nat,T_1: huffma1450048681e_tree(a),T_2: huffma1450048681e_tree(a),Aa: a] :
      ( huffma1518433673istent(a,T_1)
     => ( huffma1518433673istent(a,T_2)
       => ( ( inf_inf(fun(a,bool),huffma675207370phabet(a,T_1),huffma675207370phabet(a,T_2)) = bot_bot(fun(a,bool)) )
         => ( pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),Aa),huffma675207370phabet(a,T_1)))
           => ( ~ pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),Aa),huffma675207370phabet(a,T_2)))
             => ( ( ta = huffma1146269203erNode(a,W,T_1,T_2) )
               => ( ( aa = Aa )
                 => pa ) ) ) ) ) ) ) ).

tff(conj_3,hypothesis,
    ! [W: nat,T_1: huffma1450048681e_tree(a),T_2: huffma1450048681e_tree(a),Aa: a] :
      ( huffma1518433673istent(a,T_1)
     => ( huffma1518433673istent(a,T_2)
       => ( ( inf_inf(fun(a,bool),huffma675207370phabet(a,T_1),huffma675207370phabet(a,T_2)) = bot_bot(fun(a,bool)) )
         => ( ~ pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),Aa),huffma675207370phabet(a,T_1)))
           => ( pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),Aa),huffma675207370phabet(a,T_2)))
             => ( ( ta = huffma1146269203erNode(a,W,T_1,T_2) )
               => ( ( aa = Aa )
                 => pa ) ) ) ) ) ) ) ).

tff(conj_4,hypothesis,
    ! [W: nat,T_1: huffma1450048681e_tree(a),T_2: huffma1450048681e_tree(a),Aa: a] :
      ( huffma1518433673istent(a,T_1)
     => ( huffma1518433673istent(a,T_2)
       => ( ( inf_inf(fun(a,bool),huffma675207370phabet(a,T_1),huffma675207370phabet(a,T_2)) = bot_bot(fun(a,bool)) )
         => ( ~ pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),Aa),huffma675207370phabet(a,T_1)))
           => ( ~ pp(aa1(fun(a,bool),bool,aa1(a,fun(fun(a,bool),bool),member(a),Aa),huffma675207370phabet(a,T_2)))
             => ( ( ta = huffma1146269203erNode(a,W,T_1,T_2) )
               => ( ( aa = Aa )
                 => pa ) ) ) ) ) ) ) ).

tff(conj_5,conjecture,
    pa ).

%------------------------------------------------------------------------------
