%------------------------------------------------------------------------------
% File     : SWW525_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Hoare's Logic with Procedures line 320
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : hoare_320 [Bla13]

% Status   : ContradictoryAxioms
% Rating   : 0.67 v8.1.0, 1.00 v7.5.0, 0.67 v7.4.0, 0.75 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  133 (  66 unt;  29 typ;   0 def)
%            Number of atoms       :  178 (  86 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  140 (  66   ~;   0   |;   9   &)
%                                         (   8 <=>;  57  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   7 avg)
%            Maximal term depth    :   10 (   1 avg)
%            Number of types       :    8 (   7 usr)
%            Number of type conns  :   49 (  15   >;  34   *;   0   +;   0  <<)
%            Number of predicates  :    6 (   5 usr;   1 prp; 0-4 aty)
%            Number of functors    :   17 (  17 usr;   6 con; 0-10 aty)
%            Number of variables   :  495 ( 487   !;   4   ?; 495   :)
%                                         (   4  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:26:45
%------------------------------------------------------------------------------
%----Should-be-implicit typings (8)
tff(ty_tc_Com_Ocom,type,
    com: $tType ).

tff(ty_tc_Com_Oloc,type,
    loc: $tType ).

tff(ty_tc_Com_Opname,type,
    pname: $tType ).

tff(ty_tc_Com_Ostate,type,
    state: $tType ).

tff(ty_tc_Com_Ovname,type,
    vname: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (21)
tff(sy_c_Com_OWT,type,
    wt: com > $o ).

tff(sy_c_Com_Ocom_OAss,type,
    ass: ( vname * fun(state,nat) ) > com ).

tff(sy_c_Com_Ocom_OCall,type,
    call: ( vname * pname * fun(state,nat) ) > com ).

tff(sy_c_Com_Ocom_OCond,type,
    cond: ( fun(state,bool) * com * com ) > com ).

tff(sy_c_Com_Ocom_OLocal,type,
    local: ( loc * fun(state,nat) * com ) > com ).

tff(sy_c_Com_Ocom_OSKIP,type,
    skip: com ).

tff(sy_c_Com_Ocom_OSemi,type,
    semi: ( com * com ) > com ).

tff(sy_c_Com_Ocom_OWhile,type,
    while: ( fun(state,bool) * com ) > com ).

tff(sy_c_Com_Ocom_Ocom__case,type,
    com_case: 
      !>[T4: $tType] : ( ( T4 * fun(vname,fun(fun(state,nat),T4)) * fun(loc,fun(fun(state,nat),fun(com,T4))) * fun(com,fun(com,T4)) * fun(fun(state,bool),fun(com,fun(com,T4))) * fun(fun(state,bool),fun(com,T4)) * fun(pname,T4) * fun(vname,fun(pname,fun(fun(state,nat),T4))) * com ) > T4 ) ).

tff(sy_c_Com_Ocom_Ocom__rec,type,
    com_rec: 
      !>[T4: $tType] : ( ( T4 * fun(vname,fun(fun(state,nat),T4)) * fun(loc,fun(fun(state,nat),fun(com,fun(T4,T4)))) * fun(com,fun(com,fun(T4,fun(T4,T4)))) * fun(fun(state,bool),fun(com,fun(com,fun(T4,fun(T4,T4))))) * fun(fun(state,bool),fun(com,fun(T4,T4))) * fun(pname,T4) * fun(vname,fun(pname,fun(fun(state,nat),T4))) * com ) > T4 ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Ostate__not__singleton,type,
    hoare_531836380gleton: $o ).

tff(sy_c_Natural_Oevalc,type,
    evalc: ( com * state * state ) > $o ).

tff(sy_c_Natural_Oevaln,type,
    evaln: ( com * state * nat * state ) > $o ).

tff(sy_c_Natural_Oupdate,type,
    update: ( state * vname * nat ) > state ).

tff(sy_c_aa,type,
    aa: 
      !>[A1: $tType,B1: $tType] : ( ( fun(A1,B1) * A1 ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_Z,type,
    z: state ).

tff(sy_v_c,type,
    c: com ).

tff(sy_v_s_H,type,
    s: state ).

%----Relevant facts (98)
tff(fact_0_state__not__singleton__def,axiom,
    ( hoare_531836380gleton
  <=> ? [S4: state,T3: state] : ( S4 != T3 ) ) ).

tff(fact_1_single__stateE,axiom,
    ( hoare_531836380gleton
   => ! [T2: state] :
        ~ ! [S3: state] : ( S3 = T2 ) ) ).

tff(fact_2_com__det,axiom,
    ! [U: state,T1: state,S2: state,C: com] :
      ( evalc(C,S2,T1)
     => ( evalc(C,S2,U)
       => ( U = T1 ) ) ) ).

tff(fact_3_evalc_OSkip,axiom,
    ! [S2: state] : evalc(skip,S2,S2) ).

tff(fact_4_evalc__elim__cases_I1_J,axiom,
    ! [T1: state,S2: state] :
      ( evalc(skip,S2,T1)
     => ( T1 = S2 ) ) ).

tff(fact_5_evalc_OSemi,axiom,
    ! [S21: state,C1: com,S11: state,S0: state,C0: com] :
      ( evalc(C0,S0,S11)
     => ( evalc(C1,S11,S21)
       => evalc(semi(C0,C1),S0,S21) ) ) ).

tff(fact_6_evalc_OIfFalse,axiom,
    ! [C01: com,S12: state,C11: com,S: state,B: fun(state,bool)] :
      ( ~ pp(aa(state,bool,B,S))
     => ( evalc(C11,S,S12)
       => evalc(cond(B,C01,C11),S,S12) ) ) ).

tff(fact_7_evalc_OIfTrue,axiom,
    ! [C11: com,S12: state,C01: com,S: state,B: fun(state,bool)] :
      ( pp(aa(state,bool,B,S))
     => ( evalc(C01,S,S12)
       => evalc(cond(B,C01,C11),S,S12) ) ) ).

tff(fact_8_evalc__elim__cases_I5_J,axiom,
    ! [T: state,S: state,C2: com,C11: com,B: fun(state,bool)] :
      ( evalc(cond(B,C11,C2),S,T)
     => ( ( pp(aa(state,bool,B,S))
         => ~ evalc(C11,S,T) )
       => ~ ( ~ pp(aa(state,bool,B,S))
           => ~ evalc(C2,S,T) ) ) ) ).

tff(fact_9_evalc_OWhileFalse,axiom,
    ! [Ca: com,S: state,B: fun(state,bool)] :
      ( ~ pp(aa(state,bool,B,S))
     => evalc(while(B,Ca),S,S) ) ).

tff(fact_10_evalc_OWhileTrue,axiom,
    ! [S22: state,S12: state,Ca: com,S01: state,B: fun(state,bool)] :
      ( pp(aa(state,bool,B,S01))
     => ( evalc(Ca,S01,S12)
       => ( evalc(while(B,Ca),S12,S22)
         => evalc(while(B,Ca),S01,S22) ) ) ) ).

tff(fact_11_evalc__elim__cases_I4_J,axiom,
    ! [T1: state,S2: state,C21: com,C1: com] :
      ( evalc(semi(C1,C21),S2,T1)
     => ~ ! [S1: state] :
            ( evalc(C1,S2,S1)
           => ~ evalc(C21,S1,T1) ) ) ).

tff(fact_12_com_Osimps_I3_J,axiom,
    ! [Com21: com,Com11: com,Com2: com,Com1: com] :
      ( ( semi(Com1,Com2) = semi(Com11,Com21) )
    <=> ( ( Com1 = Com11 )
        & ( Com2 = Com21 ) ) ) ).

tff(fact_13_com_Osimps_I4_J,axiom,
    ! [Com21: com,Com11: com,Fun: fun(state,bool),Com2: com,Com1: com,Fun1: fun(state,bool)] :
      ( ( cond(Fun1,Com1,Com2) = cond(Fun,Com11,Com21) )
    <=> ( ( Fun1 = Fun )
        & ( Com1 = Com11 )
        & ( Com2 = Com21 ) ) ) ).

tff(fact_14_com_Osimps_I5_J,axiom,
    ! [Com3: com,Fun: fun(state,bool),Com: com,Fun1: fun(state,bool)] :
      ( ( while(Fun1,Com) = while(Fun,Com3) )
    <=> ( ( Fun1 = Fun )
        & ( Com = Com3 ) ) ) ).

tff(fact_15_evalc__WHILE__case,axiom,
    ! [T: state,S: state,Ca: com,B: fun(state,bool)] :
      ( evalc(while(B,Ca),S,T)
     => ( ( ( T = S )
         => pp(aa(state,bool,B,S)) )
       => ~ ( pp(aa(state,bool,B,S))
           => ! [S1: state] :
                ( evalc(Ca,S,S1)
               => ~ evalc(while(B,Ca),S1,T) ) ) ) ) ).

tff(fact_16_com_Osimps_I12_J,axiom,
    ! [Com22: com,Com12: com] : ( skip != semi(Com12,Com22) ) ).

tff(fact_17_com_Osimps_I13_J,axiom,
    ! [Com22: com,Com12: com] : ( semi(Com12,Com22) != skip ) ).

tff(fact_18_com_Osimps_I14_J,axiom,
    ! [Com21: com,Com11: com,Fun: fun(state,bool)] : ( skip != cond(Fun,Com11,Com21) ) ).

tff(fact_19_com_Osimps_I15_J,axiom,
    ! [Com21: com,Com11: com,Fun: fun(state,bool)] : ( cond(Fun,Com11,Com21) != skip ) ).

tff(fact_20_com_Osimps_I44_J,axiom,
    ! [Com21: com,Com11: com,Fun: fun(state,bool),Com2: com,Com1: com] : ( semi(Com1,Com2) != cond(Fun,Com11,Com21) ) ).

tff(fact_21_com_Osimps_I52_J,axiom,
    ! [Com3: com,Fun: fun(state,bool),Com2: com,Com1: com,Fun1: fun(state,bool)] : ( cond(Fun1,Com1,Com2) != while(Fun,Com3) ) ).

tff(fact_22_com_Osimps_I53_J,axiom,
    ! [Com2: com,Com1: com,Fun1: fun(state,bool),Com3: com,Fun: fun(state,bool)] : ( while(Fun,Com3) != cond(Fun1,Com1,Com2) ) ).

tff(fact_23_com_Osimps_I47_J,axiom,
    ! [Com2: com,Com1: com,Com3: com,Fun: fun(state,bool)] : ( while(Fun,Com3) != semi(Com1,Com2) ) ).

tff(fact_24_com_Osimps_I46_J,axiom,
    ! [Com3: com,Fun: fun(state,bool),Com2: com,Com1: com] : ( semi(Com1,Com2) != while(Fun,Com3) ) ).

tff(fact_25_com_Osimps_I17_J,axiom,
    ! [Com3: com,Fun: fun(state,bool)] : ( while(Fun,Com3) != skip ) ).

tff(fact_26_com_Osimps_I16_J,axiom,
    ! [Com3: com,Fun: fun(state,bool)] : ( skip != while(Fun,Com3) ) ).

tff(fact_27_com_Osimps_I45_J,axiom,
    ! [Com2: com,Com1: com,Com21: com,Com11: com,Fun: fun(state,bool)] : ( cond(Fun,Com11,Com21) != semi(Com1,Com2) ) ).

tff(fact_28_com_Osimps_I64_J,axiom,
    ! [A1: $tType,F8: fun(vname,fun(pname,fun(fun(state,nat),A1))),F7: fun(pname,A1),F6: fun(fun(state,bool),fun(com,A1)),F5: fun(fun(state,bool),fun(com,fun(com,A1))),F4: fun(com,fun(com,A1)),F3: fun(loc,fun(fun(state,nat),fun(com,A1))),F2: fun(vname,fun(fun(state,nat),A1)),F1: A1] : ( com_case(A1,F1,F2,F3,F4,F5,F6,F7,F8,skip) = F1 ) ).

tff(fact_29_com_Osimps_I67_J,axiom,
    ! [A1: $tType,Com2: com,Com1: com,F8: fun(vname,fun(pname,fun(fun(state,nat),A1))),F7: fun(pname,A1),F6: fun(fun(state,bool),fun(com,A1)),F5: fun(fun(state,bool),fun(com,fun(com,A1))),F4: fun(com,fun(com,A1)),F3: fun(loc,fun(fun(state,nat),fun(com,A1))),F2: fun(vname,fun(fun(state,nat),A1)),F1: A1] : ( com_case(A1,F1,F2,F3,F4,F5,F6,F7,F8,semi(Com1,Com2)) = aa(com,A1,aa(com,fun(com,A1),F4,Com1),Com2) ) ).

tff(fact_30_com_Osimps_I68_J,axiom,
    ! [A1: $tType,Com2: com,Com1: com,Fun1: fun(state,bool),F8: fun(vname,fun(pname,fun(fun(state,nat),A1))),F7: fun(pname,A1),F6: fun(fun(state,bool),fun(com,A1)),F5: fun(fun(state,bool),fun(com,fun(com,A1))),F4: fun(com,fun(com,A1)),F3: fun(loc,fun(fun(state,nat),fun(com,A1))),F2: fun(vname,fun(fun(state,nat),A1)),F1: A1] : ( com_case(A1,F1,F2,F3,F4,F5,F6,F7,F8,cond(Fun1,Com1,Com2)) = aa(com,A1,aa(com,fun(com,A1),aa(fun(state,bool),fun(com,fun(com,A1)),F5,Fun1),Com1),Com2) ) ).

tff(fact_31_com_Osimps_I69_J,axiom,
    ! [A1: $tType,Com: com,Fun1: fun(state,bool),F8: fun(vname,fun(pname,fun(fun(state,nat),A1))),F7: fun(pname,A1),F6: fun(fun(state,bool),fun(com,A1)),F5: fun(fun(state,bool),fun(com,fun(com,A1))),F4: fun(com,fun(com,A1)),F3: fun(loc,fun(fun(state,nat),fun(com,A1))),F2: fun(vname,fun(fun(state,nat),A1)),F1: A1] : ( com_case(A1,F1,F2,F3,F4,F5,F6,F7,F8,while(Fun1,Com)) = aa(com,A1,aa(fun(state,bool),fun(com,A1),F6,Fun1),Com) ) ).

tff(fact_32_WTs__elim__cases_I4_J,axiom,
    ! [C21: com,C1: com] :
      ( wt(semi(C1,C21))
     => ~ ( wt(C1)
         => ~ wt(C21) ) ) ).

tff(fact_33_WTs__elim__cases_I5_J,axiom,
    ! [C2: com,C11: com,B: fun(state,bool)] :
      ( wt(cond(B,C11,C2))
     => ~ ( wt(C11)
         => ~ wt(C2) ) ) ).

tff(fact_34_WTs__elim__cases_I6_J,axiom,
    ! [Ca: com,B: fun(state,bool)] :
      ( wt(while(B,Ca))
     => wt(Ca) ) ).

tff(fact_35_While,axiom,
    ! [B: fun(state,bool),Ca: com] :
      ( wt(Ca)
     => wt(while(B,Ca)) ) ).

tff(fact_36_WT_OIf,axiom,
    ! [B: fun(state,bool),C11: com,C01: com] :
      ( wt(C01)
     => ( wt(C11)
       => wt(cond(B,C01,C11)) ) ) ).

tff(fact_37_WT_OSemi,axiom,
    ! [C1: com,C0: com] :
      ( wt(C0)
     => ( wt(C1)
       => wt(semi(C0,C1)) ) ) ).

tff(fact_38_WT_OSkip,axiom,
    wt(skip) ).

tff(fact_39_WTs__elim__cases_I3_J,axiom,
    ! [Ca: com,A: fun(state,nat),Y: loc] :
      ( wt(local(Y,A,Ca))
     => wt(Ca) ) ).

tff(fact_40_com_Orecs_I1_J,axiom,
    ! [A1: $tType,F8: fun(vname,fun(pname,fun(fun(state,nat),A1))),F7: fun(pname,A1),F6: fun(fun(state,bool),fun(com,fun(A1,A1))),F5: fun(fun(state,bool),fun(com,fun(com,fun(A1,fun(A1,A1))))),F4: fun(com,fun(com,fun(A1,fun(A1,A1)))),F3: fun(loc,fun(fun(state,nat),fun(com,fun(A1,A1)))),F2: fun(vname,fun(fun(state,nat),A1)),F1: A1] : ( com_rec(A1,F1,F2,F3,F4,F5,F6,F7,F8,skip) = F1 ) ).

tff(fact_41_com_Orecs_I4_J,axiom,
    ! [A1: $tType,Com2: com,Com1: com,F8: fun(vname,fun(pname,fun(fun(state,nat),A1))),F7: fun(pname,A1),F6: fun(fun(state,bool),fun(com,fun(A1,A1))),F5: fun(fun(state,bool),fun(com,fun(com,fun(A1,fun(A1,A1))))),F4: fun(com,fun(com,fun(A1,fun(A1,A1)))),F3: fun(loc,fun(fun(state,nat),fun(com,fun(A1,A1)))),F2: fun(vname,fun(fun(state,nat),A1)),F1: A1] : ( com_rec(A1,F1,F2,F3,F4,F5,F6,F7,F8,semi(Com1,Com2)) = aa(A1,A1,aa(A1,fun(A1,A1),aa(com,fun(A1,fun(A1,A1)),aa(com,fun(com,fun(A1,fun(A1,A1))),F4,Com1),Com2),com_rec(A1,F1,F2,F3,F4,F5,F6,F7,F8,Com1)),com_rec(A1,F1,F2,F3,F4,F5,F6,F7,F8,Com2)) ) ).

tff(fact_42_com_Orecs_I5_J,axiom,
    ! [A1: $tType,Com2: com,Com1: com,Fun1: fun(state,bool),F8: fun(vname,fun(pname,fun(fun(state,nat),A1))),F7: fun(pname,A1),F6: fun(fun(state,bool),fun(com,fun(A1,A1))),F5: fun(fun(state,bool),fun(com,fun(com,fun(A1,fun(A1,A1))))),F4: fun(com,fun(com,fun(A1,fun(A1,A1)))),F3: fun(loc,fun(fun(state,nat),fun(com,fun(A1,A1)))),F2: fun(vname,fun(fun(state,nat),A1)),F1: A1] : ( com_rec(A1,F1,F2,F3,F4,F5,F6,F7,F8,cond(Fun1,Com1,Com2)) = aa(A1,A1,aa(A1,fun(A1,A1),aa(com,fun(A1,fun(A1,A1)),aa(com,fun(com,fun(A1,fun(A1,A1))),aa(fun(state,bool),fun(com,fun(com,fun(A1,fun(A1,A1)))),F5,Fun1),Com1),Com2),com_rec(A1,F1,F2,F3,F4,F5,F6,F7,F8,Com1)),com_rec(A1,F1,F2,F3,F4,F5,F6,F7,F8,Com2)) ) ).

tff(fact_43_com_Osimps_I1_J,axiom,
    ! [Fun: fun(state,nat),Vname: vname,Fun1: fun(state,nat),Vname1: vname] :
      ( ( ass(Vname1,Fun1) = ass(Vname,Fun) )
    <=> ( ( Vname1 = Vname )
        & ( Fun1 = Fun ) ) ) ).

tff(fact_44_com_Osimps_I2_J,axiom,
    ! [Com3: com,Fun: fun(state,nat),Loc1: loc,Com: com,Fun1: fun(state,nat),Loc: loc] :
      ( ( local(Loc,Fun1,Com) = local(Loc1,Fun,Com3) )
    <=> ( ( Loc = Loc1 )
        & ( Fun1 = Fun )
        & ( Com = Com3 ) ) ) ).

tff(fact_45_com_Osimps_I22_J,axiom,
    ! [Com3: com,Fun: fun(state,nat),Loc1: loc,Fun1: fun(state,nat),Vname1: vname] : ( ass(Vname1,Fun1) != local(Loc1,Fun,Com3) ) ).

tff(fact_46_com_Osimps_I23_J,axiom,
    ! [Fun1: fun(state,nat),Vname1: vname,Com3: com,Fun: fun(state,nat),Loc1: loc] : ( local(Loc1,Fun,Com3) != ass(Vname1,Fun1) ) ).

tff(fact_47_com_Orecs_I2_J,axiom,
    ! [A1: $tType,Fun1: fun(state,nat),Vname1: vname,F8: fun(vname,fun(pname,fun(fun(state,nat),A1))),F7: fun(pname,A1),F6: fun(fun(state,bool),fun(com,fun(A1,A1))),F5: fun(fun(state,bool),fun(com,fun(com,fun(A1,fun(A1,A1))))),F4: fun(com,fun(com,fun(A1,fun(A1,A1)))),F3: fun(loc,fun(fun(state,nat),fun(com,fun(A1,A1)))),F2: fun(vname,fun(fun(state,nat),A1)),F1: A1] : ( com_rec(A1,F1,F2,F3,F4,F5,F6,F7,F8,ass(Vname1,Fun1)) = aa(fun(state,nat),A1,aa(vname,fun(fun(state,nat),A1),F2,Vname1),Fun1) ) ).

tff(fact_48_com_Orecs_I3_J,axiom,
    ! [A1: $tType,Com: com,Fun1: fun(state,nat),Loc: loc,F8: fun(vname,fun(pname,fun(fun(state,nat),A1))),F7: fun(pname,A1),F6: fun(fun(state,bool),fun(com,fun(A1,A1))),F5: fun(fun(state,bool),fun(com,fun(com,fun(A1,fun(A1,A1))))),F4: fun(com,fun(com,fun(A1,fun(A1,A1)))),F3: fun(loc,fun(fun(state,nat),fun(com,fun(A1,A1)))),F2: fun(vname,fun(fun(state,nat),A1)),F1: A1] : ( com_rec(A1,F1,F2,F3,F4,F5,F6,F7,F8,local(Loc,Fun1,Com)) = aa(A1,A1,aa(com,fun(A1,A1),aa(fun(state,nat),fun(com,fun(A1,A1)),aa(loc,fun(fun(state,nat),fun(com,fun(A1,A1))),F3,Loc),Fun1),Com),com_rec(A1,F1,F2,F3,F4,F5,F6,F7,F8,Com)) ) ).

tff(fact_49_WT_OAssign,axiom,
    ! [A: fun(state,nat),X: vname] : wt(ass(X,A)) ).

tff(fact_50_WT_OLocal,axiom,
    ! [A: fun(state,nat),Y: loc,Ca: com] :
      ( wt(Ca)
     => wt(local(Y,A,Ca)) ) ).

tff(fact_51_com_Osimps_I38_J,axiom,
    ! [Com3: com,Fun: fun(state,bool),Com: com,Fun1: fun(state,nat),Loc: loc] : ( local(Loc,Fun1,Com) != while(Fun,Com3) ) ).

tff(fact_52_com_Osimps_I39_J,axiom,
    ! [Com: com,Fun1: fun(state,nat),Loc: loc,Com3: com,Fun: fun(state,bool)] : ( while(Fun,Com3) != local(Loc,Fun1,Com) ) ).

tff(fact_53_com_Osimps_I29_J,axiom,
    ! [Fun1: fun(state,nat),Vname1: vname,Com3: com,Fun: fun(state,bool)] : ( while(Fun,Com3) != ass(Vname1,Fun1) ) ).

tff(fact_54_com_Osimps_I28_J,axiom,
    ! [Com3: com,Fun: fun(state,bool),Fun1: fun(state,nat),Vname1: vname] : ( ass(Vname1,Fun1) != while(Fun,Com3) ) ).

tff(fact_55_com_Osimps_I36_J,axiom,
    ! [Com21: com,Com11: com,Fun: fun(state,bool),Com: com,Fun1: fun(state,nat),Loc: loc] : ( local(Loc,Fun1,Com) != cond(Fun,Com11,Com21) ) ).

tff(fact_56_com_Osimps_I37_J,axiom,
    ! [Com: com,Fun1: fun(state,nat),Loc: loc,Com21: com,Com11: com,Fun: fun(state,bool)] : ( cond(Fun,Com11,Com21) != local(Loc,Fun1,Com) ) ).

tff(fact_57_com_Osimps_I27_J,axiom,
    ! [Fun1: fun(state,nat),Vname1: vname,Com21: com,Com11: com,Fun: fun(state,bool)] : ( cond(Fun,Com11,Com21) != ass(Vname1,Fun1) ) ).

tff(fact_58_com_Osimps_I26_J,axiom,
    ! [Com21: com,Com11: com,Fun: fun(state,bool),Fun1: fun(state,nat),Vname1: vname] : ( ass(Vname1,Fun1) != cond(Fun,Com11,Com21) ) ).

tff(fact_59_com_Osimps_I34_J,axiom,
    ! [Com21: com,Com11: com,Com: com,Fun1: fun(state,nat),Loc: loc] : ( local(Loc,Fun1,Com) != semi(Com11,Com21) ) ).

tff(fact_60_com_Osimps_I35_J,axiom,
    ! [Com: com,Fun1: fun(state,nat),Loc: loc,Com21: com,Com11: com] : ( semi(Com11,Com21) != local(Loc,Fun1,Com) ) ).

tff(fact_61_com_Osimps_I25_J,axiom,
    ! [Fun1: fun(state,nat),Vname1: vname,Com21: com,Com11: com] : ( semi(Com11,Com21) != ass(Vname1,Fun1) ) ).

tff(fact_62_com_Osimps_I24_J,axiom,
    ! [Com21: com,Com11: com,Fun1: fun(state,nat),Vname1: vname] : ( ass(Vname1,Fun1) != semi(Com11,Com21) ) ).

tff(fact_63_com_Osimps_I11_J,axiom,
    ! [Com3: com,Fun: fun(state,nat),Loc1: loc] : ( local(Loc1,Fun,Com3) != skip ) ).

tff(fact_64_com_Osimps_I9_J,axiom,
    ! [Fun: fun(state,nat),Vname: vname] : ( ass(Vname,Fun) != skip ) ).

tff(fact_65_com_Osimps_I10_J,axiom,
    ! [Com3: com,Fun: fun(state,nat),Loc1: loc] : ( skip != local(Loc1,Fun,Com3) ) ).

tff(fact_66_com_Osimps_I8_J,axiom,
    ! [Fun: fun(state,nat),Vname: vname] : ( skip != ass(Vname,Fun) ) ).

tff(fact_67_com_Osimps_I65_J,axiom,
    ! [A1: $tType,Fun1: fun(state,nat),Vname1: vname,F8: fun(vname,fun(pname,fun(fun(state,nat),A1))),F7: fun(pname,A1),F6: fun(fun(state,bool),fun(com,A1)),F5: fun(fun(state,bool),fun(com,fun(com,A1))),F4: fun(com,fun(com,A1)),F3: fun(loc,fun(fun(state,nat),fun(com,A1))),F2: fun(vname,fun(fun(state,nat),A1)),F1: A1] : ( com_case(A1,F1,F2,F3,F4,F5,F6,F7,F8,ass(Vname1,Fun1)) = aa(fun(state,nat),A1,aa(vname,fun(fun(state,nat),A1),F2,Vname1),Fun1) ) ).

tff(fact_68_com_Osimps_I66_J,axiom,
    ! [A1: $tType,Com: com,Fun1: fun(state,nat),Loc: loc,F8: fun(vname,fun(pname,fun(fun(state,nat),A1))),F7: fun(pname,A1),F6: fun(fun(state,bool),fun(com,A1)),F5: fun(fun(state,bool),fun(com,fun(com,A1))),F4: fun(com,fun(com,A1)),F3: fun(loc,fun(fun(state,nat),fun(com,A1))),F2: fun(vname,fun(fun(state,nat),A1)),F1: A1] : ( com_case(A1,F1,F2,F3,F4,F5,F6,F7,F8,local(Loc,Fun1,Com)) = aa(com,A1,aa(fun(state,nat),fun(com,A1),aa(loc,fun(fun(state,nat),fun(com,A1)),F3,Loc),Fun1),Com) ) ).

tff(fact_69_com_Orecs_I6_J,axiom,
    ! [A1: $tType,Com: com,Fun1: fun(state,bool),F8: fun(vname,fun(pname,fun(fun(state,nat),A1))),F7: fun(pname,A1),F6: fun(fun(state,bool),fun(com,fun(A1,A1))),F5: fun(fun(state,bool),fun(com,fun(com,fun(A1,fun(A1,A1))))),F4: fun(com,fun(com,fun(A1,fun(A1,A1)))),F3: fun(loc,fun(fun(state,nat),fun(com,fun(A1,A1)))),F2: fun(vname,fun(fun(state,nat),A1)),F1: A1] : ( com_rec(A1,F1,F2,F3,F4,F5,F6,F7,F8,while(Fun1,Com)) = aa(A1,A1,aa(com,fun(A1,A1),aa(fun(state,bool),fun(com,fun(A1,A1)),F6,Fun1),Com),com_rec(A1,F1,F2,F3,F4,F5,F6,F7,F8,Com)) ) ).

tff(fact_70_evalc__elim__cases_I2_J,axiom,
    ! [T: state,S: state,A: fun(state,nat),X: vname] :
      ( evalc(ass(X,A),S,T)
     => ( T = update(S,X,aa(state,nat,A,S)) ) ) ).

tff(fact_71_evalc_OAssign,axiom,
    ! [S: state,A: fun(state,nat),X: vname] : evalc(ass(X,A),S,update(S,X,aa(state,nat,A,S))) ).

tff(fact_72_com_Osimps_I71_J,axiom,
    ! [A1: $tType,Fun1: fun(state,nat),Pname1: pname,Vname1: vname,F8: fun(vname,fun(pname,fun(fun(state,nat),A1))),F7: fun(pname,A1),F6: fun(fun(state,bool),fun(com,A1)),F5: fun(fun(state,bool),fun(com,fun(com,A1))),F4: fun(com,fun(com,A1)),F3: fun(loc,fun(fun(state,nat),fun(com,A1))),F2: fun(vname,fun(fun(state,nat),A1)),F1: A1] : ( com_case(A1,F1,F2,F3,F4,F5,F6,F7,F8,call(Vname1,Pname1,Fun1)) = aa(fun(state,nat),A1,aa(pname,fun(fun(state,nat),A1),aa(vname,fun(pname,fun(fun(state,nat),A1)),F8,Vname1),Pname1),Fun1) ) ).

tff(fact_73_evaln__elim__cases_I1_J,axiom,
    ! [T1: state,N1: nat,S2: state] :
      ( evaln(skip,S2,N1,T1)
     => ( T1 = S2 ) ) ).

tff(fact_74_com_Osimps_I7_J,axiom,
    ! [Fun: fun(state,nat),Pname: pname,Vname: vname,Fun1: fun(state,nat),Pname1: pname,Vname1: vname] :
      ( ( call(Vname1,Pname1,Fun1) = call(Vname,Pname,Fun) )
    <=> ( ( Vname1 = Vname )
        & ( Pname1 = Pname )
        & ( Fun1 = Fun ) ) ) ).

tff(fact_75_evaln_OWhileFalse,axiom,
    ! [N2: nat,Ca: com,S: state,B: fun(state,bool)] :
      ( ~ pp(aa(state,bool,B,S))
     => evaln(while(B,Ca),S,N2,S) ) ).

tff(fact_76_evaln_OWhileTrue,axiom,
    ! [S22: state,S12: state,N2: nat,Ca: com,S01: state,B: fun(state,bool)] :
      ( pp(aa(state,bool,B,S01))
     => ( evaln(Ca,S01,N2,S12)
       => ( evaln(while(B,Ca),S12,N2,S22)
         => evaln(while(B,Ca),S01,N2,S22) ) ) ) ).

tff(fact_77_evaln_OIfFalse,axiom,
    ! [C01: com,S12: state,N2: nat,C11: com,S: state,B: fun(state,bool)] :
      ( ~ pp(aa(state,bool,B,S))
     => ( evaln(C11,S,N2,S12)
       => evaln(cond(B,C01,C11),S,N2,S12) ) ) ).

tff(fact_78_evaln_OIfTrue,axiom,
    ! [C11: com,S12: state,N2: nat,C01: com,S: state,B: fun(state,bool)] :
      ( pp(aa(state,bool,B,S))
     => ( evaln(C01,S,N2,S12)
       => evaln(cond(B,C01,C11),S,N2,S12) ) ) ).

tff(fact_79_evaln__elim__cases_I5_J,axiom,
    ! [T: state,N2: nat,S: state,C2: com,C11: com,B: fun(state,bool)] :
      ( evaln(cond(B,C11,C2),S,N2,T)
     => ( ( pp(aa(state,bool,B,S))
         => ~ evaln(C11,S,N2,T) )
       => ~ ( ~ pp(aa(state,bool,B,S))
           => ~ evaln(C2,S,N2,T) ) ) ) ).

tff(fact_80_evaln_OSemi,axiom,
    ! [S21: state,C1: com,S11: state,N1: nat,S0: state,C0: com] :
      ( evaln(C0,S0,N1,S11)
     => ( evaln(C1,S11,N1,S21)
       => evaln(semi(C0,C1),S0,N1,S21) ) ) ).

tff(fact_81_evaln_OSkip,axiom,
    ! [N1: nat,S2: state] : evaln(skip,S2,N1,S2) ).

tff(fact_82_evaln_OAssign,axiom,
    ! [N2: nat,S: state,A: fun(state,nat),X: vname] : evaln(ass(X,A),S,N2,update(S,X,aa(state,nat,A,S))) ).

tff(fact_83_evaln__elim__cases_I2_J,axiom,
    ! [T: state,N2: nat,S: state,A: fun(state,nat),X: vname] :
      ( evaln(ass(X,A),S,N2,T)
     => ( T = update(S,X,aa(state,nat,A,S)) ) ) ).

tff(fact_84_evaln__evalc,axiom,
    ! [T1: state,N1: nat,S2: state,C: com] :
      ( evaln(C,S2,N1,T1)
     => evalc(C,S2,T1) ) ).

tff(fact_85_eval__eq,axiom,
    ! [T: state,S: state,Ca: com] :
      ( evalc(Ca,S,T)
    <=> ? [N: nat] : evaln(Ca,S,N,T) ) ).

tff(fact_86_com_Osimps_I60_J,axiom,
    ! [Fun: fun(state,nat),Pname: pname,Vname: vname,Com: com,Fun1: fun(state,bool)] : ( while(Fun1,Com) != call(Vname,Pname,Fun) ) ).

tff(fact_87_com_Osimps_I61_J,axiom,
    ! [Com: com,Fun1: fun(state,bool),Fun: fun(state,nat),Pname: pname,Vname: vname] : ( call(Vname,Pname,Fun) != while(Fun1,Com) ) ).

tff(fact_88_com_Osimps_I57_J,axiom,
    ! [Com2: com,Com1: com,Fun1: fun(state,bool),Fun: fun(state,nat),Pname: pname,Vname: vname] : ( call(Vname,Pname,Fun) != cond(Fun1,Com1,Com2) ) ).

tff(fact_89_com_Osimps_I56_J,axiom,
    ! [Fun: fun(state,nat),Pname: pname,Vname: vname,Com2: com,Com1: com,Fun1: fun(state,bool)] : ( cond(Fun1,Com1,Com2) != call(Vname,Pname,Fun) ) ).

tff(fact_90_com_Osimps_I50_J,axiom,
    ! [Fun: fun(state,nat),Pname: pname,Vname: vname,Com2: com,Com1: com] : ( semi(Com1,Com2) != call(Vname,Pname,Fun) ) ).

tff(fact_91_com_Osimps_I51_J,axiom,
    ! [Com2: com,Com1: com,Fun: fun(state,nat),Pname: pname,Vname: vname] : ( call(Vname,Pname,Fun) != semi(Com1,Com2) ) ).

tff(fact_92_com_Osimps_I42_J,axiom,
    ! [Fun: fun(state,nat),Pname: pname,Vname: vname,Com: com,Fun1: fun(state,nat),Loc: loc] : ( local(Loc,Fun1,Com) != call(Vname,Pname,Fun) ) ).

tff(fact_93_com_Osimps_I43_J,axiom,
    ! [Com: com,Fun1: fun(state,nat),Loc: loc,Fun: fun(state,nat),Pname: pname,Vname: vname] : ( call(Vname,Pname,Fun) != local(Loc,Fun1,Com) ) ).

tff(fact_94_com_Osimps_I33_J,axiom,
    ! [Fun1: fun(state,nat),Vname1: vname,Fun: fun(state,nat),Pname: pname,Vname: vname] : ( call(Vname,Pname,Fun) != ass(Vname1,Fun1) ) ).

tff(fact_95_com_Osimps_I32_J,axiom,
    ! [Fun: fun(state,nat),Pname: pname,Vname: vname,Fun1: fun(state,nat),Vname1: vname] : ( ass(Vname1,Fun1) != call(Vname,Pname,Fun) ) ).

tff(fact_96_com_Osimps_I20_J,axiom,
    ! [Fun: fun(state,nat),Pname: pname,Vname: vname] : ( skip != call(Vname,Pname,Fun) ) ).

tff(fact_97_com_Osimps_I21_J,axiom,
    ! [Fun: fun(state,nat),Pname: pname,Vname: vname] : ( call(Vname,Pname,Fun) != skip ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (4)
tff(conj_0,hypothesis,
    hoare_531836380gleton ).

tff(conj_1,hypothesis,
    ! [Z: state] :
      ( ! [S1: state] :
          ( evalc(c,z,S1)
         => ( Z = S1 ) )
     => ( Z = s ) ) ).

tff(conj_2,hypothesis,
    ~ ? [X1: state] : evalc(c,z,X1) ).

tff(conj_3,conjecture,
    evalc(c,z,s) ).

%------------------------------------------------------------------------------
