%------------------------------------------------------------------------------
% File     : SWW524_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Hoare's Logic with Procedures line 316
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : hoare_316 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  169 (  48 unt;  42 typ;   0 def)
%            Number of atoms       :  284 ( 105 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  225 (  68   ~;  21   |;  22   &)
%                                         (  18 <=>;  96  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   17 (   6 avg)
%            Maximal term depth    :   13 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   35 (  21   >;  14   *;   0   +;   0  <<)
%            Number of predicates  :    6 (   5 usr;   1 prp; 0-3 aty)
%            Number of functors    :   34 (  34 usr;   9 con; 0-5 aty)
%            Number of variables   :  480 ( 436   !;  11   ?; 480   :)
%                                         (  33  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:23
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Com_Ocom,type,
    com: $tType ).

tff(ty_tc_Com_Ostate,type,
    state: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Hoare__Mirabelle__vtrypsmcwp_Otriple,type,
    hoare_28830079triple: $tType > $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (37)
tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( fun(B,C) > fun(fun(A,B),fun(A,C)) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(B,fun(A,C))) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_Com_Ocom_OCond,type,
    cond: ( fun(state,bool) * com * com ) > com ).

tff(sy_c_Com_Ocom_OSKIP,type,
    skip: com ).

tff(sy_c_Com_Ocom_OSemi,type,
    semi: ( com * com ) > com ).

tff(sy_c_Com_Ocom_OWhile,type,
    while: ( fun(state,bool) * com ) > com ).

tff(sy_c_Fun_Ocomp,type,
    comp: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_HOL_OThe,type,
    the: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_OMGT,type,
    hoare_Mirabelle_MGT: com > hoare_28830079triple(state) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Ohoare__derivs,type,
    hoare_992312373derivs: 
      !>[A: $tType] : ( ( fun(hoare_28830079triple(A),bool) * fun(hoare_28830079triple(A),bool) ) > $o ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Ohoare__valids,type,
    hoare_592965047valids: 
      !>[A: $tType] : ( ( fun(hoare_28830079triple(A),bool) * fun(hoare_28830079triple(A),bool) ) > $o ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Opeek__and,type,
    hoare_1442473487ek_and: 
      !>[A: $tType] : ( ( fun(A,fun(state,bool)) * fun(state,bool) ) > fun(A,fun(state,bool)) ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Ostate__not__singleton,type,
    hoare_531836380gleton: $o ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple,type,
    hoare_1841697145triple: 
      !>[A: $tType] : ( ( fun(A,fun(state,bool)) * com * fun(A,fun(state,bool)) ) > hoare_28830079triple(A) ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__case,type,
    hoare_376461865e_case: 
      !>[A: $tType,T4: $tType] : ( ( fun(fun(A,fun(state,bool)),fun(com,fun(fun(A,fun(state,bool)),T4))) * hoare_28830079triple(A) ) > T4 ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__rec,type,
    hoare_678420151le_rec: 
      !>[A: $tType,T4: $tType] : ( ( fun(fun(A,fun(state,bool)),fun(com,fun(fun(A,fun(state,bool)),T4))) * hoare_28830079triple(A) ) > T4 ) ).

tff(sy_c_Natural_Oevalc,type,
    evalc: com > fun(state,fun(state,bool)) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),fun(A,bool))) ).

tff(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fAll,type,
    fAll: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_G,type,
    g: fun(hoare_28830079triple(state),bool) ).

tff(sy_v_c,type,
    c: com ).

%----Relevant facts (100)
tff(fact_0_triple_Oinject,axiom,
    ! [A: $tType,Fun22: fun(A,fun(state,bool)),Com: com,Fun13: fun(A,fun(state,bool)),Fun21: fun(A,fun(state,bool)),Com4: com,Fun12: fun(A,fun(state,bool))] :
      ( ( hoare_1841697145triple(A,Fun12,Com4,Fun21) = hoare_1841697145triple(A,Fun13,Com,Fun22) )
    <=> ( ( Fun12 = Fun13 )
        & ( Com4 = Com )
        & ( Fun21 = Fun22 ) ) ) ).

tff(fact_1_empty,axiom,
    ! [A: $tType,Ga: fun(hoare_28830079triple(A),bool)] : hoare_992312373derivs(A,Ga,bot_bot(fun(hoare_28830079triple(A),bool))) ).

tff(fact_2_cut,axiom,
    ! [A: $tType,Ga: fun(hoare_28830079triple(A),bool),Ts: fun(hoare_28830079triple(A),bool),G1: fun(hoare_28830079triple(A),bool)] :
      ( hoare_992312373derivs(A,G1,Ts)
     => ( hoare_992312373derivs(A,Ga,G1)
       => hoare_992312373derivs(A,Ga,Ts) ) ) ).

tff(fact_3_hoare__derivs_Oinsert,axiom,
    ! [A: $tType,Ts: fun(hoare_28830079triple(A),bool),T: hoare_28830079triple(A),Ga: fun(hoare_28830079triple(A),bool)] :
      ( hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),T),bot_bot(fun(hoare_28830079triple(A),bool))))
     => ( hoare_992312373derivs(A,Ga,Ts)
       => hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),T),Ts)) ) ) ).

tff(fact_4_derivs__insertD,axiom,
    ! [A: $tType,Ts: fun(hoare_28830079triple(A),bool),T: hoare_28830079triple(A),Ga: fun(hoare_28830079triple(A),bool)] :
      ( hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),T),Ts))
     => ( hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),T),bot_bot(fun(hoare_28830079triple(A),bool))))
        & hoare_992312373derivs(A,Ga,Ts) ) ) ).

tff(fact_5_constant,axiom,
    ! [A: $tType,Q1: fun(A,fun(state,bool)),Ca: com,P1: fun(A,fun(state,bool)),Ga: fun(hoare_28830079triple(A),bool),C5: bool] :
      ( ( pp(C5)
       => hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,P1,Ca,Q1)),bot_bot(fun(hoare_28830079triple(A),bool)))) )
     => hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,aa(bool,fun(A,fun(state,bool)),aa(fun(A,fun(bool,fun(state,bool))),fun(bool,fun(A,fun(state,bool))),combc(A,bool,fun(state,bool)),aa(fun(A,fun(state,fun(bool,bool))),fun(A,fun(bool,fun(state,bool))),combb(fun(state,fun(bool,bool)),fun(bool,fun(state,bool)),A,combc(state,bool,bool)),aa(fun(A,fun(state,bool)),fun(A,fun(state,fun(bool,bool))),combb(fun(state,bool),fun(state,fun(bool,bool)),A,combb(bool,fun(bool,bool),state,fconj)),P1))),C5),Ca,Q1)),bot_bot(fun(hoare_28830079triple(A),bool)))) ) ).

tff(fact_6_MGT__alternI,axiom,
    ! [Ca: com,Ga: fun(hoare_28830079triple(state),bool)] :
      ( hoare_992312373derivs(state,Ga,aa(fun(hoare_28830079triple(state),bool),fun(hoare_28830079triple(state),bool),aa(hoare_28830079triple(state),fun(fun(hoare_28830079triple(state),bool),fun(hoare_28830079triple(state),bool)),insert(hoare_28830079triple(state)),hoare_Mirabelle_MGT(Ca)),bot_bot(fun(hoare_28830079triple(state),bool))))
     => hoare_992312373derivs(state,Ga,aa(fun(hoare_28830079triple(state),bool),fun(hoare_28830079triple(state),bool),aa(hoare_28830079triple(state),fun(fun(hoare_28830079triple(state),bool),fun(hoare_28830079triple(state),bool)),insert(hoare_28830079triple(state)),hoare_1841697145triple(state,aa(fun(state,fun(state,fun(state,bool))),fun(state,fun(state,bool)),combb(fun(state,fun(state,bool)),fun(state,bool),state,combb(fun(state,bool),bool,state,fAll(state))),aa(fun(state,fun(state,bool)),fun(state,fun(state,fun(state,bool))),combb(fun(state,bool),fun(state,fun(state,bool)),state,aa(fun(state,fun(fun(state,bool),fun(state,bool))),fun(fun(state,bool),fun(state,fun(state,bool))),combc(state,fun(state,bool),fun(state,bool)),aa(fun(state,fun(state,fun(bool,bool))),fun(state,fun(fun(state,bool),fun(state,bool))),combb(fun(state,fun(bool,bool)),fun(fun(state,bool),fun(state,bool)),state,combs(state,bool,bool)),aa(fun(state,fun(state,bool)),fun(state,fun(state,fun(bool,bool))),combb(fun(state,bool),fun(state,fun(bool,bool)),state,combb(bool,fun(bool,bool),state,fimplies)),evalc(Ca))))),fequal(state))),Ca,fequal(state))),bot_bot(fun(hoare_28830079triple(state),bool)))) ) ).

tff(fact_7_singleton__conv2,axiom,
    ! [A: $tType,A2: A] : ( collect(A,aa(A,fun(A,bool),fequal(A),A2)) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),A2),bot_bot(fun(A,bool))) ) ).

tff(fact_8_singleton__conv,axiom,
    ! [A: $tType,A2: A] : ( collect(A,aa(A,fun(A,bool),aa(fun(A,fun(A,bool)),fun(A,fun(A,bool)),combc(A,A,bool),fequal(A)),A2)) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),A2),bot_bot(fun(A,bool))) ) ).

tff(fact_9_escape,axiom,
    ! [A: $tType,Q1: fun(A,fun(state,bool)),Ca: com,Ga: fun(hoare_28830079triple(A),bool),P1: fun(A,fun(state,bool))] :
      ( ! [Z: A,S2: state] :
          ( pp(aa(state,bool,aa(A,fun(state,bool),P1,Z),S2))
         => hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,combk(fun(state,bool),A,aa(state,fun(state,bool),aa(fun(state,fun(state,bool)),fun(state,fun(state,bool)),combc(state,state,bool),fequal(state)),S2)),Ca,combk(fun(state,bool),A,aa(A,fun(state,bool),Q1,Z)))),bot_bot(fun(hoare_28830079triple(A),bool)))) )
     => hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,P1,Ca,Q1)),bot_bot(fun(hoare_28830079triple(A),bool)))) ) ).

tff(fact_10_conseq2,axiom,
    ! [A: $tType,Q1: fun(A,fun(state,bool)),Q3: fun(A,fun(state,bool)),Ca: com,P1: fun(A,fun(state,bool)),Ga: fun(hoare_28830079triple(A),bool)] :
      ( hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,P1,Ca,Q3)),bot_bot(fun(hoare_28830079triple(A),bool))))
     => ( ! [Z: A,S2: state] :
            ( pp(aa(state,bool,aa(A,fun(state,bool),Q3,Z),S2))
           => pp(aa(state,bool,aa(A,fun(state,bool),Q1,Z),S2)) )
       => hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,P1,Ca,Q1)),bot_bot(fun(hoare_28830079triple(A),bool)))) ) ) ).

tff(fact_11_conseq1,axiom,
    ! [A: $tType,P1: fun(A,fun(state,bool)),Q1: fun(A,fun(state,bool)),Ca: com,P4: fun(A,fun(state,bool)),Ga: fun(hoare_28830079triple(A),bool)] :
      ( hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,P4,Ca,Q1)),bot_bot(fun(hoare_28830079triple(A),bool))))
     => ( ! [Z: A,S2: state] :
            ( pp(aa(state,bool,aa(A,fun(state,bool),P1,Z),S2))
           => pp(aa(state,bool,aa(A,fun(state,bool),P4,Z),S2)) )
       => hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,P1,Ca,Q1)),bot_bot(fun(hoare_28830079triple(A),bool)))) ) ) ).

tff(fact_12_MGT__def,axiom,
    ! [Ca: com] : ( hoare_Mirabelle_MGT(Ca) = hoare_1841697145triple(state,fequal(state),Ca,evalc(Ca)) ) ).

tff(fact_13_state__not__singleton__def,axiom,
    ( hoare_531836380gleton
  <=> ? [S5: state,T3: state] : ( S5 != T3 ) ) ).

tff(fact_14_single__stateE,axiom,
    ( hoare_531836380gleton
   => ! [T2: state] :
        ~ ! [S2: state] : ( S2 = T2 ) ) ).

tff(fact_15_insert__absorb2,axiom,
    ! [A: $tType,A1: fun(A,bool),X3: A] : ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),X3),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),X3),A1)) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),X3),A1) ) ).

tff(fact_16_insert__iff,axiom,
    ! [A: $tType,A1: fun(A,bool),B1: A,A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),B1),A1)))
    <=> ( ( A2 = B1 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1)) ) ) ).

tff(fact_17_insertE,axiom,
    ! [A: $tType,A1: fun(A,bool),B1: A,A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),B1),A1)))
     => ( ( A2 != B1 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1)) ) ) ).

tff(fact_18_emptyE,axiom,
    ! [A: $tType,A2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),bot_bot(fun(A,bool)))) ).

tff(fact_19_Collect__empty__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( collect(A,P1) = bot_bot(fun(A,bool)) )
    <=> ! [X2: A] : ~ pp(aa(A,bool,P1,X2)) ) ).

tff(fact_20_empty__iff,axiom,
    ! [A: $tType,Ca: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Ca),bot_bot(fun(A,bool)))) ).

tff(fact_21_empty__Collect__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,P1) )
    <=> ! [X2: A] : ~ pp(aa(A,bool,P1,X2)) ) ).

tff(fact_22_all__not__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
    <=> ( A1 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_23_insertCI,axiom,
    ! [A: $tType,B1: A,B4: fun(A,bool),A2: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),B4))
       => ( A2 = B1 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),B1),B4))) ) ).

tff(fact_24_equals0D,axiom,
    ! [A: $tType,A2: A,A1: fun(A,bool)] :
      ( ( A1 = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1)) ) ).

tff(fact_25_ex__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ? [X2: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
    <=> ( A1 != bot_bot(fun(A,bool)) ) ) ).

tff(fact_26_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,combk(bool,A,fFalse)) ) ).

tff(fact_27_insert__absorb,axiom,
    ! [A: $tType,A1: fun(A,bool),A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1))
     => ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),A2),A1) = A1 ) ) ).

tff(fact_28_insertI2,axiom,
    ! [A: $tType,B1: A,B4: fun(A,bool),A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),B4))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),B1),B4))) ) ).

tff(fact_29_insert__eq__iff,axiom,
    ! [A: $tType,B4: fun(A,bool),B1: A,A1: fun(A,bool),A2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),B4))
       => ( ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),A2),A1) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),B1),B4) )
        <=> ( ( ( A2 = B1 )
             => ( A1 = B4 ) )
            & ( ( A2 != B1 )
             => ? [C4: fun(A,bool)] :
                  ( ( A1 = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),B1),C4) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),C4))
                  & ( B4 = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),A2),C4) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),C4)) ) ) ) ) ) ) ).

tff(fact_30_insert__ident,axiom,
    ! [A: $tType,B4: fun(A,bool),A1: fun(A,bool),X3: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),B4))
       => ( ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),X3),A1) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),X3),B4) )
        <=> ( A1 = B4 ) ) ) ) ).

tff(fact_31_insert__code,axiom,
    ! [A: $tType,X3: A,A1: fun(A,bool),Y2: A] :
      ( pp(aa(A,bool,aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),Y2),A1),X3))
    <=> ( ( Y2 = X3 )
        | pp(aa(A,bool,A1,X3)) ) ) ).

tff(fact_32_insert__commute,axiom,
    ! [A: $tType,A1: fun(A,bool),Y2: A,X3: A] : ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),X3),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),Y2),A1)) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),Y2),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),X3),A1)) ) ).

tff(fact_33_insert__Collect,axiom,
    ! [A: $tType,P1: fun(A,bool),A2: A] : ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),A2),collect(A,P1)) = collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),combb(bool,fun(bool,bool),A,fimplies),aa(fun(A,bool),fun(A,bool),combb(bool,bool,A,fNot),aa(A,fun(A,bool),aa(fun(A,fun(A,bool)),fun(A,fun(A,bool)),combc(A,A,bool),fequal(A)),A2)))),P1)) ) ).

tff(fact_34_insert__compr,axiom,
    ! [A: $tType,B4: fun(A,bool),A2: A] : ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),A2),B4) = collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),combb(bool,fun(bool,bool),A,fdisj),aa(A,fun(A,bool),aa(fun(A,fun(A,bool)),fun(A,fun(A,bool)),combc(A,A,bool),fequal(A)),A2))),aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(fun(A,bool),bool)),fun(fun(A,bool),fun(A,bool)),combc(A,fun(A,bool),bool),member(A)),B4))) ) ).

tff(fact_35_insertI1,axiom,
    ! [A: $tType,B4: fun(A,bool),A2: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),A2),B4))) ).

tff(fact_36_insert__compr__raw,axiom,
    ! [A: $tType,X1: A,Xa: fun(A,bool)] : ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),X1),Xa) = collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),combb(bool,fun(bool,bool),A,fdisj),aa(A,fun(A,bool),aa(fun(A,fun(A,bool)),fun(A,fun(A,bool)),combc(A,A,bool),fequal(A)),X1))),aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(fun(A,bool),bool)),fun(fun(A,bool),fun(A,bool)),combc(A,fun(A,bool),bool),member(A)),Xa))) ) ).

tff(fact_37_singleton__inject,axiom,
    ! [A: $tType,B1: A,A2: A] :
      ( ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),A2),bot_bot(fun(A,bool))) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),B1),bot_bot(fun(A,bool))) )
     => ( A2 = B1 ) ) ).

tff(fact_38_singletonE,axiom,
    ! [A: $tType,A2: A,B1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),A2),bot_bot(fun(A,bool)))))
     => ( B1 = A2 ) ) ).

tff(fact_39_doubleton__eq__iff,axiom,
    ! [A: $tType,D: A,Ca: A,B1: A,A2: A] :
      ( ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),A2),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),B1),bot_bot(fun(A,bool)))) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),Ca),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),D),bot_bot(fun(A,bool)))) )
    <=> ( ( ( A2 = Ca )
          & ( B1 = D ) )
        | ( ( A2 = D )
          & ( B1 = Ca ) ) ) ) ).

tff(fact_40_singleton__iff,axiom,
    ! [A: $tType,A2: A,B1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),A2),bot_bot(fun(A,bool)))))
    <=> ( B1 = A2 ) ) ).

tff(fact_41_insert__not__empty,axiom,
    ! [A: $tType,A1: fun(A,bool),A2: A] : ( aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),A2),A1) != bot_bot(fun(A,bool)) ) ).

tff(fact_42_empty__not__insert,axiom,
    ! [A: $tType,A1: fun(A,bool),A2: A] : ( bot_bot(fun(A,bool)) != aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),A2),A1) ) ).

tff(fact_43_Collect__conv__if,axiom,
    ! [A: $tType,A2: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,A2))
       => ( collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),combb(bool,fun(bool,bool),A,fconj),aa(A,fun(A,bool),aa(fun(A,fun(A,bool)),fun(A,fun(A,bool)),combc(A,A,bool),fequal(A)),A2))),P1)) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),A2),bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,A2))
       => ( collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),combb(bool,fun(bool,bool),A,fconj),aa(A,fun(A,bool),aa(fun(A,fun(A,bool)),fun(A,fun(A,bool)),combc(A,A,bool),fequal(A)),A2))),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_44_Collect__conv__if2,axiom,
    ! [A: $tType,A2: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,A2))
       => ( collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),combb(bool,fun(bool,bool),A,fconj),aa(A,fun(A,bool),fequal(A),A2))),P1)) = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),A2),bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,A2))
       => ( collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),combb(bool,fun(bool,bool),A,fconj),aa(A,fun(A,bool),fequal(A),A2))),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_45_conseq12,axiom,
    ! [A: $tType,Q1: fun(A,fun(state,bool)),P1: fun(A,fun(state,bool)),Q3: fun(A,fun(state,bool)),Ca: com,P4: fun(A,fun(state,bool)),Ga: fun(hoare_28830079triple(A),bool)] :
      ( hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,P4,Ca,Q3)),bot_bot(fun(hoare_28830079triple(A),bool))))
     => ( ! [Z: A,S2: state] :
            ( pp(aa(state,bool,aa(A,fun(state,bool),P1,Z),S2))
           => ! [S3: state] :
                ( ! [Z1: A] :
                    ( pp(aa(state,bool,aa(A,fun(state,bool),P4,Z1),S2))
                   => pp(aa(state,bool,aa(A,fun(state,bool),Q3,Z1),S3)) )
               => pp(aa(state,bool,aa(A,fun(state,bool),Q1,Z),S3)) ) )
       => hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,P1,Ca,Q1)),bot_bot(fun(hoare_28830079triple(A),bool)))) ) ) ).

tff(fact_46_the__elem__eq,axiom,
    ! [A: $tType,X3: A] : ( the_elem(A,aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),X3),bot_bot(fun(A,bool)))) = X3 ) ).

tff(fact_47_triple_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Fun21: fun(B,fun(state,bool)),Com4: com,Fun12: fun(B,fun(state,bool)),F1: fun(fun(B,fun(state,bool)),fun(com,fun(fun(B,fun(state,bool)),A)))] : ( hoare_376461865e_case(B,A,F1,hoare_1841697145triple(B,Fun12,Com4,Fun21)) = aa(fun(B,fun(state,bool)),A,aa(com,fun(fun(B,fun(state,bool)),A),aa(fun(B,fun(state,bool)),fun(com,fun(fun(B,fun(state,bool)),A)),F1,Fun12),Com4),Fun21) ) ).

tff(fact_48_triple_Orecs,axiom,
    ! [A: $tType,B: $tType,Fun21: fun(B,fun(state,bool)),Com4: com,Fun12: fun(B,fun(state,bool)),F1: fun(fun(B,fun(state,bool)),fun(com,fun(fun(B,fun(state,bool)),A)))] : ( hoare_678420151le_rec(B,A,F1,hoare_1841697145triple(B,Fun12,Com4,Fun21)) = aa(fun(B,fun(state,bool)),A,aa(com,fun(fun(B,fun(state,bool)),A),aa(fun(B,fun(state,bool)),fun(com,fun(fun(B,fun(state,bool)),A)),F1,Fun12),Com4),Fun21) ) ).

tff(fact_49_bot__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( bot(A)
     => ! [X3: B] : ( aa(B,A,bot_bot(fun(B,A)),X3) = bot_bot(A) ) ) ).

tff(fact_50_bot__fun__def,axiom,
    ! [A: $tType,B: $tType] :
      ( bot(B)
     => ! [X1: A] : ( aa(A,B,bot_bot(fun(A,B)),X1) = bot_bot(B) ) ) ).

tff(fact_51_hoare__derivs_OSkip,axiom,
    ! [A: $tType,P1: fun(A,fun(state,bool)),Ga: fun(hoare_28830079triple(A),bool)] : hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,P1,skip,P1)),bot_bot(fun(hoare_28830079triple(A),bool)))) ).

tff(fact_52_LoopF,axiom,
    ! [A: $tType,Ca: com,B1: fun(state,bool),P1: fun(A,fun(state,bool)),Ga: fun(hoare_28830079triple(A),bool)] : hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,aa(fun(state,bool),fun(A,fun(state,bool)),aa(fun(A,fun(fun(state,bool),fun(state,bool))),fun(fun(state,bool),fun(A,fun(state,bool))),combc(A,fun(state,bool),fun(state,bool)),aa(fun(A,fun(state,fun(bool,bool))),fun(A,fun(fun(state,bool),fun(state,bool))),combb(fun(state,fun(bool,bool)),fun(fun(state,bool),fun(state,bool)),A,combs(state,bool,bool)),aa(fun(A,fun(state,bool)),fun(A,fun(state,fun(bool,bool))),combb(fun(state,bool),fun(state,fun(bool,bool)),A,combb(bool,fun(bool,bool),state,fconj)),P1))),aa(fun(state,bool),fun(state,bool),combb(bool,bool,state,fNot),B1)),while(B1,Ca),P1)),bot_bot(fun(hoare_28830079triple(A),bool)))) ).

tff(fact_53_evalc_OSkip,axiom,
    ! [S4: state] : pp(aa(state,bool,aa(state,fun(state,bool),evalc(skip),S4),S4)) ).

tff(fact_54_evalc__elim__cases_I1_J,axiom,
    ! [T1: state,S4: state] :
      ( pp(aa(state,bool,aa(state,fun(state,bool),evalc(skip),S4),T1))
     => ( T1 = S4 ) ) ).

tff(fact_55_evalc_OWhileFalse,axiom,
    ! [Ca: com,S: state,B1: fun(state,bool)] :
      ( ~ pp(aa(state,bool,B1,S))
     => pp(aa(state,bool,aa(state,fun(state,bool),evalc(while(B1,Ca)),S),S)) ) ).

tff(fact_56_evalc_OWhileTrue,axiom,
    ! [S22: state,S1: state,Ca: com,S01: state,B1: fun(state,bool)] :
      ( pp(aa(state,bool,B1,S01))
     => ( pp(aa(state,bool,aa(state,fun(state,bool),evalc(Ca),S01),S1))
       => ( pp(aa(state,bool,aa(state,fun(state,bool),evalc(while(B1,Ca)),S1),S22))
         => pp(aa(state,bool,aa(state,fun(state,bool),evalc(while(B1,Ca)),S01),S22)) ) ) ) ).

tff(fact_57_com__det,axiom,
    ! [U: state,T1: state,S4: state,C3: com] :
      ( pp(aa(state,bool,aa(state,fun(state,bool),evalc(C3),S4),T1))
     => ( pp(aa(state,bool,aa(state,fun(state,bool),evalc(C3),S4),U))
       => ( U = T1 ) ) ) ).

tff(fact_58_com_Osimps_I5_J,axiom,
    ! [Com: com,Fun: fun(state,bool),Com4: com,Fun1: fun(state,bool)] :
      ( ( while(Fun1,Com4) = while(Fun,Com) )
    <=> ( ( Fun1 = Fun )
        & ( Com4 = Com ) ) ) ).

tff(fact_59_evalc__WHILE__case,axiom,
    ! [T: state,S: state,Ca: com,B1: fun(state,bool)] :
      ( pp(aa(state,bool,aa(state,fun(state,bool),evalc(while(B1,Ca)),S),T))
     => ( ( ( T = S )
         => pp(aa(state,bool,B1,S)) )
       => ~ ( pp(aa(state,bool,B1,S))
           => ! [S11: state] :
                ( pp(aa(state,bool,aa(state,fun(state,bool),evalc(Ca),S),S11))
               => ~ pp(aa(state,bool,aa(state,fun(state,bool),evalc(while(B1,Ca)),S11),T)) ) ) ) ) ).

tff(fact_60_com_Osimps_I16_J,axiom,
    ! [Com: com,Fun: fun(state,bool)] : ( skip != while(Fun,Com) ) ).

tff(fact_61_com_Osimps_I17_J,axiom,
    ! [Com: com,Fun: fun(state,bool)] : ( while(Fun,Com) != skip ) ).

tff(fact_62_Comp,axiom,
    ! [A: $tType,R1: fun(A,fun(state,bool)),D: com,Q1: fun(A,fun(state,bool)),Ca: com,P1: fun(A,fun(state,bool)),Ga: fun(hoare_28830079triple(A),bool)] :
      ( hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,P1,Ca,Q1)),bot_bot(fun(hoare_28830079triple(A),bool))))
     => ( hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,Q1,D,R1)),bot_bot(fun(hoare_28830079triple(A),bool))))
       => hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,P1,semi(Ca,D),R1)),bot_bot(fun(hoare_28830079triple(A),bool)))) ) ) ).

tff(fact_63_the__elem__def,axiom,
    ! [A: $tType,X5: fun(A,bool)] : ( the_elem(A,X5) = the(A,aa(fun(A,fun(A,bool)),fun(A,bool),combb(fun(A,bool),bool,A,aa(fun(A,bool),fun(fun(A,bool),bool),fequal(fun(A,bool)),X5)),aa(fun(A,bool),fun(A,fun(A,bool)),aa(fun(A,fun(fun(A,bool),fun(A,bool))),fun(fun(A,bool),fun(A,fun(A,bool))),combc(A,fun(A,bool),fun(A,bool)),insert(A)),bot_bot(fun(A,bool))))) ) ).

tff(fact_64_triple_Oexhaust,axiom,
    ! [A: $tType,Y2: hoare_28830079triple(A)] :
      ~ ! [Fun11: fun(A,fun(state,bool)),Com3: com,Fun2: fun(A,fun(state,bool))] : ( Y2 != hoare_1841697145triple(A,Fun11,Com3,Fun2) ) ).

tff(fact_65_com_Osimps_I3_J,axiom,
    ! [Com21: com,Com11: com,Com2: com,Com1: com] :
      ( ( semi(Com1,Com2) = semi(Com11,Com21) )
    <=> ( ( Com1 = Com11 )
        & ( Com2 = Com21 ) ) ) ).

tff(fact_66_evalc_OSemi,axiom,
    ! [S21: state,C11: com,S12: state,S0: state,C01: com] :
      ( pp(aa(state,bool,aa(state,fun(state,bool),evalc(C01),S0),S12))
     => ( pp(aa(state,bool,aa(state,fun(state,bool),evalc(C11),S12),S21))
       => pp(aa(state,bool,aa(state,fun(state,bool),evalc(semi(C01,C11)),S0),S21)) ) ) ).

tff(fact_67_com_Osimps_I12_J,axiom,
    ! [Com22: com,Com12: com] : ( skip != semi(Com12,Com22) ) ).

tff(fact_68_com_Osimps_I13_J,axiom,
    ! [Com22: com,Com12: com] : ( semi(Com12,Com22) != skip ) ).

tff(fact_69_com_Osimps_I46_J,axiom,
    ! [Com: com,Fun: fun(state,bool),Com2: com,Com1: com] : ( semi(Com1,Com2) != while(Fun,Com) ) ).

tff(fact_70_com_Osimps_I47_J,axiom,
    ! [Com2: com,Com1: com,Com: com,Fun: fun(state,bool)] : ( while(Fun,Com) != semi(Com1,Com2) ) ).

tff(fact_71_evalc__elim__cases_I4_J,axiom,
    ! [T1: state,S4: state,C21: com,C11: com] :
      ( pp(aa(state,bool,aa(state,fun(state,bool),evalc(semi(C11,C21)),S4),T1))
     => ~ ! [S11: state] :
            ( pp(aa(state,bool,aa(state,fun(state,bool),evalc(C11),S4),S11))
           => ~ pp(aa(state,bool,aa(state,fun(state,bool),evalc(C21),S11),T1)) ) ) ).

tff(fact_72_the__sym__eq__trivial,axiom,
    ! [A: $tType,X3: A] : ( the(A,aa(A,fun(A,bool),fequal(A),X3)) = X3 ) ).

tff(fact_73_the__eq__trivial,axiom,
    ! [A: $tType,A2: A] : ( the(A,aa(A,fun(A,bool),aa(fun(A,fun(A,bool)),fun(A,fun(A,bool)),combc(A,A,bool),fequal(A)),A2)) = A2 ) ).

tff(fact_74_If__def,axiom,
    ! [A: $tType,Y2: A,X3: A,P1: bool] :
      ( ( pp(P1)
       => ( X3 = the(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),combb(bool,fun(bool,bool),A,fconj),aa(fun(A,bool),fun(A,bool),combb(bool,bool,A,aa(bool,fun(bool,bool),fimplies,P1)),aa(A,fun(A,bool),aa(fun(A,fun(A,bool)),fun(A,fun(A,bool)),combc(A,A,bool),fequal(A)),X3)))),aa(fun(A,bool),fun(A,bool),combb(bool,bool,A,aa(bool,fun(bool,bool),fimplies,aa(bool,bool,fNot,P1))),aa(A,fun(A,bool),aa(fun(A,fun(A,bool)),fun(A,fun(A,bool)),combc(A,A,bool),fequal(A)),Y2)))) ) )
      & ( ~ pp(P1)
       => ( Y2 = the(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),combb(bool,fun(bool,bool),A,fconj),aa(fun(A,bool),fun(A,bool),combb(bool,bool,A,aa(bool,fun(bool,bool),fimplies,P1)),aa(A,fun(A,bool),aa(fun(A,fun(A,bool)),fun(A,fun(A,bool)),combc(A,A,bool),fequal(A)),X3)))),aa(fun(A,bool),fun(A,bool),combb(bool,bool,A,aa(bool,fun(bool,bool),fimplies,aa(bool,bool,fNot,P1))),aa(A,fun(A,bool),aa(fun(A,fun(A,bool)),fun(A,fun(A,bool)),combc(A,A,bool),fequal(A)),Y2)))) ) ) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X4: A] : ( aa(A,B,F,X4) = aa(A,B,G,X4) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A1))
    <=> pp(aa(A,bool,A1,X3)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_78_the__equality,axiom,
    ! [A: $tType,A2: A,P1: fun(A,bool)] :
      ( pp(aa(A,bool,P1,A2))
     => ( ! [X4: A] :
            ( pp(aa(A,bool,P1,X4))
           => ( X4 = A2 ) )
       => ( the(A,P1) = A2 ) ) ) ).

tff(fact_79_theI,axiom,
    ! [A: $tType,A2: A,P1: fun(A,bool)] :
      ( pp(aa(A,bool,P1,A2))
     => ( ! [X4: A] :
            ( pp(aa(A,bool,P1,X4))
           => ( X4 = A2 ) )
       => pp(aa(A,bool,P1,the(A,P1))) ) ) ).

tff(fact_80_theI_H,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ? [X1: A] :
          ( pp(aa(A,bool,P1,X1))
          & ! [Y1: A] :
              ( pp(aa(A,bool,P1,Y1))
             => ( Y1 = X1 ) ) )
     => pp(aa(A,bool,P1,the(A,P1))) ) ).

tff(fact_81_the1__equality,axiom,
    ! [A: $tType,A2: A,P1: fun(A,bool)] :
      ( ? [X1: A] :
          ( pp(aa(A,bool,P1,X1))
          & ! [Y1: A] :
              ( pp(aa(A,bool,P1,Y1))
             => ( Y1 = X1 ) ) )
     => ( pp(aa(A,bool,P1,A2))
       => ( the(A,P1) = A2 ) ) ) ).

tff(fact_82_mk__disjoint__insert,axiom,
    ! [A: $tType,A1: fun(A,bool),A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1))
     => ? [B3: fun(A,bool)] :
          ( ( A1 = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),A2),B3) )
          & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),B3)) ) ) ).

tff(fact_83_Set_Oset__insert,axiom,
    ! [A: $tType,A1: fun(A,bool),X3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A1))
     => ~ ! [B3: fun(A,bool)] :
            ( ( A1 = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),X3),B3) )
           => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),B3)) ) ) ).

tff(fact_84_equals0I,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [Y1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),A1))
     => ( A1 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_85_conseq,axiom,
    ! [A: $tType,Q1: fun(A,fun(state,bool)),Ca: com,Ga: fun(hoare_28830079triple(A),bool),P1: fun(A,fun(state,bool))] :
      ( ! [Z: A,S2: state] :
          ( pp(aa(state,bool,aa(A,fun(state,bool),P1,Z),S2))
         => ? [P3: fun(A,fun(state,bool)),Q2: fun(A,fun(state,bool))] :
              ( hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,P3,Ca,Q2)),bot_bot(fun(hoare_28830079triple(A),bool))))
              & ! [S3: state] :
                  ( ! [Z1: A] :
                      ( pp(aa(state,bool,aa(A,fun(state,bool),P3,Z1),S2))
                     => pp(aa(state,bool,aa(A,fun(state,bool),Q2,Z1),S3)) )
                 => pp(aa(state,bool,aa(A,fun(state,bool),Q1,Z),S3)) ) ) )
     => hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,P1,Ca,Q1)),bot_bot(fun(hoare_28830079triple(A),bool)))) ) ).

tff(fact_86_Loop,axiom,
    ! [A: $tType,Ca: com,B1: fun(state,bool),P1: fun(A,fun(state,bool)),Ga: fun(hoare_28830079triple(A),bool)] :
      ( hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,hoare_1442473487ek_and(A,P1,B1),Ca,P1)),bot_bot(fun(hoare_28830079triple(A),bool))))
     => hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,P1,while(B1,Ca),hoare_1442473487ek_and(A,P1,comp(bool,bool,state,fNot,B1)))),bot_bot(fun(hoare_28830079triple(A),bool)))) ) ).

tff(fact_87_nonempty__iff,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ( A1 != bot_bot(fun(A,bool)) )
    <=> ? [X2: A,B2: fun(A,bool)] :
          ( ( A1 = aa(fun(A,bool),fun(A,bool),aa(A,fun(fun(A,bool),fun(A,bool)),insert(A),X2),B2) )
          & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B2)) ) ) ).

tff(fact_88_peek__and__def,axiom,
    ! [A: $tType,P2: fun(state,bool),P1: fun(A,fun(state,bool)),X1: A,Xa: state] :
      ( pp(aa(state,bool,aa(A,fun(state,bool),hoare_1442473487ek_and(A,P1,P2),X1),Xa))
    <=> ( pp(aa(state,bool,aa(A,fun(state,bool),P1,X1),Xa))
        & pp(aa(state,bool,P2,Xa)) ) ) ).

tff(fact_89_Loop__sound__lemma,axiom,
    ! [A: $tType,Ca: com,B1: fun(state,bool),P1: fun(A,fun(state,bool)),Ga: fun(hoare_28830079triple(A),bool)] :
      ( hoare_592965047valids(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,hoare_1442473487ek_and(A,P1,B1),Ca,P1)),bot_bot(fun(hoare_28830079triple(A),bool))))
     => hoare_592965047valids(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,P1,while(B1,Ca),hoare_1442473487ek_and(A,P1,comp(bool,bool,state,fNot,B1)))),bot_bot(fun(hoare_28830079triple(A),bool)))) ) ).

tff(fact_90_hoare__derivs_OIf,axiom,
    ! [A: $tType,D: com,Q1: fun(A,fun(state,bool)),Ca: com,B1: fun(state,bool),P1: fun(A,fun(state,bool)),Ga: fun(hoare_28830079triple(A),bool)] :
      ( hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,hoare_1442473487ek_and(A,P1,B1),Ca,Q1)),bot_bot(fun(hoare_28830079triple(A),bool))))
     => ( hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,hoare_1442473487ek_and(A,P1,comp(bool,bool,state,fNot,B1)),D,Q1)),bot_bot(fun(hoare_28830079triple(A),bool))))
       => hoare_992312373derivs(A,Ga,aa(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool),aa(hoare_28830079triple(A),fun(fun(hoare_28830079triple(A),bool),fun(hoare_28830079triple(A),bool)),insert(hoare_28830079triple(A)),hoare_1841697145triple(A,P1,cond(B1,Ca,D),Q1)),bot_bot(fun(hoare_28830079triple(A),bool)))) ) ) ).

tff(fact_91_com_Osimps_I4_J,axiom,
    ! [Com21: com,Com11: com,Fun: fun(state,bool),Com2: com,Com1: com,Fun1: fun(state,bool)] :
      ( ( cond(Fun1,Com1,Com2) = cond(Fun,Com11,Com21) )
    <=> ( ( Fun1 = Fun )
        & ( Com1 = Com11 )
        & ( Com2 = Com21 ) ) ) ).

tff(fact_92_evalc_OIfFalse,axiom,
    ! [C0: com,S1: state,C1: com,S: state,B1: fun(state,bool)] :
      ( ~ pp(aa(state,bool,B1,S))
     => ( pp(aa(state,bool,aa(state,fun(state,bool),evalc(C1),S),S1))
       => pp(aa(state,bool,aa(state,fun(state,bool),evalc(cond(B1,C0,C1)),S),S1)) ) ) ).

tff(fact_93_evalc_OIfTrue,axiom,
    ! [C1: com,S1: state,C0: com,S: state,B1: fun(state,bool)] :
      ( pp(aa(state,bool,B1,S))
     => ( pp(aa(state,bool,aa(state,fun(state,bool),evalc(C0),S),S1))
       => pp(aa(state,bool,aa(state,fun(state,bool),evalc(cond(B1,C0,C1)),S),S1)) ) ) ).

tff(fact_94_evalc__elim__cases_I5_J,axiom,
    ! [T: state,S: state,C2: com,C1: com,B1: fun(state,bool)] :
      ( pp(aa(state,bool,aa(state,fun(state,bool),evalc(cond(B1,C1,C2)),S),T))
     => ( ( pp(aa(state,bool,B1,S))
         => ~ pp(aa(state,bool,aa(state,fun(state,bool),evalc(C1),S),T)) )
       => ~ ( ~ pp(aa(state,bool,B1,S))
           => ~ pp(aa(state,bool,aa(state,fun(state,bool),evalc(C2),S),T)) ) ) ) ).

tff(fact_95_com_Osimps_I45_J,axiom,
    ! [Com2: com,Com1: com,Com21: com,Com11: com,Fun: fun(state,bool)] : ( cond(Fun,Com11,Com21) != semi(Com1,Com2) ) ).

tff(fact_96_com_Osimps_I44_J,axiom,
    ! [Com21: com,Com11: com,Fun: fun(state,bool),Com2: com,Com1: com] : ( semi(Com1,Com2) != cond(Fun,Com11,Com21) ) ).

tff(fact_97_com_Osimps_I52_J,axiom,
    ! [Com: com,Fun: fun(state,bool),Com2: com,Com1: com,Fun1: fun(state,bool)] : ( cond(Fun1,Com1,Com2) != while(Fun,Com) ) ).

tff(fact_98_com_Osimps_I15_J,axiom,
    ! [Com21: com,Com11: com,Fun: fun(state,bool)] : ( cond(Fun,Com11,Com21) != skip ) ).

tff(fact_99_com_Osimps_I53_J,axiom,
    ! [Com2: com,Com1: com,Fun1: fun(state,bool),Com: com,Fun: fun(state,bool)] : ( while(Fun,Com) != cond(Fun1,Com1,Com2) ) ).

%----Arities (2)
tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (22)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fAll_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(fun(A,bool),bool,fAll(A),P))
      | pp(aa(A,bool,P,X)) ) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),combb(B,C,A,P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),aa(fun(A,fun(B,C)),fun(B,fun(A,C)),combc(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C)),combs(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    hoare_531836380gleton ).

tff(conj_1,hypothesis,
    hoare_992312373derivs(state,g,aa(fun(hoare_28830079triple(state),bool),fun(hoare_28830079triple(state),bool),aa(hoare_28830079triple(state),fun(fun(hoare_28830079triple(state),bool),fun(hoare_28830079triple(state),bool)),insert(hoare_28830079triple(state)),hoare_1841697145triple(state,aa(fun(state,fun(state,fun(state,bool))),fun(state,fun(state,bool)),combb(fun(state,fun(state,bool)),fun(state,bool),state,combb(fun(state,bool),bool,state,fAll(state))),aa(fun(state,fun(state,bool)),fun(state,fun(state,fun(state,bool))),combb(fun(state,bool),fun(state,fun(state,bool)),state,aa(fun(state,fun(fun(state,bool),fun(state,bool))),fun(fun(state,bool),fun(state,fun(state,bool))),combc(state,fun(state,bool),fun(state,bool)),aa(fun(state,fun(state,fun(bool,bool))),fun(state,fun(fun(state,bool),fun(state,bool))),combb(fun(state,fun(bool,bool)),fun(fun(state,bool),fun(state,bool)),state,combs(state,bool,bool)),aa(fun(state,fun(state,bool)),fun(state,fun(state,fun(bool,bool))),combb(fun(state,bool),fun(state,fun(bool,bool)),state,combb(bool,fun(bool,bool),state,fimplies)),evalc(c))))),fequal(state))),c,fequal(state))),bot_bot(fun(hoare_28830079triple(state),bool)))) ).

tff(conj_2,conjecture,
    hoare_992312373derivs(state,g,aa(fun(hoare_28830079triple(state),bool),fun(hoare_28830079triple(state),bool),aa(hoare_28830079triple(state),fun(fun(hoare_28830079triple(state),bool),fun(hoare_28830079triple(state),bool)),insert(hoare_28830079triple(state)),hoare_1841697145triple(state,fequal(state),c,evalc(c))),bot_bot(fun(hoare_28830079triple(state),bool)))) ).

%------------------------------------------------------------------------------
