%------------------------------------------------------------------------------
% File     : SWW522_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Hoare's Logic with Procedures line 293
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : hoare_293 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v6.4.0
% Syntax   : Number of formulae    :  147 (  60 unt;  45 typ;   0 def)
%            Number of atoms       :  180 (  95 equ)
%            Maximal formula atoms :    5 (   1 avg)
%            Number of connectives :  126 (  48   ~;   2   |;   9   &)
%                                         (  13 <=>;  54  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   6 avg)
%            Maximal term depth    :   10 (   1 avg)
%            Number of types       :    9 (   8 usr)
%            Number of type conns  :   73 (  28   >;  45   *;   0   +;   0  <<)
%            Number of predicates  :   11 (  10 usr;   0 prp; 1-4 aty)
%            Number of functors    :   27 (  27 usr;   5 con; 0-10 aty)
%            Number of variables   :  448 ( 424   !;   2   ?; 448   :)
%                                         (  22  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:24:49
%------------------------------------------------------------------------------
%----Should-be-implicit typings (10)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_Com_Ocom,type,
    com: $tType ).

tff(ty_tc_Com_Oloc,type,
    loc: $tType ).

tff(ty_tc_Com_Opname,type,
    pname: $tType ).

tff(ty_tc_Com_Ostate,type,
    state: $tType ).

tff(ty_tc_Com_Ovname,type,
    vname: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Hoare__Mirabelle__vtrypsmcwp_Otriple,type,
    hoare_28830079triple: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (35)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A2: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A2: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A2: $tType] : $o ).

tff(sy_c_Com_OWT,type,
    wt: com > $o ).

tff(sy_c_Com_Ocom_OAss,type,
    ass: ( vname * fun(state,nat) ) > com ).

tff(sy_c_Com_Ocom_OCond,type,
    cond: ( fun(state,bool) * com * com ) > com ).

tff(sy_c_Com_Ocom_OLocal,type,
    local: ( loc * fun(state,nat) * com ) > com ).

tff(sy_c_Com_Ocom_OSKIP,type,
    skip: com ).

tff(sy_c_Com_Ocom_OSemi,type,
    semi: ( com * com ) > com ).

tff(sy_c_Com_Ocom_Ocom__case,type,
    com_case: 
      !>[T3: $tType] : ( ( T3 * fun(vname,fun(fun(state,nat),T3)) * fun(loc,fun(fun(state,nat),fun(com,T3))) * fun(com,fun(com,T3)) * fun(fun(state,bool),fun(com,fun(com,T3))) * fun(fun(state,bool),fun(com,T3)) * fun(pname,T3) * fun(vname,fun(pname,fun(fun(state,nat),T3))) * com ) > T3 ) ).

tff(sy_c_Com_Ocom_Ocom__rec,type,
    com_rec: 
      !>[T3: $tType] : ( ( T3 * fun(vname,fun(fun(state,nat),T3)) * fun(loc,fun(fun(state,nat),fun(com,fun(T3,T3)))) * fun(com,fun(com,fun(T3,fun(T3,T3)))) * fun(fun(state,bool),fun(com,fun(com,fun(T3,fun(T3,T3))))) * fun(fun(state,bool),fun(com,fun(T3,T3))) * fun(pname,T3) * fun(vname,fun(pname,fun(fun(state,nat),T3))) * com ) > T3 ) ).

tff(sy_c_Com_Ocom_Ocom__size,type,
    com_size: com > nat ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A2: $tType] : ( ( A2 * A2 ) > A2 ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A2: $tType] : A2 ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Ohoare__valids,type,
    hoare_592965047valids: 
      !>[A2: $tType] : ( ( fun(hoare_28830079triple(A2),bool) * fun(hoare_28830079triple(A2),bool) ) > $o ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple,type,
    hoare_1841697145triple: 
      !>[A2: $tType] : ( ( fun(A2,fun(state,bool)) * com * fun(A2,fun(state,bool)) ) > hoare_28830079triple(A2) ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__case,type,
    hoare_376461865e_case: 
      !>[A2: $tType,T3: $tType] : ( ( fun(fun(A2,fun(state,bool)),fun(com,fun(fun(A2,fun(state,bool)),T3))) * hoare_28830079triple(A2) ) > T3 ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__rec,type,
    hoare_678420151le_rec: 
      !>[A2: $tType,T3: $tType] : ( ( fun(fun(A2,fun(state,bool)),fun(com,fun(fun(A2,fun(state,bool)),T3))) * hoare_28830079triple(A2) ) > T3 ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__size,type,
    hoare_47506394e_size: 
      !>[A2: $tType] : ( ( fun(A2,nat) * hoare_28830079triple(A2) ) > nat ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple__valid,type,
    hoare_1633586161_valid: 
      !>[A2: $tType] : ( ( nat * hoare_28830079triple(A2) ) > $o ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Nat_Onat_Onat__case,type,
    nat_case: 
      !>[T3: $tType] : ( ( T3 * fun(nat,T3) * nat ) > T3 ) ).

tff(sy_c_Nat_Onat_Onat__rec,type,
    nat_rec: 
      !>[T3: $tType] : ( ( T3 * fun(nat,fun(T3,T3)) * nat ) > T3 ) ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat__aux,type,
    semiri532925092at_aux: 
      !>[A2: $tType] : ( ( fun(A2,A2) * nat * A2 ) > A2 ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A2: $tType] : ( A2 > nat ) ).

tff(sy_c_Natural_Oevaln,type,
    evaln: ( com * state * nat * state ) > $o ).

tff(sy_c_Natural_Oupdate,type,
    update: ( state * vname * nat ) > state ).

tff(sy_c_aa,type,
    aa: 
      !>[A2: $tType,B: $tType] : ( ( fun(A2,B) * A2 ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A2: $tType] : ( ( A2 * fun(A2,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_Ga,type,
    ga: fun(hoare_28830079triple(a),bool) ).

tff(sy_v_P,type,
    p: ( a * state ) > $o ).

tff(sy_v_n,type,
    n: nat ).

%----Relevant facts (95)
tff(fact_0_evaln_OSkip,axiom,
    ! [N2: nat,S3: state] : evaln(skip,S3,N2,S3) ).

tff(fact_1_evaln__elim__cases_I1_J,axiom,
    ! [T1: state,N2: nat,S3: state] :
      ( evaln(skip,S3,N2,T1)
     => ( T1 = S3 ) ) ).

tff(fact_2_triple__valid__def2,axiom,
    ! [B: $tType,Q: fun(B,fun(state,bool)),C: com,P: fun(B,fun(state,bool)),N: nat] :
      ( hoare_1633586161_valid(B,N,hoare_1841697145triple(B,P,C,Q))
    <=> ! [Z1: B,S5: state] :
          ( pp(aa(state,bool,aa(B,fun(state,bool),P,Z1),S5))
         => ! [S6: state] :
              ( evaln(C,S5,N,S6)
             => pp(aa(state,bool,aa(B,fun(state,bool),Q,Z1),S6)) ) ) ) ).

tff(fact_3_evaln__max2,axiom,
    ! [T2: state,N21: nat,S21: state,C2: com,T11: state,N11: nat,S13: state,C11: com] :
      ( evaln(C11,S13,N11,T11)
     => ( evaln(C2,S21,N21,T2)
       => ? [N1: nat] :
            ( evaln(C11,S13,N1,T11)
            & evaln(C2,S21,N1,T2) ) ) ) ).

tff(fact_4_triple__valid__Suc,axiom,
    ! [A2: $tType,T1: hoare_28830079triple(A2),N2: nat] :
      ( hoare_1633586161_valid(A2,suc(N2),T1)
     => hoare_1633586161_valid(A2,N2,T1) ) ).

tff(fact_5_com_Osimps_I64_J,axiom,
    ! [B: $tType,F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com,B)),F5: fun(fun(state,bool),fun(com,fun(com,B))),F4: fun(com,fun(com,B)),F3: fun(loc,fun(fun(state,nat),fun(com,B))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_case(B,F1,F2,F3,F4,F5,F6,F7,F8,skip) = F1 ) ).

tff(fact_6_evaln_OSemi,axiom,
    ! [S21: state,C11: com,S13: state,N2: nat,S0: state,C01: com] :
      ( evaln(C01,S0,N2,S13)
     => ( evaln(C11,S13,N2,S21)
       => evaln(semi(C01,C11),S0,N2,S21) ) ) ).

tff(fact_7_com_Orecs_I1_J,axiom,
    ! [B: $tType,F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com,fun(B,B))),F5: fun(fun(state,bool),fun(com,fun(com,fun(B,fun(B,B))))),F4: fun(com,fun(com,fun(B,fun(B,B)))),F3: fun(loc,fun(fun(state,nat),fun(com,fun(B,B)))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,skip) = F1 ) ).

tff(fact_8_evaln_OIfFalse,axiom,
    ! [C0: com,S12: state,N: nat,C12: com,S2: state,B1: fun(state,bool)] :
      ( ~ pp(aa(state,bool,B1,S2))
     => ( evaln(C12,S2,N,S12)
       => evaln(cond(B1,C0,C12),S2,N,S12) ) ) ).

tff(fact_9_evaln_OIfTrue,axiom,
    ! [C12: com,S12: state,N: nat,C0: com,S2: state,B1: fun(state,bool)] :
      ( pp(aa(state,bool,B1,S2))
     => ( evaln(C0,S2,N,S12)
       => evaln(cond(B1,C0,C12),S2,N,S12) ) ) ).

tff(fact_10_evaln__elim__cases_I5_J,axiom,
    ! [T: state,N: nat,S2: state,C21: com,C12: com,B1: fun(state,bool)] :
      ( evaln(cond(B1,C12,C21),S2,N,T)
     => ( ( pp(aa(state,bool,B1,S2))
         => ~ evaln(C12,S2,N,T) )
       => ~ ( ~ pp(aa(state,bool,B1,S2))
           => ~ evaln(C21,S2,N,T) ) ) ) ).

tff(fact_11_triple_Oinject,axiom,
    ! [B: $tType,Fun22: fun(B,fun(state,bool)),Com3: com,Fun12: fun(B,fun(state,bool)),Fun2: fun(B,fun(state,bool)),Com: com,Fun1: fun(B,fun(state,bool))] :
      ( ( hoare_1841697145triple(B,Fun1,Com,Fun2) = hoare_1841697145triple(B,Fun12,Com3,Fun22) )
    <=> ( ( Fun1 = Fun12 )
        & ( Com = Com3 )
        & ( Fun2 = Fun22 ) ) ) ).

tff(fact_12_com_Osimps_I4_J,axiom,
    ! [Com21: com,Com11: com,Fun3: fun(state,bool),Com23: com,Com13: com,Fun: fun(state,bool)] :
      ( ( cond(Fun,Com13,Com23) = cond(Fun3,Com11,Com21) )
    <=> ( ( Fun = Fun3 )
        & ( Com13 = Com11 )
        & ( Com23 = Com21 ) ) ) ).

tff(fact_13_com_Osimps_I3_J,axiom,
    ! [Com21: com,Com11: com,Com23: com,Com13: com] :
      ( ( semi(Com13,Com23) = semi(Com11,Com21) )
    <=> ( ( Com13 = Com11 )
        & ( Com23 = Com21 ) ) ) ).

tff(fact_14_WTs__elim__cases_I5_J,axiom,
    ! [C21: com,C12: com,B1: fun(state,bool)] :
      ( wt(cond(B1,C12,C21))
     => ~ ( wt(C12)
         => ~ wt(C21) ) ) ).

tff(fact_15_WTs__elim__cases_I4_J,axiom,
    ! [C2: com,C11: com] :
      ( wt(semi(C11,C2))
     => ~ ( wt(C11)
         => ~ wt(C2) ) ) ).

tff(fact_16_com_Osimps_I44_J,axiom,
    ! [Com21: com,Com11: com,Fun3: fun(state,bool),Com23: com,Com13: com] : ( semi(Com13,Com23) != cond(Fun3,Com11,Com21) ) ).

tff(fact_17_com_Osimps_I45_J,axiom,
    ! [Com23: com,Com13: com,Com21: com,Com11: com,Fun3: fun(state,bool)] : ( cond(Fun3,Com11,Com21) != semi(Com13,Com23) ) ).

tff(fact_18_com_Osimps_I67_J,axiom,
    ! [B: $tType,Com23: com,Com13: com,F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com,B)),F5: fun(fun(state,bool),fun(com,fun(com,B))),F4: fun(com,fun(com,B)),F3: fun(loc,fun(fun(state,nat),fun(com,B))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_case(B,F1,F2,F3,F4,F5,F6,F7,F8,semi(Com13,Com23)) = aa(com,B,aa(com,fun(com,B),F4,Com13),Com23) ) ).

tff(fact_19_com_Orecs_I4_J,axiom,
    ! [B: $tType,Com23: com,Com13: com,F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com,fun(B,B))),F5: fun(fun(state,bool),fun(com,fun(com,fun(B,fun(B,B))))),F4: fun(com,fun(com,fun(B,fun(B,B)))),F3: fun(loc,fun(fun(state,nat),fun(com,fun(B,B)))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,semi(Com13,Com23)) = aa(B,B,aa(B,fun(B,B),aa(com,fun(B,fun(B,B)),aa(com,fun(com,fun(B,fun(B,B))),F4,Com13),Com23),com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,Com13)),com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,Com23)) ) ).

tff(fact_20_com_Osimps_I68_J,axiom,
    ! [B: $tType,Com23: com,Com13: com,Fun: fun(state,bool),F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com,B)),F5: fun(fun(state,bool),fun(com,fun(com,B))),F4: fun(com,fun(com,B)),F3: fun(loc,fun(fun(state,nat),fun(com,B))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_case(B,F1,F2,F3,F4,F5,F6,F7,F8,cond(Fun,Com13,Com23)) = aa(com,B,aa(com,fun(com,B),aa(fun(state,bool),fun(com,fun(com,B)),F5,Fun),Com13),Com23) ) ).

tff(fact_21_com_Orecs_I5_J,axiom,
    ! [B: $tType,Com23: com,Com13: com,Fun: fun(state,bool),F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com,fun(B,B))),F5: fun(fun(state,bool),fun(com,fun(com,fun(B,fun(B,B))))),F4: fun(com,fun(com,fun(B,fun(B,B)))),F3: fun(loc,fun(fun(state,nat),fun(com,fun(B,B)))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,cond(Fun,Com13,Com23)) = aa(B,B,aa(B,fun(B,B),aa(com,fun(B,fun(B,B)),aa(com,fun(com,fun(B,fun(B,B))),aa(fun(state,bool),fun(com,fun(com,fun(B,fun(B,B)))),F5,Fun),Com13),Com23),com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,Com13)),com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,Com23)) ) ).

tff(fact_22_WT_OSemi,axiom,
    ! [C11: com,C01: com] :
      ( wt(C01)
     => ( wt(C11)
       => wt(semi(C01,C11)) ) ) ).

tff(fact_23_WT_OIf,axiom,
    ! [B1: fun(state,bool),C12: com,C0: com] :
      ( wt(C0)
     => ( wt(C12)
       => wt(cond(B1,C0,C12)) ) ) ).

tff(fact_24_evaln__Suc,axiom,
    ! [S4: state,N2: nat,S3: state,C3: com] :
      ( evaln(C3,S3,N2,S4)
     => evaln(C3,S3,suc(N2),S4) ) ).

tff(fact_25_WT_OSkip,axiom,
    wt(skip) ).

tff(fact_26_com_Osimps_I15_J,axiom,
    ! [Com21: com,Com11: com,Fun3: fun(state,bool)] : ( cond(Fun3,Com11,Com21) != skip ) ).

tff(fact_27_com_Osimps_I14_J,axiom,
    ! [Com21: com,Com11: com,Fun3: fun(state,bool)] : ( skip != cond(Fun3,Com11,Com21) ) ).

tff(fact_28_com_Osimps_I13_J,axiom,
    ! [Com22: com,Com12: com] : ( semi(Com12,Com22) != skip ) ).

tff(fact_29_com_Osimps_I12_J,axiom,
    ! [Com22: com,Com12: com] : ( skip != semi(Com12,Com22) ) ).

tff(fact_30_evaln__elim__cases_I4_J,axiom,
    ! [T1: state,N2: nat,S3: state,C2: com,C11: com] :
      ( evaln(semi(C11,C2),S3,N2,T1)
     => ~ ! [S11: state] :
            ( evaln(C11,S3,N2,S11)
           => ~ evaln(C2,S11,N2,T1) ) ) ).

tff(fact_31_nat_Oinject,axiom,
    ! [Nat4: nat,Nat3: nat] :
      ( ( suc(Nat3) = suc(Nat4) )
    <=> ( Nat3 = Nat4 ) ) ).

tff(fact_32_triple_Orecs,axiom,
    ! [B: $tType,C1: $tType,Fun2: fun(C1,fun(state,bool)),Com: com,Fun1: fun(C1,fun(state,bool)),F1: fun(fun(C1,fun(state,bool)),fun(com,fun(fun(C1,fun(state,bool)),B)))] : ( hoare_678420151le_rec(C1,B,F1,hoare_1841697145triple(C1,Fun1,Com,Fun2)) = aa(fun(C1,fun(state,bool)),B,aa(com,fun(fun(C1,fun(state,bool)),B),aa(fun(C1,fun(state,bool)),fun(com,fun(fun(C1,fun(state,bool)),B)),F1,Fun1),Com),Fun2) ) ).

tff(fact_33_triple_Osimps_I2_J,axiom,
    ! [B: $tType,C1: $tType,Fun2: fun(C1,fun(state,bool)),Com: com,Fun1: fun(C1,fun(state,bool)),F1: fun(fun(C1,fun(state,bool)),fun(com,fun(fun(C1,fun(state,bool)),B)))] : ( hoare_376461865e_case(C1,B,F1,hoare_1841697145triple(C1,Fun1,Com,Fun2)) = aa(fun(C1,fun(state,bool)),B,aa(com,fun(fun(C1,fun(state,bool)),B),aa(fun(C1,fun(state,bool)),fun(com,fun(fun(C1,fun(state,bool)),B)),F1,Fun1),Com),Fun2) ) ).

tff(fact_34_triple_Oexhaust,axiom,
    ! [B: $tType,Y2: hoare_28830079triple(B)] :
      ~ ! [Fun11: fun(B,fun(state,bool)),Com4: com,Fun21: fun(B,fun(state,bool))] : ( Y2 != hoare_1841697145triple(B,Fun11,Com4,Fun21) ) ).

tff(fact_35_n__not__Suc__n,axiom,
    ! [N2: nat] : ( N2 != suc(N2) ) ).

tff(fact_36_Suc__n__not__n,axiom,
    ! [N2: nat] : ( suc(N2) != N2 ) ).

tff(fact_37_Suc__inject,axiom,
    ! [Y: nat,X5: nat] :
      ( ( suc(X5) = suc(Y) )
     => ( X5 = Y ) ) ).

tff(fact_38_of__nat__aux_Osimps_I2_J,axiom,
    ! [B: $tType] :
      ( semiring_1(B)
     => ! [I: B,N: nat,Inc: fun(B,B)] : ( semiri532925092at_aux(B,Inc,suc(N),I) = semiri532925092at_aux(B,Inc,N,aa(B,B,Inc,I)) ) ) ).

tff(fact_39_nat__case__Suc,axiom,
    ! [B: $tType,Nat3: nat,F2: fun(nat,B),F1: B] : ( nat_case(B,F1,F2,suc(Nat3)) = aa(nat,B,F2,Nat3) ) ).

tff(fact_40_triples__valid__Suc,axiom,
    ! [B: $tType,N: nat,Tsa: fun(hoare_28830079triple(B),bool)] :
      ( ! [X2: hoare_28830079triple(B)] :
          ( member(hoare_28830079triple(B),X2,Tsa)
         => hoare_1633586161_valid(B,suc(N),X2) )
     => ! [X: hoare_28830079triple(B)] :
          ( member(hoare_28830079triple(B),X,Tsa)
         => hoare_1633586161_valid(B,N,X) ) ) ).

tff(fact_41_nat__rec__Suc,axiom,
    ! [B: $tType,Nat3: nat,F2: fun(nat,fun(B,B)),F1: B] : ( nat_rec(B,F1,F2,suc(Nat3)) = aa(B,B,aa(nat,fun(B,B),F2,Nat3),nat_rec(B,F1,F2,Nat3)) ) ).

tff(fact_42_WTs__elim__cases_I3_J,axiom,
    ! [C: com,A: fun(state,nat),Y1: loc] :
      ( wt(local(Y1,A,C))
     => wt(C) ) ).

tff(fact_43_com_Osimps_I2_J,axiom,
    ! [Com3: com,Fun3: fun(state,nat),Loc1: loc,Com: com,Fun: fun(state,nat),Loc: loc] :
      ( ( local(Loc,Fun,Com) = local(Loc1,Fun3,Com3) )
    <=> ( ( Loc = Loc1 )
        & ( Fun = Fun3 )
        & ( Com = Com3 ) ) ) ).

tff(fact_44_WT_OLocal,axiom,
    ! [A: fun(state,nat),Y1: loc,C: com] :
      ( wt(C)
     => wt(local(Y1,A,C)) ) ).

tff(fact_45_com_Osimps_I37_J,axiom,
    ! [Com: com,Fun: fun(state,nat),Loc: loc,Com21: com,Com11: com,Fun3: fun(state,bool)] : ( cond(Fun3,Com11,Com21) != local(Loc,Fun,Com) ) ).

tff(fact_46_com_Osimps_I36_J,axiom,
    ! [Com21: com,Com11: com,Fun3: fun(state,bool),Com: com,Fun: fun(state,nat),Loc: loc] : ( local(Loc,Fun,Com) != cond(Fun3,Com11,Com21) ) ).

tff(fact_47_com_Osimps_I35_J,axiom,
    ! [Com: com,Fun: fun(state,nat),Loc: loc,Com21: com,Com11: com] : ( semi(Com11,Com21) != local(Loc,Fun,Com) ) ).

tff(fact_48_com_Osimps_I34_J,axiom,
    ! [Com21: com,Com11: com,Com: com,Fun: fun(state,nat),Loc: loc] : ( local(Loc,Fun,Com) != semi(Com11,Com21) ) ).

tff(fact_49_com_Osimps_I11_J,axiom,
    ! [Com3: com,Fun3: fun(state,nat),Loc1: loc] : ( local(Loc1,Fun3,Com3) != skip ) ).

tff(fact_50_com_Osimps_I10_J,axiom,
    ! [Com3: com,Fun3: fun(state,nat),Loc1: loc] : ( skip != local(Loc1,Fun3,Com3) ) ).

tff(fact_51_com_Orecs_I3_J,axiom,
    ! [B: $tType,Com: com,Fun: fun(state,nat),Loc: loc,F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com,fun(B,B))),F5: fun(fun(state,bool),fun(com,fun(com,fun(B,fun(B,B))))),F4: fun(com,fun(com,fun(B,fun(B,B)))),F3: fun(loc,fun(fun(state,nat),fun(com,fun(B,B)))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,local(Loc,Fun,Com)) = aa(B,B,aa(com,fun(B,B),aa(fun(state,nat),fun(com,fun(B,B)),aa(loc,fun(fun(state,nat),fun(com,fun(B,B))),F3,Loc),Fun),Com),com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,Com)) ) ).

tff(fact_52_com_Osimps_I66_J,axiom,
    ! [B: $tType,Com: com,Fun: fun(state,nat),Loc: loc,F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com,B)),F5: fun(fun(state,bool),fun(com,fun(com,B))),F4: fun(com,fun(com,B)),F3: fun(loc,fun(fun(state,nat),fun(com,B))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_case(B,F1,F2,F3,F4,F5,F6,F7,F8,local(Loc,Fun,Com)) = aa(com,B,aa(fun(state,nat),fun(com,B),aa(loc,fun(fun(state,nat),fun(com,B)),F3,Loc),Fun),Com) ) ).

tff(fact_53_def__nat__rec__Suc,axiom,
    ! [B: $tType,N: nat,H: fun(nat,fun(B,B)),C: B,F: fun(nat,B)] :
      ( ! [N1: nat] : ( aa(nat,B,F,N1) = nat_rec(B,C,H,N1) )
     => ( aa(nat,B,F,suc(N)) = aa(B,B,aa(nat,fun(B,B),H,N),aa(nat,B,F,N)) ) ) ).

tff(fact_54_hoare__valids__def,axiom,
    ! [B: $tType,Tsa: fun(hoare_28830079triple(B),bool),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_592965047valids(B,Ga,Tsa)
    <=> ! [N3: nat] :
          ( ! [X4: hoare_28830079triple(B)] :
              ( member(hoare_28830079triple(B),X4,Ga)
             => hoare_1633586161_valid(B,N3,X4) )
         => ! [X4: hoare_28830079triple(B)] :
              ( member(hoare_28830079triple(B),X4,Tsa)
             => hoare_1633586161_valid(B,N3,X4) ) ) ) ).

tff(fact_55_com_Osimps_I1_J,axiom,
    ! [Fun3: fun(state,nat),Vname1: vname,Fun: fun(state,nat),Vname: vname] :
      ( ( ass(Vname,Fun) = ass(Vname1,Fun3) )
    <=> ( ( Vname = Vname1 )
        & ( Fun = Fun3 ) ) ) ).

tff(fact_56_WT_OAssign,axiom,
    ! [A: fun(state,nat),X3: vname] : wt(ass(X3,A)) ).

tff(fact_57_com_Osimps_I27_J,axiom,
    ! [Fun: fun(state,nat),Vname: vname,Com21: com,Com11: com,Fun3: fun(state,bool)] : ( cond(Fun3,Com11,Com21) != ass(Vname,Fun) ) ).

tff(fact_58_com_Osimps_I26_J,axiom,
    ! [Com21: com,Com11: com,Fun3: fun(state,bool),Fun: fun(state,nat),Vname: vname] : ( ass(Vname,Fun) != cond(Fun3,Com11,Com21) ) ).

tff(fact_59_com_Osimps_I25_J,axiom,
    ! [Fun: fun(state,nat),Vname: vname,Com21: com,Com11: com] : ( semi(Com11,Com21) != ass(Vname,Fun) ) ).

tff(fact_60_com_Osimps_I24_J,axiom,
    ! [Com21: com,Com11: com,Fun: fun(state,nat),Vname: vname] : ( ass(Vname,Fun) != semi(Com11,Com21) ) ).

tff(fact_61_com_Osimps_I22_J,axiom,
    ! [Com3: com,Fun3: fun(state,nat),Loc1: loc,Fun: fun(state,nat),Vname: vname] : ( ass(Vname,Fun) != local(Loc1,Fun3,Com3) ) ).

tff(fact_62_com_Osimps_I23_J,axiom,
    ! [Fun: fun(state,nat),Vname: vname,Com3: com,Fun3: fun(state,nat),Loc1: loc] : ( local(Loc1,Fun3,Com3) != ass(Vname,Fun) ) ).

tff(fact_63_com_Osimps_I8_J,axiom,
    ! [Fun3: fun(state,nat),Vname1: vname] : ( skip != ass(Vname1,Fun3) ) ).

tff(fact_64_com_Osimps_I9_J,axiom,
    ! [Fun3: fun(state,nat),Vname1: vname] : ( ass(Vname1,Fun3) != skip ) ).

tff(fact_65_com_Orecs_I2_J,axiom,
    ! [B: $tType,Fun: fun(state,nat),Vname: vname,F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com,fun(B,B))),F5: fun(fun(state,bool),fun(com,fun(com,fun(B,fun(B,B))))),F4: fun(com,fun(com,fun(B,fun(B,B)))),F3: fun(loc,fun(fun(state,nat),fun(com,fun(B,B)))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,ass(Vname,Fun)) = aa(fun(state,nat),B,aa(vname,fun(fun(state,nat),B),F2,Vname),Fun) ) ).

tff(fact_66_com_Osimps_I65_J,axiom,
    ! [B: $tType,Fun: fun(state,nat),Vname: vname,F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com,B)),F5: fun(fun(state,bool),fun(com,fun(com,B))),F4: fun(com,fun(com,B)),F3: fun(loc,fun(fun(state,nat),fun(com,B))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_case(B,F1,F2,F3,F4,F5,F6,F7,F8,ass(Vname,Fun)) = aa(fun(state,nat),B,aa(vname,fun(fun(state,nat),B),F2,Vname),Fun) ) ).

tff(fact_67_evaln__elim__cases_I2_J,axiom,
    ! [T: state,N: nat,S2: state,A: fun(state,nat),X3: vname] :
      ( evaln(ass(X3,A),S2,N,T)
     => ( T = update(S2,X3,aa(state,nat,A,S2)) ) ) ).

tff(fact_68_evaln_OAssign,axiom,
    ! [N: nat,S2: state,A: fun(state,nat),X3: vname] : evaln(ass(X3,A),S2,N,update(S2,X3,aa(state,nat,A,S2))) ).

tff(fact_69_of__nat__aux_Osimps_I1_J,axiom,
    ! [B: $tType] :
      ( semiring_1(B)
     => ! [I: B,Inc: fun(B,B)] : ( semiri532925092at_aux(B,Inc,zero_zero(nat),I) = I ) ) ).

tff(fact_70_nat__case__0,axiom,
    ! [B: $tType,F2: fun(nat,B),F1: B] : ( nat_case(B,F1,F2,zero_zero(nat)) = F1 ) ).

tff(fact_71_ext,axiom,
    ! [C1: $tType,B: $tType,G: fun(B,C1),F: fun(B,C1)] :
      ( ! [X2: B] : ( aa(B,C1,F,X2) = aa(B,C1,G,X2) )
     => ( F = G ) ) ).

tff(fact_72_mem__def,axiom,
    ! [B: $tType,A1: fun(B,bool),X1: B] :
      ( member(B,X1,A1)
    <=> pp(aa(B,bool,A1,X1)) ) ).

tff(fact_73_nat__rec__0,axiom,
    ! [B: $tType,F2: fun(nat,fun(B,B)),F1: B] : ( nat_rec(B,F1,F2,zero_zero(nat)) = F1 ) ).

tff(fact_74_Suc__neq__Zero,axiom,
    ! [M2: nat] : ( suc(M2) != zero_zero(nat) ) ).

tff(fact_75_Zero__neq__Suc,axiom,
    ! [M2: nat] : ( zero_zero(nat) != suc(M2) ) ).

tff(fact_76_nat_Osimps_I3_J,axiom,
    ! [Nat2: nat] : ( suc(Nat2) != zero_zero(nat) ) ).

tff(fact_77_Suc__not__Zero,axiom,
    ! [M2: nat] : ( suc(M2) != zero_zero(nat) ) ).

tff(fact_78_nat_Osimps_I2_J,axiom,
    ! [Nat1: nat] : ( zero_zero(nat) != suc(Nat1) ) ).

tff(fact_79_Zero__not__Suc,axiom,
    ! [M2: nat] : ( zero_zero(nat) != suc(M2) ) ).

tff(fact_80_triple_Osize_I1_J,axiom,
    ! [B: $tType,Fun2: fun(B,fun(state,bool)),Com: com,Fun1: fun(B,fun(state,bool)),Fa: fun(B,nat)] : ( hoare_47506394e_size(B,Fa,hoare_1841697145triple(B,Fun1,Com,Fun2)) = zero_zero(nat) ) ).

tff(fact_81_triple_Osize_I2_J,axiom,
    ! [B: $tType,Fun2: fun(B,fun(state,bool)),Com: com,Fun1: fun(B,fun(state,bool))] : ( size_size(hoare_28830079triple(B),hoare_1841697145triple(B,Fun1,Com,Fun2)) = zero_zero(nat) ) ).

tff(fact_82_def__nat__rec__0,axiom,
    ! [B: $tType,H: fun(nat,fun(B,B)),C: B,F: fun(nat,B)] :
      ( ! [N1: nat] : ( aa(nat,B,F,N1) = nat_rec(B,C,H,N1) )
     => ( aa(nat,B,F,zero_zero(nat)) = C ) ) ).

tff(fact_83_zero__reorient,axiom,
    ! [B: $tType] :
      ( zero(B)
     => ! [X1: B] :
          ( ( zero_zero(B) = X1 )
        <=> ( X1 = zero_zero(B) ) ) ) ).

tff(fact_84_not0__implies__Suc,axiom,
    ! [N2: nat] :
      ( ( N2 != zero_zero(nat) )
     => ? [M1: nat] : ( N2 = suc(M1) ) ) ).

tff(fact_85_nat__induct,axiom,
    ! [N: nat,P: fun(nat,bool)] :
      ( pp(aa(nat,bool,P,zero_zero(nat)))
     => ( ! [N1: nat] :
            ( pp(aa(nat,bool,P,N1))
           => pp(aa(nat,bool,P,suc(N1))) )
       => pp(aa(nat,bool,P,N)) ) ) ).

tff(fact_86_nat_Oexhaust,axiom,
    ! [Y: nat] :
      ( ( Y != zero_zero(nat) )
     => ~ ! [Nat: nat] : ( Y != suc(Nat) ) ) ).

tff(fact_87_zero__induct,axiom,
    ! [K: nat,P: fun(nat,bool)] :
      ( pp(aa(nat,bool,P,K))
     => ( ! [N1: nat] :
            ( pp(aa(nat,bool,P,suc(N1)))
           => pp(aa(nat,bool,P,N1)) )
       => pp(aa(nat,bool,P,zero_zero(nat))) ) ) ).

tff(fact_88_com_Osize_I1_J,axiom,
    com_size(skip) = zero_zero(nat) ).

tff(fact_89_com_Osize_I2_J,axiom,
    ! [Fun: fun(state,nat),Vname: vname] : ( com_size(ass(Vname,Fun)) = zero_zero(nat) ) ).

tff(fact_90_com_Osize_I3_J,axiom,
    ! [Com: com,Fun: fun(state,nat),Loc: loc] : ( com_size(local(Loc,Fun,Com)) = plus_plus(nat,com_size(Com),suc(zero_zero(nat))) ) ).

tff(fact_91_com_Osize_I4_J,axiom,
    ! [Com2: com,Com1: com] : ( com_size(semi(Com1,Com2)) = plus_plus(nat,plus_plus(nat,com_size(Com1),com_size(Com2)),suc(zero_zero(nat))) ) ).

tff(fact_92_add__right__cancel,axiom,
    ! [B: $tType] :
      ( cancel_semigroup_add(B)
     => ! [C: B,A: B,B1: B] :
          ( ( plus_plus(B,B1,A) = plus_plus(B,C,A) )
        <=> ( B1 = C ) ) ) ).

tff(fact_93_add__left__cancel,axiom,
    ! [B: $tType] :
      ( cancel_semigroup_add(B)
     => ! [C: B,B1: B,A: B] :
          ( ( plus_plus(B,A,B1) = plus_plus(B,A,C) )
        <=> ( B1 = C ) ) ) ).

tff(fact_94_nat__add__right__cancel,axiom,
    ! [N: nat,K: nat,M: nat] :
      ( ( plus_plus(nat,M,K) = plus_plus(nat,N,K) )
    <=> ( M = N ) ) ).

%----Arities (3)
tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    ! [X: hoare_28830079triple(a)] :
      ( member(hoare_28830079triple(a),X,ga)
     => hoare_1633586161_valid(a,n,X) ) ).

tff(conj_1,conjecture,
    ! [Z: a,S: state] :
      ( ~ p(Z,S)
      | ! [S1: state] :
          ( ~ evaln(skip,S,n,S1)
          | p(Z,S1) ) ) ).

%------------------------------------------------------------------------------
