%------------------------------------------------------------------------------
% File     : SWW521_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Hoare's Logic with Procedures line 287
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : hoare_287 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v7.5.0, 0.00 v7.4.0, 0.50 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  161 (  26 unt;  39 typ;   0 def)
%            Number of atoms       :  312 (  54 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  206 (  16   ~;   6   |;   9   &)
%                                         (  30 <=>; 145  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   34 (  21   >;  13   *;   0   +;   0  <<)
%            Number of predicates  :   16 (  15 usr;   0 prp; 1-6 aty)
%            Number of functors    :   21 (  21 usr;   6 con; 0-5 aty)
%            Number of variables   :  386 ( 351   !;   2   ?; 386   :)
%                                         (  33  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:24:18
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Hoare__Mirabelle__vtrypsmcwp_Otriple,type,
    hoare_28830079triple: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (34)
tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Oboolean__algebra,type,
    boolean_algebra: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_Groups_Ouminus__class_Ouminus,type,
    uminus_uminus: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Ohoare__derivs,type,
    hoare_992312373derivs: 
      !>[A: $tType] : ( ( fun(hoare_28830079triple(A),bool) * fun(hoare_28830079triple(A),bool) ) > $o ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Ohoare__valids,type,
    hoare_592965047valids: 
      !>[A: $tType] : ( ( fun(hoare_28830079triple(A),bool) * fun(hoare_28830079triple(A),bool) ) > $o ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple__valid,type,
    hoare_1633586161_valid: 
      !>[A: $tType] : ( ( nat * hoare_28830079triple(A) ) > $o ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat__aux,type,
    semiri532925092at_aux: 
      !>[A: $tType] : ( ( fun(A,A) * nat * A ) > A ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oorder__class_Ostrict__mono,type,
    order_strict_mono: 
      !>[A: $tType,B: $tType] : ( fun(A,B) > $o ) ).

tff(sy_c_Predicate_OPowp,type,
    powp: 
      !>[A: $tType] : ( fun(A,bool) > fun(fun(A,bool),bool) ) ).

tff(sy_c_Predicate_Oinv__imagep,type,
    inv_imagep: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(B,bool)) * fun(A,B) * A * A ) > $o ) ).

tff(sy_c_SetInterval_Oord__class_OatLeast,type,
    ord_atLeast: 
      !>[A: $tType] : ( A > fun(A,bool) ) ).

tff(sy_c_SetInterval_Oord__class_OatMost,type,
    ord_atMost: 
      !>[A: $tType] : ( A > fun(A,bool) ) ).

tff(sy_c_SetInterval_Oord__class_OgreaterThan,type,
    ord_greaterThan: 
      !>[A: $tType] : ( A > fun(A,bool) ) ).

tff(sy_c_SetInterval_Oord__class_OlessThan,type,
    ord_lessThan: 
      !>[A: $tType] : ( A > fun(A,bool) ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_Ga,type,
    ga: fun(hoare_28830079triple(a),bool) ).

tff(sy_v_ts_H,type,
    ts: fun(hoare_28830079triple(a),bool) ).

tff(sy_v_tsa,type,
    tsa: fun(hoare_28830079triple(a),bool) ).

%----Relevant facts (98)
tff(fact_0_asm,axiom,
    ! [B: $tType,Ga: fun(hoare_28830079triple(B),bool),Tsa: fun(hoare_28830079triple(B),bool)] :
      ( ord_less_eq(fun(hoare_28830079triple(B),bool),Tsa,Ga)
     => hoare_992312373derivs(B,Ga,Tsa) ) ).

tff(fact_1_weaken,axiom,
    ! [B: $tType,Tsa: fun(hoare_28830079triple(B),bool),Ts: fun(hoare_28830079triple(B),bool),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,Ga,Ts)
     => ( ord_less_eq(fun(hoare_28830079triple(B),bool),Tsa,Ts)
       => hoare_992312373derivs(B,Ga,Tsa) ) ) ).

tff(fact_2_thin,axiom,
    ! [B: $tType,Ga: fun(hoare_28830079triple(B),bool),Tsa: fun(hoare_28830079triple(B),bool),G1: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,G1,Tsa)
     => ( ord_less_eq(fun(hoare_28830079triple(B),bool),G1,Ga)
       => hoare_992312373derivs(B,Ga,Tsa) ) ) ).

tff(fact_3_cut,axiom,
    ! [B: $tType,Ga: fun(hoare_28830079triple(B),bool),Tsa: fun(hoare_28830079triple(B),bool),G1: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,G1,Tsa)
     => ( hoare_992312373derivs(B,Ga,G1)
       => hoare_992312373derivs(B,Ga,Tsa) ) ) ).

tff(fact_4_subsetD,axiom,
    ! [B: $tType,C1: B,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ord_less_eq(fun(B,bool),A2,B2)
     => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),A2))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),B2)) ) ) ).

tff(fact_5_equalityI,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ord_less_eq(fun(B,bool),A2,B2)
     => ( ord_less_eq(fun(B,bool),B2,A2)
       => ( A2 = B2 ) ) ) ).

tff(fact_6_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X3: A] : ord_less_eq(A,X3,X3) ) ).

tff(fact_7_hoare__valids__def,axiom,
    ! [B: $tType,Tsa: fun(hoare_28830079triple(B),bool),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_592965047valids(B,Ga,Tsa)
    <=> ! [N5: nat] :
          ( ! [X4: hoare_28830079triple(B)] :
              ( pp(aa(fun(hoare_28830079triple(B),bool),bool,aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),bool),member(hoare_28830079triple(B)),X4),Ga))
             => hoare_1633586161_valid(B,N5,X4) )
         => ! [X4: hoare_28830079triple(B)] :
              ( pp(aa(fun(hoare_28830079triple(B),bool),bool,aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),bool),member(hoare_28830079triple(B)),X4),Tsa))
             => hoare_1633586161_valid(B,N5,X4) ) ) ) ).

tff(fact_8_le__fun__def,axiom,
    ! [C: $tType,B: $tType] :
      ( ord(C)
     => ! [G: fun(B,C),F: fun(B,C)] :
          ( ord_less_eq(fun(B,C),F,G)
        <=> ! [X4: B] : ord_less_eq(C,aa(B,C,F,X4),aa(B,C,G,X4)) ) ) ).

tff(fact_9_le__funD,axiom,
    ! [C: $tType,B: $tType] :
      ( ord(C)
     => ! [X2: B,G: fun(B,C),F: fun(B,C)] :
          ( ord_less_eq(fun(B,C),F,G)
         => ord_less_eq(C,aa(B,C,F,X2),aa(B,C,G,X2)) ) ) ).

tff(fact_10_le__funE,axiom,
    ! [C: $tType,B: $tType] :
      ( ord(C)
     => ! [X2: B,G: fun(B,C),F: fun(B,C)] :
          ( ord_less_eq(fun(B,C),F,G)
         => ord_less_eq(C,aa(B,C,F,X2),aa(B,C,G,X2)) ) ) ).

tff(fact_11_subset__refl,axiom,
    ! [B: $tType,A2: fun(B,bool)] : ord_less_eq(fun(B,bool),A2,A2) ).

tff(fact_12_set__eq__subset,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ( A2 = B2 )
    <=> ( ord_less_eq(fun(B,bool),A2,B2)
        & ord_less_eq(fun(B,bool),B2,A2) ) ) ).

tff(fact_13_rev__predicate1D,axiom,
    ! [B: $tType,Q1: fun(B,bool),X2: B,P1: fun(B,bool)] :
      ( pp(aa(B,bool,P1,X2))
     => ( ord_less_eq(fun(B,bool),P1,Q1)
       => pp(aa(B,bool,Q1,X2)) ) ) ).

tff(fact_14_equalityD1,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ( A2 = B2 )
     => ord_less_eq(fun(B,bool),A2,B2) ) ).

tff(fact_15_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X3: A] :
          ( ~ ord_less_eq(A,X3,Y1)
         => ord_less_eq(A,Y1,X3) ) ) ).

tff(fact_16_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y1: A,X3: A] :
          ( ord_less_eq(A,X3,Y1)
         => ( ord_less_eq(A,Y1,Z)
           => ord_less_eq(A,X3,Z) ) ) ) ).

tff(fact_17_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X3: A] :
          ( ord_less_eq(A,X3,Y1)
         => ( ord_less_eq(A,Y1,X3)
           => ( X3 = Y1 ) ) ) ) ).

tff(fact_18_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C3: A,B3: A,A3: A] :
          ( ord_less_eq(A,A3,B3)
         => ( ( B3 = C3 )
           => ord_less_eq(A,A3,C3) ) ) ) ).

tff(fact_19_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C3: A,B3: A,A3: A] :
          ( ( A3 = B3 )
         => ( ord_less_eq(A,B3,C3)
           => ord_less_eq(A,A3,C3) ) ) ) ).

tff(fact_20_order__antisym__conv,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [X2: B,Y: B] :
          ( ord_less_eq(B,Y,X2)
         => ( ord_less_eq(B,X2,Y)
          <=> ( X2 = Y ) ) ) ) ).

tff(fact_21_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X3: A] :
          ( ( X3 = Y1 )
         => ord_less_eq(A,X3,Y1) ) ) ).

tff(fact_22_order__eq__iff,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [Y: B,X2: B] :
          ( ( X2 = Y )
        <=> ( ord_less_eq(B,X2,Y)
            & ord_less_eq(B,Y,X2) ) ) ) ).

tff(fact_23_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X3: A] :
          ( ord_less_eq(A,X3,Y1)
          | ord_less_eq(A,Y1,X3) ) ) ).

tff(fact_24_equalityE,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ( A2 = B2 )
     => ~ ( ord_less_eq(fun(B,bool),A2,B2)
         => ~ ord_less_eq(fun(B,bool),B2,A2) ) ) ).

tff(fact_25_subset__trans,axiom,
    ! [B: $tType,C2: fun(B,bool),B2: fun(B,bool),A2: fun(B,bool)] :
      ( ord_less_eq(fun(B,bool),A2,B2)
     => ( ord_less_eq(fun(B,bool),B2,C2)
       => ord_less_eq(fun(B,bool),A2,C2) ) ) ).

tff(fact_26_set__mp,axiom,
    ! [B: $tType,X2: B,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ord_less_eq(fun(B,bool),A2,B2)
     => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A2))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),B2)) ) ) ).

tff(fact_27_set__rev__mp,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool),X2: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A2))
     => ( ord_less_eq(fun(B,bool),A2,B2)
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),B2)) ) ) ).

tff(fact_28_predicate1D,axiom,
    ! [B: $tType,X2: B,Q1: fun(B,bool),P1: fun(B,bool)] :
      ( ord_less_eq(fun(B,bool),P1,Q1)
     => ( pp(aa(B,bool,P1,X2))
       => pp(aa(B,bool,Q1,X2)) ) ) ).

tff(fact_29_in__mono,axiom,
    ! [B: $tType,X2: B,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ord_less_eq(fun(B,bool),A2,B2)
     => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A2))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),B2)) ) ) ).

tff(fact_30_equalityD2,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ( A2 = B2 )
     => ord_less_eq(fun(B,bool),B2,A2) ) ).

tff(fact_31_subsetI,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ! [X: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X),A2))
         => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X),B2)) )
     => ord_less_eq(fun(B,bool),A2,B2) ) ).

tff(fact_32_le__funI,axiom,
    ! [C: $tType,B: $tType] :
      ( ord(C)
     => ! [G: fun(B,C),F: fun(B,C)] :
          ( ! [X: B] : ord_less_eq(C,aa(B,C,F,X),aa(B,C,G,X))
         => ord_less_eq(fun(B,C),F,G) ) ) ).

tff(fact_33_predicate1I,axiom,
    ! [B: $tType,Q1: fun(B,bool),P1: fun(B,bool)] :
      ( ! [X: B] :
          ( pp(aa(B,bool,P1,X))
         => pp(aa(B,bool,Q1,X)) )
     => ord_less_eq(fun(B,bool),P1,Q1) ) ).

tff(fact_34_Collect__mono,axiom,
    ! [B: $tType,Q1: fun(B,bool),P1: fun(B,bool)] :
      ( ! [X: B] :
          ( pp(aa(B,bool,P1,X))
         => pp(aa(B,bool,Q1,X)) )
     => ord_less_eq(fun(B,bool),collect(B,P1),collect(B,Q1)) ) ).

tff(fact_35_order__subst1,axiom,
    ! [B: $tType,C: $tType] :
      ( ( order(C)
        & order(B) )
     => ! [C1: C,B1: C,F: fun(C,B),A1: B] :
          ( ord_less_eq(B,A1,aa(C,B,F,B1))
         => ( ord_less_eq(C,B1,C1)
           => ( ! [X: C,Y2: C] :
                  ( ord_less_eq(C,X,Y2)
                 => ord_less_eq(B,aa(C,B,F,X),aa(C,B,F,Y2)) )
             => ord_less_eq(B,A1,aa(C,B,F,C1)) ) ) ) ) ).

tff(fact_36_ord__eq__le__subst,axiom,
    ! [B: $tType,C: $tType] :
      ( ( ord(C)
        & ord(B) )
     => ! [C1: C,B1: C,F: fun(C,B),A1: B] :
          ( ( A1 = aa(C,B,F,B1) )
         => ( ord_less_eq(C,B1,C1)
           => ( ! [X: C,Y2: C] :
                  ( ord_less_eq(C,X,Y2)
                 => ord_less_eq(B,aa(C,B,F,X),aa(C,B,F,Y2)) )
             => ord_less_eq(B,A1,aa(C,B,F,C1)) ) ) ) ) ).

tff(fact_37_order__subst2,axiom,
    ! [B: $tType,C: $tType] :
      ( ( order(C)
        & order(B) )
     => ! [C1: C,F: fun(B,C),B1: B,A1: B] :
          ( ord_less_eq(B,A1,B1)
         => ( ord_less_eq(C,aa(B,C,F,B1),C1)
           => ( ! [X: B,Y2: B] :
                  ( ord_less_eq(B,X,Y2)
                 => ord_less_eq(C,aa(B,C,F,X),aa(B,C,F,Y2)) )
             => ord_less_eq(C,aa(B,C,F,A1),C1) ) ) ) ) ).

tff(fact_38_ord__le__eq__subst,axiom,
    ! [B: $tType,C: $tType] :
      ( ( ord(C)
        & ord(B) )
     => ! [C1: C,F: fun(B,C),B1: B,A1: B] :
          ( ord_less_eq(B,A1,B1)
         => ( ( aa(B,C,F,B1) = C1 )
           => ( ! [X: B,Y2: B] :
                  ( ord_less_eq(B,X,Y2)
                 => ord_less_eq(C,aa(B,C,F,X),aa(B,C,F,Y2)) )
             => ord_less_eq(C,aa(B,C,F,A1),C1) ) ) ) ) ).

tff(fact_39_Powp__mono,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ord_less_eq(fun(B,bool),A2,B2)
     => ord_less_eq(fun(fun(B,bool),bool),powp(B,A2),powp(B,B2)) ) ).

tff(fact_40_in__inv__imagep,axiom,
    ! [B: $tType,C: $tType,Y: C,X2: C,F: fun(C,B),R1: fun(B,fun(B,bool))] :
      ( inv_imagep(B,C,R1,F,X2,Y)
    <=> pp(aa(B,bool,aa(B,fun(B,bool),R1,aa(C,B,F,X2)),aa(C,B,F,Y))) ) ).

tff(fact_41_triples__valid__Suc,axiom,
    ! [B: $tType,N2: nat,Tsa: fun(hoare_28830079triple(B),bool)] :
      ( ! [X: hoare_28830079triple(B)] :
          ( pp(aa(fun(hoare_28830079triple(B),bool),bool,aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),bool),member(hoare_28830079triple(B)),X),Tsa))
         => hoare_1633586161_valid(B,suc(N2),X) )
     => ! [X1: hoare_28830079triple(B)] :
          ( pp(aa(fun(hoare_28830079triple(B),bool),bool,aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),bool),member(hoare_28830079triple(B)),X1),Tsa))
         => hoare_1633586161_valid(B,N2,X1) ) ) ).

tff(fact_42_strict__mono__less__eq,axiom,
    ! [C: $tType,B: $tType] :
      ( ( linorder(B)
        & order(C) )
     => ! [Y: B,X2: B,F: fun(B,C)] :
          ( order_strict_mono(B,C,F)
         => ( ord_less_eq(C,aa(B,C,F,X2),aa(B,C,F,Y))
          <=> ord_less_eq(B,X2,Y) ) ) ) ).

tff(fact_43_greaterThan__subset__iff,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [Y: B,X2: B] :
          ( ord_less_eq(fun(B,bool),ord_greaterThan(B,X2),ord_greaterThan(B,Y))
        <=> ord_less_eq(B,Y,X2) ) ) ).

tff(fact_44_greaterThan__eq__iff,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [Y: B,X2: B] :
          ( ( ord_greaterThan(B,X2) = ord_greaterThan(B,Y) )
        <=> ( X2 = Y ) ) ) ).

tff(fact_45_strict__mono__eq,axiom,
    ! [C: $tType,B: $tType] :
      ( ( linorder(B)
        & order(C) )
     => ! [Y: B,X2: B,F: fun(B,C)] :
          ( order_strict_mono(B,C,F)
         => ( ( aa(B,C,F,X2) = aa(B,C,F,Y) )
          <=> ( X2 = Y ) ) ) ) ).

tff(fact_46_triple__valid__Suc,axiom,
    ! [A: $tType,T: hoare_28830079triple(A),N3: nat] :
      ( hoare_1633586161_valid(A,suc(N3),T)
     => hoare_1633586161_valid(A,N3,T) ) ).

tff(fact_47_nat_Oinject,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( suc(Nat) = suc(Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_48_Suc__le__mono,axiom,
    ! [M5: nat,N2: nat] :
      ( ord_less_eq(nat,suc(N2),suc(M5))
    <=> ord_less_eq(nat,N2,M5) ) ).

tff(fact_49_lessThan__subset__iff,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [Y: B,X2: B] :
          ( ord_less_eq(fun(B,bool),ord_lessThan(B,X2),ord_lessThan(B,Y))
        <=> ord_less_eq(B,X2,Y) ) ) ).

tff(fact_50_lessThan__eq__iff,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [Y: B,X2: B] :
          ( ( ord_lessThan(B,X2) = ord_lessThan(B,Y) )
        <=> ( X2 = Y ) ) ) ).

tff(fact_51_le__antisym,axiom,
    ! [N3: nat,M4: nat] :
      ( ord_less_eq(nat,M4,N3)
     => ( ord_less_eq(nat,N3,M4)
       => ( M4 = N3 ) ) ) ).

tff(fact_52_le__trans,axiom,
    ! [K1: nat,J: nat,I1: nat] :
      ( ord_less_eq(nat,I1,J)
     => ( ord_less_eq(nat,J,K1)
       => ord_less_eq(nat,I1,K1) ) ) ).

tff(fact_53_eq__imp__le,axiom,
    ! [N3: nat,M4: nat] :
      ( ( M4 = N3 )
     => ord_less_eq(nat,M4,N3) ) ).

tff(fact_54_nat__le__linear,axiom,
    ! [N3: nat,M4: nat] :
      ( ord_less_eq(nat,M4,N3)
      | ord_less_eq(nat,N3,M4) ) ).

tff(fact_55_le__refl,axiom,
    ! [N3: nat] : ord_less_eq(nat,N3,N3) ).

tff(fact_56_Suc__n__not__le__n,axiom,
    ! [N3: nat] : ~ ord_less_eq(nat,suc(N3),N3) ).

tff(fact_57_not__less__eq__eq,axiom,
    ! [N2: nat,M5: nat] :
      ( ~ ord_less_eq(nat,M5,N2)
    <=> ord_less_eq(nat,suc(N2),M5) ) ).

tff(fact_58_le__Suc__eq,axiom,
    ! [N2: nat,M5: nat] :
      ( ord_less_eq(nat,M5,suc(N2))
    <=> ( ord_less_eq(nat,M5,N2)
        | ( M5 = suc(N2) ) ) ) ).

tff(fact_59_le__SucI,axiom,
    ! [N3: nat,M4: nat] :
      ( ord_less_eq(nat,M4,N3)
     => ord_less_eq(nat,M4,suc(N3)) ) ).

tff(fact_60_le__SucE,axiom,
    ! [N3: nat,M4: nat] :
      ( ord_less_eq(nat,M4,suc(N3))
     => ( ~ ord_less_eq(nat,M4,N3)
       => ( M4 = suc(N3) ) ) ) ).

tff(fact_61_Suc__leD,axiom,
    ! [N3: nat,M4: nat] :
      ( ord_less_eq(nat,suc(M4),N3)
     => ord_less_eq(nat,M4,N3) ) ).

tff(fact_62_Suc__inject,axiom,
    ! [Y1: nat,X3: nat] :
      ( ( suc(X3) = suc(Y1) )
     => ( X3 = Y1 ) ) ).

tff(fact_63_Suc__n__not__n,axiom,
    ! [N3: nat] : ( suc(N3) != N3 ) ).

tff(fact_64_n__not__Suc__n,axiom,
    ! [N3: nat] : ( N3 != suc(N3) ) ).

tff(fact_65_lift__Suc__mono__le,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [N4: nat,N2: nat,F: fun(nat,B)] :
          ( ! [N: nat] : ord_less_eq(B,aa(nat,B,F,N),aa(nat,B,F,suc(N)))
         => ( ord_less_eq(nat,N2,N4)
           => ord_less_eq(B,aa(nat,B,F,N2),aa(nat,B,F,N4)) ) ) ) ).

tff(fact_66_Suc__le__D,axiom,
    ! [M3: nat,N3: nat] :
      ( ord_less_eq(nat,suc(N3),M3)
     => ? [M1: nat] : ( M3 = suc(M1) ) ) ).

tff(fact_67_of__nat__aux_Osimps_I2_J,axiom,
    ! [B: $tType] :
      ( semiring_1(B)
     => ! [I: B,N2: nat,Inc: fun(B,B)] : ( semiri532925092at_aux(B,Inc,suc(N2),I) = semiri532925092at_aux(B,Inc,N2,aa(B,B,Inc,I)) ) ) ).

tff(fact_68_full__nat__induct,axiom,
    ! [N2: nat,P1: fun(nat,bool)] :
      ( ! [N: nat] :
          ( ! [M2: nat] :
              ( ord_less_eq(nat,suc(M2),N)
             => pp(aa(nat,bool,P1,M2)) )
         => pp(aa(nat,bool,P1,N)) )
     => pp(aa(nat,bool,P1,N2)) ) ).

tff(fact_69_atLeast__subset__iff,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [Y: B,X2: B] :
          ( ord_less_eq(fun(B,bool),ord_atLeast(B,X2),ord_atLeast(B,Y))
        <=> ord_less_eq(B,Y,X2) ) ) ).

tff(fact_70_atMost__subset__iff,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [Y: B,X2: B] :
          ( ord_less_eq(fun(B,bool),ord_atMost(B,X2),ord_atMost(B,Y))
        <=> ord_less_eq(B,X2,Y) ) ) ).

tff(fact_71_Suc__le__D__lemma,axiom,
    ! [P1: fun(nat,bool),M: nat,N2: nat] :
      ( ord_less_eq(nat,suc(N2),M)
     => ( ! [M1: nat] :
            ( ord_less_eq(nat,N2,M1)
           => pp(aa(nat,bool,P1,suc(M1))) )
       => pp(aa(nat,bool,P1,M)) ) ) ).

tff(fact_72_atMost__eq__iff,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [Y: B,X2: B] :
          ( ( ord_atMost(B,X2) = ord_atMost(B,Y) )
        <=> ( X2 = Y ) ) ) ).

tff(fact_73_ext,axiom,
    ! [C: $tType,B: $tType,G: fun(B,C),F: fun(B,C)] :
      ( ! [X: B] : ( aa(B,C,F,X) = aa(B,C,G,X) )
     => ( F = G ) ) ).

tff(fact_74_mem__def,axiom,
    ! [B: $tType,A2: fun(B,bool),X2: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A2))
    <=> pp(aa(B,bool,A2,X2)) ) ).

tff(fact_75_Collect__def,axiom,
    ! [B: $tType,P1: fun(B,bool)] : ( collect(B,P1) = P1 ) ).

tff(fact_76_atLeast__eq__iff,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [Y: B,X2: B] :
          ( ( ord_atLeast(B,X2) = ord_atLeast(B,Y) )
        <=> ( X2 = Y ) ) ) ).

tff(fact_77_atMost__iff,axiom,
    ! [B: $tType] :
      ( ord(B)
     => ! [K: B,I: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),I),ord_atMost(B,K)))
        <=> ord_less_eq(B,I,K) ) ) ).

tff(fact_78_atLeast__iff,axiom,
    ! [B: $tType] :
      ( ord(B)
     => ! [K: B,I: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),I),ord_atLeast(B,K)))
        <=> ord_less_eq(B,K,I) ) ) ).

tff(fact_79_atLeast__Suc__greaterThan,axiom,
    ! [K: nat] : ( ord_atLeast(nat,suc(K)) = ord_greaterThan(nat,K) ) ).

tff(fact_80_lessThan__Suc__atMost,axiom,
    ! [K: nat] : ( ord_lessThan(nat,suc(K)) = ord_atMost(nat,K) ) ).

tff(fact_81_Compl__atMost,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [K: B] : ( uminus_uminus(fun(B,bool),ord_atMost(B,K)) = ord_greaterThan(B,K) ) ) ).

tff(fact_82_Compl__greaterThan,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [K: B] : ( uminus_uminus(fun(B,bool),ord_greaterThan(B,K)) = ord_atMost(B,K) ) ) ).

tff(fact_83_ComplI,axiom,
    ! [B: $tType,A2: fun(B,bool),C1: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),A2))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),uminus_uminus(fun(B,bool),A2))) ) ).

tff(fact_84_Compl__eq__Compl__iff,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ( uminus_uminus(fun(B,bool),A2) = uminus_uminus(fun(B,bool),B2) )
    <=> ( A2 = B2 ) ) ).

tff(fact_85_Compl__iff,axiom,
    ! [B: $tType,A2: fun(B,bool),C1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),uminus_uminus(fun(B,bool),A2)))
    <=> ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),A2)) ) ).

tff(fact_86_Compl__subset__Compl__iff,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ord_less_eq(fun(B,bool),uminus_uminus(fun(B,bool),A2),uminus_uminus(fun(B,bool),B2))
    <=> ord_less_eq(fun(B,bool),B2,A2) ) ).

tff(fact_87_Compl__atLeast,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [K: B] : ( uminus_uminus(fun(B,bool),ord_atLeast(B,K)) = ord_lessThan(B,K) ) ) ).

tff(fact_88_Compl__lessThan,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [K: B] : ( uminus_uminus(fun(B,bool),ord_lessThan(B,K)) = ord_atLeast(B,K) ) ) ).

tff(fact_89_Compl__anti__mono,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ord_less_eq(fun(B,bool),A2,B2)
     => ord_less_eq(fun(B,bool),uminus_uminus(fun(B,bool),B2),uminus_uminus(fun(B,bool),A2)) ) ).

tff(fact_90_ComplE,axiom,
    ! [B: $tType,A2: fun(B,bool),C1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),uminus_uminus(fun(B,bool),A2)))
     => ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),A2)) ) ).

tff(fact_91_ComplD,axiom,
    ! [B: $tType,A2: fun(B,bool),C1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),uminus_uminus(fun(B,bool),A2)))
     => ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),A2)) ) ).

tff(fact_92_double__complement,axiom,
    ! [B: $tType,A2: fun(B,bool)] : ( uminus_uminus(fun(B,bool),uminus_uminus(fun(B,bool),A2)) = A2 ) ).

tff(fact_93_Compl__eq,axiom,
    ! [B: $tType,A2: fun(B,bool)] : ( uminus_uminus(fun(B,bool),A2) = collect(B,combb(bool,bool,B,fNot,combc(B,fun(B,bool),bool,member(B),A2))) ) ).

tff(fact_94_neg__le__iff__le,axiom,
    ! [B: $tType] :
      ( ordered_ab_group_add(B)
     => ! [A1: B,B1: B] :
          ( ord_less_eq(B,uminus_uminus(B,B1),uminus_uminus(B,A1))
        <=> ord_less_eq(B,A1,B1) ) ) ).

tff(fact_95_compl__le__compl__iff,axiom,
    ! [B: $tType] :
      ( boolean_algebra(B)
     => ! [Y: B,X2: B] :
          ( ord_less_eq(B,uminus_uminus(B,X2),uminus_uminus(B,Y))
        <=> ord_less_eq(B,Y,X2) ) ) ).

tff(fact_96_compl__eq__compl__iff,axiom,
    ! [B: $tType] :
      ( boolean_algebra(B)
     => ! [Y: B,X2: B] :
          ( ( uminus_uminus(B,X2) = uminus_uminus(B,Y) )
        <=> ( X2 = Y ) ) ) ).

tff(fact_97_neg__equal__iff__equal,axiom,
    ! [B: $tType] :
      ( group_add(B)
     => ! [B1: B,A1: B] :
          ( ( uminus_uminus(B,A1) = uminus_uminus(B,B1) )
        <=> ( A1 = B1 ) ) ) ).

%----Arities (14)
tff(arity_fun___Lattices_Oboolean__algebra,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( boolean_algebra(T_2)
     => boolean_algebra(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_HOL_Obool___Lattices_Oboolean__algebra,axiom,
    boolean_algebra(bool) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (6)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

%----Conjectures (4)
tff(conj_0,hypothesis,
    hoare_992312373derivs(a,ga,ts) ).

tff(conj_1,hypothesis,
    ! [N1: nat] :
      ( ! [X: hoare_28830079triple(a)] :
          ( pp(aa(fun(hoare_28830079triple(a),bool),bool,aa(hoare_28830079triple(a),fun(fun(hoare_28830079triple(a),bool),bool),member(hoare_28830079triple(a)),X),ga))
         => hoare_1633586161_valid(a,N1,X) )
     => ! [X1: hoare_28830079triple(a)] :
          ( pp(aa(fun(hoare_28830079triple(a),bool),bool,aa(hoare_28830079triple(a),fun(fun(hoare_28830079triple(a),bool),bool),member(hoare_28830079triple(a)),X1),ts))
         => hoare_1633586161_valid(a,N1,X1) ) ) ).

tff(conj_2,hypothesis,
    ord_less_eq(fun(hoare_28830079triple(a),bool),tsa,ts) ).

tff(conj_3,conjecture,
    ! [N: nat] :
      ( ? [X1: hoare_28830079triple(a)] :
          ( pp(aa(fun(hoare_28830079triple(a),bool),bool,aa(hoare_28830079triple(a),fun(fun(hoare_28830079triple(a),bool),bool),member(hoare_28830079triple(a)),X1),ga))
          & ~ hoare_1633586161_valid(a,N,X1) )
      | ! [X: hoare_28830079triple(a)] :
          ( pp(aa(fun(hoare_28830079triple(a),bool),bool,aa(hoare_28830079triple(a),fun(fun(hoare_28830079triple(a),bool),bool),member(hoare_28830079triple(a)),X),tsa))
         => hoare_1633586161_valid(a,N,X) ) ) ).

%------------------------------------------------------------------------------
