%------------------------------------------------------------------------------
% File     : SWW520_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Hoare's Logic with Procedures line 283
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : hoare_283 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v6.4.0
% Syntax   : Number of formulae    :  159 (  36 unt;  33 typ;   0 def)
%            Number of atoms       :  302 (  52 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  200 (  24   ~;   5   |;   7   &)
%                                         (  20 <=>; 144  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   32 (  19   >;  13   *;   0   +;   0  <<)
%            Number of predicates  :   14 (  13 usr;   0 prp; 1-6 aty)
%            Number of functors    :   17 (  17 usr;   3 con; 0-4 aty)
%            Number of variables   :  373 ( 343   !;   3   ?; 373   :)
%                                         (  27  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:23:44
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Hoare__Mirabelle__vtrypsmcwp_Otriple,type,
    hoare_28830079triple: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Predicate_Opred,type,
    pred: $tType > $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (27)
tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Complete__Lattices_Ocomplete__lattice,type,
    comple187826305attice: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_Complete__Lattices_OSup__class_OSup,type,
    complete_Sup_Sup: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Ohoare__valids,type,
    hoare_592965047valids: 
      !>[A: $tType] : ( ( fun(hoare_28830079triple(A),bool) * fun(hoare_28830079triple(A),bool) ) > $o ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple__valid,type,
    hoare_1633586161_valid: 
      !>[A: $tType] : ( ( nat * hoare_28830079triple(A) ) > $o ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat__aux,type,
    semiri532925092at_aux: 
      !>[A: $tType] : ( ( fun(A,A) * nat * A ) > A ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Predicate_OPowp,type,
    powp: 
      !>[A: $tType] : ( fun(A,bool) > fun(fun(A,bool),bool) ) ).

tff(sy_c_Predicate_Oinv__imagep,type,
    inv_imagep: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(B,bool)) * fun(A,B) * A * A ) > $o ) ).

tff(sy_c_Predicate_Opred_OPred,type,
    pred1: 
      !>[A: $tType] : ( fun(A,bool) > pred(A) ) ).

tff(sy_c_Predicate_Opred_Opred__case,type,
    pred_case: 
      !>[A: $tType,T1: $tType] : ( ( fun(fun(A,bool),T1) * pred(A) ) > T1 ) ).

tff(sy_c_Predicate_Opred_Opred__rec,type,
    pred_rec: 
      !>[A: $tType,T1: $tType] : ( ( fun(fun(A,bool),T1) * pred(A) ) > T1 ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_Ga,type,
    ga: fun(hoare_28830079triple(a),bool) ).

%----Relevant facts (98)
tff(fact_0_ball__empty,axiom,
    ! [B: $tType,P1: fun(B,bool),X1: B] :
      ( member(B,X1,bot_bot(fun(B,bool)))
     => pp(aa(B,bool,P1,X1)) ) ).

tff(fact_1_all__not__in__conv,axiom,
    ! [B: $tType,A2: fun(B,bool)] :
      ( ! [X6: B] : ~ member(B,X6,A2)
    <=> ( A2 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_2_empty__Collect__eq,axiom,
    ! [B: $tType,P1: fun(B,bool)] :
      ( ( bot_bot(fun(B,bool)) = collect(B,P1) )
    <=> ! [X6: B] : ~ pp(aa(B,bool,P1,X6)) ) ).

tff(fact_3_empty__iff,axiom,
    ! [B: $tType,C1: B] : ~ member(B,C1,bot_bot(fun(B,bool))) ).

tff(fact_4_Collect__empty__eq,axiom,
    ! [B: $tType,P1: fun(B,bool)] :
      ( ( collect(B,P1) = bot_bot(fun(B,bool)) )
    <=> ! [X6: B] : ~ pp(aa(B,bool,P1,X6)) ) ).

tff(fact_5_emptyE,axiom,
    ! [B: $tType,A1: B] : ~ member(B,A1,bot_bot(fun(B,bool))) ).

tff(fact_6_hoare__valids__def,axiom,
    ! [B: $tType,Tsa: fun(hoare_28830079triple(B),bool),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_592965047valids(B,Ga,Tsa)
    <=> ! [N4: nat] :
          ( ! [X6: hoare_28830079triple(B)] :
              ( member(hoare_28830079triple(B),X6,Ga)
             => hoare_1633586161_valid(B,N4,X6) )
         => ! [X6: hoare_28830079triple(B)] :
              ( member(hoare_28830079triple(B),X6,Tsa)
             => hoare_1633586161_valid(B,N4,X6) ) ) ) ).

tff(fact_7_bot__fun__def,axiom,
    ! [B: $tType,C: $tType] :
      ( bot(C)
     => ! [X1: B] : ( aa(B,C,bot_bot(fun(B,C)),X1) = bot_bot(C) ) ) ).

tff(fact_8_bot__apply,axiom,
    ! [C: $tType,B: $tType] :
      ( bot(B)
     => ! [X4: C] : ( aa(C,B,bot_bot(fun(C,B)),X4) = bot_bot(B) ) ) ).

tff(fact_9_bot__empty__eq,axiom,
    ! [B: $tType,X1: B] :
      ( pp(aa(B,bool,bot_bot(fun(B,bool)),X1))
    <=> member(B,X1,bot_bot(fun(B,bool))) ) ).

tff(fact_10_empty__def,axiom,
    ! [B: $tType] : ( bot_bot(fun(B,bool)) = collect(B,combk(bool,B,fFalse)) ) ).

tff(fact_11_equals0D,axiom,
    ! [B: $tType,A1: B,A2: fun(B,bool)] :
      ( ( A2 = bot_bot(fun(B,bool)) )
     => ~ member(B,A1,A2) ) ).

tff(fact_12_ex__in__conv,axiom,
    ! [B: $tType,A2: fun(B,bool)] :
      ( ? [X6: B] : member(B,X6,A2)
    <=> ( A2 != bot_bot(fun(B,bool)) ) ) ).

tff(fact_13_equals0I,axiom,
    ! [B: $tType,A2: fun(B,bool)] :
      ( ! [Y: B] : ~ member(B,Y,A2)
     => ( A2 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_14_in__inv__imagep,axiom,
    ! [B: $tType,C: $tType,Y1: C,X4: C,F: fun(C,B),R1: fun(B,fun(B,bool))] :
      ( inv_imagep(B,C,R1,F,X4,Y1)
    <=> pp(aa(B,bool,aa(B,fun(B,bool),R1,aa(C,B,F,X4)),aa(C,B,F,Y1))) ) ).

tff(fact_15_triples__valid__Suc,axiom,
    ! [B: $tType,N1: nat,Tsa: fun(hoare_28830079triple(B),bool)] :
      ( ! [X: hoare_28830079triple(B)] :
          ( member(hoare_28830079triple(B),X,Tsa)
         => hoare_1633586161_valid(B,suc(N1),X) )
     => ! [X1: hoare_28830079triple(B)] :
          ( member(hoare_28830079triple(B),X1,Tsa)
         => hoare_1633586161_valid(B,N1,X1) ) ) ).

tff(fact_16_Sup__empty,axiom,
    ! [B: $tType] :
      ( comple187826305attice(B)
     => ( complete_Sup_Sup(B,bot_bot(fun(B,bool))) = bot_bot(B) ) ) ).

tff(fact_17_bot__pred__def,axiom,
    ! [B: $tType] : ( bot_bot(pred(B)) = pred1(B,bot_bot(fun(B,bool))) ) ).

tff(fact_18_ball__reg,axiom,
    ! [B: $tType,Q1: fun(B,bool),P1: fun(B,bool),R: fun(B,bool)] :
      ( ! [X: B] :
          ( member(B,X,R)
         => ( pp(aa(B,bool,P1,X))
           => pp(aa(B,bool,Q1,X)) ) )
     => ( ! [X: B] :
            ( member(B,X,R)
           => pp(aa(B,bool,P1,X)) )
       => ! [X1: B] :
            ( member(B,X1,R)
           => pp(aa(B,bool,Q1,X1)) ) ) ) ).

tff(fact_19_triple__valid__Suc,axiom,
    ! [A: $tType,T: hoare_28830079triple(A),N2: nat] :
      ( hoare_1633586161_valid(A,suc(N2),T)
     => hoare_1633586161_valid(A,N2,T) ) ).

tff(fact_20_subset__empty,axiom,
    ! [B: $tType,A2: fun(B,bool)] :
      ( ord_less_eq(fun(B,bool),A2,bot_bot(fun(B,bool)))
    <=> ( A2 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_21_empty__subsetI,axiom,
    ! [B: $tType,A2: fun(B,bool)] : ord_less_eq(fun(B,bool),bot_bot(fun(B,bool)),A2) ).

tff(fact_22_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X3: A] : ord_less_eq(A,X3,X3) ) ).

tff(fact_23_subsetD,axiom,
    ! [B: $tType,C1: B,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ord_less_eq(fun(B,bool),A2,B2)
     => ( member(B,C1,A2)
       => member(B,C1,B2) ) ) ).

tff(fact_24_equalityI,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ord_less_eq(fun(B,bool),A2,B2)
     => ( ord_less_eq(fun(B,bool),B2,A2)
       => ( A2 = B2 ) ) ) ).

tff(fact_25_pred_Oinject,axiom,
    ! [B: $tType,Fun2: fun(B,bool),Fun1: fun(B,bool)] :
      ( ( pred1(B,Fun1) = pred1(B,Fun2) )
    <=> ( Fun1 = Fun2 ) ) ).

tff(fact_26_subset__refl,axiom,
    ! [B: $tType,A2: fun(B,bool)] : ord_less_eq(fun(B,bool),A2,A2) ).

tff(fact_27_le__fun__def,axiom,
    ! [C: $tType,B: $tType] :
      ( ord(C)
     => ! [G: fun(B,C),F: fun(B,C)] :
          ( ord_less_eq(fun(B,C),F,G)
        <=> ! [X6: B] : ord_less_eq(C,aa(B,C,F,X6),aa(B,C,G,X6)) ) ) ).

tff(fact_28_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X3: A] :
          ( ord_less_eq(A,X3,Y2)
          | ord_less_eq(A,Y2,X3) ) ) ).

tff(fact_29_set__eq__subset,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ( A2 = B2 )
    <=> ( ord_less_eq(fun(B,bool),A2,B2)
        & ord_less_eq(fun(B,bool),B2,A2) ) ) ).

tff(fact_30_order__eq__iff,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [Y1: B,X4: B] :
          ( ( X4 = Y1 )
        <=> ( ord_less_eq(B,X4,Y1)
            & ord_less_eq(B,Y1,X4) ) ) ) ).

tff(fact_31_rev__predicate1D,axiom,
    ! [B: $tType,Q1: fun(B,bool),X4: B,P1: fun(B,bool)] :
      ( pp(aa(B,bool,P1,X4))
     => ( ord_less_eq(fun(B,bool),P1,Q1)
       => pp(aa(B,bool,Q1,X4)) ) ) ).

tff(fact_32_equalityD1,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ( A2 = B2 )
     => ord_less_eq(fun(B,bool),A2,B2) ) ).

tff(fact_33_equalityD2,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ( A2 = B2 )
     => ord_less_eq(fun(B,bool),B2,A2) ) ).

tff(fact_34_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X3: A] :
          ( ( X3 = Y2 )
         => ord_less_eq(A,X3,Y2) ) ) ).

tff(fact_35_le__funD,axiom,
    ! [C: $tType,B: $tType] :
      ( ord(C)
     => ! [X4: B,G: fun(B,C),F: fun(B,C)] :
          ( ord_less_eq(fun(B,C),F,G)
         => ord_less_eq(C,aa(B,C,F,X4),aa(B,C,G,X4)) ) ) ).

tff(fact_36_in__mono,axiom,
    ! [B: $tType,X4: B,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ord_less_eq(fun(B,bool),A2,B2)
     => ( member(B,X4,A2)
       => member(B,X4,B2) ) ) ).

tff(fact_37_order__antisym__conv,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [X4: B,Y1: B] :
          ( ord_less_eq(B,Y1,X4)
         => ( ord_less_eq(B,X4,Y1)
          <=> ( X4 = Y1 ) ) ) ) ).

tff(fact_38_predicate1D,axiom,
    ! [B: $tType,X4: B,Q1: fun(B,bool),P1: fun(B,bool)] :
      ( ord_less_eq(fun(B,bool),P1,Q1)
     => ( pp(aa(B,bool,P1,X4))
       => pp(aa(B,bool,Q1,X4)) ) ) ).

tff(fact_39_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C3: A,B3: A,A3: A] :
          ( ( A3 = B3 )
         => ( ord_less_eq(A,B3,C3)
           => ord_less_eq(A,A3,C3) ) ) ) ).

tff(fact_40_set__rev__mp,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool),X4: B] :
      ( member(B,X4,A2)
     => ( ord_less_eq(fun(B,bool),A2,B2)
       => member(B,X4,B2) ) ) ).

tff(fact_41_set__mp,axiom,
    ! [B: $tType,X4: B,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ord_less_eq(fun(B,bool),A2,B2)
     => ( member(B,X4,A2)
       => member(B,X4,B2) ) ) ).

tff(fact_42_subset__trans,axiom,
    ! [B: $tType,C2: fun(B,bool),B2: fun(B,bool),A2: fun(B,bool)] :
      ( ord_less_eq(fun(B,bool),A2,B2)
     => ( ord_less_eq(fun(B,bool),B2,C2)
       => ord_less_eq(fun(B,bool),A2,C2) ) ) ).

tff(fact_43_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C3: A,B3: A,A3: A] :
          ( ord_less_eq(A,A3,B3)
         => ( ( B3 = C3 )
           => ord_less_eq(A,A3,C3) ) ) ) ).

tff(fact_44_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X3: A] :
          ( ord_less_eq(A,X3,Y2)
         => ( ord_less_eq(A,Y2,X3)
           => ( X3 = Y2 ) ) ) ) ).

tff(fact_45_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z1: A,Y2: A,X3: A] :
          ( ord_less_eq(A,X3,Y2)
         => ( ord_less_eq(A,Y2,Z1)
           => ord_less_eq(A,X3,Z1) ) ) ) ).

tff(fact_46_equalityE,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ( A2 = B2 )
     => ~ ( ord_less_eq(fun(B,bool),A2,B2)
         => ~ ord_less_eq(fun(B,bool),B2,A2) ) ) ).

tff(fact_47_le__funE,axiom,
    ! [C: $tType,B: $tType] :
      ( ord(C)
     => ! [X4: B,G: fun(B,C),F: fun(B,C)] :
          ( ord_less_eq(fun(B,C),F,G)
         => ord_less_eq(C,aa(B,C,F,X4),aa(B,C,G,X4)) ) ) ).

tff(fact_48_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X3: A] :
          ( ~ ord_less_eq(A,X3,Y2)
         => ord_less_eq(A,Y2,X3) ) ) ).

tff(fact_49_Union__empty,axiom,
    ! [B: $tType] : ( complete_Sup_Sup(fun(B,bool),bot_bot(fun(fun(B,bool),bool))) = bot_bot(fun(B,bool)) ) ).

tff(fact_50_Sup__upper2,axiom,
    ! [B: $tType] :
      ( comple187826305attice(B)
     => ! [V1: B,A2: fun(B,bool),U: B] :
          ( member(B,U,A2)
         => ( ord_less_eq(B,V1,U)
           => ord_less_eq(B,V1,complete_Sup_Sup(B,A2)) ) ) ) ).

tff(fact_51_Union__mono,axiom,
    ! [B: $tType,B2: fun(fun(B,bool),bool),A2: fun(fun(B,bool),bool)] :
      ( ord_less_eq(fun(fun(B,bool),bool),A2,B2)
     => ord_less_eq(fun(B,bool),complete_Sup_Sup(fun(B,bool),A2),complete_Sup_Sup(fun(B,bool),B2)) ) ).

tff(fact_52_Sup__subset__mono,axiom,
    ! [B: $tType] :
      ( comple187826305attice(B)
     => ! [B2: fun(B,bool),A2: fun(B,bool)] :
          ( ord_less_eq(fun(B,bool),A2,B2)
         => ord_less_eq(B,complete_Sup_Sup(B,A2),complete_Sup_Sup(B,B2)) ) ) ).

tff(fact_53_Sup__upper,axiom,
    ! [B: $tType] :
      ( comple187826305attice(B)
     => ! [A2: fun(B,bool),X4: B] :
          ( member(B,X4,A2)
         => ord_less_eq(B,X4,complete_Sup_Sup(B,A2)) ) ) ).

tff(fact_54_Union__upper,axiom,
    ! [B: $tType,A2: fun(fun(B,bool),bool),B2: fun(B,bool)] :
      ( member(fun(B,bool),B2,A2)
     => ord_less_eq(fun(B,bool),B2,complete_Sup_Sup(fun(B,bool),A2)) ) ).

tff(fact_55_Sup__le__iff,axiom,
    ! [B: $tType] :
      ( comple187826305attice(B)
     => ! [B1: B,A2: fun(B,bool)] :
          ( ord_less_eq(B,complete_Sup_Sup(B,A2),B1)
        <=> ! [X6: B] :
              ( member(B,X6,A2)
             => ord_less_eq(B,X6,B1) ) ) ) ).

tff(fact_56_bot__least,axiom,
    ! [A: $tType] :
      ( bot(A)
     => ! [A3: A] : ord_less_eq(A,bot_bot(A),A3) ) ).

tff(fact_57_bot__unique,axiom,
    ! [B: $tType] :
      ( bot(B)
     => ! [A1: B] :
          ( ord_less_eq(B,A1,bot_bot(B))
        <=> ( A1 = bot_bot(B) ) ) ) ).

tff(fact_58_le__bot,axiom,
    ! [A: $tType] :
      ( bot(A)
     => ! [A3: A] :
          ( ord_less_eq(A,A3,bot_bot(A))
         => ( A3 = bot_bot(A) ) ) ) ).

tff(fact_59_subsetI,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ! [X: B] :
          ( member(B,X,A2)
         => member(B,X,B2) )
     => ord_less_eq(fun(B,bool),A2,B2) ) ).

tff(fact_60_less__eq__Sup,axiom,
    ! [B: $tType] :
      ( comple187826305attice(B)
     => ! [U: B,A2: fun(B,bool)] :
          ( ! [V: B] :
              ( member(B,V,A2)
             => ord_less_eq(B,U,V) )
         => ( ( A2 != bot_bot(fun(B,bool)) )
           => ord_less_eq(B,U,complete_Sup_Sup(B,A2)) ) ) ) ).

tff(fact_61_pred_Orecs,axiom,
    ! [B: $tType,C: $tType,Fun1: fun(C,bool),F1: fun(fun(C,bool),B)] : ( pred_rec(C,B,F1,pred1(C,Fun1)) = aa(fun(C,bool),B,F1,Fun1) ) ).

tff(fact_62_pred_Osimps_I2_J,axiom,
    ! [B: $tType,C: $tType,Fun1: fun(C,bool),F1: fun(fun(C,bool),B)] : ( pred_case(C,B,F1,pred1(C,Fun1)) = aa(fun(C,bool),B,F1,Fun1) ) ).

tff(fact_63_nat_Oinject,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( suc(Nat) = suc(Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_64_Sup__least,axiom,
    ! [B: $tType] :
      ( comple187826305attice(B)
     => ! [Z: B,A2: fun(B,bool)] :
          ( ! [X: B] :
              ( member(B,X,A2)
             => ord_less_eq(B,X,Z) )
         => ord_less_eq(B,complete_Sup_Sup(B,A2),Z) ) ) ).

tff(fact_65_Suc__le__mono,axiom,
    ! [M3: nat,N1: nat] :
      ( ord_less_eq(nat,suc(N1),suc(M3))
    <=> ord_less_eq(nat,N1,M3) ) ).

tff(fact_66_UnionI,axiom,
    ! [B: $tType,A2: B,C2: fun(fun(B,bool),bool),X5: fun(B,bool)] :
      ( member(fun(B,bool),X5,C2)
     => ( member(B,A2,X5)
       => member(B,A2,complete_Sup_Sup(fun(B,bool),C2)) ) ) ).

tff(fact_67_Suc__leD,axiom,
    ! [N2: nat,M2: nat] :
      ( ord_less_eq(nat,suc(M2),N2)
     => ord_less_eq(nat,M2,N2) ) ).

tff(fact_68_le__SucE,axiom,
    ! [N2: nat,M2: nat] :
      ( ord_less_eq(nat,M2,suc(N2))
     => ( ~ ord_less_eq(nat,M2,N2)
       => ( M2 = suc(N2) ) ) ) ).

tff(fact_69_le__SucI,axiom,
    ! [N2: nat,M2: nat] :
      ( ord_less_eq(nat,M2,N2)
     => ord_less_eq(nat,M2,suc(N2)) ) ).

tff(fact_70_le__Suc__eq,axiom,
    ! [N1: nat,M3: nat] :
      ( ord_less_eq(nat,M3,suc(N1))
    <=> ( ord_less_eq(nat,M3,N1)
        | ( M3 = suc(N1) ) ) ) ).

tff(fact_71_not__less__eq__eq,axiom,
    ! [N1: nat,M3: nat] :
      ( ~ ord_less_eq(nat,M3,N1)
    <=> ord_less_eq(nat,suc(N1),M3) ) ).

tff(fact_72_Suc__n__not__le__n,axiom,
    ! [N2: nat] : ~ ord_less_eq(nat,suc(N2),N2) ).

tff(fact_73_ext,axiom,
    ! [C: $tType,B: $tType,G: fun(B,C),F: fun(B,C)] :
      ( ! [X: B] : ( aa(B,C,F,X) = aa(B,C,G,X) )
     => ( F = G ) ) ).

tff(fact_74_mem__def,axiom,
    ! [B: $tType,A2: fun(B,bool),X4: B] :
      ( member(B,X4,A2)
    <=> pp(aa(B,bool,A2,X4)) ) ).

tff(fact_75_Collect__def,axiom,
    ! [B: $tType,P1: fun(B,bool)] : ( collect(B,P1) = P1 ) ).

tff(fact_76_n__not__Suc__n,axiom,
    ! [N2: nat] : ( N2 != suc(N2) ) ).

tff(fact_77_Suc__n__not__n,axiom,
    ! [N2: nat] : ( suc(N2) != N2 ) ).

tff(fact_78_Suc__inject,axiom,
    ! [Y2: nat,X3: nat] :
      ( ( suc(X3) = suc(Y2) )
     => ( X3 = Y2 ) ) ).

tff(fact_79_UnionE,axiom,
    ! [B: $tType,C2: fun(fun(B,bool),bool),A2: B] :
      ( member(B,A2,complete_Sup_Sup(fun(B,bool),C2))
     => ~ ! [X2: fun(B,bool)] :
            ( member(B,A2,X2)
           => ~ member(fun(B,bool),X2,C2) ) ) ).

tff(fact_80_Union__least,axiom,
    ! [B: $tType,C2: fun(B,bool),A2: fun(fun(B,bool),bool)] :
      ( ! [X2: fun(B,bool)] :
          ( member(fun(B,bool),X2,A2)
         => ord_less_eq(fun(B,bool),X2,C2) )
     => ord_less_eq(fun(B,bool),complete_Sup_Sup(fun(B,bool),A2),C2) ) ).

tff(fact_81_le__funI,axiom,
    ! [C: $tType,B: $tType] :
      ( ord(C)
     => ! [G: fun(B,C),F: fun(B,C)] :
          ( ! [X: B] : ord_less_eq(C,aa(B,C,F,X),aa(B,C,G,X))
         => ord_less_eq(fun(B,C),F,G) ) ) ).

tff(fact_82_le__antisym,axiom,
    ! [N2: nat,M2: nat] :
      ( ord_less_eq(nat,M2,N2)
     => ( ord_less_eq(nat,N2,M2)
       => ( M2 = N2 ) ) ) ).

tff(fact_83_le__trans,axiom,
    ! [K: nat,J: nat,I1: nat] :
      ( ord_less_eq(nat,I1,J)
     => ( ord_less_eq(nat,J,K)
       => ord_less_eq(nat,I1,K) ) ) ).

tff(fact_84_eq__imp__le,axiom,
    ! [N2: nat,M2: nat] :
      ( ( M2 = N2 )
     => ord_less_eq(nat,M2,N2) ) ).

tff(fact_85_nat__le__linear,axiom,
    ! [N2: nat,M2: nat] :
      ( ord_less_eq(nat,M2,N2)
      | ord_less_eq(nat,N2,M2) ) ).

tff(fact_86_le__refl,axiom,
    ! [N2: nat] : ord_less_eq(nat,N2,N2) ).

tff(fact_87_lift__Suc__mono__le,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [N3: nat,N1: nat,F: fun(nat,B)] :
          ( ! [N: nat] : ord_less_eq(B,aa(nat,B,F,N),aa(nat,B,F,suc(N)))
         => ( ord_less_eq(nat,N1,N3)
           => ord_less_eq(B,aa(nat,B,F,N1),aa(nat,B,F,N3)) ) ) ) ).

tff(fact_88_Suc__le__D,axiom,
    ! [M: nat,N2: nat] :
      ( ord_less_eq(nat,suc(N2),M)
     => ? [M1: nat] : ( M = suc(M1) ) ) ).

tff(fact_89_Powp__mono,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ord_less_eq(fun(B,bool),A2,B2)
     => ord_less_eq(fun(fun(B,bool),bool),powp(B,A2),powp(B,B2)) ) ).

tff(fact_90_pred_Oexhaust,axiom,
    ! [B: $tType,Y1: pred(B)] :
      ~ ! [Fun: fun(B,bool)] : ( Y1 != pred1(B,Fun) ) ).

tff(fact_91_of__nat__aux_Osimps_I2_J,axiom,
    ! [B: $tType] :
      ( semiring_1(B)
     => ! [I: B,N1: nat,Inc: fun(B,B)] : ( semiri532925092at_aux(B,Inc,suc(N1),I) = semiri532925092at_aux(B,Inc,N1,aa(B,B,Inc,I)) ) ) ).

tff(fact_92_Collect__mono,axiom,
    ! [B: $tType,Q1: fun(B,bool),P1: fun(B,bool)] :
      ( ! [X: B] :
          ( pp(aa(B,bool,P1,X))
         => pp(aa(B,bool,Q1,X)) )
     => ord_less_eq(fun(B,bool),collect(B,P1),collect(B,Q1)) ) ).

tff(fact_93_predicate1I,axiom,
    ! [B: $tType,Q1: fun(B,bool),P1: fun(B,bool)] :
      ( ! [X: B] :
          ( pp(aa(B,bool,P1,X))
         => pp(aa(B,bool,Q1,X)) )
     => ord_less_eq(fun(B,bool),P1,Q1) ) ).

tff(fact_94_order__subst1,axiom,
    ! [B: $tType,C: $tType] :
      ( ( order(C)
        & order(B) )
     => ! [C1: C,B1: C,F: fun(C,B),A1: B] :
          ( ord_less_eq(B,A1,aa(C,B,F,B1))
         => ( ord_less_eq(C,B1,C1)
           => ( ! [X: C,Y: C] :
                  ( ord_less_eq(C,X,Y)
                 => ord_less_eq(B,aa(C,B,F,X),aa(C,B,F,Y)) )
             => ord_less_eq(B,A1,aa(C,B,F,C1)) ) ) ) ) ).

tff(fact_95_ord__le__eq__subst,axiom,
    ! [B: $tType,C: $tType] :
      ( ( ord(C)
        & ord(B) )
     => ! [C1: C,F: fun(B,C),B1: B,A1: B] :
          ( ord_less_eq(B,A1,B1)
         => ( ( aa(B,C,F,B1) = C1 )
           => ( ! [X: B,Y: B] :
                  ( ord_less_eq(B,X,Y)
                 => ord_less_eq(C,aa(B,C,F,X),aa(B,C,F,Y)) )
             => ord_less_eq(C,aa(B,C,F,A1),C1) ) ) ) ) ).

tff(fact_96_order__subst2,axiom,
    ! [B: $tType,C: $tType] :
      ( ( order(C)
        & order(B) )
     => ! [C1: C,F: fun(B,C),B1: B,A1: B] :
          ( ord_less_eq(B,A1,B1)
         => ( ord_less_eq(C,aa(B,C,F,B1),C1)
           => ( ! [X: B,Y: B] :
                  ( ord_less_eq(B,X,Y)
                 => ord_less_eq(C,aa(B,C,F,X),aa(B,C,F,Y)) )
             => ord_less_eq(C,aa(B,C,F,A1),C1) ) ) ) ) ).

tff(fact_97_ord__eq__le__subst,axiom,
    ! [B: $tType,C: $tType] :
      ( ( ord(C)
        & ord(B) )
     => ! [C1: C,B1: C,F: fun(C,B),A1: B] :
          ( ( A1 = aa(C,B,F,B1) )
         => ( ord_less_eq(C,B1,C1)
           => ( ! [X: C,Y: C] :
                  ( ord_less_eq(C,X,Y)
                 => ord_less_eq(B,aa(C,B,F,X),aa(C,B,F,Y)) )
             => ord_less_eq(B,A1,aa(C,B,F,C1)) ) ) ) ) ).

%----Arities (22)
tff(arity_fun___Complete__Lattices_Ocomplete__lattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( comple187826305attice(T_2)
     => comple187826305attice(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_Nat_Onat___Orderings_Obot,axiom,
    bot(nat) ).

tff(arity_HOL_Obool___Complete__Lattices_Ocomplete__lattice,axiom,
    comple187826305attice(bool) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

tff(arity_Predicate_Opred___Complete__Lattices_Ocomplete__lattice,axiom,
    ! [T_1: $tType] : comple187826305attice(pred(T_1)) ).

tff(arity_Predicate_Opred___Orderings_Opreorder,axiom,
    ! [T_1: $tType] : preorder(pred(T_1)) ).

tff(arity_Predicate_Opred___Orderings_Oorder,axiom,
    ! [T_1: $tType] : order(pred(T_1)) ).

tff(arity_Predicate_Opred___Orderings_Oord,axiom,
    ! [T_1: $tType] : ord(pred(T_1)) ).

tff(arity_Predicate_Opred___Orderings_Obot,axiom,
    ! [T_1: $tType] : bot(pred(T_1)) ).

%----Helper facts (5)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ! [N: nat] :
      ( ? [X1: hoare_28830079triple(a)] :
          ( member(hoare_28830079triple(a),X1,ga)
          & ~ hoare_1633586161_valid(a,N,X1) )
      | ! [X: hoare_28830079triple(a)] :
          ( member(hoare_28830079triple(a),X,bot_bot(fun(hoare_28830079triple(a),bool)))
         => hoare_1633586161_valid(a,N,X) ) ) ).

%------------------------------------------------------------------------------
