%------------------------------------------------------------------------------
% File     : SWW514_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Hoare's Logic with Procedures line 237
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : hoare_237 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  177 (  44 unt;  48 typ;   0 def)
%            Number of atoms       :  296 ( 113 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  229 (  62   ~;  23   |;  20   &)
%                                         (  22 <=>; 102  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   17 (   6 avg)
%            Maximal term depth    :   13 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   31 (  19   >;  12   *;   0   +;   0  <<)
%            Number of predicates  :    9 (   8 usr;   0 prp; 1-4 aty)
%            Number of functors    :   35 (  35 usr;  14 con; 0-4 aty)
%            Number of variables   :  488 ( 444   !;   9   ?; 488   :)
%                                         (  35  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:17:34
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_t_b,type,
    b: $tType ).

tff(ty_tc_Com_Ocom,type,
    com: $tType ).

tff(ty_tc_Com_Ostate,type,
    state: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Hoare__Mirabelle__vtrypsmcwp_Otriple,type,
    hoare_28830079triple: $tType > $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (41)
tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Finite__Set_Ofinite,type,
    finite_finite1: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( fun(B,C) > fun(fun(A,B),fun(A,C)) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(B,fun(A,C))) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_Com_Ocom_OSKIP,type,
    skip: com ).

tff(sy_c_Com_Ocom_OSemi,type,
    semi: ( com * com ) > com ).

tff(sy_c_Com_Ocom_OWhile,type,
    while: ( fun(state,bool) * com ) > com ).

tff(sy_c_Finite__Set_Ofinite,type,
    finite_finite: 
      !>[A: $tType] : ( fun(A,bool) > $o ) ).

tff(sy_c_Finite__Set_Ofold1Set,type,
    finite_fold1Set: 
      !>[A: $tType] : ( ( fun(A,fun(A,A)) * fun(A,bool) * A ) > $o ) ).

tff(sy_c_Finite__Set_Ofolding__one,type,
    finite_folding_one: 
      !>[A: $tType] : ( ( fun(A,fun(A,A)) * fun(fun(A,bool),A) ) > $o ) ).

tff(sy_c_Finite__Set_Ofolding__one__idem,type,
    finite2073411215e_idem: 
      !>[A: $tType] : ( ( fun(A,fun(A,A)) * fun(fun(A,bool),A) ) > $o ) ).

tff(sy_c_HOL_OThe,type,
    the: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Ohoare__derivs,type,
    hoare_992312373derivs: 
      !>[A: $tType] : ( ( fun(hoare_28830079triple(A),bool) * fun(hoare_28830079triple(A),bool) ) > $o ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple,type,
    hoare_1841697145triple: 
      !>[A: $tType] : fun(fun(A,fun(state,bool)),fun(com,fun(fun(A,fun(state,bool)),hoare_28830079triple(A)))) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__case,type,
    hoare_376461865e_case: 
      !>[A: $tType,T1: $tType] : ( ( fun(fun(A,fun(state,bool)),fun(com,fun(fun(A,fun(state,bool)),T1))) * hoare_28830079triple(A) ) > T1 ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__rec,type,
    hoare_678420151le_rec: 
      !>[A: $tType,T1: $tType] : ( ( fun(fun(A,fun(state,bool)),fun(com,fun(fun(A,fun(state,bool)),T1))) * hoare_28830079triple(A) ) > T1 ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oimage,type,
    image: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,bool) ) > fun(B,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),fun(A,bool))) ).

tff(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_G,type,
    g: fun(hoare_28830079triple(b),bool) ).

tff(sy_v_P,type,
    p: fun(a,fun(b,fun(state,bool))) ).

tff(sy_v_P_H,type,
    p1: fun(a,fun(b,fun(state,bool))) ).

tff(sy_v_Q,type,
    q: fun(a,fun(b,fun(state,bool))) ).

tff(sy_v_Q_H,type,
    q1: fun(a,fun(b,fun(state,bool))) ).

tff(sy_v_U,type,
    u: fun(a,bool) ).

tff(sy_v_c0,type,
    c0: fun(a,com) ).

%----Relevant facts (100)
tff(fact_0_triple_Oinject,axiom,
    ! [C: $tType,Fun21: fun(C,fun(state,bool)),Com: com,Fun12: fun(C,fun(state,bool)),Fun2: fun(C,fun(state,bool)),Com3: com,Fun11: fun(C,fun(state,bool))] :
      ( ( aa(fun(C,fun(state,bool)),hoare_28830079triple(C),aa(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C))),hoare_1841697145triple(C),Fun11),Com3),Fun2) = aa(fun(C,fun(state,bool)),hoare_28830079triple(C),aa(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C))),hoare_1841697145triple(C),Fun12),Com),Fun21) )
    <=> ( ( Fun11 = Fun12 )
        & ( Com3 = Com )
        & ( Fun2 = Fun21 ) ) ) ).

tff(fact_1_empty,axiom,
    ! [C: $tType,Ga: fun(hoare_28830079triple(C),bool)] : hoare_992312373derivs(C,Ga,bot_bot(fun(hoare_28830079triple(C),bool))) ).

tff(fact_2_cut,axiom,
    ! [C: $tType,Ga: fun(hoare_28830079triple(C),bool),Ts: fun(hoare_28830079triple(C),bool),G1: fun(hoare_28830079triple(C),bool)] :
      ( hoare_992312373derivs(C,G1,Ts)
     => ( hoare_992312373derivs(C,Ga,G1)
       => hoare_992312373derivs(C,Ga,Ts) ) ) ).

tff(fact_3_hoare__derivs_Oinsert,axiom,
    ! [C: $tType,Ts: fun(hoare_28830079triple(C),bool),T: hoare_28830079triple(C),Ga: fun(hoare_28830079triple(C),bool)] :
      ( hoare_992312373derivs(C,Ga,aa(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool),aa(hoare_28830079triple(C),fun(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool)),insert(hoare_28830079triple(C)),T),bot_bot(fun(hoare_28830079triple(C),bool))))
     => ( hoare_992312373derivs(C,Ga,Ts)
       => hoare_992312373derivs(C,Ga,aa(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool),aa(hoare_28830079triple(C),fun(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool)),insert(hoare_28830079triple(C)),T),Ts)) ) ) ).

tff(fact_4_derivs__insertD,axiom,
    ! [C: $tType,Ts: fun(hoare_28830079triple(C),bool),T: hoare_28830079triple(C),Ga: fun(hoare_28830079triple(C),bool)] :
      ( hoare_992312373derivs(C,Ga,aa(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool),aa(hoare_28830079triple(C),fun(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool)),insert(hoare_28830079triple(C)),T),Ts))
     => ( hoare_992312373derivs(C,Ga,aa(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool),aa(hoare_28830079triple(C),fun(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool)),insert(hoare_28830079triple(C)),T),bot_bot(fun(hoare_28830079triple(C),bool))))
        & hoare_992312373derivs(C,Ga,Ts) ) ) ).

tff(fact_5_constant,axiom,
    ! [C: $tType,Qa: fun(C,fun(state,bool)),C1: com,Pa: fun(C,fun(state,bool)),Ga: fun(hoare_28830079triple(C),bool),C3: bool] :
      ( ( pp(C3)
       => hoare_992312373derivs(C,Ga,aa(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool),aa(hoare_28830079triple(C),fun(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool)),insert(hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),hoare_28830079triple(C),aa(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C))),hoare_1841697145triple(C),Pa),C1),Qa)),bot_bot(fun(hoare_28830079triple(C),bool)))) )
     => hoare_992312373derivs(C,Ga,aa(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool),aa(hoare_28830079triple(C),fun(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool)),insert(hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),hoare_28830079triple(C),aa(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C))),hoare_1841697145triple(C),aa(bool,fun(C,fun(state,bool)),aa(fun(C,fun(bool,fun(state,bool))),fun(bool,fun(C,fun(state,bool))),combc(C,bool,fun(state,bool)),aa(fun(C,fun(state,fun(bool,bool))),fun(C,fun(bool,fun(state,bool))),combb(fun(state,fun(bool,bool)),fun(bool,fun(state,bool)),C,combc(state,bool,bool)),aa(fun(C,fun(state,bool)),fun(C,fun(state,fun(bool,bool))),combb(fun(state,bool),fun(state,fun(bool,bool)),C,combb(bool,fun(bool,bool),state,fconj)),Pa))),C3)),C1),Qa)),bot_bot(fun(hoare_28830079triple(C),bool)))) ) ).

tff(fact_6_singleton__conv2,axiom,
    ! [C: $tType,A2: C] : ( collect(C,aa(C,fun(C,bool),fequal(C),A2)) = aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A2),bot_bot(fun(C,bool))) ) ).

tff(fact_7_singleton__conv,axiom,
    ! [C: $tType,A2: C] : ( collect(C,aa(C,fun(C,bool),aa(fun(C,fun(C,bool)),fun(C,fun(C,bool)),combc(C,C,bool),fequal(C)),A2)) = aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A2),bot_bot(fun(C,bool))) ) ).

tff(fact_8_escape,axiom,
    ! [C: $tType,Qa: fun(C,fun(state,bool)),C1: com,Ga: fun(hoare_28830079triple(C),bool),Pa: fun(C,fun(state,bool))] :
      ( ! [Z: C,S: state] :
          ( pp(aa(state,bool,aa(C,fun(state,bool),Pa,Z),S))
         => hoare_992312373derivs(C,Ga,aa(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool),aa(hoare_28830079triple(C),fun(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool)),insert(hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),hoare_28830079triple(C),aa(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C))),hoare_1841697145triple(C),combk(fun(state,bool),C,aa(state,fun(state,bool),aa(fun(state,fun(state,bool)),fun(state,fun(state,bool)),combc(state,state,bool),fequal(state)),S))),C1),combk(fun(state,bool),C,aa(C,fun(state,bool),Qa,Z)))),bot_bot(fun(hoare_28830079triple(C),bool)))) )
     => hoare_992312373derivs(C,Ga,aa(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool),aa(hoare_28830079triple(C),fun(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool)),insert(hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),hoare_28830079triple(C),aa(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C))),hoare_1841697145triple(C),Pa),C1),Qa)),bot_bot(fun(hoare_28830079triple(C),bool)))) ) ).

tff(fact_9_image__insert,axiom,
    ! [C: $tType,D1: $tType,B3: fun(D1,bool),A2: D1,F: fun(D1,C)] : ( image(D1,C,F,aa(fun(D1,bool),fun(D1,bool),aa(D1,fun(fun(D1,bool),fun(D1,bool)),insert(D1),A2),B3)) = aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),aa(D1,C,F,A2)),image(D1,C,F,B3)) ) ).

tff(fact_10_conseq2,axiom,
    ! [C: $tType,Qa: fun(C,fun(state,bool)),Q_a: fun(C,fun(state,bool)),C1: com,Pa: fun(C,fun(state,bool)),Ga: fun(hoare_28830079triple(C),bool)] :
      ( hoare_992312373derivs(C,Ga,aa(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool),aa(hoare_28830079triple(C),fun(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool)),insert(hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),hoare_28830079triple(C),aa(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C))),hoare_1841697145triple(C),Pa),C1),Q_a)),bot_bot(fun(hoare_28830079triple(C),bool))))
     => ( ! [Z: C,S: state] :
            ( pp(aa(state,bool,aa(C,fun(state,bool),Q_a,Z),S))
           => pp(aa(state,bool,aa(C,fun(state,bool),Qa,Z),S)) )
       => hoare_992312373derivs(C,Ga,aa(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool),aa(hoare_28830079triple(C),fun(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool)),insert(hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),hoare_28830079triple(C),aa(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C))),hoare_1841697145triple(C),Pa),C1),Qa)),bot_bot(fun(hoare_28830079triple(C),bool)))) ) ) ).

tff(fact_11_conseq1,axiom,
    ! [C: $tType,Pa: fun(C,fun(state,bool)),Qa: fun(C,fun(state,bool)),C1: com,P_a: fun(C,fun(state,bool)),Ga: fun(hoare_28830079triple(C),bool)] :
      ( hoare_992312373derivs(C,Ga,aa(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool),aa(hoare_28830079triple(C),fun(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool)),insert(hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),hoare_28830079triple(C),aa(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C))),hoare_1841697145triple(C),P_a),C1),Qa)),bot_bot(fun(hoare_28830079triple(C),bool))))
     => ( ! [Z: C,S: state] :
            ( pp(aa(state,bool,aa(C,fun(state,bool),Pa,Z),S))
           => pp(aa(state,bool,aa(C,fun(state,bool),P_a,Z),S)) )
       => hoare_992312373derivs(C,Ga,aa(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool),aa(hoare_28830079triple(C),fun(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool)),insert(hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),hoare_28830079triple(C),aa(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C))),hoare_1841697145triple(C),Pa),C1),Qa)),bot_bot(fun(hoare_28830079triple(C),bool)))) ) ) ).

tff(fact_12_finite__imageI,axiom,
    ! [D1: $tType,C: $tType,H: fun(C,D1),F1: fun(C,bool)] :
      ( finite_finite(C,F1)
     => finite_finite(D1,image(C,D1,H,F1)) ) ).

tff(fact_13_empty__is__image,axiom,
    ! [C: $tType,D1: $tType,A1: fun(D1,bool),F: fun(D1,C)] :
      ( ( bot_bot(fun(C,bool)) = image(D1,C,F,A1) )
    <=> ( A1 = bot_bot(fun(D1,bool)) ) ) ).

tff(fact_14_image__empty,axiom,
    ! [D1: $tType,C: $tType,F: fun(D1,C)] : ( image(D1,C,F,bot_bot(fun(D1,bool))) = bot_bot(fun(C,bool)) ) ).

tff(fact_15_image__is__empty,axiom,
    ! [C: $tType,D1: $tType,A1: fun(D1,bool),F: fun(D1,C)] :
      ( ( image(D1,C,F,A1) = bot_bot(fun(C,bool)) )
    <=> ( A1 = bot_bot(fun(D1,bool)) ) ) ).

tff(fact_16_finite__insert,axiom,
    ! [C: $tType,A1: fun(C,bool),A2: C] :
      ( finite_finite(C,aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A2),A1))
    <=> finite_finite(C,A1) ) ).

tff(fact_17_finite_OinsertI,axiom,
    ! [C: $tType,A2: C,A1: fun(C,bool)] :
      ( finite_finite(C,A1)
     => finite_finite(C,aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A2),A1)) ) ).

tff(fact_18_emptyE,axiom,
    ! [C: $tType,A2: C] : ~ pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),A2),bot_bot(fun(C,bool)))) ).

tff(fact_19_Collect__empty__eq,axiom,
    ! [C: $tType,Pa: fun(C,bool)] :
      ( ( collect(C,Pa) = bot_bot(fun(C,bool)) )
    <=> ! [X5: C] : ~ pp(aa(C,bool,Pa,X5)) ) ).

tff(fact_20_empty__iff,axiom,
    ! [C: $tType,C1: C] : ~ pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),C1),bot_bot(fun(C,bool)))) ).

tff(fact_21_empty__Collect__eq,axiom,
    ! [C: $tType,Pa: fun(C,bool)] :
      ( ( bot_bot(fun(C,bool)) = collect(C,Pa) )
    <=> ! [X5: C] : ~ pp(aa(C,bool,Pa,X5)) ) ).

tff(fact_22_all__not__in__conv,axiom,
    ! [C: $tType,A1: fun(C,bool)] :
      ( ! [X5: C] : ~ pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),X5),A1))
    <=> ( A1 = bot_bot(fun(C,bool)) ) ) ).

tff(fact_23_finite__code,axiom,
    ! [C: $tType] :
      ( finite_finite1(C)
     => ! [A1: fun(C,bool)] : finite_finite(C,A1) ) ).

tff(fact_24_insertCI,axiom,
    ! [C: $tType,B1: C,B3: fun(C,bool),A2: C] :
      ( ( ~ pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),A2),B3))
       => ( A2 = B1 ) )
     => pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),A2),aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),B1),B3))) ) ).

tff(fact_25_insertE,axiom,
    ! [C: $tType,A1: fun(C,bool),B1: C,A2: C] :
      ( pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),A2),aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),B1),A1)))
     => ( ( A2 != B1 )
       => pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),A2),A1)) ) ) ).

tff(fact_26_insert__iff,axiom,
    ! [C: $tType,A1: fun(C,bool),B1: C,A2: C] :
      ( pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),A2),aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),B1),A1)))
    <=> ( ( A2 = B1 )
        | pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),A2),A1)) ) ) ).

tff(fact_27_insert__absorb2,axiom,
    ! [C: $tType,A1: fun(C,bool),X2: C] : ( aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),X2),aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),X2),A1)) = aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),X2),A1) ) ).

tff(fact_28_image__eqI,axiom,
    ! [C: $tType,D1: $tType,A1: fun(D1,bool),X2: D1,F: fun(D1,C),B1: C] :
      ( ( B1 = aa(D1,C,F,X2) )
     => ( pp(aa(fun(D1,bool),bool,aa(D1,fun(fun(D1,bool),bool),member(D1),X2),A1))
       => pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),B1),image(D1,C,F,A1))) ) ) ).

tff(fact_29_finite__Collect__conjI,axiom,
    ! [C: $tType,Qa: fun(C,bool),Pa: fun(C,bool)] :
      ( ( finite_finite(C,collect(C,Pa))
        | finite_finite(C,collect(C,Qa)) )
     => finite_finite(C,collect(C,aa(fun(C,bool),fun(C,bool),aa(fun(C,fun(bool,bool)),fun(fun(C,bool),fun(C,bool)),combs(C,bool,bool),aa(fun(C,bool),fun(C,fun(bool,bool)),combb(bool,fun(bool,bool),C,fconj),Pa)),Qa))) ) ).

tff(fact_30_finite__Collect__disjI,axiom,
    ! [C: $tType,Qa: fun(C,bool),Pa: fun(C,bool)] :
      ( finite_finite(C,collect(C,aa(fun(C,bool),fun(C,bool),aa(fun(C,fun(bool,bool)),fun(fun(C,bool),fun(C,bool)),combs(C,bool,bool),aa(fun(C,bool),fun(C,fun(bool,bool)),combb(bool,fun(bool,bool),C,fdisj),Pa)),Qa)))
    <=> ( finite_finite(C,collect(C,Pa))
        & finite_finite(C,collect(C,Qa)) ) ) ).

tff(fact_31_finite_OemptyI,axiom,
    ! [C: $tType] : finite_finite(C,bot_bot(fun(C,bool))) ).

tff(fact_32_equals0D,axiom,
    ! [C: $tType,A2: C,A1: fun(C,bool)] :
      ( ( A1 = bot_bot(fun(C,bool)) )
     => ~ pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),A2),A1)) ) ).

tff(fact_33_ex__in__conv,axiom,
    ! [C: $tType,A1: fun(C,bool)] :
      ( ? [X5: C] : pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),X5),A1))
    <=> ( A1 != bot_bot(fun(C,bool)) ) ) ).

tff(fact_34_empty__def,axiom,
    ! [C: $tType] : ( bot_bot(fun(C,bool)) = collect(C,combk(bool,C,fFalse)) ) ).

tff(fact_35_finite,axiom,
    ! [C: $tType] :
      ( finite_finite1(C)
     => ! [A1: fun(C,bool)] : finite_finite(C,A1) ) ).

tff(fact_36_insert__absorb,axiom,
    ! [C: $tType,A1: fun(C,bool),A2: C] :
      ( pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),A2),A1))
     => ( aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A2),A1) = A1 ) ) ).

tff(fact_37_insertI2,axiom,
    ! [C: $tType,B1: C,B3: fun(C,bool),A2: C] :
      ( pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),A2),B3))
     => pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),A2),aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),B1),B3))) ) ).

tff(fact_38_insert__eq__iff,axiom,
    ! [C: $tType,B3: fun(C,bool),B1: C,A1: fun(C,bool),A2: C] :
      ( ~ pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),A2),A1))
     => ( ~ pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),B1),B3))
       => ( ( aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A2),A1) = aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),B1),B3) )
        <=> ( ( ( A2 = B1 )
             => ( A1 = B3 ) )
            & ( ( A2 != B1 )
             => ? [C2: fun(C,bool)] :
                  ( ( A1 = aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),B1),C2) )
                  & ~ pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),B1),C2))
                  & ( B3 = aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A2),C2) )
                  & ~ pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),A2),C2)) ) ) ) ) ) ) ).

tff(fact_39_insert__ident,axiom,
    ! [C: $tType,B3: fun(C,bool),A1: fun(C,bool),X2: C] :
      ( ~ pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),X2),A1))
     => ( ~ pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),X2),B3))
       => ( ( aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),X2),A1) = aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),X2),B3) )
        <=> ( A1 = B3 ) ) ) ) ).

tff(fact_40_insert__code,axiom,
    ! [C: $tType,X2: C,A1: fun(C,bool),Y3: C] :
      ( pp(aa(C,bool,aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),Y3),A1),X2))
    <=> ( ( Y3 = X2 )
        | pp(aa(C,bool,A1,X2)) ) ) ).

tff(fact_41_insert__commute,axiom,
    ! [C: $tType,A1: fun(C,bool),Y3: C,X2: C] : ( aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),X2),aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),Y3),A1)) = aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),Y3),aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),X2),A1)) ) ).

tff(fact_42_insert__Collect,axiom,
    ! [C: $tType,Pa: fun(C,bool),A2: C] : ( aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A2),collect(C,Pa)) = collect(C,aa(fun(C,bool),fun(C,bool),aa(fun(C,fun(bool,bool)),fun(fun(C,bool),fun(C,bool)),combs(C,bool,bool),aa(fun(C,bool),fun(C,fun(bool,bool)),combb(bool,fun(bool,bool),C,fimplies),aa(fun(C,bool),fun(C,bool),combb(bool,bool,C,fNot),aa(C,fun(C,bool),aa(fun(C,fun(C,bool)),fun(C,fun(C,bool)),combc(C,C,bool),fequal(C)),A2)))),Pa)) ) ).

tff(fact_43_insert__compr,axiom,
    ! [C: $tType,B3: fun(C,bool),A2: C] : ( aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A2),B3) = collect(C,aa(fun(C,bool),fun(C,bool),aa(fun(C,fun(bool,bool)),fun(fun(C,bool),fun(C,bool)),combs(C,bool,bool),aa(fun(C,bool),fun(C,fun(bool,bool)),combb(bool,fun(bool,bool),C,fdisj),aa(C,fun(C,bool),aa(fun(C,fun(C,bool)),fun(C,fun(C,bool)),combc(C,C,bool),fequal(C)),A2))),aa(fun(C,bool),fun(C,bool),aa(fun(C,fun(fun(C,bool),bool)),fun(fun(C,bool),fun(C,bool)),combc(C,fun(C,bool),bool),member(C)),B3))) ) ).

tff(fact_44_insertI1,axiom,
    ! [C: $tType,B3: fun(C,bool),A2: C] : pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),A2),aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A2),B3))) ).

tff(fact_45_rev__image__eqI,axiom,
    ! [D1: $tType,C: $tType,F: fun(C,D1),B1: D1,A1: fun(C,bool),X2: C] :
      ( pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),X2),A1))
     => ( ( B1 = aa(C,D1,F,X2) )
       => pp(aa(fun(D1,bool),bool,aa(D1,fun(fun(D1,bool),bool),member(D1),B1),image(C,D1,F,A1))) ) ) ).

tff(fact_46_imageI,axiom,
    ! [D1: $tType,C: $tType,F: fun(C,D1),A1: fun(C,bool),X2: C] :
      ( pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),X2),A1))
     => pp(aa(fun(D1,bool),bool,aa(D1,fun(fun(D1,bool),bool),member(D1),aa(C,D1,F,X2)),image(C,D1,F,A1))) ) ).

tff(fact_47_image__iff,axiom,
    ! [C: $tType,D1: $tType,A1: fun(D1,bool),F: fun(D1,C),Z2: C] :
      ( pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),Z2),image(D1,C,F,A1)))
    <=> ? [X5: D1] :
          ( pp(aa(fun(D1,bool),bool,aa(D1,fun(fun(D1,bool),bool),member(D1),X5),A1))
          & ( Z2 = aa(D1,C,F,X5) ) ) ) ).

tff(fact_48_insert__compr__raw,axiom,
    ! [C: $tType,X4: C,Xa: fun(C,bool)] : ( aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),X4),Xa) = collect(C,aa(fun(C,bool),fun(C,bool),aa(fun(C,fun(bool,bool)),fun(fun(C,bool),fun(C,bool)),combs(C,bool,bool),aa(fun(C,bool),fun(C,fun(bool,bool)),combb(bool,fun(bool,bool),C,fdisj),aa(C,fun(C,bool),aa(fun(C,fun(C,bool)),fun(C,fun(C,bool)),combc(C,C,bool),fequal(C)),X4))),aa(fun(C,bool),fun(C,bool),aa(fun(C,fun(fun(C,bool),bool)),fun(fun(C,bool),fun(C,bool)),combc(C,fun(C,bool),bool),member(C)),Xa))) ) ).

tff(fact_49_image__ident,axiom,
    ! [C: $tType,Y2: fun(C,bool)] : ( image(C,C,combi(C),Y2) = Y2 ) ).

tff(fact_50_image__image,axiom,
    ! [D1: $tType,C: $tType,E: $tType,A1: fun(E,bool),G: fun(E,D1),F: fun(D1,C)] : ( image(D1,C,F,image(E,D1,G,A1)) = image(E,C,aa(fun(E,D1),fun(E,C),combb(D1,C,E,F),G),A1) ) ).

tff(fact_51_singleton__inject,axiom,
    ! [C: $tType,B1: C,A2: C] :
      ( ( aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A2),bot_bot(fun(C,bool))) = aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),B1),bot_bot(fun(C,bool))) )
     => ( A2 = B1 ) ) ).

tff(fact_52_singletonE,axiom,
    ! [C: $tType,A2: C,B1: C] :
      ( pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),B1),aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A2),bot_bot(fun(C,bool)))))
     => ( B1 = A2 ) ) ).

tff(fact_53_doubleton__eq__iff,axiom,
    ! [C: $tType,D: C,C1: C,B1: C,A2: C] :
      ( ( aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A2),aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),B1),bot_bot(fun(C,bool)))) = aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),C1),aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),D),bot_bot(fun(C,bool)))) )
    <=> ( ( ( A2 = C1 )
          & ( B1 = D ) )
        | ( ( A2 = D )
          & ( B1 = C1 ) ) ) ) ).

tff(fact_54_singleton__iff,axiom,
    ! [C: $tType,A2: C,B1: C] :
      ( pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),B1),aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A2),bot_bot(fun(C,bool)))))
    <=> ( B1 = A2 ) ) ).

tff(fact_55_insert__not__empty,axiom,
    ! [C: $tType,A1: fun(C,bool),A2: C] : ( aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A2),A1) != bot_bot(fun(C,bool)) ) ).

tff(fact_56_empty__not__insert,axiom,
    ! [C: $tType,A1: fun(C,bool),A2: C] : ( bot_bot(fun(C,bool)) != aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A2),A1) ) ).

tff(fact_57_insert__image,axiom,
    ! [D1: $tType,C: $tType,F: fun(C,D1),A1: fun(C,bool),X2: C] :
      ( pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),X2),A1))
     => ( aa(fun(D1,bool),fun(D1,bool),aa(D1,fun(fun(D1,bool),fun(D1,bool)),insert(D1),aa(C,D1,F,X2)),image(C,D1,F,A1)) = image(C,D1,F,A1) ) ) ).

tff(fact_58_Collect__conv__if,axiom,
    ! [C: $tType,A2: C,Pa: fun(C,bool)] :
      ( ( pp(aa(C,bool,Pa,A2))
       => ( collect(C,aa(fun(C,bool),fun(C,bool),aa(fun(C,fun(bool,bool)),fun(fun(C,bool),fun(C,bool)),combs(C,bool,bool),aa(fun(C,bool),fun(C,fun(bool,bool)),combb(bool,fun(bool,bool),C,fconj),aa(C,fun(C,bool),aa(fun(C,fun(C,bool)),fun(C,fun(C,bool)),combc(C,C,bool),fequal(C)),A2))),Pa)) = aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A2),bot_bot(fun(C,bool))) ) )
      & ( ~ pp(aa(C,bool,Pa,A2))
       => ( collect(C,aa(fun(C,bool),fun(C,bool),aa(fun(C,fun(bool,bool)),fun(fun(C,bool),fun(C,bool)),combs(C,bool,bool),aa(fun(C,bool),fun(C,fun(bool,bool)),combb(bool,fun(bool,bool),C,fconj),aa(C,fun(C,bool),aa(fun(C,fun(C,bool)),fun(C,fun(C,bool)),combc(C,C,bool),fequal(C)),A2))),Pa)) = bot_bot(fun(C,bool)) ) ) ) ).

tff(fact_59_Collect__conv__if2,axiom,
    ! [C: $tType,A2: C,Pa: fun(C,bool)] :
      ( ( pp(aa(C,bool,Pa,A2))
       => ( collect(C,aa(fun(C,bool),fun(C,bool),aa(fun(C,fun(bool,bool)),fun(fun(C,bool),fun(C,bool)),combs(C,bool,bool),aa(fun(C,bool),fun(C,fun(bool,bool)),combb(bool,fun(bool,bool),C,fconj),aa(C,fun(C,bool),fequal(C),A2))),Pa)) = aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A2),bot_bot(fun(C,bool))) ) )
      & ( ~ pp(aa(C,bool,Pa,A2))
       => ( collect(C,aa(fun(C,bool),fun(C,bool),aa(fun(C,fun(bool,bool)),fun(fun(C,bool),fun(C,bool)),combs(C,bool,bool),aa(fun(C,bool),fun(C,fun(bool,bool)),combb(bool,fun(bool,bool),C,fconj),aa(C,fun(C,bool),fequal(C),A2))),Pa)) = bot_bot(fun(C,bool)) ) ) ) ).

tff(fact_60_image__constant,axiom,
    ! [C: $tType,D1: $tType,C1: D1,A1: fun(C,bool),X2: C] :
      ( pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),X2),A1))
     => ( image(C,D1,combk(D1,C,C1),A1) = aa(fun(D1,bool),fun(D1,bool),aa(D1,fun(fun(D1,bool),fun(D1,bool)),insert(D1),C1),bot_bot(fun(D1,bool))) ) ) ).

tff(fact_61_image__constant__conv,axiom,
    ! [C: $tType,D1: $tType,C1: D1,A1: fun(C,bool)] :
      ( ( ( A1 = bot_bot(fun(C,bool)) )
       => ( image(C,D1,combk(D1,C,C1),A1) = bot_bot(fun(D1,bool)) ) )
      & ( ( A1 != bot_bot(fun(C,bool)) )
       => ( image(C,D1,combk(D1,C,C1),A1) = aa(fun(D1,bool),fun(D1,bool),aa(D1,fun(fun(D1,bool),fun(D1,bool)),insert(D1),C1),bot_bot(fun(D1,bool))) ) ) ) ).

tff(fact_62_imageE,axiom,
    ! [C: $tType,D1: $tType,A1: fun(D1,bool),F: fun(D1,C),B1: C] :
      ( pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),B1),image(D1,C,F,A1)))
     => ~ ! [X1: D1] :
            ( ( B1 = aa(D1,C,F,X1) )
           => ~ pp(aa(fun(D1,bool),bool,aa(D1,fun(fun(D1,bool),bool),member(D1),X1),A1)) ) ) ).

tff(fact_63_finite__induct,axiom,
    ! [C: $tType,Pa: fun(fun(C,bool),bool),F1: fun(C,bool)] :
      ( finite_finite(C,F1)
     => ( pp(aa(fun(C,bool),bool,Pa,bot_bot(fun(C,bool))))
       => ( ! [X1: C,F2: fun(C,bool)] :
              ( finite_finite(C,F2)
             => ( ~ pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),X1),F2))
               => ( pp(aa(fun(C,bool),bool,Pa,F2))
                 => pp(aa(fun(C,bool),bool,Pa,aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),X1),F2))) ) ) )
         => pp(aa(fun(C,bool),bool,Pa,F1)) ) ) ) ).

tff(fact_64_finite_Osimps,axiom,
    ! [C: $tType,A2: fun(C,bool)] :
      ( finite_finite(C,A2)
    <=> ( ( A2 = bot_bot(fun(C,bool)) )
        | ? [A4: fun(C,bool),A3: C] :
            ( ( A2 = aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A3),A4) )
            & finite_finite(C,A4) ) ) ) ).

tff(fact_65_pigeonhole__infinite,axiom,
    ! [D1: $tType,C: $tType,F: fun(C,D1),A1: fun(C,bool)] :
      ( ~ finite_finite(C,A1)
     => ( finite_finite(D1,image(C,D1,F,A1))
       => ? [X1: C] :
            ( pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),X1),A1))
            & ~ finite_finite(C,collect(C,aa(fun(C,bool),fun(C,bool),aa(fun(C,fun(bool,bool)),fun(fun(C,bool),fun(C,bool)),combs(C,bool,bool),aa(fun(C,bool),fun(C,fun(bool,bool)),combb(bool,fun(bool,bool),C,fconj),aa(fun(C,bool),fun(C,bool),aa(fun(C,fun(fun(C,bool),bool)),fun(fun(C,bool),fun(C,bool)),combc(C,fun(C,bool),bool),member(C)),A1))),aa(D1,fun(C,bool),aa(fun(C,fun(D1,bool)),fun(D1,fun(C,bool)),combc(C,D1,bool),aa(fun(C,D1),fun(C,fun(D1,bool)),combb(D1,fun(D1,bool),C,fequal(D1)),F)),aa(C,D1,F,X1))))) ) ) ) ).

tff(fact_66_conseq12,axiom,
    ! [C: $tType,Qa: fun(C,fun(state,bool)),Pa: fun(C,fun(state,bool)),Q_a: fun(C,fun(state,bool)),C1: com,P_a: fun(C,fun(state,bool)),Ga: fun(hoare_28830079triple(C),bool)] :
      ( hoare_992312373derivs(C,Ga,aa(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool),aa(hoare_28830079triple(C),fun(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool)),insert(hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),hoare_28830079triple(C),aa(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C))),hoare_1841697145triple(C),P_a),C1),Q_a)),bot_bot(fun(hoare_28830079triple(C),bool))))
     => ( ! [Z: C,S: state] :
            ( pp(aa(state,bool,aa(C,fun(state,bool),Pa,Z),S))
           => ! [S1: state] :
                ( ! [Z1: C] :
                    ( pp(aa(state,bool,aa(C,fun(state,bool),P_a,Z1),S))
                   => pp(aa(state,bool,aa(C,fun(state,bool),Q_a,Z1),S1)) )
               => pp(aa(state,bool,aa(C,fun(state,bool),Qa,Z),S1)) ) )
       => hoare_992312373derivs(C,Ga,aa(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool),aa(hoare_28830079triple(C),fun(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool)),insert(hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),hoare_28830079triple(C),aa(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C))),hoare_1841697145triple(C),Pa),C1),Qa)),bot_bot(fun(hoare_28830079triple(C),bool)))) ) ) ).

tff(fact_67_the__elem__eq,axiom,
    ! [C: $tType,X2: C] : ( the_elem(C,aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),X2),bot_bot(fun(C,bool)))) = X2 ) ).

tff(fact_68_nonempty__iff,axiom,
    ! [C: $tType,A1: fun(C,bool)] :
      ( ( A1 != bot_bot(fun(C,bool)) )
    <=> ? [X5: C,B2: fun(C,bool)] :
          ( ( A1 = aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),X5),B2) )
          & ~ pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),X5),B2)) ) ) ).

tff(fact_69_triple_Osimps_I2_J,axiom,
    ! [C: $tType,D1: $tType,Fun2: fun(D1,fun(state,bool)),Com3: com,Fun11: fun(D1,fun(state,bool)),F11: fun(fun(D1,fun(state,bool)),fun(com,fun(fun(D1,fun(state,bool)),C)))] : ( hoare_376461865e_case(D1,C,F11,aa(fun(D1,fun(state,bool)),hoare_28830079triple(D1),aa(com,fun(fun(D1,fun(state,bool)),hoare_28830079triple(D1)),aa(fun(D1,fun(state,bool)),fun(com,fun(fun(D1,fun(state,bool)),hoare_28830079triple(D1))),hoare_1841697145triple(D1),Fun11),Com3),Fun2)) = aa(fun(D1,fun(state,bool)),C,aa(com,fun(fun(D1,fun(state,bool)),C),aa(fun(D1,fun(state,bool)),fun(com,fun(fun(D1,fun(state,bool)),C)),F11,Fun11),Com3),Fun2) ) ).

tff(fact_70_triple_Orecs,axiom,
    ! [C: $tType,D1: $tType,Fun2: fun(D1,fun(state,bool)),Com3: com,Fun11: fun(D1,fun(state,bool)),F11: fun(fun(D1,fun(state,bool)),fun(com,fun(fun(D1,fun(state,bool)),C)))] : ( hoare_678420151le_rec(D1,C,F11,aa(fun(D1,fun(state,bool)),hoare_28830079triple(D1),aa(com,fun(fun(D1,fun(state,bool)),hoare_28830079triple(D1)),aa(fun(D1,fun(state,bool)),fun(com,fun(fun(D1,fun(state,bool)),hoare_28830079triple(D1))),hoare_1841697145triple(D1),Fun11),Com3),Fun2)) = aa(fun(D1,fun(state,bool)),C,aa(com,fun(fun(D1,fun(state,bool)),C),aa(fun(D1,fun(state,bool)),fun(com,fun(fun(D1,fun(state,bool)),C)),F11,Fun11),Com3),Fun2) ) ).

tff(fact_71_bot__fun__def,axiom,
    ! [C: $tType,D1: $tType] :
      ( bot(D1)
     => ! [X4: C] : ( aa(C,D1,bot_bot(fun(C,D1)),X4) = bot_bot(D1) ) ) ).

tff(fact_72_bot__apply,axiom,
    ! [D1: $tType,C: $tType] :
      ( bot(C)
     => ! [X2: D1] : ( aa(D1,C,bot_bot(fun(D1,C)),X2) = bot_bot(C) ) ) ).

tff(fact_73_hoare__derivs_OSkip,axiom,
    ! [C: $tType,Pa: fun(C,fun(state,bool)),Ga: fun(hoare_28830079triple(C),bool)] : hoare_992312373derivs(C,Ga,aa(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool),aa(hoare_28830079triple(C),fun(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool)),insert(hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),hoare_28830079triple(C),aa(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C))),hoare_1841697145triple(C),Pa),skip),Pa)),bot_bot(fun(hoare_28830079triple(C),bool)))) ).

tff(fact_74_folding__one__idem_Oinsert__idem,axiom,
    ! [C: $tType,X2: C,A1: fun(C,bool),F1: fun(fun(C,bool),C),F: fun(C,fun(C,C))] :
      ( finite2073411215e_idem(C,F,F1)
     => ( finite_finite(C,A1)
       => ( ( A1 != bot_bot(fun(C,bool)) )
         => ( aa(fun(C,bool),C,F1,aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),X2),A1)) = aa(C,C,aa(C,fun(C,C),F,X2),aa(fun(C,bool),C,F1,A1)) ) ) ) ) ).

tff(fact_75_ext,axiom,
    ! [D1: $tType,C: $tType,G: fun(C,D1),F: fun(C,D1)] :
      ( ! [X1: C] : ( aa(C,D1,F,X1) = aa(C,D1,G,X1) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [C: $tType,A1: fun(C,bool),X2: C] :
      ( pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),X2),A1))
    <=> pp(aa(C,bool,A1,X2)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [C: $tType,Pa: fun(C,bool)] : ( collect(C,Pa) = Pa ) ).

tff(fact_78_folding__one__idem_Oidem,axiom,
    ! [C: $tType,X2: C,F1: fun(fun(C,bool),C),F: fun(C,fun(C,C))] :
      ( finite2073411215e_idem(C,F,F1)
     => ( aa(C,C,aa(C,fun(C,C),F,X2),X2) = X2 ) ) ).

tff(fact_79_folding__one__idem_Oin__idem,axiom,
    ! [C: $tType,X2: C,A1: fun(C,bool),F1: fun(fun(C,bool),C),F: fun(C,fun(C,C))] :
      ( finite2073411215e_idem(C,F,F1)
     => ( finite_finite(C,A1)
       => ( pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),X2),A1))
         => ( aa(C,C,aa(C,fun(C,C),F,X2),aa(fun(C,bool),C,F1,A1)) = aa(fun(C,bool),C,F1,A1) ) ) ) ) ).

tff(fact_80_folding__one__idem_Ohom__commute,axiom,
    ! [C: $tType,N: fun(C,bool),H: fun(C,C),F1: fun(fun(C,bool),C),F: fun(C,fun(C,C))] :
      ( finite2073411215e_idem(C,F,F1)
     => ( ! [X1: C,Y1: C] : ( aa(C,C,H,aa(C,C,aa(C,fun(C,C),F,X1),Y1)) = aa(C,C,aa(C,fun(C,C),F,aa(C,C,H,X1)),aa(C,C,H,Y1)) )
       => ( finite_finite(C,N)
         => ( ( N != bot_bot(fun(C,bool)) )
           => ( aa(C,C,H,aa(fun(C,bool),C,F1,N)) = aa(fun(C,bool),C,F1,image(C,C,H,N)) ) ) ) ) ) ).

tff(fact_81_LoopF,axiom,
    ! [C: $tType,C1: com,B1: fun(state,bool),Pa: fun(C,fun(state,bool)),Ga: fun(hoare_28830079triple(C),bool)] : hoare_992312373derivs(C,Ga,aa(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool),aa(hoare_28830079triple(C),fun(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool)),insert(hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),hoare_28830079triple(C),aa(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C))),hoare_1841697145triple(C),aa(fun(state,bool),fun(C,fun(state,bool)),aa(fun(C,fun(fun(state,bool),fun(state,bool))),fun(fun(state,bool),fun(C,fun(state,bool))),combc(C,fun(state,bool),fun(state,bool)),aa(fun(C,fun(state,fun(bool,bool))),fun(C,fun(fun(state,bool),fun(state,bool))),combb(fun(state,fun(bool,bool)),fun(fun(state,bool),fun(state,bool)),C,combs(state,bool,bool)),aa(fun(C,fun(state,bool)),fun(C,fun(state,fun(bool,bool))),combb(fun(state,bool),fun(state,fun(bool,bool)),C,combb(bool,fun(bool,bool),state,fconj)),Pa))),aa(fun(state,bool),fun(state,bool),combb(bool,bool,state,fNot),B1))),while(B1,C1)),Pa)),bot_bot(fun(hoare_28830079triple(C),bool)))) ).

tff(fact_82_com_Osimps_I5_J,axiom,
    ! [Com: com,Fun: fun(state,bool),Com3: com,Fun1: fun(state,bool)] :
      ( ( while(Fun1,Com3) = while(Fun,Com) )
    <=> ( ( Fun1 = Fun )
        & ( Com3 = Com ) ) ) ).

tff(fact_83_com_Osimps_I17_J,axiom,
    ! [Com: com,Fun: fun(state,bool)] : ( while(Fun,Com) != skip ) ).

tff(fact_84_com_Osimps_I16_J,axiom,
    ! [Com: com,Fun: fun(state,bool)] : ( skip != while(Fun,Com) ) ).

tff(fact_85_Comp,axiom,
    ! [C: $tType,R1: fun(C,fun(state,bool)),D: com,Qa: fun(C,fun(state,bool)),C1: com,Pa: fun(C,fun(state,bool)),Ga: fun(hoare_28830079triple(C),bool)] :
      ( hoare_992312373derivs(C,Ga,aa(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool),aa(hoare_28830079triple(C),fun(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool)),insert(hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),hoare_28830079triple(C),aa(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C))),hoare_1841697145triple(C),Pa),C1),Qa)),bot_bot(fun(hoare_28830079triple(C),bool))))
     => ( hoare_992312373derivs(C,Ga,aa(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool),aa(hoare_28830079triple(C),fun(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool)),insert(hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),hoare_28830079triple(C),aa(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C))),hoare_1841697145triple(C),Qa),D),R1)),bot_bot(fun(hoare_28830079triple(C),bool))))
       => hoare_992312373derivs(C,Ga,aa(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool),aa(hoare_28830079triple(C),fun(fun(hoare_28830079triple(C),bool),fun(hoare_28830079triple(C),bool)),insert(hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),hoare_28830079triple(C),aa(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C))),hoare_1841697145triple(C),Pa),semi(C1,D)),R1)),bot_bot(fun(hoare_28830079triple(C),bool)))) ) ) ).

tff(fact_86_fold1Set__sing,axiom,
    ! [C: $tType,B1: C,A2: C,F: fun(C,fun(C,C))] :
      ( finite_fold1Set(C,F,aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),A2),bot_bot(fun(C,bool))),B1)
    <=> ( A2 = B1 ) ) ).

tff(fact_87_com_Osimps_I3_J,axiom,
    ! [Com22: com,Com12: com,Com21: com,Com11: com] :
      ( ( semi(Com11,Com21) = semi(Com12,Com22) )
    <=> ( ( Com11 = Com12 )
        & ( Com21 = Com22 ) ) ) ).

tff(fact_88_com_Osimps_I46_J,axiom,
    ! [Com: com,Fun: fun(state,bool),Com21: com,Com11: com] : ( semi(Com11,Com21) != while(Fun,Com) ) ).

tff(fact_89_com_Osimps_I47_J,axiom,
    ! [Com21: com,Com11: com,Com: com,Fun: fun(state,bool)] : ( while(Fun,Com) != semi(Com11,Com21) ) ).

tff(fact_90_com_Osimps_I12_J,axiom,
    ! [Com2: com,Com1: com] : ( skip != semi(Com1,Com2) ) ).

tff(fact_91_com_Osimps_I13_J,axiom,
    ! [Com2: com,Com1: com] : ( semi(Com1,Com2) != skip ) ).

tff(fact_92_empty__fold1SetE,axiom,
    ! [C: $tType,X2: C,F: fun(C,fun(C,C))] : ~ finite_fold1Set(C,F,bot_bot(fun(C,bool)),X2) ).

tff(fact_93_fold1Set__nonempty,axiom,
    ! [C: $tType,X2: C,A1: fun(C,bool),F: fun(C,fun(C,C))] :
      ( finite_fold1Set(C,F,A1,X2)
     => ( A1 != bot_bot(fun(C,bool)) ) ) ).

tff(fact_94_finite__nonempty__imp__fold1Set,axiom,
    ! [C: $tType,F: fun(C,fun(C,C)),A1: fun(C,bool)] :
      ( finite_finite(C,A1)
     => ( ( A1 != bot_bot(fun(C,bool)) )
       => ? [X11: C] : finite_fold1Set(C,F,A1,X11) ) ) ).

tff(fact_95_finite__ne__induct,axiom,
    ! [C: $tType,Pa: fun(fun(C,bool),bool),F1: fun(C,bool)] :
      ( finite_finite(C,F1)
     => ( ( F1 != bot_bot(fun(C,bool)) )
       => ( ! [X1: C] : pp(aa(fun(C,bool),bool,Pa,aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),X1),bot_bot(fun(C,bool)))))
         => ( ! [X1: C,F2: fun(C,bool)] :
                ( finite_finite(C,F2)
               => ( ( F2 != bot_bot(fun(C,bool)) )
                 => ( ~ pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),X1),F2))
                   => ( pp(aa(fun(C,bool),bool,Pa,F2))
                     => pp(aa(fun(C,bool),bool,Pa,aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),X1),F2))) ) ) ) )
           => pp(aa(fun(C,bool),bool,Pa,F1)) ) ) ) ) ).

tff(fact_96_the__elem__def,axiom,
    ! [C: $tType,X3: fun(C,bool)] : ( the_elem(C,X3) = the(C,aa(fun(C,fun(C,bool)),fun(C,bool),combb(fun(C,bool),bool,C,aa(fun(C,bool),fun(fun(C,bool),bool),fequal(fun(C,bool)),X3)),aa(fun(C,bool),fun(C,fun(C,bool)),aa(fun(C,fun(fun(C,bool),fun(C,bool))),fun(fun(C,bool),fun(C,fun(C,bool))),combc(C,fun(C,bool),fun(C,bool)),insert(C)),bot_bot(fun(C,bool))))) ) ).

tff(fact_97_folding__one_Oinsert,axiom,
    ! [C: $tType,X2: C,A1: fun(C,bool),F1: fun(fun(C,bool),C),F: fun(C,fun(C,C))] :
      ( finite_folding_one(C,F,F1)
     => ( finite_finite(C,A1)
       => ( ~ pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),X2),A1))
         => ( ( A1 != bot_bot(fun(C,bool)) )
           => ( aa(fun(C,bool),C,F1,aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),X2),A1)) = aa(C,C,aa(C,fun(C,C),F,X2),aa(fun(C,bool),C,F1,A1)) ) ) ) ) ) ).

tff(fact_98_folding__one_Osingleton,axiom,
    ! [C: $tType,X2: C,F1: fun(fun(C,bool),C),F: fun(C,fun(C,C))] :
      ( finite_folding_one(C,F,F1)
     => ( aa(fun(C,bool),C,F1,aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),X2),bot_bot(fun(C,bool)))) = X2 ) ) ).

tff(fact_99_folding__one_Oclosed,axiom,
    ! [C: $tType,A1: fun(C,bool),F1: fun(fun(C,bool),C),F: fun(C,fun(C,C))] :
      ( finite_folding_one(C,F,F1)
     => ( finite_finite(C,A1)
       => ( ( A1 != bot_bot(fun(C,bool)) )
         => ( ! [X1: C,Y1: C] : pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),aa(C,C,aa(C,fun(C,C),F,X1),Y1)),aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),X1),aa(fun(C,bool),fun(C,bool),aa(C,fun(fun(C,bool),fun(C,bool)),insert(C),Y1),bot_bot(fun(C,bool))))))
           => pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),aa(fun(C,bool),C,F1,A1)),A1)) ) ) ) ) ).

%----Arities (4)
tff(arity_fun___Finite__Set_Ofinite,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( finite_finite1(T_2)
        & finite_finite1(T_1) )
     => finite_finite1(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Finite__Set_Ofinite,axiom,
    finite_finite1(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (22)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P1: bool] :
      ( ~ pp(aa(bool,bool,fNot,P1))
      | ~ pp(P1) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P1: bool] :
      ( pp(P1)
      | pp(aa(bool,bool,fNot,P1)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P1: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),combb(B,C,A,P1),Q),R) = aa(B,C,P1,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P1: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),aa(fun(A,fun(B,C)),fun(B,fun(A,C)),combc(A,B,C),P1),Q),R) = aa(B,C,aa(A,fun(B,C),P1,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P1: A] : ( aa(A,A,combi(A),P1) = P1 ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P1: A] : ( aa(B,A,combk(A,B,P1),Q) = P1 ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P1: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C)),combs(A,B,C),P1),Q),R) = aa(B,C,aa(A,fun(B,C),P1,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P1: bool] :
      ( ~ pp(P1)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P1),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P1: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P1),Q))
      | pp(P1) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P1: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P1),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P1: bool] :
      ( ~ pp(P1)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P1),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P1: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P1),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P1: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P1),Q))
      | pp(P1)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P1: bool] :
      ( ( P1 = fTrue )
      | ( P1 = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P1: bool] :
      ( pp(P1)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P1),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P1: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P1),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P1: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P1),Q))
      | ~ pp(P1)
      | pp(Q) ) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    finite_finite(a,u) ).

tff(conj_1,hypothesis,
    ! [P: a] :
      ( hoare_992312373derivs(b,g,aa(fun(hoare_28830079triple(b),bool),fun(hoare_28830079triple(b),bool),aa(hoare_28830079triple(b),fun(fun(hoare_28830079triple(b),bool),fun(hoare_28830079triple(b),bool)),insert(hoare_28830079triple(b)),aa(fun(b,fun(state,bool)),hoare_28830079triple(b),aa(com,fun(fun(b,fun(state,bool)),hoare_28830079triple(b)),aa(fun(b,fun(state,bool)),fun(com,fun(fun(b,fun(state,bool)),hoare_28830079triple(b))),hoare_1841697145triple(b),aa(a,fun(b,fun(state,bool)),p1,P)),aa(a,com,c0,P)),aa(a,fun(b,fun(state,bool)),q1,P))),bot_bot(fun(hoare_28830079triple(b),bool))))
     => hoare_992312373derivs(b,g,aa(fun(hoare_28830079triple(b),bool),fun(hoare_28830079triple(b),bool),aa(hoare_28830079triple(b),fun(fun(hoare_28830079triple(b),bool),fun(hoare_28830079triple(b),bool)),insert(hoare_28830079triple(b)),aa(fun(b,fun(state,bool)),hoare_28830079triple(b),aa(com,fun(fun(b,fun(state,bool)),hoare_28830079triple(b)),aa(fun(b,fun(state,bool)),fun(com,fun(fun(b,fun(state,bool)),hoare_28830079triple(b))),hoare_1841697145triple(b),aa(a,fun(b,fun(state,bool)),p,P)),aa(a,com,c0,P)),aa(a,fun(b,fun(state,bool)),q,P))),bot_bot(fun(hoare_28830079triple(b),bool)))) ) ).

tff(conj_2,conjecture,
    ( ~ hoare_992312373derivs(b,g,image(a,hoare_28830079triple(b),aa(fun(a,fun(b,fun(state,bool))),fun(a,hoare_28830079triple(b)),aa(fun(a,fun(fun(b,fun(state,bool)),hoare_28830079triple(b))),fun(fun(a,fun(b,fun(state,bool))),fun(a,hoare_28830079triple(b))),combs(a,fun(b,fun(state,bool)),hoare_28830079triple(b)),aa(fun(a,com),fun(a,fun(fun(b,fun(state,bool)),hoare_28830079triple(b))),aa(fun(a,fun(com,fun(fun(b,fun(state,bool)),hoare_28830079triple(b)))),fun(fun(a,com),fun(a,fun(fun(b,fun(state,bool)),hoare_28830079triple(b)))),combs(a,com,fun(fun(b,fun(state,bool)),hoare_28830079triple(b))),aa(fun(a,fun(b,fun(state,bool))),fun(a,fun(com,fun(fun(b,fun(state,bool)),hoare_28830079triple(b)))),combb(fun(b,fun(state,bool)),fun(com,fun(fun(b,fun(state,bool)),hoare_28830079triple(b))),a,hoare_1841697145triple(b)),p1)),c0)),q1),u))
    | hoare_992312373derivs(b,g,image(a,hoare_28830079triple(b),aa(fun(a,fun(b,fun(state,bool))),fun(a,hoare_28830079triple(b)),aa(fun(a,fun(fun(b,fun(state,bool)),hoare_28830079triple(b))),fun(fun(a,fun(b,fun(state,bool))),fun(a,hoare_28830079triple(b))),combs(a,fun(b,fun(state,bool)),hoare_28830079triple(b)),aa(fun(a,com),fun(a,fun(fun(b,fun(state,bool)),hoare_28830079triple(b))),aa(fun(a,fun(com,fun(fun(b,fun(state,bool)),hoare_28830079triple(b)))),fun(fun(a,com),fun(a,fun(fun(b,fun(state,bool)),hoare_28830079triple(b)))),combs(a,com,fun(fun(b,fun(state,bool)),hoare_28830079triple(b))),aa(fun(a,fun(b,fun(state,bool))),fun(a,fun(com,fun(fun(b,fun(state,bool)),hoare_28830079triple(b)))),combb(fun(b,fun(state,bool)),fun(com,fun(fun(b,fun(state,bool)),hoare_28830079triple(b))),a,hoare_1841697145triple(b)),p)),c0)),q),u)) ) ).

%------------------------------------------------------------------------------
