%------------------------------------------------------------------------------
% File     : SWW512_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Hoare's Logic with Procedures line 213
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : hoare_213 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.00 v6.4.0
% Syntax   : Number of formulae    :  160 (  33 unt;  34 typ;   0 def)
%            Number of atoms       :  311 (  63 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  212 (  27   ~;  11   |;  13   &)
%                                         (  25 <=>; 136  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   6 avg)
%            Maximal term depth    :    6 (   2 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   26 (  16   >;  10   *;   0   +;   0  <<)
%            Number of predicates  :   12 (  11 usr;   0 prp; 1-6 aty)
%            Number of functors    :   21 (  21 usr;   5 con; 0-5 aty)
%            Number of variables   :  423 ( 387   !;   3   ?; 423   :)
%                                         (  33  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:13
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Hoare__Mirabelle__vtrypsmcwp_Otriple,type,
    hoare_28830079triple: $tType > $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (30)
tff(sy_cl_Enum_Oenum,type,
    enum: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Owellorder,type,
    wellorder: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Enum_Oenum__class_Oenum__all,type,
    enum_enum_all: 
      !>[A: $tType] : ( fun(A,bool) > $o ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Ohoare__derivs,type,
    hoare_992312373derivs: 
      !>[A: $tType] : ( ( fun(hoare_28830079triple(A),bool) * fun(hoare_28830079triple(A),bool) ) > $o ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_OLeast,type,
    ord_Least: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_Predicate_OPowp,type,
    powp: 
      !>[A: $tType] : ( fun(A,bool) > fun(fun(A,bool),bool) ) ).

tff(sy_c_Predicate_Oinv__imagep,type,
    inv_imagep: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(B,bool)) * fun(A,B) * A * A ) > $o ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_OPow,type,
    pow: 
      !>[A: $tType] : ( fun(A,bool) > fun(fun(A,bool),bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_G,type,
    g: fun(hoare_28830079triple(a),bool) ).

tff(sy_v_Ga,type,
    ga: fun(hoare_28830079triple(a),bool) ).

%----Relevant facts (100)
tff(fact_0_empty,axiom,
    ! [B: $tType,G1: fun(hoare_28830079triple(B),bool)] : hoare_992312373derivs(B,G1,bot_bot(fun(hoare_28830079triple(B),bool))) ).

tff(fact_1_asm,axiom,
    ! [B: $tType,G1: fun(hoare_28830079triple(B),bool),Tsa: fun(hoare_28830079triple(B),bool)] :
      ( pp(aa(fun(hoare_28830079triple(B),bool),bool,aa(fun(hoare_28830079triple(B),bool),fun(fun(hoare_28830079triple(B),bool),bool),ord_less_eq(fun(hoare_28830079triple(B),bool)),Tsa),G1))
     => hoare_992312373derivs(B,G1,Tsa) ) ).

tff(fact_2_weaken,axiom,
    ! [B: $tType,Tsa: fun(hoare_28830079triple(B),bool),Ts: fun(hoare_28830079triple(B),bool),G1: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,G1,Ts)
     => ( pp(aa(fun(hoare_28830079triple(B),bool),bool,aa(fun(hoare_28830079triple(B),bool),fun(fun(hoare_28830079triple(B),bool),bool),ord_less_eq(fun(hoare_28830079triple(B),bool)),Tsa),Ts))
       => hoare_992312373derivs(B,G1,Tsa) ) ) ).

tff(fact_3_cut,axiom,
    ! [B: $tType,G1: fun(hoare_28830079triple(B),bool),Tsa: fun(hoare_28830079triple(B),bool),G_a: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,G_a,Tsa)
     => ( hoare_992312373derivs(B,G1,G_a)
       => hoare_992312373derivs(B,G1,Tsa) ) ) ).

tff(fact_4_empty__subsetI,axiom,
    ! [B: $tType,A1: fun(B,bool)] : pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),bot_bot(fun(B,bool))),A1)) ).

tff(fact_5_subset__empty,axiom,
    ! [B: $tType,A1: fun(B,bool)] :
      ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),bot_bot(fun(B,bool))))
    <=> ( A1 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_6_subsetD,axiom,
    ! [B: $tType,C1: B,B1: fun(B,bool),A1: fun(B,bool)] :
      ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),B1))
     => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),A1))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),B1)) ) ) ).

tff(fact_7_equalityI,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool)] :
      ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),B1))
     => ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),B1),A1))
       => ( A1 = B1 ) ) ) ).

tff(fact_8_all__not__in__conv,axiom,
    ! [B: $tType,A1: fun(B,bool)] :
      ( ! [X4: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),A1))
    <=> ( A1 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_9_empty__Collect__eq,axiom,
    ! [B: $tType,P1: fun(B,bool)] :
      ( ( bot_bot(fun(B,bool)) = collect(B,P1) )
    <=> ! [X4: B] : ~ pp(aa(B,bool,P1,X4)) ) ).

tff(fact_10_empty__iff,axiom,
    ! [B: $tType,C1: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C1),bot_bot(fun(B,bool)))) ).

tff(fact_11_Collect__empty__eq,axiom,
    ! [B: $tType,P1: fun(B,bool)] :
      ( ( collect(B,P1) = bot_bot(fun(B,bool)) )
    <=> ! [X4: B] : ~ pp(aa(B,bool,P1,X4)) ) ).

tff(fact_12_emptyE,axiom,
    ! [B: $tType,A2: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A2),bot_bot(fun(B,bool)))) ).

tff(fact_13_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : pp(aa(A,bool,aa(A,fun(A,bool),ord_less_eq(A),X),X)) ) ).

tff(fact_14_bot__fun__def,axiom,
    ! [B: $tType,C: $tType] :
      ( bot(C)
     => ! [X3: B] : ( aa(B,C,bot_bot(fun(B,C)),X3) = bot_bot(C) ) ) ).

tff(fact_15_bot__apply,axiom,
    ! [C: $tType,B: $tType] :
      ( bot(B)
     => ! [X1: C] : ( aa(C,B,bot_bot(fun(C,B)),X1) = bot_bot(B) ) ) ).

tff(fact_16_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ pp(aa(A,bool,aa(A,fun(A,bool),ord_less_eq(A),X),Y))
         => pp(aa(A,bool,aa(A,fun(A,bool),ord_less_eq(A),Y),X)) ) ) ).

tff(fact_17_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less_eq(A),X),Y))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less_eq(A),Y),Z))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less_eq(A),X),Z)) ) ) ) ).

tff(fact_18_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less_eq(A),X),Y))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less_eq(A),Y),X))
           => ( X = Y ) ) ) ) ).

tff(fact_19_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C3: A,B4: A,A4: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less_eq(A),A4),B4))
         => ( ( B4 = C3 )
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less_eq(A),A4),C3)) ) ) ) ).

tff(fact_20_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C3: A,B4: A,A4: A] :
          ( ( A4 = B4 )
         => ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less_eq(A),B4),C3))
           => pp(aa(A,bool,aa(A,fun(A,bool),ord_less_eq(A),A4),C3)) ) ) ) ).

tff(fact_21_order__antisym__conv,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [X1: B,Y2: B] :
          ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less_eq(B),Y2),X1))
         => ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less_eq(B),X1),Y2))
          <=> ( X1 = Y2 ) ) ) ) ).

tff(fact_22_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ( X = Y )
         => pp(aa(A,bool,aa(A,fun(A,bool),ord_less_eq(A),X),Y)) ) ) ).

tff(fact_23_order__eq__iff,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [Y2: B,X1: B] :
          ( ( X1 = Y2 )
        <=> ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less_eq(B),X1),Y2))
            & pp(aa(B,bool,aa(B,fun(B,bool),ord_less_eq(B),Y2),X1)) ) ) ) ).

tff(fact_24_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less_eq(A),X),Y))
          | pp(aa(A,bool,aa(A,fun(A,bool),ord_less_eq(A),Y),X)) ) ) ).

tff(fact_25_equals0D,axiom,
    ! [B: $tType,A2: B,A1: fun(B,bool)] :
      ( ( A1 = bot_bot(fun(B,bool)) )
     => ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A2),A1)) ) ).

tff(fact_26_ex__in__conv,axiom,
    ! [B: $tType,A1: fun(B,bool)] :
      ( ? [X4: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),A1))
    <=> ( A1 != bot_bot(fun(B,bool)) ) ) ).

tff(fact_27_empty__def,axiom,
    ! [B: $tType] : ( bot_bot(fun(B,bool)) = collect(B,combk(bool,B,fFalse)) ) ).

tff(fact_28_equalityE,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool)] :
      ( ( A1 = B1 )
     => ~ ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),B1))
         => ~ pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),B1),A1)) ) ) ).

tff(fact_29_subset__trans,axiom,
    ! [B: $tType,C2: fun(B,bool),B1: fun(B,bool),A1: fun(B,bool)] :
      ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),B1))
     => ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),B1),C2))
       => pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),C2)) ) ) ).

tff(fact_30_set__mp,axiom,
    ! [B: $tType,X1: B,B1: fun(B,bool),A1: fun(B,bool)] :
      ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),B1))
     => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A1))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),B1)) ) ) ).

tff(fact_31_set__rev__mp,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool),X1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A1))
     => ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),B1))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),B1)) ) ) ).

tff(fact_32_in__mono,axiom,
    ! [B: $tType,X1: B,B1: fun(B,bool),A1: fun(B,bool)] :
      ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),B1))
     => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A1))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),B1)) ) ) ).

tff(fact_33_equalityD2,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool)] :
      ( ( A1 = B1 )
     => pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),B1),A1)) ) ).

tff(fact_34_equalityD1,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool)] :
      ( ( A1 = B1 )
     => pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),B1)) ) ).

tff(fact_35_set__eq__subset,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool)] :
      ( ( A1 = B1 )
    <=> ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),B1))
        & pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),B1),A1)) ) ) ).

tff(fact_36_subset__refl,axiom,
    ! [B: $tType,A1: fun(B,bool)] : pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),A1)) ).

tff(fact_37_le__bot,axiom,
    ! [A: $tType] :
      ( bot(A)
     => ! [A4: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),ord_less_eq(A),A4),bot_bot(A)))
         => ( A4 = bot_bot(A) ) ) ) ).

tff(fact_38_bot__unique,axiom,
    ! [B: $tType] :
      ( bot(B)
     => ! [A2: B] :
          ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less_eq(B),A2),bot_bot(B)))
        <=> ( A2 = bot_bot(B) ) ) ) ).

tff(fact_39_bot__least,axiom,
    ! [A: $tType] :
      ( bot(A)
     => ! [A4: A] : pp(aa(A,bool,aa(A,fun(A,bool),ord_less_eq(A),bot_bot(A)),A4)) ) ).

tff(fact_40_le__funE,axiom,
    ! [C: $tType,B: $tType] :
      ( ord(C)
     => ! [X1: B,G: fun(B,C),F: fun(B,C)] :
          ( pp(aa(fun(B,C),bool,aa(fun(B,C),fun(fun(B,C),bool),ord_less_eq(fun(B,C)),F),G))
         => pp(aa(C,bool,aa(C,fun(C,bool),ord_less_eq(C),aa(B,C,F,X1)),aa(B,C,G,X1))) ) ) ).

tff(fact_41_le__funD,axiom,
    ! [C: $tType,B: $tType] :
      ( ord(C)
     => ! [X1: B,G: fun(B,C),F: fun(B,C)] :
          ( pp(aa(fun(B,C),bool,aa(fun(B,C),fun(fun(B,C),bool),ord_less_eq(fun(B,C)),F),G))
         => pp(aa(C,bool,aa(C,fun(C,bool),ord_less_eq(C),aa(B,C,F,X1)),aa(B,C,G,X1))) ) ) ).

tff(fact_42_le__fun__def,axiom,
    ! [C: $tType,B: $tType] :
      ( ord(C)
     => ! [G: fun(B,C),F: fun(B,C)] :
          ( pp(aa(fun(B,C),bool,aa(fun(B,C),fun(fun(B,C),bool),ord_less_eq(fun(B,C)),F),G))
        <=> ! [X4: B] : pp(aa(C,bool,aa(C,fun(C,bool),ord_less_eq(C),aa(B,C,F,X4)),aa(B,C,G,X4))) ) ) ).

tff(fact_43_subsetI,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool)] :
      ( ! [X2: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A1))
         => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),B1)) )
     => pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),B1)) ) ).

tff(fact_44_le__funI,axiom,
    ! [C: $tType,B: $tType] :
      ( ord(C)
     => ! [G: fun(B,C),F: fun(B,C)] :
          ( ! [X2: B] : pp(aa(C,bool,aa(C,fun(C,bool),ord_less_eq(C),aa(B,C,F,X2)),aa(B,C,G,X2)))
         => pp(aa(fun(B,C),bool,aa(fun(B,C),fun(fun(B,C),bool),ord_less_eq(fun(B,C)),F),G)) ) ) ).

tff(fact_45_Collect__mono,axiom,
    ! [B: $tType,Q1: fun(B,bool),P1: fun(B,bool)] :
      ( ! [X2: B] :
          ( pp(aa(B,bool,P1,X2))
         => pp(aa(B,bool,Q1,X2)) )
     => pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),collect(B,P1)),collect(B,Q1))) ) ).

tff(fact_46_pred__subset__eq,axiom,
    ! [B: $tType,S: fun(B,bool),R2: fun(B,bool)] :
      ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),combc(B,fun(B,bool),bool,member(B),R2)),combc(B,fun(B,bool),bool,member(B),S)))
    <=> pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),R2),S)) ) ).

tff(fact_47_equals0I,axiom,
    ! [B: $tType,A1: fun(B,bool)] :
      ( ! [Y1: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Y1),A1))
     => ( A1 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_48_order__subst1,axiom,
    ! [B: $tType,C: $tType] :
      ( ( order(C)
        & order(B) )
     => ! [C1: C,B2: C,F: fun(C,B),A2: B] :
          ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less_eq(B),A2),aa(C,B,F,B2)))
         => ( pp(aa(C,bool,aa(C,fun(C,bool),ord_less_eq(C),B2),C1))
           => ( ! [X2: C,Y1: C] :
                  ( pp(aa(C,bool,aa(C,fun(C,bool),ord_less_eq(C),X2),Y1))
                 => pp(aa(B,bool,aa(B,fun(B,bool),ord_less_eq(B),aa(C,B,F,X2)),aa(C,B,F,Y1))) )
             => pp(aa(B,bool,aa(B,fun(B,bool),ord_less_eq(B),A2),aa(C,B,F,C1))) ) ) ) ) ).

tff(fact_49_ord__eq__le__subst,axiom,
    ! [B: $tType,C: $tType] :
      ( ( ord(C)
        & ord(B) )
     => ! [C1: C,B2: C,F: fun(C,B),A2: B] :
          ( ( A2 = aa(C,B,F,B2) )
         => ( pp(aa(C,bool,aa(C,fun(C,bool),ord_less_eq(C),B2),C1))
           => ( ! [X2: C,Y1: C] :
                  ( pp(aa(C,bool,aa(C,fun(C,bool),ord_less_eq(C),X2),Y1))
                 => pp(aa(B,bool,aa(B,fun(B,bool),ord_less_eq(B),aa(C,B,F,X2)),aa(C,B,F,Y1))) )
             => pp(aa(B,bool,aa(B,fun(B,bool),ord_less_eq(B),A2),aa(C,B,F,C1))) ) ) ) ) ).

tff(fact_50_order__subst2,axiom,
    ! [B: $tType,C: $tType] :
      ( ( order(C)
        & order(B) )
     => ! [C1: C,F: fun(B,C),B2: B,A2: B] :
          ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less_eq(B),A2),B2))
         => ( pp(aa(C,bool,aa(C,fun(C,bool),ord_less_eq(C),aa(B,C,F,B2)),C1))
           => ( ! [X2: B,Y1: B] :
                  ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less_eq(B),X2),Y1))
                 => pp(aa(C,bool,aa(C,fun(C,bool),ord_less_eq(C),aa(B,C,F,X2)),aa(B,C,F,Y1))) )
             => pp(aa(C,bool,aa(C,fun(C,bool),ord_less_eq(C),aa(B,C,F,A2)),C1)) ) ) ) ) ).

tff(fact_51_bot__empty__eq,axiom,
    ! [B: $tType,X3: B] :
      ( pp(aa(B,bool,bot_bot(fun(B,bool)),X3))
    <=> pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),bot_bot(fun(B,bool)))) ) ).

tff(fact_52_rev__predicate1D,axiom,
    ! [B: $tType,Q1: fun(B,bool),X1: B,P1: fun(B,bool)] :
      ( pp(aa(B,bool,P1,X1))
     => ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),P1),Q1))
       => pp(aa(B,bool,Q1,X1)) ) ) ).

tff(fact_53_predicate1D,axiom,
    ! [B: $tType,X1: B,Q1: fun(B,bool),P1: fun(B,bool)] :
      ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),P1),Q1))
     => ( pp(aa(B,bool,P1,X1))
       => pp(aa(B,bool,Q1,X1)) ) ) ).

tff(fact_54_predicate1I,axiom,
    ! [B: $tType,Q1: fun(B,bool),P1: fun(B,bool)] :
      ( ! [X2: B] :
          ( pp(aa(B,bool,P1,X2))
         => pp(aa(B,bool,Q1,X2)) )
     => pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),P1),Q1)) ) ).

tff(fact_55_ord__le__eq__subst,axiom,
    ! [B: $tType,C: $tType] :
      ( ( ord(C)
        & ord(B) )
     => ! [C1: C,F: fun(B,C),B2: B,A2: B] :
          ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less_eq(B),A2),B2))
         => ( ( aa(B,C,F,B2) = C1 )
           => ( ! [X2: B,Y1: B] :
                  ( pp(aa(B,bool,aa(B,fun(B,bool),ord_less_eq(B),X2),Y1))
                 => pp(aa(C,bool,aa(C,fun(C,bool),ord_less_eq(C),aa(B,C,F,X2)),aa(B,C,F,Y1))) )
             => pp(aa(C,bool,aa(C,fun(C,bool),ord_less_eq(C),aa(B,C,F,A2)),C1)) ) ) ) ) ).

tff(fact_56_Powp__mono,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool)] :
      ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),B1))
     => pp(aa(fun(fun(B,bool),bool),bool,aa(fun(fun(B,bool),bool),fun(fun(fun(B,bool),bool),bool),ord_less_eq(fun(fun(B,bool),bool)),powp(B,A1)),powp(B,B1))) ) ).

tff(fact_57_in__inv__imagep,axiom,
    ! [B: $tType,C: $tType,Y2: C,X1: C,F: fun(C,B),R1: fun(B,fun(B,bool))] :
      ( inv_imagep(B,C,R1,F,X1,Y2)
    <=> pp(aa(B,bool,aa(B,fun(B,bool),R1,aa(C,B,F,X1)),aa(C,B,F,Y2))) ) ).

tff(fact_58_inv__imagep__def,axiom,
    ! [C: $tType,B: $tType,F: fun(B,C),R1: fun(C,fun(C,bool)),X3: B,Xa: B] :
      ( inv_imagep(C,B,R1,F,X3,Xa)
    <=> pp(aa(C,bool,aa(C,fun(C,bool),R1,aa(B,C,F,X3)),aa(B,C,F,Xa))) ) ).

tff(fact_59_Pow__mono,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool)] :
      ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),B1))
     => pp(aa(fun(fun(B,bool),bool),bool,aa(fun(fun(B,bool),bool),fun(fun(fun(B,bool),bool),bool),ord_less_eq(fun(fun(B,bool),bool)),pow(B,A1)),pow(B,B1))) ) ).

tff(fact_60_order__fun_I1_J,axiom,
    ! [C: $tType,B: $tType] :
      ( ( enum(B)
        & order(C) )
     => ! [G: fun(B,C),F: fun(B,C)] :
          ( pp(aa(fun(B,C),bool,aa(fun(B,C),fun(fun(B,C),bool),ord_less_eq(fun(B,C)),F),G))
        <=> enum_enum_all(B,combs(B,C,bool,combb(C,fun(C,bool),B,ord_less_eq(C),F),G)) ) ) ).

tff(fact_61_Least__le,axiom,
    ! [B: $tType] :
      ( wellorder(B)
     => ! [K: B,P1: fun(B,bool)] :
          ( pp(aa(B,bool,P1,K))
         => pp(aa(B,bool,aa(B,fun(B,bool),ord_less_eq(B),ord_Least(B,P1)),K)) ) ) ).

tff(fact_62_Pow__iff,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool)] :
      ( pp(aa(fun(fun(B,bool),bool),bool,aa(fun(B,bool),fun(fun(fun(B,bool),bool),bool),member(fun(B,bool)),A1),pow(B,B1)))
    <=> pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),B1)) ) ).

tff(fact_63_PowI,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool)] :
      ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),B1))
     => pp(aa(fun(fun(B,bool),bool),bool,aa(fun(B,bool),fun(fun(fun(B,bool),bool),bool),member(fun(B,bool)),A1),pow(B,B1))) ) ).

tff(fact_64_Pow__def,axiom,
    ! [B: $tType,A1: fun(B,bool)] : ( pow(B,A1) = collect(fun(B,bool),combc(fun(B,bool),fun(B,bool),bool,ord_less_eq(fun(B,bool)),A1)) ) ).

tff(fact_65_PowD,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool)] :
      ( pp(aa(fun(fun(B,bool),bool),bool,aa(fun(B,bool),fun(fun(fun(B,bool),bool),bool),member(fun(B,bool)),A1),pow(B,B1)))
     => pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),B1)) ) ).

tff(fact_66_Pow__not__empty,axiom,
    ! [B: $tType,A1: fun(B,bool)] : ( pow(B,A1) != bot_bot(fun(fun(B,bool),bool)) ) ).

tff(fact_67_Pow__top,axiom,
    ! [B: $tType,A1: fun(B,bool)] : pp(aa(fun(fun(B,bool),bool),bool,aa(fun(B,bool),fun(fun(fun(B,bool),bool),bool),member(fun(B,bool)),A1),pow(B,A1))) ).

tff(fact_68_LeastI__ex,axiom,
    ! [B: $tType] :
      ( wellorder(B)
     => ! [P1: fun(B,bool)] :
          ( ? [X11: B] : pp(aa(B,bool,P1,X11))
         => pp(aa(B,bool,P1,ord_Least(B,P1))) ) ) ).

tff(fact_69_all__code,axiom,
    ! [B: $tType] :
      ( enum(B)
     => ! [P1: fun(B,bool)] :
          ( ! [X12: B] : pp(aa(B,bool,P1,X12))
        <=> enum_enum_all(B,P1) ) ) ).

tff(fact_70_enum__all,axiom,
    ! [B: $tType] :
      ( enum(B)
     => ! [P1: fun(B,bool)] :
          ( enum_enum_all(B,P1)
        <=> ! [X12: B] : pp(aa(B,bool,P1,X12)) ) ) ).

tff(fact_71_Pow__bottom,axiom,
    ! [B: $tType,B1: fun(B,bool)] : pp(aa(fun(fun(B,bool),bool),bool,aa(fun(B,bool),fun(fun(fun(B,bool),bool),bool),member(fun(B,bool)),bot_bot(fun(B,bool))),pow(B,B1))) ).

tff(fact_72_LeastI,axiom,
    ! [B: $tType] :
      ( wellorder(B)
     => ! [K: B,P1: fun(B,bool)] :
          ( pp(aa(B,bool,P1,K))
         => pp(aa(B,bool,P1,ord_Least(B,P1))) ) ) ).

tff(fact_73_Powp__Pow__eq,axiom,
    ! [B: $tType,A1: fun(B,bool),X3: fun(B,bool)] :
      ( pp(aa(fun(B,bool),bool,powp(B,combc(B,fun(B,bool),bool,member(B),A1)),X3))
    <=> pp(aa(fun(fun(B,bool),bool),bool,aa(fun(B,bool),fun(fun(fun(B,bool),bool),bool),member(fun(B,bool)),X3),pow(B,A1))) ) ).

tff(fact_74_Least__equality,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [X1: B,P1: fun(B,bool)] :
          ( pp(aa(B,bool,P1,X1))
         => ( ! [Y1: B] :
                ( pp(aa(B,bool,P1,Y1))
               => pp(aa(B,bool,aa(B,fun(B,bool),ord_less_eq(B),X1),Y1)) )
           => ( ord_Least(B,P1) = X1 ) ) ) ) ).

tff(fact_75_ext,axiom,
    ! [C: $tType,B: $tType,G: fun(B,C),F: fun(B,C)] :
      ( ! [X2: B] : ( aa(B,C,F,X2) = aa(B,C,G,X2) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [B: $tType,A1: fun(B,bool),X1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A1))
    <=> pp(aa(B,bool,A1,X1)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [B: $tType,P1: fun(B,bool)] : ( collect(B,P1) = P1 ) ).

tff(fact_78_LeastI2__ex,axiom,
    ! [B: $tType] :
      ( wellorder(B)
     => ! [Q1: fun(B,bool),P1: fun(B,bool)] :
          ( ? [X11: B] : pp(aa(B,bool,P1,X11))
         => ( ! [X2: B] :
                ( pp(aa(B,bool,P1,X2))
               => pp(aa(B,bool,Q1,X2)) )
           => pp(aa(B,bool,Q1,ord_Least(B,P1))) ) ) ) ).

tff(fact_79_LeastI2,axiom,
    ! [B: $tType] :
      ( wellorder(B)
     => ! [Q1: fun(B,bool),A2: B,P1: fun(B,bool)] :
          ( pp(aa(B,bool,P1,A2))
         => ( ! [X2: B] :
                ( pp(aa(B,bool,P1,X2))
               => pp(aa(B,bool,Q1,X2)) )
           => pp(aa(B,bool,Q1,ord_Least(B,P1))) ) ) ) ).

tff(fact_80_LeastI2__wellorder,axiom,
    ! [B: $tType] :
      ( wellorder(B)
     => ! [Q1: fun(B,bool),A2: B,P1: fun(B,bool)] :
          ( pp(aa(B,bool,P1,A2))
         => ( ! [A3: B] :
                ( pp(aa(B,bool,P1,A3))
               => ( ! [B3: B] :
                      ( pp(aa(B,bool,P1,B3))
                     => pp(aa(B,bool,aa(B,fun(B,bool),ord_less_eq(B),A3),B3)) )
                 => pp(aa(B,bool,Q1,A3)) ) )
           => pp(aa(B,bool,Q1,ord_Least(B,P1))) ) ) ) ).

tff(fact_81_Pow__empty,axiom,
    ! [B: $tType] : ( pow(B,bot_bot(fun(B,bool))) = insert(fun(B,bool),bot_bot(fun(B,bool)),bot_bot(fun(fun(B,bool),bool))) ) ).

tff(fact_82_insert__absorb2,axiom,
    ! [B: $tType,A1: fun(B,bool),X1: B] : ( insert(B,X1,insert(B,X1,A1)) = insert(B,X1,A1) ) ).

tff(fact_83_insert__iff,axiom,
    ! [B: $tType,A1: fun(B,bool),B2: B,A2: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A2),insert(B,B2,A1)))
    <=> ( ( A2 = B2 )
        | pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A2),A1)) ) ) ).

tff(fact_84_insertE,axiom,
    ! [B: $tType,A1: fun(B,bool),B2: B,A2: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A2),insert(B,B2,A1)))
     => ( ( A2 != B2 )
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A2),A1)) ) ) ).

tff(fact_85_insertCI,axiom,
    ! [B: $tType,B2: B,B1: fun(B,bool),A2: B] :
      ( ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A2),B1))
       => ( A2 = B2 ) )
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A2),insert(B,B2,B1))) ) ).

tff(fact_86_insert__subset,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool),X1: B] :
      ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),insert(B,X1,A1)),B1))
    <=> ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),B1))
        & pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),B1)) ) ) ).

tff(fact_87_singleton__conv2,axiom,
    ! [B: $tType,A2: B] : ( collect(B,aa(B,fun(B,bool),fequal(B),A2)) = insert(B,A2,bot_bot(fun(B,bool))) ) ).

tff(fact_88_singleton__conv,axiom,
    ! [B: $tType,A2: B] : ( collect(B,combc(B,B,bool,fequal(B),A2)) = insert(B,A2,bot_bot(fun(B,bool))) ) ).

tff(fact_89_empty__not__insert,axiom,
    ! [B: $tType,A1: fun(B,bool),A2: B] : ( bot_bot(fun(B,bool)) != insert(B,A2,A1) ) ).

tff(fact_90_insert__not__empty,axiom,
    ! [B: $tType,A1: fun(B,bool),A2: B] : ( insert(B,A2,A1) != bot_bot(fun(B,bool)) ) ).

tff(fact_91_singleton__iff,axiom,
    ! [B: $tType,A2: B,B2: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B2),insert(B,A2,bot_bot(fun(B,bool)))))
    <=> ( B2 = A2 ) ) ).

tff(fact_92_doubleton__eq__iff,axiom,
    ! [B: $tType,D: B,C1: B,B2: B,A2: B] :
      ( ( insert(B,A2,insert(B,B2,bot_bot(fun(B,bool)))) = insert(B,C1,insert(B,D,bot_bot(fun(B,bool)))) )
    <=> ( ( ( A2 = C1 )
          & ( B2 = D ) )
        | ( ( A2 = D )
          & ( B2 = C1 ) ) ) ) ).

tff(fact_93_singletonE,axiom,
    ! [B: $tType,A2: B,B2: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B2),insert(B,A2,bot_bot(fun(B,bool)))))
     => ( B2 = A2 ) ) ).

tff(fact_94_singleton__inject,axiom,
    ! [B: $tType,B2: B,A2: B] :
      ( ( insert(B,A2,bot_bot(fun(B,bool))) = insert(B,B2,bot_bot(fun(B,bool))) )
     => ( A2 = B2 ) ) ).

tff(fact_95_Collect__conv__if2,axiom,
    ! [B: $tType,A2: B,P1: fun(B,bool)] :
      ( ( pp(aa(B,bool,P1,A2))
       => ( collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,aa(B,fun(B,bool),fequal(B),A2)),P1)) = insert(B,A2,bot_bot(fun(B,bool))) ) )
      & ( ~ pp(aa(B,bool,P1,A2))
       => ( collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,aa(B,fun(B,bool),fequal(B),A2)),P1)) = bot_bot(fun(B,bool)) ) ) ) ).

tff(fact_96_Collect__conv__if,axiom,
    ! [B: $tType,A2: B,P1: fun(B,bool)] :
      ( ( pp(aa(B,bool,P1,A2))
       => ( collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,combc(B,B,bool,fequal(B),A2)),P1)) = insert(B,A2,bot_bot(fun(B,bool))) ) )
      & ( ~ pp(aa(B,bool,P1,A2))
       => ( collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,combc(B,B,bool,fequal(B),A2)),P1)) = bot_bot(fun(B,bool)) ) ) ) ).

tff(fact_97_subset__singletonD,axiom,
    ! [B: $tType,X1: B,A1: fun(B,bool)] :
      ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),insert(B,X1,bot_bot(fun(B,bool)))))
     => ( ( A1 = bot_bot(fun(B,bool)) )
        | ( A1 = insert(B,X1,bot_bot(fun(B,bool))) ) ) ) ).

tff(fact_98_subset__insertI,axiom,
    ! [B: $tType,A2: B,B1: fun(B,bool)] : pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),B1),insert(B,A2,B1))) ).

tff(fact_99_subset__insert,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: fun(B,bool),X1: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A1))
     => ( pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),insert(B,X1,B1)))
      <=> pp(aa(fun(B,bool),bool,aa(fun(B,bool),fun(fun(B,bool),bool),ord_less_eq(fun(B,bool)),A1),B1)) ) ) ).

%----Arities (11)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_fun___Enum_Oenum,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( enum(T_2)
        & enum(T_1) )
     => enum(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

tff(arity_HOL_Obool___Enum_Oenum,axiom,
    enum(bool) ).

%----Helper facts (13)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    pp(aa(fun(hoare_28830079triple(a),bool),bool,aa(fun(hoare_28830079triple(a),bool),fun(fun(hoare_28830079triple(a),bool),bool),ord_less_eq(fun(hoare_28830079triple(a),bool)),g),ga)) ).

tff(conj_1,conjecture,
    hoare_992312373derivs(a,ga,bot_bot(fun(hoare_28830079triple(a),bool))) ).

%------------------------------------------------------------------------------
