%------------------------------------------------------------------------------
% File     : SWW511_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Hoare's Logic with Procedures line 199
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : hoare_199 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  170 (  40 unt;  44 typ;   0 def)
%            Number of atoms       :  307 ( 108 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  240 (  59   ~;  23   |;  29   &)
%                                         (  22 <=>; 107  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   17 (   6 avg)
%            Maximal term depth    :   12 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   36 (  21   >;  15   *;   0   +;   0  <<)
%            Number of predicates  :    9 (   8 usr;   0 prp; 1-6 aty)
%            Number of functors    :   32 (  32 usr;  11 con; 0-4 aty)
%            Number of variables   :  492 ( 436   !;  20   ?; 492   :)
%                                         (  36  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:59
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_Com_Ocom,type,
    com: $tType ).

tff(ty_tc_Com_Ostate,type,
    state: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Hoare__Mirabelle__vtrypsmcwp_Otriple,type,
    hoare_28830079triple: $tType > $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (38)
tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Finite__Set_Ofinite,type,
    finite_finite: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( fun(B,C) > fun(fun(A,B),fun(A,C)) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(B,fun(A,C))) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_Com_Ocom_OSKIP,type,
    skip: com ).

tff(sy_c_Com_Ocom_OSemi,type,
    semi: ( com * com ) > com ).

tff(sy_c_Finite__Set_Ofinite,type,
    finite_finite1: 
      !>[A: $tType] : ( fun(A,bool) > $o ) ).

tff(sy_c_Finite__Set_Ofold1,type,
    finite_fold1: 
      !>[A: $tType] : ( fun(A,fun(A,A)) > fun(fun(A,bool),A) ) ).

tff(sy_c_Finite__Set_Ofold1Set,type,
    finite_fold1Set: 
      !>[A: $tType] : ( ( fun(A,fun(A,A)) * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_Finite__Set_Ofold__graph,type,
    finite_fold_graph: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(B,B)) * B * fun(A,bool) * B ) > $o ) ).

tff(sy_c_Finite__Set_Ofolding__one,type,
    finite_folding_one: 
      !>[A: $tType] : ( ( fun(A,fun(A,A)) * fun(fun(A,bool),A) ) > $o ) ).

tff(sy_c_Finite__Set_Ofolding__one__idem,type,
    finite2073411215e_idem: 
      !>[A: $tType] : ( ( fun(A,fun(A,A)) * fun(fun(A,bool),A) ) > $o ) ).

tff(sy_c_HOL_OThe,type,
    the: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Ohoare__derivs,type,
    hoare_992312373derivs: 
      !>[A: $tType] : ( ( fun(hoare_28830079triple(A),bool) * fun(hoare_28830079triple(A),bool) ) > $o ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Opeek__and,type,
    hoare_1442473487ek_and: 
      !>[A: $tType] : ( ( fun(A,fun(state,bool)) * fun(state,bool) ) > fun(A,fun(state,bool)) ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple,type,
    hoare_1841697145triple: 
      !>[A: $tType] : ( ( fun(A,fun(state,bool)) * com * fun(A,fun(state,bool)) ) > hoare_28830079triple(A) ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__case,type,
    hoare_376461865e_case: 
      !>[A: $tType,T1: $tType] : ( ( fun(fun(A,fun(state,bool)),fun(com,fun(fun(A,fun(state,bool)),T1))) * hoare_28830079triple(A) ) > T1 ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__rec,type,
    hoare_678420151le_rec: 
      !>[A: $tType,T1: $tType] : ( ( fun(fun(A,fun(state,bool)),fun(com,fun(fun(A,fun(state,bool)),T1))) * hoare_28830079triple(A) ) > T1 ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),fun(A,bool))) ).

tff(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_G,type,
    g: fun(hoare_28830079triple(a),bool) ).

tff(sy_v_P,type,
    p: fun(a,fun(state,bool)) ).

tff(sy_v_b,type,
    b: fun(state,bool) ).

tff(sy_v_c,type,
    c: com ).

%----Relevant facts (100)
tff(fact_0_triple_Oinject,axiom,
    ! [B: $tType,Fun22: fun(B,fun(state,bool)),Com4: com,Fun12: fun(B,fun(state,bool)),Fun21: fun(B,fun(state,bool)),Com3: com,Fun11: fun(B,fun(state,bool))] :
      ( ( hoare_1841697145triple(B,Fun11,Com3,Fun21) = hoare_1841697145triple(B,Fun12,Com4,Fun22) )
    <=> ( ( Fun11 = Fun12 )
        & ( Com3 = Com4 )
        & ( Fun21 = Fun22 ) ) ) ).

tff(fact_1_peek__and__def,axiom,
    ! [B: $tType,P3: fun(state,bool),Pa: fun(B,fun(state,bool)),X5: B,Xa: state] :
      ( pp(aa(state,bool,aa(B,fun(state,bool),hoare_1442473487ek_and(B,Pa,P3),X5),Xa))
    <=> ( pp(aa(state,bool,aa(B,fun(state,bool),Pa,X5),Xa))
        & pp(aa(state,bool,P3,Xa)) ) ) ).

tff(fact_2_empty,axiom,
    ! [B: $tType,Ga: fun(hoare_28830079triple(B),bool)] : hoare_992312373derivs(B,Ga,bot_bot(fun(hoare_28830079triple(B),bool))) ).

tff(fact_3_cut,axiom,
    ! [B: $tType,Ga: fun(hoare_28830079triple(B),bool),Ts: fun(hoare_28830079triple(B),bool),G1: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,G1,Ts)
     => ( hoare_992312373derivs(B,Ga,G1)
       => hoare_992312373derivs(B,Ga,Ts) ) ) ).

tff(fact_4_hoare__derivs_Oinsert,axiom,
    ! [B: $tType,Ts: fun(hoare_28830079triple(B),bool),T: hoare_28830079triple(B),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),T),bot_bot(fun(hoare_28830079triple(B),bool))))
     => ( hoare_992312373derivs(B,Ga,Ts)
       => hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),T),Ts)) ) ) ).

tff(fact_5_constant,axiom,
    ! [B: $tType,Q1: fun(B,fun(state,bool)),Ca: com,Pa: fun(B,fun(state,bool)),Ga: fun(hoare_28830079triple(B),bool),C2: bool] :
      ( ( pp(C2)
       => hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Pa,Ca,Q1)),bot_bot(fun(hoare_28830079triple(B),bool)))) )
     => hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,aa(bool,fun(B,fun(state,bool)),aa(fun(B,fun(bool,fun(state,bool))),fun(bool,fun(B,fun(state,bool))),combc(B,bool,fun(state,bool)),aa(fun(B,fun(state,fun(bool,bool))),fun(B,fun(bool,fun(state,bool))),combb(fun(state,fun(bool,bool)),fun(bool,fun(state,bool)),B,combc(state,bool,bool)),aa(fun(B,fun(state,bool)),fun(B,fun(state,fun(bool,bool))),combb(fun(state,bool),fun(state,fun(bool,bool)),B,combb(bool,fun(bool,bool),state,fconj)),Pa))),C2),Ca,Q1)),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ).

tff(fact_6_singleton__conv2,axiom,
    ! [B: $tType,A5: B] : ( collect(B,aa(B,fun(B,bool),fequal(B),A5)) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool))) ) ).

tff(fact_7_singleton__conv,axiom,
    ! [B: $tType,A5: B] : ( collect(B,aa(B,fun(B,bool),aa(fun(B,fun(B,bool)),fun(B,fun(B,bool)),combc(B,B,bool),fequal(B)),A5)) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool))) ) ).

tff(fact_8_escape,axiom,
    ! [B: $tType,Q1: fun(B,fun(state,bool)),Ca: com,Ga: fun(hoare_28830079triple(B),bool),Pa: fun(B,fun(state,bool))] :
      ( ! [Z1: B,S: state] :
          ( pp(aa(state,bool,aa(B,fun(state,bool),Pa,Z1),S))
         => hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,combk(fun(state,bool),B,aa(state,fun(state,bool),aa(fun(state,fun(state,bool)),fun(state,fun(state,bool)),combc(state,state,bool),fequal(state)),S)),Ca,combk(fun(state,bool),B,aa(B,fun(state,bool),Q1,Z1)))),bot_bot(fun(hoare_28830079triple(B),bool)))) )
     => hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Pa,Ca,Q1)),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ).

tff(fact_9_conseq2,axiom,
    ! [B: $tType,Q1: fun(B,fun(state,bool)),Q3: fun(B,fun(state,bool)),Ca: com,Pa: fun(B,fun(state,bool)),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Pa,Ca,Q3)),bot_bot(fun(hoare_28830079triple(B),bool))))
     => ( ! [Z1: B,S: state] :
            ( pp(aa(state,bool,aa(B,fun(state,bool),Q3,Z1),S))
           => pp(aa(state,bool,aa(B,fun(state,bool),Q1,Z1),S)) )
       => hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Pa,Ca,Q1)),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ) ).

tff(fact_10_conseq1,axiom,
    ! [B: $tType,Pa: fun(B,fun(state,bool)),Q1: fun(B,fun(state,bool)),Ca: com,P2: fun(B,fun(state,bool)),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,P2,Ca,Q1)),bot_bot(fun(hoare_28830079triple(B),bool))))
     => ( ! [Z1: B,S: state] :
            ( pp(aa(state,bool,aa(B,fun(state,bool),Pa,Z1),S))
           => pp(aa(state,bool,aa(B,fun(state,bool),P2,Z1),S)) )
       => hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Pa,Ca,Q1)),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ) ).

tff(fact_11_conseq12,axiom,
    ! [B: $tType,Q1: fun(B,fun(state,bool)),Pa: fun(B,fun(state,bool)),Q3: fun(B,fun(state,bool)),Ca: com,P2: fun(B,fun(state,bool)),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,P2,Ca,Q3)),bot_bot(fun(hoare_28830079triple(B),bool))))
     => ( ! [Z1: B,S: state] :
            ( pp(aa(state,bool,aa(B,fun(state,bool),Pa,Z1),S))
           => ! [S1: state] :
                ( ! [Z2: B] :
                    ( pp(aa(state,bool,aa(B,fun(state,bool),P2,Z2),S))
                   => pp(aa(state,bool,aa(B,fun(state,bool),Q3,Z2),S1)) )
               => pp(aa(state,bool,aa(B,fun(state,bool),Q1,Z1),S1)) ) )
       => hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Pa,Ca,Q1)),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ) ).

tff(fact_12_insert__absorb2,axiom,
    ! [B: $tType,A1: fun(B,bool),X1: B] : ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),A1)) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),A1) ) ).

tff(fact_13_insert__iff,axiom,
    ! [B: $tType,A1: fun(B,bool),Ba: B,A5: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),Ba),A1)))
    <=> ( ( A5 = Ba )
        | pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A1)) ) ) ).

tff(fact_14_insertE,axiom,
    ! [B: $tType,A1: fun(B,bool),Ba: B,A5: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),Ba),A1)))
     => ( ( A5 != Ba )
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A1)) ) ) ).

tff(fact_15_insertCI,axiom,
    ! [B: $tType,Ba: B,B3: fun(B,bool),A5: B] :
      ( ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),B3))
       => ( A5 = Ba ) )
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),Ba),B3))) ) ).

tff(fact_16_all__not__in__conv,axiom,
    ! [B: $tType,A1: fun(B,bool)] :
      ( ! [X2: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A1))
    <=> ( A1 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_17_empty__Collect__eq,axiom,
    ! [B: $tType,Pa: fun(B,bool)] :
      ( ( bot_bot(fun(B,bool)) = collect(B,Pa) )
    <=> ! [X2: B] : ~ pp(aa(B,bool,Pa,X2)) ) ).

tff(fact_18_emptyE,axiom,
    ! [B: $tType,A5: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),bot_bot(fun(B,bool)))) ).

tff(fact_19_Collect__empty__eq,axiom,
    ! [B: $tType,Pa: fun(B,bool)] :
      ( ( collect(B,Pa) = bot_bot(fun(B,bool)) )
    <=> ! [X2: B] : ~ pp(aa(B,bool,Pa,X2)) ) ).

tff(fact_20_empty__iff,axiom,
    ! [B: $tType,Ca: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ca),bot_bot(fun(B,bool)))) ).

tff(fact_21_equals0D,axiom,
    ! [B: $tType,A5: B,A1: fun(B,bool)] :
      ( ( A1 = bot_bot(fun(B,bool)) )
     => ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A1)) ) ).

tff(fact_22_ex__in__conv,axiom,
    ! [B: $tType,A1: fun(B,bool)] :
      ( ? [X2: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A1))
    <=> ( A1 != bot_bot(fun(B,bool)) ) ) ).

tff(fact_23_empty__def,axiom,
    ! [B: $tType] : ( bot_bot(fun(B,bool)) = collect(B,combk(bool,B,fFalse)) ) ).

tff(fact_24_insert__absorb,axiom,
    ! [B: $tType,A1: fun(B,bool),A5: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A1))
     => ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),A1) = A1 ) ) ).

tff(fact_25_insertI2,axiom,
    ! [B: $tType,Ba: B,B3: fun(B,bool),A5: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),B3))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),Ba),B3))) ) ).

tff(fact_26_insert__eq__iff,axiom,
    ! [B: $tType,B3: fun(B,bool),Ba: B,A1: fun(B,bool),A5: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A1))
     => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ba),B3))
       => ( ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),A1) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),Ba),B3) )
        <=> ( ( ( A5 = Ba )
             => ( A1 = B3 ) )
            & ( ( A5 != Ba )
             => ? [C1: fun(B,bool)] :
                  ( ( A1 = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),Ba),C1) )
                  & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ba),C1))
                  & ( B3 = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),C1) )
                  & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),C1)) ) ) ) ) ) ) ).

tff(fact_27_insert__ident,axiom,
    ! [B: $tType,B3: fun(B,bool),A1: fun(B,bool),X1: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A1))
     => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),B3))
       => ( ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),A1) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),B3) )
        <=> ( A1 = B3 ) ) ) ) ).

tff(fact_28_insert__code,axiom,
    ! [B: $tType,X1: B,A1: fun(B,bool),Y3: B] :
      ( pp(aa(B,bool,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),Y3),A1),X1))
    <=> ( ( Y3 = X1 )
        | pp(aa(B,bool,A1,X1)) ) ) ).

tff(fact_29_insert__commute,axiom,
    ! [B: $tType,A1: fun(B,bool),Y3: B,X1: B] : ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),Y3),A1)) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),Y3),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),A1)) ) ).

tff(fact_30_insert__Collect,axiom,
    ! [B: $tType,Pa: fun(B,bool),A5: B] : ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),collect(B,Pa)) = collect(B,aa(fun(B,bool),fun(B,bool),aa(fun(B,fun(bool,bool)),fun(fun(B,bool),fun(B,bool)),combs(B,bool,bool),aa(fun(B,bool),fun(B,fun(bool,bool)),combb(bool,fun(bool,bool),B,fimplies),aa(fun(B,bool),fun(B,bool),combb(bool,bool,B,fNot),aa(B,fun(B,bool),aa(fun(B,fun(B,bool)),fun(B,fun(B,bool)),combc(B,B,bool),fequal(B)),A5)))),Pa)) ) ).

tff(fact_31_insert__compr,axiom,
    ! [B: $tType,B3: fun(B,bool),A5: B] : ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),B3) = collect(B,aa(fun(B,bool),fun(B,bool),aa(fun(B,fun(bool,bool)),fun(fun(B,bool),fun(B,bool)),combs(B,bool,bool),aa(fun(B,bool),fun(B,fun(bool,bool)),combb(bool,fun(bool,bool),B,fdisj),aa(B,fun(B,bool),aa(fun(B,fun(B,bool)),fun(B,fun(B,bool)),combc(B,B,bool),fequal(B)),A5))),aa(fun(B,bool),fun(B,bool),aa(fun(B,fun(fun(B,bool),bool)),fun(fun(B,bool),fun(B,bool)),combc(B,fun(B,bool),bool),member(B)),B3))) ) ).

tff(fact_32_insertI1,axiom,
    ! [B: $tType,B3: fun(B,bool),A5: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),B3))) ).

tff(fact_33_insert__compr__raw,axiom,
    ! [B: $tType,X5: B,Xa: fun(B,bool)] : ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X5),Xa) = collect(B,aa(fun(B,bool),fun(B,bool),aa(fun(B,fun(bool,bool)),fun(fun(B,bool),fun(B,bool)),combs(B,bool,bool),aa(fun(B,bool),fun(B,fun(bool,bool)),combb(bool,fun(bool,bool),B,fdisj),aa(B,fun(B,bool),aa(fun(B,fun(B,bool)),fun(B,fun(B,bool)),combc(B,B,bool),fequal(B)),X5))),aa(fun(B,bool),fun(B,bool),aa(fun(B,fun(fun(B,bool),bool)),fun(fun(B,bool),fun(B,bool)),combc(B,fun(B,bool),bool),member(B)),Xa))) ) ).

tff(fact_34_singleton__inject,axiom,
    ! [B: $tType,Ba: B,A5: B] :
      ( ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool))) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),Ba),bot_bot(fun(B,bool))) )
     => ( A5 = Ba ) ) ).

tff(fact_35_singletonE,axiom,
    ! [B: $tType,A5: B,Ba: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ba),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool)))))
     => ( Ba = A5 ) ) ).

tff(fact_36_doubleton__eq__iff,axiom,
    ! [B: $tType,D: B,Ca: B,Ba: B,A5: B] :
      ( ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),Ba),bot_bot(fun(B,bool)))) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),Ca),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),D),bot_bot(fun(B,bool)))) )
    <=> ( ( ( A5 = Ca )
          & ( Ba = D ) )
        | ( ( A5 = D )
          & ( Ba = Ca ) ) ) ) ).

tff(fact_37_singleton__iff,axiom,
    ! [B: $tType,A5: B,Ba: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ba),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool)))))
    <=> ( Ba = A5 ) ) ).

tff(fact_38_insert__not__empty,axiom,
    ! [B: $tType,A1: fun(B,bool),A5: B] : ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),A1) != bot_bot(fun(B,bool)) ) ).

tff(fact_39_empty__not__insert,axiom,
    ! [B: $tType,A1: fun(B,bool),A5: B] : ( bot_bot(fun(B,bool)) != aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),A1) ) ).

tff(fact_40_Collect__conv__if,axiom,
    ! [B: $tType,A5: B,Pa: fun(B,bool)] :
      ( ( pp(aa(B,bool,Pa,A5))
       => ( collect(B,aa(fun(B,bool),fun(B,bool),aa(fun(B,fun(bool,bool)),fun(fun(B,bool),fun(B,bool)),combs(B,bool,bool),aa(fun(B,bool),fun(B,fun(bool,bool)),combb(bool,fun(bool,bool),B,fconj),aa(B,fun(B,bool),aa(fun(B,fun(B,bool)),fun(B,fun(B,bool)),combc(B,B,bool),fequal(B)),A5))),Pa)) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool))) ) )
      & ( ~ pp(aa(B,bool,Pa,A5))
       => ( collect(B,aa(fun(B,bool),fun(B,bool),aa(fun(B,fun(bool,bool)),fun(fun(B,bool),fun(B,bool)),combs(B,bool,bool),aa(fun(B,bool),fun(B,fun(bool,bool)),combb(bool,fun(bool,bool),B,fconj),aa(B,fun(B,bool),aa(fun(B,fun(B,bool)),fun(B,fun(B,bool)),combc(B,B,bool),fequal(B)),A5))),Pa)) = bot_bot(fun(B,bool)) ) ) ) ).

tff(fact_41_Collect__conv__if2,axiom,
    ! [B: $tType,A5: B,Pa: fun(B,bool)] :
      ( ( pp(aa(B,bool,Pa,A5))
       => ( collect(B,aa(fun(B,bool),fun(B,bool),aa(fun(B,fun(bool,bool)),fun(fun(B,bool),fun(B,bool)),combs(B,bool,bool),aa(fun(B,bool),fun(B,fun(bool,bool)),combb(bool,fun(bool,bool),B,fconj),aa(B,fun(B,bool),fequal(B),A5))),Pa)) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool))) ) )
      & ( ~ pp(aa(B,bool,Pa,A5))
       => ( collect(B,aa(fun(B,bool),fun(B,bool),aa(fun(B,fun(bool,bool)),fun(fun(B,bool),fun(B,bool)),combs(B,bool,bool),aa(fun(B,bool),fun(B,fun(bool,bool)),combb(bool,fun(bool,bool),B,fconj),aa(B,fun(B,bool),fequal(B),A5))),Pa)) = bot_bot(fun(B,bool)) ) ) ) ).

tff(fact_42_the__elem__eq,axiom,
    ! [B: $tType,X1: B] : ( the_elem(B,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),bot_bot(fun(B,bool)))) = X1 ) ).

tff(fact_43_triple_Osimps_I2_J,axiom,
    ! [B: $tType,C: $tType,Fun21: fun(C,fun(state,bool)),Com3: com,Fun11: fun(C,fun(state,bool)),F11: fun(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)))] : ( hoare_376461865e_case(C,B,F11,hoare_1841697145triple(C,Fun11,Com3,Fun21)) = aa(fun(C,fun(state,bool)),B,aa(com,fun(fun(C,fun(state,bool)),B),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)),F11,Fun11),Com3),Fun21) ) ).

tff(fact_44_triple_Orecs,axiom,
    ! [B: $tType,C: $tType,Fun21: fun(C,fun(state,bool)),Com3: com,Fun11: fun(C,fun(state,bool)),F11: fun(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)))] : ( hoare_678420151le_rec(C,B,F11,hoare_1841697145triple(C,Fun11,Com3,Fun21)) = aa(fun(C,fun(state,bool)),B,aa(com,fun(fun(C,fun(state,bool)),B),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)),F11,Fun11),Com3),Fun21) ) ).

tff(fact_45_bot__apply,axiom,
    ! [C: $tType,B: $tType] :
      ( bot(B)
     => ! [X1: C] : ( aa(C,B,bot_bot(fun(C,B)),X1) = bot_bot(B) ) ) ).

tff(fact_46_bot__fun__def,axiom,
    ! [B: $tType,C: $tType] :
      ( bot(C)
     => ! [X5: B] : ( aa(B,C,bot_bot(fun(B,C)),X5) = bot_bot(C) ) ) ).

tff(fact_47_hoare__derivs_OSkip,axiom,
    ! [B: $tType,Pa: fun(B,fun(state,bool)),Ga: fun(hoare_28830079triple(B),bool)] : hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Pa,skip,Pa)),bot_bot(fun(hoare_28830079triple(B),bool)))) ).

tff(fact_48_Comp,axiom,
    ! [B: $tType,R1: fun(B,fun(state,bool)),D: com,Q1: fun(B,fun(state,bool)),Ca: com,Pa: fun(B,fun(state,bool)),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Pa,Ca,Q1)),bot_bot(fun(hoare_28830079triple(B),bool))))
     => ( hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Q1,D,R1)),bot_bot(fun(hoare_28830079triple(B),bool))))
       => hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Pa,semi(Ca,D),R1)),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ) ).

tff(fact_49_triple_Oexhaust,axiom,
    ! [B: $tType,Y3: hoare_28830079triple(B)] :
      ~ ! [Fun1: fun(B,fun(state,bool)),Com: com,Fun2: fun(B,fun(state,bool))] : ( Y3 != hoare_1841697145triple(B,Fun1,Com,Fun2) ) ).

tff(fact_50_com_Osimps_I3_J,axiom,
    ! [Com22: com,Com12: com,Com21: com,Com11: com] :
      ( ( semi(Com11,Com21) = semi(Com12,Com22) )
    <=> ( ( Com11 = Com12 )
        & ( Com21 = Com22 ) ) ) ).

tff(fact_51_com_Osimps_I13_J,axiom,
    ! [Com2: com,Com1: com] : ( semi(Com1,Com2) != skip ) ).

tff(fact_52_com_Osimps_I12_J,axiom,
    ! [Com2: com,Com1: com] : ( skip != semi(Com1,Com2) ) ).

tff(fact_53_the__elem__def,axiom,
    ! [B: $tType,X4: fun(B,bool)] : ( the_elem(B,X4) = the(B,aa(fun(B,fun(B,bool)),fun(B,bool),combb(fun(B,bool),bool,B,aa(fun(B,bool),fun(fun(B,bool),bool),fequal(fun(B,bool)),X4)),aa(fun(B,bool),fun(B,fun(B,bool)),aa(fun(B,fun(fun(B,bool),fun(B,bool))),fun(fun(B,bool),fun(B,fun(B,bool))),combc(B,fun(B,bool),fun(B,bool)),insert(B)),bot_bot(fun(B,bool))))) ) ).

tff(fact_54_the__sym__eq__trivial,axiom,
    ! [B: $tType,X1: B] : ( the(B,aa(B,fun(B,bool),fequal(B),X1)) = X1 ) ).

tff(fact_55_the__eq__trivial,axiom,
    ! [B: $tType,A5: B] : ( the(B,aa(B,fun(B,bool),aa(fun(B,fun(B,bool)),fun(B,fun(B,bool)),combc(B,B,bool),fequal(B)),A5)) = A5 ) ).

tff(fact_56_If__def,axiom,
    ! [B: $tType,Y3: B,X1: B,Pa: bool] :
      ( ( pp(Pa)
       => ( X1 = the(B,aa(fun(B,bool),fun(B,bool),aa(fun(B,fun(bool,bool)),fun(fun(B,bool),fun(B,bool)),combs(B,bool,bool),aa(fun(B,bool),fun(B,fun(bool,bool)),combb(bool,fun(bool,bool),B,fconj),aa(fun(B,bool),fun(B,bool),combb(bool,bool,B,aa(bool,fun(bool,bool),fimplies,Pa)),aa(B,fun(B,bool),aa(fun(B,fun(B,bool)),fun(B,fun(B,bool)),combc(B,B,bool),fequal(B)),X1)))),aa(fun(B,bool),fun(B,bool),combb(bool,bool,B,aa(bool,fun(bool,bool),fimplies,aa(bool,bool,fNot,Pa))),aa(B,fun(B,bool),aa(fun(B,fun(B,bool)),fun(B,fun(B,bool)),combc(B,B,bool),fequal(B)),Y3)))) ) )
      & ( ~ pp(Pa)
       => ( Y3 = the(B,aa(fun(B,bool),fun(B,bool),aa(fun(B,fun(bool,bool)),fun(fun(B,bool),fun(B,bool)),combs(B,bool,bool),aa(fun(B,bool),fun(B,fun(bool,bool)),combb(bool,fun(bool,bool),B,fconj),aa(fun(B,bool),fun(B,bool),combb(bool,bool,B,aa(bool,fun(bool,bool),fimplies,Pa)),aa(B,fun(B,bool),aa(fun(B,fun(B,bool)),fun(B,fun(B,bool)),combc(B,B,bool),fequal(B)),X1)))),aa(fun(B,bool),fun(B,bool),combb(bool,bool,B,aa(bool,fun(bool,bool),fimplies,aa(bool,bool,fNot,Pa))),aa(B,fun(B,bool),aa(fun(B,fun(B,bool)),fun(B,fun(B,bool)),combc(B,B,bool),fequal(B)),Y3)))) ) ) ) ).

tff(fact_57_Set_Oset__insert,axiom,
    ! [B: $tType,A1: fun(B,bool),X1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A1))
     => ~ ! [B2: fun(B,bool)] :
            ( ( A1 = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),B2) )
           => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),B2)) ) ) ).

tff(fact_58_the__equality,axiom,
    ! [B: $tType,A5: B,Pa: fun(B,bool)] :
      ( pp(aa(B,bool,Pa,A5))
     => ( ! [X3: B] :
            ( pp(aa(B,bool,Pa,X3))
           => ( X3 = A5 ) )
       => ( the(B,Pa) = A5 ) ) ) ).

tff(fact_59_theI,axiom,
    ! [B: $tType,A5: B,Pa: fun(B,bool)] :
      ( pp(aa(B,bool,Pa,A5))
     => ( ! [X3: B] :
            ( pp(aa(B,bool,Pa,X3))
           => ( X3 = A5 ) )
       => pp(aa(B,bool,Pa,the(B,Pa))) ) ) ).

tff(fact_60_the1__equality,axiom,
    ! [B: $tType,A5: B,Pa: fun(B,bool)] :
      ( ? [X5: B] :
          ( pp(aa(B,bool,Pa,X5))
          & ! [Y2: B] :
              ( pp(aa(B,bool,Pa,Y2))
             => ( Y2 = X5 ) ) )
     => ( pp(aa(B,bool,Pa,A5))
       => ( the(B,Pa) = A5 ) ) ) ).

tff(fact_61_theI_H,axiom,
    ! [B: $tType,Pa: fun(B,bool)] :
      ( ? [X5: B] :
          ( pp(aa(B,bool,Pa,X5))
          & ! [Y2: B] :
              ( pp(aa(B,bool,Pa,Y2))
             => ( Y2 = X5 ) ) )
     => pp(aa(B,bool,Pa,the(B,Pa))) ) ).

tff(fact_62_mk__disjoint__insert,axiom,
    ! [B: $tType,A1: fun(B,bool),A5: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A1))
     => ? [B2: fun(B,bool)] :
          ( ( A1 = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),B2) )
          & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),B2)) ) ) ).

tff(fact_63_equals0I,axiom,
    ! [B: $tType,A1: fun(B,bool)] :
      ( ! [Y2: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Y2),A1))
     => ( A1 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_64_conseq,axiom,
    ! [B: $tType,Q1: fun(B,fun(state,bool)),Ca: com,Ga: fun(hoare_28830079triple(B),bool),Pa: fun(B,fun(state,bool))] :
      ( ! [Z1: B,S: state] :
          ( pp(aa(state,bool,aa(B,fun(state,bool),Pa,Z1),S))
         => ? [P1: fun(B,fun(state,bool)),Q2: fun(B,fun(state,bool))] :
              ( hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,P1,Ca,Q2)),bot_bot(fun(hoare_28830079triple(B),bool))))
              & ! [S1: state] :
                  ( ! [Z2: B] :
                      ( pp(aa(state,bool,aa(B,fun(state,bool),P1,Z2),S))
                     => pp(aa(state,bool,aa(B,fun(state,bool),Q2,Z2),S1)) )
                 => pp(aa(state,bool,aa(B,fun(state,bool),Q1,Z1),S1)) ) ) )
     => hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Pa,Ca,Q1)),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ).

tff(fact_65_nonempty__iff,axiom,
    ! [B: $tType,A1: fun(B,bool)] :
      ( ( A1 != bot_bot(fun(B,bool)) )
    <=> ? [X2: B,B1: fun(B,bool)] :
          ( ( A1 = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X2),B1) )
          & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),B1)) ) ) ).

tff(fact_66_bot__empty__eq,axiom,
    ! [B: $tType,X5: B] :
      ( pp(aa(B,bool,bot_bot(fun(B,bool)),X5))
    <=> pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X5),bot_bot(fun(B,bool)))) ) ).

tff(fact_67_fold1Set__sing,axiom,
    ! [B: $tType,Ba: B,A5: B,F: fun(B,fun(B,B))] :
      ( pp(aa(B,bool,finite_fold1Set(B,F,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool)))),Ba))
    <=> ( A5 = Ba ) ) ).

tff(fact_68_folding__one_Osingleton,axiom,
    ! [B: $tType,X1: B,F1: fun(fun(B,bool),B),F: fun(B,fun(B,B))] :
      ( finite_folding_one(B,F,F1)
     => ( aa(fun(B,bool),B,F1,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),bot_bot(fun(B,bool)))) = X1 ) ) ).

tff(fact_69_the1I2,axiom,
    ! [B: $tType,Q1: fun(B,bool),Pa: fun(B,bool)] :
      ( ? [X5: B] :
          ( pp(aa(B,bool,Pa,X5))
          & ! [Y2: B] :
              ( pp(aa(B,bool,Pa,Y2))
             => ( Y2 = X5 ) ) )
     => ( ! [X3: B] :
            ( pp(aa(B,bool,Pa,X3))
           => pp(aa(B,bool,Q1,X3)) )
       => pp(aa(B,bool,Q1,the(B,Pa))) ) ) ).

tff(fact_70_fold1Set__nonempty,axiom,
    ! [B: $tType,X1: B,A1: fun(B,bool),F: fun(B,fun(B,B))] :
      ( pp(aa(B,bool,finite_fold1Set(B,F,A1),X1))
     => ( A1 != bot_bot(fun(B,bool)) ) ) ).

tff(fact_71_empty__fold1SetE,axiom,
    ! [B: $tType,X1: B,F: fun(B,fun(B,B))] : ~ pp(aa(B,bool,finite_fold1Set(B,F,bot_bot(fun(B,bool))),X1)) ).

tff(fact_72_fold1Set_Ointros,axiom,
    ! [B: $tType,X1: B,A1: fun(B,bool),A5: B,F: fun(B,fun(B,B))] :
      ( finite_fold_graph(B,B,F,A5,A1,X1)
     => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A1))
       => pp(aa(B,bool,finite_fold1Set(B,F,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),A1)),X1)) ) ) ).

tff(fact_73_folding__one_Oinsert,axiom,
    ! [B: $tType,X1: B,A1: fun(B,bool),F1: fun(fun(B,bool),B),F: fun(B,fun(B,B))] :
      ( finite_folding_one(B,F,F1)
     => ( finite_finite1(B,A1)
       => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A1))
         => ( ( A1 != bot_bot(fun(B,bool)) )
           => ( aa(fun(B,bool),B,F1,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),A1)) = aa(B,B,aa(B,fun(B,B),F,X1),aa(fun(B,bool),B,F1,A1)) ) ) ) ) ) ).

tff(fact_74_fold1__def,axiom,
    ! [B: $tType,A1: fun(B,bool),F: fun(B,fun(B,B))] : ( aa(fun(B,bool),B,finite_fold1(B,F),A1) = the(B,finite_fold1Set(B,F,A1)) ) ).

tff(fact_75_ext,axiom,
    ! [C: $tType,B: $tType,G: fun(B,C),F: fun(B,C)] :
      ( ! [X3: B] : ( aa(B,C,F,X3) = aa(B,C,G,X3) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [B: $tType,A1: fun(B,bool),X1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A1))
    <=> pp(aa(B,bool,A1,X1)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [B: $tType,Pa: fun(B,bool)] : ( collect(B,Pa) = Pa ) ).

tff(fact_78_finite__code,axiom,
    ! [B: $tType] :
      ( finite_finite(B)
     => ! [A1: fun(B,bool)] : finite_finite1(B,A1) ) ).

tff(fact_79_finite__Collect__conjI,axiom,
    ! [B: $tType,Q1: fun(B,bool),Pa: fun(B,bool)] :
      ( ( finite_finite1(B,collect(B,Pa))
        | finite_finite1(B,collect(B,Q1)) )
     => finite_finite1(B,collect(B,aa(fun(B,bool),fun(B,bool),aa(fun(B,fun(bool,bool)),fun(fun(B,bool),fun(B,bool)),combs(B,bool,bool),aa(fun(B,bool),fun(B,fun(bool,bool)),combb(bool,fun(bool,bool),B,fconj),Pa)),Q1))) ) ).

tff(fact_80_finite__Collect__disjI,axiom,
    ! [B: $tType,Q1: fun(B,bool),Pa: fun(B,bool)] :
      ( finite_finite1(B,collect(B,aa(fun(B,bool),fun(B,bool),aa(fun(B,fun(bool,bool)),fun(fun(B,bool),fun(B,bool)),combs(B,bool,bool),aa(fun(B,bool),fun(B,fun(bool,bool)),combb(bool,fun(bool,bool),B,fdisj),Pa)),Q1)))
    <=> ( finite_finite1(B,collect(B,Pa))
        & finite_finite1(B,collect(B,Q1)) ) ) ).

tff(fact_81_finite_OemptyI,axiom,
    ! [B: $tType] : finite_finite1(B,bot_bot(fun(B,bool))) ).

tff(fact_82_finite_OinsertI,axiom,
    ! [B: $tType,A5: B,A1: fun(B,bool)] :
      ( finite_finite1(B,A1)
     => finite_finite1(B,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),A1)) ) ).

tff(fact_83_finite__insert,axiom,
    ! [B: $tType,A1: fun(B,bool),A5: B] :
      ( finite_finite1(B,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),A1))
    <=> finite_finite1(B,A1) ) ).

tff(fact_84_folding__one_Oeq__fold,axiom,
    ! [B: $tType,A1: fun(B,bool),F1: fun(fun(B,bool),B),F: fun(B,fun(B,B))] :
      ( finite_folding_one(B,F,F1)
     => ( finite_finite1(B,A1)
       => ( aa(fun(B,bool),B,F1,A1) = aa(fun(B,bool),B,finite_fold1(B,F),A1) ) ) ) ).

tff(fact_85_finite,axiom,
    ! [B: $tType] :
      ( finite_finite(B)
     => ! [A1: fun(B,bool)] : finite_finite1(B,A1) ) ).

tff(fact_86_fold__graph_OinsertI,axiom,
    ! [B: $tType,C: $tType,Y3: C,Z: C,F: fun(B,fun(C,C)),A1: fun(B,bool),X1: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A1))
     => ( finite_fold_graph(B,C,F,Z,A1,Y3)
       => finite_fold_graph(B,C,F,Z,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),A1),aa(C,C,aa(B,fun(C,C),F,X1),Y3)) ) ) ).

tff(fact_87_empty__fold__graphE,axiom,
    ! [B: $tType,C: $tType,X1: C,Z: C,F: fun(B,fun(C,C))] :
      ( finite_fold_graph(B,C,F,Z,bot_bot(fun(B,bool)),X1)
     => ( X1 = Z ) ) ).

tff(fact_88_fold__graph_OemptyI,axiom,
    ! [B: $tType,C: $tType,Z: C,F: fun(B,fun(C,C))] : finite_fold_graph(B,C,F,Z,bot_bot(fun(B,bool)),Z) ).

tff(fact_89_fold1__singleton,axiom,
    ! [B: $tType,A5: B,F: fun(B,fun(B,B))] : ( aa(fun(B,bool),B,finite_fold1(B,F),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool)))) = A5 ) ).

tff(fact_90_fold1__singleton__def,axiom,
    ! [B: $tType,A5: B,F: fun(B,fun(B,B)),G: fun(fun(B,bool),B)] :
      ( ( G = finite_fold1(B,F) )
     => ( aa(fun(B,bool),B,G,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool)))) = A5 ) ) ).

tff(fact_91_folding__one_Oclosed,axiom,
    ! [B: $tType,A1: fun(B,bool),F1: fun(fun(B,bool),B),F: fun(B,fun(B,B))] :
      ( finite_folding_one(B,F,F1)
     => ( finite_finite1(B,A1)
       => ( ( A1 != bot_bot(fun(B,bool)) )
         => ( ! [X3: B,Y2: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(B,B,aa(B,fun(B,B),F,X3),Y2)),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X3),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),Y2),bot_bot(fun(B,bool))))))
           => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(fun(B,bool),B,F1,A1)),A1)) ) ) ) ) ).

tff(fact_92_insert__fold1SetE,axiom,
    ! [B: $tType,X1: B,X4: fun(B,bool),A5: B,F: fun(B,fun(B,B))] :
      ( pp(aa(B,bool,finite_fold1Set(B,F,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),X4)),X1))
     => ~ ! [A7: B,A6: fun(B,bool)] :
            ( ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),X4) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A7),A6) )
           => ( finite_fold_graph(B,B,F,A7,A6,X1)
             => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A7),A6)) ) ) ) ).

tff(fact_93_finite__nonempty__imp__fold1Set,axiom,
    ! [B: $tType,F: fun(B,fun(B,B)),A1: fun(B,bool)] :
      ( finite_finite1(B,A1)
     => ( ( A1 != bot_bot(fun(B,bool)) )
       => ? [X11: B] : pp(aa(B,bool,finite_fold1Set(B,F,A1),X11)) ) ) ).

tff(fact_94_finite_Osimps,axiom,
    ! [B: $tType,A5: fun(B,bool)] :
      ( finite_finite1(B,A5)
    <=> ( ( A5 = bot_bot(fun(B,bool)) )
        | ? [A3: fun(B,bool),A4: B] :
            ( ( A5 = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A4),A3) )
            & finite_finite1(B,A3) ) ) ) ).

tff(fact_95_finite__induct,axiom,
    ! [B: $tType,Pa: fun(fun(B,bool),bool),F1: fun(B,bool)] :
      ( finite_finite1(B,F1)
     => ( pp(aa(fun(B,bool),bool,Pa,bot_bot(fun(B,bool))))
       => ( ! [X3: B,F2: fun(B,bool)] :
              ( finite_finite1(B,F2)
             => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),F2))
               => ( pp(aa(fun(B,bool),bool,Pa,F2))
                 => pp(aa(fun(B,bool),bool,Pa,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X3),F2))) ) ) )
         => pp(aa(fun(B,bool),bool,Pa,F1)) ) ) ) ).

tff(fact_96_finite__imp__fold__graph,axiom,
    ! [B: $tType,C: $tType,Z: C,F: fun(B,fun(C,C)),A1: fun(B,bool)] :
      ( finite_finite1(B,A1)
     => ? [X11: C] : finite_fold_graph(B,C,F,Z,A1,X11) ) ).

tff(fact_97_fold1Set_Osimps,axiom,
    ! [B: $tType,A2: B,A11: fun(B,bool),F: fun(B,fun(B,B))] :
      ( pp(aa(B,bool,finite_fold1Set(B,F,A11),A2))
    <=> ? [A4: B,A3: fun(B,bool),X2: B] :
          ( ( A11 = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A4),A3) )
          & ( A2 = X2 )
          & finite_fold_graph(B,B,F,A4,A3,X2)
          & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A4),A3)) ) ) ).

tff(fact_98_fold__graph_Osimps,axiom,
    ! [B: $tType,C: $tType,A2: C,A11: fun(B,bool),Z: C,F: fun(B,fun(C,C))] :
      ( finite_fold_graph(B,C,F,Z,A11,A2)
    <=> ( ( ( A11 = bot_bot(fun(B,bool)) )
          & ( A2 = Z ) )
        | ? [X2: B,A3: fun(B,bool),Y1: C] :
            ( ( A11 = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X2),A3) )
            & ( A2 = aa(C,C,aa(B,fun(C,C),F,X2),Y1) )
            & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A3))
            & finite_fold_graph(B,C,F,Z,A3,Y1) ) ) ) ).

tff(fact_99_folding__one__idem_Oinsert__idem,axiom,
    ! [B: $tType,X1: B,A1: fun(B,bool),F1: fun(fun(B,bool),B),F: fun(B,fun(B,B))] :
      ( finite2073411215e_idem(B,F,F1)
     => ( finite_finite1(B,A1)
       => ( ( A1 != bot_bot(fun(B,bool)) )
         => ( aa(fun(B,bool),B,F1,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),A1)) = aa(B,B,aa(B,fun(B,B),F,X1),aa(fun(B,bool),B,F1,A1)) ) ) ) ) ).

%----Arities (4)
tff(arity_fun___Finite__Set_Ofinite,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( finite_finite(T_2)
        & finite_finite(T_1) )
     => finite_finite(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Finite__Set_Ofinite,axiom,
    finite_finite(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (21)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),combb(B,C,A,P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),aa(fun(A,fun(B,C)),fun(B,fun(A,C)),combc(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C)),combs(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    hoare_992312373derivs(a,g,aa(fun(hoare_28830079triple(a),bool),fun(hoare_28830079triple(a),bool),aa(hoare_28830079triple(a),fun(fun(hoare_28830079triple(a),bool),fun(hoare_28830079triple(a),bool)),insert(hoare_28830079triple(a)),hoare_1841697145triple(a,hoare_1442473487ek_and(a,aa(fun(state,bool),fun(a,fun(state,bool)),aa(fun(a,fun(fun(state,bool),fun(state,bool))),fun(fun(state,bool),fun(a,fun(state,bool))),combc(a,fun(state,bool),fun(state,bool)),aa(fun(a,fun(state,fun(bool,bool))),fun(a,fun(fun(state,bool),fun(state,bool))),combb(fun(state,fun(bool,bool)),fun(fun(state,bool),fun(state,bool)),a,combs(state,bool,bool)),aa(fun(a,fun(state,bool)),fun(a,fun(state,fun(bool,bool))),combb(fun(state,bool),fun(state,fun(bool,bool)),a,combb(bool,fun(bool,bool),state,fconj)),p))),aa(fun(state,bool),fun(state,bool),combb(bool,bool,state,fNot),b)),b),c,aa(fun(state,bool),fun(a,fun(state,bool)),aa(fun(a,fun(fun(state,bool),fun(state,bool))),fun(fun(state,bool),fun(a,fun(state,bool))),combc(a,fun(state,bool),fun(state,bool)),aa(fun(a,fun(state,fun(bool,bool))),fun(a,fun(fun(state,bool),fun(state,bool))),combb(fun(state,fun(bool,bool)),fun(fun(state,bool),fun(state,bool)),a,combs(state,bool,bool)),aa(fun(a,fun(state,bool)),fun(a,fun(state,fun(bool,bool))),combb(fun(state,bool),fun(state,fun(bool,bool)),a,combb(bool,fun(bool,bool),state,fconj)),p))),aa(fun(state,bool),fun(state,bool),combb(bool,bool,state,fNot),b)))),bot_bot(fun(hoare_28830079triple(a),bool)))) ).

%------------------------------------------------------------------------------
