%------------------------------------------------------------------------------
% File     : SWW510_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Hoare's Logic with Procedures line 189
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : hoare_189 [Bla13]

% Status   : Theorem
% Rating   : 0.67 v7.4.0, 1.00 v6.4.0
% Syntax   : Number of formulae    :  170 (  39 unt;  43 typ;   0 def)
%            Number of atoms       :  321 ( 112 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  258 (  64   ~;  25   |;  30   &)
%                                         (  21 <=>; 118  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   17 (   6 avg)
%            Maximal term depth    :    8 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   42 (  24   >;  18   *;   0   +;   0  <<)
%            Number of predicates  :   10 (   9 usr;   0 prp; 1-6 aty)
%            Number of functors    :   30 (  30 usr;   9 con; 0-5 aty)
%            Number of variables   :  497 ( 439   !;  23   ?; 497   :)
%                                         (  35  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:38
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_Com_Ocom,type,
    com: $tType ).

tff(ty_tc_Com_Ostate,type,
    state: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Hoare__Mirabelle__vtrypsmcwp_Otriple,type,
    hoare_28830079triple: $tType > $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (37)
tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Finite__Set_Ofinite,type,
    finite_finite: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Com_Ocom_OSKIP,type,
    skip: com ).

tff(sy_c_Com_Ocom_OSemi,type,
    semi: ( com * com ) > com ).

tff(sy_c_Finite__Set_Ofinite,type,
    finite_finite1: 
      !>[A: $tType] : ( fun(A,bool) > $o ) ).

tff(sy_c_Finite__Set_Ofold1,type,
    finite_fold1: 
      !>[A: $tType] : ( fun(A,fun(A,A)) > fun(fun(A,bool),A) ) ).

tff(sy_c_Finite__Set_Ofold1Set,type,
    finite_fold1Set: 
      !>[A: $tType] : ( ( fun(A,fun(A,A)) * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_Finite__Set_Ofold__graph,type,
    finite_fold_graph: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(B,B)) * B * fun(A,bool) * B ) > $o ) ).

tff(sy_c_Finite__Set_Ofolding__one,type,
    finite_folding_one: 
      !>[A: $tType] : ( ( fun(A,fun(A,A)) * fun(fun(A,bool),A) ) > $o ) ).

tff(sy_c_Finite__Set_Ofolding__one__idem,type,
    finite2073411215e_idem: 
      !>[A: $tType] : ( ( fun(A,fun(A,A)) * fun(fun(A,bool),A) ) > $o ) ).

tff(sy_c_HOL_OThe,type,
    the: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Ohoare__derivs,type,
    hoare_992312373derivs: 
      !>[A: $tType] : ( ( fun(hoare_28830079triple(A),bool) * fun(hoare_28830079triple(A),bool) ) > $o ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple,type,
    hoare_1841697145triple: 
      !>[A: $tType] : ( ( fun(A,fun(state,bool)) * com * fun(A,fun(state,bool)) ) > hoare_28830079triple(A) ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__case,type,
    hoare_376461865e_case: 
      !>[A: $tType,T1: $tType] : ( ( fun(fun(A,fun(state,bool)),fun(com,fun(fun(A,fun(state,bool)),T1))) * hoare_28830079triple(A) ) > T1 ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__rec,type,
    hoare_678420151le_rec: 
      !>[A: $tType,T1: $tType] : ( ( fun(fun(A,fun(state,bool)),fun(com,fun(fun(A,fun(state,bool)),T1))) * hoare_28830079triple(A) ) > T1 ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),fun(A,bool))) ).

tff(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_G,type,
    g: fun(hoare_28830079triple(a),bool) ).

tff(sy_v_P,type,
    p: ( a * state ) > $o ).

tff(sy_v_Q,type,
    q: a > fun(state,bool) ).

tff(sy_v_c,type,
    c: com ).

%----Relevant facts (100)
tff(fact_0_triple_Oinject,axiom,
    ! [B: $tType,Fun22: fun(B,fun(state,bool)),Com4: com,Fun12: fun(B,fun(state,bool)),Fun21: fun(B,fun(state,bool)),Com3: com,Fun11: fun(B,fun(state,bool))] :
      ( ( hoare_1841697145triple(B,Fun11,Com3,Fun21) = hoare_1841697145triple(B,Fun12,Com4,Fun22) )
    <=> ( ( Fun11 = Fun12 )
        & ( Com3 = Com4 )
        & ( Fun21 = Fun22 ) ) ) ).

tff(fact_1_empty,axiom,
    ! [B: $tType,Ga: fun(hoare_28830079triple(B),bool)] : hoare_992312373derivs(B,Ga,bot_bot(fun(hoare_28830079triple(B),bool))) ).

tff(fact_2_cut,axiom,
    ! [B: $tType,Ga: fun(hoare_28830079triple(B),bool),Ts: fun(hoare_28830079triple(B),bool),G1: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,G1,Ts)
     => ( hoare_992312373derivs(B,Ga,G1)
       => hoare_992312373derivs(B,Ga,Ts) ) ) ).

tff(fact_3_hoare__derivs_Oinsert,axiom,
    ! [B: $tType,Ts: fun(hoare_28830079triple(B),bool),T: hoare_28830079triple(B),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),T),bot_bot(fun(hoare_28830079triple(B),bool))))
     => ( hoare_992312373derivs(B,Ga,Ts)
       => hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),T),Ts)) ) ) ).

tff(fact_4_singleton__conv2,axiom,
    ! [B: $tType,A5: B] : ( collect(B,aa(B,fun(B,bool),fequal(B),A5)) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool))) ) ).

tff(fact_5_singleton__conv,axiom,
    ! [B: $tType,A5: B] : ( collect(B,combc(B,B,bool,fequal(B),A5)) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool))) ) ).

tff(fact_6_conseq2,axiom,
    ! [B: $tType,Qa: fun(B,fun(state,bool)),Q2: fun(B,fun(state,bool)),Ca: com,Pa: fun(B,fun(state,bool)),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Pa,Ca,Q2)),bot_bot(fun(hoare_28830079triple(B),bool))))
     => ( ! [Z: B,S: state] :
            ( pp(aa(state,bool,aa(B,fun(state,bool),Q2,Z),S))
           => pp(aa(state,bool,aa(B,fun(state,bool),Qa,Z),S)) )
       => hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Pa,Ca,Qa)),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ) ).

tff(fact_7_conseq1,axiom,
    ! [B: $tType,Pa: fun(B,fun(state,bool)),Qa: fun(B,fun(state,bool)),Ca: com,P2: fun(B,fun(state,bool)),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,P2,Ca,Qa)),bot_bot(fun(hoare_28830079triple(B),bool))))
     => ( ! [Z: B,S: state] :
            ( pp(aa(state,bool,aa(B,fun(state,bool),Pa,Z),S))
           => pp(aa(state,bool,aa(B,fun(state,bool),P2,Z),S)) )
       => hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Pa,Ca,Qa)),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ) ).

tff(fact_8_conseq12,axiom,
    ! [B: $tType,Qa: fun(B,fun(state,bool)),Pa: fun(B,fun(state,bool)),Q2: fun(B,fun(state,bool)),Ca: com,P2: fun(B,fun(state,bool)),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,P2,Ca,Q2)),bot_bot(fun(hoare_28830079triple(B),bool))))
     => ( ! [Z: B,S: state] :
            ( pp(aa(state,bool,aa(B,fun(state,bool),Pa,Z),S))
           => ! [S1: state] :
                ( ! [Z1: B] :
                    ( pp(aa(state,bool,aa(B,fun(state,bool),P2,Z1),S))
                   => pp(aa(state,bool,aa(B,fun(state,bool),Q2,Z1),S1)) )
               => pp(aa(state,bool,aa(B,fun(state,bool),Qa,Z),S1)) ) )
       => hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Pa,Ca,Qa)),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ) ).

tff(fact_9_insert__absorb2,axiom,
    ! [B: $tType,A1: fun(B,bool),X1: B] : ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),A1)) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),A1) ) ).

tff(fact_10_insert__iff,axiom,
    ! [B: $tType,A1: fun(B,bool),B1: B,A5: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),B1),A1)))
    <=> ( ( A5 = B1 )
        | pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A1)) ) ) ).

tff(fact_11_insertE,axiom,
    ! [B: $tType,A1: fun(B,bool),B1: B,A5: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),B1),A1)))
     => ( ( A5 != B1 )
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A1)) ) ) ).

tff(fact_12_insertCI,axiom,
    ! [B: $tType,B1: B,B4: fun(B,bool),A5: B] :
      ( ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),B4))
       => ( A5 = B1 ) )
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),B1),B4))) ) ).

tff(fact_13_all__not__in__conv,axiom,
    ! [B: $tType,A1: fun(B,bool)] :
      ( ! [X3: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A1))
    <=> ( A1 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_14_empty__Collect__eq,axiom,
    ! [B: $tType,Pa: fun(B,bool)] :
      ( ( bot_bot(fun(B,bool)) = collect(B,Pa) )
    <=> ! [X3: B] : ~ pp(aa(B,bool,Pa,X3)) ) ).

tff(fact_15_empty__iff,axiom,
    ! [B: $tType,Ca: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ca),bot_bot(fun(B,bool)))) ).

tff(fact_16_emptyE,axiom,
    ! [B: $tType,A5: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),bot_bot(fun(B,bool)))) ).

tff(fact_17_Collect__empty__eq,axiom,
    ! [B: $tType,Pa: fun(B,bool)] :
      ( ( collect(B,Pa) = bot_bot(fun(B,bool)) )
    <=> ! [X3: B] : ~ pp(aa(B,bool,Pa,X3)) ) ).

tff(fact_18_equals0D,axiom,
    ! [B: $tType,A5: B,A1: fun(B,bool)] :
      ( ( A1 = bot_bot(fun(B,bool)) )
     => ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A1)) ) ).

tff(fact_19_ex__in__conv,axiom,
    ! [B: $tType,A1: fun(B,bool)] :
      ( ? [X3: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A1))
    <=> ( A1 != bot_bot(fun(B,bool)) ) ) ).

tff(fact_20_empty__def,axiom,
    ! [B: $tType] : ( bot_bot(fun(B,bool)) = collect(B,combk(bool,B,fFalse)) ) ).

tff(fact_21_insert__absorb,axiom,
    ! [B: $tType,A1: fun(B,bool),A5: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A1))
     => ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),A1) = A1 ) ) ).

tff(fact_22_insertI2,axiom,
    ! [B: $tType,B1: B,B4: fun(B,bool),A5: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),B4))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),B1),B4))) ) ).

tff(fact_23_insert__eq__iff,axiom,
    ! [B: $tType,B4: fun(B,bool),B1: B,A1: fun(B,bool),A5: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A1))
     => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B1),B4))
       => ( ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),A1) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),B1),B4) )
        <=> ( ( ( A5 = B1 )
             => ( A1 = B4 ) )
            & ( ( A5 != B1 )
             => ? [C1: fun(B,bool)] :
                  ( ( A1 = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),B1),C1) )
                  & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B1),C1))
                  & ( B4 = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),C1) )
                  & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),C1)) ) ) ) ) ) ) ).

tff(fact_24_insert__ident,axiom,
    ! [B: $tType,B4: fun(B,bool),A1: fun(B,bool),X1: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A1))
     => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),B4))
       => ( ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),A1) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),B4) )
        <=> ( A1 = B4 ) ) ) ) ).

tff(fact_25_insert__code,axiom,
    ! [B: $tType,X1: B,A1: fun(B,bool),Y3: B] :
      ( pp(aa(B,bool,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),Y3),A1),X1))
    <=> ( ( Y3 = X1 )
        | pp(aa(B,bool,A1,X1)) ) ) ).

tff(fact_26_insert__commute,axiom,
    ! [B: $tType,A1: fun(B,bool),Y3: B,X1: B] : ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),Y3),A1)) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),Y3),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),A1)) ) ).

tff(fact_27_insert__Collect,axiom,
    ! [B: $tType,Pa: fun(B,bool),A5: B] : ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),collect(B,Pa)) = collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fimplies,combb(bool,bool,B,fNot,combc(B,B,bool,fequal(B),A5))),Pa)) ) ).

tff(fact_28_insert__compr,axiom,
    ! [B: $tType,B4: fun(B,bool),A5: B] : ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),B4) = collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fdisj,combc(B,B,bool,fequal(B),A5)),combc(B,fun(B,bool),bool,member(B),B4))) ) ).

tff(fact_29_insertI1,axiom,
    ! [B: $tType,B4: fun(B,bool),A5: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),B4))) ).

tff(fact_30_insert__compr__raw,axiom,
    ! [B: $tType,X5: B,Xa: fun(B,bool)] : ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X5),Xa) = collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fdisj,combc(B,B,bool,fequal(B),X5)),combc(B,fun(B,bool),bool,member(B),Xa))) ) ).

tff(fact_31_singleton__inject,axiom,
    ! [B: $tType,B1: B,A5: B] :
      ( ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool))) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),B1),bot_bot(fun(B,bool))) )
     => ( A5 = B1 ) ) ).

tff(fact_32_singletonE,axiom,
    ! [B: $tType,A5: B,B1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B1),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool)))))
     => ( B1 = A5 ) ) ).

tff(fact_33_doubleton__eq__iff,axiom,
    ! [B: $tType,D: B,Ca: B,B1: B,A5: B] :
      ( ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),B1),bot_bot(fun(B,bool)))) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),Ca),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),D),bot_bot(fun(B,bool)))) )
    <=> ( ( ( A5 = Ca )
          & ( B1 = D ) )
        | ( ( A5 = D )
          & ( B1 = Ca ) ) ) ) ).

tff(fact_34_singleton__iff,axiom,
    ! [B: $tType,A5: B,B1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B1),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool)))))
    <=> ( B1 = A5 ) ) ).

tff(fact_35_insert__not__empty,axiom,
    ! [B: $tType,A1: fun(B,bool),A5: B] : ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),A1) != bot_bot(fun(B,bool)) ) ).

tff(fact_36_empty__not__insert,axiom,
    ! [B: $tType,A1: fun(B,bool),A5: B] : ( bot_bot(fun(B,bool)) != aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),A1) ) ).

tff(fact_37_Collect__conv__if,axiom,
    ! [B: $tType,A5: B,Pa: fun(B,bool)] :
      ( ( pp(aa(B,bool,Pa,A5))
       => ( collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,combc(B,B,bool,fequal(B),A5)),Pa)) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool))) ) )
      & ( ~ pp(aa(B,bool,Pa,A5))
       => ( collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,combc(B,B,bool,fequal(B),A5)),Pa)) = bot_bot(fun(B,bool)) ) ) ) ).

tff(fact_38_Collect__conv__if2,axiom,
    ! [B: $tType,A5: B,Pa: fun(B,bool)] :
      ( ( pp(aa(B,bool,Pa,A5))
       => ( collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,aa(B,fun(B,bool),fequal(B),A5)),Pa)) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool))) ) )
      & ( ~ pp(aa(B,bool,Pa,A5))
       => ( collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,aa(B,fun(B,bool),fequal(B),A5)),Pa)) = bot_bot(fun(B,bool)) ) ) ) ).

tff(fact_39_the__elem__eq,axiom,
    ! [B: $tType,X1: B] : ( the_elem(B,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),bot_bot(fun(B,bool)))) = X1 ) ).

tff(fact_40_triple_Osimps_I2_J,axiom,
    ! [B: $tType,C: $tType,Fun21: fun(C,fun(state,bool)),Com3: com,Fun11: fun(C,fun(state,bool)),F11: fun(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)))] : ( hoare_376461865e_case(C,B,F11,hoare_1841697145triple(C,Fun11,Com3,Fun21)) = aa(fun(C,fun(state,bool)),B,aa(com,fun(fun(C,fun(state,bool)),B),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)),F11,Fun11),Com3),Fun21) ) ).

tff(fact_41_triple_Orecs,axiom,
    ! [B: $tType,C: $tType,Fun21: fun(C,fun(state,bool)),Com3: com,Fun11: fun(C,fun(state,bool)),F11: fun(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)))] : ( hoare_678420151le_rec(C,B,F11,hoare_1841697145triple(C,Fun11,Com3,Fun21)) = aa(fun(C,fun(state,bool)),B,aa(com,fun(fun(C,fun(state,bool)),B),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)),F11,Fun11),Com3),Fun21) ) ).

tff(fact_42_bot__apply,axiom,
    ! [C: $tType,B: $tType] :
      ( bot(B)
     => ! [X1: C] : ( aa(C,B,bot_bot(fun(C,B)),X1) = bot_bot(B) ) ) ).

tff(fact_43_bot__fun__def,axiom,
    ! [B: $tType,C: $tType] :
      ( bot(C)
     => ! [X5: B] : ( aa(B,C,bot_bot(fun(B,C)),X5) = bot_bot(C) ) ) ).

tff(fact_44_hoare__derivs_OSkip,axiom,
    ! [B: $tType,Pa: fun(B,fun(state,bool)),Ga: fun(hoare_28830079triple(B),bool)] : hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Pa,skip,Pa)),bot_bot(fun(hoare_28830079triple(B),bool)))) ).

tff(fact_45_Comp,axiom,
    ! [B: $tType,R1: fun(B,fun(state,bool)),D: com,Qa: fun(B,fun(state,bool)),Ca: com,Pa: fun(B,fun(state,bool)),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Pa,Ca,Qa)),bot_bot(fun(hoare_28830079triple(B),bool))))
     => ( hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Qa,D,R1)),bot_bot(fun(hoare_28830079triple(B),bool))))
       => hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Pa,semi(Ca,D),R1)),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ) ).

tff(fact_46_triple_Oexhaust,axiom,
    ! [B: $tType,Y3: hoare_28830079triple(B)] :
      ~ ! [Fun1: fun(B,fun(state,bool)),Com: com,Fun2: fun(B,fun(state,bool))] : ( Y3 != hoare_1841697145triple(B,Fun1,Com,Fun2) ) ).

tff(fact_47_com_Osimps_I3_J,axiom,
    ! [Com22: com,Com12: com,Com21: com,Com11: com] :
      ( ( semi(Com11,Com21) = semi(Com12,Com22) )
    <=> ( ( Com11 = Com12 )
        & ( Com21 = Com22 ) ) ) ).

tff(fact_48_com_Osimps_I13_J,axiom,
    ! [Com2: com,Com1: com] : ( semi(Com1,Com2) != skip ) ).

tff(fact_49_com_Osimps_I12_J,axiom,
    ! [Com2: com,Com1: com] : ( skip != semi(Com1,Com2) ) ).

tff(fact_50_the__elem__def,axiom,
    ! [B: $tType,X4: fun(B,bool)] : ( the_elem(B,X4) = the(B,combb(fun(B,bool),bool,B,aa(fun(B,bool),fun(fun(B,bool),bool),fequal(fun(B,bool)),X4),combc(B,fun(B,bool),fun(B,bool),insert(B),bot_bot(fun(B,bool))))) ) ).

tff(fact_51_the__sym__eq__trivial,axiom,
    ! [B: $tType,X1: B] : ( the(B,aa(B,fun(B,bool),fequal(B),X1)) = X1 ) ).

tff(fact_52_the__eq__trivial,axiom,
    ! [B: $tType,A5: B] : ( the(B,combc(B,B,bool,fequal(B),A5)) = A5 ) ).

tff(fact_53_If__def,axiom,
    ! [B: $tType,Y3: B,X1: B,Pa: bool] :
      ( ( pp(Pa)
       => ( X1 = the(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,combb(bool,bool,B,aa(bool,fun(bool,bool),fimplies,Pa),combc(B,B,bool,fequal(B),X1))),combb(bool,bool,B,aa(bool,fun(bool,bool),fimplies,aa(bool,bool,fNot,Pa)),combc(B,B,bool,fequal(B),Y3)))) ) )
      & ( ~ pp(Pa)
       => ( Y3 = the(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,combb(bool,bool,B,aa(bool,fun(bool,bool),fimplies,Pa),combc(B,B,bool,fequal(B),X1))),combb(bool,bool,B,aa(bool,fun(bool,bool),fimplies,aa(bool,bool,fNot,Pa)),combc(B,B,bool,fequal(B),Y3)))) ) ) ) ).

tff(fact_54_Set_Oset__insert,axiom,
    ! [B: $tType,A1: fun(B,bool),X1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A1))
     => ~ ! [B3: fun(B,bool)] :
            ( ( A1 = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),B3) )
           => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),B3)) ) ) ).

tff(fact_55_the__equality,axiom,
    ! [B: $tType,A5: B,Pa: fun(B,bool)] :
      ( pp(aa(B,bool,Pa,A5))
     => ( ! [X2: B] :
            ( pp(aa(B,bool,Pa,X2))
           => ( X2 = A5 ) )
       => ( the(B,Pa) = A5 ) ) ) ).

tff(fact_56_theI,axiom,
    ! [B: $tType,A5: B,Pa: fun(B,bool)] :
      ( pp(aa(B,bool,Pa,A5))
     => ( ! [X2: B] :
            ( pp(aa(B,bool,Pa,X2))
           => ( X2 = A5 ) )
       => pp(aa(B,bool,Pa,the(B,Pa))) ) ) ).

tff(fact_57_the1__equality,axiom,
    ! [B: $tType,A5: B,Pa: fun(B,bool)] :
      ( ? [X5: B] :
          ( pp(aa(B,bool,Pa,X5))
          & ! [Y2: B] :
              ( pp(aa(B,bool,Pa,Y2))
             => ( Y2 = X5 ) ) )
     => ( pp(aa(B,bool,Pa,A5))
       => ( the(B,Pa) = A5 ) ) ) ).

tff(fact_58_theI_H,axiom,
    ! [B: $tType,Pa: fun(B,bool)] :
      ( ? [X5: B] :
          ( pp(aa(B,bool,Pa,X5))
          & ! [Y2: B] :
              ( pp(aa(B,bool,Pa,Y2))
             => ( Y2 = X5 ) ) )
     => pp(aa(B,bool,Pa,the(B,Pa))) ) ).

tff(fact_59_mk__disjoint__insert,axiom,
    ! [B: $tType,A1: fun(B,bool),A5: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A1))
     => ? [B3: fun(B,bool)] :
          ( ( A1 = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),B3) )
          & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),B3)) ) ) ).

tff(fact_60_equals0I,axiom,
    ! [B: $tType,A1: fun(B,bool)] :
      ( ! [Y2: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Y2),A1))
     => ( A1 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_61_conseq,axiom,
    ! [B: $tType,Qa: fun(B,fun(state,bool)),Ca: com,Ga: fun(hoare_28830079triple(B),bool),Pa: fun(B,fun(state,bool))] :
      ( ! [Z: B,S: state] :
          ( pp(aa(state,bool,aa(B,fun(state,bool),Pa,Z),S))
         => ? [P: fun(B,fun(state,bool)),Q: fun(B,fun(state,bool))] :
              ( hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,P,Ca,Q)),bot_bot(fun(hoare_28830079triple(B),bool))))
              & ! [S1: state] :
                  ( ! [Z1: B] :
                      ( pp(aa(state,bool,aa(B,fun(state,bool),P,Z1),S))
                     => pp(aa(state,bool,aa(B,fun(state,bool),Q,Z1),S1)) )
                 => pp(aa(state,bool,aa(B,fun(state,bool),Qa,Z),S1)) ) ) )
     => hoare_992312373derivs(B,Ga,aa(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool),aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),fun(hoare_28830079triple(B),bool)),insert(hoare_28830079triple(B)),hoare_1841697145triple(B,Pa,Ca,Qa)),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ).

tff(fact_62_nonempty__iff,axiom,
    ! [B: $tType,A1: fun(B,bool)] :
      ( ( A1 != bot_bot(fun(B,bool)) )
    <=> ? [X3: B,B2: fun(B,bool)] :
          ( ( A1 = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X3),B2) )
          & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),B2)) ) ) ).

tff(fact_63_bot__empty__eq,axiom,
    ! [B: $tType,X5: B] :
      ( pp(aa(B,bool,bot_bot(fun(B,bool)),X5))
    <=> pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X5),bot_bot(fun(B,bool)))) ) ).

tff(fact_64_theI2,axiom,
    ! [B: $tType,Qa: fun(B,bool),A5: B,Pa: fun(B,bool)] :
      ( pp(aa(B,bool,Pa,A5))
     => ( ! [X2: B] :
            ( pp(aa(B,bool,Pa,X2))
           => ( X2 = A5 ) )
       => ( ! [X2: B] :
              ( pp(aa(B,bool,Pa,X2))
             => pp(aa(B,bool,Qa,X2)) )
         => pp(aa(B,bool,Qa,the(B,Pa))) ) ) ) ).

tff(fact_65_fold1Set__sing,axiom,
    ! [B: $tType,B1: B,A5: B,F: fun(B,fun(B,B))] :
      ( pp(aa(B,bool,finite_fold1Set(B,F,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool)))),B1))
    <=> ( A5 = B1 ) ) ).

tff(fact_66_folding__one_Osingleton,axiom,
    ! [B: $tType,X1: B,F1: fun(fun(B,bool),B),F: fun(B,fun(B,B))] :
      ( finite_folding_one(B,F,F1)
     => ( aa(fun(B,bool),B,F1,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),bot_bot(fun(B,bool)))) = X1 ) ) ).

tff(fact_67_the1I2,axiom,
    ! [B: $tType,Qa: fun(B,bool),Pa: fun(B,bool)] :
      ( ? [X5: B] :
          ( pp(aa(B,bool,Pa,X5))
          & ! [Y2: B] :
              ( pp(aa(B,bool,Pa,Y2))
             => ( Y2 = X5 ) ) )
     => ( ! [X2: B] :
            ( pp(aa(B,bool,Pa,X2))
           => pp(aa(B,bool,Qa,X2)) )
       => pp(aa(B,bool,Qa,the(B,Pa))) ) ) ).

tff(fact_68_fold1Set__nonempty,axiom,
    ! [B: $tType,X1: B,A1: fun(B,bool),F: fun(B,fun(B,B))] :
      ( pp(aa(B,bool,finite_fold1Set(B,F,A1),X1))
     => ( A1 != bot_bot(fun(B,bool)) ) ) ).

tff(fact_69_empty__fold1SetE,axiom,
    ! [B: $tType,X1: B,F: fun(B,fun(B,B))] : ~ pp(aa(B,bool,finite_fold1Set(B,F,bot_bot(fun(B,bool))),X1)) ).

tff(fact_70_fold1Set_Ointros,axiom,
    ! [B: $tType,X1: B,A1: fun(B,bool),A5: B,F: fun(B,fun(B,B))] :
      ( finite_fold_graph(B,B,F,A5,A1,X1)
     => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A1))
       => pp(aa(B,bool,finite_fold1Set(B,F,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),A1)),X1)) ) ) ).

tff(fact_71_folding__one_Oinsert,axiom,
    ! [B: $tType,X1: B,A1: fun(B,bool),F1: fun(fun(B,bool),B),F: fun(B,fun(B,B))] :
      ( finite_folding_one(B,F,F1)
     => ( finite_finite1(B,A1)
       => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A1))
         => ( ( A1 != bot_bot(fun(B,bool)) )
           => ( aa(fun(B,bool),B,F1,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),A1)) = aa(B,B,aa(B,fun(B,B),F,X1),aa(fun(B,bool),B,F1,A1)) ) ) ) ) ) ).

tff(fact_72_fold1__def,axiom,
    ! [B: $tType,A1: fun(B,bool),F: fun(B,fun(B,B))] : ( aa(fun(B,bool),B,finite_fold1(B,F),A1) = the(B,finite_fold1Set(B,F,A1)) ) ).

tff(fact_73_finite__code,axiom,
    ! [B: $tType] :
      ( finite_finite(B)
     => ! [A1: fun(B,bool)] : finite_finite1(B,A1) ) ).

tff(fact_74_finite__Collect__conjI,axiom,
    ! [B: $tType,Qa: fun(B,bool),Pa: fun(B,bool)] :
      ( ( finite_finite1(B,collect(B,Pa))
        | finite_finite1(B,collect(B,Qa)) )
     => finite_finite1(B,collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,Pa),Qa))) ) ).

tff(fact_75_ext,axiom,
    ! [C: $tType,B: $tType,G: fun(B,C),F: fun(B,C)] :
      ( ! [X2: B] : ( aa(B,C,F,X2) = aa(B,C,G,X2) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [B: $tType,A1: fun(B,bool),X1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A1))
    <=> pp(aa(B,bool,A1,X1)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [B: $tType,Pa: fun(B,bool)] : ( collect(B,Pa) = Pa ) ).

tff(fact_78_finite__Collect__disjI,axiom,
    ! [B: $tType,Qa: fun(B,bool),Pa: fun(B,bool)] :
      ( finite_finite1(B,collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fdisj,Pa),Qa)))
    <=> ( finite_finite1(B,collect(B,Pa))
        & finite_finite1(B,collect(B,Qa)) ) ) ).

tff(fact_79_finite_OemptyI,axiom,
    ! [B: $tType] : finite_finite1(B,bot_bot(fun(B,bool))) ).

tff(fact_80_finite_OinsertI,axiom,
    ! [B: $tType,A5: B,A1: fun(B,bool)] :
      ( finite_finite1(B,A1)
     => finite_finite1(B,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),A1)) ) ).

tff(fact_81_finite__insert,axiom,
    ! [B: $tType,A1: fun(B,bool),A5: B] :
      ( finite_finite1(B,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),A1))
    <=> finite_finite1(B,A1) ) ).

tff(fact_82_folding__one_Oeq__fold,axiom,
    ! [B: $tType,A1: fun(B,bool),F1: fun(fun(B,bool),B),F: fun(B,fun(B,B))] :
      ( finite_folding_one(B,F,F1)
     => ( finite_finite1(B,A1)
       => ( aa(fun(B,bool),B,F1,A1) = aa(fun(B,bool),B,finite_fold1(B,F),A1) ) ) ) ).

tff(fact_83_finite,axiom,
    ! [B: $tType] :
      ( finite_finite(B)
     => ! [A1: fun(B,bool)] : finite_finite1(B,A1) ) ).

tff(fact_84_fold__graph_OinsertI,axiom,
    ! [B: $tType,C: $tType,Y3: C,Z3: C,F: fun(B,fun(C,C)),A1: fun(B,bool),X1: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A1))
     => ( finite_fold_graph(B,C,F,Z3,A1,Y3)
       => finite_fold_graph(B,C,F,Z3,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),A1),aa(C,C,aa(B,fun(C,C),F,X1),Y3)) ) ) ).

tff(fact_85_empty__fold__graphE,axiom,
    ! [B: $tType,C: $tType,X1: C,Z3: C,F: fun(B,fun(C,C))] :
      ( finite_fold_graph(B,C,F,Z3,bot_bot(fun(B,bool)),X1)
     => ( X1 = Z3 ) ) ).

tff(fact_86_fold__graph_OemptyI,axiom,
    ! [B: $tType,C: $tType,Z3: C,F: fun(B,fun(C,C))] : finite_fold_graph(B,C,F,Z3,bot_bot(fun(B,bool)),Z3) ).

tff(fact_87_fold1__singleton,axiom,
    ! [B: $tType,A5: B,F: fun(B,fun(B,B))] : ( aa(fun(B,bool),B,finite_fold1(B,F),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool)))) = A5 ) ).

tff(fact_88_fold1__singleton__def,axiom,
    ! [B: $tType,A5: B,F: fun(B,fun(B,B)),G: fun(fun(B,bool),B)] :
      ( ( G = finite_fold1(B,F) )
     => ( aa(fun(B,bool),B,G,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),bot_bot(fun(B,bool)))) = A5 ) ) ).

tff(fact_89_folding__one_Oclosed,axiom,
    ! [B: $tType,A1: fun(B,bool),F1: fun(fun(B,bool),B),F: fun(B,fun(B,B))] :
      ( finite_folding_one(B,F,F1)
     => ( finite_finite1(B,A1)
       => ( ( A1 != bot_bot(fun(B,bool)) )
         => ( ! [X2: B,Y2: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(B,B,aa(B,fun(B,B),F,X2),Y2)),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X2),aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),Y2),bot_bot(fun(B,bool))))))
           => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(fun(B,bool),B,F1,A1)),A1)) ) ) ) ) ).

tff(fact_90_insert__fold1SetE,axiom,
    ! [B: $tType,X1: B,X4: fun(B,bool),A5: B,F: fun(B,fun(B,B))] :
      ( pp(aa(B,bool,finite_fold1Set(B,F,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),X4)),X1))
     => ~ ! [A7: B,A6: fun(B,bool)] :
            ( ( aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A5),X4) = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A7),A6) )
           => ( finite_fold_graph(B,B,F,A7,A6,X1)
             => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A7),A6)) ) ) ) ).

tff(fact_91_finite__nonempty__imp__fold1Set,axiom,
    ! [B: $tType,F: fun(B,fun(B,B)),A1: fun(B,bool)] :
      ( finite_finite1(B,A1)
     => ( ( A1 != bot_bot(fun(B,bool)) )
       => ? [X11: B] : pp(aa(B,bool,finite_fold1Set(B,F,A1),X11)) ) ) ).

tff(fact_92_finite_Osimps,axiom,
    ! [B: $tType,A5: fun(B,bool)] :
      ( finite_finite1(B,A5)
    <=> ( ( A5 = bot_bot(fun(B,bool)) )
        | ? [A3: fun(B,bool),A4: B] :
            ( ( A5 = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A4),A3) )
            & finite_finite1(B,A3) ) ) ) ).

tff(fact_93_finite__induct,axiom,
    ! [B: $tType,Pa: fun(fun(B,bool),bool),F1: fun(B,bool)] :
      ( finite_finite1(B,F1)
     => ( pp(aa(fun(B,bool),bool,Pa,bot_bot(fun(B,bool))))
       => ( ! [X2: B,F2: fun(B,bool)] :
              ( finite_finite1(B,F2)
             => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),F2))
               => ( pp(aa(fun(B,bool),bool,Pa,F2))
                 => pp(aa(fun(B,bool),bool,Pa,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X2),F2))) ) ) )
         => pp(aa(fun(B,bool),bool,Pa,F1)) ) ) ) ).

tff(fact_94_finite__imp__fold__graph,axiom,
    ! [B: $tType,C: $tType,Z3: C,F: fun(B,fun(C,C)),A1: fun(B,bool)] :
      ( finite_finite1(B,A1)
     => ? [X11: C] : finite_fold_graph(B,C,F,Z3,A1,X11) ) ).

tff(fact_95_fold1Set_Osimps,axiom,
    ! [B: $tType,A2: B,A11: fun(B,bool),F: fun(B,fun(B,B))] :
      ( pp(aa(B,bool,finite_fold1Set(B,F,A11),A2))
    <=> ? [A4: B,A3: fun(B,bool),X3: B] :
          ( ( A11 = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),A4),A3) )
          & ( A2 = X3 )
          & finite_fold_graph(B,B,F,A4,A3,X3)
          & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A4),A3)) ) ) ).

tff(fact_96_fold__graph_Osimps,axiom,
    ! [B: $tType,C: $tType,A2: C,A11: fun(B,bool),Z3: C,F: fun(B,fun(C,C))] :
      ( finite_fold_graph(B,C,F,Z3,A11,A2)
    <=> ( ( ( A11 = bot_bot(fun(B,bool)) )
          & ( A2 = Z3 ) )
        | ? [X3: B,A3: fun(B,bool),Y1: C] :
            ( ( A11 = aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X3),A3) )
            & ( A2 = aa(C,C,aa(B,fun(C,C),F,X3),Y1) )
            & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A3))
            & finite_fold_graph(B,C,F,Z3,A3,Y1) ) ) ) ).

tff(fact_97_folding__one__idem_Oinsert__idem,axiom,
    ! [B: $tType,X1: B,A1: fun(B,bool),F1: fun(fun(B,bool),B),F: fun(B,fun(B,B))] :
      ( finite2073411215e_idem(B,F,F1)
     => ( finite_finite1(B,A1)
       => ( ( A1 != bot_bot(fun(B,bool)) )
         => ( aa(fun(B,bool),B,F1,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X1),A1)) = aa(B,B,aa(B,fun(B,B),F,X1),aa(fun(B,bool),B,F1,A1)) ) ) ) ) ).

tff(fact_98_finite__ne__induct,axiom,
    ! [B: $tType,Pa: fun(fun(B,bool),bool),F1: fun(B,bool)] :
      ( finite_finite1(B,F1)
     => ( ( F1 != bot_bot(fun(B,bool)) )
       => ( ! [X2: B] : pp(aa(fun(B,bool),bool,Pa,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X2),bot_bot(fun(B,bool)))))
         => ( ! [X2: B,F2: fun(B,bool)] :
                ( finite_finite1(B,F2)
               => ( ( F2 != bot_bot(fun(B,bool)) )
                 => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),F2))
                   => ( pp(aa(fun(B,bool),bool,Pa,F2))
                     => pp(aa(fun(B,bool),bool,Pa,aa(fun(B,bool),fun(B,bool),aa(B,fun(fun(B,bool),fun(B,bool)),insert(B),X2),F2))) ) ) ) )
           => pp(aa(fun(B,bool),bool,Pa,F1)) ) ) ) ) ).

tff(fact_99_folding__one__idem_Oidem,axiom,
    ! [B: $tType,X1: B,F1: fun(fun(B,bool),B),F: fun(B,fun(B,B))] :
      ( finite2073411215e_idem(B,F,F1)
     => ( aa(B,B,aa(B,fun(B,B),F,X1),X1) = X1 ) ) ).

%----Arities (4)
tff(arity_fun___Finite__Set_Ofinite,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( finite_finite(T_2)
        & finite_finite(T_1) )
     => finite_finite(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Finite__Set_Ofinite,axiom,
    finite_finite(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (21)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P1: bool] :
      ( ~ pp(aa(bool,bool,fNot,P1))
      | ~ pp(P1) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P1: bool] :
      ( pp(P1)
      | pp(aa(bool,bool,fNot,P1)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q1: fun(A,B),P1: fun(B,C)] : ( aa(A,C,combb(B,C,A,P1,Q1),R) = aa(B,C,P1,aa(A,B,Q1,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q1: B,P1: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P1,Q1),R) = aa(B,C,aa(A,fun(B,C),P1,R),Q1) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q1: B,P1: A] : ( aa(B,A,combk(A,B,P1),Q1) = P1 ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q1: fun(A,B),P1: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P1,Q1),R) = aa(B,C,aa(A,fun(B,C),P1,R),aa(A,B,Q1,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q1: bool,P1: bool] :
      ( ~ pp(P1)
      | ~ pp(Q1)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P1),Q1)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q1: bool,P1: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P1),Q1))
      | pp(P1) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q1: bool,P1: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P1),Q1))
      | pp(Q1) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q1: bool,P1: bool] :
      ( ~ pp(P1)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P1),Q1)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P1: bool,Q1: bool] :
      ( ~ pp(Q1)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P1),Q1)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q1: bool,P1: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P1),Q1))
      | pp(P1)
      | pp(Q1) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P1: bool] :
      ( ( P1 = fTrue )
      | ( P1 = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q1: bool,P1: bool] :
      ( pp(P1)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P1),Q1)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P1: bool,Q1: bool] :
      ( ~ pp(Q1)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P1),Q1)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q1: bool,P1: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P1),Q1))
      | ~ pp(P1)
      | pp(Q1) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    ! [Z2: a,S2: state] :
      ( p(Z2,S2)
     => hoare_992312373derivs(a,g,aa(fun(hoare_28830079triple(a),bool),fun(hoare_28830079triple(a),bool),aa(hoare_28830079triple(a),fun(fun(hoare_28830079triple(a),bool),fun(hoare_28830079triple(a),bool)),insert(hoare_28830079triple(a)),hoare_1841697145triple(a,combk(fun(state,bool),a,combc(state,state,bool,fequal(state),S2)),c,combk(fun(state,bool),a,q(Z2)))),bot_bot(fun(hoare_28830079triple(a),bool)))) ) ).

tff(conj_1,conjecture,
    ! [Z: a,S: state] :
      ( ~ p(Z,S)
      | ? [P: fun(a,fun(state,bool)),Q: fun(a,fun(state,bool))] :
          ( hoare_992312373derivs(a,g,aa(fun(hoare_28830079triple(a),bool),fun(hoare_28830079triple(a),bool),aa(hoare_28830079triple(a),fun(fun(hoare_28830079triple(a),bool),fun(hoare_28830079triple(a),bool)),insert(hoare_28830079triple(a)),hoare_1841697145triple(a,P,c,Q)),bot_bot(fun(hoare_28830079triple(a),bool))))
          & ! [S1: state] :
              ( ? [Z1: a] :
                  ( pp(aa(state,bool,aa(a,fun(state,bool),P,Z1),S))
                  & ~ pp(aa(state,bool,aa(a,fun(state,bool),Q,Z1),S1)) )
              | pp(aa(state,bool,q(Z),S1)) ) ) ) ).

%------------------------------------------------------------------------------
