%------------------------------------------------------------------------------
% File     : SWW509_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Hoare's Logic with Procedures line 182
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : hoare_182 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  172 (  44 unt;  49 typ;   0 def)
%            Number of atoms       :  264 (  95 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  201 (  60   ~;  17   |;  20   &)
%                                         (  23 <=>;  81  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   17 (   6 avg)
%            Maximal term depth    :    8 (   2 avg)
%            Number of types       :    7 (   6 usr)
%            Number of type conns  :   52 (  27   >;  25   *;   0   +;   0  <<)
%            Number of predicates  :   10 (   9 usr;   0 prp; 1-6 aty)
%            Number of functors    :   34 (  34 usr;  10 con; 0-5 aty)
%            Number of variables   :  467 ( 417   !;  16   ?; 467   :)
%                                         (  34  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:11
%------------------------------------------------------------------------------
%----Should-be-implicit typings (9)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_Com_Ocom,type,
    com: $tType ).

tff(ty_tc_Com_Opname,type,
    pname: $tType ).

tff(ty_tc_Com_Ostate,type,
    state: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Hoare__Mirabelle__vtrypsmcwp_Otriple,type,
    hoare_28830079triple: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Option_Ooption,type,
    option: $tType > $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (40)
tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Com_Obody,type,
    body1: pname > option(com) ).

tff(sy_c_Com_Ocom_OBODY,type,
    body: pname > com ).

tff(sy_c_Com_Ocom_OSKIP,type,
    skip: com ).

tff(sy_c_Com_Ocom_OSemi,type,
    semi: ( com * com ) > com ).

tff(sy_c_Finite__Set_Ofold1Set,type,
    finite_fold1Set: 
      !>[A: $tType] : ( ( fun(A,fun(A,A)) * fun(A,bool) * A ) > $o ) ).

tff(sy_c_Finite__Set_Ofold__graph,type,
    finite_fold_graph: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(B,B)) * B * fun(A,bool) * B ) > $o ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Ohoare__derivs,type,
    hoare_992312373derivs: 
      !>[A: $tType] : ( ( fun(hoare_28830079triple(A),bool) * fun(hoare_28830079triple(A),bool) ) > $o ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple,type,
    hoare_1841697145triple: 
      !>[A: $tType] : ( ( fun(A,fun(state,bool)) * com * fun(A,fun(state,bool)) ) > hoare_28830079triple(A) ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__case,type,
    hoare_376461865e_case: 
      !>[A: $tType,T4: $tType] : ( ( fun(fun(A,fun(state,bool)),fun(com,fun(fun(A,fun(state,bool)),T4))) * hoare_28830079triple(A) ) > T4 ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__rec,type,
    hoare_678420151le_rec: 
      !>[A: $tType,T4: $tType] : ( ( fun(fun(A,fun(state,bool)),fun(com,fun(fun(A,fun(state,bool)),T4))) * hoare_28830079triple(A) ) > T4 ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple__valid,type,
    hoare_1633586161_valid: 
      !>[A: $tType] : ( ( nat * hoare_28830079triple(A) ) > $o ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat__aux,type,
    semiri532925092at_aux: 
      !>[A: $tType] : ( ( fun(A,A) * nat * A ) > A ) ).

tff(sy_c_Natural_Oevalc,type,
    evalc: ( com * state * state ) > $o ).

tff(sy_c_Natural_Oevaln,type,
    evaln: ( com * state * nat * state ) > $o ).

tff(sy_c_Option_Othe,type,
    the: 
      !>[A: $tType] : ( option(A) > A ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_G,type,
    g: fun(hoare_28830079triple(a),bool) ).

tff(sy_v_P,type,
    p: fun(a,fun(state,bool)) ).

tff(sy_v_Q,type,
    q: fun(a,fun(state,bool)) ).

tff(sy_v_pn,type,
    pn: pname ).

%----Relevant facts (99)
tff(fact_0_triple_Oinject,axiom,
    ! [B: $tType,Fun22: fun(B,fun(state,bool)),Com4: com,Fun12: fun(B,fun(state,bool)),Fun21: fun(B,fun(state,bool)),Com3: com,Fun11: fun(B,fun(state,bool))] :
      ( ( hoare_1841697145triple(B,Fun11,Com3,Fun21) = hoare_1841697145triple(B,Fun12,Com4,Fun22) )
    <=> ( ( Fun11 = Fun12 )
        & ( Com3 = Com4 )
        & ( Fun21 = Fun22 ) ) ) ).

tff(fact_1_empty,axiom,
    ! [B: $tType,Ga: fun(hoare_28830079triple(B),bool)] : hoare_992312373derivs(B,Ga,bot_bot(fun(hoare_28830079triple(B),bool))) ).

tff(fact_2_cut,axiom,
    ! [B: $tType,Ga: fun(hoare_28830079triple(B),bool),Ts: fun(hoare_28830079triple(B),bool),G1: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,G1,Ts)
     => ( hoare_992312373derivs(B,Ga,G1)
       => hoare_992312373derivs(B,Ga,Ts) ) ) ).

tff(fact_3_hoare__derivs_Oinsert,axiom,
    ! [B: $tType,Ts: fun(hoare_28830079triple(B),bool),T3: hoare_28830079triple(B),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),T3,bot_bot(fun(hoare_28830079triple(B),bool))))
     => ( hoare_992312373derivs(B,Ga,Ts)
       => hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),T3,Ts)) ) ) ).

tff(fact_4_conseq2,axiom,
    ! [B: $tType,Qa: fun(B,fun(state,bool)),Q2: fun(B,fun(state,bool)),C4: com,Pa: fun(B,fun(state,bool)),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),hoare_1841697145triple(B,Pa,C4,Q2),bot_bot(fun(hoare_28830079triple(B),bool))))
     => ( ! [Z2: B,S7: state] :
            ( pp(aa(state,bool,aa(B,fun(state,bool),Q2,Z2),S7))
           => pp(aa(state,bool,aa(B,fun(state,bool),Qa,Z2),S7)) )
       => hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),hoare_1841697145triple(B,Pa,C4,Qa),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ) ).

tff(fact_5_conseq1,axiom,
    ! [B: $tType,Pa: fun(B,fun(state,bool)),Qa: fun(B,fun(state,bool)),C4: com,P2: fun(B,fun(state,bool)),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),hoare_1841697145triple(B,P2,C4,Qa),bot_bot(fun(hoare_28830079triple(B),bool))))
     => ( ! [Z2: B,S7: state] :
            ( pp(aa(state,bool,aa(B,fun(state,bool),Pa,Z2),S7))
           => pp(aa(state,bool,aa(B,fun(state,bool),P2,Z2),S7)) )
       => hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),hoare_1841697145triple(B,Pa,C4,Qa),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ) ).

tff(fact_6_com_Osimps_I6_J,axiom,
    ! [Pname2: pname,Pname1: pname] :
      ( ( body(Pname1) = body(Pname2) )
    <=> ( Pname1 = Pname2 ) ) ).

tff(fact_7_conseq12,axiom,
    ! [B: $tType,Qa: fun(B,fun(state,bool)),Pa: fun(B,fun(state,bool)),Q2: fun(B,fun(state,bool)),C4: com,P2: fun(B,fun(state,bool)),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),hoare_1841697145triple(B,P2,C4,Q2),bot_bot(fun(hoare_28830079triple(B),bool))))
     => ( ! [Z2: B,S7: state] :
            ( pp(aa(state,bool,aa(B,fun(state,bool),Pa,Z2),S7))
           => ! [S8: state] :
                ( ! [Z3: B] :
                    ( pp(aa(state,bool,aa(B,fun(state,bool),P2,Z3),S7))
                   => pp(aa(state,bool,aa(B,fun(state,bool),Q2,Z3),S8)) )
               => pp(aa(state,bool,aa(B,fun(state,bool),Qa,Z2),S8)) ) )
       => hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),hoare_1841697145triple(B,Pa,C4,Qa),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ) ).

tff(fact_8_insert__absorb2,axiom,
    ! [B: $tType,A8: fun(B,bool),X3: B] : ( insert(B,X3,insert(B,X3,A8)) = insert(B,X3,A8) ) ).

tff(fact_9_insert__iff,axiom,
    ! [B: $tType,A8: fun(B,bool),B1: B,A5: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),insert(B,B1,A8)))
    <=> ( ( A5 = B1 )
        | pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A8)) ) ) ).

tff(fact_10_insertE,axiom,
    ! [B: $tType,A8: fun(B,bool),B1: B,A5: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),insert(B,B1,A8)))
     => ( ( A5 != B1 )
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A8)) ) ) ).

tff(fact_11_insertCI,axiom,
    ! [B: $tType,B1: B,B4: fun(B,bool),A5: B] :
      ( ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),B4))
       => ( A5 = B1 ) )
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),insert(B,B1,B4))) ) ).

tff(fact_12_all__not__in__conv,axiom,
    ! [B: $tType,A8: fun(B,bool)] :
      ( ! [X1: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A8))
    <=> ( A8 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_13_empty__Collect__eq,axiom,
    ! [B: $tType,Pa: fun(B,bool)] :
      ( ( bot_bot(fun(B,bool)) = collect(B,Pa) )
    <=> ! [X1: B] : ~ pp(aa(B,bool,Pa,X1)) ) ).

tff(fact_14_empty__iff,axiom,
    ! [B: $tType,C4: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C4),bot_bot(fun(B,bool)))) ).

tff(fact_15_Collect__empty__eq,axiom,
    ! [B: $tType,Pa: fun(B,bool)] :
      ( ( collect(B,Pa) = bot_bot(fun(B,bool)) )
    <=> ! [X1: B] : ~ pp(aa(B,bool,Pa,X1)) ) ).

tff(fact_16_emptyE,axiom,
    ! [B: $tType,A5: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),bot_bot(fun(B,bool)))) ).

tff(fact_17_equals0D,axiom,
    ! [B: $tType,A5: B,A8: fun(B,bool)] :
      ( ( A8 = bot_bot(fun(B,bool)) )
     => ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A8)) ) ).

tff(fact_18_ex__in__conv,axiom,
    ! [B: $tType,A8: fun(B,bool)] :
      ( ? [X1: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A8))
    <=> ( A8 != bot_bot(fun(B,bool)) ) ) ).

tff(fact_19_empty__def,axiom,
    ! [B: $tType] : ( bot_bot(fun(B,bool)) = collect(B,combk(bool,B,fFalse)) ) ).

tff(fact_20_insert__absorb,axiom,
    ! [B: $tType,A8: fun(B,bool),A5: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A8))
     => ( insert(B,A5,A8) = A8 ) ) ).

tff(fact_21_insertI2,axiom,
    ! [B: $tType,B1: B,B4: fun(B,bool),A5: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),B4))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),insert(B,B1,B4))) ) ).

tff(fact_22_insert__eq__iff,axiom,
    ! [B: $tType,B4: fun(B,bool),B1: B,A8: fun(B,bool),A5: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A8))
     => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B1),B4))
       => ( ( insert(B,A5,A8) = insert(B,B1,B4) )
        <=> ( ( ( A5 = B1 )
             => ( A8 = B4 ) )
            & ( ( A5 != B1 )
             => ? [C5: fun(B,bool)] :
                  ( ( A8 = insert(B,B1,C5) )
                  & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B1),C5))
                  & ( B4 = insert(B,A5,C5) )
                  & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),C5)) ) ) ) ) ) ) ).

tff(fact_23_insert__ident,axiom,
    ! [B: $tType,B4: fun(B,bool),A8: fun(B,bool),X3: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A8))
     => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),B4))
       => ( ( insert(B,X3,A8) = insert(B,X3,B4) )
        <=> ( A8 = B4 ) ) ) ) ).

tff(fact_24_insert__code,axiom,
    ! [B: $tType,X3: B,A8: fun(B,bool),Y2: B] :
      ( pp(aa(B,bool,insert(B,Y2,A8),X3))
    <=> ( ( Y2 = X3 )
        | pp(aa(B,bool,A8,X3)) ) ) ).

tff(fact_25_insert__commute,axiom,
    ! [B: $tType,A8: fun(B,bool),Y2: B,X3: B] : ( insert(B,X3,insert(B,Y2,A8)) = insert(B,Y2,insert(B,X3,A8)) ) ).

tff(fact_26_insert__Collect,axiom,
    ! [B: $tType,Pa: fun(B,bool),A5: B] : ( insert(B,A5,collect(B,Pa)) = collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fimplies,combb(bool,bool,B,fNot,combc(B,B,bool,fequal(B),A5))),Pa)) ) ).

tff(fact_27_insert__compr,axiom,
    ! [B: $tType,B4: fun(B,bool),A5: B] : ( insert(B,A5,B4) = collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fdisj,combc(B,B,bool,fequal(B),A5)),combc(B,fun(B,bool),bool,member(B),B4))) ) ).

tff(fact_28_insertI1,axiom,
    ! [B: $tType,B4: fun(B,bool),A5: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),insert(B,A5,B4))) ).

tff(fact_29_singleton__inject,axiom,
    ! [B: $tType,B1: B,A5: B] :
      ( ( insert(B,A5,bot_bot(fun(B,bool))) = insert(B,B1,bot_bot(fun(B,bool))) )
     => ( A5 = B1 ) ) ).

tff(fact_30_singletonE,axiom,
    ! [B: $tType,A5: B,B1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B1),insert(B,A5,bot_bot(fun(B,bool)))))
     => ( B1 = A5 ) ) ).

tff(fact_31_doubleton__eq__iff,axiom,
    ! [B: $tType,D: B,C4: B,B1: B,A5: B] :
      ( ( insert(B,A5,insert(B,B1,bot_bot(fun(B,bool)))) = insert(B,C4,insert(B,D,bot_bot(fun(B,bool)))) )
    <=> ( ( ( A5 = C4 )
          & ( B1 = D ) )
        | ( ( A5 = D )
          & ( B1 = C4 ) ) ) ) ).

tff(fact_32_singleton__iff,axiom,
    ! [B: $tType,A5: B,B1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B1),insert(B,A5,bot_bot(fun(B,bool)))))
    <=> ( B1 = A5 ) ) ).

tff(fact_33_insert__not__empty,axiom,
    ! [B: $tType,A8: fun(B,bool),A5: B] : ( insert(B,A5,A8) != bot_bot(fun(B,bool)) ) ).

tff(fact_34_empty__not__insert,axiom,
    ! [B: $tType,A8: fun(B,bool),A5: B] : ( bot_bot(fun(B,bool)) != insert(B,A5,A8) ) ).

tff(fact_35_the__elem__eq,axiom,
    ! [B: $tType,X3: B] : ( the_elem(B,insert(B,X3,bot_bot(fun(B,bool)))) = X3 ) ).

tff(fact_36_triple_Osimps_I2_J,axiom,
    ! [B: $tType,C: $tType,Fun21: fun(C,fun(state,bool)),Com3: com,Fun11: fun(C,fun(state,bool)),F1: fun(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)))] : ( hoare_376461865e_case(C,B,F1,hoare_1841697145triple(C,Fun11,Com3,Fun21)) = aa(fun(C,fun(state,bool)),B,aa(com,fun(fun(C,fun(state,bool)),B),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)),F1,Fun11),Com3),Fun21) ) ).

tff(fact_37_triple_Orecs,axiom,
    ! [B: $tType,C: $tType,Fun21: fun(C,fun(state,bool)),Com3: com,Fun11: fun(C,fun(state,bool)),F1: fun(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)))] : ( hoare_678420151le_rec(C,B,F1,hoare_1841697145triple(C,Fun11,Com3,Fun21)) = aa(fun(C,fun(state,bool)),B,aa(com,fun(fun(C,fun(state,bool)),B),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)),F1,Fun11),Com3),Fun21) ) ).

tff(fact_38_bot__apply,axiom,
    ! [C: $tType,B: $tType] :
      ( bot(B)
     => ! [X3: C] : ( aa(C,B,bot_bot(fun(C,B)),X3) = bot_bot(B) ) ) ).

tff(fact_39_bot__fun__def,axiom,
    ! [B: $tType,C: $tType] :
      ( bot(C)
     => ! [X5: B] : ( aa(B,C,bot_bot(fun(B,C)),X5) = bot_bot(C) ) ) ).

tff(fact_40_hoare__derivs_OSkip,axiom,
    ! [B: $tType,Pa: fun(B,fun(state,bool)),Ga: fun(hoare_28830079triple(B),bool)] : hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),hoare_1841697145triple(B,Pa,skip,Pa),bot_bot(fun(hoare_28830079triple(B),bool)))) ).

tff(fact_41_Comp,axiom,
    ! [B: $tType,R1: fun(B,fun(state,bool)),D: com,Qa: fun(B,fun(state,bool)),C4: com,Pa: fun(B,fun(state,bool)),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),hoare_1841697145triple(B,Pa,C4,Qa),bot_bot(fun(hoare_28830079triple(B),bool))))
     => ( hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),hoare_1841697145triple(B,Qa,D,R1),bot_bot(fun(hoare_28830079triple(B),bool))))
       => hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),hoare_1841697145triple(B,Pa,semi(C4,D),R1),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ) ).

tff(fact_42_triple_Oexhaust,axiom,
    ! [B: $tType,Y2: hoare_28830079triple(B)] :
      ~ ! [Fun1: fun(B,fun(state,bool)),Com: com,Fun2: fun(B,fun(state,bool))] : ( Y2 != hoare_1841697145triple(B,Fun1,Com,Fun2) ) ).

tff(fact_43_com_Osimps_I3_J,axiom,
    ! [Com23: com,Com13: com,Com22: com,Com12: com] :
      ( ( semi(Com12,Com22) = semi(Com13,Com23) )
    <=> ( ( Com12 = Com13 )
        & ( Com22 = Com23 ) ) ) ).

tff(fact_44_com_Osimps_I12_J,axiom,
    ! [Com21: com,Com11: com] : ( skip != semi(Com11,Com21) ) ).

tff(fact_45_com_Osimps_I13_J,axiom,
    ! [Com21: com,Com11: com] : ( semi(Com11,Com21) != skip ) ).

tff(fact_46_com_Osimps_I49_J,axiom,
    ! [Com2: com,Com1: com,Pname: pname] : ( body(Pname) != semi(Com1,Com2) ) ).

tff(fact_47_com_Osimps_I48_J,axiom,
    ! [Pname: pname,Com2: com,Com1: com] : ( semi(Com1,Com2) != body(Pname) ) ).

tff(fact_48_com_Osimps_I18_J,axiom,
    ! [Pname: pname] : ( skip != body(Pname) ) ).

tff(fact_49_com_Osimps_I19_J,axiom,
    ! [Pname: pname] : ( body(Pname) != skip ) ).

tff(fact_50_mk__disjoint__insert,axiom,
    ! [B: $tType,A8: fun(B,bool),A5: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A8))
     => ? [B3: fun(B,bool)] :
          ( ( A8 = insert(B,A5,B3) )
          & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),B3)) ) ) ).

tff(fact_51_Set_Oset__insert,axiom,
    ! [B: $tType,A8: fun(B,bool),X3: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A8))
     => ~ ! [B3: fun(B,bool)] :
            ( ( A8 = insert(B,X3,B3) )
           => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),B3)) ) ) ).

tff(fact_52_equals0I,axiom,
    ! [B: $tType,A8: fun(B,bool)] :
      ( ! [Y3: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Y3),A8))
     => ( A8 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_53_conseq,axiom,
    ! [B: $tType,Qa: fun(B,fun(state,bool)),C4: com,Ga: fun(hoare_28830079triple(B),bool),Pa: fun(B,fun(state,bool))] :
      ( ! [Z2: B,S7: state] :
          ( pp(aa(state,bool,aa(B,fun(state,bool),Pa,Z2),S7))
         => ? [P1: fun(B,fun(state,bool)),Q1: fun(B,fun(state,bool))] :
              ( hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),hoare_1841697145triple(B,P1,C4,Q1),bot_bot(fun(hoare_28830079triple(B),bool))))
              & ! [S8: state] :
                  ( ! [Z3: B] :
                      ( pp(aa(state,bool,aa(B,fun(state,bool),P1,Z3),S7))
                     => pp(aa(state,bool,aa(B,fun(state,bool),Q1,Z3),S8)) )
                 => pp(aa(state,bool,aa(B,fun(state,bool),Qa,Z2),S8)) ) ) )
     => hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),hoare_1841697145triple(B,Pa,C4,Qa),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ).

tff(fact_54_evalc__elim__cases_I6_J,axiom,
    ! [S1: state,S: state,P: pname] :
      ( evalc(body(P),S,S1)
     => evalc(the(com,body1(P)),S,S1) ) ).

tff(fact_55_evalc_OSemi,axiom,
    ! [S2: state,C1: com,S1: state,S0: state,C0: com] :
      ( evalc(C0,S0,S1)
     => ( evalc(C1,S1,S2)
       => evalc(semi(C0,C1),S0,S2) ) ) ).

tff(fact_56_evalc__elim__cases_I1_J,axiom,
    ! [T: state,S: state] :
      ( evalc(skip,S,T)
     => ( T = S ) ) ).

tff(fact_57_evalc_OSkip,axiom,
    ! [S: state] : evalc(skip,S,S) ).

tff(fact_58_evalc_OBody,axiom,
    ! [S1: state,S0: state,Pn: pname] :
      ( evalc(the(com,body1(Pn)),S0,S1)
     => evalc(body(Pn),S0,S1) ) ).

tff(fact_59_com__det,axiom,
    ! [U: state,T: state,S: state,C3: com] :
      ( evalc(C3,S,T)
     => ( evalc(C3,S,U)
       => ( U = T ) ) ) ).

tff(fact_60_evalc__elim__cases_I4_J,axiom,
    ! [T: state,S: state,C2: com,C1: com] :
      ( evalc(semi(C1,C2),S,T)
     => ~ ! [S11: state] :
            ( evalc(C1,S,S11)
           => ~ evalc(C2,S11,T) ) ) ).

tff(fact_61_nonempty__iff,axiom,
    ! [B: $tType,A8: fun(B,bool)] :
      ( ( A8 != bot_bot(fun(B,bool)) )
    <=> ? [X1: B,B2: fun(B,bool)] :
          ( ( A8 = insert(B,X1,B2) )
          & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),B2)) ) ) ).

tff(fact_62_bot__empty__eq,axiom,
    ! [B: $tType,X5: B] :
      ( pp(aa(B,bool,bot_bot(fun(B,bool)),X5))
    <=> pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X5),bot_bot(fun(B,bool)))) ) ).

tff(fact_63_Body__triple__valid__Suc,axiom,
    ! [B: $tType,Qa: fun(B,fun(state,bool)),Pna: pname,Pa: fun(B,fun(state,bool)),N3: nat] :
      ( hoare_1633586161_valid(B,N3,hoare_1841697145triple(B,Pa,the(com,body1(Pna)),Qa))
    <=> hoare_1633586161_valid(B,suc(N3),hoare_1841697145triple(B,Pa,body(Pna),Qa)) ) ).

tff(fact_64_triple__valid__Suc,axiom,
    ! [A: $tType,T: hoare_28830079triple(A),N4: nat] :
      ( hoare_1633586161_valid(A,suc(N4),T)
     => hoare_1633586161_valid(A,N4,T) ) ).

tff(fact_65_nat_Oinject,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( suc(Nat) = suc(Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_66_evaln_OBody,axiom,
    ! [S1: state,N4: nat,S0: state,Pn: pname] :
      ( evaln(the(com,body1(Pn)),S0,N4,S1)
     => evaln(body(Pn),S0,suc(N4),S1) ) ).

tff(fact_67_evaln_OSemi,axiom,
    ! [S2: state,C1: com,S1: state,N4: nat,S0: state,C0: com] :
      ( evaln(C0,S0,N4,S1)
     => ( evaln(C1,S1,N4,S2)
       => evaln(semi(C0,C1),S0,N4,S2) ) ) ).

tff(fact_68_evaln_OSkip,axiom,
    ! [N4: nat,S: state] : evaln(skip,S,N4,S) ).

tff(fact_69_evaln__elim__cases_I1_J,axiom,
    ! [T: state,N4: nat,S: state] :
      ( evaln(skip,S,N4,T)
     => ( T = S ) ) ).

tff(fact_70_evaln__Suc,axiom,
    ! [S6: state,N4: nat,S: state,C3: com] :
      ( evaln(C3,S,N4,S6)
     => evaln(C3,S,suc(N4),S6) ) ).

tff(fact_71_evaln__evalc,axiom,
    ! [T: state,N4: nat,S: state,C3: com] :
      ( evaln(C3,S,N4,T)
     => evalc(C3,S,T) ) ).

tff(fact_72_eval__eq,axiom,
    ! [T3: state,S5: state,C4: com] :
      ( evalc(C4,S5,T3)
    <=> ? [N5: nat] : evaln(C4,S5,N5,T3) ) ).

tff(fact_73_triple__valid__def2,axiom,
    ! [B: $tType,Qa: fun(B,fun(state,bool)),C4: com,Pa: fun(B,fun(state,bool)),N3: nat] :
      ( hoare_1633586161_valid(B,N3,hoare_1841697145triple(B,Pa,C4,Qa))
    <=> ! [Z1: B,S3: state] :
          ( pp(aa(state,bool,aa(B,fun(state,bool),Pa,Z1),S3))
         => ! [S4: state] :
              ( evaln(C4,S3,N3,S4)
             => pp(aa(state,bool,aa(B,fun(state,bool),Qa,Z1),S4)) ) ) ) ).

tff(fact_74_ext,axiom,
    ! [C: $tType,B: $tType,G: fun(B,C),F: fun(B,C)] :
      ( ! [X4: B] : ( aa(B,C,F,X4) = aa(B,C,G,X4) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [B: $tType,A8: fun(B,bool),X3: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A8))
    <=> pp(aa(B,bool,A8,X3)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [B: $tType,Pa: fun(B,bool)] : ( collect(B,Pa) = Pa ) ).

tff(fact_77_n__not__Suc__n,axiom,
    ! [N4: nat] : ( N4 != suc(N4) ) ).

tff(fact_78_Suc__n__not__n,axiom,
    ! [N4: nat] : ( suc(N4) != N4 ) ).

tff(fact_79_Suc__inject,axiom,
    ! [Y: nat,X: nat] :
      ( ( suc(X) = suc(Y) )
     => ( X = Y ) ) ).

tff(fact_80_evaln__elim__cases_I6_J,axiom,
    ! [S1: state,N4: nat,S: state,P: pname] :
      ( evaln(body(P),S,N4,S1)
     => ~ ! [N: nat] :
            ( ( N4 = suc(N) )
           => ~ evaln(the(com,body1(P)),S,N,S1) ) ) ).

tff(fact_81_evaln__elim__cases_I4_J,axiom,
    ! [T: state,N4: nat,S: state,C2: com,C1: com] :
      ( evaln(semi(C1,C2),S,N4,T)
     => ~ ! [S11: state] :
            ( evaln(C1,S,N4,S11)
           => ~ evaln(C2,S11,N4,T) ) ) ).

tff(fact_82_evalc__evaln,axiom,
    ! [T: state,S: state,C3: com] :
      ( evalc(C3,S,T)
     => ? [N: nat] : evaln(C3,S,N,T) ) ).

tff(fact_83_fold1Set__sing,axiom,
    ! [B: $tType,B1: B,A5: B,F: fun(B,fun(B,B))] :
      ( finite_fold1Set(B,F,insert(B,A5,bot_bot(fun(B,bool))),B1)
    <=> ( A5 = B1 ) ) ).

tff(fact_84_of__nat__aux_Osimps_I2_J,axiom,
    ! [B: $tType] :
      ( semiring_1(B)
     => ! [I: B,N3: nat,Inc: fun(B,B)] : ( semiri532925092at_aux(B,Inc,suc(N3),I) = semiri532925092at_aux(B,Inc,N3,aa(B,B,Inc,I)) ) ) ).

tff(fact_85_fold1Set__nonempty,axiom,
    ! [B: $tType,X3: B,A8: fun(B,bool),F: fun(B,fun(B,B))] :
      ( finite_fold1Set(B,F,A8,X3)
     => ( A8 != bot_bot(fun(B,bool)) ) ) ).

tff(fact_86_empty__fold1SetE,axiom,
    ! [B: $tType,X3: B,F: fun(B,fun(B,B))] : ~ finite_fold1Set(B,F,bot_bot(fun(B,bool)),X3) ).

tff(fact_87_evaln__max2,axiom,
    ! [T2: state,N2: nat,S2: state,C2: com,T1: state,N1: nat,S1: state,C1: com] :
      ( evaln(C1,S1,N1,T1)
     => ( evaln(C2,S2,N2,T2)
       => ? [N: nat] :
            ( evaln(C1,S1,N,T1)
            & evaln(C2,S2,N,T2) ) ) ) ).

tff(fact_88_fold1Set_Ointros,axiom,
    ! [B: $tType,X3: B,A8: fun(B,bool),A5: B,F: fun(B,fun(B,B))] :
      ( finite_fold_graph(B,B,F,A5,A8,X3)
     => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A5),A8))
       => finite_fold1Set(B,F,insert(B,A5,A8),X3) ) ) ).

tff(fact_89_fold__graph_OemptyI,axiom,
    ! [B: $tType,C: $tType,Z: C,F: fun(B,fun(C,C))] : finite_fold_graph(B,C,F,Z,bot_bot(fun(B,bool)),Z) ).

tff(fact_90_empty__fold__graphE,axiom,
    ! [B: $tType,C: $tType,X3: C,Z: C,F: fun(B,fun(C,C))] :
      ( finite_fold_graph(B,C,F,Z,bot_bot(fun(B,bool)),X3)
     => ( X3 = Z ) ) ).

tff(fact_91_fold__graph_OinsertI,axiom,
    ! [B: $tType,C: $tType,Y2: C,Z: C,F: fun(B,fun(C,C)),A8: fun(B,bool),X3: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A8))
     => ( finite_fold_graph(B,C,F,Z,A8,Y2)
       => finite_fold_graph(B,C,F,Z,insert(B,X3,A8),aa(C,C,aa(B,fun(C,C),F,X3),Y2)) ) ) ).

tff(fact_92_insert__fold1SetE,axiom,
    ! [B: $tType,X3: B,X2: fun(B,bool),A5: B,F: fun(B,fun(B,B))] :
      ( finite_fold1Set(B,F,insert(B,A5,X2),X3)
     => ~ ! [A7: B,A6: fun(B,bool)] :
            ( ( insert(B,A5,X2) = insert(B,A7,A6) )
           => ( finite_fold_graph(B,B,F,A7,A6,X3)
             => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A7),A6)) ) ) ) ).

tff(fact_93_fold1Set_Osimps,axiom,
    ! [B: $tType,A2: B,A1: fun(B,bool),F: fun(B,fun(B,B))] :
      ( finite_fold1Set(B,F,A1,A2)
    <=> ? [A4: B,A3: fun(B,bool),X1: B] :
          ( ( A1 = insert(B,A4,A3) )
          & ( A2 = X1 )
          & finite_fold_graph(B,B,F,A4,A3,X1)
          & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A4),A3)) ) ) ).

tff(fact_94_fold__graph_Osimps,axiom,
    ! [B: $tType,C: $tType,A2: C,A1: fun(B,bool),Z: C,F: fun(B,fun(C,C))] :
      ( finite_fold_graph(B,C,F,Z,A1,A2)
    <=> ( ( ( A1 = bot_bot(fun(B,bool)) )
          & ( A2 = Z ) )
        | ? [X1: B,A3: fun(B,bool),Y1: C] :
            ( ( A1 = insert(B,X1,A3) )
            & ( A2 = aa(C,C,aa(B,fun(C,C),F,X1),Y1) )
            & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),A3))
            & finite_fold_graph(B,C,F,Z,A3,Y1) ) ) ) ).

tff(fact_95_Body__triple__valid__0,axiom,
    ! [B: $tType,Qa: fun(B,fun(state,bool)),Pna: pname,Pa: fun(B,fun(state,bool))] : hoare_1633586161_valid(B,zero_zero(nat),hoare_1841697145triple(B,Pa,body(Pna),Qa)) ).

tff(fact_96_of__nat__aux_Osimps_I1_J,axiom,
    ! [B: $tType] :
      ( semiring_1(B)
     => ! [I: B,Inc: fun(B,B)] : ( semiri532925092at_aux(B,Inc,zero_zero(nat),I) = I ) ) ).

tff(fact_97_Suc__neq__Zero,axiom,
    ! [M: nat] : ( suc(M) != zero_zero(nat) ) ).

tff(fact_98_Zero__neq__Suc,axiom,
    ! [M: nat] : ( zero_zero(nat) != suc(M) ) ).

%----Arities (4)
tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Orderings_Obot,axiom,
    bot(nat) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (18)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    hoare_992312373derivs(a,insert(hoare_28830079triple(a),hoare_1841697145triple(a,p,body(pn),q),g),insert(hoare_28830079triple(a),hoare_1841697145triple(a,p,the(com,body1(pn)),q),bot_bot(fun(hoare_28830079triple(a),bool)))) ).

tff(conj_1,conjecture,
    hoare_992312373derivs(a,g,insert(hoare_28830079triple(a),hoare_1841697145triple(a,p,body(pn),q),bot_bot(fun(hoare_28830079triple(a),bool)))) ).

%------------------------------------------------------------------------------
