%------------------------------------------------------------------------------
% File     : SWW508_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Hoare's Logic with Procedures line 159
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : hoare_159 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.50 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  180 (  43 unt;  50 typ;   0 def)
%            Number of atoms       :  302 ( 107 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  237 (  65   ~;  24   |;  27   &)
%                                         (  24 <=>;  97  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   17 (   6 avg)
%            Maximal term depth    :    8 (   2 avg)
%            Number of types       :    9 (   8 usr)
%            Number of type conns  :   57 (  25   >;  32   *;   0   +;   0  <<)
%            Number of predicates  :   13 (  12 usr;   0 prp; 1-6 aty)
%            Number of functors    :   30 (  30 usr;  11 con; 0-10 aty)
%            Number of variables   :  501 ( 445   !;  19   ?; 501   :)
%                                         (  37  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:44
%------------------------------------------------------------------------------
%----Should-be-implicit typings (10)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_Com_Ocom,type,
    com: $tType ).

tff(ty_tc_Com_Oloc,type,
    loc: $tType ).

tff(ty_tc_Com_Opname,type,
    pname: $tType ).

tff(ty_tc_Com_Ostate,type,
    state: $tType ).

tff(ty_tc_Com_Ovname,type,
    vname: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Hoare__Mirabelle__vtrypsmcwp_Otriple,type,
    hoare_28830079triple: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (40)
tff(sy_cl_Groups_Ominus,type,
    cl_Groups_Ominus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Finite__Set_Ofinite,type,
    finite_finite: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Com_Ocom_OSKIP,type,
    skip: com ).

tff(sy_c_Com_Ocom_OSemi,type,
    semi: ( com * com ) > com ).

tff(sy_c_Com_Ocom_Ocom__case,type,
    com_case: 
      !>[T1: $tType] : ( ( T1 * fun(vname,fun(fun(state,nat),T1)) * fun(loc,fun(fun(state,nat),fun(com,T1))) * fun(com,fun(com,T1)) * fun(fun(state,bool),fun(com,fun(com,T1))) * fun(fun(state,bool),fun(com,T1)) * fun(pname,T1) * fun(vname,fun(pname,fun(fun(state,nat),T1))) * com ) > T1 ) ).

tff(sy_c_Finite__Set_Ofinite,type,
    finite_finite1: 
      !>[A: $tType] : ( fun(A,bool) > $o ) ).

tff(sy_c_Finite__Set_Ofold1Set,type,
    finite_fold1Set: 
      !>[A: $tType] : ( ( fun(A,fun(A,A)) * fun(A,bool) * A ) > $o ) ).

tff(sy_c_Finite__Set_Ofold__graph,type,
    finite_fold_graph: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(B,B)) * B * fun(A,bool) * B ) > $o ) ).

tff(sy_c_Finite__Set_Ofolding__one,type,
    finite_folding_one: 
      !>[A: $tType] : ( ( fun(A,fun(A,A)) * fun(fun(A,bool),A) ) > $o ) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Ohoare__derivs,type,
    hoare_992312373derivs: 
      !>[A: $tType] : ( ( fun(hoare_28830079triple(A),bool) * fun(hoare_28830079triple(A),bool) ) > $o ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple,type,
    hoare_1841697145triple: 
      !>[A: $tType] : ( ( fun(A,fun(state,bool)) * com * fun(A,fun(state,bool)) ) > hoare_28830079triple(A) ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__case,type,
    hoare_376461865e_case: 
      !>[A: $tType,T1: $tType] : ( ( fun(fun(A,fun(state,bool)),fun(com,fun(fun(A,fun(state,bool)),T1))) * hoare_28830079triple(A) ) > T1 ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__rec,type,
    hoare_678420151le_rec: 
      !>[A: $tType,T1: $tType] : ( ( fun(fun(A,fun(state,bool)),fun(com,fun(fun(A,fun(state,bool)),T1))) * hoare_28830079triple(A) ) > T1 ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Predicate_Oinv__imagep,type,
    inv_imagep: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(B,bool)) * fun(A,B) * A * A ) > $o ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_G,type,
    g: fun(hoare_28830079triple(a),bool) ).

tff(sy_v_P,type,
    p: ( a * state ) > $o ).

tff(sy_v_P_H,type,
    p1: fun(a,fun(state,bool)) ).

tff(sy_v_Q,type,
    q: ( a * state ) > $o ).

tff(sy_v_Q_H,type,
    q1: fun(a,fun(state,bool)) ).

tff(sy_v_c,type,
    c: com ).

%----Relevant facts (100)
tff(fact_0_triple_Oinject,axiom,
    ! [B: $tType,Fun22: fun(B,fun(state,bool)),Com4: com,Fun12: fun(B,fun(state,bool)),Fun21: fun(B,fun(state,bool)),Com3: com,Fun11: fun(B,fun(state,bool))] :
      ( ( hoare_1841697145triple(B,Fun11,Com3,Fun21) = hoare_1841697145triple(B,Fun12,Com4,Fun22) )
    <=> ( ( Fun11 = Fun12 )
        & ( Com3 = Com4 )
        & ( Fun21 = Fun22 ) ) ) ).

tff(fact_1_empty,axiom,
    ! [B: $tType,Ga: fun(hoare_28830079triple(B),bool)] : hoare_992312373derivs(B,Ga,bot_bot(fun(hoare_28830079triple(B),bool))) ).

tff(fact_2_cut,axiom,
    ! [B: $tType,Ga: fun(hoare_28830079triple(B),bool),Ts: fun(hoare_28830079triple(B),bool),G1: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,G1,Ts)
     => ( hoare_992312373derivs(B,Ga,G1)
       => hoare_992312373derivs(B,Ga,Ts) ) ) ).

tff(fact_3_hoare__derivs_Oinsert,axiom,
    ! [B: $tType,Ts: fun(hoare_28830079triple(B),bool),T: hoare_28830079triple(B),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),T,bot_bot(fun(hoare_28830079triple(B),bool))))
     => ( hoare_992312373derivs(B,Ga,Ts)
       => hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),T,Ts)) ) ) ).

tff(fact_4_insert__absorb2,axiom,
    ! [B: $tType,A4: fun(B,bool),X2: B] : ( insert(B,X2,insert(B,X2,A4)) = insert(B,X2,A4) ) ).

tff(fact_5_insert__iff,axiom,
    ! [B: $tType,A4: fun(B,bool),B2: B,A1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),insert(B,B2,A4)))
    <=> ( ( A1 = B2 )
        | pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),A4)) ) ) ).

tff(fact_6_insertE,axiom,
    ! [B: $tType,A4: fun(B,bool),B2: B,A1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),insert(B,B2,A4)))
     => ( ( A1 != B2 )
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),A4)) ) ) ).

tff(fact_7_insertCI,axiom,
    ! [B: $tType,B2: B,B1: fun(B,bool),A1: B] :
      ( ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),B1))
       => ( A1 = B2 ) )
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),insert(B,B2,B1))) ) ).

tff(fact_8_all__not__in__conv,axiom,
    ! [B: $tType,A4: fun(B,bool)] :
      ( ! [X3: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A4))
    <=> ( A4 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_9_empty__Collect__eq,axiom,
    ! [B: $tType,Pa: fun(B,bool)] :
      ( ( bot_bot(fun(B,bool)) = collect(B,Pa) )
    <=> ! [X3: B] : ~ pp(aa(B,bool,Pa,X3)) ) ).

tff(fact_10_empty__iff,axiom,
    ! [B: $tType,Ca: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ca),bot_bot(fun(B,bool)))) ).

tff(fact_11_Collect__empty__eq,axiom,
    ! [B: $tType,Pa: fun(B,bool)] :
      ( ( collect(B,Pa) = bot_bot(fun(B,bool)) )
    <=> ! [X3: B] : ~ pp(aa(B,bool,Pa,X3)) ) ).

tff(fact_12_emptyE,axiom,
    ! [B: $tType,A1: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),bot_bot(fun(B,bool)))) ).

tff(fact_13_triple_Orecs,axiom,
    ! [B: $tType,C: $tType,Fun21: fun(C,fun(state,bool)),Com3: com,Fun11: fun(C,fun(state,bool)),F11: fun(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)))] : ( hoare_678420151le_rec(C,B,F11,hoare_1841697145triple(C,Fun11,Com3,Fun21)) = aa(fun(C,fun(state,bool)),B,aa(com,fun(fun(C,fun(state,bool)),B),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)),F11,Fun11),Com3),Fun21) ) ).

tff(fact_14_triple_Osimps_I2_J,axiom,
    ! [B: $tType,C: $tType,Fun21: fun(C,fun(state,bool)),Com3: com,Fun11: fun(C,fun(state,bool)),F11: fun(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)))] : ( hoare_376461865e_case(C,B,F11,hoare_1841697145triple(C,Fun11,Com3,Fun21)) = aa(fun(C,fun(state,bool)),B,aa(com,fun(fun(C,fun(state,bool)),B),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)),F11,Fun11),Com3),Fun21) ) ).

tff(fact_15_empty__not__insert,axiom,
    ! [B: $tType,A4: fun(B,bool),A1: B] : ( bot_bot(fun(B,bool)) != insert(B,A1,A4) ) ).

tff(fact_16_equals0D,axiom,
    ! [B: $tType,A1: B,A4: fun(B,bool)] :
      ( ( A4 = bot_bot(fun(B,bool)) )
     => ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),A4)) ) ).

tff(fact_17_ex__in__conv,axiom,
    ! [B: $tType,A4: fun(B,bool)] :
      ( ? [X3: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A4))
    <=> ( A4 != bot_bot(fun(B,bool)) ) ) ).

tff(fact_18_empty__def,axiom,
    ! [B: $tType] : ( bot_bot(fun(B,bool)) = collect(B,combk(bool,B,fFalse)) ) ).

tff(fact_19_insert__absorb,axiom,
    ! [B: $tType,A4: fun(B,bool),A1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),A4))
     => ( insert(B,A1,A4) = A4 ) ) ).

tff(fact_20_insertI2,axiom,
    ! [B: $tType,B2: B,B1: fun(B,bool),A1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),B1))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),insert(B,B2,B1))) ) ).

tff(fact_21_insert__eq__iff,axiom,
    ! [B: $tType,B1: fun(B,bool),B2: B,A4: fun(B,bool),A1: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),A4))
     => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B2),B1))
       => ( ( insert(B,A1,A4) = insert(B,B2,B1) )
        <=> ( ( ( A1 = B2 )
             => ( A4 = B1 ) )
            & ( ( A1 != B2 )
             => ? [C1: fun(B,bool)] :
                  ( ( A4 = insert(B,B2,C1) )
                  & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B2),C1))
                  & ( B1 = insert(B,A1,C1) )
                  & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),C1)) ) ) ) ) ) ) ).

tff(fact_22_insert__ident,axiom,
    ! [B: $tType,B1: fun(B,bool),A4: fun(B,bool),X2: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A4))
     => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),B1))
       => ( ( insert(B,X2,A4) = insert(B,X2,B1) )
        <=> ( A4 = B1 ) ) ) ) ).

tff(fact_23_insert__code,axiom,
    ! [B: $tType,X2: B,A4: fun(B,bool),Y3: B] :
      ( pp(aa(B,bool,insert(B,Y3,A4),X2))
    <=> ( ( Y3 = X2 )
        | pp(aa(B,bool,A4,X2)) ) ) ).

tff(fact_24_insert__commute,axiom,
    ! [B: $tType,A4: fun(B,bool),Y3: B,X2: B] : ( insert(B,X2,insert(B,Y3,A4)) = insert(B,Y3,insert(B,X2,A4)) ) ).

tff(fact_25_insert__Collect,axiom,
    ! [B: $tType,Pa: fun(B,bool),A1: B] : ( insert(B,A1,collect(B,Pa)) = collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fimplies,combb(bool,bool,B,fNot,combc(B,B,bool,fequal(B),A1))),Pa)) ) ).

tff(fact_26_insert__compr,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: B] : ( insert(B,A1,B1) = collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fdisj,combc(B,B,bool,fequal(B),A1)),combc(B,fun(B,bool),bool,member(B),B1))) ) ).

tff(fact_27_insertI1,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),insert(B,A1,B1))) ).

tff(fact_28_singleton__inject,axiom,
    ! [B: $tType,B2: B,A1: B] :
      ( ( insert(B,A1,bot_bot(fun(B,bool))) = insert(B,B2,bot_bot(fun(B,bool))) )
     => ( A1 = B2 ) ) ).

tff(fact_29_singletonE,axiom,
    ! [B: $tType,A1: B,B2: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B2),insert(B,A1,bot_bot(fun(B,bool)))))
     => ( B2 = A1 ) ) ).

tff(fact_30_doubleton__eq__iff,axiom,
    ! [B: $tType,D: B,Ca: B,B2: B,A1: B] :
      ( ( insert(B,A1,insert(B,B2,bot_bot(fun(B,bool)))) = insert(B,Ca,insert(B,D,bot_bot(fun(B,bool)))) )
    <=> ( ( ( A1 = Ca )
          & ( B2 = D ) )
        | ( ( A1 = D )
          & ( B2 = Ca ) ) ) ) ).

tff(fact_31_singleton__iff,axiom,
    ! [B: $tType,A1: B,B2: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B2),insert(B,A1,bot_bot(fun(B,bool)))))
    <=> ( B2 = A1 ) ) ).

tff(fact_32_insert__not__empty,axiom,
    ! [B: $tType,A4: fun(B,bool),A1: B] : ( insert(B,A1,A4) != bot_bot(fun(B,bool)) ) ).

tff(fact_33_the__elem__eq,axiom,
    ! [B: $tType,X2: B] : ( the_elem(B,insert(B,X2,bot_bot(fun(B,bool)))) = X2 ) ).

tff(fact_34_bot__apply,axiom,
    ! [C: $tType,B: $tType] :
      ( bot(B)
     => ! [X2: C] : ( aa(C,B,bot_bot(fun(C,B)),X2) = bot_bot(B) ) ) ).

tff(fact_35_bot__fun__def,axiom,
    ! [B: $tType,C: $tType] :
      ( bot(C)
     => ! [X4: B] : ( aa(B,C,bot_bot(fun(B,C)),X4) = bot_bot(C) ) ) ).

tff(fact_36_hoare__derivs_OSkip,axiom,
    ! [B: $tType,Pa: fun(B,fun(state,bool)),Ga: fun(hoare_28830079triple(B),bool)] : hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),hoare_1841697145triple(B,Pa,skip,Pa),bot_bot(fun(hoare_28830079triple(B),bool)))) ).

tff(fact_37_Comp,axiom,
    ! [B: $tType,R2: fun(B,fun(state,bool)),D: com,Qa: fun(B,fun(state,bool)),Ca: com,Pa: fun(B,fun(state,bool)),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),hoare_1841697145triple(B,Pa,Ca,Qa),bot_bot(fun(hoare_28830079triple(B),bool))))
     => ( hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),hoare_1841697145triple(B,Qa,D,R2),bot_bot(fun(hoare_28830079triple(B),bool))))
       => hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),hoare_1841697145triple(B,Pa,semi(Ca,D),R2),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ) ).

tff(fact_38_triple_Oexhaust,axiom,
    ! [B: $tType,Y3: hoare_28830079triple(B)] :
      ~ ! [Fun1: fun(B,fun(state,bool)),Com: com,Fun2: fun(B,fun(state,bool))] : ( Y3 != hoare_1841697145triple(B,Fun1,Com,Fun2) ) ).

tff(fact_39_Set_Oset__insert,axiom,
    ! [B: $tType,A4: fun(B,bool),X2: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A4))
     => ~ ! [B4: fun(B,bool)] :
            ( ( A4 = insert(B,X2,B4) )
           => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),B4)) ) ) ).

tff(fact_40_mk__disjoint__insert,axiom,
    ! [B: $tType,A4: fun(B,bool),A1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),A4))
     => ? [B4: fun(B,bool)] :
          ( ( A4 = insert(B,A1,B4) )
          & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),B4)) ) ) ).

tff(fact_41_com_Osimps_I3_J,axiom,
    ! [Com22: com,Com12: com,Com2: com,Com1: com] :
      ( ( semi(Com1,Com2) = semi(Com12,Com22) )
    <=> ( ( Com1 = Com12 )
        & ( Com2 = Com22 ) ) ) ).

tff(fact_42_com_Osimps_I13_J,axiom,
    ! [Com21: com,Com11: com] : ( semi(Com11,Com21) != skip ) ).

tff(fact_43_com_Osimps_I12_J,axiom,
    ! [Com21: com,Com11: com] : ( skip != semi(Com11,Com21) ) ).

tff(fact_44_equals0I,axiom,
    ! [B: $tType,A4: fun(B,bool)] :
      ( ! [Y1: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Y1),A4))
     => ( A4 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_45_conseq,axiom,
    ! [B: $tType,Qa: fun(B,fun(state,bool)),Ca: com,Ga: fun(hoare_28830079triple(B),bool),Pa: fun(B,fun(state,bool))] :
      ( ! [Z: B,S: state] :
          ( pp(aa(state,bool,aa(B,fun(state,bool),Pa,Z),S))
         => ? [P: fun(B,fun(state,bool)),Q: fun(B,fun(state,bool))] :
              ( hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),hoare_1841697145triple(B,P,Ca,Q),bot_bot(fun(hoare_28830079triple(B),bool))))
              & ! [S1: state] :
                  ( ! [Z1: B] :
                      ( pp(aa(state,bool,aa(B,fun(state,bool),P,Z1),S))
                     => pp(aa(state,bool,aa(B,fun(state,bool),Q,Z1),S1)) )
                 => pp(aa(state,bool,aa(B,fun(state,bool),Qa,Z),S1)) ) ) )
     => hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),hoare_1841697145triple(B,Pa,Ca,Qa),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ).

tff(fact_46_nonempty__iff,axiom,
    ! [B: $tType,A4: fun(B,bool)] :
      ( ( A4 != bot_bot(fun(B,bool)) )
    <=> ? [X3: B,B3: fun(B,bool)] :
          ( ( A4 = insert(B,X3,B3) )
          & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),B3)) ) ) ).

tff(fact_47_bot__empty__eq,axiom,
    ! [B: $tType,X4: B] :
      ( pp(aa(B,bool,bot_bot(fun(B,bool)),X4))
    <=> pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),bot_bot(fun(B,bool)))) ) ).

tff(fact_48_fold1Set__sing,axiom,
    ! [B: $tType,B2: B,A1: B,F2: fun(B,fun(B,B))] :
      ( finite_fold1Set(B,F2,insert(B,A1,bot_bot(fun(B,bool))),B2)
    <=> ( A1 = B2 ) ) ).

tff(fact_49_com_Osimps_I64_J,axiom,
    ! [B: $tType,F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com,B)),F5: fun(fun(state,bool),fun(com,fun(com,B))),F4: fun(com,fun(com,B)),F3: fun(loc,fun(fun(state,nat),fun(com,B))),F21: fun(vname,fun(fun(state,nat),B)),F11: B] : ( com_case(B,F11,F21,F3,F4,F5,F6,F7,F8,skip) = F11 ) ).

tff(fact_50_fold1Set__nonempty,axiom,
    ! [B: $tType,X2: B,A4: fun(B,bool),F2: fun(B,fun(B,B))] :
      ( finite_fold1Set(B,F2,A4,X2)
     => ( A4 != bot_bot(fun(B,bool)) ) ) ).

tff(fact_51_empty__fold1SetE,axiom,
    ! [B: $tType,X2: B,F2: fun(B,fun(B,B))] : ~ finite_fold1Set(B,F2,bot_bot(fun(B,bool)),X2) ).

tff(fact_52_com_Osimps_I67_J,axiom,
    ! [B: $tType,Com2: com,Com1: com,F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com,B)),F5: fun(fun(state,bool),fun(com,fun(com,B))),F4: fun(com,fun(com,B)),F3: fun(loc,fun(fun(state,nat),fun(com,B))),F21: fun(vname,fun(fun(state,nat),B)),F11: B] : ( com_case(B,F11,F21,F3,F4,F5,F6,F7,F8,semi(Com1,Com2)) = aa(com,B,aa(com,fun(com,B),F4,Com1),Com2) ) ).

tff(fact_53_fold1Set_Ointros,axiom,
    ! [B: $tType,X2: B,A4: fun(B,bool),A1: B,F2: fun(B,fun(B,B))] :
      ( finite_fold_graph(B,B,F2,A1,A4,X2)
     => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),A4))
       => finite_fold1Set(B,F2,insert(B,A1,A4),X2) ) ) ).

tff(fact_54_folding__one_Osingleton,axiom,
    ! [B: $tType,X2: B,F: fun(fun(B,bool),B),F2: fun(B,fun(B,B))] :
      ( finite_folding_one(B,F2,F)
     => ( aa(fun(B,bool),B,F,insert(B,X2,bot_bot(fun(B,bool)))) = X2 ) ) ).

tff(fact_55_in__inv__imagep,axiom,
    ! [B: $tType,C: $tType,Y3: C,X2: C,F2: fun(C,B),R1: fun(B,fun(B,bool))] :
      ( inv_imagep(B,C,R1,F2,X2,Y3)
    <=> pp(aa(B,bool,aa(B,fun(B,bool),R1,aa(C,B,F2,X2)),aa(C,B,F2,Y3))) ) ).

tff(fact_56_insert__Diff__single,axiom,
    ! [B: $tType,A4: fun(B,bool),A1: B] : ( insert(B,A1,minus_minus(fun(B,bool),A4,insert(B,A1,bot_bot(fun(B,bool))))) = insert(B,A1,A4) ) ).

tff(fact_57_DiffE,axiom,
    ! [B: $tType,B1: fun(B,bool),A4: fun(B,bool),Ca: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ca),minus_minus(fun(B,bool),A4,B1)))
     => ~ ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ca),A4))
         => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ca),B1)) ) ) ).

tff(fact_58_DiffI,axiom,
    ! [B: $tType,B1: fun(B,bool),A4: fun(B,bool),Ca: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ca),A4))
     => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ca),B1))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ca),minus_minus(fun(B,bool),A4,B1))) ) ) ).

tff(fact_59_Diff__idemp,axiom,
    ! [B: $tType,B1: fun(B,bool),A4: fun(B,bool)] : ( minus_minus(fun(B,bool),minus_minus(fun(B,bool),A4,B1),B1) = minus_minus(fun(B,bool),A4,B1) ) ).

tff(fact_60_Diff__iff,axiom,
    ! [B: $tType,B1: fun(B,bool),A4: fun(B,bool),Ca: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ca),minus_minus(fun(B,bool),A4,B1)))
    <=> ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ca),A4))
        & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ca),B1)) ) ) ).

tff(fact_61_empty__Diff,axiom,
    ! [B: $tType,A4: fun(B,bool)] : ( minus_minus(fun(B,bool),bot_bot(fun(B,bool)),A4) = bot_bot(fun(B,bool)) ) ).

tff(fact_62_Diff__cancel,axiom,
    ! [B: $tType,A4: fun(B,bool)] : ( minus_minus(fun(B,bool),A4,A4) = bot_bot(fun(B,bool)) ) ).

tff(fact_63_Diff__empty,axiom,
    ! [B: $tType,A4: fun(B,bool)] : ( minus_minus(fun(B,bool),A4,bot_bot(fun(B,bool))) = A4 ) ).

tff(fact_64_insert__Diff__if,axiom,
    ! [B: $tType,A4: fun(B,bool),B1: fun(B,bool),X2: B] :
      ( ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),B1))
       => ( minus_minus(fun(B,bool),insert(B,X2,A4),B1) = minus_minus(fun(B,bool),A4,B1) ) )
      & ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),B1))
       => ( minus_minus(fun(B,bool),insert(B,X2,A4),B1) = insert(B,X2,minus_minus(fun(B,bool),A4,B1)) ) ) ) ).

tff(fact_65_insert__Diff1,axiom,
    ! [B: $tType,A4: fun(B,bool),B1: fun(B,bool),X2: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),B1))
     => ( minus_minus(fun(B,bool),insert(B,X2,A4),B1) = minus_minus(fun(B,bool),A4,B1) ) ) ).

tff(fact_66_DiffD2,axiom,
    ! [B: $tType,B1: fun(B,bool),A4: fun(B,bool),Ca: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ca),minus_minus(fun(B,bool),A4,B1)))
     => ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ca),B1)) ) ).

tff(fact_67_DiffD1,axiom,
    ! [B: $tType,B1: fun(B,bool),A4: fun(B,bool),Ca: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ca),minus_minus(fun(B,bool),A4,B1)))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Ca),A4)) ) ).

tff(fact_68_set__diff__eq,axiom,
    ! [B: $tType,B1: fun(B,bool),A4: fun(B,bool)] : ( minus_minus(fun(B,bool),A4,B1) = collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,combc(B,fun(B,bool),bool,member(B),A4)),combb(bool,bool,B,fNot,combc(B,fun(B,bool),bool,member(B),B1)))) ) ).

tff(fact_69_fold__graph_OemptyI,axiom,
    ! [B: $tType,C: $tType,Z4: C,F2: fun(B,fun(C,C))] : finite_fold_graph(B,C,F2,Z4,bot_bot(fun(B,bool)),Z4) ).

tff(fact_70_empty__fold__graphE,axiom,
    ! [B: $tType,C: $tType,X2: C,Z4: C,F2: fun(B,fun(C,C))] :
      ( finite_fold_graph(B,C,F2,Z4,bot_bot(fun(B,bool)),X2)
     => ( X2 = Z4 ) ) ).

tff(fact_71_fold__graph_OinsertI,axiom,
    ! [B: $tType,C: $tType,Y3: C,Z4: C,F2: fun(B,fun(C,C)),A4: fun(B,bool),X2: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A4))
     => ( finite_fold_graph(B,C,F2,Z4,A4,Y3)
       => finite_fold_graph(B,C,F2,Z4,insert(B,X2,A4),aa(C,C,aa(B,fun(C,C),F2,X2),Y3)) ) ) ).

tff(fact_72_insert__Diff,axiom,
    ! [B: $tType,A4: fun(B,bool),A1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),A4))
     => ( insert(B,A1,minus_minus(fun(B,bool),A4,insert(B,A1,bot_bot(fun(B,bool))))) = A4 ) ) ).

tff(fact_73_Diff__insert__absorb,axiom,
    ! [B: $tType,A4: fun(B,bool),X2: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A4))
     => ( minus_minus(fun(B,bool),insert(B,X2,A4),insert(B,X2,bot_bot(fun(B,bool)))) = A4 ) ) ).

tff(fact_74_Diff__insert2,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: B,A4: fun(B,bool)] : ( minus_minus(fun(B,bool),A4,insert(B,A1,B1)) = minus_minus(fun(B,bool),minus_minus(fun(B,bool),A4,insert(B,A1,bot_bot(fun(B,bool)))),B1) ) ).

tff(fact_75_ext,axiom,
    ! [C: $tType,B: $tType,G: fun(B,C),F2: fun(B,C)] :
      ( ! [X1: B] : ( aa(B,C,F2,X1) = aa(B,C,G,X1) )
     => ( F2 = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [B: $tType,A4: fun(B,bool),X2: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A4))
    <=> pp(aa(B,bool,A4,X2)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [B: $tType,Pa: fun(B,bool)] : ( collect(B,Pa) = Pa ) ).

tff(fact_78_Diff__insert,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: B,A4: fun(B,bool)] : ( minus_minus(fun(B,bool),A4,insert(B,A1,B1)) = minus_minus(fun(B,bool),minus_minus(fun(B,bool),A4,B1),insert(B,A1,bot_bot(fun(B,bool)))) ) ).

tff(fact_79_insert__fold1SetE,axiom,
    ! [B: $tType,X2: B,X5: fun(B,bool),A1: B,F2: fun(B,fun(B,B))] :
      ( finite_fold1Set(B,F2,insert(B,A1,X5),X2)
     => ~ ! [A6: B,A5: fun(B,bool)] :
            ( ( insert(B,A1,X5) = insert(B,A6,A5) )
           => ( finite_fold_graph(B,B,F2,A6,A5,X2)
             => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A6),A5)) ) ) ) ).

tff(fact_80_fold1Set_Osimps,axiom,
    ! [B: $tType,A21: B,A11: fun(B,bool),F2: fun(B,fun(B,B))] :
      ( finite_fold1Set(B,F2,A11,A21)
    <=> ? [A2: B,A3: fun(B,bool),X3: B] :
          ( ( A11 = insert(B,A2,A3) )
          & ( A21 = X3 )
          & finite_fold_graph(B,B,F2,A2,A3,X3)
          & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A2),A3)) ) ) ).

tff(fact_81_fun__diff__def,axiom,
    ! [C: $tType,B: $tType] :
      ( cl_Groups_Ominus(C)
     => ! [B1: fun(B,C),A4: fun(B,C),X4: B] : ( aa(B,C,minus_minus(fun(B,C),A4,B1),X4) = minus_minus(C,aa(B,C,A4,X4),aa(B,C,B1,X4)) ) ) ).

tff(fact_82_minus__apply,axiom,
    ! [B: $tType,C: $tType] :
      ( cl_Groups_Ominus(B)
     => ! [X2: C,B1: fun(C,B),A4: fun(C,B)] : ( aa(C,B,minus_minus(fun(C,B),A4,B1),X2) = minus_minus(B,aa(C,B,A4,X2),aa(C,B,B1,X2)) ) ) ).

tff(fact_83_fold__graph_Osimps,axiom,
    ! [B: $tType,C: $tType,A21: C,A11: fun(B,bool),Z4: C,F2: fun(B,fun(C,C))] :
      ( finite_fold_graph(B,C,F2,Z4,A11,A21)
    <=> ( ( ( A11 = bot_bot(fun(B,bool)) )
          & ( A21 = Z4 ) )
        | ? [X3: B,A3: fun(B,bool),Y2: C] :
            ( ( A11 = insert(B,X3,A3) )
            & ( A21 = aa(C,C,aa(B,fun(C,C),F2,X3),Y2) )
            & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A3))
            & finite_fold_graph(B,C,F2,Z4,A3,Y2) ) ) ) ).

tff(fact_84_folding__one_Oremove,axiom,
    ! [B: $tType,X2: B,A4: fun(B,bool),F: fun(fun(B,bool),B),F2: fun(B,fun(B,B))] :
      ( finite_folding_one(B,F2,F)
     => ( finite_finite1(B,A4)
       => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A4))
         => ( ( ( minus_minus(fun(B,bool),A4,insert(B,X2,bot_bot(fun(B,bool)))) = bot_bot(fun(B,bool)) )
             => ( aa(fun(B,bool),B,F,A4) = X2 ) )
            & ( ( minus_minus(fun(B,bool),A4,insert(B,X2,bot_bot(fun(B,bool)))) != bot_bot(fun(B,bool)) )
             => ( aa(fun(B,bool),B,F,A4) = aa(B,B,aa(B,fun(B,B),F2,X2),aa(fun(B,bool),B,F,minus_minus(fun(B,bool),A4,insert(B,X2,bot_bot(fun(B,bool)))))) ) ) ) ) ) ) ).

tff(fact_85_finite__code,axiom,
    ! [B: $tType] :
      ( finite_finite(B)
     => ! [A4: fun(B,bool)] : finite_finite1(B,A4) ) ).

tff(fact_86_finite_OemptyI,axiom,
    ! [B: $tType] : finite_finite1(B,bot_bot(fun(B,bool))) ).

tff(fact_87_finite_OinsertI,axiom,
    ! [B: $tType,A1: B,A4: fun(B,bool)] :
      ( finite_finite1(B,A4)
     => finite_finite1(B,insert(B,A1,A4)) ) ).

tff(fact_88_finite__insert,axiom,
    ! [B: $tType,A4: fun(B,bool),A1: B] :
      ( finite_finite1(B,insert(B,A1,A4))
    <=> finite_finite1(B,A4) ) ).

tff(fact_89_finite__Diff,axiom,
    ! [B: $tType,B1: fun(B,bool),A4: fun(B,bool)] :
      ( finite_finite1(B,A4)
     => finite_finite1(B,minus_minus(fun(B,bool),A4,B1)) ) ).

tff(fact_90_finite__Diff__insert,axiom,
    ! [B: $tType,B1: fun(B,bool),A1: B,A4: fun(B,bool)] :
      ( finite_finite1(B,minus_minus(fun(B,bool),A4,insert(B,A1,B1)))
    <=> finite_finite1(B,minus_minus(fun(B,bool),A4,B1)) ) ).

tff(fact_91_finite__Diff2,axiom,
    ! [B: $tType,A4: fun(B,bool),B1: fun(B,bool)] :
      ( finite_finite1(B,B1)
     => ( finite_finite1(B,minus_minus(fun(B,bool),A4,B1))
      <=> finite_finite1(B,A4) ) ) ).

tff(fact_92_finite,axiom,
    ! [B: $tType] :
      ( finite_finite(B)
     => ! [A4: fun(B,bool)] : finite_finite1(B,A4) ) ).

tff(fact_93_folding__one_Oinsert,axiom,
    ! [B: $tType,X2: B,A4: fun(B,bool),F: fun(fun(B,bool),B),F2: fun(B,fun(B,B))] :
      ( finite_folding_one(B,F2,F)
     => ( finite_finite1(B,A4)
       => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A4))
         => ( ( A4 != bot_bot(fun(B,bool)) )
           => ( aa(fun(B,bool),B,F,insert(B,X2,A4)) = aa(B,B,aa(B,fun(B,B),F2,X2),aa(fun(B,bool),B,F,A4)) ) ) ) ) ) ).

tff(fact_94_folding__one_Oinsert__remove,axiom,
    ! [B: $tType,X2: B,A4: fun(B,bool),F: fun(fun(B,bool),B),F2: fun(B,fun(B,B))] :
      ( finite_folding_one(B,F2,F)
     => ( finite_finite1(B,A4)
       => ( ( ( minus_minus(fun(B,bool),A4,insert(B,X2,bot_bot(fun(B,bool)))) = bot_bot(fun(B,bool)) )
           => ( aa(fun(B,bool),B,F,insert(B,X2,A4)) = X2 ) )
          & ( ( minus_minus(fun(B,bool),A4,insert(B,X2,bot_bot(fun(B,bool)))) != bot_bot(fun(B,bool)) )
           => ( aa(fun(B,bool),B,F,insert(B,X2,A4)) = aa(B,B,aa(B,fun(B,B),F2,X2),aa(fun(B,bool),B,F,minus_minus(fun(B,bool),A4,insert(B,X2,bot_bot(fun(B,bool)))))) ) ) ) ) ) ).

tff(fact_95_folding__one_Oclosed,axiom,
    ! [B: $tType,A4: fun(B,bool),F: fun(fun(B,bool),B),F2: fun(B,fun(B,B))] :
      ( finite_folding_one(B,F2,F)
     => ( finite_finite1(B,A4)
       => ( ( A4 != bot_bot(fun(B,bool)) )
         => ( ! [X1: B,Y1: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(B,B,aa(B,fun(B,B),F2,X1),Y1)),insert(B,X1,insert(B,Y1,bot_bot(fun(B,bool))))))
           => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(fun(B,bool),B,F,A4)),A4)) ) ) ) ) ).

tff(fact_96_finite__empty__induct,axiom,
    ! [B: $tType,Pa: fun(fun(B,bool),bool),A4: fun(B,bool)] :
      ( finite_finite1(B,A4)
     => ( pp(aa(fun(B,bool),bool,Pa,A4))
       => ( ! [A6: B,A5: fun(B,bool)] :
              ( finite_finite1(B,A5)
             => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A6),A5))
               => ( pp(aa(fun(B,bool),bool,Pa,A5))
                 => pp(aa(fun(B,bool),bool,Pa,minus_minus(fun(B,bool),A5,insert(B,A6,bot_bot(fun(B,bool)))))) ) ) )
         => pp(aa(fun(B,bool),bool,Pa,bot_bot(fun(B,bool)))) ) ) ) ).

tff(fact_97_finite__nonempty__imp__fold1Set,axiom,
    ! [B: $tType,F2: fun(B,fun(B,B)),A4: fun(B,bool)] :
      ( finite_finite1(B,A4)
     => ( ( A4 != bot_bot(fun(B,bool)) )
       => ? [X11: B] : finite_fold1Set(B,F2,A4,X11) ) ) ).

tff(fact_98_finite_Osimps,axiom,
    ! [B: $tType,A1: fun(B,bool)] :
      ( finite_finite1(B,A1)
    <=> ( ( A1 = bot_bot(fun(B,bool)) )
        | ? [A3: fun(B,bool),A2: B] :
            ( ( A1 = insert(B,A2,A3) )
            & finite_finite1(B,A3) ) ) ) ).

tff(fact_99_finite__induct,axiom,
    ! [B: $tType,Pa: fun(fun(B,bool),bool),F: fun(B,bool)] :
      ( finite_finite1(B,F)
     => ( pp(aa(fun(B,bool),bool,Pa,bot_bot(fun(B,bool))))
       => ( ! [X1: B,F1: fun(B,bool)] :
              ( finite_finite1(B,F1)
             => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),F1))
               => ( pp(aa(fun(B,bool),bool,Pa,F1))
                 => pp(aa(fun(B,bool),bool,Pa,insert(B,X1,F1))) ) ) )
         => pp(aa(fun(B,bool),bool,Pa,F)) ) ) ) ).

%----Arities (6)
tff(arity_fun___Finite__Set_Ofinite,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( finite_finite(T_2)
        & finite_finite(T_1) )
     => finite_finite(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_fun___Groups_Ominus,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( cl_Groups_Ominus(T_2)
     => cl_Groups_Ominus(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Finite__Set_Ofinite,axiom,
    finite_finite(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

tff(arity_HOL_Obool___Groups_Ominus,axiom,
    cl_Groups_Ominus(bool) ).

%----Helper facts (21)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P1: bool] :
      ( ~ pp(aa(bool,bool,fNot,P1))
      | ~ pp(P1) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P1: bool] :
      ( pp(P1)
      | pp(aa(bool,bool,fNot,P1)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q1: fun(A,B),P1: fun(B,C)] : ( aa(A,C,combb(B,C,A,P1,Q1),R) = aa(B,C,P1,aa(A,B,Q1,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q1: B,P1: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P1,Q1),R) = aa(B,C,aa(A,fun(B,C),P1,R),Q1) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q1: B,P1: A] : ( aa(B,A,combk(A,B,P1),Q1) = P1 ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q1: fun(A,B),P1: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P1,Q1),R) = aa(B,C,aa(A,fun(B,C),P1,R),aa(A,B,Q1,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q1: bool,P1: bool] :
      ( ~ pp(P1)
      | ~ pp(Q1)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P1),Q1)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q1: bool,P1: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P1),Q1))
      | pp(P1) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q1: bool,P1: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P1),Q1))
      | pp(Q1) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q1: bool,P1: bool] :
      ( ~ pp(P1)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P1),Q1)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P1: bool,Q1: bool] :
      ( ~ pp(Q1)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P1),Q1)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q1: bool,P1: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P1),Q1))
      | pp(P1)
      | pp(Q1) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P1: bool] :
      ( ( P1 = fTrue )
      | ( P1 = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q1: bool,P1: bool] :
      ( pp(P1)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P1),Q1)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P1: bool,Q1: bool] :
      ( ~ pp(Q1)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P1),Q1)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q1: bool,P1: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P1),Q1))
      | ~ pp(P1)
      | pp(Q1) ) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    hoare_992312373derivs(a,g,insert(hoare_28830079triple(a),hoare_1841697145triple(a,p1,c,q1),bot_bot(fun(hoare_28830079triple(a),bool)))) ).

tff(conj_1,hypothesis,
    ! [Z2: a,S2: state] :
      ( p(Z2,S2)
     => ! [S3: state] :
          ( ! [Z3: a] :
              ( pp(aa(state,bool,aa(a,fun(state,bool),p1,Z3),S2))
             => pp(aa(state,bool,aa(a,fun(state,bool),q1,Z3),S3)) )
         => q(Z2,S3) ) ) ).

tff(conj_2,conjecture,
    ! [Z: a,S: state] :
      ( ~ p(Z,S)
      | ? [P: fun(a,fun(state,bool)),Q: fun(a,fun(state,bool))] :
          ( hoare_992312373derivs(a,g,insert(hoare_28830079triple(a),hoare_1841697145triple(a,P,c,Q),bot_bot(fun(hoare_28830079triple(a),bool))))
          & ! [S1: state] :
              ( ? [Z1: a] :
                  ( pp(aa(state,bool,aa(a,fun(state,bool),P,Z1),S))
                  & ~ pp(aa(state,bool,aa(a,fun(state,bool),Q,Z1),S1)) )
              | q(Z,S1) ) ) ) ).

%------------------------------------------------------------------------------
