%------------------------------------------------------------------------------
% File     : SWW507_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Hoare's Logic with Procedures line 144
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : hoare_144 [Bla13]

% Status   : Theorem
% Rating   : 0.67 v9.1.0, 0.33 v7.4.0, 0.75 v7.3.0, 1.00 v6.4.0
% Syntax   : Number of formulae    :  155 (  69 unt;  47 typ;   0 def)
%            Number of atoms       :  179 (  95 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  131 (  60   ~;   6   |;  11   &)
%                                         (  10 <=>;  44  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   7 avg)
%            Maximal term depth    :   19 (   2 avg)
%            Number of types       :    9 (   8 usr)
%            Number of type conns  :   63 (  23   >;  40   *;   0   +;   0  <<)
%            Number of predicates  :    7 (   6 usr;   0 prp; 1-5 aty)
%            Number of functors    :   33 (  33 usr;   9 con; 0-10 aty)
%            Number of variables   :  511 ( 481   !;   1   ?; 511   :)
%                                         (  29  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:37
%------------------------------------------------------------------------------
%----Should-be-implicit typings (10)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_Com_Ocom,type,
    com1: $tType ).

tff(ty_tc_Com_Oloc,type,
    loc: $tType ).

tff(ty_tc_Com_Opname,type,
    pname: $tType ).

tff(ty_tc_Com_Ostate,type,
    state: $tType ).

tff(ty_tc_Com_Ovname,type,
    vname: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Hoare__Mirabelle__vtrypsmcwp_Otriple,type,
    hoare_28830079triple: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (37)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(B,fun(A,C))) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_Com_OWT,type,
    wt: com1 > $o ).

tff(sy_c_Com_Ocom_OAss,type,
    ass: ( vname * fun(state,nat) ) > com1 ).

tff(sy_c_Com_Ocom_OCond,type,
    cond: ( fun(state,bool) * com1 * com1 ) > com1 ).

tff(sy_c_Com_Ocom_OLocal,type,
    local: ( loc * fun(state,nat) * com1 ) > com1 ).

tff(sy_c_Com_Ocom_OSKIP,type,
    skip: com1 ).

tff(sy_c_Com_Ocom_OSemi,type,
    semi: ( com1 * com1 ) > com1 ).

tff(sy_c_Com_Ocom_OWhile,type,
    while: ( fun(state,bool) * com1 ) > com1 ).

tff(sy_c_Com_Ocom_Ocom__case,type,
    com_case: 
      !>[T3: $tType] : ( ( T3 * fun(vname,fun(fun(state,nat),T3)) * fun(loc,fun(fun(state,nat),fun(com1,T3))) * fun(com1,fun(com1,T3)) * fun(fun(state,bool),fun(com1,fun(com1,T3))) * fun(fun(state,bool),fun(com1,T3)) * fun(pname,T3) * fun(vname,fun(pname,fun(fun(state,nat),T3))) * com1 ) > T3 ) ).

tff(sy_c_Com_Ocom_Ocom__rec,type,
    com_rec: 
      !>[T3: $tType] : ( ( T3 * fun(vname,fun(fun(state,nat),T3)) * fun(loc,fun(fun(state,nat),fun(com1,fun(T3,T3)))) * fun(com1,fun(com1,fun(T3,fun(T3,T3)))) * fun(fun(state,bool),fun(com1,fun(com1,fun(T3,fun(T3,T3))))) * fun(fun(state,bool),fun(com1,fun(T3,T3))) * fun(pname,T3) * fun(vname,fun(pname,fun(fun(state,nat),T3))) * com1 ) > T3 ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Opeek__and,type,
    hoare_1442473487ek_and: 
      !>[A: $tType] : ( ( fun(A,fun(state,bool)) * fun(state,bool) * A * state ) > $o ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple,type,
    hoare_1841697145triple: 
      !>[A: $tType] : ( ( fun(A,fun(state,bool)) * com1 * fun(A,fun(state,bool)) ) > hoare_28830079triple(A) ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__case,type,
    hoare_376461865e_case: 
      !>[A: $tType,T3: $tType] : ( ( fun(fun(A,fun(state,bool)),fun(com1,fun(fun(A,fun(state,bool)),T3))) * hoare_28830079triple(A) ) > T3 ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__rec,type,
    hoare_678420151le_rec: 
      !>[A: $tType,T3: $tType] : ( ( fun(fun(A,fun(state,bool)),fun(com1,fun(fun(A,fun(state,bool)),T3))) * hoare_28830079triple(A) ) > T3 ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__size,type,
    hoare_47506394e_size: 
      !>[A: $tType] : ( ( fun(A,nat) * hoare_28830079triple(A) ) > nat ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple__valid,type,
    hoare_1633586161_valid: 
      !>[A: $tType] : ( ( nat * hoare_28830079triple(A) ) > $o ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Nat_Onat_Onat__case,type,
    nat_case: 
      !>[T3: $tType] : ( ( T3 * fun(nat,T3) * nat ) > T3 ) ).

tff(sy_c_Nat_Onat_Onat__rec,type,
    nat_rec: 
      !>[T3: $tType] : ( ( T3 * fun(nat,fun(T3,T3)) * nat ) > T3 ) ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat__aux,type,
    semiri532925092at_aux: 
      !>[A: $tType] : ( ( fun(A,A) * nat * A ) > A ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Natural_Oevaln,type,
    evaln: fun(com1,fun(state,fun(nat,fun(state,bool)))) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fAll,type,
    fAll: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_com,type,
    com: com1 ).

tff(sy_v_fun1,type,
    fun1: fun(a,fun(state,bool)) ).

tff(sy_v_fun2,type,
    fun2: fun(a,fun(state,bool)) ).

tff(sy_v_n,type,
    n: nat ).

%----Relevant facts (96)
tff(fact_0_triple_Oinject,axiom,
    ! [B: $tType,Fun22: fun(B,fun(state,bool)),Com3: com1,Fun12: fun(B,fun(state,bool)),Fun2: fun(B,fun(state,bool)),Com: com1,Fun1: fun(B,fun(state,bool))] :
      ( ( hoare_1841697145triple(B,Fun1,Com,Fun2) = hoare_1841697145triple(B,Fun12,Com3,Fun22) )
    <=> ( ( Fun1 = Fun12 )
        & ( Com = Com3 )
        & ( Fun2 = Fun22 ) ) ) ).

tff(fact_1_triple_Osimps_I2_J,axiom,
    ! [B: $tType,C: $tType,Fun2: fun(C,fun(state,bool)),Com: com1,Fun1: fun(C,fun(state,bool)),F1: fun(fun(C,fun(state,bool)),fun(com1,fun(fun(C,fun(state,bool)),B)))] : ( hoare_376461865e_case(C,B,F1,hoare_1841697145triple(C,Fun1,Com,Fun2)) = aa(fun(C,fun(state,bool)),B,aa(com1,fun(fun(C,fun(state,bool)),B),aa(fun(C,fun(state,bool)),fun(com1,fun(fun(C,fun(state,bool)),B)),F1,Fun1),Com),Fun2) ) ).

tff(fact_2_triple__valid__def,axiom,
    ! [B: $tType,Ta: hoare_28830079triple(B),Na: nat] :
      ( hoare_1633586161_valid(B,Na,Ta)
    <=> pp(hoare_376461865e_case(B,bool,aa(fun(fun(B,fun(state,bool)),fun(com1,fun(fun(B,fun(state,bool)),fun(B,bool)))),fun(fun(B,fun(state,bool)),fun(com1,fun(fun(B,fun(state,bool)),bool))),aa(fun(fun(com1,fun(fun(B,fun(state,bool)),fun(B,bool))),fun(com1,fun(fun(B,fun(state,bool)),bool))),fun(fun(fun(B,fun(state,bool)),fun(com1,fun(fun(B,fun(state,bool)),fun(B,bool)))),fun(fun(B,fun(state,bool)),fun(com1,fun(fun(B,fun(state,bool)),bool)))),combb(fun(com1,fun(fun(B,fun(state,bool)),fun(B,bool))),fun(com1,fun(fun(B,fun(state,bool)),bool)),fun(B,fun(state,bool))),aa(fun(fun(fun(B,fun(state,bool)),fun(B,bool)),fun(fun(B,fun(state,bool)),bool)),fun(fun(com1,fun(fun(B,fun(state,bool)),fun(B,bool))),fun(com1,fun(fun(B,fun(state,bool)),bool))),combb(fun(fun(B,fun(state,bool)),fun(B,bool)),fun(fun(B,fun(state,bool)),bool),com1),aa(fun(fun(B,bool),bool),fun(fun(fun(B,fun(state,bool)),fun(B,bool)),fun(fun(B,fun(state,bool)),bool)),combb(fun(B,bool),bool,fun(B,fun(state,bool))),fAll(B)))),aa(fun(fun(B,fun(state,bool)),fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))))),fun(fun(B,fun(state,bool)),fun(com1,fun(fun(B,fun(state,bool)),fun(B,bool)))),aa(fun(fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),fun(com1,fun(fun(B,fun(state,bool)),fun(B,bool)))),fun(fun(fun(B,fun(state,bool)),fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))))),fun(fun(B,fun(state,bool)),fun(com1,fun(fun(B,fun(state,bool)),fun(B,bool))))),combb(fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),fun(com1,fun(fun(B,fun(state,bool)),fun(B,bool))),fun(B,fun(state,bool))),aa(fun(fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))),fun(fun(B,fun(state,bool)),fun(B,bool))),fun(fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),fun(com1,fun(fun(B,fun(state,bool)),fun(B,bool)))),combb(fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))),fun(fun(B,fun(state,bool)),fun(B,bool)),com1),aa(fun(fun(B,fun(state,bool)),fun(B,bool)),fun(fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))),fun(fun(B,fun(state,bool)),fun(B,bool))),combb(fun(B,fun(state,bool)),fun(B,bool),fun(B,fun(state,bool))),aa(fun(fun(state,bool),bool),fun(fun(B,fun(state,bool)),fun(B,bool)),combb(fun(state,bool),bool,B),fAll(state))))),aa(fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),fun(fun(B,fun(state,bool)),fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))))),aa(fun(fun(B,fun(state,bool)),fun(fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))))),fun(fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),fun(fun(B,fun(state,bool)),fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))))),combc(fun(B,fun(state,bool)),fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))))),aa(fun(fun(B,fun(state,bool)),fun(fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))),fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))))),fun(fun(B,fun(state,bool)),fun(fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))))),aa(fun(fun(fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))),fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),fun(fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))))),fun(fun(fun(B,fun(state,bool)),fun(fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))),fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))))),fun(fun(B,fun(state,bool)),fun(fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))))))),combb(fun(fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))),fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),fun(fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))))),fun(B,fun(state,bool))),combb(fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))),fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))),com1)),aa(fun(fun(B,fun(state,bool)),fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),fun(fun(B,fun(state,bool)),fun(fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))),fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))))),aa(fun(fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))),fun(fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))),fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))))),fun(fun(fun(B,fun(state,bool)),fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),fun(fun(B,fun(state,bool)),fun(fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))),fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))))),combb(fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))),fun(fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))),fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),fun(B,fun(state,bool))),combb(fun(B,fun(state,bool)),fun(B,fun(state,bool)),fun(B,fun(state,bool)))),aa(fun(fun(B,fun(state,bool)),fun(B,fun(fun(state,bool),fun(state,bool)))),fun(fun(B,fun(state,bool)),fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),aa(fun(fun(B,fun(fun(state,bool),fun(state,bool))),fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),fun(fun(fun(B,fun(state,bool)),fun(B,fun(fun(state,bool),fun(state,bool)))),fun(fun(B,fun(state,bool)),fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))))),combb(fun(B,fun(fun(state,bool),fun(state,bool))),fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))),fun(B,fun(state,bool))),combs(B,fun(state,bool),fun(state,bool))),aa(fun(fun(B,fun(state,bool)),fun(B,fun(state,fun(bool,bool)))),fun(fun(B,fun(state,bool)),fun(B,fun(fun(state,bool),fun(state,bool)))),aa(fun(fun(B,fun(state,fun(bool,bool))),fun(B,fun(fun(state,bool),fun(state,bool)))),fun(fun(fun(B,fun(state,bool)),fun(B,fun(state,fun(bool,bool)))),fun(fun(B,fun(state,bool)),fun(B,fun(fun(state,bool),fun(state,bool))))),combb(fun(B,fun(state,fun(bool,bool))),fun(B,fun(fun(state,bool),fun(state,bool))),fun(B,fun(state,bool))),aa(fun(fun(state,fun(bool,bool)),fun(fun(state,bool),fun(state,bool))),fun(fun(B,fun(state,fun(bool,bool))),fun(B,fun(fun(state,bool),fun(state,bool)))),combb(fun(state,fun(bool,bool)),fun(fun(state,bool),fun(state,bool)),B),combs(state,bool,bool))),aa(fun(fun(state,bool),fun(state,fun(bool,bool))),fun(fun(B,fun(state,bool)),fun(B,fun(state,fun(bool,bool)))),combb(fun(state,bool),fun(state,fun(bool,bool)),B),aa(fun(bool,fun(bool,bool)),fun(fun(state,bool),fun(state,fun(bool,bool))),combb(bool,fun(bool,bool),state),fimplies))))))),aa(fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,fun(state,bool))))),fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),aa(fun(fun(fun(B,fun(state,bool)),fun(B,fun(state,fun(state,bool)))),fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),fun(fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,fun(state,bool))))),fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))))),combb(fun(fun(B,fun(state,bool)),fun(B,fun(state,fun(state,bool)))),fun(fun(B,fun(state,bool)),fun(B,fun(state,bool))),com1),aa(fun(fun(B,fun(state,fun(state,bool))),fun(B,fun(state,bool))),fun(fun(fun(B,fun(state,bool)),fun(B,fun(state,fun(state,bool)))),fun(fun(B,fun(state,bool)),fun(B,fun(state,bool)))),combb(fun(B,fun(state,fun(state,bool))),fun(B,fun(state,bool)),fun(B,fun(state,bool))),aa(fun(fun(state,fun(state,bool)),fun(state,bool)),fun(fun(B,fun(state,fun(state,bool))),fun(B,fun(state,bool))),combb(fun(state,fun(state,bool)),fun(state,bool),B),aa(fun(fun(state,bool),bool),fun(fun(state,fun(state,bool)),fun(state,bool)),combb(fun(state,bool),bool,state),fAll(state))))),aa(fun(com1,fun(fun(state,bool),fun(state,fun(state,bool)))),fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,fun(state,bool))))),aa(fun(fun(fun(state,bool),fun(state,fun(state,bool))),fun(fun(B,fun(state,bool)),fun(B,fun(state,fun(state,bool))))),fun(fun(com1,fun(fun(state,bool),fun(state,fun(state,bool)))),fun(com1,fun(fun(B,fun(state,bool)),fun(B,fun(state,fun(state,bool)))))),combb(fun(fun(state,bool),fun(state,fun(state,bool))),fun(fun(B,fun(state,bool)),fun(B,fun(state,fun(state,bool)))),com1),combb(fun(state,bool),fun(state,fun(state,bool)),B)),aa(fun(com1,fun(state,fun(fun(state,bool),fun(state,bool)))),fun(com1,fun(fun(state,bool),fun(state,fun(state,bool)))),aa(fun(fun(state,fun(fun(state,bool),fun(state,bool))),fun(fun(state,bool),fun(state,fun(state,bool)))),fun(fun(com1,fun(state,fun(fun(state,bool),fun(state,bool)))),fun(com1,fun(fun(state,bool),fun(state,fun(state,bool))))),combb(fun(state,fun(fun(state,bool),fun(state,bool))),fun(fun(state,bool),fun(state,fun(state,bool))),com1),combc(state,fun(state,bool),fun(state,bool))),aa(fun(com1,fun(state,fun(state,fun(bool,bool)))),fun(com1,fun(state,fun(fun(state,bool),fun(state,bool)))),aa(fun(fun(state,fun(state,fun(bool,bool))),fun(state,fun(fun(state,bool),fun(state,bool)))),fun(fun(com1,fun(state,fun(state,fun(bool,bool)))),fun(com1,fun(state,fun(fun(state,bool),fun(state,bool))))),combb(fun(state,fun(state,fun(bool,bool))),fun(state,fun(fun(state,bool),fun(state,bool))),com1),aa(fun(fun(state,fun(bool,bool)),fun(fun(state,bool),fun(state,bool))),fun(fun(state,fun(state,fun(bool,bool))),fun(state,fun(fun(state,bool),fun(state,bool)))),combb(fun(state,fun(bool,bool)),fun(fun(state,bool),fun(state,bool)),state),combs(state,bool,bool))),aa(fun(com1,fun(state,fun(state,bool))),fun(com1,fun(state,fun(state,fun(bool,bool)))),aa(fun(fun(state,fun(state,bool)),fun(state,fun(state,fun(bool,bool)))),fun(fun(com1,fun(state,fun(state,bool))),fun(com1,fun(state,fun(state,fun(bool,bool))))),combb(fun(state,fun(state,bool)),fun(state,fun(state,fun(bool,bool))),com1),aa(fun(fun(state,bool),fun(state,fun(bool,bool))),fun(fun(state,fun(state,bool)),fun(state,fun(state,fun(bool,bool)))),combb(fun(state,bool),fun(state,fun(bool,bool)),state),aa(fun(bool,fun(bool,bool)),fun(fun(state,bool),fun(state,fun(bool,bool))),combb(bool,fun(bool,bool),state),fimplies))),aa(nat,fun(com1,fun(state,fun(state,bool))),aa(fun(com1,fun(nat,fun(state,fun(state,bool)))),fun(nat,fun(com1,fun(state,fun(state,bool)))),combc(com1,nat,fun(state,fun(state,bool))),aa(fun(com1,fun(state,fun(nat,fun(state,bool)))),fun(com1,fun(nat,fun(state,fun(state,bool)))),aa(fun(fun(state,fun(nat,fun(state,bool))),fun(nat,fun(state,fun(state,bool)))),fun(fun(com1,fun(state,fun(nat,fun(state,bool)))),fun(com1,fun(nat,fun(state,fun(state,bool))))),combb(fun(state,fun(nat,fun(state,bool))),fun(nat,fun(state,fun(state,bool))),com1),combc(state,nat,fun(state,bool))),evaln)),Na))))))))),Ta)) ) ).

tff(fact_3_nat_Oinject,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( suc(Nat2) = suc(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_4_triple_Orecs,axiom,
    ! [B: $tType,C: $tType,Fun2: fun(C,fun(state,bool)),Com: com1,Fun1: fun(C,fun(state,bool)),F1: fun(fun(C,fun(state,bool)),fun(com1,fun(fun(C,fun(state,bool)),B)))] : ( hoare_678420151le_rec(C,B,F1,hoare_1841697145triple(C,Fun1,Com,Fun2)) = aa(fun(C,fun(state,bool)),B,aa(com1,fun(fun(C,fun(state,bool)),B),aa(fun(C,fun(state,bool)),fun(com1,fun(fun(C,fun(state,bool)),B)),F1,Fun1),Com),Fun2) ) ).

tff(fact_5_evaln__Suc,axiom,
    ! [S6: state,N1: nat,S3: state,C3: com1] :
      ( pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,C3),S3),N1),S6))
     => pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,C3),S3),suc(N1)),S6)) ) ).

tff(fact_6_triple_Oexhaust,axiom,
    ! [B: $tType,Y2: hoare_28830079triple(B)] :
      ~ ! [Fun11: fun(B,fun(state,bool)),Com4: com1,Fun21: fun(B,fun(state,bool))] : ( Y2 != hoare_1841697145triple(B,Fun11,Com4,Fun21) ) ).

tff(fact_7_triple__valid__def2,axiom,
    ! [B: $tType,Q1: fun(B,fun(state,bool)),C1: com1,P1: fun(B,fun(state,bool)),Na: nat] :
      ( hoare_1633586161_valid(B,Na,hoare_1841697145triple(B,P1,C1,Q1))
    <=> ! [Z: B,S4: state] :
          ( pp(aa(state,bool,aa(B,fun(state,bool),P1,Z),S4))
         => ! [S5: state] :
              ( pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,C1),S4),Na),S5))
             => pp(aa(state,bool,aa(B,fun(state,bool),Q1,Z),S5)) ) ) ) ).

tff(fact_8_n__not__Suc__n,axiom,
    ! [N1: nat] : ( N1 != suc(N1) ) ).

tff(fact_9_Suc__n__not__n,axiom,
    ! [N1: nat] : ( suc(N1) != N1 ) ).

tff(fact_10_Suc__inject,axiom,
    ! [Y1: nat,X: nat] :
      ( ( suc(X) = suc(Y1) )
     => ( X = Y1 ) ) ).

tff(fact_11_peek__and__def,axiom,
    ! [B: $tType,P2: fun(state,bool),P1: fun(B,fun(state,bool)),X2: B,Xa: state] :
      ( hoare_1442473487ek_and(B,P1,P2,X2,Xa)
    <=> ( pp(aa(state,bool,aa(B,fun(state,bool),P1,X2),Xa))
        & pp(aa(state,bool,P2,Xa)) ) ) ).

tff(fact_12_evaln__max2,axiom,
    ! [T2: state,N2: nat,S21: state,C21: com1,T1: state,N11: nat,S12: state,C11: com1] :
      ( pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,C11),S12),N11),T1))
     => ( pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,C21),S21),N2),T2))
       => ? [N: nat] :
            ( pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,C11),S12),N),T1))
            & pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,C21),S21),N),T2)) ) ) ) ).

tff(fact_13_of__nat__aux_Osimps_I2_J,axiom,
    ! [B: $tType] :
      ( semiring_1(B)
     => ! [I: B,Na: nat,Inc: fun(B,B)] : ( semiri532925092at_aux(B,Inc,suc(Na),I) = semiri532925092at_aux(B,Inc,Na,aa(B,B,Inc,I)) ) ) ).

tff(fact_14_nat__case__Suc,axiom,
    ! [B: $tType,Nat2: nat,F2: fun(nat,B),F1: B] : ( nat_case(B,F1,F2,suc(Nat2)) = aa(nat,B,F2,Nat2) ) ).

tff(fact_15_evaln__elim__cases_I1_J,axiom,
    ! [T: state,N1: nat,S3: state] :
      ( pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,skip),S3),N1),T))
     => ( T = S3 ) ) ).

tff(fact_16_evaln_OSkip,axiom,
    ! [N1: nat,S3: state] : pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,skip),S3),N1),S3)) ).

tff(fact_17_evaln_OSemi,axiom,
    ! [S21: state,C11: com1,S12: state,N1: nat,S01: state,C0: com1] :
      ( pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,C0),S01),N1),S12))
     => ( pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,C11),S12),N1),S21))
       => pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,semi(C0,C11)),S01),N1),S21)) ) ) ).

tff(fact_18_evaln__elim__cases_I5_J,axiom,
    ! [Ta: state,Na: nat,S: state,C2: com1,C12: com1,B1: fun(state,bool)] :
      ( pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,cond(B1,C12,C2)),S),Na),Ta))
     => ( ( pp(aa(state,bool,B1,S))
         => ~ pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,C12),S),Na),Ta)) )
       => ~ ( ~ pp(aa(state,bool,B1,S))
           => ~ pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,C2),S),Na),Ta)) ) ) ) ).

tff(fact_19_evaln_OIfTrue,axiom,
    ! [C12: com1,S11: state,Na: nat,C01: com1,S: state,B1: fun(state,bool)] :
      ( pp(aa(state,bool,B1,S))
     => ( pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,C01),S),Na),S11))
       => pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,cond(B1,C01,C12)),S),Na),S11)) ) ) ).

tff(fact_20_evaln_OIfFalse,axiom,
    ! [C01: com1,S11: state,Na: nat,C12: com1,S: state,B1: fun(state,bool)] :
      ( ~ pp(aa(state,bool,B1,S))
     => ( pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,C12),S),Na),S11))
       => pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,cond(B1,C01,C12)),S),Na),S11)) ) ) ).

tff(fact_21_nat__rec__Suc,axiom,
    ! [B: $tType,Nat2: nat,F2: fun(nat,fun(B,B)),F1: B] : ( nat_rec(B,F1,F2,suc(Nat2)) = aa(B,B,aa(nat,fun(B,B),F2,Nat2),nat_rec(B,F1,F2,Nat2)) ) ).

tff(fact_22_evaln__elim__cases_I4_J,axiom,
    ! [T: state,N1: nat,S3: state,C21: com1,C11: com1] :
      ( pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,semi(C11,C21)),S3),N1),T))
     => ~ ! [S1: state] :
            ( pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,C11),S3),N1),S1))
           => ~ pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,C21),S1),N1),T)) ) ) ).

tff(fact_23_com_Osimps_I3_J,axiom,
    ! [Com21: com1,Com11: com1,Com2: com1,Com1: com1] :
      ( ( semi(Com1,Com2) = semi(Com11,Com21) )
    <=> ( ( Com1 = Com11 )
        & ( Com2 = Com21 ) ) ) ).

tff(fact_24_com_Osimps_I4_J,axiom,
    ! [Com21: com1,Com11: com1,Fun3: fun(state,bool),Com2: com1,Com1: com1,Fun: fun(state,bool)] :
      ( ( cond(Fun,Com1,Com2) = cond(Fun3,Com11,Com21) )
    <=> ( ( Fun = Fun3 )
        & ( Com1 = Com11 )
        & ( Com2 = Com21 ) ) ) ).

tff(fact_25_def__nat__rec__Suc,axiom,
    ! [B: $tType,Na: nat,H: fun(nat,fun(B,B)),C1: B,F: fun(nat,B)] :
      ( ! [N: nat] : ( aa(nat,B,F,N) = nat_rec(B,C1,H,N) )
     => ( aa(nat,B,F,suc(Na)) = aa(B,B,aa(nat,fun(B,B),H,Na),aa(nat,B,F,Na)) ) ) ).

tff(fact_26_com_Osimps_I13_J,axiom,
    ! [Com22: com1,Com12: com1] : ( semi(Com12,Com22) != skip ) ).

tff(fact_27_com_Osimps_I12_J,axiom,
    ! [Com22: com1,Com12: com1] : ( skip != semi(Com12,Com22) ) ).

tff(fact_28_com_Osimps_I15_J,axiom,
    ! [Com21: com1,Com11: com1,Fun3: fun(state,bool)] : ( cond(Fun3,Com11,Com21) != skip ) ).

tff(fact_29_com_Osimps_I44_J,axiom,
    ! [Com21: com1,Com11: com1,Fun3: fun(state,bool),Com2: com1,Com1: com1] : ( semi(Com1,Com2) != cond(Fun3,Com11,Com21) ) ).

tff(fact_30_com_Osimps_I45_J,axiom,
    ! [Com2: com1,Com1: com1,Com21: com1,Com11: com1,Fun3: fun(state,bool)] : ( cond(Fun3,Com11,Com21) != semi(Com1,Com2) ) ).

tff(fact_31_com_Osimps_I14_J,axiom,
    ! [Com21: com1,Com11: com1,Fun3: fun(state,bool)] : ( skip != cond(Fun3,Com11,Com21) ) ).

tff(fact_32_com_Osimps_I64_J,axiom,
    ! [B: $tType,F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com1,B)),F5: fun(fun(state,bool),fun(com1,fun(com1,B))),F4: fun(com1,fun(com1,B)),F3: fun(loc,fun(fun(state,nat),fun(com1,B))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_case(B,F1,F2,F3,F4,F5,F6,F7,F8,skip) = F1 ) ).

tff(fact_33_com_Osimps_I67_J,axiom,
    ! [B: $tType,Com2: com1,Com1: com1,F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com1,B)),F5: fun(fun(state,bool),fun(com1,fun(com1,B))),F4: fun(com1,fun(com1,B)),F3: fun(loc,fun(fun(state,nat),fun(com1,B))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_case(B,F1,F2,F3,F4,F5,F6,F7,F8,semi(Com1,Com2)) = aa(com1,B,aa(com1,fun(com1,B),F4,Com1),Com2) ) ).

tff(fact_34_com_Osimps_I68_J,axiom,
    ! [B: $tType,Com2: com1,Com1: com1,Fun: fun(state,bool),F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com1,B)),F5: fun(fun(state,bool),fun(com1,fun(com1,B))),F4: fun(com1,fun(com1,B)),F3: fun(loc,fun(fun(state,nat),fun(com1,B))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_case(B,F1,F2,F3,F4,F5,F6,F7,F8,cond(Fun,Com1,Com2)) = aa(com1,B,aa(com1,fun(com1,B),aa(fun(state,bool),fun(com1,fun(com1,B)),F5,Fun),Com1),Com2) ) ).

tff(fact_35_WTs__elim__cases_I4_J,axiom,
    ! [C21: com1,C11: com1] :
      ( wt(semi(C11,C21))
     => ~ ( wt(C11)
         => ~ wt(C21) ) ) ).

tff(fact_36_WTs__elim__cases_I5_J,axiom,
    ! [C2: com1,C12: com1,B1: fun(state,bool)] :
      ( wt(cond(B1,C12,C2))
     => ~ ( wt(C12)
         => ~ wt(C2) ) ) ).

tff(fact_37_WT_OIf,axiom,
    ! [B1: fun(state,bool),C12: com1,C01: com1] :
      ( wt(C01)
     => ( wt(C12)
       => wt(cond(B1,C01,C12)) ) ) ).

tff(fact_38_WT_OSemi,axiom,
    ! [C11: com1,C0: com1] :
      ( wt(C0)
     => ( wt(C11)
       => wt(semi(C0,C11)) ) ) ).

tff(fact_39_WT_OSkip,axiom,
    wt(skip) ).

tff(fact_40_WTs__elim__cases_I3_J,axiom,
    ! [C1: com1,A1: fun(state,nat),Y: loc] :
      ( wt(local(Y,A1,C1))
     => wt(C1) ) ).

tff(fact_41_WTs__elim__cases_I6_J,axiom,
    ! [C1: com1,B1: fun(state,bool)] :
      ( wt(while(B1,C1))
     => wt(C1) ) ).

tff(fact_42_com_Orecs_I1_J,axiom,
    ! [B: $tType,F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com1,fun(B,B))),F5: fun(fun(state,bool),fun(com1,fun(com1,fun(B,fun(B,B))))),F4: fun(com1,fun(com1,fun(B,fun(B,B)))),F3: fun(loc,fun(fun(state,nat),fun(com1,fun(B,B)))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,skip) = F1 ) ).

tff(fact_43_of__nat__aux_Osimps_I1_J,axiom,
    ! [B: $tType] :
      ( semiring_1(B)
     => ! [I: B,Inc: fun(B,B)] : ( semiri532925092at_aux(B,Inc,zero_zero(nat),I) = I ) ) ).

tff(fact_44_com_Osimps_I5_J,axiom,
    ! [Com3: com1,Fun3: fun(state,bool),Com: com1,Fun: fun(state,bool)] :
      ( ( while(Fun,Com) = while(Fun3,Com3) )
    <=> ( ( Fun = Fun3 )
        & ( Com = Com3 ) ) ) ).

tff(fact_45_com_Osimps_I2_J,axiom,
    ! [Com3: com1,Fun3: fun(state,nat),Loc1: loc,Com: com1,Fun: fun(state,nat),Loc: loc] :
      ( ( local(Loc,Fun,Com) = local(Loc1,Fun3,Com3) )
    <=> ( ( Loc = Loc1 )
        & ( Fun = Fun3 )
        & ( Com = Com3 ) ) ) ).

tff(fact_46_com_Osimps_I1_J,axiom,
    ! [Fun3: fun(state,nat),Vname1: vname,Fun: fun(state,nat),Vname: vname] :
      ( ( ass(Vname,Fun) = ass(Vname1,Fun3) )
    <=> ( ( Vname = Vname1 )
        & ( Fun = Fun3 ) ) ) ).

tff(fact_47_evaln_OWhileTrue,axiom,
    ! [S2: state,S11: state,Na: nat,C1: com1,S0: state,B1: fun(state,bool)] :
      ( pp(aa(state,bool,B1,S0))
     => ( pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,C1),S0),Na),S11))
       => ( pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,while(B1,C1)),S11),Na),S2))
         => pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,while(B1,C1)),S0),Na),S2)) ) ) ) ).

tff(fact_48_evaln_OWhileFalse,axiom,
    ! [Na: nat,C1: com1,S: state,B1: fun(state,bool)] :
      ( ~ pp(aa(state,bool,B1,S))
     => pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,while(B1,C1)),S),Na),S)) ) ).

tff(fact_49_com_Orecs_I3_J,axiom,
    ! [B: $tType,Com: com1,Fun: fun(state,nat),Loc: loc,F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com1,fun(B,B))),F5: fun(fun(state,bool),fun(com1,fun(com1,fun(B,fun(B,B))))),F4: fun(com1,fun(com1,fun(B,fun(B,B)))),F3: fun(loc,fun(fun(state,nat),fun(com1,fun(B,B)))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,local(Loc,Fun,Com)) = aa(B,B,aa(com1,fun(B,B),aa(fun(state,nat),fun(com1,fun(B,B)),aa(loc,fun(fun(state,nat),fun(com1,fun(B,B))),F3,Loc),Fun),Com),com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,Com)) ) ).

tff(fact_50_com_Orecs_I6_J,axiom,
    ! [B: $tType,Com: com1,Fun: fun(state,bool),F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com1,fun(B,B))),F5: fun(fun(state,bool),fun(com1,fun(com1,fun(B,fun(B,B))))),F4: fun(com1,fun(com1,fun(B,fun(B,B)))),F3: fun(loc,fun(fun(state,nat),fun(com1,fun(B,B)))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,while(Fun,Com)) = aa(B,B,aa(com1,fun(B,B),aa(fun(state,bool),fun(com1,fun(B,B)),F6,Fun),Com),com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,Com)) ) ).

tff(fact_51_com_Orecs_I2_J,axiom,
    ! [B: $tType,Fun: fun(state,nat),Vname: vname,F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com1,fun(B,B))),F5: fun(fun(state,bool),fun(com1,fun(com1,fun(B,fun(B,B))))),F4: fun(com1,fun(com1,fun(B,fun(B,B)))),F3: fun(loc,fun(fun(state,nat),fun(com1,fun(B,B)))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,ass(Vname,Fun)) = aa(fun(state,nat),B,aa(vname,fun(fun(state,nat),B),F2,Vname),Fun) ) ).

tff(fact_52_com_Osimps_I23_J,axiom,
    ! [Fun: fun(state,nat),Vname: vname,Com3: com1,Fun3: fun(state,nat),Loc1: loc] : ( local(Loc1,Fun3,Com3) != ass(Vname,Fun) ) ).

tff(fact_53_com_Osimps_I38_J,axiom,
    ! [Com3: com1,Fun3: fun(state,bool),Com: com1,Fun: fun(state,nat),Loc: loc] : ( local(Loc,Fun,Com) != while(Fun3,Com3) ) ).

tff(fact_54_com_Osimps_I39_J,axiom,
    ! [Com: com1,Fun: fun(state,nat),Loc: loc,Com3: com1,Fun3: fun(state,bool)] : ( while(Fun3,Com3) != local(Loc,Fun,Com) ) ).

tff(fact_55_com_Osimps_I22_J,axiom,
    ! [Com3: com1,Fun3: fun(state,nat),Loc1: loc,Fun: fun(state,nat),Vname: vname] : ( ass(Vname,Fun) != local(Loc1,Fun3,Com3) ) ).

tff(fact_56_com_Osimps_I29_J,axiom,
    ! [Fun: fun(state,nat),Vname: vname,Com3: com1,Fun3: fun(state,bool)] : ( while(Fun3,Com3) != ass(Vname,Fun) ) ).

tff(fact_57_com_Osimps_I28_J,axiom,
    ! [Com3: com1,Fun3: fun(state,bool),Fun: fun(state,nat),Vname: vname] : ( ass(Vname,Fun) != while(Fun3,Com3) ) ).

tff(fact_58_Suc__neq__Zero,axiom,
    ! [M: nat] : ( suc(M) != zero_zero(nat) ) ).

tff(fact_59_Zero__neq__Suc,axiom,
    ! [M: nat] : ( zero_zero(nat) != suc(M) ) ).

tff(fact_60_nat_Osimps_I3_J,axiom,
    ! [Nat1: nat] : ( suc(Nat1) != zero_zero(nat) ) ).

tff(fact_61_Suc__not__Zero,axiom,
    ! [M: nat] : ( suc(M) != zero_zero(nat) ) ).

tff(fact_62_nat_Osimps_I2_J,axiom,
    ! [Nat: nat] : ( zero_zero(nat) != suc(Nat) ) ).

tff(fact_63_Zero__not__Suc,axiom,
    ! [M: nat] : ( zero_zero(nat) != suc(M) ) ).

tff(fact_64_nat__case__0,axiom,
    ! [B: $tType,F2: fun(nat,B),F1: B] : ( nat_case(B,F1,F2,zero_zero(nat)) = F1 ) ).

tff(fact_65_While,axiom,
    ! [B1: fun(state,bool),C1: com1] :
      ( wt(C1)
     => wt(while(B1,C1)) ) ).

tff(fact_66_WT_OLocal,axiom,
    ! [A1: fun(state,nat),Y: loc,C1: com1] :
      ( wt(C1)
     => wt(local(Y,A1,C1)) ) ).

tff(fact_67_WT_OAssign,axiom,
    ! [A1: fun(state,nat),X1: vname] : wt(ass(X1,A1)) ).

tff(fact_68_com_Osimps_I53_J,axiom,
    ! [Com2: com1,Com1: com1,Fun: fun(state,bool),Com3: com1,Fun3: fun(state,bool)] : ( while(Fun3,Com3) != cond(Fun,Com1,Com2) ) ).

tff(fact_69_com_Osimps_I52_J,axiom,
    ! [Com3: com1,Fun3: fun(state,bool),Com2: com1,Com1: com1,Fun: fun(state,bool)] : ( cond(Fun,Com1,Com2) != while(Fun3,Com3) ) ).

tff(fact_70_com_Osimps_I26_J,axiom,
    ! [Com21: com1,Com11: com1,Fun3: fun(state,bool),Fun: fun(state,nat),Vname: vname] : ( ass(Vname,Fun) != cond(Fun3,Com11,Com21) ) ).

tff(fact_71_com_Osimps_I27_J,axiom,
    ! [Fun: fun(state,nat),Vname: vname,Com21: com1,Com11: com1,Fun3: fun(state,bool)] : ( cond(Fun3,Com11,Com21) != ass(Vname,Fun) ) ).

tff(fact_72_com_Osimps_I37_J,axiom,
    ! [Com: com1,Fun: fun(state,nat),Loc: loc,Com21: com1,Com11: com1,Fun3: fun(state,bool)] : ( cond(Fun3,Com11,Com21) != local(Loc,Fun,Com) ) ).

tff(fact_73_com_Osimps_I36_J,axiom,
    ! [Com21: com1,Com11: com1,Fun3: fun(state,bool),Com: com1,Fun: fun(state,nat),Loc: loc] : ( local(Loc,Fun,Com) != cond(Fun3,Com11,Com21) ) ).

tff(fact_74_com_Osimps_I46_J,axiom,
    ! [Com3: com1,Fun3: fun(state,bool),Com2: com1,Com1: com1] : ( semi(Com1,Com2) != while(Fun3,Com3) ) ).

tff(fact_75_com_Osimps_I47_J,axiom,
    ! [Com2: com1,Com1: com1,Com3: com1,Fun3: fun(state,bool)] : ( while(Fun3,Com3) != semi(Com1,Com2) ) ).

tff(fact_76_com_Osimps_I24_J,axiom,
    ! [Com21: com1,Com11: com1,Fun: fun(state,nat),Vname: vname] : ( ass(Vname,Fun) != semi(Com11,Com21) ) ).

tff(fact_77_com_Osimps_I25_J,axiom,
    ! [Fun: fun(state,nat),Vname: vname,Com21: com1,Com11: com1] : ( semi(Com11,Com21) != ass(Vname,Fun) ) ).

tff(fact_78_com_Osimps_I35_J,axiom,
    ! [Com: com1,Fun: fun(state,nat),Loc: loc,Com21: com1,Com11: com1] : ( semi(Com11,Com21) != local(Loc,Fun,Com) ) ).

tff(fact_79_com_Osimps_I34_J,axiom,
    ! [Com21: com1,Com11: com1,Com: com1,Fun: fun(state,nat),Loc: loc] : ( local(Loc,Fun,Com) != semi(Com11,Com21) ) ).

tff(fact_80_com_Osimps_I16_J,axiom,
    ! [Com3: com1,Fun3: fun(state,bool)] : ( skip != while(Fun3,Com3) ) ).

tff(fact_81_com_Osimps_I17_J,axiom,
    ! [Com3: com1,Fun3: fun(state,bool)] : ( while(Fun3,Com3) != skip ) ).

tff(fact_82_com_Osimps_I8_J,axiom,
    ! [Fun3: fun(state,nat),Vname1: vname] : ( skip != ass(Vname1,Fun3) ) ).

tff(fact_83_com_Osimps_I10_J,axiom,
    ! [Com3: com1,Fun3: fun(state,nat),Loc1: loc] : ( skip != local(Loc1,Fun3,Com3) ) ).

tff(fact_84_com_Osimps_I9_J,axiom,
    ! [Fun3: fun(state,nat),Vname1: vname] : ( ass(Vname1,Fun3) != skip ) ).

tff(fact_85_com_Osimps_I11_J,axiom,
    ! [Com3: com1,Fun3: fun(state,nat),Loc1: loc] : ( local(Loc1,Fun3,Com3) != skip ) ).

tff(fact_86_nat__rec__0,axiom,
    ! [B: $tType,F2: fun(nat,fun(B,B)),F1: B] : ( nat_rec(B,F1,F2,zero_zero(nat)) = F1 ) ).

tff(fact_87_com_Osimps_I69_J,axiom,
    ! [B: $tType,Com: com1,Fun: fun(state,bool),F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com1,B)),F5: fun(fun(state,bool),fun(com1,fun(com1,B))),F4: fun(com1,fun(com1,B)),F3: fun(loc,fun(fun(state,nat),fun(com1,B))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_case(B,F1,F2,F3,F4,F5,F6,F7,F8,while(Fun,Com)) = aa(com1,B,aa(fun(state,bool),fun(com1,B),F6,Fun),Com) ) ).

tff(fact_88_com_Osimps_I66_J,axiom,
    ! [B: $tType,Com: com1,Fun: fun(state,nat),Loc: loc,F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com1,B)),F5: fun(fun(state,bool),fun(com1,fun(com1,B))),F4: fun(com1,fun(com1,B)),F3: fun(loc,fun(fun(state,nat),fun(com1,B))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_case(B,F1,F2,F3,F4,F5,F6,F7,F8,local(Loc,Fun,Com)) = aa(com1,B,aa(fun(state,nat),fun(com1,B),aa(loc,fun(fun(state,nat),fun(com1,B)),F3,Loc),Fun),Com) ) ).

tff(fact_89_com_Osimps_I65_J,axiom,
    ! [B: $tType,Fun: fun(state,nat),Vname: vname,F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com1,B)),F5: fun(fun(state,bool),fun(com1,fun(com1,B))),F4: fun(com1,fun(com1,B)),F3: fun(loc,fun(fun(state,nat),fun(com1,B))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_case(B,F1,F2,F3,F4,F5,F6,F7,F8,ass(Vname,Fun)) = aa(fun(state,nat),B,aa(vname,fun(fun(state,nat),B),F2,Vname),Fun) ) ).

tff(fact_90_com_Orecs_I5_J,axiom,
    ! [B: $tType,Com2: com1,Com1: com1,Fun: fun(state,bool),F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com1,fun(B,B))),F5: fun(fun(state,bool),fun(com1,fun(com1,fun(B,fun(B,B))))),F4: fun(com1,fun(com1,fun(B,fun(B,B)))),F3: fun(loc,fun(fun(state,nat),fun(com1,fun(B,B)))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,cond(Fun,Com1,Com2)) = aa(B,B,aa(B,fun(B,B),aa(com1,fun(B,fun(B,B)),aa(com1,fun(com1,fun(B,fun(B,B))),aa(fun(state,bool),fun(com1,fun(com1,fun(B,fun(B,B)))),F5,Fun),Com1),Com2),com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,Com1)),com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,Com2)) ) ).

tff(fact_91_com_Orecs_I4_J,axiom,
    ! [B: $tType,Com2: com1,Com1: com1,F8: fun(vname,fun(pname,fun(fun(state,nat),B))),F7: fun(pname,B),F6: fun(fun(state,bool),fun(com1,fun(B,B))),F5: fun(fun(state,bool),fun(com1,fun(com1,fun(B,fun(B,B))))),F4: fun(com1,fun(com1,fun(B,fun(B,B)))),F3: fun(loc,fun(fun(state,nat),fun(com1,fun(B,B)))),F2: fun(vname,fun(fun(state,nat),B)),F1: B] : ( com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,semi(Com1,Com2)) = aa(B,B,aa(B,fun(B,B),aa(com1,fun(B,fun(B,B)),aa(com1,fun(com1,fun(B,fun(B,B))),F4,Com1),Com2),com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,Com1)),com_rec(B,F1,F2,F3,F4,F5,F6,F7,F8,Com2)) ) ).

tff(fact_92_triple_Osize_I1_J,axiom,
    ! [B: $tType,Fun2: fun(B,fun(state,bool)),Com: com1,Fun1: fun(B,fun(state,bool)),Fa: fun(B,nat)] : ( hoare_47506394e_size(B,Fa,hoare_1841697145triple(B,Fun1,Com,Fun2)) = zero_zero(nat) ) ).

tff(fact_93_triple_Osize_I2_J,axiom,
    ! [B: $tType,Fun2: fun(B,fun(state,bool)),Com: com1,Fun1: fun(B,fun(state,bool))] : ( size_size(hoare_28830079triple(B),hoare_1841697145triple(B,Fun1,Com,Fun2)) = zero_zero(nat) ) ).

tff(fact_94_def__nat__rec__0,axiom,
    ! [B: $tType,H: fun(nat,fun(B,B)),C1: B,F: fun(nat,B)] :
      ( ! [N: nat] : ( aa(nat,B,F,N) = nat_rec(B,C1,H,N) )
     => ( aa(nat,B,F,zero_zero(nat)) = C1 ) ) ).

tff(fact_95_evaln__WHILE__case,axiom,
    ! [Ta: state,Na: nat,S: state,C1: com1,B1: fun(state,bool)] :
      ( pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,while(B1,C1)),S),Na),Ta))
     => ( ( ( Ta = S )
         => pp(aa(state,bool,B1,S)) )
       => ~ ( pp(aa(state,bool,B1,S))
           => ! [S1: state] :
                ( pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,C1),S),Na),S1))
               => ~ pp(aa(state,bool,aa(nat,fun(state,bool),aa(state,fun(nat,fun(state,bool)),aa(com1,fun(state,fun(nat,fun(state,bool))),evaln,while(B1,C1)),S1),Na),Ta)) ) ) ) ) ).

%----Arities (2)
tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (9)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fAll_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(fun(A,bool),bool,fAll(A),P))
      | pp(aa(A,bool,P,X)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),aa(fun(A,fun(B,C)),fun(B,fun(A,C)),combc(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C)),combs(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ( ~ pp(hoare_376461865e_case(a,bool,aa(fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool)))),fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),bool))),aa(fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool))),fun(com1,fun(fun(a,fun(state,bool)),bool))),fun(fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool)))),fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),bool)))),combb(fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool))),fun(com1,fun(fun(a,fun(state,bool)),bool)),fun(a,fun(state,bool))),aa(fun(fun(fun(a,fun(state,bool)),fun(a,bool)),fun(fun(a,fun(state,bool)),bool)),fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool))),fun(com1,fun(fun(a,fun(state,bool)),bool))),combb(fun(fun(a,fun(state,bool)),fun(a,bool)),fun(fun(a,fun(state,bool)),bool),com1),aa(fun(fun(a,bool),bool),fun(fun(fun(a,fun(state,bool)),fun(a,bool)),fun(fun(a,fun(state,bool)),bool)),combb(fun(a,bool),bool,fun(a,fun(state,bool))),fAll(a)))),aa(fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool)))),aa(fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool)))),fun(fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool))))),combb(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool))),fun(a,fun(state,bool))),aa(fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,bool))),fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool)))),combb(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,bool)),com1),aa(fun(fun(a,fun(state,bool)),fun(a,bool)),fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,bool))),combb(fun(a,fun(state,bool)),fun(a,bool),fun(a,fun(state,bool))),aa(fun(fun(state,bool),bool),fun(fun(a,fun(state,bool)),fun(a,bool)),combb(fun(state,bool),bool,a),fAll(state))))),aa(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),aa(fun(fun(a,fun(state,bool)),fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))))),fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))))),combc(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),aa(fun(fun(a,fun(state,bool)),fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),fun(fun(a,fun(state,bool)),fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))))),aa(fun(fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))))),fun(fun(fun(a,fun(state,bool)),fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),fun(fun(a,fun(state,bool)),fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))))),combb(fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),fun(a,fun(state,bool))),combb(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),com1)),aa(fun(fun(a,fun(state,bool)),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(fun(a,fun(state,bool)),fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),aa(fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),fun(fun(fun(a,fun(state,bool)),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(fun(a,fun(state,bool)),fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))))),combb(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(a,fun(state,bool))),combb(fun(a,fun(state,bool)),fun(a,fun(state,bool)),fun(a,fun(state,bool)))),aa(fun(fun(a,fun(state,bool)),fun(a,fun(fun(state,bool),fun(state,bool)))),fun(fun(a,fun(state,bool)),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),aa(fun(fun(a,fun(fun(state,bool),fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(fun(fun(a,fun(state,bool)),fun(a,fun(fun(state,bool),fun(state,bool)))),fun(fun(a,fun(state,bool)),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),combb(fun(a,fun(fun(state,bool),fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(a,fun(state,bool))),combs(a,fun(state,bool),fun(state,bool))),aa(fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(bool,bool)))),fun(fun(a,fun(state,bool)),fun(a,fun(fun(state,bool),fun(state,bool)))),aa(fun(fun(a,fun(state,fun(bool,bool))),fun(a,fun(fun(state,bool),fun(state,bool)))),fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(bool,bool)))),fun(fun(a,fun(state,bool)),fun(a,fun(fun(state,bool),fun(state,bool))))),combb(fun(a,fun(state,fun(bool,bool))),fun(a,fun(fun(state,bool),fun(state,bool))),fun(a,fun(state,bool))),aa(fun(fun(state,fun(bool,bool)),fun(fun(state,bool),fun(state,bool))),fun(fun(a,fun(state,fun(bool,bool))),fun(a,fun(fun(state,bool),fun(state,bool)))),combb(fun(state,fun(bool,bool)),fun(fun(state,bool),fun(state,bool)),a),combs(state,bool,bool))),aa(fun(fun(state,bool),fun(state,fun(bool,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(bool,bool)))),combb(fun(state,bool),fun(state,fun(bool,bool)),a),aa(fun(bool,fun(bool,bool)),fun(fun(state,bool),fun(state,fun(bool,bool))),combb(bool,fun(bool,bool),state),fimplies))))))),aa(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(state,bool))))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),aa(fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(state,bool)))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(state,bool))))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),combb(fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(state,bool)))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),com1),aa(fun(fun(a,fun(state,fun(state,bool))),fun(a,fun(state,bool))),fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(state,bool)))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),combb(fun(a,fun(state,fun(state,bool))),fun(a,fun(state,bool)),fun(a,fun(state,bool))),aa(fun(fun(state,fun(state,bool)),fun(state,bool)),fun(fun(a,fun(state,fun(state,bool))),fun(a,fun(state,bool))),combb(fun(state,fun(state,bool)),fun(state,bool),a),aa(fun(fun(state,bool),bool),fun(fun(state,fun(state,bool)),fun(state,bool)),combb(fun(state,bool),bool,state),fAll(state))))),aa(fun(com1,fun(fun(state,bool),fun(state,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(state,bool))))),aa(fun(fun(fun(state,bool),fun(state,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(state,bool))))),fun(fun(com1,fun(fun(state,bool),fun(state,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(state,bool)))))),combb(fun(fun(state,bool),fun(state,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(state,bool)))),com1),combb(fun(state,bool),fun(state,fun(state,bool)),a)),aa(fun(com1,fun(state,fun(fun(state,bool),fun(state,bool)))),fun(com1,fun(fun(state,bool),fun(state,fun(state,bool)))),aa(fun(fun(state,fun(fun(state,bool),fun(state,bool))),fun(fun(state,bool),fun(state,fun(state,bool)))),fun(fun(com1,fun(state,fun(fun(state,bool),fun(state,bool)))),fun(com1,fun(fun(state,bool),fun(state,fun(state,bool))))),combb(fun(state,fun(fun(state,bool),fun(state,bool))),fun(fun(state,bool),fun(state,fun(state,bool))),com1),combc(state,fun(state,bool),fun(state,bool))),aa(fun(com1,fun(state,fun(state,fun(bool,bool)))),fun(com1,fun(state,fun(fun(state,bool),fun(state,bool)))),aa(fun(fun(state,fun(state,fun(bool,bool))),fun(state,fun(fun(state,bool),fun(state,bool)))),fun(fun(com1,fun(state,fun(state,fun(bool,bool)))),fun(com1,fun(state,fun(fun(state,bool),fun(state,bool))))),combb(fun(state,fun(state,fun(bool,bool))),fun(state,fun(fun(state,bool),fun(state,bool))),com1),aa(fun(fun(state,fun(bool,bool)),fun(fun(state,bool),fun(state,bool))),fun(fun(state,fun(state,fun(bool,bool))),fun(state,fun(fun(state,bool),fun(state,bool)))),combb(fun(state,fun(bool,bool)),fun(fun(state,bool),fun(state,bool)),state),combs(state,bool,bool))),aa(fun(com1,fun(state,fun(state,bool))),fun(com1,fun(state,fun(state,fun(bool,bool)))),aa(fun(fun(state,fun(state,bool)),fun(state,fun(state,fun(bool,bool)))),fun(fun(com1,fun(state,fun(state,bool))),fun(com1,fun(state,fun(state,fun(bool,bool))))),combb(fun(state,fun(state,bool)),fun(state,fun(state,fun(bool,bool))),com1),aa(fun(fun(state,bool),fun(state,fun(bool,bool))),fun(fun(state,fun(state,bool)),fun(state,fun(state,fun(bool,bool)))),combb(fun(state,bool),fun(state,fun(bool,bool)),state),aa(fun(bool,fun(bool,bool)),fun(fun(state,bool),fun(state,fun(bool,bool))),combb(bool,fun(bool,bool),state),fimplies))),aa(nat,fun(com1,fun(state,fun(state,bool))),aa(fun(com1,fun(nat,fun(state,fun(state,bool)))),fun(nat,fun(com1,fun(state,fun(state,bool)))),combc(com1,nat,fun(state,fun(state,bool))),aa(fun(com1,fun(state,fun(nat,fun(state,bool)))),fun(com1,fun(nat,fun(state,fun(state,bool)))),aa(fun(fun(state,fun(nat,fun(state,bool))),fun(nat,fun(state,fun(state,bool)))),fun(fun(com1,fun(state,fun(nat,fun(state,bool)))),fun(com1,fun(nat,fun(state,fun(state,bool))))),combb(fun(state,fun(nat,fun(state,bool))),fun(nat,fun(state,fun(state,bool))),com1),combc(state,nat,fun(state,bool))),evaln)),suc(n)))))))))),hoare_1841697145triple(a,fun1,com,fun2)))
    | pp(hoare_376461865e_case(a,bool,aa(fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool)))),fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),bool))),aa(fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool))),fun(com1,fun(fun(a,fun(state,bool)),bool))),fun(fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool)))),fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),bool)))),combb(fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool))),fun(com1,fun(fun(a,fun(state,bool)),bool)),fun(a,fun(state,bool))),aa(fun(fun(fun(a,fun(state,bool)),fun(a,bool)),fun(fun(a,fun(state,bool)),bool)),fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool))),fun(com1,fun(fun(a,fun(state,bool)),bool))),combb(fun(fun(a,fun(state,bool)),fun(a,bool)),fun(fun(a,fun(state,bool)),bool),com1),aa(fun(fun(a,bool),bool),fun(fun(fun(a,fun(state,bool)),fun(a,bool)),fun(fun(a,fun(state,bool)),bool)),combb(fun(a,bool),bool,fun(a,fun(state,bool))),fAll(a)))),aa(fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool)))),aa(fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool)))),fun(fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool))))),combb(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool))),fun(a,fun(state,bool))),aa(fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,bool))),fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,bool)))),combb(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,bool)),com1),aa(fun(fun(a,fun(state,bool)),fun(a,bool)),fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,bool))),combb(fun(a,fun(state,bool)),fun(a,bool),fun(a,fun(state,bool))),aa(fun(fun(state,bool),bool),fun(fun(a,fun(state,bool)),fun(a,bool)),combb(fun(state,bool),bool,a),fAll(state))))),aa(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),aa(fun(fun(a,fun(state,bool)),fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))))),fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))))),combc(fun(a,fun(state,bool)),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),aa(fun(fun(a,fun(state,bool)),fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),fun(fun(a,fun(state,bool)),fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))))),aa(fun(fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))))),fun(fun(fun(a,fun(state,bool)),fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),fun(fun(a,fun(state,bool)),fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))))),combb(fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),fun(a,fun(state,bool))),combb(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),com1)),aa(fun(fun(a,fun(state,bool)),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(fun(a,fun(state,bool)),fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),aa(fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),fun(fun(fun(a,fun(state,bool)),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(fun(a,fun(state,bool)),fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))))),combb(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(a,fun(state,bool))),combb(fun(a,fun(state,bool)),fun(a,fun(state,bool)),fun(a,fun(state,bool)))),aa(fun(fun(a,fun(state,bool)),fun(a,fun(fun(state,bool),fun(state,bool)))),fun(fun(a,fun(state,bool)),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),aa(fun(fun(a,fun(fun(state,bool),fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(fun(fun(a,fun(state,bool)),fun(a,fun(fun(state,bool),fun(state,bool)))),fun(fun(a,fun(state,bool)),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),combb(fun(a,fun(fun(state,bool),fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),fun(a,fun(state,bool))),combs(a,fun(state,bool),fun(state,bool))),aa(fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(bool,bool)))),fun(fun(a,fun(state,bool)),fun(a,fun(fun(state,bool),fun(state,bool)))),aa(fun(fun(a,fun(state,fun(bool,bool))),fun(a,fun(fun(state,bool),fun(state,bool)))),fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(bool,bool)))),fun(fun(a,fun(state,bool)),fun(a,fun(fun(state,bool),fun(state,bool))))),combb(fun(a,fun(state,fun(bool,bool))),fun(a,fun(fun(state,bool),fun(state,bool))),fun(a,fun(state,bool))),aa(fun(fun(state,fun(bool,bool)),fun(fun(state,bool),fun(state,bool))),fun(fun(a,fun(state,fun(bool,bool))),fun(a,fun(fun(state,bool),fun(state,bool)))),combb(fun(state,fun(bool,bool)),fun(fun(state,bool),fun(state,bool)),a),combs(state,bool,bool))),aa(fun(fun(state,bool),fun(state,fun(bool,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(bool,bool)))),combb(fun(state,bool),fun(state,fun(bool,bool)),a),aa(fun(bool,fun(bool,bool)),fun(fun(state,bool),fun(state,fun(bool,bool))),combb(bool,fun(bool,bool),state),fimplies))))))),aa(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(state,bool))))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),aa(fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(state,bool)))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),fun(fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(state,bool))))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))))),combb(fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(state,bool)))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool))),com1),aa(fun(fun(a,fun(state,fun(state,bool))),fun(a,fun(state,bool))),fun(fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(state,bool)))),fun(fun(a,fun(state,bool)),fun(a,fun(state,bool)))),combb(fun(a,fun(state,fun(state,bool))),fun(a,fun(state,bool)),fun(a,fun(state,bool))),aa(fun(fun(state,fun(state,bool)),fun(state,bool)),fun(fun(a,fun(state,fun(state,bool))),fun(a,fun(state,bool))),combb(fun(state,fun(state,bool)),fun(state,bool),a),aa(fun(fun(state,bool),bool),fun(fun(state,fun(state,bool)),fun(state,bool)),combb(fun(state,bool),bool,state),fAll(state))))),aa(fun(com1,fun(fun(state,bool),fun(state,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(state,bool))))),aa(fun(fun(fun(state,bool),fun(state,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(state,bool))))),fun(fun(com1,fun(fun(state,bool),fun(state,fun(state,bool)))),fun(com1,fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(state,bool)))))),combb(fun(fun(state,bool),fun(state,fun(state,bool))),fun(fun(a,fun(state,bool)),fun(a,fun(state,fun(state,bool)))),com1),combb(fun(state,bool),fun(state,fun(state,bool)),a)),aa(fun(com1,fun(state,fun(fun(state,bool),fun(state,bool)))),fun(com1,fun(fun(state,bool),fun(state,fun(state,bool)))),aa(fun(fun(state,fun(fun(state,bool),fun(state,bool))),fun(fun(state,bool),fun(state,fun(state,bool)))),fun(fun(com1,fun(state,fun(fun(state,bool),fun(state,bool)))),fun(com1,fun(fun(state,bool),fun(state,fun(state,bool))))),combb(fun(state,fun(fun(state,bool),fun(state,bool))),fun(fun(state,bool),fun(state,fun(state,bool))),com1),combc(state,fun(state,bool),fun(state,bool))),aa(fun(com1,fun(state,fun(state,fun(bool,bool)))),fun(com1,fun(state,fun(fun(state,bool),fun(state,bool)))),aa(fun(fun(state,fun(state,fun(bool,bool))),fun(state,fun(fun(state,bool),fun(state,bool)))),fun(fun(com1,fun(state,fun(state,fun(bool,bool)))),fun(com1,fun(state,fun(fun(state,bool),fun(state,bool))))),combb(fun(state,fun(state,fun(bool,bool))),fun(state,fun(fun(state,bool),fun(state,bool))),com1),aa(fun(fun(state,fun(bool,bool)),fun(fun(state,bool),fun(state,bool))),fun(fun(state,fun(state,fun(bool,bool))),fun(state,fun(fun(state,bool),fun(state,bool)))),combb(fun(state,fun(bool,bool)),fun(fun(state,bool),fun(state,bool)),state),combs(state,bool,bool))),aa(fun(com1,fun(state,fun(state,bool))),fun(com1,fun(state,fun(state,fun(bool,bool)))),aa(fun(fun(state,fun(state,bool)),fun(state,fun(state,fun(bool,bool)))),fun(fun(com1,fun(state,fun(state,bool))),fun(com1,fun(state,fun(state,fun(bool,bool))))),combb(fun(state,fun(state,bool)),fun(state,fun(state,fun(bool,bool))),com1),aa(fun(fun(state,bool),fun(state,fun(bool,bool))),fun(fun(state,fun(state,bool)),fun(state,fun(state,fun(bool,bool)))),combb(fun(state,bool),fun(state,fun(bool,bool)),state),aa(fun(bool,fun(bool,bool)),fun(fun(state,bool),fun(state,fun(bool,bool))),combb(bool,fun(bool,bool),state),fimplies))),aa(nat,fun(com1,fun(state,fun(state,bool))),aa(fun(com1,fun(nat,fun(state,fun(state,bool)))),fun(nat,fun(com1,fun(state,fun(state,bool)))),combc(com1,nat,fun(state,fun(state,bool))),aa(fun(com1,fun(state,fun(nat,fun(state,bool)))),fun(com1,fun(nat,fun(state,fun(state,bool)))),aa(fun(fun(state,fun(nat,fun(state,bool))),fun(nat,fun(state,fun(state,bool)))),fun(fun(com1,fun(state,fun(nat,fun(state,bool)))),fun(com1,fun(nat,fun(state,fun(state,bool))))),combb(fun(state,fun(nat,fun(state,bool))),fun(nat,fun(state,fun(state,bool))),com1),combc(state,nat,fun(state,bool))),evaln)),n))))))))),hoare_1841697145triple(a,fun1,com,fun2))) ) ).

%------------------------------------------------------------------------------
