%------------------------------------------------------------------------------
% File     : SWW503_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fundamental Theorem of Algebra line 235
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fta_235 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  228 (  88 unt;  54 typ;   0 def)
%            Number of atoms       :  367 (  85 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  225 (  32   ~;   7   |;  21   &)
%                                         (  30 <=>; 135  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   4 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   16 (  10   >;   6   *;   0   +;   0  <<)
%            Number of predicates  :   36 (  35 usr;   0 prp; 1-3 aty)
%            Number of functors    :   15 (  15 usr;   6 con; 0-3 aty)
%            Number of variables   :  292 ( 248   !;   2   ?; 292   :)
%                                         (  42  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:17:55
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_RealDef_Oreal,type,
    real: $tType ).

%----Explicit typings (50)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield,type,
    field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__0,type,
    semiring_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Odivision__ring,type,
    division_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__field,type,
    real_field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Olinordered__field,type,
    linordered_field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield__inverse__zero,type,
    field_inverse_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__algebra__1,type,
    real_algebra_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__normed__field,type,
    real_normed_field: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__normed__vector,type,
    real_normed_vector: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__comm__monoid__add,type,
    ordere216010020id_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__normed__algebra__1,type,
    real_n2089651433ebra_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Odivision__ring__inverse__zero,type,
    divisi14063676e_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__normed__div__algebra,type,
    real_n1866405975lgebra: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Olinordered__field__inverse__zero,type,
    linord1117847801e_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__cancel__ab__semigroup__add,type,
    ordere223160158up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Fields_Oinverse__class_Odivide,type,
    inverse_divide: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_NthRoot_Oroot,type,
    root: ( nat * real ) > real ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Parity_Oeven__odd__class_Oeven,type,
    even_odd_even: 
      !>[A: $tType] : ( A > $o ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( ( A * nat ) > A ) ).

tff(sy_c_RealVector_Onorm__class_Onorm,type,
    norm_norm: 
      !>[A: $tType] : ( A > real ) ).

tff(sy_c_RealVector_Oof__real,type,
    of_real: 
      !>[A: $tType] : ( real > A ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_b,type,
    b: complex ).

tff(sy_v_n,type,
    n: nat ).

tff(sy_v_na____,type,
    na: nat ).

tff(sy_v_v____,type,
    v: complex ).

%----Relevant facts (98)
tff(fact_0__096root_An_A_Icmod_Ab_J_A_094_An_A_061_Acmod_Ab_096,axiom,
    power_power(real,root(na,norm_norm(complex,b)),na) = norm_norm(complex,b) ).

tff(fact_1_n,axiom,
    na != zero_zero(nat) ).

tff(fact_2_b,axiom,
    b != zero_zero(complex) ).

tff(fact_3_o,axiom,
    ~ even_odd_even(nat,na) ).

tff(fact_4_assms_I2_J,axiom,
    n != zero_zero(nat) ).

tff(fact_5_of__real__divide,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & real_field(A) )
     => ! [Y: real,X1: real] : ( of_real(A,inverse_divide(real,X1,Y)) = inverse_divide(A,of_real(A,X1),of_real(A,Y)) ) ) ).

tff(fact_6_of__real__power,axiom,
    ! [A: $tType] :
      ( real_algebra_1(A)
     => ! [N: nat,X1: real] : ( of_real(A,power_power(real,X1,N)) = power_power(A,of_real(A,X1),N) ) ) ).

tff(fact_7_th0,axiom,
    norm_norm(complex,inverse_divide(complex,of_real(complex,norm_norm(complex,b)),b)) = one_one(real) ).

tff(fact_8_complex__of__real__power,axiom,
    ! [N: nat,X1: real] : ( power_power(complex,of_real(complex,X1),N) = of_real(complex,power_power(real,X1,N)) ) ).

tff(fact_9_of__real__eq__iff,axiom,
    ! [A: $tType] :
      ( real_algebra_1(A)
     => ! [Y1: real,X: real] :
          ( ( of_real(A,X) = of_real(A,Y1) )
        <=> ( X = Y1 ) ) ) ).

tff(fact_10_v,axiom,
    ord_less(real,norm_norm(complex,plus_plus(complex,inverse_divide(complex,of_real(complex,norm_norm(complex,b)),b),power_power(complex,v,na))),one_one(real)) ).

tff(fact_11_norm__divide,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & real_normed_field(A) )
     => ! [B: A,A1: A] : ( norm_norm(A,inverse_divide(A,A1,B)) = inverse_divide(real,norm_norm(A,A1),norm_norm(A,B)) ) ) ).

tff(fact_12_norm__power,axiom,
    ! [A: $tType] :
      ( real_n1866405975lgebra(A)
     => ! [N: nat,X1: A] : ( norm_norm(A,power_power(A,X1,N)) = power_power(real,norm_norm(A,X1),N) ) ) ).

tff(fact_13_power__divide,axiom,
    ! [A: $tType] :
      ( field_inverse_zero(A)
     => ! [N: nat,B: A,A1: A] : ( power_power(A,inverse_divide(A,A1,B),N) = inverse_divide(A,power_power(A,A1,N),power_power(A,B,N)) ) ) ).

tff(fact_14__096EX_Av_O_Acmod_A_Icomplex__of__real_A_Icmod_Ab_J_A_P_Ab_A_L_Av_A_094_An_J_A_060_A1_096,axiom,
    ? [V: complex] : ord_less(real,norm_norm(complex,plus_plus(complex,inverse_divide(complex,of_real(complex,norm_norm(complex,b)),b),power_power(complex,V,na))),one_one(real)) ).

tff(fact_15__096_B_Bthesis_O_A_I_B_Bv_O_Acmod_A_Icomplex__of__real_A_Icmod_Ab_J_A_P_Ab_A_L_Av_A_094_An_J_A_060_A1_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [V: complex] : ~ ord_less(real,norm_norm(complex,plus_plus(complex,inverse_divide(complex,of_real(complex,norm_norm(complex,b)),b),power_power(complex,V,na))),one_one(real)) ).

tff(fact_16_power__one,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat] : ( power_power(A,one_one(A),N) = one_one(A) ) ) ).

tff(fact_17_norm__zero,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ( norm_norm(A,zero_zero(A)) = zero_zero(real) ) ) ).

tff(fact_18_norm__eq__zero,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ! [X: A] :
          ( ( norm_norm(A,X) = zero_zero(real) )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_19_of__real__0,axiom,
    ! [A: $tType] :
      ( real_algebra_1(A)
     => ( of_real(A,zero_zero(real)) = zero_zero(A) ) ) ).

tff(fact_20_of__real__eq__0__iff,axiom,
    ! [A: $tType] :
      ( real_algebra_1(A)
     => ! [X: real] :
          ( ( of_real(A,X) = zero_zero(A) )
        <=> ( X = zero_zero(real) ) ) ) ).

tff(fact_21_of__real__add,axiom,
    ! [A: $tType] :
      ( real_algebra_1(A)
     => ! [Y: real,X1: real] : ( of_real(A,plus_plus(real,X1,Y)) = plus_plus(A,of_real(A,X1),of_real(A,Y)) ) ) ).

tff(fact_22_power__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [Nb: nat,A2: A] :
          ( ( power_power(A,A2,Nb) = zero_zero(A) )
        <=> ( ( A2 = zero_zero(A) )
            & ( Nb != zero_zero(nat) ) ) ) ) ).

tff(fact_23_power__0,axiom,
    ! [A: $tType] :
      ( power(A)
     => ! [A1: A] : ( power_power(A,A1,zero_zero(nat)) = one_one(A) ) ) ).

tff(fact_24_zero__less__norm__iff,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ! [X: A] :
          ( ord_less(real,zero_zero(real),norm_norm(A,X))
        <=> ( X != zero_zero(A) ) ) ) ).

tff(fact_25_norm__one,axiom,
    ! [A: $tType] :
      ( real_n2089651433ebra_1(A)
     => ( norm_norm(A,one_one(A)) = one_one(real) ) ) ).

tff(fact_26_of__real__1,axiom,
    ! [A: $tType] :
      ( real_algebra_1(A)
     => ( of_real(A,one_one(real)) = one_one(A) ) ) ).

tff(fact_27_power__0__left,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & semiring_0(A) )
     => ! [N: nat] :
          ( ( ( N = zero_zero(nat) )
           => ( power_power(A,zero_zero(A),N) = one_one(A) ) )
          & ( ( N != zero_zero(nat) )
           => ( power_power(A,zero_zero(A),N) = zero_zero(A) ) ) ) ) ).

tff(fact_28_zero__less__power,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ord_less(A,zero_zero(A),power_power(A,A1,N)) ) ) ).

tff(fact_29_power__inject__exp,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Nb: nat,Ma: nat,A2: A] :
          ( ord_less(A,one_one(A),A2)
         => ( ( power_power(A,A2,Ma) = power_power(A,A2,Nb) )
          <=> ( Ma = Nb ) ) ) ) ).

tff(fact_30_power__strict__increasing__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Y1: nat,X: nat,Ba: A] :
          ( ord_less(A,one_one(A),Ba)
         => ( ord_less(A,power_power(A,Ba,X),power_power(A,Ba,Y1))
          <=> ord_less(nat,X,Y1) ) ) ) ).

tff(fact_31_one__less__power,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A1: A] :
          ( ord_less(A,one_one(A),A1)
         => ( ord_less(nat,zero_zero(nat),N)
           => ord_less(A,one_one(A),power_power(A,A1,N)) ) ) ) ).

tff(fact_32_power__less__imp__less__exp,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,M1: nat,A1: A] :
          ( ord_less(A,one_one(A),A1)
         => ( ord_less(A,power_power(A,A1,M1),power_power(A,A1,N))
           => ord_less(nat,M1,N) ) ) ) ).

tff(fact_33_power__strict__increasing,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [A1: A,N1: nat,N: nat] :
          ( ord_less(nat,N,N1)
         => ( ord_less(A,one_one(A),A1)
           => ord_less(A,power_power(A,A1,N),power_power(A,A1,N1)) ) ) ) ).

tff(fact_34_power__strict__decreasing,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [A1: A,N1: nat,N: nat] :
          ( ord_less(nat,N,N1)
         => ( ord_less(A,zero_zero(A),A1)
           => ( ord_less(A,A1,one_one(A))
             => ord_less(A,power_power(A,A1,N1),power_power(A,A1,N)) ) ) ) ) ).

tff(fact_35_norm__add__less,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ! [S: real,Y: A,R: real,X1: A] :
          ( ord_less(real,norm_norm(A,X1),R)
         => ( ord_less(real,norm_norm(A,Y),S)
           => ord_less(real,norm_norm(A,plus_plus(A,X1,Y)),plus_plus(real,R,S)) ) ) ) ).

tff(fact_36_field__power__not__zero,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [N: nat,A1: A] :
          ( ( A1 != zero_zero(A) )
         => ( power_power(A,A1,N) != zero_zero(A) ) ) ) ).

tff(fact_37_power__one__over,axiom,
    ! [A: $tType] :
      ( field_inverse_zero(A)
     => ! [N: nat,A1: A] : ( inverse_divide(A,one_one(A),power_power(A,A1,N)) = power_power(A,inverse_divide(A,one_one(A),A1),N) ) ) ).

tff(fact_38_nonzero__power__divide,axiom,
    ! [A: $tType] :
      ( field(A)
     => ! [N: nat,A1: A,B: A] :
          ( ( B != zero_zero(A) )
         => ( power_power(A,inverse_divide(A,A1,B),N) = inverse_divide(A,power_power(A,A1,N),power_power(A,B,N)) ) ) ) ).

tff(fact_39_nonzero__norm__divide,axiom,
    ! [A: $tType] :
      ( real_normed_field(A)
     => ! [A1: A,B: A] :
          ( ( B != zero_zero(A) )
         => ( norm_norm(A,inverse_divide(A,A1,B)) = inverse_divide(real,norm_norm(A,A1),norm_norm(A,B)) ) ) ) ).

tff(fact_40_divide__self__if,axiom,
    ! [A: $tType] :
      ( divisi14063676e_zero(A)
     => ! [A1: A] :
          ( ( ( A1 = zero_zero(A) )
           => ( inverse_divide(A,A1,A1) = zero_zero(A) ) )
          & ( ( A1 != zero_zero(A) )
           => ( inverse_divide(A,A1,A1) = one_one(A) ) ) ) ) ).

tff(fact_41_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ord_less(A,zero_zero(A),plus_plus(A,A2,A2))
        <=> ord_less(A,zero_zero(A),A2) ) ) ).

tff(fact_42_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ord_less(A,plus_plus(A,A2,A2),zero_zero(A))
        <=> ord_less(A,A2,zero_zero(A)) ) ) ).

tff(fact_43_zero__less__power__eq,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Nb: nat,X: A] :
          ( ord_less(A,zero_zero(A),power_power(A,X,Nb))
        <=> ( ( Nb = zero_zero(nat) )
            | ( even_odd_even(nat,Nb)
              & ( X != zero_zero(A) ) )
            | ( ~ even_odd_even(nat,Nb)
              & ord_less(A,zero_zero(A),X) ) ) ) ) ).

tff(fact_44_divide__zero,axiom,
    ! [A: $tType] :
      ( divisi14063676e_zero(A)
     => ! [A1: A] : ( inverse_divide(A,A1,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_45_divide__zero__left,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A1: A] : ( inverse_divide(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_46_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [Ba: A,C: A,A2: A] :
          ( ord_less(A,plus_plus(A,A2,C),plus_plus(A,Ba,C))
        <=> ord_less(A,A2,Ba) ) ) ).

tff(fact_47_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [Ba: A,A2: A,C: A] :
          ( ord_less(A,plus_plus(A,C,A2),plus_plus(A,C,Ba))
        <=> ord_less(A,A2,Ba) ) ) ).

tff(fact_48_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A2: A,Ba: A] :
          ( ( plus_plus(A,Ba,A2) = plus_plus(A,C,A2) )
        <=> ( Ba = C ) ) ) ).

tff(fact_49_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,Ba: A,A2: A] :
          ( ( plus_plus(A,A2,Ba) = plus_plus(A,A2,C) )
        <=> ( Ba = C ) ) ) ).

tff(fact_50_even__sum__nat,axiom,
    ! [Y1: nat,X: nat] :
      ( even_odd_even(nat,plus_plus(nat,X,Y1))
    <=> ( ( even_odd_even(nat,X)
          & even_odd_even(nat,Y1) )
        | ( ~ even_odd_even(nat,X)
          & ~ even_odd_even(nat,Y1) ) ) ) ).

tff(fact_51_even__add,axiom,
    ! [Nb: nat,Ma: nat] :
      ( even_odd_even(nat,plus_plus(nat,Ma,Nb))
    <=> ( even_odd_even(nat,Ma)
      <=> even_odd_even(nat,Nb) ) ) ).

tff(fact_52_odd__add,axiom,
    ! [Nb: nat,Ma: nat] :
      ( ~ even_odd_even(nat,plus_plus(nat,Ma,Nb))
    <=> ~ ( ~ even_odd_even(nat,Ma)
        <=> ~ even_odd_even(nat,Nb) ) ) ).

tff(fact_53_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ( zero_zero(A) = plus_plus(A,A2,A2) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_54_nat__zero__less__power__iff,axiom,
    ! [Nb: nat,X: nat] :
      ( ord_less(nat,zero_zero(nat),power_power(nat,X,Nb))
    <=> ( ord_less(nat,zero_zero(nat),X)
        | ( Nb = zero_zero(nat) ) ) ) ).

tff(fact_55_even__power__nat,axiom,
    ! [Y1: nat,X: nat] :
      ( even_odd_even(nat,power_power(nat,X,Y1))
    <=> ( even_odd_even(nat,X)
        & ord_less(nat,zero_zero(nat),Y1) ) ) ).

tff(fact_56_zero__less__power__nat__eq,axiom,
    ! [Nb: nat,X: nat] :
      ( ord_less(nat,zero_zero(nat),power_power(nat,X,Nb))
    <=> ( ( Nb = zero_zero(nat) )
        | ord_less(nat,zero_zero(nat),X) ) ) ).

tff(fact_57_odd__1__nat,axiom,
    ~ even_odd_even(nat,one_one(nat)) ).

tff(fact_58_nat__power__less__imp__less,axiom,
    ! [N: nat,M1: nat,I: nat] :
      ( ord_less(nat,zero_zero(nat),I)
     => ( ord_less(nat,power_power(nat,I,M1),power_power(nat,I,N))
       => ord_less(nat,M1,N) ) ) ).

tff(fact_59_power__one__right,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( power_power(A,A1,one_one(nat)) = A1 ) ) ).

tff(fact_60_odd__pos,axiom,
    ! [N: nat] :
      ( ~ even_odd_even(nat,N)
     => ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_61_norm__not__less__zero,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ! [X1: A] : ~ ord_less(real,norm_norm(A,X1),zero_zero(real)) ) ).

tff(fact_62_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_63_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A1: A,B: A] :
          ( ( plus_plus(A,B,A1) = plus_plus(A,C1,A1) )
         => ( B = C1 ) ) ) ).

tff(fact_64_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C1: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C1) )
         => ( B = C1 ) ) ) ).

tff(fact_65_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C1) )
         => ( B = C1 ) ) ) ).

tff(fact_66_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C1: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C1) = plus_plus(A,A1,plus_plus(A,B,C1)) ) ) ).

tff(fact_67_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X: A] :
          ( ( one_one(A) = X )
        <=> ( X = one_one(A) ) ) ) ).

tff(fact_68_nonzero__of__real__divide,axiom,
    ! [A: $tType] :
      ( real_field(A)
     => ! [X1: real,Y: real] :
          ( ( Y != zero_zero(real) )
         => ( of_real(A,inverse_divide(real,X1,Y)) = inverse_divide(A,of_real(A,X1),of_real(A,Y)) ) ) ) ).

tff(fact_69_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_70_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_71_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_72_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_73_add__less__imp__less__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,A1: A,C1: A] :
          ( ord_less(A,plus_plus(A,C1,A1),plus_plus(A,C1,B))
         => ord_less(A,A1,B) ) ) ).

tff(fact_74_add__less__imp__less__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,C1: A,A1: A] :
          ( ord_less(A,plus_plus(A,A1,C1),plus_plus(A,B,C1))
         => ord_less(A,A1,B) ) ) ).

tff(fact_75_add__strict__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [D: A,C1: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ( ord_less(A,C1,D)
           => ord_less(A,plus_plus(A,A1,C1),plus_plus(A,B,D)) ) ) ) ).

tff(fact_76_add__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C1: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,plus_plus(A,C1,A1),plus_plus(A,C1,B)) ) ) ).

tff(fact_77_add__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C1: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,plus_plus(A,A1,C1),plus_plus(A,B,C1)) ) ) ).

tff(fact_78_add__divide__distrib,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [C1: A,B: A,A1: A] : ( inverse_divide(A,plus_plus(A,A1,B),C1) = plus_plus(A,inverse_divide(A,A1,C1),inverse_divide(A,B,C1)) ) ) ).

tff(fact_79_divide__1,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A1: A] : ( inverse_divide(A,A1,one_one(A)) = A1 ) ) ).

tff(fact_80_even__zero__nat,axiom,
    even_odd_even(nat,zero_zero(nat)) ).

tff(fact_81_add__neg__neg,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,A1,zero_zero(A))
         => ( ord_less(A,B,zero_zero(A))
           => ord_less(A,plus_plus(A,A1,B),zero_zero(A)) ) ) ) ).

tff(fact_82_add__pos__pos,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( ord_less(A,zero_zero(A),B)
           => ord_less(A,zero_zero(A),plus_plus(A,A1,B)) ) ) ) ).

tff(fact_83_divide__strict__right__mono__neg,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [C1: A,A1: A,B: A] :
          ( ord_less(A,B,A1)
         => ( ord_less(A,C1,zero_zero(A))
           => ord_less(A,inverse_divide(A,A1,C1),inverse_divide(A,B,C1)) ) ) ) ).

tff(fact_84_divide__strict__right__mono,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [C1: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ( ord_less(A,zero_zero(A),C1)
           => ord_less(A,inverse_divide(A,A1,C1),inverse_divide(A,B,C1)) ) ) ) ).

tff(fact_85_divide__neg__neg,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y: A,X1: A] :
          ( ord_less(A,X1,zero_zero(A))
         => ( ord_less(A,Y,zero_zero(A))
           => ord_less(A,zero_zero(A),inverse_divide(A,X1,Y)) ) ) ) ).

tff(fact_86_divide__neg__pos,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y: A,X1: A] :
          ( ord_less(A,X1,zero_zero(A))
         => ( ord_less(A,zero_zero(A),Y)
           => ord_less(A,inverse_divide(A,X1,Y),zero_zero(A)) ) ) ) ).

tff(fact_87_divide__pos__neg,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y: A,X1: A] :
          ( ord_less(A,zero_zero(A),X1)
         => ( ord_less(A,Y,zero_zero(A))
           => ord_less(A,inverse_divide(A,X1,Y),zero_zero(A)) ) ) ) ).

tff(fact_88_divide__pos__pos,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y: A,X1: A] :
          ( ord_less(A,zero_zero(A),X1)
         => ( ord_less(A,zero_zero(A),Y)
           => ord_less(A,zero_zero(A),inverse_divide(A,X1,Y)) ) ) ) ).

tff(fact_89_divide__less__cancel,axiom,
    ! [A: $tType] :
      ( linord1117847801e_zero(A)
     => ! [Ba: A,C: A,A2: A] :
          ( ord_less(A,inverse_divide(A,A2,C),inverse_divide(A,Ba,C))
        <=> ( ( ord_less(A,zero_zero(A),C)
             => ord_less(A,A2,Ba) )
            & ( ord_less(A,C,zero_zero(A))
             => ord_less(A,Ba,A2) )
            & ( C != zero_zero(A) ) ) ) ) ).

tff(fact_90_divide__less__0__iff,axiom,
    ! [A: $tType] :
      ( linord1117847801e_zero(A)
     => ! [Ba: A,A2: A] :
          ( ord_less(A,inverse_divide(A,A2,Ba),zero_zero(A))
        <=> ( ( ord_less(A,zero_zero(A),A2)
              & ord_less(A,Ba,zero_zero(A)) )
            | ( ord_less(A,A2,zero_zero(A))
              & ord_less(A,zero_zero(A),Ba) ) ) ) ) ).

tff(fact_91_zero__less__divide__iff,axiom,
    ! [A: $tType] :
      ( linord1117847801e_zero(A)
     => ! [Ba: A,A2: A] :
          ( ord_less(A,zero_zero(A),inverse_divide(A,A2,Ba))
        <=> ( ( ord_less(A,zero_zero(A),A2)
              & ord_less(A,zero_zero(A),Ba) )
            | ( ord_less(A,A2,zero_zero(A))
              & ord_less(A,Ba,zero_zero(A)) ) ) ) ) ).

tff(fact_92_right__inverse__eq,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A2: A,Ba: A] :
          ( ( Ba != zero_zero(A) )
         => ( ( inverse_divide(A,A2,Ba) = one_one(A) )
          <=> ( A2 = Ba ) ) ) ) ).

tff(fact_93_divide__self,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A1: A] :
          ( ( A1 != zero_zero(A) )
         => ( inverse_divide(A,A1,A1) = one_one(A) ) ) ) ).

tff(fact_94_gt__half__sum,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,inverse_divide(A,plus_plus(A,A1,B),plus_plus(A,one_one(A),one_one(A))),B) ) ) ).

tff(fact_95_less__half__sum,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,A1,inverse_divide(A,plus_plus(A,A1,B),plus_plus(A,one_one(A),one_one(A)))) ) ) ).

tff(fact_96_power__less__zero__eq,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Nb: nat,X: A] :
          ( ord_less(A,power_power(A,X,Nb),zero_zero(A))
        <=> ( ~ even_odd_even(nat,Nb)
            & ord_less(A,X,zero_zero(A)) ) ) ) ).

tff(fact_97_IH,axiom,
    ! [M: nat] :
      ( ord_less(nat,M,na)
     => ( ( M != zero_zero(nat) )
       => ? [Z: complex] : ord_less(real,norm_norm(complex,plus_plus(complex,one_one(complex),times_times(complex,b,power_power(complex,Z,M)))),one_one(real)) ) ) ).

%----Arities (73)
tff(arity_Nat_Onat___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__0,axiom,
    semiring_0(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Power_Opower,axiom,
    power(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_RealDef_Oreal___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add(real) ).

tff(arity_RealDef_Oreal___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(real) ).

tff(arity_RealDef_Oreal___Fields_Olinordered__field__inverse__zero,axiom,
    linord1117847801e_zero(real) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__normed__div__algebra,axiom,
    real_n1866405975lgebra(real) ).

tff(arity_RealDef_Oreal___Fields_Odivision__ring__inverse__zero,axiom,
    divisi14063676e_zero(real) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__normed__algebra__1,axiom,
    real_n2089651433ebra_1(real) ).

tff(arity_RealDef_Oreal___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add(real) ).

tff(arity_RealDef_Oreal___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(real) ).

tff(arity_RealDef_Oreal___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(real) ).

tff(arity_RealDef_Oreal___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(real) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__normed__vector,axiom,
    real_normed_vector(real) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__normed__field,axiom,
    real_normed_field(real) ).

tff(arity_RealDef_Oreal___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(real) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__algebra__1,axiom,
    real_algebra_1(real) ).

tff(arity_RealDef_Oreal___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(real) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__semidom,axiom,
    linordered_semidom(real) ).

tff(arity_RealDef_Oreal___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(real) ).

tff(arity_RealDef_Oreal___Fields_Olinordered__field,axiom,
    linordered_field(real) ).

tff(arity_RealDef_Oreal___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(real) ).

tff(arity_RealDef_Oreal___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(real) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__idom,axiom,
    linordered_idom(real) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__field,axiom,
    real_field(real) ).

tff(arity_RealDef_Oreal___Fields_Odivision__ring,axiom,
    division_ring(real) ).

tff(arity_RealDef_Oreal___Rings_Ozero__neq__one,axiom,
    zero_neq_one(real) ).

tff(arity_RealDef_Oreal___Groups_Omonoid__mult,axiom,
    monoid_mult(real) ).

tff(arity_RealDef_Oreal___Groups_Omonoid__add,axiom,
    monoid_add(real) ).

tff(arity_RealDef_Oreal___Rings_Osemiring__0,axiom,
    semiring_0(real) ).

tff(arity_RealDef_Oreal___Rings_Omult__zero,axiom,
    mult_zero(real) ).

tff(arity_RealDef_Oreal___Fields_Ofield,axiom,
    field(real) ).

tff(arity_RealDef_Oreal___Power_Opower,axiom,
    power(real) ).

tff(arity_RealDef_Oreal___Groups_Ozero,axiom,
    zero(real) ).

tff(arity_RealDef_Oreal___Groups_Oone,axiom,
    one(real) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__normed__div__algebra,axiom,
    real_n1866405975lgebra(complex) ).

tff(arity_Complex_Ocomplex___Fields_Odivision__ring__inverse__zero,axiom,
    divisi14063676e_zero(complex) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__normed__algebra__1,axiom,
    real_n2089651433ebra_1(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(complex) ).

tff(arity_Complex_Ocomplex___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(complex) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__normed__vector,axiom,
    real_normed_vector(complex) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__normed__field,axiom,
    real_normed_field(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(complex) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__algebra__1,axiom,
    real_algebra_1(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(complex) ).

tff(arity_Complex_Ocomplex___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(complex) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__field,axiom,
    real_field(complex) ).

tff(arity_Complex_Ocomplex___Fields_Odivision__ring,axiom,
    division_ring(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ozero__neq__one,axiom,
    zero_neq_one(complex) ).

tff(arity_Complex_Ocomplex___Groups_Omonoid__mult,axiom,
    monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Groups_Omonoid__add,axiom,
    monoid_add(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__0,axiom,
    semiring_0(complex) ).

tff(arity_Complex_Ocomplex___Rings_Omult__zero,axiom,
    mult_zero(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield,axiom,
    field(complex) ).

tff(arity_Complex_Ocomplex___Power_Opower,axiom,
    power(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ozero,axiom,
    zero(complex) ).

tff(arity_Complex_Ocomplex___Groups_Oone,axiom,
    one(complex) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    power_power(complex,inverse_divide(complex,v,of_real(complex,root(na,norm_norm(complex,b)))),na) = inverse_divide(complex,power_power(complex,v,na),of_real(complex,norm_norm(complex,b))) ).

%------------------------------------------------------------------------------
