%------------------------------------------------------------------------------
% File     : SWW502_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fundamental Theorem of Algebra line 227
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fta_227 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  244 (  98 unt;  57 typ;   0 def)
%            Number of atoms       :  362 (  98 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  196 (  21   ~;   9   |;  12   &)
%                                         (  24 <=>; 130  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   3 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   16 (  10   >;   6   *;   0   +;   0  <<)
%            Number of predicates  :   39 (  37 usr;   1 prp; 0-3 aty)
%            Number of functors    :   16 (  16 usr;   7 con; 0-3 aty)
%            Number of variables   :  306 ( 258   !;   3   ?; 306   :)
%                                         (  45  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:17:47
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_RealDef_Oreal,type,
    real: $tType ).

%----Explicit typings (53)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield,type,
    field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__0,type,
    semiring_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__field,type,
    real_field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__mult,type,
    comm_monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield__inverse__zero,type,
    field_inverse_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__algebra__1,type,
    real_algebra_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__normed__field,type,
    real_normed_field: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__normed__vector,type,
    real_normed_vector: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__comm__monoid__add,type,
    ordere216010020id_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__normed__algebra,type,
    real_normed_algebra: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__normed__algebra__1,type,
    real_n2089651433ebra_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Odivision__ring__inverse__zero,type,
    divisi14063676e_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__normed__div__algebra,type,
    real_n1866405975lgebra: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__cancel__ab__semigroup__add,type,
    ordere223160158up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Complex_Oii,type,
    ii: complex ).

tff(sy_c_Fields_Oinverse__class_Odivide,type,
    inverse_divide: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Parity_Oeven__odd__class_Oeven,type,
    even_odd_even: 
      !>[A: $tType] : ( A > $o ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( ( A * nat ) > A ) ).

tff(sy_c_RealVector_Onorm__class_Onorm,type,
    norm_norm: 
      !>[A: $tType] : ( A > real ) ).

tff(sy_c_RealVector_Oof__real,type,
    of_real: 
      !>[A: $tType] : ( real > A ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_b,type,
    b: complex ).

tff(sy_v_m____,type,
    m: nat ).

tff(sy_v_n,type,
    n: nat ).

tff(sy_v_na____,type,
    na: nat ).

%----Relevant facts (98)
tff(fact_0_o,axiom,
    ~ even_odd_even(nat,na) ).

tff(fact_1_n,axiom,
    na != zero_zero(nat) ).

tff(fact_2_b,axiom,
    b != zero_zero(complex) ).

tff(fact_3_th0,axiom,
    norm_norm(complex,inverse_divide(complex,of_real(complex,norm_norm(complex,b)),b)) = one_one(real) ).

tff(fact_4__096cmod_A_Icomplex__of__real_A_Icmod_Ab_J_A_P_Ab_A_L_A1_J_A_060_A1_A_124cmod_A_Icomplex__of__real_A_Icmod_Ab_J_A_P_Ab_A_N_A1_J_A_060_A1_A_124cmod_A_Icomplex__of__real_A_Icmod_Ab_J_A_P_Ab_A_L_A_092_060i_062_J_A_060_A1_A_124cmod_A_Icomplex__of__real_A_Icmod_Ab_J_A_P_Ab_A_N_A_092_060i_062_J_A_060_A1_096,axiom,
    ( ord_less(real,norm_norm(complex,plus_plus(complex,inverse_divide(complex,of_real(complex,norm_norm(complex,b)),b),one_one(complex))),one_one(real))
    | ord_less(real,norm_norm(complex,minus_minus(complex,inverse_divide(complex,of_real(complex,norm_norm(complex,b)),b),one_one(complex))),one_one(real))
    | ord_less(real,norm_norm(complex,plus_plus(complex,inverse_divide(complex,of_real(complex,norm_norm(complex,b)),b),ii)),one_one(real))
    | ord_less(real,norm_norm(complex,minus_minus(complex,inverse_divide(complex,of_real(complex,norm_norm(complex,b)),b),ii)),one_one(real)) ) ).

tff(fact_5_unimodular__reduce__norm,axiom,
    ! [Z1: complex] :
      ( ( norm_norm(complex,Z1) = one_one(real) )
     => ( ord_less(real,norm_norm(complex,plus_plus(complex,Z1,one_one(complex))),one_one(real))
        | ord_less(real,norm_norm(complex,minus_minus(complex,Z1,one_one(complex))),one_one(real))
        | ord_less(real,norm_norm(complex,plus_plus(complex,Z1,ii)),one_one(real))
        | ord_less(real,norm_norm(complex,minus_minus(complex,Z1,ii)),one_one(real)) ) ) ).

tff(fact_6_assms_I2_J,axiom,
    n != zero_zero(nat) ).

tff(fact_7_norm__ii,axiom,
    norm_norm(complex,ii) = one_one(real) ).

tff(fact_8_of__real__1,axiom,
    ! [A: $tType] :
      ( real_algebra_1(A)
     => ( of_real(A,one_one(real)) = one_one(A) ) ) ).

tff(fact_9_norm__one,axiom,
    ! [A: $tType] :
      ( real_n2089651433ebra_1(A)
     => ( norm_norm(A,one_one(A)) = one_one(real) ) ) ).

tff(fact_10_of__real__divide,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & real_field(A) )
     => ! [Y1: real,X1: real] : ( of_real(A,inverse_divide(real,X1,Y1)) = inverse_divide(A,of_real(A,X1),of_real(A,Y1)) ) ) ).

tff(fact_11_calculation,axiom,
    ( even_odd_even(nat,na)
   => ? [Z: complex] : ord_less(real,norm_norm(complex,plus_plus(complex,one_one(complex),times_times(complex,b,power_power(complex,Z,na)))),one_one(real)) ) ).

tff(fact_12_of__real__power,axiom,
    ! [A: $tType] :
      ( real_algebra_1(A)
     => ! [N: nat,X1: real] : ( of_real(A,power_power(real,X1,N)) = power_power(A,of_real(A,X1),N) ) ) ).

tff(fact_13_of__real__diff,axiom,
    ! [A: $tType] :
      ( real_algebra_1(A)
     => ! [Y1: real,X1: real] : ( of_real(A,minus_minus(real,X1,Y1)) = minus_minus(A,of_real(A,X1),of_real(A,Y1)) ) ) ).

tff(fact_14_of__real__add,axiom,
    ! [A: $tType] :
      ( real_algebra_1(A)
     => ! [Y1: real,X1: real] : ( of_real(A,plus_plus(real,X1,Y1)) = plus_plus(A,of_real(A,X1),of_real(A,Y1)) ) ) ).

tff(fact_15_power__one,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat] : ( power_power(A,one_one(A),N) = one_one(A) ) ) ).

tff(fact_16_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [Ba: A,C: A,A2: A] :
          ( ord_less(A,plus_plus(A,A2,C),plus_plus(A,Ba,C))
        <=> ord_less(A,A2,Ba) ) ) ).

tff(fact_17_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [Ba: A,A2: A,C: A] :
          ( ord_less(A,plus_plus(A,C,A2),plus_plus(A,C,Ba))
        <=> ord_less(A,A2,Ba) ) ) ).

tff(fact_18_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A2: A,Ba: A] :
          ( ( plus_plus(A,Ba,A2) = plus_plus(A,C,A2) )
        <=> ( Ba = C ) ) ) ).

tff(fact_19_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,Ba: A,A2: A] :
          ( ( plus_plus(A,A2,Ba) = plus_plus(A,A2,C) )
        <=> ( Ba = C ) ) ) ).

tff(fact_20_nat__zero__less__power__iff,axiom,
    ! [Nb: nat,X: nat] :
      ( ord_less(nat,zero_zero(nat),power_power(nat,X,Nb))
    <=> ( ord_less(nat,zero_zero(nat),X)
        | ( Nb = zero_zero(nat) ) ) ) ).

tff(fact_21_of__real__eq__iff,axiom,
    ! [A: $tType] :
      ( real_algebra_1(A)
     => ! [Y: real,X: real] :
          ( ( of_real(A,X) = of_real(A,Y) )
        <=> ( X = Y ) ) ) ).

tff(fact_22_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ( zero_zero(A) = plus_plus(A,A2,A2) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_23_diff__self,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A1: A] : ( minus_minus(A,A1,A1) = zero_zero(A) ) ) ).

tff(fact_24_norm__zero,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ( norm_norm(A,zero_zero(A)) = zero_zero(real) ) ) ).

tff(fact_25_norm__eq__zero,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ! [X: A] :
          ( ( norm_norm(A,X) = zero_zero(real) )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_26_of__real__0,axiom,
    ! [A: $tType] :
      ( real_algebra_1(A)
     => ( of_real(A,zero_zero(real)) = zero_zero(A) ) ) ).

tff(fact_27_of__real__eq__0__iff,axiom,
    ! [A: $tType] :
      ( real_algebra_1(A)
     => ! [X: real] :
          ( ( of_real(A,X) = zero_zero(A) )
        <=> ( X = zero_zero(real) ) ) ) ).

tff(fact_28_of__real__mult,axiom,
    ! [A: $tType] :
      ( real_algebra_1(A)
     => ! [Y1: real,X1: real] : ( of_real(A,times_times(real,X1,Y1)) = times_times(A,of_real(A,X1),of_real(A,Y1)) ) ) ).

tff(fact_29_IH,axiom,
    ! [M1: nat] :
      ( ord_less(nat,M1,na)
     => ( ( M1 != zero_zero(nat) )
       => ? [Z: complex] : ord_less(real,norm_norm(complex,plus_plus(complex,one_one(complex),times_times(complex,b,power_power(complex,Z,M1)))),one_one(real)) ) ) ).

tff(fact_30_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ord_less(A,plus_plus(A,A2,A2),zero_zero(A))
        <=> ord_less(A,A2,zero_zero(A)) ) ) ).

tff(fact_31_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ord_less(A,zero_zero(A),plus_plus(A,A2,A2))
        <=> ord_less(A,zero_zero(A),A2) ) ) ).

tff(fact_32_power__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [Nb: nat,A2: A] :
          ( ( power_power(A,A2,Nb) = zero_zero(A) )
        <=> ( ( A2 = zero_zero(A) )
            & ( Nb != zero_zero(nat) ) ) ) ) ).

tff(fact_33_power__0,axiom,
    ! [A: $tType] :
      ( power(A)
     => ! [A1: A] : ( power_power(A,A1,zero_zero(nat)) = one_one(A) ) ) ).

tff(fact_34_zero__less__norm__iff,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ! [X: A] :
          ( ord_less(real,zero_zero(real),norm_norm(A,X))
        <=> ( X != zero_zero(A) ) ) ) ).

tff(fact_35_norm__mult,axiom,
    ! [A: $tType] :
      ( real_n1866405975lgebra(A)
     => ! [Y1: A,X1: A] : ( norm_norm(A,times_times(A,X1,Y1)) = times_times(real,norm_norm(A,X1),norm_norm(A,Y1)) ) ) ).

tff(fact_36_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_37_power__add,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,M: nat,A1: A] : ( power_power(A,A1,plus_plus(nat,M,N)) = times_times(A,power_power(A,A1,M),power_power(A,A1,N)) ) ) ).

tff(fact_38_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_mult(A)
     => ! [C1: A,B: A,A1: A] : ( times_times(A,times_times(A,A1,B),C1) = times_times(A,A1,times_times(A,B,C1)) ) ) ).

tff(fact_39_nat__power__less__imp__less,axiom,
    ! [N: nat,M: nat,I: nat] :
      ( ord_less(nat,zero_zero(nat),I)
     => ( ord_less(nat,power_power(nat,I,M),power_power(nat,I,N))
       => ord_less(nat,M,N) ) ) ).

tff(fact_40_mult_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [A1: A] : ( times_times(A,A1,one_one(A)) = A1 ) ) ).

tff(fact_41_mult__1__right,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( times_times(A,A1,one_one(A)) = A1 ) ) ).

tff(fact_42_mult__1,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [A1: A] : ( times_times(A,one_one(A),A1) = A1 ) ) ).

tff(fact_43_mult__1__left,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( times_times(A,one_one(A),A1) = A1 ) ) ).

tff(fact_44_power__mult__distrib,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [N: nat,B: A,A1: A] : ( power_power(A,times_times(A,A1,B),N) = times_times(A,power_power(A,A1,N),power_power(A,B,N)) ) ) ).

tff(fact_45_power__commutes,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A1: A] : ( times_times(A,power_power(A,A1,N),A1) = times_times(A,A1,power_power(A,A1,N)) ) ) ).

tff(fact_46_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_47_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_48_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_49_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_50_right__minus__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [Ba: A,A2: A] :
          ( ( minus_minus(A,A2,Ba) = zero_zero(A) )
        <=> ( A2 = Ba ) ) ) ).

tff(fact_51_eq__iff__diff__eq__0,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [Ba: A,A2: A] :
          ( ( A2 = Ba )
        <=> ( minus_minus(A,A2,Ba) = zero_zero(A) ) ) ) ).

tff(fact_52_diff__0__right,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A1: A] : ( minus_minus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_53_power__one__right,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( power_power(A,A1,one_one(nat)) = A1 ) ) ).

tff(fact_54_field__power__not__zero,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [N: nat,A1: A] :
          ( ( A1 != zero_zero(A) )
         => ( power_power(A,A1,N) != zero_zero(A) ) ) ) ).

tff(fact_55_norm__mult__less,axiom,
    ! [A: $tType] :
      ( real_normed_algebra(A)
     => ! [S: real,Y1: A,R: real,X1: A] :
          ( ord_less(real,norm_norm(A,X1),R)
         => ( ord_less(real,norm_norm(A,Y1),S)
           => ord_less(real,norm_norm(A,times_times(A,X1,Y1)),times_times(real,R,S)) ) ) ) ).

tff(fact_56_power__0__left,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & semiring_0(A) )
     => ! [N: nat] :
          ( ( ( N = zero_zero(nat) )
           => ( power_power(A,zero_zero(A),N) = one_one(A) ) )
          & ( ( N != zero_zero(nat) )
           => ( power_power(A,zero_zero(A),N) = zero_zero(A) ) ) ) ) ).

tff(fact_57_complex__i__not__zero,axiom,
    ii != zero_zero(complex) ).

tff(fact_58_power__Suc__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( ord_less(A,A1,one_one(A))
           => ord_less(A,times_times(A,A1,power_power(A,A1,N)),power_power(A,A1,N)) ) ) ) ).

tff(fact_59_add__neg__neg,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,A1,zero_zero(A))
         => ( ord_less(A,B,zero_zero(A))
           => ord_less(A,plus_plus(A,A1,B),zero_zero(A)) ) ) ) ).

tff(fact_60_add__pos__pos,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( ord_less(A,zero_zero(A),B)
           => ord_less(A,zero_zero(A),plus_plus(A,A1,B)) ) ) ) ).

tff(fact_61_less__iff__diff__less__0,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [Ba: A,A2: A] :
          ( ord_less(A,A2,Ba)
        <=> ord_less(A,minus_minus(A,A2,Ba),zero_zero(A)) ) ) ).

tff(fact_62_zero__less__power,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ord_less(A,zero_zero(A),power_power(A,A1,N)) ) ) ).

tff(fact_63_nonzero__power__divide,axiom,
    ! [A: $tType] :
      ( field(A)
     => ! [N: nat,A1: A,B: A] :
          ( ( B != zero_zero(A) )
         => ( power_power(A,inverse_divide(A,A1,B),N) = inverse_divide(A,power_power(A,A1,N),power_power(A,B,N)) ) ) ) ).

tff(fact_64_nonzero__norm__divide,axiom,
    ! [A: $tType] :
      ( real_normed_field(A)
     => ! [A1: A,B: A] :
          ( ( B != zero_zero(A) )
         => ( norm_norm(A,inverse_divide(A,A1,B)) = inverse_divide(real,norm_norm(A,A1),norm_norm(A,B)) ) ) ) ).

tff(fact_65_power__less__power__Suc,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A1: A] :
          ( ord_less(A,one_one(A),A1)
         => ord_less(A,power_power(A,A1,N),times_times(A,A1,power_power(A,A1,N))) ) ) ).

tff(fact_66_power__gt1__lemma,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A1: A] :
          ( ord_less(A,one_one(A),A1)
         => ord_less(A,one_one(A),times_times(A,A1,power_power(A,A1,N))) ) ) ).

tff(fact_67_power__strict__decreasing,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [A1: A,N1: nat,N: nat] :
          ( ord_less(nat,N,N1)
         => ( ord_less(A,zero_zero(A),A1)
           => ( ord_less(A,A1,one_one(A))
             => ord_less(A,power_power(A,A1,N1),power_power(A,A1,N)) ) ) ) ) ).

tff(fact_68_one__less__power,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A1: A] :
          ( ord_less(A,one_one(A),A1)
         => ( ord_less(nat,zero_zero(nat),N)
           => ord_less(A,one_one(A),power_power(A,A1,N)) ) ) ) ).

tff(fact_69_complex__of__real__power,axiom,
    ! [N: nat,X1: real] : ( power_power(complex,of_real(complex,X1),N) = of_real(complex,power_power(real,X1,N)) ) ).

tff(fact_70_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A1: A,B: A] :
          ( ( plus_plus(A,B,A1) = plus_plus(A,C1,A1) )
         => ( B = C1 ) ) ) ).

tff(fact_71_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C1: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C1) )
         => ( B = C1 ) ) ) ).

tff(fact_72_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C1) )
         => ( B = C1 ) ) ) ).

tff(fact_73_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C1: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C1) = plus_plus(A,A1,plus_plus(A,B,C1)) ) ) ).

tff(fact_74_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X: A] :
          ( ( one_one(A) = X )
        <=> ( X = one_one(A) ) ) ) ).

tff(fact_75_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [D: A,C: A,Ba: A,A2: A] :
          ( ( minus_minus(A,A2,Ba) = minus_minus(A,C,D) )
         => ( ( A2 = Ba )
          <=> ( C = D ) ) ) ) ).

tff(fact_76_add__less__imp__less__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,A1: A,C1: A] :
          ( ord_less(A,plus_plus(A,C1,A1),plus_plus(A,C1,B))
         => ord_less(A,A1,B) ) ) ).

tff(fact_77_add__less__imp__less__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,C1: A,A1: A] :
          ( ord_less(A,plus_plus(A,A1,C1),plus_plus(A,B,C1))
         => ord_less(A,A1,B) ) ) ).

tff(fact_78_add__strict__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [D1: A,C1: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ( ord_less(A,C1,D1)
           => ord_less(A,plus_plus(A,A1,C1),plus_plus(A,B,D1)) ) ) ) ).

tff(fact_79_add__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C1: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,plus_plus(A,C1,A1),plus_plus(A,C1,B)) ) ) ).

tff(fact_80_add__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C1: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,plus_plus(A,A1,C1),plus_plus(A,B,C1)) ) ) ).

tff(fact_81_diff__eq__diff__less,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [D: A,C: A,Ba: A,A2: A] :
          ( ( minus_minus(A,A2,Ba) = minus_minus(A,C,D) )
         => ( ord_less(A,A2,Ba)
          <=> ord_less(A,C,D) ) ) ) ).

tff(fact_82_add__diff__cancel,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B: A,A1: A] : ( minus_minus(A,plus_plus(A,A1,B),B) = A1 ) ) ).

tff(fact_83_diff__add__cancel,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B: A,A1: A] : ( plus_plus(A,minus_minus(A,A1,B),B) = A1 ) ) ).

tff(fact_84_power__divide,axiom,
    ! [A: $tType] :
      ( field_inverse_zero(A)
     => ! [N: nat,B: A,A1: A] : ( power_power(A,inverse_divide(A,A1,B),N) = inverse_divide(A,power_power(A,A1,N),power_power(A,B,N)) ) ) ).

tff(fact_85_norm__minus__commute,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ! [B: A,A1: A] : ( norm_norm(A,minus_minus(A,A1,B)) = norm_norm(A,minus_minus(A,B,A1)) ) ) ).

tff(fact_86_norm__power,axiom,
    ! [A: $tType] :
      ( real_n1866405975lgebra(A)
     => ! [N: nat,X1: A] : ( norm_norm(A,power_power(A,X1,N)) = power_power(real,norm_norm(A,X1),N) ) ) ).

tff(fact_87_norm__divide,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & real_normed_field(A) )
     => ! [B: A,A1: A] : ( norm_norm(A,inverse_divide(A,A1,B)) = inverse_divide(real,norm_norm(A,A1),norm_norm(A,B)) ) ) ).

tff(fact_88_complex__i__not__one,axiom,
    ii != one_one(complex) ).

tff(fact_89_power__strict__increasing,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [A1: A,N1: nat,N: nat] :
          ( ord_less(nat,N,N1)
         => ( ord_less(A,one_one(A),A1)
           => ord_less(A,power_power(A,A1,N),power_power(A,A1,N1)) ) ) ) ).

tff(fact_90_power__less__imp__less__exp,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,M: nat,A1: A] :
          ( ord_less(A,one_one(A),A1)
         => ( ord_less(A,power_power(A,A1,M),power_power(A,A1,N))
           => ord_less(nat,M,N) ) ) ) ).

tff(fact_91_power__strict__increasing__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Y: nat,X: nat,Ba: A] :
          ( ord_less(A,one_one(A),Ba)
         => ( ord_less(A,power_power(A,Ba,X),power_power(A,Ba,Y))
          <=> ord_less(nat,X,Y) ) ) ) ).

tff(fact_92_power__inject__exp,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Nb: nat,Ma: nat,A2: A] :
          ( ord_less(A,one_one(A),A2)
         => ( ( power_power(A,A2,Ma) = power_power(A,A2,Nb) )
          <=> ( Ma = Nb ) ) ) ) ).

tff(fact_93_power__one__over,axiom,
    ! [A: $tType] :
      ( field_inverse_zero(A)
     => ! [N: nat,A1: A] : ( inverse_divide(A,one_one(A),power_power(A,A1,N)) = power_power(A,inverse_divide(A,one_one(A),A1),N) ) ) ).

tff(fact_94_norm__add__less,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ! [S: real,Y1: A,R: real,X1: A] :
          ( ord_less(real,norm_norm(A,X1),R)
         => ( ord_less(real,norm_norm(A,Y1),S)
           => ord_less(real,norm_norm(A,plus_plus(A,X1,Y1)),plus_plus(real,R,S)) ) ) ) ).

tff(fact_95_divide__self__if,axiom,
    ! [A: $tType] :
      ( divisi14063676e_zero(A)
     => ! [A1: A] :
          ( ( ( A1 = zero_zero(A) )
           => ( inverse_divide(A,A1,A1) = zero_zero(A) ) )
          & ( ( A1 != zero_zero(A) )
           => ( inverse_divide(A,A1,A1) = one_one(A) ) ) ) ) ).

tff(fact_96_even__power__nat,axiom,
    ! [Y: nat,X: nat] :
      ( even_odd_even(nat,power_power(nat,X,Y))
    <=> ( even_odd_even(nat,X)
        & ord_less(nat,zero_zero(nat),Y) ) ) ).

tff(fact_97_zero__less__power__eq,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Nb: nat,X: A] :
          ( ord_less(A,zero_zero(A),power_power(A,X,Nb))
        <=> ( ( Nb = zero_zero(nat) )
            | ( even_odd_even(nat,Nb)
              & ( X != zero_zero(A) ) )
            | ( ~ even_odd_even(nat,Nb)
              & ord_less(A,zero_zero(A),X) ) ) ) ) ).

%----Arities (80)
tff(arity_Nat_Onat___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__0,axiom,
    semiring_0(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Power_Opower,axiom,
    power(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_RealDef_Oreal___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add(real) ).

tff(arity_RealDef_Oreal___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(real) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__normed__div__algebra,axiom,
    real_n1866405975lgebra(real) ).

tff(arity_RealDef_Oreal___Fields_Odivision__ring__inverse__zero,axiom,
    divisi14063676e_zero(real) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__normed__algebra__1,axiom,
    real_n2089651433ebra_1(real) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__normed__algebra,axiom,
    real_normed_algebra(real) ).

tff(arity_RealDef_Oreal___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add(real) ).

tff(arity_RealDef_Oreal___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(real) ).

tff(arity_RealDef_Oreal___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(real) ).

tff(arity_RealDef_Oreal___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(real) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__normed__vector,axiom,
    real_normed_vector(real) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__normed__field,axiom,
    real_normed_field(real) ).

tff(arity_RealDef_Oreal___Groups_Oordered__ab__group__add,axiom,
    ordered_ab_group_add(real) ).

tff(arity_RealDef_Oreal___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(real) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__algebra__1,axiom,
    real_algebra_1(real) ).

tff(arity_RealDef_Oreal___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(real) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__semidom,axiom,
    linordered_semidom(real) ).

tff(arity_RealDef_Oreal___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(real) ).

tff(arity_RealDef_Oreal___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(real) ).

tff(arity_RealDef_Oreal___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(real) ).

tff(arity_RealDef_Oreal___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(real) ).

tff(arity_RealDef_Oreal___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(real) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__idom,axiom,
    linordered_idom(real) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__field,axiom,
    real_field(real) ).

tff(arity_RealDef_Oreal___Rings_Ozero__neq__one,axiom,
    zero_neq_one(real) ).

tff(arity_RealDef_Oreal___Groups_Omonoid__mult,axiom,
    monoid_mult(real) ).

tff(arity_RealDef_Oreal___Groups_Omonoid__add,axiom,
    monoid_add(real) ).

tff(arity_RealDef_Oreal___Rings_Osemiring__0,axiom,
    semiring_0(real) ).

tff(arity_RealDef_Oreal___Groups_Ogroup__add,axiom,
    group_add(real) ).

tff(arity_RealDef_Oreal___Rings_Omult__zero,axiom,
    mult_zero(real) ).

tff(arity_RealDef_Oreal___Fields_Ofield,axiom,
    field(real) ).

tff(arity_RealDef_Oreal___Power_Opower,axiom,
    power(real) ).

tff(arity_RealDef_Oreal___Groups_Ozero,axiom,
    zero(real) ).

tff(arity_RealDef_Oreal___Groups_Oone,axiom,
    one(real) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__normed__div__algebra,axiom,
    real_n1866405975lgebra(complex) ).

tff(arity_Complex_Ocomplex___Fields_Odivision__ring__inverse__zero,axiom,
    divisi14063676e_zero(complex) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__normed__algebra__1,axiom,
    real_n2089651433ebra_1(complex) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__normed__algebra,axiom,
    real_normed_algebra(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(complex) ).

tff(arity_Complex_Ocomplex___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(complex) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__normed__vector,axiom,
    real_normed_vector(complex) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__normed__field,axiom,
    real_normed_field(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(complex) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__algebra__1,axiom,
    real_algebra_1(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(complex) ).

tff(arity_Complex_Ocomplex___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(complex) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__field,axiom,
    real_field(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ozero__neq__one,axiom,
    zero_neq_one(complex) ).

tff(arity_Complex_Ocomplex___Groups_Omonoid__mult,axiom,
    monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Groups_Omonoid__add,axiom,
    monoid_add(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__0,axiom,
    semiring_0(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ogroup__add,axiom,
    group_add(complex) ).

tff(arity_Complex_Ocomplex___Rings_Omult__zero,axiom,
    mult_zero(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield,axiom,
    field(complex) ).

tff(arity_Complex_Ocomplex___Power_Opower,axiom,
    power(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ozero,axiom,
    zero(complex) ).

tff(arity_Complex_Ocomplex___Groups_Oone,axiom,
    one(complex) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (7)
tff(conj_0,hypothesis,
    $true ).

tff(conj_1,hypothesis,
    $true ).

tff(conj_2,hypothesis,
    ~ ord_less(real,norm_norm(complex,plus_plus(complex,inverse_divide(complex,of_real(complex,norm_norm(complex,b)),b),one_one(complex))),one_one(real)) ).

tff(conj_3,hypothesis,
    ~ ord_less(real,norm_norm(complex,minus_minus(complex,inverse_divide(complex,of_real(complex,norm_norm(complex,b)),b),one_one(complex))),one_one(real)) ).

tff(conj_4,hypothesis,
    ord_less(real,norm_norm(complex,plus_plus(complex,inverse_divide(complex,of_real(complex,norm_norm(complex,b)),b),ii)),one_one(real)) ).

tff(conj_5,hypothesis,
    ~ even_odd_even(nat,m) ).

tff(conj_6,conjecture,
    ? [V: complex] : ord_less(real,norm_norm(complex,plus_plus(complex,inverse_divide(complex,of_real(complex,norm_norm(complex,b)),b),power_power(complex,V,na))),one_one(real)) ).

%------------------------------------------------------------------------------
