%------------------------------------------------------------------------------
% File     : SWW499_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fundamental Theorem of Algebra line 209
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fta_209 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.00 v6.4.0
% Syntax   : Number of formulae    :  236 ( 105 unt;  44 typ;   0 def)
%            Number of atoms       :  310 ( 112 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  138 (  20   ~;   8   |;  10   &)
%                                         (  27 <=>;  73  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    8 (   3 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   16 (  12   >;   4   *;   0   +;   0  <<)
%            Number of predicates  :   26 (  25 usr;   0 prp; 1-3 aty)
%            Number of functors    :   14 (  14 usr;   5 con; 0-3 aty)
%            Number of variables   :  251 ( 220   !;   2   ?; 251   :)
%                                         (  29  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:17:21
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Polynomial_Opoly,type,
    poly: $tType > $tType ).

tff(ty_tc_RealDef_Oreal,type,
    real: $tType ).

%----Explicit typings (38)
tff(sy_cl_Rings_Ocomm__ring__1,type,
    comm_ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__0,type,
    comm_semiring_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oidom,type,
    idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__mult,type,
    comm_monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__no__zero__divisors,type,
    ring_n68954251visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Oab__semigroup__idem__mult,type,
    ab_sem1668676832m_mult: 
      !>[A: $tType] : $o ).

tff(sy_c_Fundamental__Theorem__Algebra__Mirabelle__jmqnahvvas_Ocsqrt,type,
    fundam1563812824_csqrt: complex > complex ).

tff(sy_c_Fundamental__Theorem__Algebra__Mirabelle__jmqnahvvas_Opsize,type,
    fundam1280195782_psize: 
      !>[A: $tType] : ( poly(A) > nat ) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Parity_Oeven__odd__class_Oeven,type,
    even_odd_even: 
      !>[A: $tType] : ( A > $o ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( ( A * nat ) > A ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_n,type,
    n: nat ).

tff(sy_v_na____,type,
    na: nat ).

%----Relevant facts (97)
tff(fact_0_e,axiom,
    even_odd_even(nat,na) ).

tff(fact_1_n,axiom,
    na != zero_zero(nat) ).

tff(fact_2_assms_I2_J,axiom,
    n != zero_zero(nat) ).

tff(fact_3_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_4_rel__simps_I38_J,axiom,
    ! [L: int] :
      ( ( pls = bit0(L) )
    <=> ( pls = L ) ) ).

tff(fact_5_rel__simps_I44_J,axiom,
    ! [K: int] :
      ( ( bit0(K) = pls )
    <=> ( K = pls ) ) ).

tff(fact_6_rel__simps_I49_J,axiom,
    ! [L1: int,K1: int] : ( bit0(K1) != bit1(L1) ) ).

tff(fact_7_rel__simps_I50_J,axiom,
    ! [L1: int,K1: int] : ( bit1(K1) != bit0(L1) ) ).

tff(fact_8_rel__simps_I39_J,axiom,
    ! [L1: int] : ( pls != bit1(L1) ) ).

tff(fact_9_rel__simps_I46_J,axiom,
    ! [K1: int] : ( bit1(K1) != pls ) ).

tff(fact_10_arith__simps_I32_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int,V: int] : ( times_times(A,number_number_of(A,V),number_number_of(A,W1)) = number_number_of(A,times_times(int,V,W1)) ) ) ).

tff(fact_11_mult__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W1: int,V: int] : ( times_times(A,number_number_of(A,V),times_times(A,number_number_of(A,W1),Z)) = times_times(A,number_number_of(A,times_times(int,V,W1)),Z) ) ) ).

tff(fact_12_mult__numeral__1__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( times_times(A,A1,number_number_of(A,bit1(pls))) = A1 ) ) ).

tff(fact_13_mult__numeral__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( times_times(A,number_number_of(A,bit1(pls)),A1) = A1 ) ) ).

tff(fact_14_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y1: int,X: int] :
          ( ( number_number_of(A,X) = number_number_of(A,Y1) )
        <=> ( X = Y1 ) ) ) ).

tff(fact_15_rel__simps_I51_J,axiom,
    ! [L: int,K: int] :
      ( ( bit1(K) = bit1(L) )
    <=> ( K = L ) ) ).

tff(fact_16_rel__simps_I48_J,axiom,
    ! [L: int,K: int] :
      ( ( bit0(K) = bit0(L) )
    <=> ( K = L ) ) ).

tff(fact_17_mult__Pls,axiom,
    ! [W1: int] : ( times_times(int,pls,W1) = pls ) ).

tff(fact_18_mult__Bit0,axiom,
    ! [L1: int,K1: int] : ( times_times(int,bit0(K1),L1) = bit0(times_times(int,K1,L1)) ) ).

tff(fact_19_number__of__Pls,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_20_times__numeral__code_I5_J,axiom,
    ! [W1: int,V: int] : ( times_times(int,number_number_of(int,V),number_number_of(int,W1)) = number_number_of(int,times_times(int,V,W1)) ) ).

tff(fact_21_semiring__numeral__0__eq__0,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_22_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [X: A,W: int] :
          ( ( number_number_of(A,W) = X )
        <=> ( X = number_number_of(A,W) ) ) ) ).

tff(fact_23_number__of__mult,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int,V: int] : ( number_number_of(A,times_times(int,V,W1)) = times_times(A,number_number_of(A,V),number_number_of(A,W1)) ) ) ).

tff(fact_24_nat__number__of__Pls,axiom,
    number_number_of(nat,pls) = zero_zero(nat) ).

tff(fact_25_even__mult__two__ex,axiom,
    ! [Nb: nat] :
      ( even_odd_even(nat,Nb)
    <=> ? [M3: nat] : ( Nb = times_times(nat,number_number_of(nat,bit0(bit1(pls))),M3) ) ) ).

tff(fact_26_even__product__nat,axiom,
    ! [Y1: nat,X: nat] :
      ( even_odd_even(nat,times_times(nat,X,Y1))
    <=> ( even_odd_even(nat,X)
        | even_odd_even(nat,Y1) ) ) ).

tff(fact_27_mult__cancel2,axiom,
    ! [Nb: nat,K: nat,M2: nat] :
      ( ( times_times(nat,M2,K) = times_times(nat,Nb,K) )
    <=> ( ( M2 = Nb )
        | ( K = zero_zero(nat) ) ) ) ).

tff(fact_28_mult__cancel1,axiom,
    ! [Nb: nat,M2: nat,K: nat] :
      ( ( times_times(nat,K,M2) = times_times(nat,K,Nb) )
    <=> ( ( M2 = Nb )
        | ( K = zero_zero(nat) ) ) ) ).

tff(fact_29_mult__is__0,axiom,
    ! [Nb: nat,M2: nat] :
      ( ( times_times(nat,M2,Nb) = zero_zero(nat) )
    <=> ( ( M2 = zero_zero(nat) )
        | ( Nb = zero_zero(nat) ) ) ) ).

tff(fact_30_mult__0__right,axiom,
    ! [M1: nat] : ( times_times(nat,M1,zero_zero(nat)) = zero_zero(nat) ) ).

tff(fact_31_mult__0,axiom,
    ! [N: nat] : ( times_times(nat,zero_zero(nat),N) = zero_zero(nat) ) ).

tff(fact_32_mult__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_n68954251visors(A)
     => ! [Ba: A,A2: A] :
          ( ( times_times(A,A2,Ba) = zero_zero(A) )
        <=> ( ( A2 = zero_zero(A) )
            | ( Ba = zero_zero(A) ) ) ) ) ).

tff(fact_33_mult__zero__left,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A1: A] : ( times_times(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_34_mult__zero__right,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A1: A] : ( times_times(A,A1,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_35_number__of__is__id,axiom,
    ! [K1: int] : ( number_number_of(int,K1) = K1 ) ).

tff(fact_36_Pls__def,axiom,
    pls = zero_zero(int) ).

tff(fact_37_zero__is__num__zero,axiom,
    zero_zero(int) = number_number_of(int,pls) ).

tff(fact_38_nat__mult__commute,axiom,
    ! [N: nat,M1: nat] : ( times_times(nat,M1,N) = times_times(nat,N,M1) ) ).

tff(fact_39_nat__mult__assoc,axiom,
    ! [K1: nat,N: nat,M1: nat] : ( times_times(nat,times_times(nat,M1,N),K1) = times_times(nat,M1,times_times(nat,N,K1)) ) ).

tff(fact_40_no__zero__divisors,axiom,
    ! [A: $tType] :
      ( no_zero_divisors(A)
     => ! [B: A,A1: A] :
          ( ( A1 != zero_zero(A) )
         => ( ( B != zero_zero(A) )
           => ( times_times(A,A1,B) != zero_zero(A) ) ) ) ) ).

tff(fact_41_divisors__zero,axiom,
    ! [A: $tType] :
      ( no_zero_divisors(A)
     => ! [B: A,A1: A] :
          ( ( times_times(A,A1,B) = zero_zero(A) )
         => ( ( A1 = zero_zero(A) )
            | ( B = zero_zero(A) ) ) ) ) ).

tff(fact_42_even__zero__nat,axiom,
    even_odd_even(nat,zero_zero(nat)) ).

tff(fact_43_semiring__norm_I112_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( zero_zero(A) = number_number_of(A,pls) ) ) ).

tff(fact_44_semiring__norm_I113_J,axiom,
    zero_zero(nat) = number_number_of(nat,pls) ).

tff(fact_45_psize__eq__0__iff,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [P1: poly(A)] :
          ( ( fundam1280195782_psize(A,P1) = zero_zero(nat) )
        <=> ( P1 = zero_zero(poly(A)) ) ) ) ).

tff(fact_46_mult__left__idem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [B: A,A1: A] : ( times_times(A,A1,times_times(A,A1,B)) = times_times(A,A1,B) ) ) ).

tff(fact_47_nat__mult__eq__cancel__disj,axiom,
    ! [Nb: nat,M2: nat,K: nat] :
      ( ( times_times(nat,K,M2) = times_times(nat,K,Nb) )
    <=> ( ( K = zero_zero(nat) )
        | ( M2 = Nb ) ) ) ).

tff(fact_48_power2__eq__square__number__of,axiom,
    ! [B1: $tType] :
      ( ( monoid_mult(B1)
        & number(B1) )
     => ! [W1: int] : ( power_power(B1,number_number_of(B1,W1),number_number_of(nat,bit0(bit1(pls)))) = times_times(B1,number_number_of(B1,W1),number_number_of(B1,W1)) ) ) ).

tff(fact_49_power__eq__0__iff__number__of,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [W: int,A2: A] :
          ( ( power_power(A,A2,number_number_of(nat,W)) = zero_zero(A) )
        <=> ( ( A2 = zero_zero(A) )
            & ( number_number_of(nat,W) != zero_zero(nat) ) ) ) ) ).

tff(fact_50_zero__eq__power2,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [A2: A] :
          ( ( power_power(A,A2,number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_51_zero__power2,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( power_power(A,zero_zero(A),number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) ) ) ).

tff(fact_52_zpower__zpower,axiom,
    ! [Z: nat,Y: nat,X1: int] : ( power_power(int,power_power(int,X1,Y),Z) = power_power(int,X1,times_times(nat,Y,Z)) ) ).

tff(fact_53_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_54_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_mult(A)
     => ! [C: A,B: A,A1: A] : ( times_times(A,times_times(A,A1,B),C) = times_times(A,A1,times_times(A,B,C)) ) ) ).

tff(fact_55_mult__idem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [X1: A] : ( times_times(A,X1,X1) = X1 ) ) ).

tff(fact_56_times_Oidem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [A1: A] : ( times_times(A,A1,A1) = A1 ) ) ).

tff(fact_57_power3__eq__cube,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( power_power(A,A1,number_number_of(nat,bit1(bit1(pls)))) = times_times(A,times_times(A,A1,A1),A1) ) ) ).

tff(fact_58_power2__eq__square,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( power_power(A,A1,number_number_of(nat,bit0(bit1(pls)))) = times_times(A,A1,A1) ) ) ).

tff(fact_59_power__even__eq,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A1: A] : ( power_power(A,A1,times_times(nat,number_number_of(nat,bit0(bit1(pls))),N)) = power_power(A,power_power(A,A1,N),number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_60_power__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [Nb: nat,A2: A] :
          ( ( power_power(A,A2,Nb) = zero_zero(A) )
        <=> ( ( A2 = zero_zero(A) )
            & ( Nb != zero_zero(nat) ) ) ) ) ).

tff(fact_61_comm__semiring__1__class_Onormalizing__semiring__rules_I36_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [N: nat,X1: A] : ( power_power(A,X1,times_times(nat,number_number_of(nat,bit0(bit1(pls))),N)) = times_times(A,power_power(A,X1,N),power_power(A,X1,N)) ) ) ).

tff(fact_62_comm__semiring__1__class_Onormalizing__semiring__rules_I29_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X1: A] : ( times_times(A,X1,X1) = power_power(A,X1,number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_63_csqrt,axiom,
    ! [Z: complex] : ( power_power(complex,fundam1563812824_csqrt(Z),number_number_of(nat,bit0(bit1(pls)))) = Z ) ).

tff(fact_64_comm__semiring__1__class_Onormalizing__semiring__rules_I7_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B: A,A1: A] : ( times_times(A,A1,B) = times_times(A,B,A1) ) ) ).

tff(fact_65_comm__semiring__1__class_Onormalizing__semiring__rules_I19_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( times_times(A,Lx,times_times(A,Rx,Ry)) = times_times(A,Rx,times_times(A,Lx,Ry)) ) ) ).

tff(fact_66_comm__semiring__1__class_Onormalizing__semiring__rules_I18_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( times_times(A,Lx,times_times(A,Rx,Ry)) = times_times(A,times_times(A,Lx,Rx),Ry) ) ) ).

tff(fact_67_comm__semiring__1__class_Onormalizing__semiring__rules_I17_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),Rx) = times_times(A,Lx,times_times(A,Ly,Rx)) ) ) ).

tff(fact_68_comm__semiring__1__class_Onormalizing__semiring__rules_I16_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),Rx) = times_times(A,times_times(A,Lx,Rx),Ly) ) ) ).

tff(fact_69_comm__semiring__1__class_Onormalizing__semiring__rules_I14_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,Lx,times_times(A,Ly,times_times(A,Rx,Ry))) ) ) ).

tff(fact_70_comm__semiring__1__class_Onormalizing__semiring__rules_I15_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,Rx,times_times(A,times_times(A,Lx,Ly),Ry)) ) ) ).

tff(fact_71_comm__semiring__1__class_Onormalizing__semiring__rules_I13_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,times_times(A,Lx,Rx),times_times(A,Ly,Ry)) ) ) ).

tff(fact_72_comm__semiring__1__class_Onormalizing__semiring__rules_I9_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( times_times(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_73_comm__semiring__1__class_Onormalizing__semiring__rules_I10_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( times_times(A,A1,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_74_field__power__not__zero,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [N: nat,A1: A] :
          ( ( A1 != zero_zero(A) )
         => ( power_power(A,A1,N) != zero_zero(A) ) ) ) ).

tff(fact_75_comm__semiring__1__class_Onormalizing__semiring__rules_I30_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,Y: A,X1: A] : ( power_power(A,times_times(A,X1,Y),Q) = times_times(A,power_power(A,X1,Q),power_power(A,Y,Q)) ) ) ).

tff(fact_76_power__mult__distrib,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [N: nat,B: A,A1: A] : ( power_power(A,times_times(A,A1,B),N) = times_times(A,power_power(A,A1,N),power_power(A,B,N)) ) ) ).

tff(fact_77_power__commutes,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A1: A] : ( times_times(A,power_power(A,A1,N),A1) = times_times(A,A1,power_power(A,A1,N)) ) ) ).

tff(fact_78_comm__semiring__1__class_Onormalizing__semiring__rules_I31_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,P: nat,X1: A] : ( power_power(A,power_power(A,X1,P),Q) = power_power(A,X1,times_times(nat,P,Q)) ) ) ).

tff(fact_79_power__mult,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,M1: nat,A1: A] : ( power_power(A,A1,times_times(nat,M1,N)) = power_power(A,power_power(A,A1,M1),N) ) ) ).

tff(fact_80_four__x__squared,axiom,
    ! [X1: real] : ( times_times(real,number_number_of(real,bit0(bit0(bit1(pls)))),power_power(real,X1,number_number_of(nat,bit0(bit1(pls))))) = power_power(real,times_times(real,number_number_of(real,bit0(bit1(pls))),X1),number_number_of(nat,bit0(bit1(pls)))) ) ).

tff(fact_81_zero__less__power2,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A2: A] :
          ( ord_less(A,zero_zero(A),power_power(A,A2,number_number_of(nat,bit0(bit1(pls)))))
        <=> ( A2 != zero_zero(A) ) ) ) ).

tff(fact_82_zero__le__even__power_H,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [N: nat,A1: A] : ord_less_eq(A,zero_zero(A),power_power(A,A1,times_times(nat,number_number_of(nat,bit0(bit1(pls))),N))) ) ).

tff(fact_83_nat__zero__less__power__iff,axiom,
    ! [Nb: nat,X: nat] :
      ( ord_less(nat,zero_zero(nat),power_power(nat,X,Nb))
    <=> ( ord_less(nat,zero_zero(nat),X)
        | ( Nb = zero_zero(nat) ) ) ) ).

tff(fact_84_le__0__eq,axiom,
    ! [Nb: nat] :
      ( ord_less_eq(nat,Nb,zero_zero(nat))
    <=> ( Nb = zero_zero(nat) ) ) ).

tff(fact_85_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : ord_less_eq(nat,zero_zero(nat),N) ).

tff(fact_86_le0,axiom,
    ! [N: nat] : ord_less_eq(nat,zero_zero(nat),N) ).

tff(fact_87_less__zeroE,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_88_less__nat__zero__code,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_89_neq0__conv,axiom,
    ! [Nb: nat] :
      ( ( Nb != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),Nb) ) ).

tff(fact_90_rel__simps_I34_J,axiom,
    ! [L: int,K: int] :
      ( ord_less_eq(int,bit1(K),bit1(L))
    <=> ord_less_eq(int,K,L) ) ).

tff(fact_91_rel__simps_I17_J,axiom,
    ! [L: int,K: int] :
      ( ord_less(int,bit1(K),bit1(L))
    <=> ord_less(int,K,L) ) ).

tff(fact_92_rel__simps_I19_J,axiom,
    ord_less_eq(int,pls,pls) ).

tff(fact_93_rel__simps_I2_J,axiom,
    ~ ord_less(int,pls,pls) ).

tff(fact_94_rel__simps_I31_J,axiom,
    ! [L: int,K: int] :
      ( ord_less_eq(int,bit0(K),bit0(L))
    <=> ord_less_eq(int,K,L) ) ).

tff(fact_95_rel__simps_I14_J,axiom,
    ! [L: int,K: int] :
      ( ord_less(int,bit0(K),bit0(L))
    <=> ord_less(int,K,L) ) ).

tff(fact_96_not__real__square__gt__zero,axiom,
    ! [X: real] :
      ( ~ ord_less(real,zero_zero(real),times_times(real,X,X))
    <=> ( X = zero_zero(real) ) ) ).

%----Arities (92)
tff(arity_Polynomial_Opoly___Rings_Oidom,axiom,
    ! [T_1: $tType] :
      ( idom(T_1)
     => idom(poly(T_1)) ) ).

tff(arity_Polynomial_Opoly___Rings_Ocomm__semiring__0,axiom,
    ! [T_1: $tType] :
      ( comm_semiring_0(T_1)
     => comm_semiring_0(poly(T_1)) ) ).

tff(arity_Polynomial_Opoly___Rings_Ocomm__ring__1,axiom,
    ! [T_1: $tType] :
      ( comm_ring_1(T_1)
     => comm_ring_1(poly(T_1)) ) ).

tff(arity_Complex_Ocomplex___Rings_Oidom,axiom,
    idom(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ocomm__semiring__0,axiom,
    comm_semiring_0(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ocomm__ring__1,axiom,
    comm_ring_1(complex) ).

tff(arity_RealDef_Oreal___Rings_Oidom,axiom,
    idom(real) ).

tff(arity_RealDef_Oreal___Rings_Ocomm__semiring__0,axiom,
    comm_semiring_0(real) ).

tff(arity_RealDef_Oreal___Rings_Ocomm__ring__1,axiom,
    comm_ring_1(real) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__0,axiom,
    comm_semiring_0(nat) ).

tff(arity_Int_Oint___Rings_Oidom,axiom,
    idom(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__0,axiom,
    comm_semiring_0(int) ).

tff(arity_Int_Oint___Rings_Ocomm__ring__1,axiom,
    comm_ring_1(int) ).

tff(arity_Int_Oint___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(int) ).

tff(arity_Int_Oint___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(int) ).

tff(arity_Int_Oint___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Rings_Omult__zero,axiom,
    mult_zero(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Power_Opower,axiom,
    power(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Power_Opower,axiom,
    power(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_RealDef_Oreal___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(real) ).

tff(arity_RealDef_Oreal___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors(real) ).

tff(arity_RealDef_Oreal___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(real) ).

tff(arity_RealDef_Oreal___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(real) ).

tff(arity_RealDef_Oreal___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(real) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__idom,axiom,
    linordered_idom(real) ).

tff(arity_RealDef_Oreal___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(real) ).

tff(arity_RealDef_Oreal___Int_Onumber__semiring,axiom,
    number_semiring(real) ).

tff(arity_RealDef_Oreal___Rings_Ozero__neq__one,axiom,
    zero_neq_one(real) ).

tff(arity_RealDef_Oreal___Groups_Omonoid__mult,axiom,
    monoid_mult(real) ).

tff(arity_RealDef_Oreal___Rings_Osemiring__1,axiom,
    semiring_1(real) ).

tff(arity_RealDef_Oreal___Rings_Omult__zero,axiom,
    mult_zero(real) ).

tff(arity_RealDef_Oreal___Int_Oring__char__0,axiom,
    ring_char_0(real) ).

tff(arity_RealDef_Oreal___Int_Onumber__ring,axiom,
    number_ring(real) ).

tff(arity_RealDef_Oreal___Power_Opower,axiom,
    power(real) ).

tff(arity_RealDef_Oreal___Groups_Ozero,axiom,
    zero(real) ).

tff(arity_RealDef_Oreal___Int_Onumber,axiom,
    number(real) ).

tff(arity_Complex_Ocomplex___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(complex) ).

tff(arity_Complex_Ocomplex___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors(complex) ).

tff(arity_Complex_Ocomplex___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__semiring,axiom,
    number_semiring(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ozero__neq__one,axiom,
    zero_neq_one(complex) ).

tff(arity_Complex_Ocomplex___Groups_Omonoid__mult,axiom,
    monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__1,axiom,
    semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Rings_Omult__zero,axiom,
    mult_zero(complex) ).

tff(arity_Complex_Ocomplex___Int_Oring__char__0,axiom,
    ring_char_0(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__ring,axiom,
    number_ring(complex) ).

tff(arity_Complex_Ocomplex___Power_Opower,axiom,
    power(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ozero,axiom,
    zero(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber,axiom,
    number(complex) ).

tff(arity_Polynomial_Opoly___Rings_Oring__1__no__zero__divisors,axiom,
    ! [T_1: $tType] :
      ( idom(T_1)
     => ring_11004092258visors(poly(T_1)) ) ).

tff(arity_Polynomial_Opoly___Rings_Oring__no__zero__divisors,axiom,
    ! [T_1: $tType] :
      ( idom(T_1)
     => ring_n68954251visors(poly(T_1)) ) ).

tff(arity_Polynomial_Opoly___Groups_Oab__semigroup__mult,axiom,
    ! [T_1: $tType] :
      ( comm_semiring_0(T_1)
     => ab_semigroup_mult(poly(T_1)) ) ).

tff(arity_Polynomial_Opoly___Groups_Ocomm__monoid__mult,axiom,
    ! [T_1: $tType] :
      ( comm_semiring_1(T_1)
     => comm_monoid_mult(poly(T_1)) ) ).

tff(arity_Polynomial_Opoly___Rings_Ono__zero__divisors,axiom,
    ! [T_1: $tType] :
      ( idom(T_1)
     => no_zero_divisors(poly(T_1)) ) ).

tff(arity_Polynomial_Opoly___Rings_Olinordered__idom,axiom,
    ! [T_1: $tType] :
      ( linordered_idom(T_1)
     => linordered_idom(poly(T_1)) ) ).

tff(arity_Polynomial_Opoly___Rings_Ocomm__semiring__1,axiom,
    ! [T_1: $tType] :
      ( comm_semiring_1(T_1)
     => comm_semiring_1(poly(T_1)) ) ).

tff(arity_Polynomial_Opoly___Int_Onumber__semiring,axiom,
    ! [T_1: $tType] :
      ( comm_ring_1(T_1)
     => number_semiring(poly(T_1)) ) ).

tff(arity_Polynomial_Opoly___Rings_Ozero__neq__one,axiom,
    ! [T_1: $tType] :
      ( comm_semiring_1(T_1)
     => zero_neq_one(poly(T_1)) ) ).

tff(arity_Polynomial_Opoly___Groups_Omonoid__mult,axiom,
    ! [T_1: $tType] :
      ( comm_semiring_1(T_1)
     => monoid_mult(poly(T_1)) ) ).

tff(arity_Polynomial_Opoly___Rings_Osemiring__1,axiom,
    ! [T_1: $tType] :
      ( comm_semiring_1(T_1)
     => semiring_1(poly(T_1)) ) ).

tff(arity_Polynomial_Opoly___Rings_Omult__zero,axiom,
    ! [T_1: $tType] :
      ( comm_semiring_0(T_1)
     => mult_zero(poly(T_1)) ) ).

tff(arity_Polynomial_Opoly___Int_Oring__char__0,axiom,
    ! [T_1: $tType] :
      ( linordered_idom(T_1)
     => ring_char_0(poly(T_1)) ) ).

tff(arity_Polynomial_Opoly___Int_Onumber__ring,axiom,
    ! [T_1: $tType] :
      ( comm_ring_1(T_1)
     => number_ring(poly(T_1)) ) ).

tff(arity_Polynomial_Opoly___Power_Opower,axiom,
    ! [T_1: $tType] :
      ( comm_semiring_1(T_1)
     => power(poly(T_1)) ) ).

tff(arity_Polynomial_Opoly___Groups_Ozero,axiom,
    ! [T_1: $tType] :
      ( zero(T_1)
     => zero(poly(T_1)) ) ).

tff(arity_Polynomial_Opoly___Int_Onumber,axiom,
    ! [T_1: $tType] :
      ( comm_ring_1(T_1)
     => number(poly(T_1)) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ? [M: nat] : ( na = times_times(nat,number_number_of(nat,bit0(bit1(pls))),M) ) ).

%------------------------------------------------------------------------------
