%------------------------------------------------------------------------------
% File     : SWW493_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fundamental Theorem of Algebra line 156
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fta_156 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  138 (  14 unt;  21 typ;   0 def)
%            Number of atoms       :  449 (  37 equ)
%            Maximal formula atoms :   12 (   3 avg)
%            Number of connectives :  371 (  39   ~;  13   |;  31   &)
%                                         (  33 <=>; 255  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   7 avg)
%            Maximal term depth    :    2 (   1 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   14 (   9   >;   5   *;   0   +;   0  <<)
%            Number of predicates  :   16 (  15 usr;   0 prp; 1-3 aty)
%            Number of functors    :    4 (   4 usr;   2 con; 0-4 aty)
%            Number of variables   :  468 ( 414   !;  37   ?; 468   :)
%                                         (  17  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:07
%------------------------------------------------------------------------------
%----Should-be-implicit typings (3)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_RealDef_Oreal,type,
    real: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (18)
tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Owellorder,type,
    wellorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Olinordered__field,type,
    linordered_field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : $o ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oorder__class_Omono,type,
    order_mono: 
      !>[A: $tType,B: $tType] : ( fun(A,B) > $o ) ).

tff(sy_c_Orderings_Oorder__class_Ostrict__mono,type,
    order_strict_mono: 
      !>[A: $tType,B: $tType] : ( fun(A,B) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_P,type,
    p: real > $o ).

%----Relevant facts (100)
tff(fact_0_ex,axiom,
    ? [X11: real] : p(X11) ).

tff(fact_1_bz,axiom,
    ? [Z: real] :
    ! [X1: real] :
      ( p(X1)
     => ord_less(real,X1,Z) ) ).

tff(fact_2_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X4: A] : ~ ord_less(A,X4,X4) ) ).

tff(fact_3_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X3: A] :
          ( ( X3 != Y1 )
        <=> ( ord_less(A,X3,Y1)
            | ord_less(A,Y1,X3) ) ) ) ).

tff(fact_4_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X3: A] :
          ( ~ ord_less(A,X3,Y1)
        <=> ( ord_less(A,Y1,X3)
            | ( X3 = Y1 ) ) ) ) ).

tff(fact_5_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X4: A] :
          ( ord_less(A,X4,Y2)
          | ( X4 = Y2 )
          | ord_less(A,Y2,X4) ) ) ).

tff(fact_6_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X3: A,Y1: A] :
          ( ~ ord_less(A,Y1,X3)
         => ( ~ ord_less(A,X3,Y1)
          <=> ( X3 = Y1 ) ) ) ) ).

tff(fact_7_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X4: A] :
          ( ( X4 != Y2 )
         => ( ~ ord_less(A,X4,Y2)
           => ord_less(A,Y2,X4) ) ) ) ).

tff(fact_8_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y2: A,X4: A] :
          ( ( X4 != Y2 )
         => ( ~ ord_less(A,X4,Y2)
           => ord_less(A,Y2,X4) ) ) ) ).

tff(fact_9_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X4: A] :
          ( ord_less(A,X4,Y2)
         => ( X4 != Y2 ) ) ) ).

tff(fact_10_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X4: A] :
          ( ord_less(A,X4,Y2)
         => ~ ord_less(A,Y2,X4) ) ) ).

tff(fact_11_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X4: A] :
          ( ord_less(A,X4,Y2)
         => ~ ord_less(A,Y2,X4) ) ) ).

tff(fact_12_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X4: A] :
          ( ord_less(A,X4,Y2)
         => ( X4 != Y2 ) ) ) ).

tff(fact_13_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X4: A] :
          ( ord_less(A,X4,Y2)
         => ( Y2 != X4 ) ) ) ).

tff(fact_14_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X4: A] :
          ( ~ ord_less(A,X4,Y2)
         => ( ( X4 != Y2 )
           => ord_less(A,Y2,X4) ) ) ) ).

tff(fact_15_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X4: A] :
          ( ord_less(A,X4,Y2)
         => ~ ord_less(A,Y2,X4) ) ) ).

tff(fact_16_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z2: A,Y2: A,X4: A] :
          ( ord_less(A,X4,Y2)
         => ( ord_less(A,Y2,Z2)
           => ord_less(A,X4,Z2) ) ) ) ).

tff(fact_17_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A3: A] :
          ( ord_less(A,A3,B2)
         => ( ( B2 = C2 )
           => ord_less(A,A3,C2) ) ) ) ).

tff(fact_18_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A3: A] :
          ( ( A3 = B2 )
         => ( ord_less(A,B2,C2)
           => ord_less(A,A3,C2) ) ) ) ).

tff(fact_19_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B2: A,A3: A] :
          ( ord_less(A,A3,B2)
         => ~ ord_less(A,B2,A3) ) ) ).

tff(fact_20_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Pa: bool,Y1: A,X3: A] :
          ( ord_less(A,X3,Y1)
         => ( ord_less(A,Y1,X3)
           => pp(Pa) ) ) ) ).

tff(fact_21_order__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,B1: B,F1: fun(B,A),A1: A] :
          ( ord_less(A,A1,aa(B,A,F1,B1))
         => ( ord_less(B,B1,C1)
           => ( ! [X2: B,Y: B] :
                  ( ord_less(B,X2,Y)
                 => ord_less(A,aa(B,A,F1,X2),aa(B,A,F1,Y)) )
             => ord_less(A,A1,aa(B,A,F1,C1)) ) ) ) ) ).

tff(fact_22_ord__eq__less__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C1: B,B1: B,F1: fun(B,A),A1: A] :
          ( ( A1 = aa(B,A,F1,B1) )
         => ( ord_less(B,B1,C1)
           => ( ! [X2: B,Y: B] :
                  ( ord_less(B,X2,Y)
                 => ord_less(A,aa(B,A,F1,X2),aa(B,A,F1,Y)) )
             => ord_less(A,A1,aa(B,A,F1,C1)) ) ) ) ) ).

tff(fact_23_order__less__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,F1: fun(A,B),B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ( ord_less(B,aa(A,B,F1,B1),C1)
           => ( ! [X2: A,Y: A] :
                  ( ord_less(A,X2,Y)
                 => ord_less(B,aa(A,B,F1,X2),aa(A,B,F1,Y)) )
             => ord_less(B,aa(A,B,F1,A1),C1) ) ) ) ) ).

tff(fact_24_ord__less__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C1: B,F1: fun(A,B),B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ( ( aa(A,B,F1,B1) = C1 )
           => ( ! [X2: A,Y: A] :
                  ( ord_less(A,X2,Y)
                 => ord_less(B,aa(A,B,F1,X2),aa(A,B,F1,Y)) )
             => ord_less(B,aa(A,B,F1,A1),C1) ) ) ) ) ).

tff(fact_25_dense,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [Y2: A,X4: A] :
          ( ord_less(A,X4,Y2)
         => ? [Z: A] :
              ( ord_less(A,X4,Z)
              & ord_less(A,Z,Y2) ) ) ) ).

tff(fact_26_lt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X4: A] :
        ? [Y: A] : ord_less(A,Y,X4) ) ).

tff(fact_27_gt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X3: A] :
        ? [X11: A] : ord_less(A,X3,X11) ) ).

tff(fact_28_strict__monoD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( order(A)
        & order(B) )
     => ! [Y1: A,X3: A,F1: fun(A,B)] :
          ( order_strict_mono(A,B,F1)
         => ( ord_less(A,X3,Y1)
           => ord_less(B,aa(A,B,F1,X3),aa(A,B,F1,Y1)) ) ) ) ).

tff(fact_29_strict__mono__less,axiom,
    ! [B: $tType,A: $tType] :
      ( ( linorder(A)
        & order(B) )
     => ! [Y1: A,X3: A,F1: fun(A,B)] :
          ( order_strict_mono(A,B,F1)
         => ( ord_less(B,aa(A,B,F1,X3),aa(A,B,F1,Y1))
          <=> ord_less(A,X3,Y1) ) ) ) ).

tff(fact_30_strict__mono__eq,axiom,
    ! [B: $tType,A: $tType] :
      ( ( linorder(A)
        & order(B) )
     => ! [Y1: A,X3: A,F1: fun(A,B)] :
          ( order_strict_mono(A,B,F1)
         => ( ( aa(A,B,F1,X3) = aa(A,B,F1,Y1) )
          <=> ( X3 = Y1 ) ) ) ) ).

tff(fact_31_strict__monoI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( order(A)
        & order(B) )
     => ! [F1: fun(A,B)] :
          ( ! [X2: A,Y: A] :
              ( ord_less(A,X2,Y)
             => ord_less(B,aa(A,B,F1,X2),aa(A,B,F1,Y)) )
         => order_strict_mono(A,B,F1) ) ) ).

tff(fact_32_strict__mono__mono,axiom,
    ! [B: $tType,A: $tType] :
      ( ( order(A)
        & order(B) )
     => ! [F1: fun(A,B)] :
          ( order_strict_mono(A,B,F1)
         => order_mono(A,B,F1) ) ) ).

tff(fact_33_less__induct,axiom,
    ! [A: $tType] :
      ( wellorder(A)
     => ! [A1: A,Pa: fun(A,bool)] :
          ( ! [X2: A] :
              ( ! [Y3: A] :
                  ( ord_less(A,Y3,X2)
                 => pp(aa(A,bool,Pa,Y3)) )
             => pp(aa(A,bool,Pa,X2)) )
         => pp(aa(A,bool,Pa,A1)) ) ) ).

tff(fact_34_strict__mono__less__eq,axiom,
    ! [B: $tType,A: $tType] :
      ( ( linorder(A)
        & order(B) )
     => ! [Y1: A,X3: A,F1: fun(A,B)] :
          ( order_strict_mono(A,B,F1)
         => ( ord_less_eq(B,aa(A,B,F1,X3),aa(A,B,F1,Y1))
          <=> ord_less_eq(A,X3,Y1) ) ) ) ).

tff(fact_35_posreal__complete,axiom,
    ! [Pa: fun(real,bool)] :
      ( ? [X1: real] : member(real,X1,Pa)
     => ( ? [Y3: real] :
          ! [X2: real] :
            ( member(real,X2,Pa)
           => ord_less(real,X2,Y3) )
       => ? [S1: real] :
          ! [Y3: real] :
            ( ? [X: real] :
                ( member(real,X,Pa)
                & ord_less(real,Y3,X) )
          <=> ord_less(real,Y3,S1) ) ) ) ).

tff(fact_36_linordered__field__no__lb,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [X1: A] :
        ? [Y: A] : ord_less(A,Y,X1) ) ).

tff(fact_37_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X4: A] : ord_less_eq(A,X4,X4) ) ).

tff(fact_38_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X4: A] :
          ( ~ ord_less_eq(A,X4,Y2)
         => ord_less_eq(A,Y2,X4) ) ) ).

tff(fact_39_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X3: A,G: fun(A,B),F1: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F1,G)
         => ord_less_eq(B,aa(A,B,F1,X3),aa(A,B,G,X3)) ) ) ).

tff(fact_40_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z2: A,Y2: A,X4: A] :
          ( ord_less_eq(A,X4,Y2)
         => ( ord_less_eq(A,Y2,Z2)
           => ord_less_eq(A,X4,Z2) ) ) ) ).

tff(fact_41_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X4: A] :
          ( ord_less_eq(A,X4,Y2)
         => ( ord_less_eq(A,Y2,X4)
           => ( X4 = Y2 ) ) ) ) ).

tff(fact_42_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A3: A] :
          ( ord_less_eq(A,A3,B2)
         => ( ( B2 = C2 )
           => ord_less_eq(A,A3,C2) ) ) ) ).

tff(fact_43_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A3: A] :
          ( ( A3 = B2 )
         => ( ord_less_eq(A,B2,C2)
           => ord_less_eq(A,A3,C2) ) ) ) ).

tff(fact_44_order__antisym__conv,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [X3: A,Y1: A] :
          ( ord_less_eq(A,Y1,X3)
         => ( ord_less_eq(A,X3,Y1)
          <=> ( X3 = Y1 ) ) ) ) ).

tff(fact_45_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X3: A,G: fun(A,B),F1: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F1,G)
         => ord_less_eq(B,aa(A,B,F1,X3),aa(A,B,G,X3)) ) ) ).

tff(fact_46_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X4: A] :
          ( ( X4 = Y2 )
         => ord_less_eq(A,X4,Y2) ) ) ).

tff(fact_47_monoD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( order(A)
        & order(B) )
     => ! [Y1: A,X3: A,F1: fun(A,B)] :
          ( order_mono(A,B,F1)
         => ( ord_less_eq(A,X3,Y1)
           => ord_less_eq(B,aa(A,B,F1,X3),aa(A,B,F1,Y1)) ) ) ) ).

tff(fact_48_order__eq__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X3: A] :
          ( ( X3 = Y1 )
        <=> ( ord_less_eq(A,X3,Y1)
            & ord_less_eq(A,Y1,X3) ) ) ) ).

tff(fact_49_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X4: A] :
          ( ord_less_eq(A,X4,Y2)
          | ord_less_eq(A,Y2,X4) ) ) ).

tff(fact_50_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F1: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F1,G)
        <=> ! [X: A] : ord_less_eq(B,aa(A,B,F1,X),aa(A,B,G,X)) ) ) ).

tff(fact_51_order__le__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z2: A,Y2: A,X4: A] :
          ( ord_less_eq(A,X4,Y2)
         => ( ord_less(A,Y2,Z2)
           => ord_less(A,X4,Z2) ) ) ) ).

tff(fact_52_order__less__le__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z2: A,Y2: A,X4: A] :
          ( ord_less(A,X4,Y2)
         => ( ord_less_eq(A,Y2,Z2)
           => ord_less(A,X4,Z2) ) ) ) ).

tff(fact_53_order__le__neq__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B2: A,A3: A] :
          ( ord_less_eq(A,A3,B2)
         => ( ( A3 != B2 )
           => ord_less(A,A3,B2) ) ) ) ).

tff(fact_54_order__le__imp__less__or__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X4: A] :
          ( ord_less_eq(A,X4,Y2)
         => ( ord_less(A,X4,Y2)
            | ( X4 = Y2 ) ) ) ) ).

tff(fact_55_linorder__antisym__conv2,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X3: A] :
          ( ord_less_eq(A,X3,Y1)
         => ( ~ ord_less(A,X3,Y1)
          <=> ( X3 = Y1 ) ) ) ) ).

tff(fact_56_order__less__imp__le,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X4: A] :
          ( ord_less(A,X4,Y2)
         => ord_less_eq(A,X4,Y2) ) ) ).

tff(fact_57_leD,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X4: A,Y2: A] :
          ( ord_less_eq(A,Y2,X4)
         => ~ ord_less(A,X4,Y2) ) ) ).

tff(fact_58_order__neq__le__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B2: A,A3: A] :
          ( ( A3 != B2 )
         => ( ord_less_eq(A,A3,B2)
           => ord_less(A,A3,B2) ) ) ) ).

tff(fact_59_linorder__antisym__conv1,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X3: A] :
          ( ~ ord_less(A,X3,Y1)
         => ( ord_less_eq(A,X3,Y1)
          <=> ( X3 = Y1 ) ) ) ) ).

tff(fact_60_not__leE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X4: A,Y2: A] :
          ( ~ ord_less_eq(A,Y2,X4)
         => ord_less(A,X4,Y2) ) ) ).

tff(fact_61_leI,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X4: A] :
          ( ~ ord_less(A,X4,Y2)
         => ord_less_eq(A,Y2,X4) ) ) ).

tff(fact_62_order__le__less,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X3: A] :
          ( ord_less_eq(A,X3,Y1)
        <=> ( ord_less(A,X3,Y1)
            | ( X3 = Y1 ) ) ) ) ).

tff(fact_63_less__le__not__le,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X3: A] :
          ( ord_less(A,X3,Y1)
        <=> ( ord_less_eq(A,X3,Y1)
            & ~ ord_less_eq(A,Y1,X3) ) ) ) ).

tff(fact_64_order__less__le,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X3: A] :
          ( ord_less(A,X3,Y1)
        <=> ( ord_less_eq(A,X3,Y1)
            & ( X3 != Y1 ) ) ) ) ).

tff(fact_65_linorder__le__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X4: A] :
          ( ord_less_eq(A,X4,Y2)
          | ord_less(A,Y2,X4) ) ) ).

tff(fact_66_linorder__not__le,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X3: A] :
          ( ~ ord_less_eq(A,X3,Y1)
        <=> ord_less(A,Y1,X3) ) ) ).

tff(fact_67_linorder__not__less,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X3: A] :
          ( ~ ord_less(A,X3,Y1)
        <=> ord_less_eq(A,Y1,X3) ) ) ).

tff(fact_68_monoI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( order(A)
        & order(B) )
     => ! [F1: fun(A,B)] :
          ( ! [X2: A,Y: A] :
              ( ord_less_eq(A,X2,Y)
             => ord_less_eq(B,aa(A,B,F1,X2),aa(A,B,F1,Y)) )
         => order_mono(A,B,F1) ) ) ).

tff(fact_69_dense__le,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [Z2: A,Y2: A] :
          ( ! [X2: A] :
              ( ord_less(A,X2,Y2)
             => ord_less_eq(A,X2,Z2) )
         => ord_less_eq(A,Y2,Z2) ) ) ).

tff(fact_70_dense__le__bounded,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [Z2: A,Y2: A,X4: A] :
          ( ord_less(A,X4,Y2)
         => ( ! [W: A] :
                ( ord_less(A,X4,W)
               => ( ord_less(A,W,Y2)
                 => ord_less_eq(A,W,Z2) ) )
           => ord_less_eq(A,Y2,Z2) ) ) ) ).

tff(fact_71_order__less__le__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,F1: fun(A,B),B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ( ord_less_eq(B,aa(A,B,F1,B1),C1)
           => ( ! [X2: A,Y: A] :
                  ( ord_less(A,X2,Y)
                 => ord_less(B,aa(A,B,F1,X2),aa(A,B,F1,Y)) )
             => ord_less(B,aa(A,B,F1,A1),C1) ) ) ) ) ).

tff(fact_72_order__le__less__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,F1: fun(A,B),B1: A,A1: A] :
          ( ord_less_eq(A,A1,B1)
         => ( ord_less(B,aa(A,B,F1,B1),C1)
           => ( ! [X2: A,Y: A] :
                  ( ord_less_eq(A,X2,Y)
                 => ord_less_eq(B,aa(A,B,F1,X2),aa(A,B,F1,Y)) )
             => ord_less(B,aa(A,B,F1,A1),C1) ) ) ) ) ).

tff(fact_73_less__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F1: fun(A,B)] :
          ( ord_less(fun(A,B),F1,G)
        <=> ( ord_less_eq(fun(A,B),F1,G)
            & ~ ord_less_eq(fun(A,B),G,F1) ) ) ) ).

tff(fact_74_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F1: fun(A,B)] :
          ( ! [X2: A] : ord_less_eq(B,aa(A,B,F1,X2),aa(A,B,G,X2))
         => ord_less_eq(fun(A,B),F1,G) ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),X3: A] :
      ( member(A,X3,A2)
    <=> pp(aa(A,bool,A2,X3)) ) ).

tff(fact_76_order__le__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,B1: B,F1: fun(B,A),A1: A] :
          ( ord_less_eq(A,A1,aa(B,A,F1,B1))
         => ( ord_less(B,B1,C1)
           => ( ! [X2: B,Y: B] :
                  ( ord_less(B,X2,Y)
                 => ord_less(A,aa(B,A,F1,X2),aa(B,A,F1,Y)) )
             => ord_less(A,A1,aa(B,A,F1,C1)) ) ) ) ) ).

tff(fact_77_order__less__le__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,B1: B,F1: fun(B,A),A1: A] :
          ( ord_less(A,A1,aa(B,A,F1,B1))
         => ( ord_less_eq(B,B1,C1)
           => ( ! [X2: B,Y: B] :
                  ( ord_less_eq(B,X2,Y)
                 => ord_less_eq(A,aa(B,A,F1,X2),aa(B,A,F1,Y)) )
             => ord_less(A,A1,aa(B,A,F1,C1)) ) ) ) ) ).

tff(fact_78_linordered__field__no__ub,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [X1: A] :
        ? [X11: A] : ord_less(A,X1,X11) ) ).

tff(fact_79_ord__le__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C1: B,F1: fun(A,B),B1: A,A1: A] :
          ( ord_less_eq(A,A1,B1)
         => ( ( aa(A,B,F1,B1) = C1 )
           => ( ! [X2: A,Y: A] :
                  ( ord_less_eq(A,X2,Y)
                 => ord_less_eq(B,aa(A,B,F1,X2),aa(A,B,F1,Y)) )
             => ord_less_eq(B,aa(A,B,F1,A1),C1) ) ) ) ) ).

tff(fact_80_order__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,F1: fun(A,B),B1: A,A1: A] :
          ( ord_less_eq(A,A1,B1)
         => ( ord_less_eq(B,aa(A,B,F1,B1),C1)
           => ( ! [X2: A,Y: A] :
                  ( ord_less_eq(A,X2,Y)
                 => ord_less_eq(B,aa(A,B,F1,X2),aa(A,B,F1,Y)) )
             => ord_less_eq(B,aa(A,B,F1,A1),C1) ) ) ) ) ).

tff(fact_81_order__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,B1: B,F1: fun(B,A),A1: A] :
          ( ord_less_eq(A,A1,aa(B,A,F1,B1))
         => ( ord_less_eq(B,B1,C1)
           => ( ! [X2: B,Y: B] :
                  ( ord_less_eq(B,X2,Y)
                 => ord_less_eq(A,aa(B,A,F1,X2),aa(B,A,F1,Y)) )
             => ord_less_eq(A,A1,aa(B,A,F1,C1)) ) ) ) ) ).

tff(fact_82_ord__eq__le__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C1: B,B1: B,F1: fun(B,A),A1: A] :
          ( ( A1 = aa(B,A,F1,B1) )
         => ( ord_less_eq(B,B1,C1)
           => ( ! [X2: B,Y: B] :
                  ( ord_less_eq(B,X2,Y)
                 => ord_less_eq(A,aa(B,A,F1,X2),aa(B,A,F1,Y)) )
             => ord_less_eq(A,A1,aa(B,A,F1,C1)) ) ) ) ) ).

tff(fact_83_less__eq__real__def,axiom,
    ! [Y1: real,X3: real] :
      ( ord_less_eq(real,X3,Y1)
    <=> ( ord_less(real,X3,Y1)
        | ( X3 = Y1 ) ) ) ).

tff(fact_84_pinf_I6_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z: A] :
        ! [X1: A] :
          ( ord_less(A,Z,X1)
         => ~ ord_less_eq(A,X1,T) ) ) ).

tff(fact_85_minf_I8_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z: A] :
        ! [X1: A] :
          ( ord_less(A,X1,Z)
         => ~ ord_less_eq(A,T,X1) ) ) ).

tff(fact_86_pinf_I8_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z: A] :
        ! [X1: A] :
          ( ord_less(A,Z,X1)
         => ord_less_eq(A,T,X1) ) ) ).

tff(fact_87_minf_I6_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z: A] :
        ! [X1: A] :
          ( ord_less(A,X1,Z)
         => ord_less_eq(A,X1,T) ) ) ).

tff(fact_88_minf_I11_J,axiom,
    ! [C: $tType,D: $tType] :
      ( ord(C)
     => ! [F: D] :
        ? [Z: C] :
        ! [X1: C] :
          ( ord_less(C,X1,Z)
         => ( F = F ) ) ) ).

tff(fact_89_pinf_I2_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Q1: fun(A,bool),Q: fun(A,bool),P: fun(A,bool),Pa: fun(A,bool)] :
          ( ? [Z1: A] :
            ! [X2: A] :
              ( ord_less(A,Z1,X2)
             => ( pp(aa(A,bool,Pa,X2))
              <=> pp(aa(A,bool,P,X2)) ) )
         => ( ? [Z1: A] :
              ! [X2: A] :
                ( ord_less(A,Z1,X2)
               => ( pp(aa(A,bool,Q,X2))
                <=> pp(aa(A,bool,Q1,X2)) ) )
           => ? [Z: A] :
              ! [X1: A] :
                ( ord_less(A,Z,X1)
               => ( ( pp(aa(A,bool,Pa,X1))
                    | pp(aa(A,bool,Q,X1)) )
                <=> ( pp(aa(A,bool,P,X1))
                    | pp(aa(A,bool,Q1,X1)) ) ) ) ) ) ) ).

tff(fact_90_pinf_I1_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Q1: fun(A,bool),Q: fun(A,bool),P: fun(A,bool),Pa: fun(A,bool)] :
          ( ? [Z1: A] :
            ! [X2: A] :
              ( ord_less(A,Z1,X2)
             => ( pp(aa(A,bool,Pa,X2))
              <=> pp(aa(A,bool,P,X2)) ) )
         => ( ? [Z1: A] :
              ! [X2: A] :
                ( ord_less(A,Z1,X2)
               => ( pp(aa(A,bool,Q,X2))
                <=> pp(aa(A,bool,Q1,X2)) ) )
           => ? [Z: A] :
              ! [X1: A] :
                ( ord_less(A,Z,X1)
               => ( ( pp(aa(A,bool,Pa,X1))
                    & pp(aa(A,bool,Q,X1)) )
                <=> ( pp(aa(A,bool,P,X1))
                    & pp(aa(A,bool,Q1,X1)) ) ) ) ) ) ) ).

tff(fact_91_pinf_I11_J,axiom,
    ! [C: $tType,D: $tType] :
      ( ord(C)
     => ! [F: D] :
        ? [Z: C] :
        ! [X1: C] :
          ( ord_less(C,Z,X1)
         => ( F = F ) ) ) ).

tff(fact_92_minf_I4_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z: A] :
        ! [X1: A] :
          ( ord_less(A,X1,Z)
         => ( X1 != T ) ) ) ).

tff(fact_93_minf_I2_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Q1: fun(A,bool),Q: fun(A,bool),P: fun(A,bool),Pa: fun(A,bool)] :
          ( ? [Z1: A] :
            ! [X2: A] :
              ( ord_less(A,X2,Z1)
             => ( pp(aa(A,bool,Pa,X2))
              <=> pp(aa(A,bool,P,X2)) ) )
         => ( ? [Z1: A] :
              ! [X2: A] :
                ( ord_less(A,X2,Z1)
               => ( pp(aa(A,bool,Q,X2))
                <=> pp(aa(A,bool,Q1,X2)) ) )
           => ? [Z: A] :
              ! [X1: A] :
                ( ord_less(A,X1,Z)
               => ( ( pp(aa(A,bool,Pa,X1))
                    | pp(aa(A,bool,Q,X1)) )
                <=> ( pp(aa(A,bool,P,X1))
                    | pp(aa(A,bool,Q1,X1)) ) ) ) ) ) ) ).

tff(fact_94_minf_I1_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Q1: fun(A,bool),Q: fun(A,bool),P: fun(A,bool),Pa: fun(A,bool)] :
          ( ? [Z1: A] :
            ! [X2: A] :
              ( ord_less(A,X2,Z1)
             => ( pp(aa(A,bool,Pa,X2))
              <=> pp(aa(A,bool,P,X2)) ) )
         => ( ? [Z1: A] :
              ! [X2: A] :
                ( ord_less(A,X2,Z1)
               => ( pp(aa(A,bool,Q,X2))
                <=> pp(aa(A,bool,Q1,X2)) ) )
           => ? [Z: A] :
              ! [X1: A] :
                ( ord_less(A,X1,Z)
               => ( ( pp(aa(A,bool,Pa,X1))
                    & pp(aa(A,bool,Q,X1)) )
                <=> ( pp(aa(A,bool,P,X1))
                    & pp(aa(A,bool,Q1,X1)) ) ) ) ) ) ) ).

tff(fact_95_pinf_I4_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z: A] :
        ! [X1: A] :
          ( ord_less(A,Z,X1)
         => ( X1 != T ) ) ) ).

tff(fact_96_minf_I7_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z: A] :
        ! [X1: A] :
          ( ord_less(A,X1,Z)
         => ~ ord_less(A,T,X1) ) ) ).

tff(fact_97_pinf_I5_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z: A] :
        ! [X1: A] :
          ( ord_less(A,Z,X1)
         => ~ ord_less(A,X1,T) ) ) ).

tff(fact_98_pinf_I3_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z: A] :
        ! [X1: A] :
          ( ord_less(A,Z,X1)
         => ( X1 != T ) ) ) ).

tff(fact_99_pinf_I7_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z: A] :
        ! [X1: A] :
          ( ord_less(A,Z,X1)
         => ord_less(A,T,X1) ) ) ).

%----Arities (14)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

tff(arity_RealDef_Oreal___Orderings_Odense__linorder,axiom,
    dense_linorder(real) ).

tff(arity_RealDef_Oreal___Fields_Olinordered__field,axiom,
    linordered_field(real) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__idom,axiom,
    linordered_idom(real) ).

tff(arity_RealDef_Oreal___Orderings_Opreorder,axiom,
    preorder(real) ).

tff(arity_RealDef_Oreal___Orderings_Olinorder,axiom,
    linorder(real) ).

tff(arity_RealDef_Oreal___Orderings_Oorder,axiom,
    order(real) ).

tff(arity_RealDef_Oreal___Orderings_Oord,axiom,
    ord(real) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ? [S: real] :
    ! [Y: real] :
      ( ? [X: real] :
          ( p(X)
          & ord_less(real,Y,X) )
    <=> ord_less(real,Y,S) ) ).

%------------------------------------------------------------------------------
