%------------------------------------------------------------------------------
% File     : SWW488_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fundamental Theorem of Algebra line 112
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fta_112 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v7.4.0, 0.50 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  191 (  30 unt;  47 typ;   0 def)
%            Number of atoms       :  313 (  98 equ)
%            Maximal formula atoms :    5 (   1 avg)
%            Number of connectives :  187 (  18   ~;   2   |;   5   &)
%                                         (  28 <=>; 134  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   4 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   27 (  15   >;  12   *;   0   +;   0  <<)
%            Number of predicates  :   26 (  25 usr;   0 prp; 1-3 aty)
%            Number of functors    :   19 (  19 usr;   4 con; 0-5 aty)
%            Number of variables   :  329 ( 290   !;   0   ?; 329   :)
%                                         (  39  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:19
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Polynomial_Opoly,type,
    poly1: $tType > $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (42)
tff(sy_cl_Rings_Ocomm__ring__1,type,
    comm_ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__comm__monoid__add,type,
    cancel1352612707id_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oidom,type,
    idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__0,type,
    comm_semiring_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__comm__monoid__add,type,
    ordere216010020id_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__cancel__ab__semigroup__add,type,
    ordere223160158up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_Fundamental__Theorem__Algebra__Mirabelle__jmqnahvvas_Ooffset__poly,type,
    fundam296178794t_poly: 
      !>[A: $tType] : ( ( poly1(A) * A ) > poly1(A) ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_Oring__1__class_OInts,type,
    ring_1_Ints: 
      !>[A: $tType] : fun(A,bool) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Polynomial_Ocoeff,type,
    coeff: 
      !>[A: $tType] : ( poly1(A) > fun(nat,A) ) ).

tff(sy_c_Polynomial_Omonom,type,
    monom: 
      !>[A: $tType] : ( ( A * nat ) > poly1(A) ) ).

tff(sy_c_Polynomial_Oorder,type,
    order: 
      !>[A: $tType] : ( ( A * poly1(A) ) > nat ) ).

tff(sy_c_Polynomial_Opcompose,type,
    pcompose: 
      !>[A: $tType] : ( ( poly1(A) * poly1(A) ) > poly1(A) ) ).

tff(sy_c_Polynomial_Opoly,type,
    poly: 
      !>[A: $tType] : ( poly1(A) > fun(A,A) ) ).

tff(sy_c_Polynomial_Opoly__rec,type,
    poly_rec: 
      !>[B1: $tType,A: $tType] : ( ( B1 * fun(A,fun(poly1(A),fun(B1,B1))) * poly1(A) ) > B1 ) ).

tff(sy_c_Polynomial_Osynthetic__div,type,
    synthetic_div: 
      !>[A: $tType] : ( ( poly1(A) * A ) > poly1(A) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,B1) * A ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_h,type,
    h: a ).

tff(sy_v_x,type,
    x: a ).

%----Relevant facts (98)
tff(fact_0_offset__poly__0,axiom,
    ! [A: $tType] :
      ( comm_semiring_0(A)
     => ! [H: A] : ( fundam296178794t_poly(A,zero_zero(poly1(A)),H) = zero_zero(poly1(A)) ) ) ).

tff(fact_1_poly__0,axiom,
    ! [A: $tType] :
      ( comm_semiring_0(A)
     => ! [X: A] : ( aa(A,A,poly(A,zero_zero(poly1(A))),X) = zero_zero(A) ) ) ).

tff(fact_2_poly__add,axiom,
    ! [A: $tType] :
      ( comm_semiring_0(A)
     => ! [X: A,Q1: poly1(A),P: poly1(A)] : ( aa(A,A,poly(A,plus_plus(poly1(A),P,Q1)),X) = plus_plus(A,aa(A,A,poly(A,P),X),aa(A,A,poly(A,Q1),X)) ) ) ).

tff(fact_3_double__zero__sym,axiom,
    ! [B1: $tType] :
      ( linord219039673up_add(B1)
     => ! [A2: B1] :
          ( ( zero_zero(B1) = plus_plus(B1,A2,A2) )
        <=> ( A2 = zero_zero(B1) ) ) ) ).

tff(fact_4_double__eq__0__iff,axiom,
    ! [B1: $tType] :
      ( linord219039673up_add(B1)
     => ! [A2: B1] :
          ( ( plus_plus(B1,A2,A2) = zero_zero(B1) )
        <=> ( A2 = zero_zero(B1) ) ) ) ).

tff(fact_5_add__left__cancel,axiom,
    ! [B1: $tType] :
      ( cancel_semigroup_add(B1)
     => ! [C2: B1,B2: B1,A2: B1] :
          ( ( plus_plus(B1,A2,B2) = plus_plus(B1,A2,C2) )
        <=> ( B2 = C2 ) ) ) ).

tff(fact_6_add__right__cancel,axiom,
    ! [B1: $tType] :
      ( cancel_semigroup_add(B1)
     => ! [C2: B1,A2: B1,B2: B1] :
          ( ( plus_plus(B1,B2,A2) = plus_plus(B1,C2,A2) )
        <=> ( B2 = C2 ) ) ) ).

tff(fact_7_poly__zero,axiom,
    ! [B1: $tType] :
      ( ( ring_char_0(B1)
        & idom(B1) )
     => ! [Pa: poly1(B1)] :
          ( ( poly(B1,Pa) = poly(B1,zero_zero(poly1(B1))) )
        <=> ( Pa = zero_zero(poly1(B1)) ) ) ) ).

tff(fact_8_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_9_comm__semiring__1__class_Onormalizing__semiring__rules_I5_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_10_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_11_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_12_add__poly__code_I2_J,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [P: poly1(A)] : ( plus_plus(poly1(A),P,zero_zero(poly1(A))) = P ) ) ).

tff(fact_13_add__poly__code_I1_J,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [Q1: poly1(A)] : ( plus_plus(poly1(A),zero_zero(poly1(A)),Q1) = Q1 ) ) ).

tff(fact_14_zero__reorient,axiom,
    ! [B1: $tType] :
      ( zero(B1)
     => ! [Xa: B1] :
          ( ( zero_zero(B1) = Xa )
        <=> ( Xa = zero_zero(B1) ) ) ) ).

tff(fact_15_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A1: A,B: A] :
          ( ( plus_plus(A,B,A1) = plus_plus(A,C,A1) )
         => ( B = C ) ) ) ).

tff(fact_16_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C) )
         => ( B = C ) ) ) ).

tff(fact_17_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C) )
         => ( B = C ) ) ) ).

tff(fact_18_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),plus_plus(A,C,D)) = plus_plus(A,plus_plus(A,A1,C),plus_plus(A,B,D)) ) ) ).

tff(fact_19_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C) = plus_plus(A,plus_plus(A,A1,C),B) ) ) ).

tff(fact_20_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C) = plus_plus(A,A1,plus_plus(A,B,C)) ) ) ).

tff(fact_21_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C) = plus_plus(A,A1,plus_plus(A,B,C)) ) ) ).

tff(fact_22_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C: A,A1: A] : ( plus_plus(A,A1,plus_plus(A,C,D)) = plus_plus(A,plus_plus(A,A1,C),D) ) ) ).

tff(fact_23_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C: A,A1: A] : ( plus_plus(A,A1,plus_plus(A,C,D)) = plus_plus(A,C,plus_plus(A,A1,D)) ) ) ).

tff(fact_24_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,A1: A] : ( plus_plus(A,A1,C) = plus_plus(A,C,A1) ) ) ).

tff(fact_25_poly__eq__iff,axiom,
    ! [B1: $tType] :
      ( ( ring_char_0(B1)
        & idom(B1) )
     => ! [Q: poly1(B1),Pa: poly1(B1)] :
          ( ( poly(B1,Pa) = poly(B1,Q) )
        <=> ( Pa = Q ) ) ) ).

tff(fact_26_add__0__iff,axiom,
    ! [B1: $tType] :
      ( semiri456707255roduct(B1)
     => ! [A2: B1,B2: B1] :
          ( ( B2 = plus_plus(B1,B2,A2) )
        <=> ( A2 = zero_zero(B1) ) ) ) ).

tff(fact_27_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_28_comm__semiring__1__class_Onormalizing__semiring__rules_I6_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_29_order__root,axiom,
    ! [B1: $tType] :
      ( idom(B1)
     => ! [A2: B1,Pa: poly1(B1)] :
          ( ( aa(B1,B1,poly(B1,Pa),A2) = zero_zero(B1) )
        <=> ( ( Pa = zero_zero(poly1(B1)) )
            | ( order(B1,A2,Pa) != zero_zero(nat) ) ) ) ) ).

tff(fact_30_pcompose__0,axiom,
    ! [A: $tType] :
      ( comm_semiring_0(A)
     => ! [Q1: poly1(A)] : ( pcompose(A,zero_zero(poly1(A)),Q1) = zero_zero(poly1(A)) ) ) ).

tff(fact_31_poly__rec__0,axiom,
    ! [C1: $tType,B1: $tType] :
      ( zero(C1)
     => ! [Z1: B1,F: fun(C1,fun(poly1(C1),fun(B1,B1)))] :
          ( ( aa(B1,B1,aa(poly1(C1),fun(B1,B1),aa(C1,fun(poly1(C1),fun(B1,B1)),F,zero_zero(C1)),zero_zero(poly1(C1))),Z1) = Z1 )
         => ( poly_rec(B1,C1,Z1,F,zero_zero(poly1(C1))) = Z1 ) ) ) ).

tff(fact_32_monom__eq__0__iff,axiom,
    ! [B1: $tType] :
      ( zero(B1)
     => ! [N2: nat,A2: B1] :
          ( ( monom(B1,A2,N2) = zero_zero(poly1(B1)) )
        <=> ( A2 = zero_zero(B1) ) ) ) ).

tff(fact_33_monom__eq__0,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [N1: nat] : ( monom(A,zero_zero(A),N1) = zero_zero(poly1(A)) ) ) ).

tff(fact_34_synthetic__div__0,axiom,
    ! [A: $tType] :
      ( comm_semiring_0(A)
     => ! [C: A] : ( synthetic_div(A,zero_zero(poly1(A)),C) = zero_zero(poly1(A)) ) ) ).

tff(fact_35_poly__pcompose,axiom,
    ! [A: $tType] :
      ( comm_semiring_0(A)
     => ! [X: A,Q1: poly1(A),P: poly1(A)] : ( aa(A,A,poly(A,pcompose(A,P,Q1)),X) = aa(A,A,poly(A,P),aa(A,A,poly(A,Q1),X)) ) ) ).

tff(fact_36_add__monom,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [B: A,N1: nat,A1: A] : ( plus_plus(poly1(A),monom(A,A1,N1),monom(A,B,N1)) = monom(A,plus_plus(A,A1,B),N1) ) ) ).

tff(fact_37_Ints__double__eq__0__iff,axiom,
    ! [B1: $tType] :
      ( ring_char_0(B1)
     => ! [A2: B1] :
          ( member(B1,A2,ring_1_Ints(B1))
         => ( ( plus_plus(B1,A2,A2) = zero_zero(B1) )
          <=> ( A2 = zero_zero(B1) ) ) ) ) ).

tff(fact_38_monom__eq__iff,axiom,
    ! [B1: $tType] :
      ( zero(B1)
     => ! [B2: B1,N2: nat,A2: B1] :
          ( ( monom(B1,A2,N2) = monom(B1,B2,N2) )
        <=> ( A2 = B2 ) ) ) ).

tff(fact_39_Ints__0,axiom,
    ! [B1: $tType] :
      ( ring_1(B1)
     => member(B1,zero_zero(B1),ring_1_Ints(B1)) ) ).

tff(fact_40_Ints__add,axiom,
    ! [B1: $tType] :
      ( ring_1(B1)
     => ! [B2: B1,A2: B1] :
          ( member(B1,A2,ring_1_Ints(B1))
         => ( member(B1,B2,ring_1_Ints(B1))
           => member(B1,plus_plus(B1,A2,B2),ring_1_Ints(B1)) ) ) ) ).

tff(fact_41_add__is__0,axiom,
    ! [N2: nat,M1: nat] :
      ( ( plus_plus(nat,M1,N2) = zero_zero(nat) )
    <=> ( ( M1 = zero_zero(nat) )
        & ( N2 = zero_zero(nat) ) ) ) ).

tff(fact_42_plus__nat_Oadd__0,axiom,
    ! [N1: nat] : ( plus_plus(nat,zero_zero(nat),N1) = N1 ) ).

tff(fact_43_Nat_Oadd__0__right,axiom,
    ! [M: nat] : ( plus_plus(nat,M,zero_zero(nat)) = M ) ).

tff(fact_44_add__eq__self__zero,axiom,
    ! [N1: nat,M: nat] :
      ( ( plus_plus(nat,M,N1) = M )
     => ( N1 = zero_zero(nat) ) ) ).

tff(fact_45_Ints__odd__nonzero,axiom,
    ! [B1: $tType] :
      ( ring_char_0(B1)
     => ! [A2: B1] :
          ( member(B1,A2,ring_1_Ints(B1))
         => ( plus_plus(B1,plus_plus(B1,one_one(B1),A2),A2) != zero_zero(B1) ) ) ) ).

tff(fact_46_nat__add__right__cancel,axiom,
    ! [N2: nat,K1: nat,M1: nat] :
      ( ( plus_plus(nat,M1,K1) = plus_plus(nat,N2,K1) )
    <=> ( M1 = N2 ) ) ).

tff(fact_47_nat__add__left__cancel,axiom,
    ! [N2: nat,M1: nat,K1: nat] :
      ( ( plus_plus(nat,K1,M1) = plus_plus(nat,K1,N2) )
    <=> ( M1 = N2 ) ) ).

tff(fact_48_poly__1,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X: A] : ( aa(A,A,poly(A,one_one(poly1(A))),X) = one_one(A) ) ) ).

tff(fact_49_nat__add__assoc,axiom,
    ! [K: nat,N1: nat,M: nat] : ( plus_plus(nat,plus_plus(nat,M,N1),K) = plus_plus(nat,M,plus_plus(nat,N1,K)) ) ).

tff(fact_50_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X: nat] : ( plus_plus(nat,X,plus_plus(nat,Y,Z)) = plus_plus(nat,Y,plus_plus(nat,X,Z)) ) ).

tff(fact_51_nat__add__commute,axiom,
    ! [N1: nat,M: nat] : ( plus_plus(nat,M,N1) = plus_plus(nat,N1,M) ) ).

tff(fact_52_one__reorient,axiom,
    ! [B1: $tType] :
      ( one(B1)
     => ! [Xa: B1] :
          ( ( one_one(B1) = Xa )
        <=> ( Xa = one_one(B1) ) ) ) ).

tff(fact_53_Ints__1,axiom,
    ! [B1: $tType] :
      ( ring_1(B1)
     => member(B1,one_one(B1),ring_1_Ints(B1)) ) ).

tff(fact_54_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_55_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_56_Ints__odd__less__0,axiom,
    ! [B1: $tType] :
      ( linordered_idom(B1)
     => ! [A2: B1] :
          ( member(B1,A2,ring_1_Ints(B1))
         => ( ord_less(B1,plus_plus(B1,plus_plus(B1,one_one(B1),A2),A2),zero_zero(B1))
          <=> ord_less(B1,A2,zero_zero(B1)) ) ) ) ).

tff(fact_57_coeff__1,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [N1: nat] :
          ( ( ( N1 = zero_zero(nat) )
           => ( aa(nat,A,coeff(A,one_one(poly1(A))),N1) = one_one(A) ) )
          & ( ( N1 != zero_zero(nat) )
           => ( aa(nat,A,coeff(A,one_one(poly1(A))),N1) = zero_zero(A) ) ) ) ) ).

tff(fact_58_less__zeroE,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_59_less__nat__zero__code,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_60_neq0__conv,axiom,
    ! [N2: nat] :
      ( ( N2 != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N2) ) ).

tff(fact_61_nat__add__left__cancel__less,axiom,
    ! [N2: nat,M1: nat,K1: nat] :
      ( ord_less(nat,plus_plus(nat,K1,M1),plus_plus(nat,K1,N2))
    <=> ord_less(nat,M1,N2) ) ).

tff(fact_62_add__less__cancel__right,axiom,
    ! [B1: $tType] :
      ( ordere236663937imp_le(B1)
     => ! [B2: B1,C2: B1,A2: B1] :
          ( ord_less(B1,plus_plus(B1,A2,C2),plus_plus(B1,B2,C2))
        <=> ord_less(B1,A2,B2) ) ) ).

tff(fact_63_add__less__cancel__left,axiom,
    ! [B1: $tType] :
      ( ordere236663937imp_le(B1)
     => ! [B2: B1,A2: B1,C2: B1] :
          ( ord_less(B1,plus_plus(B1,C2,A2),plus_plus(B1,C2,B2))
        <=> ord_less(B1,A2,B2) ) ) ).

tff(fact_64_add__gr__0,axiom,
    ! [N2: nat,M1: nat] :
      ( ord_less(nat,zero_zero(nat),plus_plus(nat,M1,N2))
    <=> ( ord_less(nat,zero_zero(nat),M1)
        | ord_less(nat,zero_zero(nat),N2) ) ) ).

tff(fact_65_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [B1: $tType] :
      ( linord219039673up_add(B1)
     => ! [A2: B1] :
          ( ord_less(B1,zero_zero(B1),plus_plus(B1,A2,A2))
        <=> ord_less(B1,zero_zero(B1),A2) ) ) ).

tff(fact_66_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [B1: $tType] :
      ( linord219039673up_add(B1)
     => ! [A2: B1] :
          ( ord_less(B1,plus_plus(B1,A2,A2),zero_zero(B1))
        <=> ord_less(B1,A2,zero_zero(B1)) ) ) ).

tff(fact_67_coeff__0,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [N1: nat] : ( aa(nat,A,coeff(A,zero_zero(poly1(A))),N1) = zero_zero(A) ) ) ).

tff(fact_68_coeff__add,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [N1: nat,Q1: poly1(A),P: poly1(A)] : ( aa(nat,A,coeff(A,plus_plus(poly1(A),P,Q1)),N1) = plus_plus(A,aa(nat,A,coeff(A,P),N1),aa(nat,A,coeff(A,Q1),N1)) ) ) ).

tff(fact_69_coeff__monom,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [A1: A,N1: nat,M: nat] :
          ( ( ( M = N1 )
           => ( aa(nat,A,coeff(A,monom(A,A1,M)),N1) = A1 ) )
          & ( ( M != N1 )
           => ( aa(nat,A,coeff(A,monom(A,A1,M)),N1) = zero_zero(A) ) ) ) ) ).

tff(fact_70_not__one__less__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ ord_less(A,one_one(A),zero_zero(A)) ) ).

tff(fact_71_not__less0,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_72_zero__less__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less(A,zero_zero(A),one_one(A)) ) ).

tff(fact_73_ext,axiom,
    ! [C1: $tType,B1: $tType,G: fun(B1,C1),F: fun(B1,C1)] :
      ( ! [X1: B1] : ( aa(B1,C1,F,X1) = aa(B1,C1,G,X1) )
     => ( F = G ) ) ).

tff(fact_74_mem__def,axiom,
    ! [B1: $tType,A3: fun(B1,bool),Xa: B1] :
      ( member(B1,Xa,A3)
    <=> pp(aa(B1,bool,A3,Xa)) ) ).

tff(fact_75_gr__implies__not0,axiom,
    ! [N1: nat,M: nat] :
      ( ord_less(nat,M,N1)
     => ( N1 != zero_zero(nat) ) ) ).

tff(fact_76_gr0I,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_77_add__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,C)) ) ) ).

tff(fact_78_add__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,plus_plus(A,C,A1),plus_plus(A,C,B)) ) ) ).

tff(fact_79_add__strict__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [D: A,C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ( ord_less(A,C,D)
           => ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,D)) ) ) ) ).

tff(fact_80_add__less__imp__less__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,C: A,A1: A] :
          ( ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,C))
         => ord_less(A,A1,B) ) ) ).

tff(fact_81_add__less__imp__less__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,A1: A,C: A] :
          ( ord_less(A,plus_plus(A,C,A1),plus_plus(A,C,B))
         => ord_less(A,A1,B) ) ) ).

tff(fact_82_add__lessD1,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less(nat,plus_plus(nat,I,J),K)
     => ord_less(nat,I,K) ) ).

tff(fact_83_less__add__eq__less,axiom,
    ! [N1: nat,M: nat,L: nat,K: nat] :
      ( ord_less(nat,K,L)
     => ( ( plus_plus(nat,M,L) = plus_plus(nat,K,N1) )
       => ord_less(nat,M,N1) ) ) ).

tff(fact_84_add__less__mono,axiom,
    ! [L: nat,K: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ( ord_less(nat,K,L)
       => ord_less(nat,plus_plus(nat,I,K),plus_plus(nat,J,L)) ) ) ).

tff(fact_85_add__less__mono1,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,plus_plus(nat,I,K),plus_plus(nat,J,K)) ) ).

tff(fact_86_trans__less__add2,axiom,
    ! [M: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,I,plus_plus(nat,M,J)) ) ).

tff(fact_87_trans__less__add1,axiom,
    ! [M: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,I,plus_plus(nat,J,M)) ) ).

tff(fact_88_less__add__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [A1: A] : ord_less(A,A1,plus_plus(A,A1,one_one(A))) ) ).

tff(fact_89_not__add__less2,axiom,
    ! [I: nat,J: nat] : ~ ord_less(nat,plus_plus(nat,J,I),I) ).

tff(fact_90_not__add__less1,axiom,
    ! [J: nat,I: nat] : ~ ord_less(nat,plus_plus(nat,I,J),I) ).

tff(fact_91_pos__add__strict,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( ord_less(A,B,C)
           => ord_less(A,B,plus_plus(A,A1,C)) ) ) ) ).

tff(fact_92_expand__poly__eq,axiom,
    ! [B1: $tType] :
      ( zero(B1)
     => ! [Q: poly1(B1),Pa: poly1(B1)] :
          ( ( Pa = Q )
        <=> ! [N: nat] : ( aa(nat,B1,coeff(B1,Pa),N) = aa(nat,B1,coeff(B1,Q),N) ) ) ) ).

tff(fact_93_coeff__inject,axiom,
    ! [B1: $tType] :
      ( zero(B1)
     => ! [Y1: poly1(B1),Xa: poly1(B1)] :
          ( ( coeff(B1,Xa) = coeff(B1,Y1) )
        <=> ( Xa = Y1 ) ) ) ).

tff(fact_94_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ ord_less(A,X,Y)
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_95_zero__less__two,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less(A,zero_zero(A),plus_plus(A,one_one(A),one_one(A))) ) ).

tff(fact_96_even__less__0__iff,axiom,
    ! [B1: $tType] :
      ( linordered_idom(B1)
     => ! [A2: B1] :
          ( ord_less(B1,plus_plus(B1,A2,A2),zero_zero(B1))
        <=> ord_less(B1,A2,zero_zero(B1)) ) ) ).

tff(fact_97_add__pos__pos,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( ord_less(A,zero_zero(A),B)
           => ord_less(A,zero_zero(A),plus_plus(A,A1,B)) ) ) ) ).

%----Class relationships (4)
tff(clar_Rings_Ocomm__semiring__0__Groups_Oab__semigroup__add,axiom,
    ! [A: $tType] :
      ( comm_semiring_0(A)
     => ab_semigroup_add(A) ) ).

tff(clar_Rings_Ocomm__semiring__0__Groups_Ocomm__monoid__add,axiom,
    ! [A: $tType] :
      ( comm_semiring_0(A)
     => comm_monoid_add(A) ) ).

tff(clar_Rings_Ocomm__semiring__0__Groups_Omonoid__add,axiom,
    ! [A: $tType] :
      ( comm_semiring_0(A)
     => monoid_add(A) ) ).

tff(clar_Rings_Ocomm__semiring__0__Groups_Ozero,axiom,
    ! [A: $tType] :
      ( comm_semiring_0(A)
     => zero(A) ) ).

%----Arities (38)
tff(arity_Polynomial_Opoly___Groups_Ocancel__comm__monoid__add,axiom,
    ! [T_1: $tType] :
      ( cancel1352612707id_add(T_1)
     => cancel1352612707id_add(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Rings_Ocomm__ring__1,axiom,
    ! [T_1: $tType] :
      ( comm_ring_1(T_1)
     => comm_ring_1(poly1(T_1)) ) ).

tff(arity_Nat_Onat___Groups_Ocancel__comm__monoid__add,axiom,
    cancel1352612707id_add(nat) ).

tff(arity_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__0,axiom,
    comm_semiring_0(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_Polynomial_Opoly___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    ! [T_1: $tType] :
      ( idom(T_1)
     => semiri456707255roduct(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ! [T_1: $tType] :
      ( linordered_idom(T_1)
     => ordere223160158up_add(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ! [T_1: $tType] :
      ( linordered_idom(T_1)
     => ordere236663937imp_le(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Groups_Oordered__comm__monoid__add,axiom,
    ! [T_1: $tType] :
      ( linordered_idom(T_1)
     => ordere216010020id_add(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Groups_Olinordered__ab__group__add,axiom,
    ! [T_1: $tType] :
      ( linordered_idom(T_1)
     => linord219039673up_add(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Groups_Ocancel__ab__semigroup__add,axiom,
    ! [T_1: $tType] :
      ( cancel1352612707id_add(T_1)
     => cancel146912293up_add(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Groups_Ocancel__semigroup__add,axiom,
    ! [T_1: $tType] :
      ( cancel1352612707id_add(T_1)
     => cancel_semigroup_add(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Rings_Olinordered__semidom,axiom,
    ! [T_1: $tType] :
      ( linordered_idom(T_1)
     => linordered_semidom(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Groups_Oab__semigroup__add,axiom,
    ! [T_1: $tType] :
      ( comm_monoid_add(T_1)
     => ab_semigroup_add(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Groups_Ocomm__monoid__add,axiom,
    ! [T_1: $tType] :
      ( comm_monoid_add(T_1)
     => comm_monoid_add(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Rings_Olinordered__idom,axiom,
    ! [T_1: $tType] :
      ( linordered_idom(T_1)
     => linordered_idom(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Rings_Ocomm__semiring__1,axiom,
    ! [T_1: $tType] :
      ( comm_semiring_1(T_1)
     => comm_semiring_1(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Rings_Ocomm__semiring__0,axiom,
    ! [T_1: $tType] :
      ( comm_semiring_0(T_1)
     => comm_semiring_0(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Rings_Ozero__neq__one,axiom,
    ! [T_1: $tType] :
      ( comm_semiring_1(T_1)
     => zero_neq_one(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Groups_Omonoid__add,axiom,
    ! [T_1: $tType] :
      ( comm_monoid_add(T_1)
     => monoid_add(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Int_Oring__char__0,axiom,
    ! [T_1: $tType] :
      ( linordered_idom(T_1)
     => ring_char_0(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Rings_Oring__1,axiom,
    ! [T_1: $tType] :
      ( comm_ring_1(T_1)
     => ring_1(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Groups_Ozero,axiom,
    ! [T_1: $tType] :
      ( zero(T_1)
     => zero(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Rings_Oidom,axiom,
    ! [T_1: $tType] :
      ( idom(T_1)
     => idom(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Groups_Oone,axiom,
    ! [T_1: $tType] :
      ( comm_semiring_1(T_1)
     => one(poly1(T_1)) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    aa(a,a,poly(a,fundam296178794t_poly(a,zero_zero(poly1(a)),h)),x) = aa(a,a,poly(a,zero_zero(poly1(a))),plus_plus(a,h,x)) ).

%----Type variables (1)
tff(tfree_0,hypothesis,
    comm_semiring_0(a) ).

%------------------------------------------------------------------------------
